/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IField;
import com.openshift.client.Message;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.internal.client.GearProfile;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceProperties;
import com.openshift.internal.client.response.CartridgeResourceProperty;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.EnumDataType;
import com.openshift.internal.client.response.EnvironmentVariableResourceDTO;
import com.openshift.internal.client.response.GearGroupResourceDTO;
import com.openshift.internal.client.response.GearResourceDTO;
import com.openshift.internal.client.response.IRestResponseFactory;
import com.openshift.internal.client.response.KeyResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.LinkParameter;
import com.openshift.internal.client.response.RestResponse;
import com.openshift.internal.client.response.UserResourceDTO;
import com.openshift.internal.client.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftJsonDTOFactory
implements IRestResponseFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(OpenShiftJsonDTOFactory.class);

    @Override
    public RestResponse get(String json) throws OpenShiftException {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        this.LOGGER.trace("Unmarshalling response\n{}", (Object)json);
        ModelNode rootNode = this.getModelNode(json);
        String type = rootNode.get("type").asString();
        String status = rootNode.get("status").asString();
        Messages messages = this.createMessages(rootNode.get("messages"));
        EnumDataType dataType = EnumDataType.safeValueOf(type);
        if (dataType == null) {
            return new RestResponse(status, messages, null, null);
        }
        Object data = this.createData(dataType, messages, rootNode);
        return new RestResponse(status, messages, data, dataType);
    }

    private Object createData(EnumDataType dataType, Messages messages, ModelNode rootNode) {
        switch (dataType) {
            case user: {
                return this.createUser(rootNode);
            }
            case keys: {
                return this.createKeys(rootNode);
            }
            case key: {
                return this.createKey(rootNode, messages);
            }
            case links: {
                return this.createLinks(rootNode);
            }
            case domains: {
                return this.createDomains(rootNode);
            }
            case domain: {
                return this.createDomain(rootNode, messages);
            }
            case applications: {
                return this.createApplications(rootNode);
            }
            case application: {
                return this.createApplication(rootNode, messages);
            }
            case gear_groups: {
                return this.createGearGroups(rootNode);
            }
            case cartridges: {
                return this.createCartridges(rootNode.get("data"));
            }
            case cartridge: {
                return this.createCartridge(rootNode, messages);
            }
            case environment_variables: {
                return this.createEnvironmentVariables(rootNode);
            }
            case environment_variable: {
                return this.createEnvironmentVariable(rootNode, messages);
            }
        }
        return null;
    }

    private Messages createMessages(ModelNode messagesNode) {
        LinkedHashMap<IField, List<Message>> messagesByField = new LinkedHashMap<IField, List<Message>>();
        if (messagesNode.getType() == ModelType.LIST) {
            for (ModelNode messageNode : messagesNode.asList()) {
                Message message = this.createMessage(messageNode);
                ArrayList<Message> messages = (ArrayList<Message>)messagesByField.get(message.getField());
                if (messages == null) {
                    messages = new ArrayList<Message>();
                }
                messages.add(message);
                messagesByField.put(message.getField(), messages);
            }
        }
        return new Messages(messagesByField);
    }

    private Message createMessage(ModelNode messageNode) {
        String text = this.getString(messageNode.get("text"));
        String field = this.getString(messageNode.get("field"));
        int exitCode = this.getInt(messageNode.get("exit_code"));
        String severity = this.getString(messageNode.get("severity"));
        return new Message(text, field, severity, exitCode);
    }

    private int getInt(ModelNode messageNode) {
        if (messageNode == null || !messageNode.isDefined()) {
            return -1;
        }
        return messageNode.asInt();
    }

    private String getString(ModelNode node) {
        if (node == null || !node.isDefined()) {
            return null;
        }
        return node.asString();
    }

    private ModelNode getModelNode(String content) throws OpenShiftException {
        if (content == null) {
            throw new OpenShiftException("Could not unmarshall response: no content.", new Object[0]);
        }
        ModelNode node = ModelNode.fromJSONString(content);
        if (!node.isDefined()) {
            throw new OpenShiftException("Could not unmarshall response: erroneous content.", new Object[0]);
        }
        return node;
    }

    private UserResourceDTO createUser(ModelNode userNode) throws OpenShiftException {
        if (userNode.has("data")) {
            return this.createUser(userNode.get("data"));
        }
        String rhlogin = this.getAsString(userNode, "login");
        int maxGears = this.getAsInteger(userNode, "max_gears");
        int consumedGears = this.getAsInteger(userNode, "consumed_gears");
        Map<String, Link> links = this.createLinks(userNode.get("links"));
        return new UserResourceDTO(rhlogin, maxGears, consumedGears, links);
    }

    private List<KeyResourceDTO> createKeys(ModelNode rootNode) throws OpenShiftException {
        ArrayList<KeyResourceDTO> keys = new ArrayList<KeyResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode dataNode : rootNode.get("data").asList()) {
                if (dataNode.getType() != ModelType.OBJECT) continue;
                keys.add(this.createKey(dataNode, null));
            }
        }
        return keys;
    }

    private KeyResourceDTO createKey(ModelNode keyNode, Messages messages) throws OpenShiftException {
        if (keyNode.has("data")) {
            return this.createKey(keyNode.get("data"), messages);
        }
        String name = this.getAsString(keyNode, "name");
        String type = this.getAsString(keyNode, "type");
        String content = this.getAsString(keyNode, "content");
        Map<String, Link> links = this.createLinks(keyNode.get("links"));
        return new KeyResourceDTO(name, type, content, links, messages);
    }

    private Map<String, Link> createLinks(ModelNode linksNode) throws OpenShiftException {
        if (linksNode.has("data")) {
            return this.createLinks(linksNode.get("data"));
        }
        HashMap<String, Link> links = new HashMap<String, Link>();
        if (linksNode.isDefined()) {
            for (ModelNode linkNode : linksNode.asList()) {
                String linkName = linkNode.asProperty().getName();
                ModelNode valueNode = linkNode.asProperty().getValue();
                if (!valueNode.isDefined()) continue;
                links.put(linkName, this.createLink(valueNode));
            }
        }
        return links;
    }

    private Link createLink(ModelNode valueNode) {
        String rel = this.getAsString(valueNode, "rel");
        String href = valueNode.get("href").asString();
        String method = valueNode.get("method").asString();
        List<LinkParameter> requiredParams = this.createLinkParameters(valueNode.get("required_params"));
        List<LinkParameter> optionalParams = this.createLinkParameters(valueNode.get("optional_params"));
        return new Link(rel, href, method, requiredParams, optionalParams);
    }

    private List<DomainResourceDTO> createDomains(ModelNode rootNode) throws OpenShiftException {
        ArrayList<DomainResourceDTO> domains = new ArrayList<DomainResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode dataNode : rootNode.get("data").asList()) {
                if (dataNode.getType() == ModelType.OBJECT) {
                    domains.add(this.createDomain(dataNode, null));
                    continue;
                }
                throw new OpenShiftException("Unexpected node type: {0}", new Object[]{dataNode.getType()});
            }
        } else {
            ModelNode domainNode = rootNode.get("domain");
            if (domainNode.isDefined() && domainNode.getType() == ModelType.OBJECT) {
                domains.add(this.createDomain(domainNode, null));
            } else {
                throw new OpenShiftException("Unexpected node type: {0}", new Object[]{domainNode.getType()});
            }
        }
        return domains;
    }

    private DomainResourceDTO createDomain(ModelNode domainNode, Messages messages) throws OpenShiftException {
        if (domainNode.has("data")) {
            return this.createDomain(domainNode.get("data"), messages);
        }
        String namespace = this.getAsString(domainNode, "id");
        String suffix = this.getAsString(domainNode, "suffix");
        Map<String, Link> links = this.createLinks(domainNode.get("links"));
        return new DomainResourceDTO(namespace, suffix, links, messages);
    }

    private List<ApplicationResourceDTO> createApplications(ModelNode rootNode) throws OpenShiftException {
        ArrayList<ApplicationResourceDTO> applicationDTOs = new ArrayList<ApplicationResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode applicationNode : rootNode.get("data").asList()) {
                applicationDTOs.add(this.createApplication(applicationNode, null));
            }
        }
        return applicationDTOs;
    }

    private ApplicationResourceDTO createApplication(ModelNode appNode, Messages messages) throws OpenShiftException {
        if (appNode.has("data")) {
            return this.createApplication(appNode.get("data"), messages);
        }
        String framework = this.getAsString(appNode, "framework");
        String creationTime = this.getAsString(appNode, "creation_time");
        String name = this.getAsString(appNode, "name");
        String uuid = this.getAsString(appNode, "uuid");
        ApplicationScale scalable = ApplicationScale.safeValueOf(this.getAsString(appNode, "scalable"));
        GearProfile gearProfile = this.createGearProfile(appNode);
        String applicationUrl = this.getAsString(appNode, "app_url");
        String sshUrl = this.getAsString(appNode, "ssh_url");
        String gitUrl = this.getAsString(appNode, "git_url");
        String initialGitUrl = this.getAsString(appNode, "initial_git_url");
        String domainId = this.getAsString(appNode, "domain_id");
        Map<String, Link> links = this.createLinks(appNode.get("links"));
        List<String> aliases = this.createAliases(appNode.get("aliases"));
        Map<String, CartridgeResourceDTO> cartridges = this.createCartridges(appNode.get("cartridges"));
        return new ApplicationResourceDTO(framework, domainId, creationTime, name, gearProfile, scalable, uuid, applicationUrl, sshUrl, gitUrl, initialGitUrl, aliases, cartridges, links, messages);
    }

    private GearProfile createGearProfile(ModelNode appNode) {
        String gearProfileName = this.getAsString(appNode, "gear_profile");
        if (gearProfileName == null) {
            return null;
        }
        return new GearProfile(gearProfileName);
    }

    private Collection<GearGroupResourceDTO> createGearGroups(ModelNode dataNode) {
        ArrayList<GearGroupResourceDTO> gearGroupDTOs = new ArrayList<GearGroupResourceDTO>();
        for (ModelNode gearGroupNode : dataNode.get("data").asList()) {
            gearGroupDTOs.add(this.createGearGroupResourceDTO(gearGroupNode));
        }
        return gearGroupDTOs;
    }

    private GearGroupResourceDTO createGearGroupResourceDTO(ModelNode gearGroupNode) {
        String uuid = this.getAsString(gearGroupNode, "uuid");
        String name = this.getAsString(gearGroupNode, "name");
        Collection<GearResourceDTO> gears = this.createGears(gearGroupNode.get("gears"));
        Map<String, CartridgeResourceDTO> cartridges = this.createCartridges(gearGroupNode.get("cartridges"));
        return new GearGroupResourceDTO(uuid, name, gears, cartridges);
    }

    private Collection<GearResourceDTO> createGears(ModelNode gearsNode) {
        ArrayList<GearResourceDTO> gears = new ArrayList<GearResourceDTO>();
        for (ModelNode gearNode : gearsNode.asList()) {
            gears.add(new GearResourceDTO(this.getAsString(gearNode, "id"), this.getAsString(gearNode, "state"), this.getAsString(gearNode, "ssh_url")));
        }
        return gears;
    }

    private Map<String, CartridgeResourceDTO> createCartridges(ModelNode cartridgesNode) throws OpenShiftException {
        LinkedHashMap<String, CartridgeResourceDTO> cartridgesByName = new LinkedHashMap<String, CartridgeResourceDTO>();
        if (cartridgesNode.isDefined() && cartridgesNode.getType() == ModelType.LIST) {
            for (ModelNode cartridgeNode : cartridgesNode.asList()) {
                CartridgeResourceDTO cartridgeResourceDTO = this.createCartridge(cartridgeNode, null);
                cartridgesByName.put(cartridgeResourceDTO.getName(), cartridgeResourceDTO);
            }
        }
        return cartridgesByName;
    }

    private CartridgeResourceDTO createCartridge(ModelNode cartridgeNode, Messages messages) throws OpenShiftException {
        if (cartridgeNode.has("data")) {
            return this.createCartridge(cartridgeNode.get("data"), messages);
        }
        String name = this.getAsString(cartridgeNode, "name");
        String displayName = this.getAsString(cartridgeNode, "display_name");
        String description = this.getAsString(cartridgeNode, "description");
        String type = this.getAsString(cartridgeNode, "type");
        URL url = this.createUrl(this.getAsString(cartridgeNode, "url"), name);
        CartridgeResourceProperties properties = this.createProperties(cartridgeNode.get("properties"));
        Map<String, Link> links = this.createLinks(cartridgeNode.get("links"));
        return new CartridgeResourceDTO(name, displayName, description, type, url, properties, links, messages);
    }

    private URL createUrl(String url, String name) {
        try {
            if (url == null) {
                return null;
            }
            return new URL(url);
        }
        catch (MalformedURLException e) {
            this.LOGGER.warn("Url {} in server response for cartridge {} is not a valid URL.", (Object)url, (Object)name);
            return null;
        }
    }

    private List<String> createAliases(ModelNode aliasNodesList) {
        ArrayList<String> aliases = new ArrayList<String>();
        switch (aliasNodesList.getType()) {
            case OBJECT: 
            case LIST: {
                for (ModelNode aliasNode : aliasNodesList.asList()) {
                    aliases.add(aliasNode.asString());
                }
                break;
            }
            default: {
                aliases.add(aliasNodesList.asString());
            }
        }
        return aliases;
    }

    private List<LinkParameter> createLinkParameters(ModelNode linkParamNodes) throws OpenShiftRequestException {
        ArrayList<LinkParameter> linkParams = new ArrayList<LinkParameter>();
        if (linkParamNodes.isDefined()) {
            for (ModelNode linkParamNode : linkParamNodes.asList()) {
                linkParams.add(this.createLinkParameter(linkParamNode));
            }
        }
        return linkParams;
    }

    private LinkParameter createLinkParameter(ModelNode linkParamNode) throws OpenShiftRequestException {
        String description = linkParamNode.get("description").asString();
        String type = linkParamNode.get("type").asString();
        String defaultValue = linkParamNode.get("default_value").asString();
        String name = linkParamNode.get("name").asString();
        return new LinkParameter(name, type, defaultValue, description, this.createValidOptions(linkParamNode));
    }

    private List<String> createValidOptions(ModelNode linkParamNode) {
        ArrayList<String> validOptions = new ArrayList<String>();
        ModelNode validOptionsNode = linkParamNode.get("valid_options");
        if (validOptionsNode.isDefined()) {
            switch (validOptionsNode.getType()) {
                case STRING: {
                    validOptions.add(validOptionsNode.asString());
                    break;
                }
                case LIST: {
                    for (ModelNode validOptionNode : validOptionsNode.asList()) {
                        validOptions.add(validOptionNode.asString());
                    }
                    break;
                }
            }
        }
        return validOptions;
    }

    private String getAsString(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asString() : null;
    }

    private CartridgeResourceProperties createProperties(ModelNode propertiesNode) {
        if (propertiesNode == null || !propertiesNode.isDefined()) {
            return null;
        }
        CartridgeResourceProperties properties = new CartridgeResourceProperties();
        for (ModelNode propertyNode : propertiesNode.asList()) {
            CartridgeResourceProperty property = this.createProperty(propertyNode);
            String name = property.getName();
            if (StringUtils.isEmpty(name)) continue;
            properties.add(name, property);
        }
        return properties;
    }

    private CartridgeResourceProperty createProperty(ModelNode propertyNode) {
        String name = this.getAsString(propertyNode, "name");
        String description = this.getAsString(propertyNode, "description");
        String type = this.getAsString(propertyNode, "type");
        String value = this.getAsString(propertyNode, "value");
        return new CartridgeResourceProperty(name, type, description, value);
    }

    private Boolean getAsBoolean(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asBoolean() : Boolean.FALSE.booleanValue();
    }

    private int getAsInteger(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asInt() : 0;
    }

    private List<EnvironmentVariableResourceDTO> createEnvironmentVariables(ModelNode rootNode) throws OpenShiftException {
        ArrayList<EnvironmentVariableResourceDTO> environmentVariables = new ArrayList<EnvironmentVariableResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode environmentVariableNode : rootNode.get("data").asList()) {
                environmentVariables.add(this.createEnvironmentVariable(environmentVariableNode, null));
            }
        }
        return environmentVariables;
    }

    private EnvironmentVariableResourceDTO createEnvironmentVariable(ModelNode environmentVariableNode, Messages messages) throws OpenShiftException {
        if (environmentVariableNode.has("data")) {
            return this.createEnvironmentVariable(environmentVariableNode.get("data"), messages);
        }
        String name = this.getAsString(environmentVariableNode, "name");
        String value = this.getAsString(environmentVariableNode, "value");
        Map<String, Link> links = this.createLinks(environmentVariableNode.get("links"));
        return new EnvironmentVariableResourceDTO(name, value, links, messages);
    }
}

