/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-change-parents", scope="fabric", description="Replace the profile's parents with the specified list of parents")
public class ProfileChangeParentsAction
extends AbstractAction {
    @Option(name="--version", description="The profile version. Defaults to the current default version.")
    private String versionId;
    @Argument(index=0, required=true, name="profile", description="Name of the profile.")
    private String profileId;
    @Argument(index=1, name="parents", description="The list of new parent profiles.", required=true, multiValued=true)
    private List<String> parentIds;
    private final ProfileService profileService;
    private final FabricService fabricService;

    ProfileChangeParentsAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        Version version = this.versionId != null ? this.profileService.getRequiredVersion(this.versionId) : this.fabricService.getRequiredDefaultVersion();
        Profile profile = version.getRequiredProfile(this.profileId);
        Profile[] parents = FabricCommand.getExistingProfiles((FabricService)this.fabricService, (Version)version, this.parentIds);
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        for (Profile parent : parents) {
            builder.addParent(parent.getId());
        }
        this.profileService.updateProfile(builder.getProfile());
        return null;
    }
}

