/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.commands;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IUser;
import com.openshift.client.cartridge.StandaloneCartridge;
import com.openshift.internal.client.GearProfile;
import io.fabric8.openshift.commands.OpenshiftCommandSupport;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="application-create", scope="openshift", description="Creates an application")
public class ApplicationCreateAction
extends OpenshiftCommandSupport {
    @Option(name="--domain", required=false, description="Create applications on that domain.")
    String domainId;
    @Option(name="--gear-profile", description="Gear profile controls how much memory and CPU your cartridges can use.")
    private String gearProfile = "small";
    @Option(name="--scaling", description="Enable scaling for the web cartridge.")
    private boolean scaling = false;
    @Argument(index=0, name="application", required=true, description="The target application.")
    String applicationName;
    @Argument(index=1, name="cartridge", required=true, multiValued=false, description="The cartridge to use.")
    String cartridge;

    protected Object doExecute() throws Exception {
        IDomain domain;
        IOpenShiftConnection connection = this.getOrCreateConnection();
        IUser user = connection.getUser();
        IDomain iDomain = domain = this.domainId != null ? user.getDomain(this.domainId) : user.getDefaultDomain();
        if (this.domainId != null && domain == null) {
            domain = user.createDomain(this.domainId);
        }
        ApplicationScale scale = ApplicationScale.NO_SCALE;
        if (this.scaling) {
            scale = ApplicationScale.SCALE;
        }
        IApplication application = domain.createApplication(this.applicationName, new StandaloneCartridge(this.cartridge), scale, new GearProfile(this.gearProfile));
        System.out.println(application.getCreationLog());
        return null;
    }
}

