/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.proxy.impl;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.common.util.Files;
import io.fabric8.deployer.ProjectDeployer;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.DeployResults;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.MavenResolver;
import io.fabric8.maven.proxy.MavenProxy;
import io.fabric8.maven.proxy.impl.InvalidMavenArtifactRequest;
import io.fabric8.maven.proxy.impl.UploadContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import org.apache.felix.utils.version.VersionTable;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProxyServletSupport
extends HttpServlet
implements MavenProxy {
    public static Logger LOGGER = LoggerFactory.getLogger(MavenProxyServletSupport.class);
    private static final String SNAPSHOT_TIMESTAMP_REGEX = "^([0-9]{8}.[0-9]{6}-[0-9]+).*";
    private static final Pattern SNAPSHOT_TIMESTAMP_PATTENR = Pattern.compile("^([0-9]{8}.[0-9]{6}-[0-9]+).*");
    public static final Pattern ARTIFACT_REQUEST_URL_REGEX = Pattern.compile("([^ ]+)/([^/ ]+)/([^/ ]+)/([^/ ]+)");
    public static final Pattern ARTIFACT_METADATA_URL_REGEX = Pattern.compile("([^ ]+)/([^/ ]+)/([^/ ]+)/((maven-metadata([-]([^ .]+))?.xml))([.]([^ ]+))?");
    public static final Pattern REPOSITORY_ID_REGEX = Pattern.compile("[^ ]*(@id=([^@ ]+))+[^ ]*");
    public static final String DEFAULT_REPO_ID = "default";
    protected static final String LOCATION_HEADER = "X-Location";
    protected List<RemoteRepository> repositories;
    protected RepositorySystem system;
    protected RepositorySystemSession session;
    protected File tmpFolder = new File(System.getProperty("karaf.data") + File.separator + "maven" + File.separator + "proxy" + File.separator + "tmp");
    final File uploadRepository;
    final RuntimeProperties runtimeProperties;
    final ProjectDeployer projectDeployer;
    final MavenResolver resolver;
    private Comparator<String> VERSION_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String v1, String v2) {
            return VersionTable.getVersion(v1).compareTo(VersionTable.getVersion(v2));
        }
    };
    private Comparator<SnapshotVersion> SNAPSHOT_VERSION_COMPARATOR = new Comparator<SnapshotVersion>(){

        @Override
        public int compare(SnapshotVersion o1, SnapshotVersion o2) {
            int c = MavenProxyServletSupport.this.VERSION_COMPARATOR.compare(o1.getVersion(), o2.getVersion());
            if (c == 0) {
                c = o1.getExtension().compareTo(o2.getExtension());
            }
            if (c == 0) {
                c = o1.getClassifier().compareTo(o2.getClassifier());
            }
            return c;
        }
    };

    public MavenProxyServletSupport(MavenResolver resolver, RuntimeProperties runtimeProperties, ProjectDeployer projectDeployer, File uploadRepository) {
        this.resolver = resolver;
        this.runtimeProperties = runtimeProperties;
        this.projectDeployer = projectDeployer;
        this.uploadRepository = uploadRepository;
    }

    @Override
    public synchronized void start() throws IOException {
        if (!this.tmpFolder.exists() && !this.tmpFolder.mkdirs()) {
            throw new IOException("Failed to create temporary artifact folder");
        }
        if (this.system == null) {
            this.system = this.resolver.getRepositorySystem();
        }
        if (this.session == null) {
            this.session = this.resolver.createSession();
        }
        if (this.repositories == null) {
            this.repositories = this.resolver.getRepositories();
        }
    }

    @Override
    public synchronized void stop() {
    }

    @Override
    public File download(String path) throws InvalidMavenArtifactRequest {
        if (path == null) {
            throw new InvalidMavenArtifactRequest();
        }
        Matcher artifactMatcher = ARTIFACT_REQUEST_URL_REGEX.matcher(path);
        Matcher metdataMatcher = ARTIFACT_METADATA_URL_REGEX.matcher(path);
        if (metdataMatcher.matches()) {
            LOGGER.info("Received request for maven metadata : {}", (Object)path);
            Metadata metadata = null;
            try {
                metadata = this.convertPathToMetadata(path);
                if (!"maven-metadata.xml".equals(metadata.getType()) || metdataMatcher.group(7) != null) {
                    return null;
                }
                ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
                for (RemoteRepository repository : this.repositories) {
                    MetadataRequest request = new MetadataRequest(metadata, repository, null);
                    request.setFavorLocalRepository(false);
                    requests.add(request);
                }
                MetadataRequest request = new MetadataRequest(metadata, null, null);
                request.setFavorLocalRepository(true);
                requests.add(request);
                org.apache.maven.artifact.repository.metadata.Metadata mr = new org.apache.maven.artifact.repository.metadata.Metadata();
                mr.setModelVersion("1.1.0");
                mr.setGroupId(metadata.getGroupId());
                mr.setArtifactId(metadata.getArtifactId());
                mr.setVersioning(new Versioning());
                boolean merged = false;
                List results = this.system.resolveMetadata(this.session, requests);
                for (MetadataResult result : results) {
                    if (result.getMetadata() == null || result.getMetadata().getFile() == null) continue;
                    FileInputStream fis = new FileInputStream(result.getMetadata().getFile());
                    org.apache.maven.artifact.repository.metadata.Metadata m = new MetadataXpp3Reader().read((InputStream)fis, false);
                    fis.close();
                    if (m.getVersioning() != null) {
                        mr.getVersioning().setLastUpdated(this.latestTimestamp(mr.getVersioning().getLastUpdated(), m.getVersioning().getLastUpdated()));
                        mr.getVersioning().setLatest(this.latestVersion(mr.getVersioning().getLatest(), m.getVersioning().getLatest()));
                        mr.getVersioning().setRelease(this.latestVersion(mr.getVersioning().getRelease(), m.getVersioning().getRelease()));
                        for (String v : m.getVersioning().getVersions()) {
                            if (mr.getVersioning().getVersions().contains(v)) continue;
                            mr.getVersioning().getVersions().add(v);
                        }
                        mr.getVersioning().getSnapshotVersions().addAll(m.getVersioning().getSnapshotVersions());
                    }
                    merged = true;
                }
                if (merged) {
                    Collections.sort(mr.getVersioning().getVersions(), this.VERSION_COMPARATOR);
                    Collections.sort(mr.getVersioning().getSnapshotVersions(), this.SNAPSHOT_VERSION_COMPARATOR);
                    File tmpFile = Files.createTempFile((Path)this.runtimeProperties.getDataPath());
                    FileOutputStream fos = new FileOutputStream(tmpFile);
                    new MetadataXpp3Writer().write((OutputStream)fos, mr);
                    fos.close();
                    return tmpFile;
                }
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Could not find metadata : %s due to %s", metadata, e.getMessage()), (Throwable)e);
                return null;
            }
            return null;
        }
        if (artifactMatcher.matches()) {
            LOGGER.info("Received request for maven artifact : {}", (Object)path);
            Artifact artifact = this.convertPathToArtifact(path);
            try {
                File download = this.resolver.resolveFile(artifact);
                File tmpFile = Files.createTempFile((Path)this.runtimeProperties.getDataPath());
                Files.copy((File)download, (File)tmpFile);
                return tmpFile;
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Could not find artifact : %s due to %s", artifact, e.getMessage()), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private String latestTimestamp(String t1, String t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.compareTo(t2) < 0 ? t2 : t1;
    }

    private String latestVersion(String v1, String v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return this.VERSION_COMPARATOR.compare(v1, v2) < 0 ? v2 : v1;
    }

    @Override
    public boolean upload(InputStream is, String path) throws InvalidMavenArtifactRequest {
        return this.doUpload(is, path).status();
    }

    protected UploadContext doUpload(InputStream is, String path) throws InvalidMavenArtifactRequest {
        File file;
        if (path == null) {
            throw new InvalidMavenArtifactRequest();
        }
        int p = path.lastIndexOf(47);
        String filename = path.substring(p + 1);
        String uuid = UUID.randomUUID().toString();
        File tmp = new File(this.tmpFolder, uuid);
        tmp.mkdir();
        try {
            file = this.readFile(is, tmp, filename);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        UploadContext result = new UploadContext(file);
        if (p <= 0) {
            try {
                String mvnCoordsPath = MavenProxyServletSupport.readMvnCoordsPath(file);
                if (mvnCoordsPath != null) {
                    return this.move(file, mvnCoordsPath);
                }
                result.addHeader(LOCATION_HEADER, file.getPath());
                return result;
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to deploy artifact : %s due to %s", filename, e.getMessage()), (Throwable)e);
                return UploadContext.ERROR;
            }
        }
        Matcher artifactMatcher = ARTIFACT_REQUEST_URL_REGEX.matcher(path);
        Matcher metadataMatcher = ARTIFACT_METADATA_URL_REGEX.matcher(path);
        if (metadataMatcher.matches()) {
            LOGGER.info("Received upload request for maven metadata : {}", (Object)path);
            try {
                File target = new File(this.uploadRepository, path);
                Files.copy((File)file, (File)target);
                LOGGER.info("Maven metadata installed");
            }
            catch (Exception e) {
                result = UploadContext.ERROR;
                LOGGER.warn(String.format("Failed to upload metadata: %s due to %s", path, e.getMessage()), (Throwable)e);
            }
        } else if (artifactMatcher.matches()) {
            LOGGER.info("Received upload request for maven artifact : {}", (Object)path);
            Artifact artifact = null;
            try {
                artifact = this.convertPathToArtifact(path);
                File target = new File(this.uploadRepository, path);
                Files.copy((File)file, (File)target);
                result.setGroupId(artifact.getGroupId());
                result.setArtifactId(artifact.getArtifactId());
                result.setVersion(artifact.getVersion());
                result.setType(artifact.getExtension());
                LOGGER.info("Artifact installed: {}", (Object)artifact.toString());
            }
            catch (Exception e) {
                result = UploadContext.ERROR;
                LOGGER.warn(String.format("Failed to upload artifact : %s due to %s", artifact, e.getMessage()), (Throwable)e);
            }
        }
        return result;
    }

    protected UploadContext move(String currentFile, String newPath) throws Exception {
        File file = new File(currentFile);
        if (!file.exists()) {
            throw new IllegalArgumentException("No such file: " + currentFile);
        }
        return this.move(file, newPath);
    }

    /*
     * Loose catch block
     */
    private UploadContext move(File file, String newPath) throws Exception {
        try {
            try (FileInputStream fis = new FileInputStream(file);){
                UploadContext uploadContext = this.doUpload(fis, newPath);
                return uploadContext;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readMvnCoordsPath(File file) throws Exception {
        try (JarFile jarFile = null;){
            jarFile = new JarFile(file);
            String previous = null;
            String match = null;
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/maven/") || !name.endsWith("pom.properties")) continue;
                if (previous != null) {
                    throw new IllegalStateException(String.format("Duplicate pom.properties found: %s != %s", name, previous));
                }
                previous = name;
                Properties props = new Properties();
                try (InputStream stream = jarFile.getInputStream(entry);){
                    props.load(stream);
                }
                String groupId = props.getProperty("groupId");
                String artifactId = props.getProperty("artifactId");
                String version = props.getProperty("version");
                String packaging = Files.getFileExtension((String)file.getPath());
                match = String.format("%s/%s/%s/%s-%s.%s", groupId, artifactId, version, artifactId, version, packaging != null ? packaging : "jar");
            }
            String string = match;
            return string;
        }
    }

    protected ProjectRequirements toProjectRequirements(UploadContext context) {
        ProjectRequirements requirements = new ProjectRequirements();
        requirements.setParentProfiles(Collections.emptyList());
        DependencyDTO rootDependency = new DependencyDTO();
        rootDependency.setGroupId(context.getGroupId());
        rootDependency.setArtifactId(context.getArtifactId());
        rootDependency.setVersion(context.getVersion());
        rootDependency.setType(context.getType());
        requirements.setRootDependency(rootDependency);
        return requirements;
    }

    protected DeployResults addToProfile(ProjectRequirements requirements) throws Exception {
        return this.projectDeployer.deployProject(requirements);
    }

    protected String convertToMavenUrl(String path) throws InvalidMavenArtifactRequest {
        String url = null;
        StringBuilder sb = new StringBuilder();
        if (path == null) {
            throw new InvalidMavenArtifactRequest("Cannot match request path to maven url, request path is empty.");
        }
        Matcher pathMatcher = ARTIFACT_REQUEST_URL_REGEX.matcher(path);
        if (pathMatcher.matches()) {
            String groupId = pathMatcher.group(1).replaceAll("/", ".");
            String artifactId = pathMatcher.group(2);
            String version = pathMatcher.group(3);
            String filename = pathMatcher.group(4);
            String extension = "jar";
            String classifier = "";
            String filePerfix = artifactId + "-" + version;
            String stripedFileName = null;
            if (version.endsWith("SNAPSHOT")) {
                String baseVersion = version.replaceAll("-SNAPSHOT", "");
                String timestampedFileName = filename.substring(artifactId.length() + baseVersion.length() + 2);
                Matcher ts = SNAPSHOT_TIMESTAMP_PATTENR.matcher(timestampedFileName);
                if (ts.matches()) {
                    version = baseVersion + "-" + ts.group(1);
                    filePerfix = artifactId + "-" + version;
                }
                stripedFileName = filename.replaceAll(SNAPSHOT_TIMESTAMP_REGEX, "SNAPSHOT");
                stripedFileName = stripedFileName.substring(filePerfix.length());
            } else {
                stripedFileName = filename.substring(filePerfix.length());
            }
            if (stripedFileName != null && stripedFileName.startsWith("-") && stripedFileName.contains(".")) {
                classifier = stripedFileName.substring(1, stripedFileName.indexOf(46));
            }
            extension = stripedFileName.substring(stripedFileName.indexOf(46) + 1);
            sb.append(groupId).append(":").append(artifactId).append(":").append(extension).append(":");
            if (classifier != null && !classifier.isEmpty()) {
                sb.append(classifier).append(":");
            }
            sb.append(version);
            url = sb.toString();
        }
        return url;
    }

    protected Artifact convertPathToArtifact(String path) throws InvalidMavenArtifactRequest {
        return new DefaultArtifact(this.convertToMavenUrl(path), null);
    }

    protected Metadata convertPathToMetadata(String path) throws InvalidMavenArtifactRequest {
        DefaultMetadata metadata = null;
        if (path == null) {
            throw new InvalidMavenArtifactRequest("Cannot match request path to maven url, request path is empty.");
        }
        Matcher pathMatcher = ARTIFACT_METADATA_URL_REGEX.matcher(path);
        if (pathMatcher.matches()) {
            String groupId = pathMatcher.group(1).replaceAll("/", ".");
            String artifactId = pathMatcher.group(2);
            String version = pathMatcher.group(3);
            String type = pathMatcher.group(9);
            type = type == null ? "maven-metadata.xml" : "maven-metadata.xml." + type;
            metadata = new DefaultMetadata(groupId, artifactId, version, type, Metadata.Nature.RELEASE_OR_SNAPSHOT);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File readFile(InputStream is, File tempLocation, String name) throws FileNotFoundException {
        File tmpFile = null;
        OutputStream fos = null;
        try {
            int length;
            tmpFile = new File(tempLocation, name);
            if (tmpFile.exists() && !tmpFile.delete()) {
                throw new IOException("Failed to delete file");
            }
            fos = new FileOutputStream(tmpFile);
            byte[] buffer = new byte[8192];
            while ((length = is.read(buffer)) != -1) {
                ((FileOutputStream)fos).write(buffer, 0, length);
            }
        }
        catch (Exception ex) {
        }
        finally {
            try {
                fos.flush();
            }
            catch (Exception ex) {}
            try {
                ((FileOutputStream)fos).close();
            }
            catch (Exception ex) {}
        }
        return tmpFile;
    }

    public ProjectDeployer getProjectDeployer() {
        return this.projectDeployer;
    }
}

