/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.proxy.impl;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class UploadContext {
    static final UploadContext ERROR = new UploadContext();
    private boolean status;
    private File file;
    private Map<String, String> headers;
    private String groupId;
    private String artifactId;
    private String version;
    private String type;

    private UploadContext() {
    }

    UploadContext(File file) {
        this.status = true;
        this.file = file;
    }

    public boolean status() {
        return this.status;
    }

    public File file() {
        return this.file;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public Map<String, String> headers() {
        return this.headers == null ? Collections.emptyMap() : this.headers;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toArtifact() {
        return String.format("%s:%s:%s:%s", this.groupId, this.artifactId, this.type, this.version);
    }
}

