/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.features;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.OptionsProvider;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.features.FeatureUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.features", label="Fabric8 Features Service", immediate=true, metatype=false)
@Service(value={FeaturesService.class})
@Properties(value={@Property(name="service.ranking", intValue={1})})
public final class FabricFeaturesServiceImpl
extends AbstractComponent
implements FeaturesService,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesService.class);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @GuardedBy(value="this")
    private final LoadingCache<String, Repository> repositories = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Repository>(){

        public Repository load(String uri) throws Exception {
            RepositoryImpl repository = new RepositoryImpl(new URI(uri));
            repository.load();
            return repository;
        }
    });
    @GuardedBy(value="this")
    private final Set<Repository> installedRepositories = new HashSet<Repository>();
    @GuardedBy(value="this")
    private final Set<Feature> installedFeatures = new HashSet<Feature>();

    @Activate
    void activate() {
        ((FabricService)this.fabricService.get()).trackConfiguration((Runnable)this);
        this.activateComponent();
        this.executor.submit(this);
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        ((FabricService)this.fabricService.get()).untrackConfiguration((Runnable)this);
    }

    @Override
    public synchronized void run() {
        this.assertValid();
        this.repositories.invalidateAll();
        this.installedRepositories.clear();
        this.installedRepositories.addAll(Arrays.asList(this.listInstalledRepositories()));
        this.installedFeatures.clear();
        this.installedFeatures.addAll(Arrays.asList(this.listInstalledFeatures()));
    }

    @Override
    public void validateRepository(URI uri) throws Exception {
        this.assertValid();
        FeatureValidationUtil.validate(uri);
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        this.unsupportedAddRepository(uri);
    }

    @Override
    public void addRepository(URI uri, boolean b) throws Exception {
        this.unsupportedAddRepository(uri);
    }

    private void unsupportedAddRepository(URI uri) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --repositories %s target-profile instead. See fabric:profile-edit --help for more information.", uri.toString()));
    }

    @Override
    public void removeRepository(URI uri) throws Exception {
        this.unsupportedRemoveRepository(uri);
    }

    @Override
    public void removeRepository(URI uri, boolean b) throws Exception {
        this.unsupportedRemoveRepository(uri);
    }

    private void unsupportedRemoveRepository(URI uri) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --delete --repositories %s target-profile instead. See fabric:profile-edit --help for more information.", uri.toString()));
    }

    @Override
    public void restoreRepository(URI uri) throws Exception {
    }

    @Override
    public Repository[] listRepositories() {
        this.assertValid();
        LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
        for (String uri : this.getAllProfilesOverlay().getRepositories()) {
            try {
                this.populateRepositories(uri, repos);
            }
            catch (Exception ex) {
                LOGGER.warn("Error while populating repositories from uri.", (Throwable)ex);
            }
        }
        return repos.toArray(new Repository[repos.size()]);
    }

    @Override
    public void installFeature(String s) throws Exception {
        this.unsupportedInstallFeature(s);
    }

    @Override
    public void installFeature(String s, EnumSet<FeaturesService.Option> options) throws Exception {
        this.unsupportedInstallFeature(s);
    }

    @Override
    public void installFeature(String s, String s2) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        this.unsupportedInstallFeature(featureName);
    }

    @Override
    public void installFeature(String s, String s2, EnumSet<FeaturesService.Option> options) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        this.unsupportedInstallFeature(featureName);
    }

    @Override
    public void installFeature(Feature feature, EnumSet<FeaturesService.Option> options) throws Exception {
        this.unsupportedInstallFeature(feature.getName());
    }

    @Override
    public void installFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (Feature feature : features) {
            sb.append("--feature ").append(feature.getName());
        }
        this.unsupportedInstallFeature(sb.toString());
    }

    private void unsupportedInstallFeature(String s) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --features %s target-profile instead. See fabric:profile-edit --help for more information.", s));
    }

    @Override
    public void uninstallFeature(String s) throws Exception {
        this.unsupportedUninstallFeature(s);
    }

    @Override
    public void uninstallFeature(String s, String s2) throws Exception {
        String featureName = s;
        if (s2 != null && s2.equals("0.0.0")) {
            featureName = s + "/" + s2;
        }
        this.unsupportedUninstallFeature(featureName);
    }

    @Override
    public void uninstallFeature(String s, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeature(s);
    }

    @Override
    public void uninstallFeature(String s, String s2, EnumSet<FeaturesService.Option> options) throws Exception {
        this.uninstallFeature(s, s2);
    }

    private void unsupportedUninstallFeature(String s) {
        throw new UnsupportedOperationException(String.format("The container is managed by fabric, please use fabric:profile-edit --delete --features %s target-profile instead. See fabric:profile-edit --help for more information.", s));
    }

    @Override
    public Feature[] listFeatures() throws Exception {
        Repository[] repositories;
        this.assertValid();
        HashSet<Feature> allfeatures = new HashSet<Feature>();
        for (Repository repository : repositories = this.listRepositories()) {
            try {
                for (Feature feature : repository.getFeatures()) {
                    if (allfeatures.contains(feature)) continue;
                    allfeatures.add(feature);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Could not load features from %s.", (Object)repository.getURI());
            }
        }
        return allfeatures.toArray(new Feature[allfeatures.size()]);
    }

    @Override
    public Feature[] listInstalledFeatures() {
        this.assertValid();
        HashSet<Feature> installed = new HashSet<Feature>();
        try {
            Map<String, Map<String, Feature>> allFeatures = this.getFeatures(this.installedRepositories);
            Profile overlayProfile = ((FabricService)this.fabricService.get()).getCurrentContainer().getOverlayProfile();
            Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)((FabricService)this.fabricService.get()), (Profile)overlayProfile);
            for (String featureName : effectiveProfile.getFeatures()) {
                try {
                    Feature f;
                    if (featureName.contains("/")) {
                        String[] parts = featureName.split("/");
                        String name = parts[0];
                        String version = parts[1];
                        f = allFeatures.get(name).get(version);
                    } else {
                        TreeMap versionMap = (TreeMap)allFeatures.get(featureName);
                        f = (Feature)versionMap.lastEntry().getValue();
                    }
                    this.addFeatures(f, installed);
                }
                catch (Exception ex) {
                    LOGGER.debug("Error while adding {} to the features list");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving features.", (Throwable)e);
        }
        return installed.toArray(new Feature[installed.size()]);
    }

    @Override
    public boolean isInstalled(Feature feature) {
        this.assertValid();
        return this.installedFeatures.contains(feature);
    }

    @Override
    public Feature getFeature(String name) throws Exception {
        Feature[] features;
        this.assertValid();
        for (Feature feature : features = this.listFeatures()) {
            if (!name.equals(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    @Override
    public Feature getFeature(String name, String version) throws Exception {
        Feature[] features;
        this.assertValid();
        for (Feature feature : features = this.listFeatures()) {
            if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) continue;
            return feature;
        }
        return null;
    }

    private Map<String, Map<String, Feature>> getFeatures(Iterable<Repository> repositories) throws Exception {
        HashMap<String, Map<String, Feature>> features = new HashMap<String, Map<String, Feature>>();
        for (Repository repo : repositories) {
            try {
                for (Feature f : repo.getFeatures()) {
                    if (features.get(f.getName()) == null) {
                        TreeMap<String, Feature> versionMap = new TreeMap<String, Feature>();
                        versionMap.put(f.getVersion(), f);
                        features.put(f.getName(), versionMap);
                        continue;
                    }
                    ((Map)features.get(f.getName())).put(f.getVersion(), f);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Could not load features from %s.", (Object)repo.getURI());
            }
        }
        return features;
    }

    private Repository[] listInstalledRepositories() {
        LinkedHashSet<String> repositoryUris = new LinkedHashSet<String>();
        LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
        Profile overlayProfile = ((FabricService)this.fabricService.get()).getCurrentContainer().getOverlayProfile();
        Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)((FabricService)this.fabricService.get()), (Profile)overlayProfile);
        if (effectiveProfile.getRepositories() != null) {
            for (String uri : effectiveProfile.getRepositories()) {
                repositoryUris.add(uri);
            }
        }
        for (String uri : repositoryUris) {
            try {
                this.populateRepositories(uri, repos);
            }
            catch (Exception ex) {
                LOGGER.warn("Error while populating repositories from uri.", (Throwable)ex);
            }
        }
        return repos.toArray(new Repository[repos.size()]);
    }

    private void populateRepositories(String uri, Set<Repository> repos) throws Exception {
        Repository repository = (Repository)this.repositories.get((Object)uri);
        if (repository != null && !repos.contains(repository)) {
            repos.add(repository);
            for (URI u : repository.getRepositories()) {
                this.populateRepositories(u.toString(), repos);
            }
        }
    }

    private void addFeatures(Feature feature, Set<Feature> features) {
        if (features.contains(feature)) {
            return;
        }
        features.add(feature);
        for (Feature dependency : feature.getDependencies()) {
            this.addFeatures(FeatureUtils.search(dependency.getName(), dependency.getVersion(), this.repositories.asMap().values()), features);
        }
    }

    private Profile getAllProfilesOverlay() {
        Container container = ((FabricService)this.fabricService.get()).getCurrentContainer();
        ProfileService profileService = (ProfileService)((FabricService)this.fabricService.get()).adapt(ProfileService.class);
        Version version = container.getVersion();
        Profile versionProfile = this.getVersionProfile(version);
        return Profiles.getEffectiveProfile((FabricService)((FabricService)this.fabricService.get()), (Profile)profileService.getOverlayProfile(versionProfile));
    }

    private Profile getVersionProfile(Version version) {
        String profileId = "#version-" + version.getId();
        ProfileBuilder builder = ProfileBuilder.Factory.create((String)profileId).version(version.getId());
        VersionProfileOptionsProvider optionsProvider = new VersionProfileOptionsProvider(version);
        return ((ProfileBuilder)builder.addOptions((OptionsProvider)optionsProvider)).getProfile();
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    static class VersionProfileOptionsProvider
    implements OptionsProvider<ProfileBuilder> {
        private final Version version;

        private VersionProfileOptionsProvider(Version version) {
            this.version = version;
        }

        public ProfileBuilder addOptions(ProfileBuilder builder) {
            return builder.addParents(this.version.getProfileIds());
        }
    }
}

