var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.log = Logger.get("activemq");
    ActiveMQ.jmxDomain = 'org.apache.activemq';
    function getSelectionQueuesFolder(workspace) {
        function findQueuesFolder(node) {
            if (node) {
                if (node.title === "Queues" || node.title === "Queue") {
                    return node;
                }
                var parent = node.parent;
                if (parent) {
                    return findQueuesFolder(parent);
                }
            }
            return null;
        }
        var selection = workspace.selection;
        if (selection) {
            return findQueuesFolder(selection);
        }
        return null;
    }
    ActiveMQ.getSelectionQueuesFolder = getSelectionQueuesFolder;
    function getSelectionTopicsFolder(workspace) {
        function findTopicsFolder(node) {
            var answer = null;
            if (node) {
                if (node.title === "Topics" || node.title === "Topic") {
                    answer = node;
                }
                if (answer === null) {
                    angular.forEach(node.children, function (child) {
                        if (child.title === "Topics" || child.title === "Topic") {
                            answer = child;
                        }
                    });
                }
            }
            return answer;
        }
        var selection = workspace.selection;
        if (selection) {
            return findTopicsFolder(selection);
        }
        return null;
    }
    ActiveMQ.getSelectionTopicsFolder = getSelectionTopicsFolder;
    function selectCurrentMessage(message, key, $scope) {
        $scope.gridOptions.selectAll(false);
        var idx = Core.pathGet(message, ["rowIndex"]);
        var jmsMessageID = Core.pathGet(message, ["entity", key]);
        $scope.rowIndex = idx;
        var selected = $scope.gridOptions.selectedItems;
        selected.splice(0, selected.length);
        if (idx >= 0 && idx < $scope.messages.length) {
            $scope.row = $scope.messages.find(function (msg) { return msg[key] === jmsMessageID; });
            if ($scope.row) {
                selected.push($scope.row);
            }
        }
        else {
            $scope.row = null;
        }
    }
    ActiveMQ.selectCurrentMessage = selectCurrentMessage;
    function decorate($scope) {
        $scope.selectRowIndex = function (idx) {
            $scope.rowIndex = idx;
            var selected = $scope.gridOptions.selectedItems;
            selected.splice(0, selected.length);
            if (idx >= 0 && idx < $scope.messages.length) {
                $scope.row = $scope.messages[idx];
                if ($scope.row) {
                    selected.push($scope.row);
                }
            }
            else {
                $scope.row = null;
            }
        };
        $scope.$watch("showMessageDetails", function () {
            if (!$scope.showMessageDetails) {
                $scope.row = null;
                $scope.gridOptions.selectedItems.splice(0, $scope.gridOptions.selectedItems.length);
            }
        });
    }
    ActiveMQ.decorate = decorate;
})(ActiveMQ || (ActiveMQ = {}));
var StringHelpers;
(function (StringHelpers) {
    var dateRegex = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:/i;
    function isDate(str) {
        if (!angular.isString(str)) {
            return false;
        }
        return dateRegex.test(str);
    }
    StringHelpers.isDate = isDate;
    function obfusicate(str) {
        if (!angular.isString(str)) {
            return null;
        }
        return str.chars().map(function (c) {
            return '*';
        }).join('');
    }
    StringHelpers.obfusicate = obfusicate;
    function toString(obj) {
        if (!obj) {
            return '{ null }';
        }
        var answer = [];
        angular.forEach(obj, function (value, key) {
            var val = value;
            if (('' + key).toLowerCase() === 'password') {
                val = StringHelpers.obfusicate(value);
            }
            else if (angular.isObject(val)) {
                val = toString(val);
            }
            answer.push(key + ': ' + val);
        });
        return '{ ' + answer.join(', ') + ' }';
    }
    StringHelpers.toString = toString;
})(StringHelpers || (StringHelpers = {}));
var Core;
(function (Core) {
    function createConnectToServerOptions(options) {
        var defaults = {
            scheme: 'http',
            host: null,
            port: null,
            path: null,
            useProxy: true,
            jolokiaUrl: null,
            userName: null,
            password: null,
            view: null,
            name: null
        };
        var opts = options || {};
        return angular.extend(defaults, opts);
    }
    Core.createConnectToServerOptions = createConnectToServerOptions;
    function createConnectOptions(options) {
        return createConnectToServerOptions(options);
    }
    Core.createConnectOptions = createConnectOptions;
})(Core || (Core = {}));
var UrlHelpers;
(function (UrlHelpers) {
    var log = Logger.get("UrlHelpers");
    function noHash(url) {
        if (url.startsWith('#')) {
            return url.last(url.length - 1);
        }
        else {
            return url;
        }
    }
    UrlHelpers.noHash = noHash;
    function extractPath(url) {
        if (url.has('?')) {
            return url.split('?')[0];
        }
        else {
            return url;
        }
    }
    UrlHelpers.extractPath = extractPath;
    function contextActive(url, thingICareAbout) {
        var cleanUrl = extractPath(url);
        if (thingICareAbout.endsWith('/') && thingICareAbout.startsWith("/")) {
            return cleanUrl.has(thingICareAbout);
        }
        if (thingICareAbout.startsWith("/")) {
            return noHash(cleanUrl).startsWith(thingICareAbout);
        }
        return cleanUrl.endsWith(thingICareAbout);
    }
    UrlHelpers.contextActive = contextActive;
    function join() {
        var paths = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            paths[_i - 0] = arguments[_i];
        }
        var tmp = [];
        var length = paths.length - 1;
        paths.forEach(function (path, index) {
            if (Core.isBlank(path)) {
                return;
            }
            if (index !== 0 && path.first(1) === '/') {
                path = path.slice(1);
            }
            if (index !== length && path.last(1) === '/') {
                path = path.slice(0, path.length - 1);
            }
            if (!Core.isBlank(path)) {
                tmp.push(path);
            }
        });
        var rc = tmp.join('/');
        return rc;
    }
    UrlHelpers.join = join;
    UrlHelpers.parseQueryString = hawtioPluginLoader.parseQueryString;
    function maybeProxy(jolokiaUrl, url) {
        if (jolokiaUrl && jolokiaUrl.startsWith('proxy/')) {
            log.debug("Jolokia URL is proxied, applying proxy to: ", url);
            return join('proxy', url);
        }
        var origin = window.location['origin'];
        if (url && (url.startsWith('http') && !url.startsWith(origin))) {
            log.debug("Url doesn't match page origin: ", origin, " applying proxy to: ", url);
            return join('proxy', url);
        }
        log.debug("No need to proxy: ", url);
        return url;
    }
    UrlHelpers.maybeProxy = maybeProxy;
    function escapeColons(url) {
        var answer = url;
        if (url.startsWith('proxy')) {
            answer = url.replace(/:/g, '\\:');
        }
        else {
            answer = url.replace(/:([^\/])/, '\\:$1');
        }
        return answer;
    }
    UrlHelpers.escapeColons = escapeColons;
})(UrlHelpers || (UrlHelpers = {}));
var Core;
(function (Core) {
    Core.injector = null;
    var _urlPrefix = null;
    Core.connectionSettingsKey = "jvmConnect";
    function _resetUrlPrefix() {
        _urlPrefix = null;
    }
    Core._resetUrlPrefix = _resetUrlPrefix;
    function url(path) {
        if (path) {
            if (path.startsWith && path.startsWith("/")) {
                if (!_urlPrefix) {
                    _urlPrefix = $('base').attr('href') || "";
                    if (_urlPrefix.endsWith && _urlPrefix.endsWith('/')) {
                        _urlPrefix = _urlPrefix.substring(0, _urlPrefix.length - 1);
                    }
                }
                if (_urlPrefix) {
                    return _urlPrefix + path;
                }
            }
        }
        return path;
    }
    Core.url = url;
    function windowLocation() {
        return window.location;
    }
    Core.windowLocation = windowLocation;
    String.prototype.unescapeHTML = function () {
        var txt = document.createElement("textarea");
        txt.innerHTML = this;
        return txt.value;
    };
    if (!Object.keys) {
        console.debug("Creating hawt.io version of Object.keys()");
        Object.keys = function (obj) {
            var keys = [], k;
            for (k in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, k)) {
                    keys.push(k);
                }
            }
            return keys;
        };
    }
    function _resetJolokiaUrls() {
        jolokiaUrls = [
            Core.url("jolokia"),
            "/jolokia"
        ];
        return jolokiaUrls;
    }
    Core._resetJolokiaUrls = _resetJolokiaUrls;
    var jolokiaUrls = Core._resetJolokiaUrls();
    function trimLeading(text, prefix) {
        if (text && prefix) {
            if (text.startsWith(prefix)) {
                return text.substring(prefix.length);
            }
        }
        return text;
    }
    Core.trimLeading = trimLeading;
    function trimTrailing(text, postfix) {
        if (text && postfix) {
            if (text.endsWith(postfix)) {
                return text.substring(0, text.length - postfix.length);
            }
        }
        return text;
    }
    Core.trimTrailing = trimTrailing;
    function loadConnectionMap() {
        var localStorage = Core.getLocalStorage();
        try {
            var answer = angular.fromJson(localStorage[Core.connectionSettingsKey]);
            if (!answer) {
                return {};
            }
            else {
                return answer;
            }
        }
        catch (e) {
            delete localStorage[Core.connectionSettingsKey];
            return {};
        }
    }
    Core.loadConnectionMap = loadConnectionMap;
    function saveConnectionMap(map) {
        Logger.get("Core").debug("Saving connection map: ", StringHelpers.toString(map));
        localStorage[Core.connectionSettingsKey] = angular.toJson(map);
    }
    Core.saveConnectionMap = saveConnectionMap;
    function getConnectOptions(name, localStorage) {
        if (localStorage === void 0) { localStorage = Core.getLocalStorage(); }
        if (!name) {
            return null;
        }
        return Core.loadConnectionMap()[name];
    }
    Core.getConnectOptions = getConnectOptions;
    Core.ConnectionName = null;
    function getConnectionNameParameter(search) {
        if (Core.ConnectionName) {
            return Core.ConnectionName;
        }
        var connectionName = undefined;
        if ('con' in window) {
            connectionName = window['con'];
            Logger.get("Core").debug("Found connection name from window: ", connectionName);
        }
        else {
            connectionName = search["con"];
            if (angular.isArray(connectionName)) {
                connectionName = connectionName[0];
            }
            if (connectionName) {
                connectionName = connectionName.unescapeURL();
                Logger.get("Core").debug("Found connection name from URL: ", connectionName);
            }
            else {
                Logger.get("Core").debug("No connection name found, using direct connection to JVM");
            }
        }
        Core.ConnectionName = connectionName;
        return connectionName;
    }
    Core.getConnectionNameParameter = getConnectionNameParameter;
    function createServerConnectionUrl(options) {
        Logger.get("Core").debug("Connect to server, options: ", StringHelpers.toString(options));
        var answer = null;
        if (options.jolokiaUrl) {
            answer = options.jolokiaUrl;
        }
        if (answer === null) {
            answer = options.scheme || 'http';
            answer += '://' + (options.host || 'localhost');
            if (options.port) {
                answer += ':' + options.port;
            }
            if (options.path) {
                answer = UrlHelpers.join(answer, options.path);
            }
        }
        if (options.useProxy) {
            answer = UrlHelpers.join('proxy', answer);
        }
        Logger.get("Core").debug("Using URL: ", answer);
        return answer;
    }
    Core.createServerConnectionUrl = createServerConnectionUrl;
    function getJolokiaUrl() {
        var query = hawtioPluginLoader.parseQueryString();
        var localMode = query['localMode'];
        if (localMode) {
            Logger.get("Core").debug("local mode so not using jolokia URL");
            jolokiaUrls = [];
            return null;
        }
        var uri = null;
        var connectionName = Core.getConnectionNameParameter(query);
        if (connectionName) {
            var connectOptions = Core.getConnectOptions(connectionName);
            if (connectOptions) {
                uri = createServerConnectionUrl(connectOptions);
                Logger.get("Core").debug("Using jolokia URI: ", uri, " from local storage");
            }
            else {
                Logger.get("Core").debug("Connection parameter found but no stored connections under name: ", connectionName);
            }
        }
        if (!uri) {
            var fakeCredentials = {
                username: 'public',
                password: 'biscuit'
            };
            var localStorage = getLocalStorage();
            if ('userDetails' in window) {
                fakeCredentials = window['userDetails'];
            }
            else if ('userDetails' in localStorage) {
                fakeCredentials = angular.fromJson(localStorage['userDetails']);
            }
            uri = jolokiaUrls.find(function (url) {
                var jqxhr = $.ajax(url, {
                    async: false,
                    username: fakeCredentials.username,
                    password: fakeCredentials.password
                });
                return jqxhr.status === 200 || jqxhr.status === 401 || jqxhr.status === 403;
            });
            Logger.get("Core").debug("Using jolokia URI: ", uri, " via discovery");
        }
        return uri;
    }
    Core.getJolokiaUrl = getJolokiaUrl;
    function adjustHeight() {
        var windowHeight = $(window).height();
        var headerHeight = $("#main-nav").height();
        var containerHeight = windowHeight - headerHeight;
        $("#main").css("min-height", "" + containerHeight + "px");
    }
    Core.adjustHeight = adjustHeight;
    function isChromeApp() {
        var answer = false;
        try {
            answer = (chrome && chrome.app && chrome.extension) ? true : false;
        }
        catch (e) {
            answer = false;
        }
        return answer;
    }
    Core.isChromeApp = isChromeApp;
    function addCSS(path) {
        if ('createStyleSheet' in document) {
            document.createStyleSheet(path);
        }
        else {
            var link = $("<link>");
            $("head").append(link);
            link.attr({
                rel: 'stylesheet',
                type: 'text/css',
                href: path
            });
        }
    }
    Core.addCSS = addCSS;
    var dummyStorage = {};
    function getLocalStorage() {
        var storage = window.localStorage || (function () {
            return dummyStorage;
        })();
        return storage;
    }
    Core.getLocalStorage = getLocalStorage;
    function asArray(value) {
        return angular.isArray(value) ? value : [value];
    }
    Core.asArray = asArray;
    function parseBooleanValue(value) {
        if (!angular.isDefined(value) || !value) {
            return false;
        }
        if (value.constructor === Boolean) {
            return value;
        }
        if (angular.isString(value)) {
            switch (value.toLowerCase()) {
                case "true":
                case "1":
                case "yes":
                    return true;
                default:
                    return false;
            }
        }
        if (angular.isNumber(value)) {
            return value !== 0;
        }
        throw new Error("Can't convert value " + value + " to boolean");
    }
    Core.parseBooleanValue = parseBooleanValue;
    function toString(value) {
        if (angular.isNumber(value)) {
            return numberToString(value);
        }
        else {
            return angular.toJson(value, true);
        }
    }
    Core.toString = toString;
    function booleanToString(value) {
        return "" + value;
    }
    Core.booleanToString = booleanToString;
    function parseIntValue(value, description) {
        if (description === void 0) { description = "integer"; }
        if (angular.isString(value)) {
            try {
                return parseInt(value);
            }
            catch (e) {
                console.log("Failed to parse " + description + " with text '" + value + "'");
            }
        }
        else if (angular.isNumber(value)) {
            return value;
        }
        return null;
    }
    Core.parseIntValue = parseIntValue;
    function numberToString(value) {
        return "" + value;
    }
    Core.numberToString = numberToString;
    function parseFloatValue(value, description) {
        if (description === void 0) { description = "float"; }
        if (angular.isString(value)) {
            try {
                return parseFloat(value);
            }
            catch (e) {
                console.log("Failed to parse " + description + " with text '" + value + "'");
            }
        }
        else if (angular.isNumber(value)) {
            return value;
        }
        return null;
    }
    Core.parseFloatValue = parseFloatValue;
    function pathGet(object, paths) {
        var pathArray = (angular.isArray(paths)) ? paths : (paths || "").split(".");
        var value = object;
        angular.forEach(pathArray, function (name) {
            if (value) {
                try {
                    value = value[name];
                }
                catch (e) {
                    return null;
                }
            }
            else {
                return null;
            }
        });
        return value;
    }
    Core.pathGet = pathGet;
    function pathSet(object, paths, newValue) {
        var pathArray = (angular.isArray(paths)) ? paths : (paths || "").split(".");
        var value = object;
        var lastIndex = pathArray.length - 1;
        angular.forEach(pathArray, function (name, idx) {
            var next = value[name];
            if (idx >= lastIndex || !angular.isObject(next)) {
                next = (idx < lastIndex) ? {} : newValue;
                value[name] = next;
            }
            value = next;
        });
        return value;
    }
    Core.pathSet = pathSet;
    function $applyNowOrLater($scope) {
        if ($scope.$$phase || $scope.$root.$$phase) {
            setTimeout(function () {
                Core.$apply($scope);
            }, 50);
        }
        else {
            $scope.$apply();
        }
    }
    Core.$applyNowOrLater = $applyNowOrLater;
    function $applyLater($scope, timeout) {
        if (timeout === void 0) { timeout = 50; }
        setTimeout(function () {
            Core.$apply($scope);
        }, timeout);
    }
    Core.$applyLater = $applyLater;
    function $apply($scope) {
        var phase = $scope.$$phase || $scope.$root.$$phase;
        if (!phase) {
            $scope.$apply();
        }
    }
    Core.$apply = $apply;
    function $digest($scope) {
        var phase = $scope.$$phase || $scope.$root.$$phase;
        if (!phase) {
            $scope.$digest();
        }
    }
    Core.$digest = $digest;
    function getOrCreateElements(domElement, arrayOfElementNames) {
        var element = domElement;
        angular.forEach(arrayOfElementNames, function (name) {
            if (element) {
                var children = $(element).children(name);
                if (!children || !children.length) {
                    $("<" + name + "></" + name + ">").appendTo(element);
                    children = $(element).children(name);
                }
                element = children;
            }
        });
        return element;
    }
    Core.getOrCreateElements = getOrCreateElements;
    var _escapeHtmlChars = {
        "#": "&#35;",
        "'": "&#39;",
        "<": "&lt;",
        ">": "&gt;",
        "\"": "&quot;"
    };
    function unescapeHtml(str) {
        angular.forEach(_escapeHtmlChars, function (value, key) {
            var regex = new RegExp(value, "g");
            str = str.replace(regex, key);
        });
        str = str.replace(/&gt;/g, ">");
        return str;
    }
    Core.unescapeHtml = unescapeHtml;
    function escapeHtml(str) {
        if (angular.isString(str)) {
            var newStr = "";
            for (var i = 0; i < str.length; i++) {
                var ch = str.charAt(i);
                var ch = _escapeHtmlChars[ch] || ch;
                newStr += ch;
            }
            return newStr;
        }
        else {
            return str;
        }
    }
    Core.escapeHtml = escapeHtml;
    function isBlank(str) {
        if (str === undefined || str === null) {
            return true;
        }
        if (angular.isString(str)) {
            return str.isBlank();
        }
        else {
            return false;
        }
    }
    Core.isBlank = isBlank;
    function notification(type, message, options) {
        if (options === void 0) { options = null; }
        if (options === null) {
            options = {};
        }
        if (type === 'error' || type === 'warning') {
            if (!angular.isDefined(options.onclick)) {
                options.onclick = window['showLogPanel'];
            }
        }
        toastr[type](message, '', options);
    }
    Core.notification = notification;
    function clearNotifications() {
        toastr.clear();
    }
    Core.clearNotifications = clearNotifications;
    function trimQuotes(text) {
        if (text) {
            while (text.endsWith('"') || text.endsWith("'")) {
                text = text.substring(0, text.length - 1);
            }
            while (text.startsWith('"') || text.startsWith("'")) {
                text = text.substring(1, text.length);
            }
        }
        return text;
    }
    Core.trimQuotes = trimQuotes;
    function humanizeValue(value) {
        if (value) {
            var text = value + '';
            try {
                text = text.underscore();
            }
            catch (e) {
            }
            try {
                text = text.humanize();
            }
            catch (e) {
            }
            return trimQuotes(text);
        }
        return value;
    }
    Core.humanizeValue = humanizeValue;
})(Core || (Core = {}));
var ControllerHelpers;
(function (ControllerHelpers) {
    var log = Logger.get("ControllerHelpers");
    function createClassSelector(config) {
        return function (selector, model) {
            if (selector === model && selector in config) {
                return config[selector];
            }
            return '';
        };
    }
    ControllerHelpers.createClassSelector = createClassSelector;
    function createValueClassSelector(config) {
        return function (model) {
            if (model in config) {
                return config[model];
            }
            else {
                return '';
            }
        };
    }
    ControllerHelpers.createValueClassSelector = createValueClassSelector;
    function bindModelToSearchParam($scope, $location, modelName, paramName, initialValue, to, from) {
        if (!(modelName in $scope)) {
            $scope[modelName] = initialValue;
        }
        var toConverter = to || Core.doNothing;
        var fromConverter = from || Core.doNothing;
        function currentValue() {
            return fromConverter($location.search()[paramName] || initialValue);
        }
        var value = currentValue();
        Core.pathSet($scope, modelName, value);
        $scope.$watch(modelName, function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (newValue !== undefined && newValue !== null) {
                    $location.search(paramName, toConverter(newValue));
                }
                else {
                    $location.search(paramName, '');
                }
            }
        });
    }
    ControllerHelpers.bindModelToSearchParam = bindModelToSearchParam;
    function reloadWhenParametersChange($route, $scope, $location, parameters) {
        if (parameters === void 0) { parameters = ["nid"]; }
        var initial = angular.copy($location.search());
        $scope.$on('$routeUpdate', function () {
            var current = $location.search();
            var changed = [];
            angular.forEach(parameters, function (param) {
                if (current[param] !== initial[param]) {
                    changed.push(param);
                }
            });
            if (changed.length) {
                $route.reload();
            }
        });
    }
    ControllerHelpers.reloadWhenParametersChange = reloadWhenParametersChange;
})(ControllerHelpers || (ControllerHelpers = {}));
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Core;
(function (Core) {
    var log = Logger.get("Core");
    var TasksImpl = (function () {
        function TasksImpl() {
            this.tasks = {};
            this.tasksExecuted = false;
            this._onComplete = null;
        }
        TasksImpl.prototype.addTask = function (name, task) {
            this.tasks[name] = task;
            if (this.tasksExecuted) {
                this.executeTask(name, task);
            }
        };
        TasksImpl.prototype.executeTask = function (name, task) {
            if (angular.isFunction(task)) {
                log.debug("Executing task : ", name);
                try {
                    task();
                }
                catch (error) {
                    log.debug("Failed to execute task: ", name, " error: ", error);
                }
            }
        };
        TasksImpl.prototype.onComplete = function (cb) {
            this._onComplete = cb;
        };
        TasksImpl.prototype.execute = function () {
            var _this = this;
            if (this.tasksExecuted) {
                return;
            }
            angular.forEach(this.tasks, function (task, name) {
                _this.executeTask(name, task);
            });
            this.tasksExecuted = true;
            if (angular.isFunction(this._onComplete)) {
                this._onComplete();
            }
        };
        TasksImpl.prototype.reset = function () {
            this.tasksExecuted = false;
        };
        return TasksImpl;
    })();
    Core.TasksImpl = TasksImpl;
    var ParameterizedTasksImpl = (function (_super) {
        __extends(ParameterizedTasksImpl, _super);
        function ParameterizedTasksImpl() {
            var _this = this;
            _super.call(this);
            this.tasks = {};
            this.onComplete(function () {
                _this.reset();
            });
        }
        ParameterizedTasksImpl.prototype.addTask = function (name, task) {
            this.tasks[name] = task;
        };
        ParameterizedTasksImpl.prototype.execute = function () {
            var _this = this;
            var params = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                params[_i - 0] = arguments[_i];
            }
            if (this.tasksExecuted) {
                return;
            }
            var theArgs = params;
            var keys = Object.keys(this.tasks);
            keys.forEach(function (name) {
                var task = _this.tasks[name];
                if (angular.isFunction(task)) {
                    log.debug("Executing task: ", name, " with parameters: ", theArgs);
                    try {
                        task.apply(task, theArgs);
                    }
                    catch (e) {
                        log.debug("Failed to execute task: ", name, " error: ", e);
                    }
                }
            });
            this.tasksExecuted = true;
            if (angular.isFunction(this._onComplete)) {
                this._onComplete();
            }
        };
        return ParameterizedTasksImpl;
    })(TasksImpl);
    Core.ParameterizedTasksImpl = ParameterizedTasksImpl;
    Core.postLoginTasks = new Core.TasksImpl();
    Core.preLogoutTasks = new Core.TasksImpl();
})(Core || (Core = {}));
var Core;
(function (Core) {
    function operationToString(name, args) {
        if (!args || args.length === 0) {
            return name + '()';
        }
        else {
            return name + '(' + args.map(function (arg) {
                if (angular.isString(arg)) {
                    arg = angular.fromJson(arg);
                }
                return arg.type;
            }).join(',') + ')';
        }
    }
    Core.operationToString = operationToString;
})(Core || (Core = {}));
var Core;
(function (Core) {
    var Folder = (function () {
        function Folder(title) {
            this.title = title;
            this.key = null;
            this.typeName = null;
            this.children = [];
            this.folderNames = [];
            this.domain = null;
            this.objectName = null;
            this.map = {};
            this.entries = {};
            this.addClass = null;
            this.parent = null;
            this.isLazy = false;
            this.icon = null;
            this.tooltip = null;
            this.entity = null;
            this.version = null;
            this.mbean = null;
            this.addClass = escapeTreeCssStyles(title);
        }
        Folder.prototype.get = function (key) {
            return this.map[key];
        };
        Folder.prototype.isFolder = function () {
            return this.children.length > 0;
        };
        Folder.prototype.navigate = function () {
            var paths = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                paths[_i - 0] = arguments[_i];
            }
            var node = this;
            paths.forEach(function (path) {
                if (node) {
                    node = node.get(path);
                }
            });
            return node;
        };
        Folder.prototype.hasEntry = function (key, value) {
            var entries = this.entries;
            if (entries) {
                var actual = entries[key];
                return actual && value === actual;
            }
            return false;
        };
        Folder.prototype.parentHasEntry = function (key, value) {
            if (this.parent) {
                return this.parent.hasEntry(key, value);
            }
            return false;
        };
        Folder.prototype.ancestorHasEntry = function (key, value) {
            var parent = this.parent;
            while (parent) {
                if (parent.hasEntry(key, value))
                    return true;
                parent = parent.parent;
            }
            return false;
        };
        Folder.prototype.ancestorHasType = function (typeName) {
            var parent = this.parent;
            while (parent) {
                if (typeName === parent.typeName)
                    return true;
                parent = parent.parent;
            }
            return false;
        };
        Folder.prototype.getOrElse = function (key, defaultValue) {
            if (defaultValue === void 0) { defaultValue = new Folder(key); }
            var answer = this.map[key];
            if (!answer) {
                answer = defaultValue;
                this.map[key] = answer;
                this.children.push(answer);
                answer.parent = this;
            }
            return answer;
        };
        Folder.prototype.sortChildren = function (recursive) {
            var children = this.children;
            if (children) {
                this.children = children.sortBy("title");
                if (recursive) {
                    angular.forEach(children, function (child) { return child.sortChildren(recursive); });
                }
            }
        };
        Folder.prototype.moveChild = function (child) {
            if (child && child.parent !== this) {
                child.detach();
                child.parent = this;
                this.children.push(child);
            }
        };
        Folder.prototype.insertBefore = function (child, referenceFolder) {
            child.detach();
            child.parent = this;
            var idx = _.indexOf(this.children, referenceFolder);
            if (idx >= 0) {
                this.children.splice(idx, 0, child);
            }
        };
        Folder.prototype.insertAfter = function (child, referenceFolder) {
            child.detach();
            child.parent = this;
            var idx = _.indexOf(this.children, referenceFolder);
            if (idx >= 0) {
                this.children.splice(idx + 1, 0, child);
            }
        };
        Folder.prototype.detach = function () {
            var oldParent = this.parent;
            if (oldParent) {
                var oldParentChildren = oldParent.children;
                if (oldParentChildren) {
                    var idx = oldParentChildren.indexOf(this);
                    if (idx < 0) {
                        oldParent.children = oldParent.children.remove({ key: this.key });
                    }
                    else {
                        oldParentChildren.splice(idx, 1);
                    }
                }
                this.parent = null;
            }
        };
        Folder.prototype.findDescendant = function (filter) {
            if (filter(this)) {
                return this;
            }
            var answer = null;
            angular.forEach(this.children, function (child) {
                if (!answer) {
                    answer = child.findDescendant(filter);
                }
            });
            return answer;
        };
        Folder.prototype.findAncestor = function (filter) {
            if (filter(this)) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.findAncestor(filter);
            }
            else {
                return null;
            }
        };
        return Folder;
    })();
    Core.Folder = Folder;
})(Core || (Core = {}));
;
var Folder = (function (_super) {
    __extends(Folder, _super);
    function Folder() {
        _super.apply(this, arguments);
    }
    return Folder;
})(Core.Folder);
;
var Jmx;
(function (Jmx) {
    Jmx.log = Logger.get("JMX");
    var attributesToolBars = {};
    function findLazyLoadingFunction(workspace, folder) {
        var factories = workspace.jmxTreeLazyLoadRegistry[folder.domain];
        var lazyFunction = null;
        if (factories && factories.length) {
            angular.forEach(factories, function (customLoader) {
                if (!lazyFunction) {
                    lazyFunction = customLoader(folder);
                }
            });
        }
        return lazyFunction;
    }
    Jmx.findLazyLoadingFunction = findLazyLoadingFunction;
    function registerLazyLoadHandler(domain, lazyLoaderFactory) {
        if (!Core.lazyLoaders) {
            Core.lazyLoaders = {};
        }
        var array = Core.lazyLoaders[domain];
        if (!array) {
            array = [];
            Core.lazyLoaders[domain] = array;
        }
        array.push(lazyLoaderFactory);
    }
    Jmx.registerLazyLoadHandler = registerLazyLoadHandler;
    function unregisterLazyLoadHandler(domain, lazyLoaderFactory) {
        if (Core.lazyLoaders) {
            var array = Core.lazyLoaders[domain];
            if (array) {
                array.remove(lazyLoaderFactory);
            }
        }
    }
    Jmx.unregisterLazyLoadHandler = unregisterLazyLoadHandler;
    function addAttributeToolBar(pluginName, jmxDomain, fn) {
        var array = attributesToolBars[jmxDomain];
        if (!array) {
            array = [];
            attributesToolBars[jmxDomain] = array;
        }
        array.push(fn);
    }
    Jmx.addAttributeToolBar = addAttributeToolBar;
    function getAttributeToolBar(node, defaultValue) {
        if (defaultValue === void 0) { defaultValue = "app/jmx/html/attributeToolBar.html"; }
        var answer = null;
        var jmxDomain = (node) ? node.domain : null;
        if (jmxDomain) {
            var array = attributesToolBars[jmxDomain];
            if (array) {
                for (var idx in array) {
                    var fn = array[idx];
                    answer = fn(node);
                    if (answer)
                        break;
                }
            }
        }
        return (answer) ? answer : defaultValue;
    }
    Jmx.getAttributeToolBar = getAttributeToolBar;
    function updateTreeSelectionFromURL($location, treeElement, activateIfNoneSelected) {
        if (activateIfNoneSelected === void 0) { activateIfNoneSelected = false; }
        updateTreeSelectionFromURLAndAutoSelect($location, treeElement, null, activateIfNoneSelected);
    }
    Jmx.updateTreeSelectionFromURL = updateTreeSelectionFromURL;
    function updateTreeSelectionFromURLAndAutoSelect($location, treeElement, autoSelect, activateIfNoneSelected) {
        if (activateIfNoneSelected === void 0) { activateIfNoneSelected = false; }
        var dtree = treeElement.dynatree("getTree");
        if (dtree) {
            var node = null;
            var key = $location.search()['nid'];
            if (key) {
                try {
                    node = dtree.activateKey(key);
                }
                catch (e) {
                }
            }
            if (node) {
                node.expand(true);
            }
            else {
                if (!treeElement.dynatree("getActiveNode")) {
                    var root = treeElement.dynatree("getRoot");
                    var children = root ? root.getChildren() : null;
                    if (children && children.length) {
                        var first = children[0];
                        first.expand(true);
                        if (autoSelect) {
                            var result = autoSelect(first);
                            if (result) {
                                first = result;
                            }
                        }
                        if (activateIfNoneSelected) {
                            first.expand();
                            first.activate();
                        }
                    }
                    else {
                    }
                }
            }
        }
    }
    Jmx.updateTreeSelectionFromURLAndAutoSelect = updateTreeSelectionFromURLAndAutoSelect;
    function getUniqueTypeNames(children) {
        var typeNameMap = {};
        angular.forEach(children, function (mbean) {
            var typeName = mbean.typeName;
            if (typeName) {
                typeNameMap[typeName] = mbean;
            }
        });
        var typeNames = Object.keys(typeNameMap);
        return typeNames;
    }
    Jmx.getUniqueTypeNames = getUniqueTypeNames;
    function enableTree($scope, $location, workspace, treeElement, children, redraw, onActivateFn) {
        if (redraw === void 0) { redraw = false; }
        if (onActivateFn === void 0) { onActivateFn = null; }
        if (treeElement.length) {
            if (!onActivateFn) {
                onActivateFn = function (node) {
                    var data = node.data;
                    workspace.updateSelectionNode(data);
                    Core.$apply($scope);
                };
            }
            workspace.treeElement = treeElement;
            treeElement.dynatree({
                onActivate: onActivateFn,
                onLazyRead: function (treeNode) {
                    var folder = treeNode.data;
                    var plugin = null;
                    if (folder) {
                        plugin = Jmx.findLazyLoadingFunction(workspace, folder);
                    }
                    if (plugin) {
                        console.log("Lazy loading folder " + folder.title);
                        var oldChildren = folder.childen;
                        plugin(workspace, folder, function () {
                            treeNode.setLazyNodeStatus(DTNodeStatus_Ok);
                            var newChildren = folder.children;
                            if (newChildren !== oldChildren) {
                                treeNode.removeChildren();
                                angular.forEach(newChildren, function (newChild) {
                                    treeNode.addChild(newChild);
                                });
                            }
                        });
                    }
                    else {
                        treeNode.setLazyNodeStatus(DTNodeStatus_Ok);
                    }
                },
                onClick: function (node, event) {
                    if (event["metaKey"]) {
                        event.preventDefault();
                        var url = $location.absUrl();
                        if (node && node.data) {
                            var key = node.data["key"];
                            if (key) {
                                var hash = $location.search();
                                hash["nid"] = key;
                                var idx = url.indexOf('?');
                                if (idx <= 0) {
                                    url += "?";
                                }
                                else {
                                    url = url.substring(0, idx + 1);
                                }
                                url += $.param(hash);
                            }
                        }
                        window.open(url, '_blank');
                        window.focus();
                        return false;
                    }
                    return true;
                },
                persist: false,
                debugLevel: 0,
                children: children
            });
            if (redraw) {
                workspace.redrawTree();
            }
        }
    }
    Jmx.enableTree = enableTree;
})(Jmx || (Jmx = {}));
var Core;
(function (Core) {
    var log = Logger.get("Core");
    var Workspace = (function () {
        function Workspace(jolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope, userDetails) {
            this.jolokia = jolokia;
            this.jolokiaStatus = jolokiaStatus;
            this.jmxTreeLazyLoadRegistry = jmxTreeLazyLoadRegistry;
            this.$location = $location;
            this.$compile = $compile;
            this.$templateCache = $templateCache;
            this.localStorage = localStorage;
            this.$rootScope = $rootScope;
            this.userDetails = userDetails;
            this.operationCounter = 0;
            this.tree = new Core.Folder('MBeans');
            this.mbeanTypesToDomain = {};
            this.mbeanServicesToDomain = {};
            this.attributeColumnDefs = {};
            this.treePostProcessors = [];
            this.topLevelTabs = [];
            this.subLevelTabs = [];
            this.keyToNodeMap = {};
            this.pluginRegisterHandle = null;
            this.pluginUpdateCounter = null;
            this.treeWatchRegisterHandle = null;
            this.treeWatcherCounter = null;
            this.treeElement = null;
            this.mapData = {};
            if (!('autoRefresh' in localStorage)) {
                localStorage['autoRefresh'] = true;
            }
            if (!('updateRate' in localStorage)) {
                localStorage['updateRate'] = 5000;
            }
        }
        Workspace.prototype.createChildWorkspace = function (location) {
            var child = new Workspace(this.jolokia, this.jolokiaStatus, this.jmxTreeLazyLoadRegistry, this.$location, this.$compile, this.$templateCache, this.localStorage, this.$rootScope, this.userDetails);
            angular.forEach(this, function (value, key) { return child[key] = value; });
            child.$location = location;
            return child;
        };
        Workspace.prototype.getLocalStorage = function (key) {
            return this.localStorage[key];
        };
        Workspace.prototype.setLocalStorage = function (key, value) {
            this.localStorage[key] = value;
        };
        Workspace.prototype.loadTree = function () {
            var flags = { ignoreErrors: true, maxDepth: 7 };
            var data = this.jolokia.list(null, onSuccess(null, flags));
            if (data) {
                this.jolokiaStatus.xhr = null;
            }
            this.populateTree({
                value: data
            });
        };
        Workspace.prototype.addTreePostProcessor = function (processor) {
            this.treePostProcessors.push(processor);
            var tree = this.tree;
            if (tree) {
                processor(tree);
            }
        };
        Workspace.prototype.maybeMonitorPlugins = function () {
            if (this.treeContainsDomainAndProperties("hawtio", { type: "Registry" })) {
                if (this.pluginRegisterHandle === null) {
                    this.pluginRegisterHandle = this.jolokia.register(angular.bind(this, this.maybeUpdatePlugins), {
                        type: "read",
                        mbean: "hawtio:type=Registry",
                        attribute: "UpdateCounter"
                    });
                }
            }
            else {
                if (this.pluginRegisterHandle !== null) {
                    this.jolokia.unregister(this.pluginRegisterHandle);
                    this.pluginRegisterHandle = null;
                    this.pluginUpdateCounter = null;
                }
            }
            if (this.treeContainsDomainAndProperties("hawtio", { type: "TreeWatcher" })) {
                if (this.treeWatchRegisterHandle === null) {
                    this.treeWatchRegisterHandle = this.jolokia.register(angular.bind(this, this.maybeReloadTree), {
                        type: "read",
                        mbean: "hawtio:type=TreeWatcher",
                        attribute: "Counter"
                    });
                }
            }
        };
        Workspace.prototype.maybeUpdatePlugins = function (response) {
            if (this.pluginUpdateCounter === null) {
                this.pluginUpdateCounter = response.value;
                return;
            }
            if (this.pluginUpdateCounter !== response.value) {
                if (Core.parseBooleanValue(localStorage['autoRefresh'])) {
                    window.location.reload();
                }
            }
        };
        Workspace.prototype.maybeReloadTree = function (response) {
            var counter = response.value;
            if (this.treeWatcherCounter === null) {
                this.treeWatcherCounter = counter;
                return;
            }
            if (this.treeWatcherCounter !== counter) {
                this.treeWatcherCounter = counter;
                var workspace = this;
                function wrapInValue(response) {
                    var wrapper = {
                        value: response
                    };
                    workspace.populateTree(wrapper);
                }
                this.jolokia.list(null, onSuccess(wrapInValue, { ignoreErrors: true, maxDepth: 2 }));
            }
        };
        Workspace.prototype.folderGetOrElse = function (folder, value) {
            if (folder) {
                try {
                    return folder.getOrElse(value);
                }
                catch (e) {
                    log.warn("Failed to find value " + value + " on folder " + folder);
                }
            }
            return null;
        };
        Workspace.prototype.populateTree = function (response) {
            log.debug("JMX tree has been loaded, data: ", response.value);
            var rootId = 'root';
            var separator = '-';
            this.mbeanTypesToDomain = {};
            this.mbeanServicesToDomain = {};
            this.keyToNodeMap = {};
            var tree = new Core.Folder('MBeans');
            tree.key = rootId;
            var domains = response.value;
            for (var domainName in domains) {
                var domainClass = escapeDots(domainName);
                var domain = domains[domainName];
                for (var mbeanName in domain) {
                    var entries = {};
                    var folder = this.folderGetOrElse(tree, domainName);
                    folder.domain = domainName;
                    if (!folder.key) {
                        folder.key = rootId + separator + domainName;
                    }
                    var folderNames = [domainName];
                    folder.folderNames = folderNames;
                    folderNames = folderNames.clone();
                    var items = mbeanName.split(',');
                    var paths = [];
                    var typeName = null;
                    var serviceName = null;
                    items.forEach(function (item) {
                        var kv = item.split('=');
                        var key = kv[0];
                        var value = kv[1] || key;
                        entries[key] = value;
                        var moveToFront = false;
                        var lowerKey = key.toLowerCase();
                        if (lowerKey === "type") {
                            typeName = value;
                            if (folder.map[value]) {
                                moveToFront = true;
                            }
                        }
                        if (lowerKey === "service") {
                            serviceName = value;
                        }
                        if (moveToFront) {
                            paths.splice(0, 0, value);
                        }
                        else {
                            paths.push(value);
                        }
                    });
                    var configureFolder = function (folder, name) {
                        folder.domain = domainName;
                        if (!folder.key) {
                            folder.key = rootId + separator + folderNames.join(separator);
                        }
                        this.keyToNodeMap[folder.key] = folder;
                        folder.folderNames = folderNames.clone();
                        var classes = "";
                        var entries = folder.entries;
                        var entryKeys = Object.keys(entries).filter(function (n) { return n.toLowerCase().indexOf("type") >= 0; });
                        if (entryKeys.length) {
                            angular.forEach(entryKeys, function (entryKey) {
                                var entryValue = entries[entryKey];
                                if (!folder.ancestorHasEntry(entryKey, entryValue)) {
                                    classes += " " + domainClass + separator + entryValue;
                                }
                            });
                        }
                        else {
                            var kindName = folderNames.last();
                            if (kindName === name) {
                                kindName += "-folder";
                            }
                            if (kindName) {
                                classes += " " + domainClass + separator + kindName;
                            }
                        }
                        folder.addClass = escapeTreeCssStyles(classes);
                        return folder;
                    };
                    var lastPath = paths.pop();
                    var ws = this;
                    paths.forEach(function (value) {
                        folder = ws.folderGetOrElse(folder, value);
                        if (folder) {
                            folderNames.push(value);
                            angular.bind(ws, configureFolder, folder, value)();
                        }
                    });
                    var key = rootId + separator + folderNames.join(separator) + separator + lastPath;
                    var objectName = domainName + ":" + mbeanName;
                    if (folder) {
                        folder = this.folderGetOrElse(folder, lastPath);
                        if (folder) {
                            folder.entries = entries;
                            folder.key = key;
                            angular.bind(this, configureFolder, folder, lastPath)();
                            folder.title = Core.trimQuotes(lastPath);
                            folder.objectName = objectName;
                            folder.mbean = domain[mbeanName];
                            folder.typeName = typeName;
                            var addFolderByDomain = function (owner, typeName) {
                                var map = owner[typeName];
                                if (!map) {
                                    map = {};
                                    owner[typeName] = map;
                                }
                                var value = map[domainName];
                                if (!value) {
                                    map[domainName] = folder;
                                }
                                else {
                                    var array = null;
                                    if (angular.isArray(value)) {
                                        array = value;
                                    }
                                    else {
                                        array = [value];
                                        map[domainName] = array;
                                    }
                                    array.push(folder);
                                }
                            };
                            if (serviceName) {
                                angular.bind(this, addFolderByDomain, this.mbeanServicesToDomain, serviceName)();
                            }
                            if (typeName) {
                                angular.bind(this, addFolderByDomain, this.mbeanTypesToDomain, typeName)();
                            }
                        }
                    }
                    else {
                        log.info("No folder found for lastPath: " + lastPath);
                    }
                }
                tree.sortChildren(true);
                this.enableLazyLoading(tree);
                this.tree = tree;
                var processors = this.treePostProcessors;
                angular.forEach(processors, function (processor) { return processor(tree); });
                this.maybeMonitorPlugins();
                var rootScope = this.$rootScope;
                if (rootScope) {
                    rootScope.$broadcast('jmxTreeUpdated');
                }
            }
        };
        Workspace.prototype.enableLazyLoading = function (folder) {
            var _this = this;
            var children = folder.children;
            if (children && children.length) {
                angular.forEach(children, function (child) {
                    _this.enableLazyLoading(child);
                });
            }
            else {
                var lazyFunction = Jmx.findLazyLoadingFunction(this, folder);
                if (lazyFunction) {
                    folder.isLazy = true;
                }
            }
        };
        Workspace.prototype.hash = function () {
            var hash = this.$location.search();
            var params = Core.hashToString(hash);
            if (params) {
                return "?" + params;
            }
            return "";
        };
        Workspace.prototype.getActiveTab = function () {
            var workspace = this;
            return this.topLevelTabs.find(function (tab) {
                if (!angular.isDefined(tab.isActive)) {
                    return workspace.isLinkActive(tab.href());
                }
                else {
                    return tab.isActive(workspace);
                }
            });
        };
        Workspace.prototype.getStrippedPathName = function () {
            var pathName = Core.trimLeading((this.$location.path() || '/'), "#");
            pathName = Core.trimLeading(pathName, "/");
            return pathName;
        };
        Workspace.prototype.linkContains = function () {
            var words = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                words[_i - 0] = arguments[_i];
            }
            var pathName = this.getStrippedPathName();
            return words.all(function (word) {
                return pathName.has(word);
            });
        };
        Workspace.prototype.isLinkActive = function (href) {
            var pathName = this.getStrippedPathName();
            var link = Core.trimLeading(href, "#");
            link = Core.trimLeading(link, "/");
            var idx = link.indexOf('?');
            if (idx >= 0) {
                link = link.substring(0, idx);
            }
            if (!pathName.length) {
                return link === pathName;
            }
            else {
                return pathName.startsWith(link);
            }
        };
        Workspace.prototype.isLinkPrefixActive = function (href) {
            var pathName = this.getStrippedPathName();
            var link = Core.trimLeading(href, "#");
            link = Core.trimLeading(link, "/");
            var idx = link.indexOf('?');
            if (idx >= 0) {
                link = link.substring(0, idx);
            }
            return pathName.startsWith(link);
        };
        Workspace.prototype.isTopTabActive = function (path) {
            var tab = this.$location.search()['tab'];
            if (angular.isString(tab)) {
                return tab.startsWith(path);
            }
            return this.isLinkActive(path);
        };
        Workspace.prototype.getSelectedMBeanName = function () {
            var selection = this.selection;
            if (selection) {
                return selection.objectName;
            }
            return null;
        };
        Workspace.prototype.validSelection = function (uri) {
            var workspace = this;
            var filter = function (t) {
                var fn = t.href;
                if (fn) {
                    var href = fn();
                    if (href) {
                        if (href.startsWith("#/")) {
                            href = href.substring(2);
                        }
                        return href === uri;
                    }
                }
                return false;
            };
            var tab = this.subLevelTabs.find(filter);
            if (!tab) {
                tab = this.topLevelTabs.find(filter);
            }
            if (tab) {
                var validFn = tab['isValid'];
                return !angular.isDefined(validFn) || validFn(workspace);
            }
            else {
                log.info("Could not find tab for " + uri);
                return false;
            }
        };
        Workspace.prototype.removeAndSelectParentNode = function () {
            var selection = this.selection;
            if (selection) {
                var parent = selection.parent;
                if (parent) {
                    var idx = parent.children.indexOf(selection);
                    if (idx < 0) {
                        idx = parent.children.findIndex(function (n) { return n.key === selection.key; });
                    }
                    if (idx >= 0) {
                        parent.children.splice(idx, 1);
                    }
                    this.updateSelectionNode(parent);
                }
            }
        };
        Workspace.prototype.selectParentNode = function () {
            var selection = this.selection;
            if (selection) {
                var parent = selection.parent;
                if (parent) {
                    this.updateSelectionNode(parent);
                }
            }
        };
        Workspace.prototype.selectionViewConfigKey = function () {
            return this.selectionConfigKey("view/");
        };
        Workspace.prototype.selectionConfigKey = function (prefix) {
            if (prefix === void 0) { prefix = ""; }
            var key = null;
            var selection = this.selection;
            if (selection) {
                key = prefix + selection.domain;
                var typeName = selection.typeName;
                if (!typeName) {
                    typeName = selection.title;
                }
                key += "/" + typeName;
                if (selection.isFolder()) {
                    key += "/folder";
                }
            }
            return key;
        };
        Workspace.prototype.moveIfViewInvalid = function () {
            var workspace = this;
            var uri = Core.trimLeading(this.$location.path(), "/");
            if (this.selection) {
                var key = this.selectionViewConfigKey();
                if (this.validSelection(uri)) {
                    this.setLocalStorage(key, uri);
                    return false;
                }
                else {
                    log.info("the uri '" + uri + "' is not valid for this selection");
                    var defaultPath = this.getLocalStorage(key);
                    if (!defaultPath || !this.validSelection(defaultPath)) {
                        defaultPath = null;
                        angular.forEach(this.subLevelTabs, function (tab) {
                            var fn = tab.isValid;
                            if (!defaultPath && tab.href && angular.isDefined(fn) && fn(workspace)) {
                                defaultPath = tab.href();
                            }
                        });
                    }
                    if (!defaultPath) {
                        defaultPath = "#/jmx/help";
                    }
                    log.info("moving the URL to be " + defaultPath);
                    if (defaultPath.startsWith("#")) {
                        defaultPath = defaultPath.substring(1);
                    }
                    this.$location.path(defaultPath);
                    return true;
                }
            }
            else {
                return false;
            }
        };
        Workspace.prototype.updateSelectionNode = function (node) {
            var originalSelection = this.selection;
            this.selection = node;
            var key = null;
            if (node) {
                key = node['key'];
            }
            var $location = this.$location;
            var q = $location.search();
            if (key) {
                q['nid'] = key;
            }
            $location.search(q);
            if (originalSelection) {
                key = this.selectionViewConfigKey();
                if (key) {
                    var defaultPath = this.getLocalStorage(key);
                    if (defaultPath) {
                        this.$location.path(defaultPath);
                    }
                }
            }
        };
        Workspace.prototype.redrawTree = function () {
            var treeElement = this.treeElement;
            if (treeElement && angular.isDefined(treeElement.dynatree) && angular.isFunction(treeElement.dynatree)) {
                var node = treeElement.dynatree("getTree");
                if (angular.isDefined(node)) {
                    try {
                        node.reload();
                    }
                    catch (e) {
                    }
                }
            }
        };
        Workspace.prototype.expandSelection = function (flag) {
            var treeElement = this.treeElement;
            if (treeElement && angular.isDefined(treeElement.dynatree) && angular.isFunction(treeElement.dynatree)) {
                var node = treeElement.dynatree("getActiveNode");
                if (angular.isDefined(node)) {
                    node.expand(flag);
                }
            }
        };
        Workspace.prototype.matchesProperties = function (entries, properties) {
            if (!entries)
                return false;
            for (var key in properties) {
                var value = properties[key];
                if (!value || entries[key] !== value) {
                    return false;
                }
            }
            return true;
        };
        Workspace.prototype.hasInvokeRightsForName = function (objectName) {
            var methods = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                methods[_i - 1] = arguments[_i];
            }
            var canInvoke = true;
            if (objectName) {
                var mbean = Core.parseMBean(objectName);
                if (mbean) {
                    var mbeanFolder = this.findMBeanWithProperties(mbean.domain, mbean.attributes);
                    if (mbeanFolder) {
                        return this.hasInvokeRights.apply(this, [mbeanFolder].concat(methods));
                    }
                    else {
                        log.debug("Failed to find mbean folder with name " + objectName);
                    }
                }
                else {
                    log.debug("Failed to parse mbean name " + objectName);
                }
            }
            return canInvoke;
        };
        Workspace.prototype.hasInvokeRights = function (selection) {
            var methods = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                methods[_i - 1] = arguments[_i];
            }
            var canInvoke = true;
            if (selection) {
                var selectionFolder = selection;
                var mbean = selectionFolder.mbean;
                if (mbean) {
                    if (angular.isDefined(mbean.canInvoke)) {
                        canInvoke = mbean.canInvoke;
                    }
                    if (canInvoke && methods && methods.length > 0) {
                        var opsByString = mbean['opByString'];
                        var ops = mbean['op'];
                        if (opsByString && ops) {
                            methods.forEach(function (method) {
                                if (!canInvoke) {
                                    return;
                                }
                                var op = null;
                                if (method.endsWith(')')) {
                                    op = opsByString[method];
                                }
                                else {
                                    op = ops[method];
                                }
                                if (!op) {
                                    log.debug("Could not find method:", method, " to check permissions, skipping");
                                    return;
                                }
                                if (angular.isDefined(op.canInvoke)) {
                                    canInvoke = op.canInvoke;
                                }
                            });
                        }
                    }
                }
            }
            return canInvoke;
        };
        Workspace.prototype.treeContainsDomainAndProperties = function (domainName, properties) {
            var _this = this;
            if (properties === void 0) { properties = null; }
            var workspace = this;
            var tree = workspace.tree;
            if (tree) {
                var folder = tree.get(domainName);
                if (folder) {
                    if (properties) {
                        var children = folder.children || [];
                        var checkProperties = function (node) {
                            if (!_this.matchesProperties(node.entries, properties)) {
                                if (node.domain === domainName && node.children && node.children.length > 0) {
                                    return node.children.some(checkProperties);
                                }
                                else {
                                    return false;
                                }
                            }
                            else {
                                return true;
                            }
                        };
                        return children.some(checkProperties);
                    }
                    return true;
                }
                else {
                }
            }
            else {
            }
            return false;
        };
        Workspace.prototype.matches = function (folder, properties, propertiesCount) {
            if (folder) {
                var entries = folder.entries;
                if (properties) {
                    if (!entries)
                        return false;
                    for (var key in properties) {
                        var value = properties[key];
                        if (!value || entries[key] !== value) {
                            return false;
                        }
                    }
                }
                if (propertiesCount) {
                    return entries && Object.keys(entries).length === propertiesCount;
                }
                return true;
            }
            return false;
        };
        Workspace.prototype.hasDomainAndProperties = function (domainName, properties, propertiesCount) {
            if (properties === void 0) { properties = null; }
            if (propertiesCount === void 0) { propertiesCount = null; }
            var node = this.selection;
            if (node) {
                return this.matches(node, properties, propertiesCount) && node.domain === domainName;
            }
            return false;
        };
        Workspace.prototype.findMBeanWithProperties = function (domainName, properties, propertiesCount) {
            if (properties === void 0) { properties = null; }
            if (propertiesCount === void 0) { propertiesCount = null; }
            var tree = this.tree;
            if (tree) {
                return this.findChildMBeanWithProperties(tree.get(domainName), properties, propertiesCount);
            }
            return null;
        };
        Workspace.prototype.findChildMBeanWithProperties = function (folder, properties, propertiesCount) {
            var _this = this;
            if (properties === void 0) { properties = null; }
            if (propertiesCount === void 0) { propertiesCount = null; }
            var workspace = this;
            if (folder) {
                var children = folder.children;
                if (children) {
                    var answer = children.find(function (node) { return _this.matches(node, properties, propertiesCount); });
                    if (answer) {
                        return answer;
                    }
                    return children.map(function (node) { return workspace.findChildMBeanWithProperties(node, properties, propertiesCount); }).find(function (node) { return node; });
                }
            }
            return null;
        };
        Workspace.prototype.selectionHasDomainAndLastFolderName = function (objectName, lastName) {
            var lastNameLower = (lastName || "").toLowerCase();
            function isName(name) {
                return (name || "").toLowerCase() === lastNameLower;
            }
            var node = this.selection;
            if (node) {
                if (objectName === node.domain) {
                    var folders = node.folderNames;
                    if (folders) {
                        var last = folders.last();
                        return (isName(last) || isName(node.title)) && node.isFolder() && !node.objectName;
                    }
                }
            }
            return false;
        };
        Workspace.prototype.selectionHasDomain = function (domainName) {
            var node = this.selection;
            if (node) {
                return domainName === node.domain;
            }
            return false;
        };
        Workspace.prototype.selectionHasDomainAndType = function (objectName, typeName) {
            var node = this.selection;
            if (node) {
                return objectName === node.domain && typeName === node.typeName;
            }
            return false;
        };
        Workspace.prototype.hasMBeans = function () {
            var answer = false;
            var tree = this.tree;
            if (tree) {
                var children = tree.children;
                if (angular.isArray(children) && children.length > 0) {
                    answer = true;
                }
            }
            return answer;
        };
        Workspace.prototype.hasFabricMBean = function () {
            return this.hasDomainAndProperties('io.fabric8', { type: 'Fabric' });
        };
        Workspace.prototype.isFabricFolder = function () {
            return this.hasDomainAndProperties('io.fabric8');
        };
        Workspace.prototype.isCamelContext = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'context' });
        };
        Workspace.prototype.isCamelFolder = function () {
            return this.hasDomainAndProperties('org.apache.camel');
        };
        Workspace.prototype.isEndpointsFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'endpoints');
        };
        Workspace.prototype.isEndpoint = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'endpoints' });
        };
        Workspace.prototype.isRoutesFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'routes');
        };
        Workspace.prototype.isRoute = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'routes' });
        };
        Workspace.prototype.isOsgiFolder = function () {
            return this.hasDomainAndProperties('osgi.core');
        };
        Workspace.prototype.isKarafFolder = function () {
            return this.hasDomainAndProperties('org.apache.karaf');
        };
        Workspace.prototype.isOsgiCompendiumFolder = function () {
            return this.hasDomainAndProperties('osgi.compendium');
        };
        return Workspace;
    })();
    Core.Workspace = Workspace;
})(Core || (Core = {}));
var Workspace = (function (_super) {
    __extends(Workspace, _super);
    function Workspace() {
        _super.apply(this, arguments);
    }
    return Workspace;
})(Core.Workspace);
;
var UI;
(function (UI) {
    UI.colors = ["#5484ED", "#A4BDFC", "#46D6DB", "#7AE7BF", "#51B749", "#FBD75B", "#FFB878", "#FF887C", "#DC2127", "#DBADFF", "#E1E1E1"];
})(UI || (UI = {}));
var Core;
(function (Core) {
    Core.log = Logger.get("Core");
    Core.lazyLoaders = {};
})(Core || (Core = {}));
var numberTypeNames = {
    'byte': true,
    'short': true,
    'int': true,
    'long': true,
    'float': true,
    'double': true,
    'java.lang.byte': true,
    'java.lang.short': true,
    'java.lang.integer': true,
    'java.lang.long': true,
    'java.lang.float': true,
    'java.lang.double': true
};
function lineCount(value) {
    var rows = 0;
    if (value) {
        rows = 1;
        value.toString().each(/\n/, function () { return rows++; });
    }
    return rows;
}
function safeNull(value) {
    if (typeof value === 'boolean') {
        return value;
    }
    else if (typeof value === 'number') {
        return value;
    }
    if (value) {
        return value;
    }
    else {
        return "";
    }
}
function safeNullAsString(value, type) {
    if (typeof value === 'boolean') {
        return "" + value;
    }
    else if (typeof value === 'number') {
        return "" + value;
    }
    else if (typeof value === 'string') {
        return "" + value;
    }
    else if (type === 'javax.management.openmbean.CompositeData' || type === '[Ljavax.management.openmbean.CompositeData;' || type === 'java.util.Map') {
        var data = angular.toJson(value, true);
        return data;
    }
    else if (type === 'javax.management.ObjectName') {
        return "" + (value == null ? "" : value.canonicalName);
    }
    else if (type === 'javax.management.openmbean.TabularData') {
        var arr = [];
        for (var key in value) {
            var val = value[key];
            var line = "" + key + "=" + val;
            arr.push(line);
        }
        arr = arr.sortBy(function (row) { return row.toString(); });
        return arr.join("\n");
    }
    else if (angular.isArray(value)) {
        return value.join("\n");
    }
    else if (value) {
        return "" + value;
    }
    else {
        return "";
    }
}
function toSearchArgumentArray(value) {
    if (value) {
        if (angular.isArray(value))
            return value;
        if (angular.isString(value))
            return value.split(',');
    }
    return [];
}
function folderMatchesPatterns(node, patterns) {
    if (node) {
        var folderNames = node.folderNames;
        if (folderNames) {
            return patterns.any(function (ignorePaths) {
                for (var i = 0; i < ignorePaths.length; i++) {
                    var folderName = folderNames[i];
                    var ignorePath = ignorePaths[i];
                    if (!folderName)
                        return false;
                    var idx = ignorePath.indexOf(folderName);
                    if (idx < 0) {
                        return false;
                    }
                }
                return true;
            });
        }
    }
    return false;
}
function scopeStoreJolokiaHandle($scope, jolokia, jolokiaHandle) {
    if (jolokiaHandle) {
        $scope.$on('$destroy', function () {
            closeHandle($scope, jolokia);
        });
        $scope.jolokiaHandle = jolokiaHandle;
    }
}
function closeHandle($scope, jolokia) {
    var jolokiaHandle = $scope.jolokiaHandle;
    if (jolokiaHandle) {
        jolokia.unregister(jolokiaHandle);
        $scope.jolokiaHandle = null;
    }
}
function onSuccess(fn, options) {
    if (options === void 0) { options = {}; }
    options['mimeType'] = 'application/json';
    if (angular.isDefined(fn)) {
        options['success'] = fn;
    }
    if (!options['method']) {
        options['method'] = "POST";
    }
    options['canonicalNaming'] = false;
    options['canonicalProperties'] = false;
    if (!options['error']) {
        options['error'] = function (response) {
            Core.defaultJolokiaErrorHandler(response, options);
        };
    }
    return options;
}
function supportsLocalStorage() {
    try {
        return 'localStorage' in window && window['localStorage'] !== null;
    }
    catch (e) {
        return false;
    }
}
function isNumberTypeName(typeName) {
    if (typeName) {
        var text = typeName.toString().toLowerCase();
        var flag = numberTypeNames[text];
        return flag;
    }
    return false;
}
function encodeMBeanPath(mbean) {
    return mbean.replace(/\//g, '!/').replace(':', '/').escapeURL();
}
function escapeMBeanPath(mbean) {
    return mbean.replace(/\//g, '!/').replace(':', '/');
}
function encodeMBean(mbean) {
    return mbean.replace(/\//g, '!/').escapeURL();
}
function escapeDots(text) {
    return text.replace(/\./g, '-');
}
function escapeTreeCssStyles(text) {
    return escapeDots(text).replace(/span/g, 'sp-an');
}
function showLogPanel() {
    var log = $("#log-panel");
    var body = $('body');
    localStorage['showLog'] = 'true';
    log.css({ 'bottom': '50%' });
    body.css({
        'overflow-y': 'hidden'
    });
}
function logLevelClass(level) {
    if (level) {
        var first = level[0];
        if (first === 'w' || first === "W") {
            return "warning";
        }
        else if (first === 'e' || first === "E") {
            return "error";
        }
        else if (first === 'i' || first === "I") {
            return "info";
        }
        else if (first === 'd' || first === "D") {
            return "";
        }
    }
    return "";
}
var Core;
(function (Core) {
    function toPath(hashUrl) {
        if (Core.isBlank(hashUrl)) {
            return hashUrl;
        }
        if (hashUrl.startsWith("#")) {
            return hashUrl.substring(1);
        }
        else {
            return hashUrl;
        }
    }
    Core.toPath = toPath;
    function parseMBean(mbean) {
        var answer = {};
        var parts = mbean.split(":");
        if (parts.length > 1) {
            answer['domain'] = parts.first();
            parts = parts.exclude(parts.first());
            parts = parts.join(":");
            answer['attributes'] = {};
            var nameValues = parts.split(",");
            nameValues.forEach(function (str) {
                var nameValue = str.split('=');
                var name = nameValue.first().trim();
                nameValue = nameValue.exclude(nameValue.first());
                answer['attributes'][name] = nameValue.join('=').trim();
            });
        }
        return answer;
    }
    Core.parseMBean = parseMBean;
    function executePostLoginTasks() {
        Core.log.debug("Executing post login tasks");
        Core.postLoginTasks.reset();
        Core.postLoginTasks.execute();
    }
    Core.executePostLoginTasks = executePostLoginTasks;
    function executePreLogoutTasks(onComplete) {
        Core.log.debug("Executing pre logout tasks");
        Core.preLogoutTasks.onComplete(onComplete);
        Core.preLogoutTasks.execute();
    }
    Core.executePreLogoutTasks = executePreLogoutTasks;
    function logout(jolokiaUrl, userDetails, localStorage, $scope, successCB, errorCB) {
        if (successCB === void 0) { successCB = null; }
        if (errorCB === void 0) { errorCB = null; }
        if (jolokiaUrl) {
            var url = "auth/logout/";
            Core.executePreLogoutTasks(function () {
                $.ajax(url, {
                    type: "POST",
                    success: function () {
                        userDetails.username = null;
                        userDetails.password = null;
                        userDetails.loginDetails = null;
                        userDetails.rememberMe = false;
                        delete localStorage['userDetails'];
                        var jvmConnect = angular.fromJson(localStorage['jvmConnect']);
                        _.each(jvmConnect, function (value) {
                            delete value['userName'];
                            delete value['password'];
                        });
                        localStorage.setItem('jvmConnect', angular.toJson(jvmConnect));
                        localStorage.removeItem('activemqUserName');
                        localStorage.removeItem('activemqPassword');
                        if (successCB && angular.isFunction(successCB)) {
                            successCB();
                        }
                        Core.$apply($scope);
                    },
                    error: function (xhr, textStatus, error) {
                        userDetails.username = null;
                        userDetails.password = null;
                        userDetails.loginDetails = null;
                        userDetails.rememberMe = false;
                        delete localStorage['userDetails'];
                        var jvmConnect = angular.fromJson(localStorage['jvmConnect']);
                        _.each(jvmConnect, function (value) {
                            delete value['userName'];
                            delete value['password'];
                        });
                        localStorage.setItem('jvmConnect', angular.toJson(jvmConnect));
                        localStorage.removeItem('activemqUserName');
                        localStorage.removeItem('activemqPassword');
                        switch (xhr.status) {
                            case 401:
                                Core.log.debug('Failed to log out, ', error);
                                break;
                            case 403:
                                Core.log.debug('Failed to log out, ', error);
                                break;
                            case 0:
                                break;
                            default:
                                Core.log.debug('Failed to log out, ', error);
                                break;
                        }
                        if (errorCB && angular.isFunction(errorCB)) {
                            errorCB();
                        }
                        Core.$apply($scope);
                    }
                });
            });
        }
    }
    Core.logout = logout;
    function createHref($location, href, removeParams) {
        if (removeParams === void 0) { removeParams = null; }
        var hashMap = angular.copy($location.search());
        if (removeParams) {
            angular.forEach(removeParams, function (param) { return delete hashMap[param]; });
        }
        var hash = Core.hashToString(hashMap);
        if (hash) {
            var prefix = (href.indexOf("?") >= 0) ? "&" : "?";
            href += prefix + hash;
        }
        return href;
    }
    Core.createHref = createHref;
    function hashToString(hash) {
        var keyValuePairs = [];
        angular.forEach(hash, function (value, key) {
            keyValuePairs.push(key + "=" + value);
        });
        var params = keyValuePairs.join("&");
        return encodeURI(params);
    }
    Core.hashToString = hashToString;
    function stringToHash(hashAsString) {
        var entries = {};
        if (hashAsString) {
            var text = decodeURI(hashAsString);
            var items = text.split('&');
            angular.forEach(items, function (item) {
                var kv = item.split('=');
                var key = kv[0];
                var value = kv[1] || key;
                entries[key] = value;
            });
        }
        return entries;
    }
    Core.stringToHash = stringToHash;
    function registerForChanges(jolokia, $scope, arguments, callback, options) {
        var decorated = {
            responseJson: '',
            success: function (response) {
                var json = angular.toJson(response.value);
                if (decorated.responseJson !== json) {
                    decorated.responseJson = json;
                    callback(response);
                }
            }
        };
        angular.extend(decorated, options);
        return Core.register(jolokia, $scope, arguments, onSuccess(undefined, decorated));
    }
    Core.registerForChanges = registerForChanges;
    var responseHistory = null;
    function getOrInitObjectFromLocalStorage(key) {
        var answer = undefined;
        if (!(key in localStorage)) {
            localStorage[key] = angular.toJson({});
        }
        return angular.fromJson(localStorage[key]);
    }
    Core.getOrInitObjectFromLocalStorage = getOrInitObjectFromLocalStorage;
    function argumentsToString(arguments) {
        return StringHelpers.toString(arguments);
    }
    function keyForArgument(argument) {
        if (!('type' in argument)) {
            return null;
        }
        var answer = argument['type'];
        switch (answer.toLowerCase()) {
            case 'exec':
                answer += ':' + argument['mbean'] + ':' + argument['operation'];
                var argString = argumentsToString(argument['arguments']);
                if (!Core.isBlank(argString)) {
                    answer += ':' + argString;
                }
                break;
            case 'read':
                answer += ':' + argument['mbean'] + ':' + argument['attribute'];
                break;
            default:
                return null;
        }
        return answer;
    }
    function createResponseKey(arguments) {
        var answer = '';
        if (angular.isArray(arguments)) {
            answer = arguments.map(function (arg) {
                return keyForArgument(arg);
            }).join(':');
        }
        else {
            answer = keyForArgument(arguments);
        }
        return answer;
    }
    function getResponseHistory() {
        if (responseHistory === null) {
            responseHistory = {};
            Core.log.debug("Created response history", responseHistory);
        }
        return responseHistory;
    }
    Core.getResponseHistory = getResponseHistory;
    Core.MAX_RESPONSE_CACHE_SIZE = 20;
    function getOldestKey(responseHistory) {
        var oldest = null;
        var oldestKey = null;
        angular.forEach(responseHistory, function (value, key) {
            if (!value || !value.timestamp) {
                oldest = 0;
                oldestKey = key;
            }
            else if (oldest === null || value.timestamp < oldest) {
                oldest = value.timestamp;
                oldestKey = key;
            }
        });
        return oldestKey;
    }
    function addResponse(arguments, value) {
        var responseHistory = getResponseHistory();
        var key = createResponseKey(arguments);
        if (key === null) {
            Core.log.debug("key for arguments is null, not caching: ", StringHelpers.toString(arguments));
            return;
        }
        var keys = Object.extended(responseHistory).keys();
        if (keys.length >= Core.MAX_RESPONSE_CACHE_SIZE) {
            Core.log.debug("Cache limit (", Core.MAX_RESPONSE_CACHE_SIZE, ") met or  exceeded (", keys.length, "), trimming oldest response");
            var oldestKey = getOldestKey(responseHistory);
            if (oldestKey !== null) {
                Core.log.debug("Deleting key: ", oldestKey);
                delete responseHistory[oldestKey];
            }
            else {
                Core.log.debug("Got null key, could be a cache problem, wiping cache");
                keys.forEach(function (key) {
                    Core.log.debug("Deleting key: ", key);
                    delete responseHistory[key];
                });
            }
        }
        responseHistory[key] = value;
    }
    function getResponse(jolokia, arguments, callback) {
        var responseHistory = getResponseHistory();
        var key = createResponseKey(arguments);
        if (key === null) {
            jolokia.request(arguments, callback);
            return;
        }
        if (key in responseHistory && 'success' in callback) {
            var value = responseHistory[key];
            setTimeout(function () {
                callback['success'](value);
            }, 10);
        }
        else {
            Core.log.debug("Unable to find existing response for key: ", key);
            jolokia.request(arguments, callback);
        }
    }
    function register(jolokia, scope, arguments, callback) {
        if (!angular.isDefined(scope.$jhandle) || !angular.isArray(scope.$jhandle)) {
            scope.$jhandle = [];
        }
        else {
        }
        if (angular.isDefined(scope.$on)) {
            scope.$on('$destroy', function (event) {
                unregister(jolokia, scope);
            });
        }
        var handle = null;
        if ('success' in callback) {
            var cb = callback.success;
            var args = arguments;
            callback.success = function (response) {
                addResponse(args, response);
                cb(response);
            };
        }
        if (angular.isArray(arguments)) {
            if (arguments.length >= 1) {
                var args = [callback];
                angular.forEach(arguments, function (value) { return args.push(value); });
                var registerFn = jolokia.register;
                handle = registerFn.apply(jolokia, args);
                scope.$jhandle.push(handle);
                getResponse(jolokia, arguments, callback);
            }
        }
        else {
            handle = jolokia.register(callback, arguments);
            scope.$jhandle.push(handle);
            getResponse(jolokia, arguments, callback);
        }
        return function () {
            if (handle !== null) {
                scope.$jhandle.remove(handle);
                jolokia.unregister(handle);
            }
        };
    }
    Core.register = register;
    function unregister(jolokia, scope) {
        if (angular.isDefined(scope.$jhandle)) {
            scope.$jhandle.forEach(function (handle) {
                jolokia.unregister(handle);
            });
            delete scope.$jhandle;
        }
    }
    Core.unregister = unregister;
    function defaultJolokiaErrorHandler(response, options) {
        if (options === void 0) { options = {}; }
        var stacktrace = response.stacktrace;
        if (stacktrace) {
            var silent = options['silent'];
            if (!silent) {
                var operation = Core.pathGet(response, ['request', 'operation']) || "unknown";
                if (stacktrace.indexOf("javax.management.InstanceNotFoundException") >= 0 || stacktrace.indexOf("javax.management.AttributeNotFoundException") >= 0 || stacktrace.indexOf("java.lang.IllegalArgumentException: No operation") >= 0) {
                    Core.log.debug("Operation ", operation, " failed due to: ", response['error']);
                }
                else {
                    Core.log.warn("Operation ", operation, " failed due to: ", response['error']);
                }
            }
            else {
                Core.log.debug("Operation ", operation, " failed due to: ", response['error']);
            }
        }
    }
    Core.defaultJolokiaErrorHandler = defaultJolokiaErrorHandler;
    function logJolokiaStackTrace(response) {
        var stacktrace = response.stacktrace;
        if (stacktrace) {
            var operation = Core.pathGet(response, ['request', 'operation']) || "unknown";
            Core.log.info("Operation ", operation, " failed due to: ", response['error']);
        }
    }
    Core.logJolokiaStackTrace = logJolokiaStackTrace;
    function xmlNodeToString(xmlNode) {
        try {
            return (new XMLSerializer()).serializeToString(xmlNode);
        }
        catch (e) {
            try {
                return xmlNode.xml;
            }
            catch (e) {
                console.log('WARNING: XMLSerializer not supported');
            }
        }
        return false;
    }
    Core.xmlNodeToString = xmlNodeToString;
    function isTextNode(node) {
        return node && node.nodeType === 3;
    }
    Core.isTextNode = isTextNode;
    function fileExtension(name, defaultValue) {
        if (defaultValue === void 0) { defaultValue = ""; }
        var extension = defaultValue;
        if (name) {
            var idx = name.lastIndexOf(".");
            if (idx > 0) {
                extension = name.substring(idx + 1, name.length).toLowerCase();
            }
        }
        return extension;
    }
    Core.fileExtension = fileExtension;
    function getUUID() {
        var d = new Date();
        var ms = (d.getTime() * 1000) + d.getUTCMilliseconds();
        var random = Math.floor((1 + Math.random()) * 0x10000);
        return ms.toString(16) + random.toString(16);
    }
    Core.getUUID = getUUID;
    var _versionRegex = /[^\d]*(\d+)\.(\d+)(\.(\d+))?.*/;
    function parseVersionNumbers(text) {
        if (text) {
            var m = text.match(_versionRegex);
            if (m && m.length > 4) {
                var m1 = m[1];
                var m2 = m[2];
                var m4 = m[4];
                if (angular.isDefined(m4)) {
                    return [parseInt(m1), parseInt(m2), parseInt(m4)];
                }
                else if (angular.isDefined(m2)) {
                    return [parseInt(m1), parseInt(m2)];
                }
                else if (angular.isDefined(m1)) {
                    return [parseInt(m1)];
                }
            }
        }
        return null;
    }
    Core.parseVersionNumbers = parseVersionNumbers;
    function versionToSortableString(version, maxDigitsBetweenDots) {
        if (maxDigitsBetweenDots === void 0) { maxDigitsBetweenDots = 4; }
        return (version || "").split(".").map(function (x) {
            var length = x.length;
            return (length >= maxDigitsBetweenDots) ? x : x.padLeft(' ', maxDigitsBetweenDots - length);
        }).join(".");
    }
    Core.versionToSortableString = versionToSortableString;
    function time(message, fn) {
        var start = new Date().getTime();
        var answer = fn();
        var elapsed = new Date().getTime() - start;
        console.log(message + " " + elapsed);
        return answer;
    }
    Core.time = time;
    function compareVersionNumberArrays(v1, v2) {
        if (v1 && !v2) {
            return 1;
        }
        if (!v1 && v2) {
            return -1;
        }
        if (v1 === v2) {
            return 0;
        }
        for (var i = 0; i < v1.length; i++) {
            var n1 = v1[i];
            if (i >= v2.length) {
                return 1;
            }
            var n2 = v2[i];
            if (!angular.isDefined(n1)) {
                return -1;
            }
            if (!angular.isDefined(n2)) {
                return 1;
            }
            if (n1 > n2) {
                return 1;
            }
            else if (n1 < n2) {
                return -1;
            }
        }
        return 0;
    }
    Core.compareVersionNumberArrays = compareVersionNumberArrays;
    function valueToHtml(value) {
        if (angular.isArray(value)) {
            var size = value.length;
            if (!size) {
                return "";
            }
            else if (size === 1) {
                return valueToHtml(value[0]);
            }
            else {
                var buffer = "<ul>";
                angular.forEach(value, function (childValue) {
                    buffer += "<li>" + valueToHtml(childValue) + "</li>";
                });
                return buffer + "</ul>";
            }
        }
        else if (angular.isObject(value)) {
            var buffer = "<table>";
            angular.forEach(value, function (childValue, key) {
                buffer += "<tr><td>" + key + "</td><td>" + valueToHtml(childValue) + "</td></tr>";
            });
            return buffer + "</table>";
        }
        else if (angular.isString(value)) {
            var uriPrefixes = ["http://", "https://", "file://", "mailto:"];
            var answer = value;
            angular.forEach(uriPrefixes, function (prefix) {
                if (answer.startsWith(prefix)) {
                    answer = "<a href='" + value + "'>" + value + "</a>";
                }
            });
            return answer;
        }
        return value;
    }
    Core.valueToHtml = valueToHtml;
    function tryParseJson(text) {
        text = text.trim();
        if ((text.startsWith("[") && text.endsWith("]")) || (text.startsWith("{") && text.endsWith("}"))) {
            try {
                return JSON.parse(text);
            }
            catch (e) {
            }
        }
        return null;
    }
    Core.tryParseJson = tryParseJson;
    function maybePlural(count, word) {
        var pluralWord = (count === 1) ? word : word.pluralize();
        return "" + count + " " + pluralWord;
    }
    Core.maybePlural = maybePlural;
    function objectNameProperties(objectName) {
        var entries = {};
        if (objectName) {
            var idx = objectName.indexOf(":");
            if (idx > 0) {
                var path = objectName.substring(idx + 1);
                var items = path.split(',');
                angular.forEach(items, function (item) {
                    var kv = item.split('=');
                    var key = kv[0];
                    var value = kv[1] || key;
                    entries[key] = value;
                });
            }
        }
        return entries;
    }
    Core.objectNameProperties = objectNameProperties;
    function setPageTitle($document, title) {
        $document.attr('title', title.getTitleWithSeparator(' '));
    }
    Core.setPageTitle = setPageTitle;
    function setPageTitleWithTab($document, title, tab) {
        $document.attr('title', title.getTitleWithSeparator(' ') + " " + tab);
    }
    Core.setPageTitleWithTab = setPageTitleWithTab;
    function getMBeanTypeFolder(workspace, domain, typeName) {
        if (workspace) {
            var mbeanTypesToDomain = workspace.mbeanTypesToDomain || {};
            var types = mbeanTypesToDomain[typeName] || {};
            var answer = types[domain];
            if (angular.isArray(answer) && answer.length) {
                return answer[0];
            }
            return answer;
        }
        return null;
    }
    Core.getMBeanTypeFolder = getMBeanTypeFolder;
    function getMBeanTypeObjectName(workspace, domain, typeName) {
        var folder = Core.getMBeanTypeFolder(workspace, domain, typeName);
        return Core.pathGet(folder, ["objectName"]);
    }
    Core.getMBeanTypeObjectName = getMBeanTypeObjectName;
    function toSafeDomID(text) {
        return text ? text.replace(/(\/|\.)/g, "_") : text;
    }
    Core.toSafeDomID = toSafeDomID;
    function forEachLeafFolder(folders, fn) {
        angular.forEach(folders, function (folder) {
            var children = folder["children"];
            if (angular.isArray(children) && children.length > 0) {
                forEachLeafFolder(children, fn);
            }
            else {
                fn(folder);
            }
        });
    }
    Core.forEachLeafFolder = forEachLeafFolder;
    function extractHashURL(url) {
        var parts = url.split('#');
        if (parts.length === 0) {
            return url;
        }
        var answer = parts[1];
        if (parts.length > 1) {
            var remaining = parts.last(parts.length - 2);
            remaining.forEach(function (part) {
                answer = answer + "#" + part;
            });
        }
        return answer;
    }
    Core.extractHashURL = extractHashURL;
    function authHeaderValue(userDetails) {
        return getBasicAuthHeader(userDetails.username, userDetails.password);
    }
    Core.authHeaderValue = authHeaderValue;
    function getBasicAuthHeader(username, password) {
        var authInfo = username + ":" + password;
        authInfo = authInfo.encodeBase64();
        return "Basic " + authInfo;
    }
    Core.getBasicAuthHeader = getBasicAuthHeader;
    var httpRegex = new RegExp('^(https?):\/\/(([^:/?#]*)(?::([0-9]+))?)');
    function parseUrl(url) {
        if (Core.isBlank(url)) {
            return null;
        }
        var matches = url.match(httpRegex);
        if (matches === null) {
            return null;
        }
        var scheme = matches[1];
        var host = matches[3];
        var port = matches[4];
        var parts = null;
        if (!Core.isBlank(port)) {
            parts = url.split(port);
        }
        else {
            parts = url.split(host);
        }
        var path = parts[1];
        if (path && path.startsWith('/')) {
            path = path.slice(1, path.length);
        }
        return {
            scheme: scheme,
            host: host,
            port: port,
            path: path
        };
    }
    Core.parseUrl = parseUrl;
    function getDocHeight() {
        var D = document;
        return Math.max(Math.max(D.body.scrollHeight, D.documentElement.scrollHeight), Math.max(D.body.offsetHeight, D.documentElement.offsetHeight), Math.max(D.body.clientHeight, D.documentElement.clientHeight));
    }
    Core.getDocHeight = getDocHeight;
    function useProxyIfExternal(connectUrl) {
        if (Core.isChromeApp()) {
            return connectUrl;
        }
        var host = window.location.host;
        if (!connectUrl.startsWith("http://" + host + "/") && !connectUrl.startsWith("https://" + host + "/")) {
            var idx = connectUrl.indexOf("://");
            if (idx > 0) {
                connectUrl = connectUrl.substring(idx + 3);
            }
            connectUrl = connectUrl.replace(":", "/");
            connectUrl = Core.trimLeading(connectUrl, "/");
            connectUrl = Core.trimTrailing(connectUrl, "/");
            connectUrl = Core.url("/proxy/" + connectUrl);
        }
        return connectUrl;
    }
    Core.useProxyIfExternal = useProxyIfExternal;
    function getRecentConnections(localStorage) {
        if (Core.isBlank(localStorage['recentConnections'])) {
            Core.clearConnections();
        }
        return angular.fromJson(localStorage['recentConnections']);
    }
    Core.getRecentConnections = getRecentConnections;
    function addRecentConnection(localStorage, name) {
        var recent = getRecentConnections(localStorage);
        recent = recent.add(name).unique().first(5);
        localStorage['recentConnections'] = angular.toJson(recent);
    }
    Core.addRecentConnection = addRecentConnection;
    function removeRecentConnection(localStorage, name) {
        var recent = getRecentConnections(localStorage);
        recent = recent.exclude(function (n) {
            return n === name;
        });
        localStorage['recentConnections'] = angular.toJson(recent);
    }
    Core.removeRecentConnection = removeRecentConnection;
    function clearConnections() {
        localStorage['recentConnections'] = '[]';
    }
    Core.clearConnections = clearConnections;
    function saveConnection(options) {
        var connectionMap = Core.loadConnectionMap();
        var clone = Object.clone(options);
        delete clone.userName;
        delete clone.password;
        connectionMap[options.name] = clone;
        Core.saveConnectionMap(connectionMap);
    }
    Core.saveConnection = saveConnection;
    function connectToServer(localStorage, options) {
        Core.log.debug("Connecting with options: ", StringHelpers.toString(options));
        addRecentConnection(localStorage, options.name);
        if (!('userName' in options)) {
            var userDetails = Core.injector.get('userDetails');
            options.userName = userDetails.username;
            options.password = userDetails.password;
        }
        saveConnection(options);
        var $window = Core.injector.get('$window');
        var url = (options.view || '#/welcome') + '?con=' + options.name;
        url = url.replace(/\?/g, "&");
        url = url.replace(/&/, "?");
        var newWindow = $window.open(url);
        newWindow['con'] = options.name;
        $window['passUserDetails'] = {
            username: options.userName,
            password: options.password,
            loginDetails: {}
        };
    }
    Core.connectToServer = connectToServer;
    function extractTargetUrl($location, scheme, port) {
        if (angular.isUndefined(scheme)) {
            scheme = $location.scheme();
        }
        var host = $location.host();
        var qUrl = $location.absUrl();
        var idx = qUrl.indexOf("url=");
        if (idx > 0) {
            qUrl = qUrl.substr(idx + 4);
            var value = decodeURIComponent(qUrl);
            if (value) {
                idx = value.indexOf("/proxy/");
                if (idx > 0) {
                    value = value.substr(idx + 7);
                    idx = value.indexOf("://");
                    if (idx > 0) {
                        value = value.substr(idx + 3);
                    }
                    var data = value.split("/");
                    if (data.length >= 1) {
                        host = data[0];
                    }
                    if (angular.isUndefined(port) && data.length >= 2) {
                        var qPort = Core.parseIntValue(data[1], "port number");
                        if (qPort) {
                            port = qPort;
                        }
                    }
                }
            }
        }
        if (angular.isUndefined(port)) {
            port = $location.port();
        }
        var url = scheme + "://" + host;
        if (port != 80) {
            url += ":" + port;
        }
        return url;
    }
    Core.extractTargetUrl = extractTargetUrl;
    function isProxyUrl($location) {
        var url = $location.url();
        return url.indexOf('/hawtio/proxy/') > 0;
    }
    Core.isProxyUrl = isProxyUrl;
    function doNothing(value) {
        return value;
    }
    Core.doNothing = doNothing;
    Core.bindModelToSearchParam = ControllerHelpers.bindModelToSearchParam;
    Core.reloadWhenParametersChange = ControllerHelpers.reloadWhenParametersChange;
    function createJolokia(url, username, password) {
        var jolokiaParams = {
            url: url,
            username: username,
            password: password,
            canonicalNaming: false,
            ignoreErrors: true,
            mimeType: 'application/json'
        };
        return new Jolokia(jolokiaParams);
    }
    Core.createJolokia = createJolokia;
    function throttled(fn, millis) {
        var nextInvokeTime = 0;
        var lastAnswer = null;
        return function () {
            var now = Date.now();
            if (nextInvokeTime < now) {
                nextInvokeTime = now + millis;
                lastAnswer = fn();
            }
            else {
            }
            return lastAnswer;
        };
    }
    Core.throttled = throttled;
    function parseJsonText(text, message) {
        if (message === void 0) { message = "JSON"; }
        var answer = null;
        try {
            answer = angular.fromJson(text);
        }
        catch (e) {
            Core.log.info("Failed to parse " + message + " from: " + text + ". " + e);
        }
        return answer;
    }
    Core.parseJsonText = parseJsonText;
    function humanizeValueHtml(value) {
        var formattedValue = "";
        if (value === true) {
            formattedValue = '<i class="icon-check"></i>';
        }
        else if (value === false) {
            formattedValue = '<i class="icon-check-empty"></i>';
        }
        else {
            formattedValue = Core.humanizeValue(value);
        }
        return formattedValue;
    }
    Core.humanizeValueHtml = humanizeValueHtml;
    function getQueryParameterValue(url, parameterName) {
        var parts;
        var query = (url || '').split('?');
        if (query && query.length > 0) {
            parts = query[1];
        }
        else {
            parts = '';
        }
        var vars = parts.split('&');
        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split('=');
            if (decodeURIComponent(pair[0]) == parameterName) {
                return decodeURIComponent(pair[1]);
            }
        }
        return null;
    }
    Core.getQueryParameterValue = getQueryParameterValue;
    function createRemoteWorkspace(remoteJolokia, $location, localStorage, $rootScope, $compile, $templateCache, userDetails) {
        if ($rootScope === void 0) { $rootScope = null; }
        if ($compile === void 0) { $compile = null; }
        if ($templateCache === void 0) { $templateCache = null; }
        if (userDetails === void 0) { userDetails = null; }
        var jolokiaStatus = {
            xhr: null
        };
        var jmxTreeLazyLoadRegistry = Core.lazyLoaders;
        var profileWorkspace = new Core.Workspace(remoteJolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope, userDetails);
        Core.log.info("Loading the profile using jolokia: " + remoteJolokia);
        profileWorkspace.loadTree();
        return profileWorkspace;
    }
    Core.createRemoteWorkspace = createRemoteWorkspace;
    function humanizeMilliseconds(value) {
        if (!angular.isNumber(value)) {
            return "XXX";
        }
        var seconds = value / 1000;
        var years = Math.floor(seconds / 31536000);
        if (years) {
            return maybePlural(years, "year");
        }
        var days = Math.floor((seconds %= 31536000) / 86400);
        if (days) {
            return maybePlural(days, "day");
        }
        var hours = Math.floor((seconds %= 86400) / 3600);
        if (hours) {
            return maybePlural(hours, 'hour');
        }
        var minutes = Math.floor((seconds %= 3600) / 60);
        if (minutes) {
            return maybePlural(minutes, 'minute');
        }
        seconds = Math.floor(seconds % 60);
        if (seconds) {
            return maybePlural(seconds, 'second');
        }
        return value + " ms";
    }
    Core.humanizeMilliseconds = humanizeMilliseconds;
    function storeConnectionRegex(regexs, name, json) {
        if (!regexs.any(function (r) {
            r['name'] === name;
        })) {
            var regex = '';
            if (json['useProxy']) {
                regex = '/hawtio/proxy/';
            }
            else {
                regex = '//';
            }
            regex += json['host'] + ':' + json['port'] + '/' + json['path'];
            regexs.push({
                name: name,
                regex: regex.escapeURL(true),
                color: UI.colors.sample()
            });
            writeRegexs(regexs);
        }
    }
    Core.storeConnectionRegex = storeConnectionRegex;
    function getRegexs() {
        var regexs = [];
        try {
            regexs = angular.fromJson(localStorage['regexs']);
        }
        catch (e) {
            delete localStorage['regexs'];
        }
        return regexs;
    }
    Core.getRegexs = getRegexs;
    function removeRegex(name) {
        var regexs = Core.getRegexs();
        var hasFunc = function (r) {
            return r['name'] === name;
        };
        if (regexs.any(hasFunc)) {
            regexs = regexs.exclude(hasFunc);
            Core.writeRegexs(regexs);
        }
    }
    Core.removeRegex = removeRegex;
    function writeRegexs(regexs) {
        localStorage['regexs'] = angular.toJson(regexs);
    }
    Core.writeRegexs = writeRegexs;
    function maskPassword(value) {
        if (value) {
            var text = '' + value;
            var userInfoPattern = "(.*://.*:)(.*)(@)";
            value = value.replace(new RegExp(userInfoPattern, 'i'), "$1xxxxxx$3");
        }
        return value;
    }
    Core.maskPassword = maskPassword;
    function matchFilterIgnoreCase(text, filter) {
        if (angular.isUndefined(text) || angular.isUndefined(filter)) {
            return true;
        }
        if (text == null || filter == null) {
            return true;
        }
        text = text.toString().trim().toLowerCase();
        filter = filter.toString().trim().toLowerCase();
        if (text.length === 0 || filter.length === 0) {
            return true;
        }
        var tokens = filter.split(",");
        tokens = tokens.filter(function (t) {
            return t.length > 0;
        }).map(function (t) {
            return t.trim();
        });
        var answer = tokens.some(function (t) {
            var bool = text.indexOf(t) > -1;
            return bool;
        });
        return answer;
    }
    Core.matchFilterIgnoreCase = matchFilterIgnoreCase;
})(Core || (Core = {}));
var IDE;
(function (IDE) {
    function getIdeMBean(workspace) {
        return Core.getMBeanTypeObjectName(workspace, "hawtio", "IdeFacade");
    }
    IDE.getIdeMBean = getIdeMBean;
    function isOpenInIdeaSupported(workspace, localStorage) {
        var value = localStorage["openInIDEA"];
        return value !== "false";
    }
    IDE.isOpenInIdeaSupported = isOpenInIdeaSupported;
    function isOpenInTextMateSupported(workspace, localStorage) {
        var value = localStorage["openInTextMate"];
        return value !== "false";
    }
    IDE.isOpenInTextMateSupported = isOpenInTextMateSupported;
    function findClassAbsoluteFileName(mbean, jolokia, localStorage, fileName, className, onResult) {
        var sourceRoots = [];
        var answer = null;
        if (mbean) {
            answer = jolokia.execute(mbean, "findClassAbsoluteFileName", fileName, className, sourceRoots, onSuccess(onResult));
        }
        else {
            onResult(answer);
        }
        return answer;
    }
    IDE.findClassAbsoluteFileName = findClassAbsoluteFileName;
    function asNumber(value, defaultValue) {
        if (defaultValue === void 0) { defaultValue = 0; }
        if (angular.isNumber(value)) {
            return value;
        }
        else if (angular.isString(value)) {
            return parseInt(value);
        }
        else {
            return defaultValue;
        }
    }
    function max(v1, v2) {
        return (v1 >= v2) ? v1 : v2;
    }
    function ideaOpenAndNavigate(mbean, jolokia, absoluteFileName, line, column, fn) {
        if (fn === void 0) { fn = null; }
        var answer = null;
        if (mbean) {
            line = max(asNumber(line) - 1, 0);
            column = max(asNumber(column) - 1, 0);
            answer = jolokia.execute(mbean, "ideaOpenAndNavigate", absoluteFileName, line, column, onSuccess(fn));
        }
        return answer;
    }
    IDE.ideaOpenAndNavigate = ideaOpenAndNavigate;
})(IDE || (IDE = {}));
var IDE;
(function (IDE) {
    var log = Logger.get("IDE");
    var OpenInIdeDirective = (function () {
        function OpenInIdeDirective(localStorage, workspace, jolokia) {
            var _this = this;
            this.localStorage = localStorage;
            this.workspace = workspace;
            this.jolokia = jolokia;
            this.restrict = 'E';
            this.replace = true;
            this.transclude = false;
            this.scope = {
                fileName: '@',
                className: '@',
                line: '@',
                column: '@'
            };
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        OpenInIdeDirective.prototype.doLink = function ($scope, $element, $attrs) {
            var workspace = this.workspace;
            var jolokia = this.jolokia;
            var mbean = IDE.getIdeMBean(workspace);
            var fileName = $scope.fileName;
            if (mbean && fileName) {
                var className = $scope.className;
                var line = $scope.line;
                var col = $scope.col;
                if (!angular.isDefined(line) || line === null)
                    line = 0;
                if (!angular.isDefined(col) || col === null)
                    col = 0;
                if (IDE.isOpenInIdeaSupported(workspace, localStorage)) {
                    var ideaButton = $('<button class="btn btn-mini"><img src="app/ide/img/intellijidea.png" width="16" height="16"></button>');
                    function onResult(absoluteName) {
                        if (!absoluteName) {
                            log.info("Could not find file in source code: " + fileName + " class: " + className);
                            ideaButton.attr("title", "Could not find source file: " + fileName);
                        }
                        else {
                            ideaButton.attr("title", "Opening in IDEA: " + absoluteName);
                            IDE.ideaOpenAndNavigate(mbean, jolokia, absoluteName, line, col);
                        }
                    }
                    ideaButton.on("click", function () {
                        log.info("Finding local file name: " + fileName + " className: " + className);
                        IDE.findClassAbsoluteFileName(mbean, jolokia, localStorage, fileName, className, onResult);
                    });
                    $element.append(ideaButton);
                }
            }
        };
        return OpenInIdeDirective;
    })();
    IDE.OpenInIdeDirective = OpenInIdeDirective;
})(IDE || (IDE = {}));
var IDE;
(function (IDE) {
    var pluginName = 'ide';
    IDE._module = angular.module(pluginName, ['bootstrap', 'hawtioCore']);
    IDE._module.directive('hawtioOpenIde', ["localStorage", "workspace", "jolokia", function (localStorage, workspace, jolokia) {
        return new IDE.OpenInIdeDirective(localStorage, workspace, jolokia);
    }]);
    IDE._module.run(["helpRegistry", function (helpRegistry) {
        helpRegistry.addDevDoc('IDE', 'app/ide/doc/developer.md');
    }]);
    hawtioPluginLoader.addModule(pluginName);
})(IDE || (IDE = {}));
var Core;
(function (Core) {
    var PageTitle = (function () {
        function PageTitle() {
            this.titleElements = [];
        }
        PageTitle.prototype.addTitleElement = function (element) {
            this.titleElements.push(element);
        };
        PageTitle.prototype.getTitle = function () {
            return this.getTitleExcluding([], ' ');
        };
        PageTitle.prototype.getTitleWithSeparator = function (separator) {
            return this.getTitleExcluding([], separator);
        };
        PageTitle.prototype.getTitleExcluding = function (excludes, separator) {
            return this.getTitleArrayExcluding(excludes).join(separator);
        };
        PageTitle.prototype.getTitleArrayExcluding = function (excludes) {
            return this.titleElements.map(function (element) {
                var answer = '';
                if (element) {
                    answer = element();
                    if (answer === null) {
                        return '';
                    }
                }
                return answer;
            }).exclude(excludes).exclude('');
        };
        return PageTitle;
    })();
    Core.PageTitle = PageTitle;
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core.pluginName = 'hawtioCore';
    Core.templatePath = 'app/core/html/';
    Core.jolokiaUrl = Core.getJolokiaUrl();
    Logger.get("Core").debug("jolokiaUrl " + Core.jolokiaUrl);
    Core._module = angular.module(Core.pluginName, ['bootstrap', 'ngResource', 'ui', 'ui.bootstrap.dialog', 'hawtio-ui']);
    Core._module.config(["$locationProvider", "$routeProvider", "$dialogProvider", function ($locationProvider, $routeProvider, $dialogProvider) {
        $locationProvider.html5Mode(true);
        $dialogProvider.options({
            backdropFade: true,
            dialogFade: true
        });
        $routeProvider.when('/help', {
            redirectTo: '/help/index'
        }).when('/login', { templateUrl: Core.templatePath + 'login.html' }).when('/welcome', { templateUrl: Core.templatePath + 'welcome.html' }).when('/about', { templateUrl: Core.templatePath + 'about.html' }).when('/help/:topic/', { templateUrl: Core.templatePath + 'help.html' }).when('/help/:topic/:subtopic', { templateUrl: Core.templatePath + 'help.html' });
    }]);
    Core._module.constant('layoutTree', Core.templatePath + 'layoutTree.html');
    Core._module.constant('layoutFull', Core.templatePath + 'layoutFull.html');
    Core._module.filter("valueToHtml", function () { return Core.valueToHtml; });
    Core._module.filter('humanize', function () { return Core.humanizeValue; });
    Core._module.filter('humanizeMs', function () { return Core.humanizeMilliseconds; });
    Core._module.filter('maskPassword', function () { return Core.maskPassword; });
    Core._module.run(["$rootScope", "$routeParams", "jolokia", "workspace", "localStorage", "viewRegistry", "layoutFull", "helpRegistry", "pageTitle", "branding", "toastr", "metricsWatcher", "userDetails", "preferencesRegistry", "postLoginTasks", "preLogoutTasks", "$location", "ConnectOptions", "locationChangeStartTasks", "$http", "$route", function ($rootScope, $routeParams, jolokia, workspace, localStorage, viewRegistry, layoutFull, helpRegistry, pageTitle, branding, toastr, metricsWatcher, userDetails, preferencesRegistry, postLoginTasks, preLogoutTasks, $location, ConnectOptions, locationChangeStartTasks, $http, $route) {
        postLoginTasks.addTask("ResetPreLogoutTasks", function () {
            preLogoutTasks.reset();
        });
        preLogoutTasks.addTask("ResetPostLoginTasks", function () {
            postLoginTasks.reset();
        });
        $rootScope.lineCount = lineCount;
        $rootScope.params = $routeParams;
        $rootScope.is = function (type, value) {
            return angular['is' + type](value);
        };
        $rootScope.empty = function (value) {
            return $.isEmptyObject(value);
        };
        $rootScope.$on('UpdateRate', function (event, rate) {
            jolokia.stop();
            if (rate > 0) {
                jolokia.start(rate);
            }
            Logger.get("Core").debug("Set update rate to: ", rate);
        });
        $rootScope.$emit('UpdateRate', localStorage['updateRate']);
        $rootScope.$on('$locationChangeStart', function ($event, newUrl, oldUrl) {
            locationChangeStartTasks.execute($event, newUrl, oldUrl);
        });
        locationChangeStartTasks.addTask('ConParam', function ($event, newUrl, oldUrl) {
            if (!Core.injector) {
                return;
            }
            var $location = Core.injector.get('$location');
            var ConnectOptions = Core.injector.get('ConnectOptions');
            if (!ConnectOptions.name || !newUrl) {
                return;
            }
            var newQuery = $location.search();
            if (!newQuery.con) {
                Core.log.debug("Lost connection parameter (", ConnectOptions.name, ") from query params: ", newQuery, " resetting");
                newQuery['con'] = ConnectOptions.name;
                $location.search(newQuery);
            }
        });
        locationChangeStartTasks.addTask('UpdateSession', function () {
            Core.log.debug("Updating session expiry");
            $http({ method: 'post', url: 'refresh' }).success(function (data) {
                Core.log.debug("Updated session, response: ", data);
            }).error(function () {
                Core.log.debug("Failed to update session expiry");
            });
            Core.log.debug("Made request");
        });
        $rootScope.log = function (variable) {
            console.log(variable);
        };
        $rootScope.alert = function (text) {
            alert(text);
        };
        viewRegistry['fullscreen'] = layoutFull;
        viewRegistry['notree'] = layoutFull;
        viewRegistry['help'] = layoutFull;
        viewRegistry['welcome'] = layoutFull;
        viewRegistry['preferences'] = layoutFull;
        viewRegistry['about'] = layoutFull;
        viewRegistry['login'] = layoutFull;
        viewRegistry['ui'] = layoutFull;
        helpRegistry.addUserDoc('index', 'app/core/doc/overview.md');
        helpRegistry.addUserDoc('preferences', 'app/core/doc/preferences.md');
        helpRegistry.addSubTopic('index', 'faq', 'app/core/doc/FAQ.md');
        helpRegistry.addSubTopic('index', 'changes', 'app/core/doc/CHANGES.md');
        helpRegistry.addSubTopic('index', 'developer', 'app/core/doc/developer.md');
        helpRegistry.addDevDoc('Core', 'app/core/doc/coreDeveloper.md');
        helpRegistry.addDevDoc('UI', '#/ui/developerPage');
        helpRegistry.addDevDoc('datatable', 'app/datatable/doc/developer.md');
        helpRegistry.addDevDoc('Force Graph', 'app/forcegraph/doc/developer.md');
        preferencesRegistry.addTab("Core", "app/core/html/corePreferences.html");
        preferencesRegistry.addTab("Plugins", "app/core/html/pluginPreferences.html");
        preferencesRegistry.addTab("Console Logging", "app/core/html/loggingPreferences.html");
        preferencesRegistry.addTab("Editor", "app/ui/html/editorPreferences.html");
        preferencesRegistry.addTab("Jolokia", "app/core/html/jolokiaPreferences.html");
        preferencesRegistry.addTab("Reset", "app/core/html/resetPreferences.html");
        toastr.options = {
            'closeButton': true,
            'showMethod': 'slideDown',
            'hideMethod': 'slideUp'
        };
        var throttledError = {
            level: null,
            message: null,
            action: Core.throttled(function () {
                if (throttledError.level === "WARN") {
                    Core.notification('warning', throttledError.message);
                }
                if (throttledError.level === "ERROR") {
                    Core.notification('error', throttledError.message);
                }
            }, 500)
        };
        window['logInterceptors'].push(function (level, message) {
            throttledError.level = level;
            throttledError.message = message;
            throttledError.action();
        });
        setTimeout(function () {
            $("#main-body").fadeIn(2000).after(function () {
                Logger.get("Core").info(branding.appName + " started");
                Core.$apply($rootScope);
                $(window).trigger('resize');
                $route.reload();
            });
        }, 500);
    }]);
})(Core || (Core = {}));
hawtioPluginLoader.addUrl("plugin");
hawtioPluginLoader.addModule(Core.pluginName);
hawtioPluginLoader.addModule('angularFileUpload');
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    $.support.cors = true;
    nextTask();
});
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    $("a[title]").tooltip({
        selector: '',
        delay: { show: 1000, hide: 100 }
    });
    nextTask();
});
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    Core.adjustHeight();
    $(window).resize(Core.adjustHeight);
    nextTask();
});
hawtioPluginLoader.registerPreBootstrapTask(function (nextTask) {
    if (Core._module && Core.isChromeApp()) {
        Core._module.config([
            '$compileProvider',
            function ($compileProvider) {
                $compileProvider.urlSanitizationWhitelist(/^\s*(https?|ftp|mailto|chrome-extension):/);
            }
        ]);
    }
    nextTask();
});
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.pluginName = 'activemq';
    ActiveMQ._module = angular.module(ActiveMQ.pluginName, ['bootstrap', 'ngResource', 'ui.bootstrap.dialog', 'hawtioCore', 'camel', 'hawtio-ui']);
    ActiveMQ._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/activemq/browseQueue', { templateUrl: 'app/activemq/html/browseQueue.html' }).when('/activemq/diagram', { templateUrl: 'app/activemq/html/brokerDiagram.html', reloadOnSearch: false }).when('/activemq/createDestination', { templateUrl: 'app/activemq/html/createDestination.html' }).when('/activemq/createQueue', { templateUrl: 'app/activemq/html/createQueue.html' }).when('/activemq/createTopic', { templateUrl: 'app/activemq/html/createTopic.html' }).when('/activemq/deleteQueue', { templateUrl: 'app/activemq/html/deleteQueue.html' }).when('/activemq/deleteTopic', { templateUrl: 'app/activemq/html/deleteTopic.html' }).when('/activemq/sendMessage', { templateUrl: 'app/camel/html/sendMessage.html' }).when('/activemq/durableSubscribers', { templateUrl: 'app/activemq/html/durableSubscribers.html' }).when('/activemq/jobs', { templateUrl: 'app/activemq/html/jobs.html' });
    }]);
    ActiveMQ._module.run(["$location", "workspace", "viewRegistry", "helpRegistry", "preferencesRegistry", function ($location, workspace, viewRegistry, helpRegistry, preferencesRegistry) {
        viewRegistry['activemq'] = 'app/activemq/html/layoutActiveMQTree.html';
        helpRegistry.addUserDoc('activemq', 'app/activemq/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties("org.apache.activemq");
        });
        preferencesRegistry.addTab("ActiveMQ", "app/activemq/html/preferences.html", function () {
            return workspace.treeContainsDomainAndProperties("org.apache.activemq");
        });
        workspace.addTreePostProcessor(postProcessTree);
        var attributes = workspace.attributeColumnDefs;
        attributes[ActiveMQ.jmxDomain + "/Broker/folder"] = [
            { field: 'BrokerName', displayName: 'Name', width: "**" },
            { field: 'TotalProducerCount', displayName: 'Producer #' },
            { field: 'TotalConsumerCount', displayName: 'Consumer #' },
            { field: 'StorePercentUsage', displayName: 'Store %' },
            { field: 'TempPercentUsage', displayName: 'Temp %' },
            { field: 'MemoryPercentUsage', displayName: 'Memory %' },
            { field: 'TotalEnqueueCount', displayName: 'Enqueue #' },
            { field: 'TotalDequeueCount', displayName: 'Dequeue #' }
        ];
        attributes[ActiveMQ.jmxDomain + "/Queue/folder"] = [
            { field: 'Name', displayName: 'Name', width: "***" },
            { field: 'QueueSize', displayName: 'Queue Size' },
            { field: 'ProducerCount', displayName: 'Producer #' },
            { field: 'ConsumerCount', displayName: 'Consumer #' },
            { field: 'EnqueueCount', displayName: 'Enqueue #' },
            { field: 'DequeueCount', displayName: 'Dequeue #' },
            { field: 'MemoryPercentUsage', displayName: 'Memory %' },
            { field: 'DispatchCount', displayName: 'Dispatch #', visible: false }
        ];
        attributes[ActiveMQ.jmxDomain + "/Topic/folder"] = [
            { field: 'Name', displayName: 'Name', width: "****" },
            { field: 'ProducerCount', displayName: 'Producer #' },
            { field: 'ConsumerCount', displayName: 'Consumer #' },
            { field: 'EnqueueCount', displayName: 'Enqueue #' },
            { field: 'DequeueCount', displayName: 'Dequeue #' },
            { field: 'MemoryPercentUsage', displayName: 'Memory %' },
            { field: 'DispatchCount', displayName: 'Dispatch #', visible: false }
        ];
        attributes[ActiveMQ.jmxDomain + "/Consumer/folder"] = [
            { field: 'ConnectionId', displayName: 'Name', width: "**" },
            { field: 'PrefetchSize', displayName: 'Prefetch Size' },
            { field: 'Priority', displayName: 'Priority' },
            { field: 'DispatchedQueueSize', displayName: 'Dispatched Queue #' },
            { field: 'SlowConsumer', displayName: 'Slow ?' },
            { field: 'Retroactive', displayName: 'Retroactive' },
            { field: 'Selector', displayName: 'Selector' }
        ];
        attributes[ActiveMQ.jmxDomain + "/networkConnectors/folder"] = [
            { field: 'Name', displayName: 'Name', width: "**" },
            { field: 'UserName', displayName: 'User Name' },
            { field: 'PrefetchSize', displayName: 'Prefetch Size' },
            { field: 'ConduitSubscriptions', displayName: 'Conduit Subscriptions?' },
            { field: 'Duplex', displayName: 'Duplex' },
            { field: 'DynamicOnly', displayName: 'Dynamic Only' }
        ];
        attributes[ActiveMQ.jmxDomain + "/PersistenceAdapter/folder"] = [
            { field: 'IndexDirectory', displayName: 'Index Directory', width: "**" },
            { field: 'LogDirectory', displayName: 'Log Directory', width: "**" }
        ];
        workspace.topLevelTabs.push({
            id: "activemq",
            content: "ActiveMQ",
            title: "Manage your ActiveMQ message brokers",
            isValid: function (workspace) { return workspace.treeContainsDomainAndProperties("org.apache.activemq"); },
            href: function () { return "#/jmx/attributes?tab=activemq"; },
            isActive: function () { return workspace.isTopTabActive("activemq"); }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-envelope"></i> Browse',
            title: "Browse the messages on the queue",
            isValid: function (workspace) { return isQueue(workspace) && workspace.hasInvokeRights(workspace.selection, "browse()"); },
            href: function () { return "#/activemq/browseQueue"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-pencil"></i> Send',
            title: "Send a message to this destination",
            isValid: function (workspace) { return (isQueue(workspace) || isTopic(workspace)) && workspace.hasInvokeRights(workspace.selection, "sendTextMessage(java.util.Map,java.lang.String,java.lang.String,java.lang.String)"); },
            href: function () { return "#/activemq/sendMessage"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-picture"></i> Diagram',
            title: "View a diagram of the producers, destinations and consumers",
            isValid: function (workspace) { return workspace.isTopTabActive("activemq") || workspace.selectionHasDomain(ActiveMQ.jmxDomain); },
            href: function () { return "#/activemq/diagram"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-plus"></i> Create',
            title: "Create a new destination",
            isValid: function (workspace) { return isBroker(workspace) && workspace.hasInvokeRights(getBroker(workspace), "addQueue", "addTopic"); },
            href: function () { return "#/activemq/createDestination"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-plus"></i> Create',
            title: "Create a new queue",
            isValid: function (workspace) { return isQueuesFolder(workspace) && workspace.hasInvokeRights(getBroker(workspace), "addQueue"); },
            href: function () { return "#/activemq/createQueue"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-plus"></i> Create',
            title: "Create a new topic",
            isValid: function (workspace) { return isTopicsFolder(workspace) && workspace.hasInvokeRights(getBroker(workspace), "addQueue"); },
            href: function () { return "#/activemq/createTopic"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-remove"></i> Delete Topic',
            title: "Delete this topic",
            isValid: function (workspace) { return isTopic(workspace) && workspace.hasInvokeRights(getBroker(workspace), "removeTopic"); },
            href: function () { return "#/activemq/deleteTopic"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-remove"></i> Delete',
            title: "Delete or purge this queue",
            isValid: function (workspace) { return isQueue(workspace) && workspace.hasInvokeRights(getBroker(workspace), "removeQueue"); },
            href: function () { return "#/activemq/deleteQueue"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-list"></i> Durable Subscribers',
            title: "Manage durable subscribers",
            isValid: function (workspace) { return isBroker(workspace); },
            href: function () { return "#/activemq/durableSubscribers"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-list"></i> Jobs',
            title: "Manage jobs",
            isValid: function (workspace) { return isJobScheduler(workspace); },
            href: function () { return "#/activemq/jobs"; }
        });
        function postProcessTree(tree) {
            var activemq = tree.get("org.apache.activemq");
            setConsumerType(activemq);
            if (activemq) {
                angular.forEach(activemq.children, function (broker) {
                    angular.forEach(broker.children, function (child) {
                        var grandChildren = child.children;
                        if (grandChildren) {
                            var names = ["Topic", "Queue"];
                            angular.forEach(names, function (name) {
                                var idx = grandChildren.findIndex(function (n) { return n.title === name; });
                                if (idx > 0) {
                                    var old = grandChildren[idx];
                                    grandChildren.splice(idx, 1);
                                    grandChildren.splice(0, 0, old);
                                }
                            });
                        }
                    });
                });
            }
        }
        function setConsumerType(node) {
            if (node) {
                var parent = node.parent;
                var entries = node.entries;
                if (parent && !parent.typeName && entries) {
                    var endpoint = entries["endpoint"];
                    if (endpoint === "Consumer" || endpoint === "Producer") {
                        parent.typeName = endpoint;
                    }
                    var connectorName = entries["connectorName"];
                    if (connectorName && !node.icon) {
                        node.icon = Core.url("/img/icons/activemq/connector.png");
                    }
                }
                angular.forEach(node.children, function (child) { return setConsumerType(child); });
            }
        }
    }]);
    hawtioPluginLoader.addModule(ActiveMQ.pluginName);
    function getBroker(workspace) {
        var answer = null;
        var selection = workspace.selection;
        if (selection) {
            answer = selection.findAncestor(function (current) {
                var entries = current.entries;
                if (entries) {
                    return (('type' in entries && entries.type === 'Broker') && 'brokerName' in entries && !('destinationName' in entries) && !('destinationType' in entries));
                }
                else {
                    return false;
                }
            });
        }
        return answer;
    }
    ActiveMQ.getBroker = getBroker;
    function isQueue(workspace) {
        return workspace.hasDomainAndProperties(ActiveMQ.jmxDomain, { 'destinationType': 'Queue' }, 4) || workspace.selectionHasDomainAndType(ActiveMQ.jmxDomain, 'Queue');
    }
    ActiveMQ.isQueue = isQueue;
    function isTopic(workspace) {
        return workspace.hasDomainAndProperties(ActiveMQ.jmxDomain, { 'destinationType': 'Topic' }, 4) || workspace.selectionHasDomainAndType(ActiveMQ.jmxDomain, 'Topic');
    }
    ActiveMQ.isTopic = isTopic;
    function isQueuesFolder(workspace) {
        return workspace.selectionHasDomainAndLastFolderName(ActiveMQ.jmxDomain, 'Queue');
    }
    ActiveMQ.isQueuesFolder = isQueuesFolder;
    function isTopicsFolder(workspace) {
        return workspace.selectionHasDomainAndLastFolderName(ActiveMQ.jmxDomain, 'Topic');
    }
    ActiveMQ.isTopicsFolder = isTopicsFolder;
    function isJobScheduler(workspace) {
        return workspace.hasDomainAndProperties(ActiveMQ.jmxDomain, { 'service': 'JobScheduler' }, 4);
    }
    ActiveMQ.isJobScheduler = isJobScheduler;
    function isBroker(workspace) {
        if (workspace.selectionHasDomainAndType(ActiveMQ.jmxDomain, 'Broker')) {
            var self = Core.pathGet(workspace, ["selection"]);
            var parent = Core.pathGet(workspace, ["selection", "parent"]);
            return !(parent && (parent.ancestorHasType('Broker') || self.ancestorHasType('Broker')));
        }
        return false;
    }
    ActiveMQ.isBroker = isBroker;
})(ActiveMQ || (ActiveMQ = {}));
var Fabric;
(function (Fabric) {
    function createSshHostConfiguration() {
        return {
            hostName: null,
            port: null,
            username: null,
            password: null,
            maximumContainerCount: null,
            tags: [],
            path: null,
            passPhrase: null,
            privateKeyFile: null,
            preferredAddress: null
        };
    }
    Fabric.createSshHostConfiguration = createSshHostConfiguration;
    function createSshConfiguration() {
        return {
            hosts: [],
            defaultPath: null,
            defaultPort: null,
            defaultUsername: null,
            defaultPassword: null,
            fallbackRepositories: [],
            defaultPassPhrase: null,
            defaultPrivateKeyFile: null
        };
    }
    Fabric.createSshConfiguration = createSshConfiguration;
    function createDockerHostConfiguration() {
        return {
            hostName: null,
            port: null,
            username: null,
            password: null,
            maximumContainerCount: null,
            tags: [],
            path: null,
            passPhrase: null,
            privateKeyFile: null,
            preferredAddress: null
        };
    }
    Fabric.createDockerHostConfiguration = createDockerHostConfiguration;
    function createDockerConfiguration() {
        return {
            hosts: []
        };
    }
    Fabric.createDockerConfiguration = createDockerConfiguration;
    ;
    ;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    Fabric.log = Logger.get("Fabric");
    Fabric.jmxDomain = 'io.fabric8';
    Fabric.managerMBean = Fabric.jmxDomain + ":type=Fabric";
    Fabric.clusterManagerMBean = Fabric.jmxDomain + ":type=ClusterServiceManager";
    Fabric.clusterBootstrapManagerMBean = Fabric.jmxDomain + ":type=ClusterBootstrapManager";
    Fabric.openShiftFabricMBean = Fabric.jmxDomain + ":type=OpenShift";
    Fabric.mqManagerMBean = Fabric.jmxDomain + ":type=MQManager";
    Fabric.healthMBean = Fabric.jmxDomain + ":service=Health";
    Fabric.schemaLookupDomain = "hawtio";
    Fabric.schemaLookupType = "SchemaLookup";
    Fabric.schemaLookupMBean = Fabric.schemaLookupDomain + ":type=" + Fabric.schemaLookupType;
    Fabric.useDirectoriesInGit = true;
    Fabric.fabricTopLevel = "fabric/profiles/";
    Fabric.profileSuffix = ".profile";
    Fabric.jolokiaWebAppGroupId = Fabric.jmxDomain + ".fabric-jolokia";
    Fabric.currentContainerId = '';
    Fabric.currentContainer = {};
    Fabric.DEFAULT_REST_API = "/api/fabric8";
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    function doAction(action, jolokia, arguments, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        jolokia.request({
            type: 'exec',
            mbean: Fabric.managerMBean,
            operation: action,
            arguments: arguments
        }, {
            method: 'POST',
            success: success,
            error: error
        });
    }
    Fabric.doAction = doAction;
    function applyPatches(jolokia, files, targetVersion, newVersionName, proxyUser, proxyPass, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('applyPatches(java.util.List,java.lang.String,java.lang.String,java.lang.String,java.lang.String)', jolokia, [files, targetVersion, newVersionName, proxyUser, proxyPass], success, error);
    }
    Fabric.applyPatches = applyPatches;
    function setContainerProperty(jolokia, containerId, property, value, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('setContainerProperty(java.lang.String, java.lang.String, java.lang.Object)', jolokia, [containerId, property, value], success, error);
    }
    Fabric.setContainerProperty = setContainerProperty;
    function deleteConfigFile(jolokia, version, profile, pid, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('deleteConfigurationFile(java.lang.String, java.lang.String, java.lang.String)', jolokia, [version, profile, pid], success, error);
    }
    Fabric.deleteConfigFile = deleteConfigFile;
    function newConfigFile(jolokia, version, profile, pid, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('setConfigurationFile(java.lang.String, java.lang.String, java.lang.String, java.lang.String)', jolokia, [version, profile, pid, ''], success, error);
    }
    Fabric.newConfigFile = newConfigFile;
    function saveConfigFile(jolokia, version, profile, pid, data, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('setConfigurationFile(java.lang.String, java.lang.String, java.lang.String, java.lang.String)', jolokia, [version, profile, pid, data], success, error);
    }
    Fabric.saveConfigFile = saveConfigFile;
    function addProfilesToContainer(jolokia, container, profiles, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('addProfilesToContainer(java.lang.String, java.util.List)', jolokia, [container, profiles], success, error);
    }
    Fabric.addProfilesToContainer = addProfilesToContainer;
    function removeProfilesFromContainer(jolokia, container, profiles, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('removeProfilesFromContainer(java.lang.String, java.util.List)', jolokia, [container, profiles], success, error);
    }
    Fabric.removeProfilesFromContainer = removeProfilesFromContainer;
    function applyProfiles(jolokia, version, profiles, containers, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('applyProfilesToContainers(java.lang.String, java.util.List, java.util.List)', jolokia, [version, profiles, containers], success, error);
    }
    Fabric.applyProfiles = applyProfiles;
    function migrateContainers(jolokia, version, containers, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('applyVersionToContainers(java.lang.String, java.util.List)', jolokia, [version, containers], success, error);
    }
    Fabric.migrateContainers = migrateContainers;
    function changeProfileParents(jolokia, version, id, parents, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('changeProfileParents(java.lang.String, java.lang.String, java.util.List)', jolokia, [version, id, parents], success, error);
    }
    Fabric.changeProfileParents = changeProfileParents;
    function createProfile(jolokia, version, id, parents, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('createProfile(java.lang.String, java.lang.String, java.util.List)', jolokia, [version, id, parents], success, error);
    }
    Fabric.createProfile = createProfile;
    function copyProfile(jolokia, version, sourceName, targetName, force, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('copyProfile(java.lang.String, java.lang.String, java.lang.String, boolean)', jolokia, [version, sourceName, targetName, force], success, error);
    }
    Fabric.copyProfile = copyProfile;
    function createVersionWithParentAndId(jolokia, base, id, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('createVersion(java.lang.String, java.lang.String)', jolokia, [base, id], success, error);
    }
    Fabric.createVersionWithParentAndId = createVersionWithParentAndId;
    function createVersionWithId(jolokia, id, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('createVersion(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.createVersionWithId = createVersionWithId;
    function createVersion(jolokia, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('createVersion()', jolokia, [], success, error);
    }
    Fabric.createVersion = createVersion;
    function deleteVersion(jolokia, id, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('deleteVersion(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.deleteVersion = deleteVersion;
    function getVersionIds(jolokia) {
        return jolokia.execute(Fabric.managerMBean, "versionIds", { method: 'GET' });
    }
    Fabric.getVersionIds = getVersionIds;
    function getContainerIdsForProfile(jolokia, version, profileId) {
        return jolokia.execute(Fabric.managerMBean, "containerIdsForProfile", version, profileId, { method: 'POST' });
    }
    Fabric.getContainerIdsForProfile = getContainerIdsForProfile;
    function getContainerIds(jolokia) {
        return jolokia.execute(Fabric.managerMBean, "containerIds", { method: 'POST' });
    }
    Fabric.getContainerIds = getContainerIds;
    function getProfile(jolokia, version, id, mandatory) {
        return jolokia.execute(Fabric.managerMBean, "getProfile(java.lang.String, java.lang.String, boolean)", version, id, mandatory, { method: 'GET' });
    }
    Fabric.getProfile = getProfile;
    function deleteProfile(jolokia, version, id, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('deleteProfile(java.lang.String, java.lang.String)', jolokia, [version, id], success, error);
    }
    Fabric.deleteProfile = deleteProfile;
    function profileWebAppURL(jolokia, webAppId, profileId, versionId, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('profileWebAppURL', jolokia, [webAppId, profileId, versionId], success, error);
    }
    Fabric.profileWebAppURL = profileWebAppURL;
    function restApiUrl(jolokia, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('restApiUrl', jolokia, [], success, error);
    }
    Fabric.restApiUrl = restApiUrl;
    function stopContainer(jolokia, id, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('stopContainer(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.stopContainer = stopContainer;
    function destroyContainer(jolokia, id, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('destroyContainer(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.destroyContainer = destroyContainer;
    function startContainer(jolokia, id, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('startContainer(java.lang.String)', jolokia, [id], success, error);
    }
    Fabric.startContainer = startContainer;
    function containerWebAppURL(jolokia, webAppId, containerId, success, error) {
        if (error === void 0) { error = Core.defaultJolokiaErrorHandler; }
        doAction('containerWebAppURL', jolokia, [webAppId, containerId], success, error);
    }
    Fabric.containerWebAppURL = containerWebAppURL;
    function getDefaultVersionIdAsync(jolokia, callback) {
        doAction('defaultVersion', jolokia, [], function (response) {
            callback(response.value['id']);
        });
    }
    Fabric.getDefaultVersionIdAsync = getDefaultVersionIdAsync;
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    var dialogConfigs = {};
    function getCreateLocationDialog($dialog, resolve) {
        return $dialog.dialog({
            resolve: resolve,
            templateUrl: 'app/fabric/html/newLocation.html',
            controller: ["$scope", "dialog", "jolokia", "selectedContainers", "callbacks", function ($scope, dialog, jolokia, selectedContainers, callbacks) {
                $scope.newLocationName = "";
                $scope.close = function (result) {
                    dialog.close();
                    if (result) {
                        selectedContainers.each(function (container) {
                            Fabric.setContainerProperty(jolokia, container.id, 'location', $scope.newLocationName, callbacks.successs, callbacks.error);
                        });
                    }
                };
            }]
        });
    }
    Fabric.getCreateLocationDialog = getCreateLocationDialog;
    function getVersionCreateDialog($dialog) {
        var key = 'createVersion';
        if (!(key in dialogConfigs)) {
            dialogConfigs[key] = $dialog.dialog({
                templateUrl: 'app/fabric/html/createVersionDialog.html',
                controller: ["$scope", "dialog", "jolokia", "$location", function ($scope, dialog, jolokia, $location) {
                    $scope.name = '';
                    $scope.close = function (result) {
                        dialog.close();
                        if (result) {
                            Fabric.doCreateVersion($scope, jolokia, $location, $scope.name);
                        }
                    };
                }]
            });
        }
        return dialogConfigs[key];
    }
    Fabric.getVersionCreateDialog = getVersionCreateDialog;
    function getVersionDeleteDialog($dialog) {
        var key = 'deleteVersion';
        if (!(key in dialogConfigs)) {
            dialogConfigs[key] = $dialog.dialog({
                templateUrl: 'app/fabric/html/selectVersionDialog.html',
                controller: ["$scope", "dialog", "jolokia", "$location", "$rootScope", function ($scope, dialog, jolokia, $location, $rootScope) {
                    $scope.excludes = [];
                    $scope.$watch('selectedVersion.id', function (newValue, oldValue) {
                        if (newValue) {
                            if ($scope.excludes.find(function (v) {
                                return v === newValue;
                            })) {
                                $scope.warning = "This version is in use and cannot be deleted.";
                                $scope.invalid = true;
                            }
                            else {
                                $scope.warning = "This operation cannot be undone!";
                                $scope.invalid = false;
                            }
                        }
                    });
                    Fabric.getVersionsInUse(jolokia, function (used) {
                        $scope.excludes = used;
                        Core.$apply($scope);
                    });
                    $scope.invalid = false;
                    $scope.title = "Delete Version";
                    $scope.text = "Select the version to delete:";
                    $scope.warning = "This operation cannot be undone!";
                    $scope.action = "Delete";
                    $scope.cancel = "Cancel";
                    $scope.close = function (result) {
                        dialog.close();
                        if (result) {
                            var selectedVersion = $scope.selectedVersion.id;
                            Fabric.deleteVersion(jolokia, selectedVersion, function () {
                                $rootScope.$broadcast('wikiBranchesUpdated');
                                Fabric.getDefaultVersionIdAsync(jolokia, function (versionId) {
                                    Fabric.viewVersion(versionId, $location, $scope);
                                    Core.$apply($scope);
                                });
                            }, function (response) {
                                Fabric.log.debug("Failed to delete version ", selectedVersion, " due to ", response.error);
                                Fabric.log.debug("Stack trace: ", response.stacktrace);
                                Core.$apply($scope);
                            });
                        }
                    };
                }]
            });
        }
        return dialogConfigs[key];
    }
    Fabric.getVersionDeleteDialog = getVersionDeleteDialog;
    function getChangeDefaultVersionDialog($dialog) {
        var key = 'changeDefault';
        if (!(key in dialogConfigs)) {
            dialogConfigs[key] = $dialog.dialog({
                templateUrl: 'app/fabric/html/selectVersionDialog.html',
                controller: ["$scope", "dialog", "jolokia", "$location", function ($scope, dialog, jolokia, $location) {
                    $scope.title = "Change Default Version";
                    $scope.text = "Change the default version to:";
                    $scope.action = "Change";
                    $scope.cancel = "Cancel";
                    $scope.close = function (result) {
                        dialog.close();
                        if (result) {
                            var newDefault = $scope.selectedVersion.id;
                            Fabric.setDefaultVersion(jolokia, newDefault, function () {
                                Core.notification('success', "Set default version to " + newDefault);
                                Core.$apply($scope);
                            });
                        }
                    };
                }]
            });
        }
        return dialogConfigs[key];
    }
    Fabric.getChangeDefaultVersionDialog = getChangeDefaultVersionDialog;
    function getVersionPatchDialog($dialog) {
        var key = 'patchVersion';
        if (!(key in dialogConfigs)) {
            dialogConfigs[key] = $dialog.dialog({
                templateUrl: 'app/fabric/html/selectVersionDialog.html',
                controller: ["$scope", "dialog", "jolokia", "$location", function ($scope, dialog, jolokia, $location) {
                    $scope.title = "Patch Version";
                    $scope.text = "Select the version to patch:";
                    $scope.action = "Continue";
                    $scope.cancel = "Cancel";
                    $scope.close = function (result) {
                        dialog.close();
                        if (result) {
                            $location.url('/fabric/patching').search({ versionId: $scope.selectedVersion.id });
                            Core.$apply($scope);
                        }
                    };
                }]
            });
        }
        return dialogConfigs[key];
    }
    Fabric.getVersionPatchDialog = getVersionPatchDialog;
    function addWikiBranchMenuExtensions(wikiBranchMenu, $dialog, workspace) {
        wikiBranchMenu.addExtension({
            title: "Create Version",
            valid: function () {
                return Fabric.isFMCContainer(workspace);
            },
            action: function () {
                getVersionCreateDialog($dialog).open();
            },
            objectName: Fabric.managerMBean,
            methodName: 'createVersion'
        });
        wikiBranchMenu.addExtension({
            title: "Delete Version",
            valid: function () {
                return Fabric.isFMCContainer(workspace);
            },
            action: function () {
                getVersionDeleteDialog($dialog).open();
            },
            objectName: Fabric.managerMBean,
            methodName: 'deleteVersion'
        });
        wikiBranchMenu.addExtension({
            title: "Change Default",
            valid: function () {
                return Fabric.isFMCContainer(workspace);
            },
            action: function () {
                getChangeDefaultVersionDialog($dialog).open();
            },
            objectName: Fabric.managerMBean,
            methodName: 'setDefaultVersion'
        });
        wikiBranchMenu.addExtension({
            title: "Patch Version",
            valid: function () {
                return Fabric.isFMCContainer(workspace) && !Fabric.hasOpenShiftFabric(workspace);
            },
            action: function () {
                getVersionPatchDialog($dialog).open();
            },
            objectName: Fabric.managerMBean,
            methodName: 'applyPatches',
            argumentTypes: 'java.util.List,java.lang.String,java.lang.String,java.lang.String,java.lang.String'
        });
    }
    Fabric.addWikiBranchMenuExtensions = addWikiBranchMenuExtensions;
})(Fabric || (Fabric = {}));
var CodeEditor;
(function (CodeEditor) {
    CodeEditor.GlobalCodeMirrorOptions = {
        theme: "default",
        tabSize: 4,
        lineNumbers: true,
        indentWithTabs: true,
        lineWrapping: true,
        autoCloseTags: true
    };
    function detectTextFormat(value) {
        var answer = "text";
        if (value) {
            answer = "javascript";
            var trimmed = value.toString().trimLeft().trimRight();
            if (trimmed && trimmed.first() === '<' && trimmed.last() === '>') {
                answer = "xml";
            }
        }
        return answer;
    }
    CodeEditor.detectTextFormat = detectTextFormat;
    function autoFormatEditor(editor) {
        if (editor) {
            var totalLines = editor.lineCount();
            var start = { line: 0, ch: 0 };
            var end = { line: totalLines - 1, ch: editor.getLine(totalLines - 1).length };
            editor.autoFormatRange(start, end);
            editor.setSelection(start, start);
        }
    }
    CodeEditor.autoFormatEditor = autoFormatEditor;
    function createEditorSettings(options) {
        if (options === void 0) { options = {}; }
        options.extraKeys = options.extraKeys || {};
        (function (mode) {
            mode = mode || { name: "text" };
            if (typeof mode !== "object") {
                mode = { name: mode };
            }
            var modeName = mode.name;
            if (modeName === "javascript") {
                angular.extend(mode, {
                    "json": true
                });
            }
        })(options.mode);
        (function (options) {
            var javascriptFolding = CodeMirror.newFoldFunction(CodeMirror.braceRangeFinder);
            var xmlFolding = CodeMirror.newFoldFunction(CodeMirror.tagRangeFinder);
            var foldFunction = function (codeMirror, line) {
                var mode = codeMirror.getOption("mode");
                var modeName = mode["name"];
                if (!mode || !modeName)
                    return;
                if (modeName === 'javascript') {
                    javascriptFolding(codeMirror, line);
                }
                else if (modeName === "xml" || modeName.startsWith("html")) {
                    xmlFolding(codeMirror, line);
                }
                ;
            };
            options.onGutterClick = foldFunction;
            options.extraKeys = angular.extend(options.extraKeys, {
                "Ctrl-Q": function (codeMirror) {
                    foldFunction(codeMirror, codeMirror.getCursor().line);
                }
            });
        })(options);
        var readOnly = options.readOnly;
        if (!readOnly) {
            options.matchBrackets = true;
        }
        angular.extend(options, CodeEditor.GlobalCodeMirrorOptions);
        return options;
    }
    CodeEditor.createEditorSettings = createEditorSettings;
})(CodeEditor || (CodeEditor = {}));
var UI;
(function (UI) {
    UI.log = Logger.get("UI");
    UI.scrollBarWidth = null;
    function findParentWith($scope, attribute) {
        if (attribute in $scope) {
            return $scope;
        }
        if (!$scope.$parent) {
            return null;
        }
        return findParentWith($scope.$parent, attribute);
    }
    UI.findParentWith = findParentWith;
    function getIfSet(attribute, $attr, def) {
        if (attribute in $attr) {
            var wantedAnswer = $attr[attribute];
            if (wantedAnswer && !wantedAnswer.isBlank()) {
                return wantedAnswer;
            }
        }
        return def;
    }
    UI.getIfSet = getIfSet;
    function observe($scope, $attrs, key, defValue, callbackFunc) {
        if (callbackFunc === void 0) { callbackFunc = null; }
        $attrs.$observe(key, function (value) {
            if (!angular.isDefined(value)) {
                $scope[key] = defValue;
            }
            else {
                $scope[key] = value;
            }
            if (angular.isDefined(callbackFunc) && callbackFunc) {
                callbackFunc($scope[key]);
            }
        });
    }
    UI.observe = observe;
    function getScrollbarWidth() {
        if (!angular.isDefined(UI.scrollBarWidth)) {
            var div = document.createElement('div');
            div.innerHTML = '<div style="width:50px;height:50px;position:absolute;left:-50px;top:-50px;overflow:auto;"><div style="width:1px;height:100px;"></div></div>';
            div = div.firstChild;
            document.body.appendChild(div);
            UI.scrollBarWidth = div.offsetWidth - div.clientWidth;
            document.body.removeChild(div);
        }
        return UI.scrollBarWidth;
    }
    UI.getScrollbarWidth = getScrollbarWidth;
})(UI || (UI = {}));
var UI;
(function (UI) {
    UI.pluginName = 'hawtio-ui';
    UI.templatePath = 'app/ui/html/';
    UI._module = angular.module(UI.pluginName, ['bootstrap', 'ngResource', 'ui', 'ui.bootstrap']);
    UI._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/ui/developerPage', { templateUrl: UI.templatePath + 'developerPage.html', reloadOnSearch: false });
    }]);
    UI._module.factory('UI', function () {
        return UI;
    });
    UI._module.factory('marked', function () {
        marked.setOptions({
            gfm: true,
            tables: true,
            breaks: false,
            pedantic: true,
            sanitize: false,
            smartLists: true,
            langPrefix: 'language-'
        });
        return marked;
    });
    UI._module.directive('compile', ['$compile', function ($compile) {
        return function (scope, element, attrs) {
            scope.$watch(function (scope) {
                return scope.$eval(attrs.compile);
            }, function (value) {
                element.html(value);
                $compile(element.contents())(scope);
            });
        };
    }]);
    UI._module.controller("CodeEditor.PreferencesController", ["$scope", "localStorage", "$templateCache", function ($scope, localStorage, $templateCache) {
        $scope.exampleText = $templateCache.get("exampleText");
        $scope.codeMirrorEx = $templateCache.get("codeMirrorExTemplate");
        $scope.javascript = "javascript";
        $scope.preferences = CodeEditor.GlobalCodeMirrorOptions;
        $scope.$watch("preferences", function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.codeMirrorEx += " ";
                localStorage['CodeMirrorOptions'] = angular.toJson(angular.extend(CodeEditor.GlobalCodeMirrorOptions, $scope.preferences));
            }
        }, true);
    }]);
    UI._module.run(["localStorage", function (localStorage) {
        var opts = localStorage['CodeMirrorOptions'];
        if (opts) {
            opts = angular.fromJson(opts);
            CodeEditor.GlobalCodeMirrorOptions = angular.extend(CodeEditor.GlobalCodeMirrorOptions, opts);
        }
    }]);
    hawtioPluginLoader.addModule(UI.pluginName);
})(UI || (UI = {}));
var UI;
(function (UI) {
    function hawtioDropDown($templateCache) {
        return {
            restrict: 'A',
            replace: true,
            templateUrl: UI.templatePath + 'dropDown.html',
            scope: {
                config: '=hawtioDropDown'
            },
            controller: ["$scope", "$element", "$attrs", function ($scope, $element, $attrs) {
                if (!$scope.config) {
                    $scope.config = {};
                }
                if (!('open' in $scope.config)) {
                    $scope.config['open'] = false;
                }
                $scope.action = function (config, $event) {
                    if ('items' in config && !('action' in config)) {
                        config.open = !config.open;
                        $event.preventDefault();
                        $event.stopPropagation();
                    }
                    else if ('action' in config) {
                        var action = config['action'];
                        if (angular.isFunction(action)) {
                            action();
                        }
                        else if (angular.isString(action)) {
                            $scope.$parent.$eval(action, {
                                config: config,
                                '$event': $event
                            });
                        }
                    }
                };
                $scope.$watch('config.items', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        $scope.menuStyle = $scope.menuStyle + " ";
                    }
                }, true);
                $scope.submenu = function (config) {
                    if (config && config.submenu) {
                        return "sub-menu";
                    }
                    return "";
                };
                $scope.icon = function (config) {
                    if (config && !Core.isBlank(config.icon)) {
                        return config.icon;
                    }
                    else {
                        return 'icon-spacer';
                    }
                };
                $scope.open = function (config) {
                    if (config && !config.open) {
                        return '';
                    }
                    return 'open';
                };
            }],
            link: function ($scope, $element, $attrs) {
                $scope.menuStyle = $templateCache.get("withsubmenus.html");
                if ('processSubmenus' in $attrs) {
                    if (!Core.parseBooleanValue($attrs['processSubmenus'])) {
                        $scope.menuStyle = $templateCache.get("withoutsubmenus.html");
                    }
                }
            }
        };
    }
    UI.hawtioDropDown = hawtioDropDown;
    UI._module.directive('hawtioDropDown', ["$templateCache", UI.hawtioDropDown]);
})(UI || (UI = {}));
var ContainerHelpers;
(function (ContainerHelpers) {
    ContainerHelpers.NO_LOCATION = "No Location";
    function extractLocations(containers) {
        var locations = containers.map(function (container) {
            if (Core.isBlank(container['location'])) {
                return ContainerHelpers.NO_LOCATION;
            }
            else {
                return container['location'];
            }
        });
        locations.push(ContainerHelpers.NO_LOCATION);
        locations = locations.unique().sortBy('');
        locations = locations.exclude(function (location) {
            return Core.isBlank(location);
        });
        return locations;
    }
    ContainerHelpers.extractLocations = extractLocations;
    function getCreateLocationDialog($scope, $dialog) {
        return Fabric.getCreateLocationDialog($dialog, {
            selectedContainers: function () {
                return $scope.selectedContainers;
            },
            callbacks: function () {
                return {
                    success: function (response) {
                        Core.$apply($scope);
                    },
                    error: function (response) {
                        Core.$apply($scope);
                    }
                };
            }
        });
    }
    ContainerHelpers.getCreateLocationDialog = getCreateLocationDialog;
    function buildLocationMenu($scope, jolokia, locations) {
        var locationMenu = {
            icon: 'icon-location-arrow',
            title: 'Set Location',
            items: []
        };
        var menuItems = [];
        locations.forEach(function (location) {
            menuItems.push({
                title: location,
                action: function () {
                    $scope.selectedContainers.forEach(function (container) {
                        var arg = location;
                        if (arg === ContainerHelpers.NO_LOCATION) {
                            arg = "";
                        }
                        Fabric.setContainerProperty(jolokia, container.id, 'location', arg, function () {
                            Core.$apply($scope);
                        }, function () {
                            Core.$apply($scope);
                        });
                    });
                }
            });
        });
        menuItems.push({
            title: "New...",
            action: function () {
                $scope.createLocationDialog.open();
            }
        });
        locationMenu.items = menuItems;
        return locationMenu;
    }
    ContainerHelpers.buildLocationMenu = buildLocationMenu;
    function isCurrentContainer(container) {
        if (!container) {
            return false;
        }
        if (Core.isBlank(Fabric.currentContainerId)) {
            return false;
        }
        if (angular.isObject(container)) {
            return container['id'] === Fabric.currentContainerId;
        }
        if (angular.isString(container)) {
            return container === Fabric.currentContainerId;
        }
        return false;
    }
    ContainerHelpers.isCurrentContainer = isCurrentContainer;
    ;
    function canConnect(container) {
        if (!container) {
            return false;
        }
        if (Core.isBlank(container['jolokiaUrl'])) {
            return false;
        }
        if (!Core.parseBooleanValue(container['alive'])) {
            return false;
        }
        return true;
    }
    ContainerHelpers.canConnect = canConnect;
    ;
    function statusTitle(container) {
        var answer = 'Alive';
        if (!container.alive) {
            answer = 'Not Running';
        }
        else {
            answer += ' - ' + Core.humanizeValue(container.provisionResult);
        }
        return answer;
    }
    ContainerHelpers.statusTitle = statusTitle;
    function statusIcon(row) {
        if (row) {
            switch (row.provisionResult) {
                case 'success':
                    if (row.alive) {
                        return "green icon-play-circle";
                    }
                    else {
                        return "orange icon-off";
                    }
                case 'downloading':
                    return "icon-download-alt";
                case 'installing':
                    return "icon-hdd";
                case 'analyzing':
                case 'finalizing':
                    return "icon-refresh icon-spin";
                case 'resolving':
                    return "icon-sitemap";
                case 'error':
                    return "red icon-warning-sign";
            }
            if (!row.alive) {
                return "orange icon-off";
            }
        }
        return "icon-refresh icon-spin";
    }
    ContainerHelpers.statusIcon = statusIcon;
    function gotoContainer($location, container) {
        $location.path('/fabric/container/' + container.id);
    }
    ContainerHelpers.gotoContainer = gotoContainer;
    function doDeleteContainer($scope, jolokia, name, onDelete) {
        if (onDelete === void 0) { onDelete = null; }
        Fabric.destroyContainer(jolokia, name, function () {
            if (onDelete) {
                onDelete();
            }
            Core.$apply($scope);
        });
    }
    ContainerHelpers.doDeleteContainer = doDeleteContainer;
    function doStartContainer($scope, jolokia, name) {
        if ($scope.fabricVerboseNotifications) {
            Core.notification('info', "Starting " + name);
        }
        Fabric.startContainer(jolokia, name, function () {
            Core.$apply($scope);
        });
    }
    ContainerHelpers.doStartContainer = doStartContainer;
    function doStopContainer($scope, jolokia, name) {
        if ($scope.fabricVerboseNotifications) {
            Core.notification('info', "Stopping " + name);
        }
        Fabric.stopContainer(jolokia, name, function () {
            Core.$apply($scope);
        });
    }
    ContainerHelpers.doStopContainer = doStopContainer;
    function stopContainers($scope, jolokia, c) {
        c.forEach(function (c) { return doStopContainer($scope, jolokia, c.id); });
    }
    ContainerHelpers.stopContainers = stopContainers;
    function startContainers($scope, jolokia, c) {
        c.forEach(function (c) { return doStartContainer($scope, jolokia, c.id); });
    }
    ContainerHelpers.startContainers = startContainers;
    function anyStartable(containers) {
        return containers.length > 0 && containers.any(function (container) {
            var answer = false;
            if (!container.alive) {
                answer = true;
                switch (container.provisionResult) {
                    case 'downloading':
                    case 'installing':
                    case 'analyzing':
                    case 'finalizing':
                    case 'resolving':
                        answer = false;
                }
            }
            return answer;
        });
    }
    ContainerHelpers.anyStartable = anyStartable;
    function anyStoppable(containers) {
        return containers.length > 0 && containers.any(function (c) { return c.alive === true; });
    }
    ContainerHelpers.anyStoppable = anyStoppable;
    function allAlive(containers, state) {
        if (state === void 0) { state = true; }
        return containers.length > 0 && containers.every(function (c) { return c.alive === state; });
    }
    ContainerHelpers.allAlive = allAlive;
    function decorate($scope, $location, jolokia) {
        if ($scope.containerHelpersAdded) {
            return;
        }
        $scope.containerHelpersAdded = true;
        $scope.isCurrentContainer = isCurrentContainer;
        $scope.canConnect = canConnect;
        $scope.getStatusTitle = statusTitle;
        $scope.showContainer = function (container) {
            gotoContainer($location, container);
        };
        $scope.statusIcon = statusIcon;
        $scope.everySelectionAlive = function (state) {
            return allAlive($scope.selectedContainers, state);
        };
        $scope.anySelectionStartable = function () {
            return anyStartable($scope.selectedContainers);
        };
        $scope.anySelectionStoppable = function () {
            return anyStoppable($scope.selectedContainers);
        };
        $scope.startContainer = function (name) {
            doStartContainer($scope, jolokia, name);
        };
        $scope.stopContainer = function (name) {
            doStopContainer($scope, jolokia, name);
        };
        $scope.startSelectedContainers = function () {
            startContainers($scope, jolokia, $scope.selectedContainers);
        };
        $scope.stopSelectedContainers = function () {
            stopContainers($scope, jolokia, $scope.selectedContainers);
        };
    }
    ContainerHelpers.decorate = decorate;
})(ContainerHelpers || (ContainerHelpers = {}));
var Fabric;
(function (Fabric) {
    function getResolvers(id) {
        var answer;
        switch (id) {
            case 'child':
                answer = [];
                break;
            case 'ssh':
                answer = ['localip', 'localhostname', 'publicip', 'publichostname', 'manualip'];
                break;
            case 'jclouds':
                answer = ['localip', 'localhostname', 'publicip', 'publichostname', 'manualip'];
                break;
            case 'openshift':
                answer = [];
                break;
            case 'docker':
                answer = [];
                break;
        }
        return answer;
    }
    Fabric.getResolvers = getResolvers;
    function customizeSchema(id, schema) {
        Core.pathSet(schema, ["properties", "name", "required"], true);
        Core.pathSet(schema, ['properties', 'name', 'input-attributes', 'ng-pattern'], "/^[a-z0-9_-]*$/");
        delete schema.properties['metadataMap'];
        delete schema.properties['zookeeperUrl'];
        delete schema.properties['zookeeperPassword'];
        delete schema.properties['globalResolver'];
        delete schema.properties['zooKeeperServerPort'];
        delete schema.properties['zooKeeperServerConnectionPort'];
        delete schema.properties['agentEnabled'];
        delete schema.properties['autoImportEnabled'];
        delete schema.properties['importPath'];
        delete schema.properties['users'];
        delete schema.properties['systemProperties'];
        ['zooKeeperServerInitLimit', 'zooKeeperServerTickTime', 'zooKeeperServerSyncLimit', 'zooKeeperServerDataDir', 'waitForProvision', 'ensembleStart', 'migrationTimeout', 'dataStoreProperties'].forEach(function (attr) {
            Core.pathSet(schema, ['properties', attr, 'control-attributes', 'ng-show'], 'entity.ensembleServer');
        });
        Core.pathSet(schema, ['properties', 'providerType', 'type'], 'hidden');
        Core.pathSet(schema, ['properties', 'profiles', 'type'], 'hidden');
        Core.pathSet(schema, ['properties', 'version', 'type'], 'hidden');
        Core.pathSet(schema.properties, ['name', 'label'], 'Container Name');
        Core.pathSet(schema.properties, ['name', 'container-name-available'], 'true');
        Core.pathSet(schema.properties, ['name', 'tooltip'], 'Name of the container to create (or prefix of the container name if you create multiple containers)');
        Core.pathSet(schema.properties, ['number', 'label'], 'Number of containers');
        Core.pathSet(schema.properties, ['number', 'tooltip'], 'The number of containers to create; when set higher than 1 a number will be appended to each container name. Max value: 99');
        Core.pathSet(schema.properties, ['number', 'input-attributes', 'min'], '1');
        Core.pathSet(schema.properties, ['number', 'input-attributes', 'max'], '99');
        Core.pathSet(schema.properties, ['number', 'input-attributes', 'ng-pattern'], "/^[1-9][0-9]?$/");
        Core.pathSet(schema.properties, ['number', 'required'], true);
        Core.pathSet(schema.properties, ['login', 'input-attributes', "autofill"], "true");
        Core.pathSet(schema.properties, ['password', 'input-attributes', "autofill"], "true");
        Core.pathSet(schema.properties, ['jmxUser', 'input-attributes', "autofill"], "true");
        Core.pathSet(schema.properties, ['jmxUser', 'tooltip'], 'The username for connecting to the container using JMX');
        Core.pathSet(schema.properties, ['jmxPassword', 'input-attributes', "autofill"], "true");
        Core.pathSet(schema.properties, ['jmxPassword', 'tooltip'], 'The password for connecting to the container using JMX');
        Core.pathSet(schema.properties, ['resolver', 'input-element'], "select");
        Core.pathSet(schema.properties, ['resolver', 'input-attributes', "ng-options"], "r for r in resolvers");
        switch (id) {
            case 'child':
                delete schema.properties['manualIp'];
                delete schema.properties['preferredAddress'];
                delete schema.properties['resolver'];
                delete schema.properties['ensembleServer'];
                delete schema.properties['proxyUri'];
                delete schema.properties['adminAccess'];
                delete schema.properties['minimumPort'];
                delete schema.properties['maximumPort'];
                schema.properties['jmxPassword']['type'] = 'password';
                Core.pathSet(schema.properties, ['parent', 'label'], 'Parent Container');
                Core.pathSet(schema.properties, ['parent', 'tooltip'], 'The name of the parent container used to create the child container');
                Core.pathSet(schema.properties, ['parent', 'input-element'], "select");
                Core.pathSet(schema.properties, ['parent', 'input-attributes', "ng-options"], "c for c in child.rootContainers");
                bulkSet(schema, ["jmxUser", "jmxPassword", "parent"], 'required', true);
                schema['tabs'] = {
                    'Common': ['name', 'parent', 'jmxUser', 'jmxPassword', 'number'],
                    'Advanced': ['*']
                };
                break;
            case 'ssh':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];
                bulkSet(schema, ['host'], 'required', true);
                Core.pathSet(schema.properties, ['password', 'type'], 'password');
                schema['tabs'] = {
                    'Common': ['name', 'host', 'port', 'username', 'password', 'privateKeyFile', 'passPhrase'],
                    'Advanced': ['*']
                };
                break;
            case 'jclouds':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];
                schema['tabs'] = {
                    'Common': ['name', 'owner', 'credential', 'providerName', 'imageId', 'hardwareId', 'locationId', 'number', 'instanceType'],
                    'Advanced': ['*']
                };
                break;
            case 'openshift':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];
                delete schema.properties['manualIp'];
                delete schema.properties['preferredAddress'];
                delete schema.properties['ensembleServer'];
                delete schema.properties['proxyUri'];
                delete schema.properties['adminAccess'];
                delete schema.properties['path'];
                delete schema.properties['bindAddress'];
                delete schema.properties['hostNameContext'];
                delete schema.properties['resolver'];
                Core.pathSet(schema.properties, ['resolver', 'default'], 'publichostname');
                Core.pathSet(schema.properties, ['serverUrl', 'label'], 'OpenShift Broker');
                Core.pathSet(schema.properties, ['serverUrl', 'tooltip'], 'The OpenShift broker host name of the cloud to create the container inside. This is either the URL for your local OpenShift Enterprise installation, or its the public OpenShift online URL: openshift.redhat.com');
                Core.pathSet(schema.properties, ['login', 'label'], 'OpenShift Login');
                Core.pathSet(schema.properties, ['login', 'tooltip'], 'Your personal login to the OpenShift portal');
                Core.pathSet(schema.properties, ['login', 'input-attributes', "autofill"], "true");
                Core.pathSet(schema.properties, ['password', 'label'], 'OpenShift Password');
                Core.pathSet(schema.properties, ['password', 'tooltip'], 'Your personal password on the OpenShift portal');
                Core.pathSet(schema.properties, ['password', 'type'], 'password');
                Core.pathSet(schema.properties, ['name', 'input-attributes', 'ng-pattern'], "/^[a-z0-9]*$/");
                Core.pathSet(schema.properties, ['tryLogin', 'type'], 'string');
                Core.pathSet(schema.properties, ['tryLogin', 'input-attributes', "ng-model"], "openShift.tryLogin");
                Core.pathSet(schema.properties, ['tryLogin', 'label'], 'Authenticate');
                Core.pathSet(schema.properties, ['tryLogin', 'tooltip'], 'Authenticate with the OpenShift Broker using your login and password');
                Core.pathSet(schema.properties, ['tryLogin', 'formTemplate'], '<a ng-click="openShift.login()" ng-disabled="!entity.login || !entity.password || !entity.serverUrl" ' + 'title="Test you entered the correct OpenShift Broker, login and password" class="btn btn-primary">Login to OpenShift</a>' + '<div class="alert" ng-show="openShift.loginFailed" ' + 'title="Are you sure you correctly entered the OpenShift Broker, login and password correctly?">Login failed</div>');
                Core.pathSet(schema.properties, ['domain', 'label'], 'OpenShift Domain');
                Core.pathSet(schema.properties, ['domain', 'tooltip'], 'What is your unique domain name used for applications you create on OpenShift. Often this is your own user name or group name');
                Core.pathSet(schema.properties, ['domain', 'input-element'], "select");
                Core.pathSet(schema.properties, ['domain', 'input-attributes', "ng-options"], "c for c in openShift.domains");
                Core.pathSet(schema.properties, ['gearProfile', 'tooltip'], 'Which kind of gear to create');
                Core.pathSet(schema.properties, ['gearProfile', 'input-element'], "select");
                Core.pathSet(schema.properties, ['gearProfile', 'input-attributes', "ng-options"], "c for c in openShift.gearProfiles");
                bulkSet(schema, ['serverUrl', 'login', 'password', 'domain'], 'required', true);
                schema['tabs'] = {
                    'Common': ['name', 'serverUrl', 'login', 'password', 'tryLogin', 'domain', 'gearProfile', 'number'],
                    'Advanced': ['environmentalVariables', 'jvmOpts', '*']
                };
                break;
            case 'docker':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];
                delete schema.properties['manualIp'];
                delete schema.properties['preferredAddress'];
                delete schema.properties['resolver'];
                delete schema.properties['ensembleServer'];
                delete schema.properties['proxyUri'];
                delete schema.properties['adminAccess'];
                delete schema.properties['path'];
                delete schema.properties['bindAddress'];
                delete schema.properties['hostNameContext'];
                schema['tabs'] = {
                    'Common': ['name', 'number'],
                    'Advanced': ['environmentalVariables', 'jvmOpts', '*']
                };
                break;
            case 'kubernetes':
                delete schema.properties['jmxUser'];
                delete schema.properties['jmxPassword'];
                delete schema.properties['parent'];
                delete schema.properties['manualIp'];
                delete schema.properties['preferredAddress'];
                delete schema.properties['resolver'];
                delete schema.properties['ensembleServer'];
                delete schema.properties['proxyUri'];
                delete schema.properties['adminAccess'];
                delete schema.properties['path'];
                delete schema.properties['bindAddress'];
                delete schema.properties['hostNameContext'];
                schema['tabs'] = {
                    'Common': ['name', 'number'],
                    'Advanced': ['environmentalVariables', 'jvmOpts', '*']
                };
                break;
            default:
        }
        return schema;
    }
    Fabric.customizeSchema = customizeSchema;
    function bulkSet(schema, properties, field, value) {
        properties.each(function (name) {
            Core.pathSet(schema, ['properties', name, field], value);
        });
    }
    function setGlobalResolverEnum(schema) {
        var globalResolverEnum = ['localip', 'localhostname', 'publicip', 'publichostname'];
        Core.pathSet(schema, ['properties', 'globalResolver', 'enum'], globalResolverEnum);
    }
})(Fabric || (Fabric = {}));
var Git;
(function (Git) {
    function createGitRepository(workspace, jolokia, localStorage) {
        var mbean = getGitMBean(workspace);
        if (mbean && jolokia) {
            return new Git.JolokiaGit(mbean, jolokia, localStorage, workspace.userDetails);
        }
        return null;
    }
    Git.createGitRepository = createGitRepository;
    Git.jmxDomain = "hawtio";
    Git.mbeanType = "GitFacade";
    function hasGit(workspace) {
        return getGitMBean(workspace) !== null;
    }
    Git.hasGit = hasGit;
    function getGitMBean(workspace) {
        return Core.getMBeanTypeObjectName(workspace, Git.jmxDomain, Git.mbeanType);
    }
    Git.getGitMBean = getGitMBean;
    function getGitMBeanFolder(workspace) {
        return Core.getMBeanTypeFolder(workspace, Git.jmxDomain, Git.mbeanType);
    }
    Git.getGitMBeanFolder = getGitMBeanFolder;
    function isGitMBeanFabric(workspace) {
        var folder = getGitMBeanFolder(workspace);
        return folder && folder.entries["repo"] === "fabric";
    }
    Git.isGitMBeanFabric = isGitMBeanFabric;
})(Git || (Git = {}));
var UI;
(function (UI) {
    var Dialog = (function () {
        function Dialog() {
            this.show = false;
            this.options = {
                backdropFade: true,
                dialogFade: true
            };
        }
        Dialog.prototype.open = function () {
            this.show = true;
        };
        Dialog.prototype.close = function () {
            this.show = false;
            this.removeBackdropFadeDiv();
            setTimeout(this.removeBackdropFadeDiv, 100);
        };
        Dialog.prototype.removeBackdropFadeDiv = function () {
            $("div.modal-backdrop").remove();
        };
        return Dialog;
    })();
    UI.Dialog = Dialog;
    function multiItemConfirmActionDialog(options) {
        var $dialog = Core.injector.get("$dialog");
        return $dialog.dialog({
            resolve: {
                options: function () {
                    return options;
                }
            },
            templateUrl: 'app/ui/html/multiItemConfirmActionDialog.html',
            controller: ["$scope", "dialog", "options", function ($scope, dialog, options) {
                $scope.options = options;
                $scope.close = function (result) {
                    dialog.close();
                    options.onClose(result);
                };
            }]
        });
    }
    UI.multiItemConfirmActionDialog = multiItemConfirmActionDialog;
})(UI || (UI = {}));
var Git;
(function (Git) {
    var JolokiaGit = (function () {
        function JolokiaGit(mbean, jolokia, localStorage, userDetails, branch) {
            if (branch === void 0) { branch = "master"; }
            this.mbean = mbean;
            this.jolokia = jolokia;
            this.localStorage = localStorage;
            this.userDetails = userDetails;
            this.branch = branch;
        }
        JolokiaGit.prototype.getRepositoryLabel = function (fn, error) {
            return this.jolokia.request({ type: "read", mbean: this.mbean, attribute: ["RepositoryLabel"] }, onSuccess(function (result) {
                fn(result.value.RepositoryLabel);
            }, { error: error }));
        };
        JolokiaGit.prototype.exists = function (branch, path, fn) {
            var result;
            if (angular.isDefined(fn) && fn) {
                result = this.jolokia.execute(this.mbean, "exists", branch, path, onSuccess(fn));
            }
            else {
                result = this.jolokia.execute(this.mbean, "exists", branch, path);
            }
            if (angular.isDefined(result) && result) {
                return true;
            }
            else {
                return false;
            }
        };
        JolokiaGit.prototype.read = function (branch, path, fn) {
            return this.jolokia.execute(this.mbean, "read", branch, path, onSuccess(fn));
        };
        JolokiaGit.prototype.write = function (branch, path, commitMessage, contents, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();
            return this.jolokia.execute(this.mbean, "write", branch, path, commitMessage, authorName, authorEmail, contents, onSuccess(fn));
        };
        JolokiaGit.prototype.writeBase64 = function (branch, path, commitMessage, contents, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();
            return this.jolokia.execute(this.mbean, "writeBase64", branch, path, commitMessage, authorName, authorEmail, contents, onSuccess(fn));
        };
        JolokiaGit.prototype.createDirectory = function (branch, path, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();
            return this.jolokia.execute(this.mbean, "createDirectory", branch, path, commitMessage, authorName, authorEmail, onSuccess(fn));
        };
        JolokiaGit.prototype.revertTo = function (branch, objectId, blobPath, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();
            return this.jolokia.execute(this.mbean, "revertTo", branch, objectId, blobPath, commitMessage, authorName, authorEmail, onSuccess(fn));
        };
        JolokiaGit.prototype.rename = function (branch, oldPath, newPath, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();
            return this.jolokia.execute(this.mbean, "rename", branch, oldPath, newPath, commitMessage, authorName, authorEmail, onSuccess(fn));
        };
        JolokiaGit.prototype.remove = function (branch, path, commitMessage, fn) {
            var authorName = this.getUserName();
            var authorEmail = this.getUserEmail();
            return this.jolokia.execute(this.mbean, "remove", branch, path, commitMessage, authorName, authorEmail, onSuccess(fn));
        };
        JolokiaGit.prototype.completePath = function (branch, completionText, directoriesOnly, fn) {
            return this.jolokia.execute(this.mbean, "completePath", branch, completionText, directoriesOnly, onSuccess(fn));
        };
        JolokiaGit.prototype.history = function (branch, objectId, path, limit, fn) {
            return this.jolokia.execute(this.mbean, "history", branch, objectId, path, limit, onSuccess(fn));
        };
        JolokiaGit.prototype.commitTree = function (commitId, fn) {
            return this.jolokia.execute(this.mbean, "getCommitTree", commitId, onSuccess(fn));
        };
        JolokiaGit.prototype.commitInfo = function (commitId, fn) {
            return this.jolokia.execute(this.mbean, "getCommitInfo", commitId, onSuccess(fn));
        };
        JolokiaGit.prototype.diff = function (objectId, baseObjectId, path, fn) {
            return this.jolokia.execute(this.mbean, "diff", objectId, baseObjectId, path, onSuccess(fn));
        };
        JolokiaGit.prototype.getContent = function (objectId, blobPath, fn) {
            return this.jolokia.execute(this.mbean, "getContent", objectId, blobPath, onSuccess(fn));
        };
        JolokiaGit.prototype.readJsonChildContent = function (path, nameWildcard, search, fn) {
            return this.jolokia.execute(this.mbean, "readJsonChildContent", this.branch, path, nameWildcard, search, onSuccess(fn));
        };
        JolokiaGit.prototype.branches = function (fn) {
            return this.jolokia.execute(this.mbean, "branches", onSuccess(fn));
        };
        JolokiaGit.prototype.getUserName = function () {
            return this.localStorage["gitUserName"] || this.userDetails.username || "anonymous";
        };
        JolokiaGit.prototype.getUserEmail = function () {
            return this.localStorage["gitUserEmail"] || "anonymous@gmail.com";
        };
        return JolokiaGit;
    })();
    Git.JolokiaGit = JolokiaGit;
})(Git || (Git = {}));
var Wiki;
(function (Wiki) {
    Wiki.log = Logger.get("Wiki");
    Wiki.camelNamespaces = ["http://camel.apache.org/schema/spring", "http://camel.apache.org/schema/blueprint"];
    Wiki.springNamespaces = ["http://www.springframework.org/schema/beans"];
    Wiki.droolsNamespaces = ["http://drools.org/schema/drools-spring"];
    Wiki.dozerNamespaces = ["http://dozer.sourceforge.net"];
    Wiki.activemqNamespaces = ["http://activemq.apache.org/schema/core"];
    Wiki.excludeAdjustmentPrefixes = ["http://", "https://", "#"];
    (function (ViewMode) {
        ViewMode[ViewMode["List"] = 0] = "List";
        ViewMode[ViewMode["Icon"] = 1] = "Icon";
    })(Wiki.ViewMode || (Wiki.ViewMode = {}));
    var ViewMode = Wiki.ViewMode;
    ;
    Wiki.customWikiViewPages = ["/formTable", "/camel/diagram", "/camel/canvas", "/camel/properties", "/dozer/mappings"];
    Wiki.hideExtensions = [".profile"];
    var defaultFileNamePattern = /^[a-zA-Z0-9._-]*$/;
    var defaultFileNamePatternInvalid = "Name must be: letters, numbers, and . _ or - characters";
    var defaultFileNameExtensionPattern = "";
    var defaultLowerCaseFileNamePattern = /^[a-z0-9._-]*$/;
    var defaultLowerCaseFileNamePatternInvalid = "Name must be: lower-case letters, numbers, and . _ or - characters";
    Wiki.documentTemplates = [
        {
            label: "Folder",
            tooltip: "Create a new folder to contain documents",
            folder: true,
            icon: "/img/icons/wiki/folder.gif",
            exemplar: "myfolder",
            regex: defaultLowerCaseFileNamePattern,
            invalid: defaultLowerCaseFileNamePatternInvalid
        },
        {
            label: "App",
            tooltip: "Creates a new App folder used to configure and run containers",
            addClass: "icon-cog green",
            exemplar: 'myapp',
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: '',
            generated: {
                mbean: ['io.fabric8', { type: 'KubernetesTemplateManager' }],
                init: function (workspace, $scope) {
                },
                generate: function (options) {
                    Wiki.log.debug("Got options: ", options);
                    options.form.name = options.name;
                    options.form.path = options.parentId;
                    options.form.branch = options.branch;
                    var json = angular.toJson(options.form);
                    var jolokia = Core.injector.get("jolokia");
                    jolokia.request({
                        type: 'exec',
                        mbean: 'io.fabric8:type=KubernetesTemplateManager',
                        operation: 'createAppByJson',
                        arguments: [json]
                    }, onSuccess(function (response) {
                        Wiki.log.debug("Generated app, response: ", response);
                        options.success(undefined);
                    }, {
                        error: function (response) {
                            options.error(response.error);
                        }
                    }));
                },
                form: function (workspace, $scope) {
                    return {
                        summaryMarkdown: 'Add app summary here',
                        replicaCount: 1
                    };
                },
                schema: {
                    description: 'App settings',
                    type: 'java.lang.String',
                    properties: {
                        'summaryMarkdown': {
                            'description': 'Short Description',
                            'type': 'java.lang.String',
                            'input-attributes': { 'class': 'input-xlarge' }
                        },
                        'replicaCount': {
                            'description': 'Replica Count',
                            'type': 'java.lang.Integer',
                            'input-attributes': {
                                min: '0'
                            }
                        },
                        'labels': {
                            'description': 'Labels',
                            'type': 'map',
                            'items': {
                                'type': 'string'
                            }
                        }
                    }
                }
            }
        },
        {
            label: "Fabric8 Profile",
            tooltip: "Create a new empty fabric profile. Using a hyphen ('-') will create a folder heirarchy, for example 'my-awesome-profile' will be available via the path 'my/awesome/profile'.",
            profile: true,
            addClass: "icon-book green",
            exemplar: "user-profile",
            regex: defaultLowerCaseFileNamePattern,
            invalid: defaultLowerCaseFileNamePatternInvalid,
            fabricOnly: true
        },
        {
            label: "Properties File",
            tooltip: "A properties file typically used to configure Java classes",
            exemplar: "properties-file.properties",
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".properties"
        },
        {
            label: "JSON File",
            tooltip: "A file containing JSON data",
            exemplar: "document.json",
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".json"
        },
        {
            label: "Key Store File",
            tooltip: "Creates a keystore (database) of cryptographic keys, X.509 certificate chains, and trusted certificates.",
            exemplar: 'keystore.jks',
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".jks",
            generated: {
                mbean: ['hawtio', { type: 'KeystoreService' }],
                init: function (workspace, $scope) {
                    var mbean = 'hawtio:type=KeystoreService';
                    var response = workspace.jolokia.request({ type: "read", mbean: mbean, attribute: "SecurityProviderInfo" }, {
                        success: function (response) {
                            $scope.securityProviderInfo = response.value;
                            Core.$apply($scope);
                        },
                        error: function (response) {
                            console.log('Could not find the supported security algorithms: ', response.error);
                            Core.$apply($scope);
                        }
                    });
                },
                generate: function (options) {
                    var encodedForm = JSON.stringify(options.form);
                    var mbean = 'hawtio:type=KeystoreService';
                    var response = options.workspace.jolokia.request({
                        type: 'exec',
                        mbean: mbean,
                        operation: 'createKeyStoreViaJSON(java.lang.String)',
                        arguments: [encodedForm]
                    }, {
                        method: 'POST',
                        success: function (response) {
                            options.success(response.value);
                        },
                        error: function (response) {
                            options.error(response.error);
                        }
                    });
                },
                form: function (workspace, $scope) {
                    return {
                        storeType: $scope.securityProviderInfo.supportedKeyStoreTypes[0],
                        createPrivateKey: false,
                        keyLength: 4096,
                        keyAlgorithm: $scope.securityProviderInfo.supportedKeyAlgorithms[0],
                        keyValidity: 365
                    };
                },
                schema: {
                    "description": "Keystore Settings",
                    "type": "java.lang.String",
                    "properties": {
                        "storePassword": {
                            "description": "Keystore password.",
                            "type": "password",
                            'input-attributes': { "required": "", "ng-minlength": 6 }
                        },
                        "storeType": {
                            "description": "The type of store to create",
                            "type": "java.lang.String",
                            'input-element': "select",
                            'input-attributes': { "ng-options": "v for v in securityProviderInfo.supportedKeyStoreTypes" }
                        },
                        "createPrivateKey": {
                            "description": "Should we generate a self-signed private key?",
                            "type": "boolean"
                        },
                        "keyCommonName": {
                            "description": "The common name of the key, typically set to the hostname of the server",
                            "type": "java.lang.String",
                            'control-group-attributes': { 'ng-show': "formData.createPrivateKey" }
                        },
                        "keyLength": {
                            "description": "The length of the cryptographic key",
                            "type": "Long",
                            'control-group-attributes': { 'ng-show': "formData.createPrivateKey" }
                        },
                        "keyAlgorithm": {
                            "description": "The key algorithm",
                            "type": "java.lang.String",
                            'input-element': "select",
                            'input-attributes': { "ng-options": "v for v in securityProviderInfo.supportedKeyAlgorithms" },
                            'control-group-attributes': { 'ng-show': "formData.createPrivateKey" }
                        },
                        "keyValidity": {
                            "description": "The number of days the key will be valid for",
                            "type": "Long",
                            'control-group-attributes': { 'ng-show': "formData.createPrivateKey" }
                        },
                        "keyPassword": {
                            "description": "Password to the private key",
                            "type": "password",
                            'control-group-attributes': { 'ng-show': "formData.createPrivateKey" }
                        }
                    }
                }
            }
        },
        {
            label: "Markdown Document",
            tooltip: "A basic markup document using the Markdown wiki markup, particularly useful for ReadMe files in directories",
            exemplar: "ReadMe.md",
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".md"
        },
        {
            label: "Text Document",
            tooltip: "A plain text file",
            exemplar: "document.text",
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".txt"
        },
        {
            label: "HTML Document",
            tooltip: "A HTML document you can edit directly using the HTML markup",
            exemplar: "document.html",
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".html"
        },
        {
            label: "XML Document",
            tooltip: "An empty XML document",
            exemplar: "document.xml",
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".xml"
        },
        {
            label: "Integration Flows",
            tooltip: "Camel routes for defining your integration flows",
            children: [
                {
                    label: "Camel XML document",
                    tooltip: "A vanilla Camel XML document for integration flows",
                    icon: "/img/icons/camel.svg",
                    exemplar: "camel.xml",
                    regex: defaultFileNamePattern,
                    invalid: defaultFileNamePatternInvalid,
                    extension: ".xml"
                },
                {
                    label: "Camel OSGi Blueprint XML document",
                    tooltip: "A vanilla Camel XML document for integration flows when using OSGi Blueprint",
                    icon: "/img/icons/camel.svg",
                    exemplar: "camel-blueprint.xml",
                    regex: defaultFileNamePattern,
                    invalid: defaultFileNamePatternInvalid,
                    extension: ".xml"
                },
                {
                    label: "Camel Spring XML document",
                    tooltip: "A vanilla Camel XML document for integration flows when using the Spring framework",
                    icon: "/img/icons/camel.svg",
                    exemplar: "camel-spring.xml",
                    regex: defaultFileNamePattern,
                    invalid: defaultFileNamePatternInvalid,
                    extension: ".xml"
                }
            ]
        },
        {
            label: "Data Mapping Document",
            tooltip: "Dozer based configuration of mapping documents",
            icon: "/img/icons/dozer/dozer.gif",
            exemplar: "dozer-mapping.xml",
            regex: defaultFileNamePattern,
            invalid: defaultFileNamePatternInvalid,
            extension: ".xml"
        }
    ];
    function isWikiEnabled(workspace, jolokia, localStorage) {
        return Git.createGitRepository(workspace, jolokia, localStorage) !== null;
    }
    Wiki.isWikiEnabled = isWikiEnabled;
    function goToLink(link, $timeout, $location) {
        var href = Core.trimLeading(link, "#");
        $timeout(function () {
            Wiki.log.debug("About to navigate to: " + href);
            $location.url(href);
        }, 100);
    }
    Wiki.goToLink = goToLink;
    function customViewLinks($scope) {
        var branch = $scope.branch;
        var prefix = Core.trimLeading(Wiki.startLink(branch), "#");
        return Wiki.customWikiViewPages.map(function (path) { return prefix + path; });
    }
    Wiki.customViewLinks = customViewLinks;
    function createWizardTree(workspace, $scope) {
        var root = new Folder("New Documents");
        addCreateWizardFolders(workspace, $scope, root, Wiki.documentTemplates);
        return root;
    }
    Wiki.createWizardTree = createWizardTree;
    function addCreateWizardFolders(workspace, $scope, parent, templates) {
        angular.forEach(templates, function (template) {
            if (template['fabricOnly'] && !Fabric.hasFabric(workspace)) {
                return;
            }
            if (template.generated) {
                if (template.generated.mbean) {
                    var exists = workspace.treeContainsDomainAndProperties.apply(workspace, template.generated.mbean);
                    if (!exists) {
                        return;
                    }
                }
                if (template.generated.init) {
                    template.generated.init(workspace, $scope);
                }
            }
            var title = template.label || key;
            var node = new Folder(title);
            node.parent = parent;
            node.entity = template;
            var addClass = template.addClass;
            if (addClass) {
                node.addClass = addClass;
            }
            var key = template.exemplar;
            var parentKey = parent.key || "";
            node.key = parentKey ? parentKey + "_" + key : key;
            var icon = template.icon;
            if (icon) {
                node.icon = Core.url(icon);
            }
            var tooltip = template["tooltip"] || template["description"] || '';
            node.tooltip = tooltip;
            if (template["folder"]) {
                node.isFolder = function () {
                    return true;
                };
            }
            parent.children.push(node);
            var children = template.children;
            if (children) {
                addCreateWizardFolders(workspace, $scope, node, children);
            }
        });
    }
    Wiki.addCreateWizardFolders = addCreateWizardFolders;
    function startLink(branch) {
        var start = "#/wiki";
        if (branch) {
            start += "/branch/" + branch;
        }
        return start;
    }
    Wiki.startLink = startLink;
    function isIndexPage(path) {
        return path && (path.endsWith("index.md") || path.endsWith("index.html") || path.endsWith("index")) ? true : false;
    }
    Wiki.isIndexPage = isIndexPage;
    function viewLink(branch, pageId, $location, fileName) {
        if (fileName === void 0) { fileName = null; }
        var link = null;
        var start = startLink(branch);
        if (pageId) {
            var view = isIndexPage(pageId) ? "/book/" : "/view/";
            link = start + view + encodePath(Core.trimLeading(pageId, "/"));
        }
        else {
            var path = $location.path();
            link = "#" + path.replace(/(edit|create)/, "view");
        }
        if (fileName && pageId && pageId.endsWith(fileName)) {
            return link;
        }
        if (fileName) {
            if (!link.endsWith("/")) {
                link += "/";
            }
            link += fileName;
        }
        return link;
    }
    Wiki.viewLink = viewLink;
    function branchLink(branch, pageId, $location, fileName) {
        if (fileName === void 0) { fileName = null; }
        return viewLink(branch, pageId, $location, fileName);
    }
    Wiki.branchLink = branchLink;
    function editLink(branch, pageId, $location) {
        var link = null;
        var format = Wiki.fileFormat(pageId);
        switch (format) {
            case "image":
                break;
            default:
                var start = startLink(branch);
                if (pageId) {
                    link = start + "/edit/" + encodePath(pageId);
                }
                else {
                    var path = $location.path();
                    link = "#" + path.replace(/(view|create)/, "edit");
                }
        }
        return link;
    }
    Wiki.editLink = editLink;
    function createLink(branch, pageId, $location, $scope) {
        var path = $location.path();
        var start = startLink(branch);
        var link = '';
        if (pageId) {
            link = start + "/create/" + encodePath(pageId);
        }
        else {
            link = "#" + path.replace(/(view|edit|formTable)/, "create");
        }
        var idx = link.lastIndexOf("/");
        if (idx > 0 && !$scope.children && !path.startsWith("/wiki/formTable")) {
            link = link.substring(0, idx + 1);
        }
        return link;
    }
    Wiki.createLink = createLink;
    function encodePath(pageId) {
        return pageId.split("/").map(encodeURIComponent).join("/");
    }
    Wiki.encodePath = encodePath;
    function decodePath(pageId) {
        return pageId.split("/").map(decodeURIComponent).join("/");
    }
    Wiki.decodePath = decodePath;
    function fileFormat(name, fileExtensionTypeRegistry) {
        var extension = fileExtension(name);
        var answer = null;
        if (!fileExtensionTypeRegistry) {
            fileExtensionTypeRegistry = Core.injector.get("fileExtensionTypeRegistry");
        }
        angular.forEach(fileExtensionTypeRegistry, function (array, key) {
            if (array.indexOf(extension) >= 0) {
                answer = key;
            }
        });
        return answer;
    }
    Wiki.fileFormat = fileFormat;
    function fileName(path) {
        if (path) {
            var idx = path.lastIndexOf("/");
            if (idx > 0) {
                return path.substring(idx + 1);
            }
        }
        return path;
    }
    Wiki.fileName = fileName;
    function fileParent(path) {
        if (path) {
            var idx = path.lastIndexOf("/");
            if (idx > 0) {
                return path.substring(0, idx);
            }
        }
        return "";
    }
    Wiki.fileParent = fileParent;
    function hideFileNameExtensions(name) {
        if (name) {
            angular.forEach(Wiki.hideExtensions, function (extension) {
                if (name.endsWith(extension)) {
                    name = name.substring(0, name.length - extension.length);
                }
            });
        }
        return name;
    }
    Wiki.hideFileNameExtensions = hideFileNameExtensions;
    function gitRestURL(branch, path) {
        var url = gitRelativeURL(branch, path);
        url = Core.url('/' + url);
        var connectionName = Core.getConnectionNameParameter(location.search);
        if (connectionName) {
            var connectionOptions = Core.getConnectOptions(connectionName);
            if (connectionOptions) {
                connectionOptions.path = url;
                url = Core.createServerConnectionUrl(connectionOptions);
            }
        }
        return url;
    }
    Wiki.gitRestURL = gitRestURL;
    function gitRelativeURL(branch, path) {
        branch = branch || "master";
        path = path || "/";
        return UrlHelpers.join("git/" + branch, path);
    }
    Wiki.gitRelativeURL = gitRelativeURL;
    function fileIconHtml(row) {
        var name = row.name;
        var path = row.path;
        var branch = row.branch;
        var directory = row.directory;
        var xmlNamespaces = row.xmlNamespaces;
        var iconUrl = row.iconUrl;
        var entity = row.entity;
        if (entity) {
            name = name || entity.name;
            path = path || entity.path;
            branch = branch || entity.branch;
            directory = directory || entity.directory;
            xmlNamespaces = xmlNamespaces || entity.xmlNamespaces;
            iconUrl = iconUrl || entity.iconUrl;
        }
        branch = branch || "master";
        var css = null;
        var icon = null;
        var extension = fileExtension(name);
        if (xmlNamespaces && xmlNamespaces.length) {
            if (xmlNamespaces.any(function (ns) { return Wiki.camelNamespaces.any(ns); })) {
                icon = "img/icons/camel.svg";
            }
            else if (xmlNamespaces.any(function (ns) { return Wiki.dozerNamespaces.any(ns); })) {
                icon = "img/icons/dozer/dozer.gif";
            }
            else if (xmlNamespaces.any(function (ns) { return Wiki.activemqNamespaces.any(ns); })) {
                icon = "img/icons/messagebroker.svg";
            }
            else {
                Wiki.log.debug("file " + name + " has namespaces " + xmlNamespaces);
            }
        }
        if (iconUrl) {
            css = null;
            icon = UrlHelpers.join("git", iconUrl);
            var connectionName = Core.getConnectionNameParameter(location.search);
            if (connectionName) {
                var connectionOptions = Core.getConnectOptions(connectionName);
                if (connectionOptions) {
                    connectionOptions.path = Core.url('/' + icon);
                    icon = Core.createServerConnectionUrl(connectionOptions);
                }
            }
        }
        if (!icon) {
            if (directory) {
                switch (extension) {
                    case 'profile':
                        css = "icon-book";
                        break;
                    default:
                        css = "icon-folder-close";
                }
            }
            else {
                switch (extension) {
                    case 'png':
                    case 'svg':
                    case 'jpg':
                    case 'gif':
                        css = null;
                        icon = Wiki.gitRelativeURL(branch, path);
                        var connectionName = Core.getConnectionNameParameter(location.search);
                        if (connectionName) {
                            var connectionOptions = Core.getConnectOptions(connectionName);
                            if (connectionOptions) {
                                connectionOptions.path = Core.url('/' + icon);
                                icon = Core.createServerConnectionUrl(connectionOptions);
                            }
                        }
                        break;
                    case 'json':
                    case 'xml':
                        css = "icon-file-text";
                        break;
                    case 'md':
                        css = "icon-file-text-alt";
                        break;
                    default:
                        css = "icon-file-alt";
                }
            }
        }
        if (icon) {
            return "<img src='" + Core.url(icon) + "'>";
        }
        else {
            return "<i class='" + css + "'></i>";
        }
    }
    Wiki.fileIconHtml = fileIconHtml;
    function iconClass(row) {
        var name = row.getProperty("name");
        var extension = fileExtension(name);
        var directory = row.getProperty("directory");
        if (directory) {
            return "icon-folder-close";
        }
        if ("xml" === extension) {
            return "icon-cog";
        }
        else if ("md" === extension) {
            return "icon-file-text-alt";
        }
        return "icon-file-alt";
    }
    Wiki.iconClass = iconClass;
    function initScope($scope, $routeParams, $location) {
        $scope.pageId = Wiki.pageId($routeParams, $location);
        var branch = $routeParams["branch"];
        if (branch == 'default-version') {
            branch = $scope.defaultVersion;
        }
        $scope.branch = branch || $location.search()["branch"];
        $scope.objectId = $routeParams["objectId"];
        $scope.startLink = Wiki.startLink($scope.branch);
        $scope.historyLink = startLink($scope.branch) + "/history/" + ($scope.pageId || "");
    }
    Wiki.initScope = initScope;
    function loadBranches(jolokia, wikiRepository, $scope, isFmc) {
        if (isFmc === void 0) { isFmc = false; }
        if (isFmc) {
            $scope.branches = Fabric.getVersionIds(jolokia);
            var defaultVersion = Fabric.getDefaultVersionId(jolokia);
            if (!$scope.branch) {
                $scope.branch = defaultVersion;
            }
            $scope.branches = $scope.branches.sortBy(function (v) { return Core.versionToSortableString(v); }, true);
            Core.$apply($scope);
        }
        else {
            wikiRepository.branches(function (response) {
                $scope.branches = response.sortBy(function (v) { return Core.versionToSortableString(v); }, true);
                if (!$scope.branch && $scope.branches.find(function (branch) {
                    return branch === "master";
                })) {
                    $scope.branch = "master";
                }
                Core.$apply($scope);
            });
        }
    }
    Wiki.loadBranches = loadBranches;
    function pageId($routeParams, $location) {
        var pageId = $routeParams['page'];
        if (!pageId) {
            for (var i = 0; i < 100; i++) {
                var value = $routeParams['path' + i];
                if (angular.isDefined(value)) {
                    if (!pageId) {
                        pageId = value;
                    }
                    else {
                        pageId += "/" + value;
                    }
                }
                else
                    break;
            }
            return pageId || "/";
        }
        if (!pageId) {
            pageId = pageIdFromURI($location.path());
        }
        return pageId;
    }
    Wiki.pageId = pageId;
    function pageIdFromURI(url) {
        var wikiPrefix = "/wiki/";
        if (url && url.startsWith(wikiPrefix)) {
            var idx = url.indexOf("/", wikiPrefix.length + 1);
            if (idx > 0) {
                return url.substring(idx + 1, url.length);
            }
        }
        return null;
    }
    Wiki.pageIdFromURI = pageIdFromURI;
    function fileExtension(name) {
        if (name.indexOf('#') > 0)
            name = name.substring(0, name.indexOf('#'));
        return Core.fileExtension(name, "markdown");
    }
    Wiki.fileExtension = fileExtension;
    function onComplete(status) {
        console.log("Completed operation with status: " + JSON.stringify(status));
    }
    Wiki.onComplete = onComplete;
    function parseJson(text) {
        if (text) {
            try {
                return JSON.parse(text);
            }
            catch (e) {
                Core.notification("error", "Failed to parse JSON: " + e);
            }
        }
        return null;
    }
    Wiki.parseJson = parseJson;
    function adjustHref($scope, $location, href, fileExtension) {
        var extension = fileExtension ? "." + fileExtension : "";
        var path = $location.path();
        var folderPath = path;
        var idx = path.lastIndexOf("/");
        if (idx > 0) {
            var lastName = path.substring(idx + 1);
            if (lastName.indexOf(".") >= 0) {
                folderPath = path.substring(0, idx);
            }
        }
        if (href.startsWith('../')) {
            var parts = href.split('/');
            var pathParts = folderPath.split('/');
            var parents = parts.filter(function (part) {
                return part === "..";
            });
            parts = parts.last(parts.length - parents.length);
            pathParts = pathParts.first(pathParts.length - parents.length);
            return '#' + pathParts.join('/') + '/' + parts.join('/') + extension + $location.hash();
        }
        if (href.startsWith('/')) {
            return Wiki.branchLink($scope.branch, href + extension, $location) + extension;
        }
        if (!Wiki.excludeAdjustmentPrefixes.any(function (exclude) {
            return href.startsWith(exclude);
        })) {
            return '#' + folderPath + "/" + href + extension + $location.hash();
        }
        else {
            return null;
        }
    }
    Wiki.adjustHref = adjustHref;
})(Wiki || (Wiki = {}));
var Fabric;
(function (Fabric) {
    ;
    var IconRegistry = (function () {
        function IconRegistry() {
            this.icons = {};
        }
        IconRegistry.prototype.addIcons = function (icon, domain) {
            var _this = this;
            var domains = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                domains[_i - 2] = arguments[_i];
            }
            this.addIcon(icon, domain);
            if (domains && angular.isArray(domains)) {
                domains.forEach(function (domain) {
                    _this.addIcon(icon, domain);
                });
            }
        };
        IconRegistry.prototype.addIcon = function (icon, domain) {
            this.icons[domain] = icon;
        };
        IconRegistry.prototype.getIcons = function (things) {
            var _this = this;
            var answer = [];
            if (things && angular.isArray(things)) {
                things.forEach(function (thing) {
                    if (_this.icons[thing]) {
                        answer.push(_this.icons[thing]);
                    }
                });
            }
            return answer.unique();
        };
        IconRegistry.prototype.getIcon = function (thing) {
            return this.icons[thing];
        };
        return IconRegistry;
    })();
    Fabric.IconRegistry = IconRegistry;
    Fabric.javaIcon = {
        title: "Java",
        type: "img",
        src: "img/icons/java.svg"
    };
    Fabric.serviceIconRegistry = new IconRegistry();
    Fabric.serviceIconRegistry.addIcons({
        title: "Kubernetes",
        type: "img",
        src: "img/icons/kubernetes.svg"
    }, "io.kubernetes");
    Fabric.serviceIconRegistry.addIcons({
        title: "Fabric8",
        type: "img",
        src: "img/icons/fabric8_icon.svg"
    }, "io.fabric8", "org.fusesource.fabric");
    Fabric.serviceIconRegistry.addIcons({
        title: "hawtio",
        type: "img",
        src: "img/hawtio_icon.svg"
    }, "hawtio");
    Fabric.serviceIconRegistry.addIcons({
        title: "Apache ActiveMQ",
        type: "img",
        src: "img/icons/messagebroker.svg"
    }, "org.apache.activemq");
    Fabric.serviceIconRegistry.addIcons({
        title: "Apache Camel",
        type: "img",
        src: "img/icons/camel.svg"
    }, "org.apache.camel");
    Fabric.serviceIconRegistry.addIcons({
        title: "Apache CXF",
        type: "icon",
        src: "icon-puzzle-piece"
    }, "org.apache.cxf");
    Fabric.serviceIconRegistry.addIcons({
        title: "Apache Karaf",
        type: "icon",
        src: "icon-beaker"
    }, "org.apache.karaf");
    Fabric.serviceIconRegistry.addIcons({
        title: "Apache Zookeeper",
        type: "icon",
        src: "icon-group"
    }, "org.apache.zookeeper");
    Fabric.serviceIconRegistry.addIcons({
        title: "Jetty",
        type: "img",
        src: "img/icons/jetty.svg"
    }, "org.eclipse.jetty.server");
    Fabric.serviceIconRegistry.addIcons({
        title: "Apache Tomcat",
        type: "img",
        src: "img/icons/tomcat.svg"
    }, "Catalina", "Tomcat");
    Fabric.serviceIconRegistry.addIcons({
        title: "WildFly",
        type: "img",
        src: "img/icons/wildfly.svg"
    }, "jboss", "wildfly");
    Fabric.serviceIconRegistry.addIcons({
        title: "Apache Cassandra",
        type: "img",
        src: "img/icons/cassandra.svg",
        "class": "girthy"
    }, "org.apache.cassandra.db", "org.apache.cassandra.metrics", "org.apache.cassandra.net", "org.apache.cassandra.request");
    Fabric.containerIconRegistry = new IconRegistry();
    Fabric.containerIconRegistry.addIcons({
        title: "Apache Karaf",
        type: "icon",
        src: "icon-beaker"
    }, "karaf");
    Fabric.containerIconRegistry.addIcons({
        title: "Apache Cassandra",
        type: "img",
        src: "img/icons/cassandra.svg",
        "class": "girthy"
    }, "Cassandra");
    Fabric.containerIconRegistry.addIcons({
        title: "Apache Tomcat",
        type: "img",
        src: "img/icons/tomcat.svg"
    }, "Tomcat");
    Fabric.containerIconRegistry.addIcons({
        title: "Apache TomEE",
        type: "img",
        src: "img/icons/tomcat.svg"
    }, "TomEE");
    Fabric.containerIconRegistry.addIcons({
        title: "Jetty",
        type: "img",
        src: "img/icons/jetty.svg"
    }, "Jetty");
    Fabric.containerIconRegistry.addIcons({
        title: "Kubernetes",
        type: "img",
        src: "img/icons/kubernetes.svg"
    }, "kubelet");
    Fabric.containerIconRegistry.addIcons({
        title: "WildFly",
        type: "img",
        src: "img/icons/wildfly.svg"
    }, "WildFly");
    Fabric.containerIconRegistry.addIcons(Fabric.javaIcon, "java");
})(Fabric || (Fabric = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.LoginController", ["$scope", "jolokia", "userDetails", "jolokiaUrl", "workspace", "localStorage", "branding", "postLoginTasks", function ($scope, jolokia, userDetails, jolokiaUrl, workspace, localStorage, branding, postLoginTasks) {
        jolokia.stop();
        $scope.userDetails = userDetails;
        $scope.entity = {
            username: '',
            password: ''
        };
        $scope.backstretch = $.backstretch(branding.loginBg);
        $scope.rememberMe = false;
        if ('userDetails' in localStorage) {
            $scope.rememberMe = true;
            var details = angular.fromJson(localStorage['userDetails']);
            $scope.entity.username = details.username;
            $scope.entity.password = details.password;
        }
        $scope.branding = branding;
        $scope.$watch('userDetails', function (newValue) {
            if (newValue.username) {
                $scope.entity.username = newValue.username;
            }
            if (newValue.password) {
                $scope.entity.password = newValue.password;
            }
        }, true);
        $scope.$on('$routeChangeStart', function () {
            if ($scope.backstretch) {
                $scope.backstretch.destroy();
            }
        });
        $scope.doLogin = function () {
            if (jolokiaUrl) {
                var url = "auth/login/";
                if ($scope.entity.username.trim() != '') {
                    $.ajax(url, {
                        type: "POST",
                        success: function (response) {
                            userDetails.username = $scope.entity.username;
                            userDetails.password = $scope.entity.password;
                            userDetails.loginDetails = response;
                            if ($scope.rememberMe) {
                                localStorage['userDetails'] = angular.toJson(userDetails);
                            }
                            else {
                                delete localStorage['userDetails'];
                            }
                            jolokia.start();
                            workspace.loadTree();
                            Core.executePostLoginTasks();
                            Core.$apply($scope);
                        },
                        error: function (xhr, textStatus, error) {
                            switch (xhr.status) {
                                case 401:
                                    Core.notification('error', 'Failed to log in, ' + error);
                                    break;
                                case 403:
                                    Core.notification('error', 'Failed to log in, ' + error);
                                    break;
                                default:
                                    Core.notification('error', 'Failed to log in, ' + error);
                                    break;
                            }
                            Core.$apply($scope);
                        },
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('Authorization', Core.getBasicAuthHeader($scope.entity.username, $scope.entity.password));
                        }
                    });
                }
            }
        };
    }]);
})(Core || (Core = {}));
var Fabric;
(function (Fabric) {
    Fabric.OpenShiftCredentials = {
        username: null,
        password: null
    };
    function fabricCreated(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "Fabric" });
    }
    Fabric.fabricCreated = fabricCreated;
    function canBootstrapFabric(workspace) {
        return hasClusterBootstrapManager(workspace);
    }
    Fabric.canBootstrapFabric = canBootstrapFabric;
    function hasClusterBootstrapManager(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "ClusterBootstrapManager" });
    }
    Fabric.hasClusterBootstrapManager = hasClusterBootstrapManager;
    function hasClusterServiceManager(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "ClusterServiceManager" });
    }
    Fabric.hasClusterServiceManager = hasClusterServiceManager;
    function hasZooKeeper(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "ZooKeeper" });
    }
    Fabric.hasZooKeeper = hasZooKeeper;
    function hasOpenShiftFabric(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "OpenShift" });
    }
    Fabric.hasOpenShiftFabric = hasOpenShiftFabric;
    function hasMQManager(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.jmxDomain, { type: "MQManager" });
    }
    Fabric.hasMQManager = hasMQManager;
    function hasSchemaMBean(workspace) {
        return workspace.treeContainsDomainAndProperties(Fabric.schemaLookupDomain, { type: Fabric.schemaLookupType });
    }
    Fabric.hasSchemaMBean = hasSchemaMBean;
    function hasGitMBean(workspace) {
        return workspace.treeContainsDomainAndProperties(Git.jmxDomain, { type: Git.mbeanType });
    }
    Fabric.hasGitMBean = hasGitMBean;
    function isFMCContainer(workspace) {
        var hasFabric = Fabric.hasFabric(workspace);
        var hasSchemaMBean = Fabric.hasSchemaMBean(workspace);
        var hasGitMBean = Fabric.hasGitMBean(workspace);
        return hasFabric && hasSchemaMBean && hasGitMBean;
    }
    Fabric.isFMCContainer = isFMCContainer;
    function hasFabric(workspace) {
        return fabricCreated(workspace) && (hasClusterServiceManager(workspace) || hasClusterBootstrapManager(workspace) || hasZooKeeper(workspace));
    }
    Fabric.hasFabric = hasFabric;
    function initScope($scope, $location, jolokia, workspace) {
        if ($scope.fabricInitialized) {
            return;
        }
        else {
            $scope.fabricInitialized = true;
        }
        ContainerHelpers.decorate($scope, $location, jolokia);
        $scope.gotoProfile = function (versionId, profileId) {
            Fabric.gotoProfile(workspace, jolokia, workspace.localStorage, $location, versionId, profileId);
        };
        $scope.refreshProfile = function (versionId, profileId) {
            Fabric.log.debug('Refreshing profile: ' + profileId + '/' + versionId);
            if (!versionId || !profileId) {
                return;
            }
            jolokia.request({
                type: 'exec',
                mbean: Fabric.managerMBean,
                operation: 'refreshProfile',
                arguments: [versionId, profileId]
            }, {
                method: 'POST',
                success: function () {
                    Core.notification('success', 'Triggered refresh of profile ' + profileId + '/' + versionId);
                    Core.$apply($scope);
                },
                error: function (response) {
                    Fabric.log.warn('Failed to trigger refresh for profile ' + profileId + '/' + versionId + ' due to: ', response.error);
                    Fabric.log.info("Stack trace: ", response.stacktrace);
                    Core.$apply($scope);
                }
            });
        };
        $scope.getVersionsToExclude = function () {
            if (!$scope.selectedContainers || $scope.selectedContainers.length === 0) {
                return [];
            }
            var answer = $scope.selectedContainers.map(function (c) { return c['versionId']; });
            answer = answer.unique();
            if (answer.length > 1) {
                return [];
            }
            else {
                return answer;
            }
        };
        $scope.hasFabricWiki = function () {
            return Git.isGitMBeanFabric(workspace);
        };
        $scope.createRequiredContainers = function (profile) {
            var profileId = profile.id;
            var args = {};
            if (profileId) {
                args["profileIds"] = profileId;
            }
            var versionId = profile.versionId || profile.version;
            if (versionId) {
                args["versionId"] = versionId;
            }
            var requirements = profile.requirements;
            if (requirements) {
                var min = requirements.minimumInstances;
                if (min) {
                    var delta = min - (profile.count || 0);
                    if (delta > 1) {
                        args["number"] = delta;
                    }
                }
            }
            $location.url('/fabric/containers/createContainer').search(args);
        };
        $scope.createContainer = function () {
            var kind = null;
            var providers = registeredProviders(jolokia);
            angular.forEach(["openshift", "docker", "jclouds"], function (value) {
                if (!kind && providers[value]) {
                    kind = value;
                }
            });
            if (!kind) {
                kind = 'child';
            }
            $location.url('/fabric/containers/createContainer').search('tab', kind);
        };
        $scope.createChildContainer = function (container) {
            if (!container.root || !container.alive) {
                return;
            }
            $location.url('/fabric/containers/createContainer').search({ 'tab': 'child', 'parentId': container.id });
        };
        $scope.showProfile = function (profile) {
            var version = profile.versionId || profile.version || $scope.activeVersionId;
            Fabric.gotoProfile(workspace, jolokia, localStorage, $location, version, profile);
        };
        $scope.getSelectedClass = function (obj) {
            var answer = [];
            if (obj.selected) {
                answer.push('selected');
            }
            if (angular.isDefined(obj['root']) && obj['root'] === false) {
                answer.push('child-container');
            }
            return answer.join(' ');
        };
        $scope.isEnsembleContainer = function (containerId) {
            if (angular.isArray($scope.ensembleContainerIds)) {
                return $scope.ensembleContainerIds.any(containerId);
            }
            return false;
        };
        $scope.connect = {
            dialog: new UI.Dialog(),
            saveCredentials: false,
            userName: null,
            password: null,
            container: null,
            view: null,
            onOK: function () {
                var userName = $scope.connect.userName;
                var password = $scope.connect.password;
                var userDetails = Core.injector.get('userDetails');
                if (!userDetails.password) {
                    userDetails.password = password;
                }
                var container = $scope.connect.container;
                if ($scope.connect.saveCredentials) {
                    $scope.connect.saveCredentials = false;
                    if (userName) {
                        localStorage['fabric.userName'] = userName;
                    }
                    if (password) {
                        localStorage['fabric.password'] = password;
                    }
                }
                var options = Core.createConnectOptions({
                    jolokiaUrl: container.jolokiaUrl,
                    userName: userName,
                    password: password,
                    useProxy: true,
                    view: $scope.connect.view,
                    name: container.id
                });
                Core.connectToServer(localStorage, options);
                $scope.connect.container = {};
                setTimeout(function () {
                    $scope.connect.dialog.close();
                    Core.$apply($scope);
                }, 100);
            }
        };
        $scope.doConnect = function (container, view) {
            if (!$scope.canConnect(container)) {
                return;
            }
            var userDetails = Core.injector.get('userDetails');
            $scope.connect.userName = userDetails.username;
            $scope.connect.password = userDetails.password;
            $scope.connect.container = container;
            $scope.connect.view = view || "#/openlogs";
            var alwaysPrompt = localStorage['fabricAlwaysPrompt'];
            if ((alwaysPrompt && alwaysPrompt !== "false") || !$scope.connect.userName || !$scope.connect.password) {
                $scope.connect.dialog.open();
            }
            else {
                $scope.connect.onOK();
            }
        };
        $scope.confirmDeleteDialog = {
            dialog: new UI.Dialog(),
            onOk: function () {
                $scope.confirmDeleteDialog.dialog.close();
                if (angular.isDefined($scope.containerId)) {
                    Core.unregister(jolokia, $scope);
                    $location.path('/fabric/containers');
                    ContainerHelpers.doDeleteContainer($scope, jolokia, $scope.containerId);
                }
                else if (angular.isDefined($scope.selectedContainers)) {
                    $scope.selectedContainers.each(function (c) {
                        ContainerHelpers.doDeleteContainer($scope, jolokia, c.id);
                    });
                }
                else {
                    Fabric.log.info("Asked to delete containers but no containerId or selectedContainers attributes available");
                }
            },
            open: function () {
                $scope.confirmDeleteDialog.dialog.open();
            },
            close: function () {
                $scope.confirmDeleteDialog.dialog.close();
            }
        };
        $scope.$watch('selectedContainers', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                var num = $scope.selectedContainers.length;
                $scope.versionTitle = "Migrate " + Core.maybePlural(num, "Container") + " to:";
            }
        });
        $scope.onVersionChange = function (version) {
            var containerIds = [];
            if (angular.isDefined($scope.selectedContainers)) {
                containerIds = $scope.selectedContainers.map(function (c) { return c.id; });
            }
            else if (angular.isDefined($scope.row)) {
                containerIds = [$scope.row.id];
            }
            else {
                return;
            }
            Fabric.log.info("Setting version to " + version + " on containers: " + containerIds);
            Fabric.migrateContainers(jolokia, version, containerIds, function () {
                Core.notification('success', "Initiated container migration to version <strong>" + version + "</strong>, changes make take some time to complete");
                Core.$apply($scope);
            }, function (response) {
                Fabric.log.error("Failed to migrate containers due to ", response.error);
                Fabric.log.info("Stack trace: ", response.stacktrace);
                Core.$apply($scope);
            });
        };
        var verbose = workspace.localStorage['fabricVerboseNotifications'];
        $scope.fabricVerboseNotifications = verbose && verbose !== "false";
    }
    Fabric.initScope = initScope;
    function viewVersion(versionId, $location, $scope) {
        var defaultTarget = '/wiki/branch/' + versionId + '/view/fabric/profiles';
        var path = $location.path();
        var branch = $scope.branch || $scope.$parent.branch;
        if (!path.startsWith('/wiki/branch/') || !branch) {
            $location.path(defaultTarget);
        }
        else {
            path = path.replace('/branch/' + branch, '/branch/' + versionId);
            $location.path(path);
        }
    }
    Fabric.viewVersion = viewVersion;
    function doCreateVersion($scope, jolokia, $location, newVersionName) {
        var success = function (response) {
            var newVersion = response.value.id;
            Core.notification('success', "Created version <strong>" + newVersion + "</strong>, switching to this new version");
            var $rootScope = $scope.$root || $scope.$rootScope || $scope;
            if ($rootScope) {
                $rootScope.$broadcast('wikiBranchesUpdated');
            }
            viewVersion(newVersion, $location, $scope);
            Core.$apply($scope);
        };
        var error = function (response) {
            Fabric.log.error("Failed to create version due to :", response.error);
            Fabric.log.info("stack trace: ", response.stacktrace);
            Core.$apply($scope);
        };
        if (!Core.isBlank(newVersionName)) {
            Fabric.createVersionWithId(jolokia, newVersionName, success, error);
        }
        else {
            Fabric.createVersion(jolokia, success, error);
        }
    }
    Fabric.doCreateVersion = doCreateVersion;
    function sortVersions(versions, order) {
        return (versions || []).sortBy(function (v) {
            var answer = parseFloat(v['id']);
            if (answer === NaN) {
                answer = v['id'];
            }
            return answer;
        }, order);
    }
    Fabric.sortVersions = sortVersions;
    function pagePathToProfileId(pageId) {
        var answer = null;
        if (angular.isDefined(pageId) && pageId.has(Fabric.fabricTopLevel) && pageId !== Fabric.fabricTopLevel) {
            var profileId = pageId.remove(Fabric.fabricTopLevel);
            if ((Fabric.useDirectoriesInGit || !profileId.has("/"))) {
                var profileSeparator = profileId.indexOf(Fabric.profileSuffix + "/");
                var endsWithSuffix = profileId.endsWith(Fabric.profileSuffix);
                if (!Fabric.useDirectoriesInGit || endsWithSuffix || profileSeparator > 0) {
                    if (Fabric.useDirectoriesInGit) {
                        if (endsWithSuffix) {
                            profileId = Core.trimTrailing(profileId, Fabric.profileSuffix);
                        }
                        else if (profileSeparator > 0) {
                            profileId = profileId.substring(0, profileSeparator);
                        }
                        profileId = profileId.replace(/\//g, "-");
                    }
                    answer = profileId;
                }
            }
        }
        return answer;
    }
    Fabric.pagePathToProfileId = pagePathToProfileId;
    function profilePath(profileId) {
        if (profileId) {
            return profileId.replace(/-/g, "/") + Fabric.profileSuffix;
        }
        else {
            return null;
        }
    }
    Fabric.profilePath = profilePath;
    function profileLink(workspace, jolokia, localStorage, versionId, profileId) {
        var path;
        if (Wiki.isWikiEnabled(workspace, jolokia, localStorage)) {
            path = "/wiki/branch/" + versionId + "/view/fabric/profiles/" + Fabric.profilePath(profileId);
        }
        else {
            path = "/fabric/profile/" + versionId + "/" + profileId;
        }
        return path;
    }
    Fabric.profileLink = profileLink;
    function containerCountBadgeStyle(min, count) {
        if (min) {
            if (!count) {
                return "badge-important";
            }
            else {
                return min <= count ? "badge-success" : "badge-warning";
            }
        }
        return "";
    }
    Fabric.containerCountBadgeStyle = containerCountBadgeStyle;
    function gotoProfile(workspace, jolokia, localStorage, $location, versionId, profile) {
        var path = '';
        if (angular.isString(profile)) {
            path = profileLink(workspace, jolokia, localStorage, versionId, profile);
        }
        else {
            path = profileLink(workspace, jolokia, localStorage, versionId, profile.id);
        }
        if (!Core.isBlank(path)) {
            $location.url(path);
        }
    }
    Fabric.gotoProfile = gotoProfile;
    function gotoContainer(containerId) {
        var $location = Core.injector.get('$location');
        $location.path(UrlHelpers.join('/fabric/container', containerId));
    }
    Fabric.gotoContainer = gotoContainer;
    function setSelect(selection, group) {
        if (!angular.isDefined(selection)) {
            return group[0];
        }
        var answer = group.findIndex(function (item) {
            return item.id === selection.id;
        });
        if (answer !== -1) {
            return group[answer];
        }
        else {
            return group[0];
        }
    }
    Fabric.setSelect = setSelect;
    Fabric.urlResolvers = ['http:', 'ftp:', 'mvn:'];
    function completeUri($q, $scope, workspace, jolokia, something) {
    }
    Fabric.completeUri = completeUri;
    function getActiveVersion($location) {
        return $location.search()['cv'] || "1.0";
    }
    Fabric.getActiveVersion = getActiveVersion;
    ;
    function loadRestApi(jolokia, workspace, $scope, callback) {
        if (callback === void 0) { callback = undefined; }
        if ($scope && !$scope.restApiUrl) {
            $scope.restApiUrl = Fabric.DEFAULT_REST_API;
        }
        Fabric.restApiUrl(jolokia, function (response) {
            var answer = response.value || Fabric.DEFAULT_REST_API;
            if (Fabric.isFMCContainer(workspace)) {
                try {
                    var url = new URI(answer);
                    var path = url.pathname();
                    if (path) {
                        answer = path;
                        response.value = answer;
                    }
                }
                catch (e) {
                }
                var connectionName = Core.getConnectionNameParameter(location.search);
                if (connectionName) {
                    var connectionOptions = Core.getConnectOptions(connectionName);
                    if (connectionOptions) {
                        connectionOptions.path = answer;
                        answer = Core.createServerConnectionUrl(connectionOptions);
                    }
                }
            }
            if ($scope) {
                $scope.restApiUrl = answer;
                Fabric.log.info("got REST API: " + $scope.restApiUrl);
                Core.$apply($scope);
            }
            if (callback) {
                callback(response);
            }
        });
    }
    Fabric.loadRestApi = loadRestApi;
    function toIconURL($scope, iconURL) {
        if (!iconURL) {
            return iconURL;
        }
        var connectionName = Core.getConnectionNameParameter(location.search);
        if (connectionName) {
            var connectionOptions = Core.getConnectOptions(connectionName);
            if (connectionOptions && !/^proxy\/http/.test(iconURL)) {
                connectionOptions.path = /^\//.test(iconURL) ? iconURL : Core.url("/git/") + iconURL;
                iconURL = Core.createServerConnectionUrl(connectionOptions);
            }
        }
        return iconURL;
    }
    Fabric.toIconURL = toIconURL;
    function getVersionsInUse(jolokia, callback) {
        Fabric.doAction('containers(java.util.List, java.util.List)', jolokia, [["versionId"], []], function (response) {
            var versionIds = response.value.map(function (el) {
                return el['versionId'];
            }).unique();
            callback(versionIds);
        }, function (response) {
            Fabric.log.debug("Failed to get versions in use: ", response);
            Fabric.log.debug("Stack Trace: ", response.stacktrace);
        });
    }
    Fabric.getVersionsInUse = getVersionsInUse;
    function onJolokiaUrlCreateJolokia(response, fn) {
        var jolokia = null;
        if (response) {
            var url = response.value;
            if (url) {
                url = Core.useProxyIfExternal(url);
                jolokia = Fabric.createJolokia(url);
            }
            else {
                if (response.error) {
                    Fabric.log.debug("Failed to fetch remote jolokia URL: ", response.error);
                    Fabric.log.debug("Stack trace: ", response.stacktrace);
                }
            }
            if (fn) {
                fn(jolokia);
            }
        }
        return jolokia;
    }
    function profileJolokia(jolokia, profileId, versionId, onJolokia) {
        function onJolokiaUrl(response) {
            return onJolokiaUrlCreateJolokia(response, onJolokia);
        }
        if (profileId && versionId) {
            return Fabric.profileWebAppURL(jolokia, Fabric.jolokiaWebAppGroupId, profileId, versionId, onJolokiaUrl, onJolokiaUrl);
        }
        else {
            onJolokia(null);
            return null;
        }
    }
    Fabric.profileJolokia = profileJolokia;
    function containerJolokia(jolokia, containerId, onJolokia) {
        function onJolokiaUrl(response) {
            return onJolokiaUrlCreateJolokia(response, onJolokia);
        }
        return Fabric.containerWebAppURL(jolokia, Fabric.jolokiaWebAppGroupId, containerId, onJolokiaUrl, onJolokiaUrl);
    }
    Fabric.containerJolokia = containerJolokia;
    function getServiceList(container) {
        var answer = [];
        var javaContainer = true;
        if (angular.isDefined(container) && angular.isDefined(container.jmxDomains) && angular.isArray(container.jmxDomains) && container.alive) {
            answer = Fabric.serviceIconRegistry.getIcons(container.jmxDomains);
        }
        return answer;
    }
    Fabric.getServiceList = getServiceList;
    function getTypeIcon(container) {
        var type = container.type;
        if (container.metadata && container.metadata.containerType) {
            type = container.metadata.containerType;
        }
        var answer = Fabric.containerIconRegistry.getIcon(type);
        if (!answer) {
            return Fabric.javaIcon;
        }
        else {
            return answer;
        }
    }
    Fabric.getTypeIcon = getTypeIcon;
    function usingProfile(group, targetId, action) {
        var profile = group.find(function (p) {
            return p.id === targetId;
        });
        if (profile) {
            action(profile);
        }
    }
    Fabric.usingProfile = usingProfile;
    function getDefaultVersionId(jolokia) {
        return (getDefaultVersion(jolokia) || {})["id"] || "1.0";
    }
    Fabric.getDefaultVersionId = getDefaultVersionId;
    function getDefaultVersion(jolokia) {
        return jolokia.execute(Fabric.managerMBean, "defaultVersion()");
    }
    Fabric.getDefaultVersion = getDefaultVersion;
    function setDefaultVersion(jolokia, newVersion, callback) {
        jolokia.setAttribute(Fabric.managerMBean, "DefaultVersion", newVersion, onSuccess(function (response) {
            callback();
        }));
    }
    Fabric.setDefaultVersion = setDefaultVersion;
    function defaultContainerValues(workspace, $scope, values) {
        var map = {};
        angular.forEach(values, function (row) {
            var profileIds = row["profileIds"];
            if (profileIds) {
                angular.forEach(profileIds, function (profileId) {
                    var containers = map[profileId];
                    if (!containers) {
                        containers = [];
                        map[profileId] = containers;
                    }
                    containers.push(row);
                });
            }
            $scope.profileMap = map;
            row["link"] = containerLinks(workspace, row["id"]);
            row["profileLinks"] = profileLinks(workspace, row["versionId"], profileIds);
            var versionId = row["versionId"];
            var versionHref = Core.url("#/fabric/profiles?v=" + versionId);
            var versionLink = "<a href='" + versionHref + "'>" + versionId + "</a>";
            row["versionHref"] = versionHref;
            row["versionLink"] = versionLink;
            var id = row['id'] || "";
            var title = "container " + id + " ";
            var img = "red-dot.png";
            if (row['managed'] === false) {
                img = "spacer.gif";
            }
            else if (!row['alive']) {
                img = "gray-dot.png";
            }
            else if (row['provisionPending']) {
                img = "pending.gif";
            }
            else if (row['provisionStatus'] === 'success') {
                img = "green-dot.png";
            }
            img = "img/dots/" + img;
            row["statusImageHref"] = img;
            row["link"] = "<img src='" + img + "' title='" + title + "'/> " + (row["link"] || id);
        });
        return values;
    }
    Fabric.defaultContainerValues = defaultContainerValues;
    function toCollection(values) {
        var collection = values;
        if (!angular.isArray(values)) {
            collection = [values];
        }
        return collection;
    }
    Fabric.toCollection = toCollection;
    function containerLinks(workspace, values) {
        var answer = "";
        angular.forEach(toCollection(values), function (value, key) {
            var prefix = "";
            if (answer.length > 0) {
                prefix = " ";
            }
            answer += prefix + "<a href='" + Core.url("#/fabric/container/" + value + workspace.hash()) + "'>" + value + "</a>";
        });
        return answer;
    }
    Fabric.containerLinks = containerLinks;
    function profileLinks(workspace, versionId, values) {
        var answer = "";
        angular.forEach(toCollection(values), function (value, key) {
            var prefix = "";
            if (answer.length > 0) {
                prefix = " ";
            }
            answer += prefix + "<a href='" + Core.url("#/fabric/profile/" + versionId + "/" + value + workspace.hash()) + "'>" + value + "</a>";
        });
        return answer;
    }
    Fabric.profileLinks = profileLinks;
    function defaultProfileValues(workspace, versionId, values) {
        angular.forEach(values, function (row) {
            var id = row["id"];
            row["link"] = profileLinks(workspace, versionId, id);
            row["parentLinks"] = profileLinks(workspace, versionId, row["parentIds"]);
            var containersHref = Core.url("#/fabric/containers?p=" + id);
            var containerCount = row["containerCount"];
            var containersLink = "";
            if (containerCount) {
                containersLink = "<a href='" + containersHref + "'>" + containerCount + "</a>";
            }
            row["containersCountLink"] = containersLink;
            row["containersHref"] = containersHref;
        });
        return values;
    }
    Fabric.defaultProfileValues = defaultProfileValues;
    function getZooKeeperFacadeMBean(workspace) {
        var folder = workspace.findMBeanWithProperties(Fabric.jmxDomain, { type: "ZooKeeper" });
        return Core.pathGet(folder, "objectName");
    }
    Fabric.getZooKeeperFacadeMBean = getZooKeeperFacadeMBean;
    Fabric.statusTitle = ContainerHelpers.statusTitle;
    Fabric.statusIcon = ContainerHelpers.statusIcon;
    function createJolokia(url) {
        var userDetails = Core.injector.get("userDetails");
        Fabric.log.info("Logging into remote jolokia " + url + " using user details: " + StringHelpers.toString(userDetails));
        return Core.createJolokia(url, userDetails.username, userDetails.password);
    }
    Fabric.createJolokia = createJolokia;
    function registeredProviders(jolokia) {
        var providers = jolokia.execute(Fabric.managerMBean, 'registeredValidProviders()');
        var answer = {};
        angular.forEach(providers, function (value, key) {
            answer[key] = {
                id: key,
                className: value
            };
        });
        return answer;
    }
    Fabric.registeredProviders = registeredProviders;
    function getSchema(id, className, jolokia, cb) {
        jolokia.execute(Fabric.schemaLookupMBean, 'getSchemaForClass(java.lang.String)', className, {
            method: 'POST',
            success: function (value) {
                cb(Fabric.customizeSchema(id, angular.fromJson(value)));
            }
        });
    }
    Fabric.getSchema = getSchema;
    function getDtoSchema(id, className, jolokia, cb) {
        jolokia.execute(Fabric.schemaLookupMBean, 'getSchemaForClass(java.lang.String)', className, {
            method: 'POST',
            success: function (value) {
                cb(angular.fromJson(value));
            }
        });
    }
    Fabric.getDtoSchema = getDtoSchema;
    function getCurrentContainer(jolokia, fields) {
        var name = jolokia.getAttribute(Fabric.managerMBean, 'CurrentContainerName', { method: 'POST' });
        return jolokia.execute(Fabric.managerMBean, "getContainer(java.lang.String, java.util.List)", name, fields, { method: 'POST' });
    }
    Fabric.getCurrentContainer = getCurrentContainer;
    function getContainerFields(jolokia, name, fields) {
        return jolokia.execute(Fabric.managerMBean, "getContainer(java.lang.String, java.util.List)", name, fields, { method: 'POST' });
    }
    Fabric.getContainerFields = getContainerFields;
    function getRootContainers(jolokia) {
        var fields = ["id", "root"];
        var answer = jolokia.execute(Fabric.managerMBean, "containers(java.util.List)", fields, { method: 'POST' });
        return answer.filter(function (c) {
            return c.root;
        }).map(function (v) { return v["id"]; });
    }
    Fabric.getRootContainers = getRootContainers;
    function getContainersFields(jolokia, fields, fn) {
        if (fn === void 0) { fn = null; }
        return jolokia.execute(Fabric.managerMBean, "containers(java.util.List)", fields, onSuccess(fn));
    }
    Fabric.getContainersFields = getContainersFields;
    function getOpenShiftDomains(workspace, jolokia, serverUrl, login, password, fn, onError) {
        if (fn === void 0) { fn = null; }
        if (onError === void 0) { onError = null; }
        if (hasOpenShiftFabric(workspace) && serverUrl && login && password) {
            var options = onSuccess(fn, { error: onError });
            return jolokia.execute(Fabric.openShiftFabricMBean, "getDomains", serverUrl, login, password, options);
        }
        else {
            if (fn) {
                fn([]);
            }
            return [];
        }
    }
    Fabric.getOpenShiftDomains = getOpenShiftDomains;
    function getOpenShiftGearProfiles(workspace, jolokia, serverUrl, login, password, fn) {
        if (fn === void 0) { fn = null; }
        if (hasOpenShiftFabric(workspace) && serverUrl && login && password) {
            return jolokia.execute(Fabric.openShiftFabricMBean, "getGearProfiles", serverUrl, login, password, onSuccess(fn));
        }
        else {
            if (fn) {
                fn([]);
            }
            return [];
        }
    }
    Fabric.getOpenShiftGearProfiles = getOpenShiftGearProfiles;
    function filterProfiles(jolokia, versionId, profileIds) {
        var profiles = [];
        if (versionId) {
            profiles = jolokia.execute(Fabric.managerMBean, "getProfiles(java.lang.String, java.util.List)", versionId, ['id', 'hidden', 'abstract'], { method: 'POST' });
        }
        profiles = profiles.filter(function (profile) {
            return profileIds.some(function (id) {
                return profile.id === id;
            });
        });
        profiles = profiles.filter((function (profile) {
            return !profile.abstract && !profile.hidden;
        }));
        return profiles.map(function (p) {
            return p.id;
        });
    }
    Fabric.filterProfiles = filterProfiles;
    function getProfileData(jolokia, versionId, profileId, fields) {
        return jolokia.execute(Fabric.managerMBean, "getProfile(java.lang.String, java.lang.String, java.util.List)", versionId, profileId, fields, { method: 'POST' });
    }
    Fabric.getProfileData = getProfileData;
    function getConfigFile(jolokia, versionId, profileId, fileName, fn) {
        if (fn === void 0) { fn = null; }
        function onResults(answer) {
            return answer ? answer.decodeBase64() : null;
        }
        var callback = !fn ? null : function (result) {
            fn(onResults(result));
        };
        var answer = jolokia.execute(Fabric.managerMBean, "getConfigurationFile(java.lang.String, java.lang.String, java.lang.String)", versionId, profileId, fileName, onSuccess(callback));
        return fn ? answer : onResults(answer);
    }
    Fabric.getConfigFile = getConfigFile;
    function brokerConfigLink(workspace, jolokia, localStorage, brokerVersion, brokerProfile, brokerId) {
        var path = Fabric.profileLink(workspace, jolokia, localStorage, brokerVersion, brokerProfile);
        path += "/io.fabric8.mq.fabric.server-" + brokerId + ".properties";
        return path;
    }
    Fabric.brokerConfigLink = brokerConfigLink;
    function connectToBroker($scope, container, postfix) {
        if (postfix === void 0) { postfix = null; }
        var view = "#/jmx/attributes?tab=activemq";
        if (postfix) {
            view += "&" + postfix;
        }
        $scope.doConnect(container, view);
    }
    Fabric.connectToBroker = connectToBroker;
    function sanitizeJson(json) {
        angular.forEach(json, function (value, key) {
            if (value === "") {
                delete json[key];
            }
        });
        return json;
    }
    Fabric.sanitizeJson = sanitizeJson;
})(Fabric || (Fabric = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.BrokerDiagramController", ["$scope", "$compile", "$location", "localStorage", "jolokia", "workspace", function ($scope, $compile, $location, localStorage, jolokia, workspace) {
        Fabric.initScope($scope, $location, jolokia, workspace);
        var isFmc = Fabric.isFMCContainer(workspace);
        $scope.isFmc = isFmc;
        $scope.selectedNode = null;
        var defaultFlags = {
            panel: true,
            popup: false,
            label: true,
            group: false,
            profile: false,
            slave: false,
            broker: isFmc,
            network: true,
            container: false,
            queue: true,
            topic: true,
            consumer: true,
            producer: true
        };
        $scope.viewSettings = {};
        $scope.shapeSize = {
            broker: 20,
            queue: 14,
            topic: 14
        };
        var redrawGraph = Core.throttled(doRedrawGraph, 1000);
        var graphBuilder = new ForceGraph.GraphBuilder();
        Core.bindModelToSearchParam($scope, $location, "searchFilter", "q", "");
        angular.forEach(defaultFlags, function (defaultValue, key) {
            var modelName = "viewSettings." + key;
            function currentValue() {
                var answer = $location.search()[paramName] || defaultValue;
                return answer === "false" ? false : answer;
            }
            var paramName = key;
            var value = currentValue();
            Core.pathSet($scope, modelName, value);
            $scope.$watch(modelName, function () {
                var current = Core.pathGet($scope, modelName);
                var old = currentValue();
                if (current !== old) {
                    var defaultValue = defaultFlags[key];
                    if (current !== defaultValue) {
                        if (!current) {
                            current = "false";
                        }
                        $location.search(paramName, current);
                    }
                    else {
                        $location.search(paramName, null);
                    }
                }
                redrawGraph();
            });
        });
        $scope.connectToBroker = function () {
            var selectedNode = $scope.selectedNode;
            if (selectedNode) {
                var container = selectedNode["brokerContainer"] || selectedNode;
                connectToBroker(container, selectedNode["brokerName"]);
            }
        };
        function connectToBroker(container, brokerName, postfix) {
            if (postfix === void 0) { postfix = null; }
            if (isFmc && container.jolokia !== jolokia) {
                Fabric.connectToBroker($scope, container, postfix);
            }
            else {
                var view = "/jmx/attributes?tab=activemq";
                if (!postfix) {
                    if (brokerName) {
                        postfix = "nid=root-org.apache.activemq-Broker-" + brokerName;
                    }
                }
                if (postfix) {
                    view += "&" + postfix;
                }
                ActiveMQ.log.info("Opening view " + view);
                var path = Core.url("/#" + view);
                window.open(path, '_destination');
                window.focus();
            }
        }
        $scope.connectToDestination = function () {
            var selectedNode = $scope.selectedNode;
            if (selectedNode) {
                var container = selectedNode["brokerContainer"] || selectedNode;
                var brokerName = selectedNode["brokerName"];
                var destinationType = selectedNode["destinationType"] || selectedNode["typeLabel"];
                var destinationName = selectedNode["destinationName"];
                var postfix = null;
                if (brokerName && destinationType && destinationName) {
                    postfix = "nid=root-org.apache.activemq-Broker-" + brokerName + "-" + destinationType + "-" + destinationName;
                }
                connectToBroker(container, brokerName, postfix);
            }
        };
        $scope.$on('$destroy', function (event) {
            stopOldJolokia();
        });
        function stopOldJolokia() {
            var oldJolokia = $scope.selectedNodeJolokia;
            if (oldJolokia && oldJolokia !== jolokia) {
                oldJolokia.stop();
            }
        }
        $scope.$watch("selectedNode", function (newValue, oldValue) {
            if ($scope.unregisterFn) {
                $scope.unregisterFn();
                $scope.unregisterFn = null;
            }
            var node = $scope.selectedNode;
            if (node) {
                var mbean = node.objectName;
                var brokerContainer = node.brokerContainer || {};
                var nodeJolokia = node.jolokia || brokerContainer.jolokia || jolokia;
                if (nodeJolokia !== $scope.selectedNodeJolokia) {
                    stopOldJolokia();
                    $scope.selectedNodeJolokia = nodeJolokia;
                    if (nodeJolokia !== jolokia) {
                        var rate = Core.parseIntValue(localStorage['updateRate'] || "2000", "update rate");
                        if (rate) {
                            nodeJolokia.start(rate);
                        }
                    }
                }
                var dummyResponse = { value: node.panelProperties || {} };
                if (mbean && nodeJolokia) {
                    ActiveMQ.log.debug("reading ", mbean, " on remote container");
                    $scope.unregisterFn = Core.register(nodeJolokia, $scope, {
                        type: 'read',
                        mbean: mbean
                    }, onSuccess(renderNodeAttributes, {
                        error: function (response) {
                            renderNodeAttributes(dummyResponse);
                            Core.defaultJolokiaErrorHandler(response);
                        }
                    }));
                }
                else {
                    ActiveMQ.log.debug("no mbean or jolokia available, using dummy response");
                    renderNodeAttributes(dummyResponse);
                }
            }
        });
        function getDestinationTypeName(attributes) {
            var prefix = attributes["DestinationTemporary"] ? "Temporary " : "";
            return prefix + (attributes["DestinationTopic"] ? "Topic" : "Queue");
        }
        var ignoreNodeAttributes = ["Broker", "BrokerId", "BrokerName", "Connection", "DestinationName", "DestinationQueue", "DestinationTemporary", "DestinationTopic", ];
        var ignoreNodeAttributesByType = {
            producer: ["Producer", "ProducerId"],
            queue: ["Name", "MessageGroups", "MessageGroupType", "Subscriptions"],
            topic: ["Name", "Subscriptions"],
            broker: ["DataDirectory", "DurableTopicSubscriptions", "DynamicDestinationProducers", "InactiveDurableToppicSubscribers"]
        };
        var brokerShowProperties = ["AverageMessageSize", "BrokerId", "JobSchedulerStorePercentUsage", "Slave", "MemoryPercentUsage", "StorePercentUsage", "TempPercentUsage"];
        var onlyShowAttributesByType = {
            broker: brokerShowProperties,
            brokerSlave: brokerShowProperties
        };
        function renderNodeAttributes(response) {
            var properties = [];
            if (response) {
                var value = response.value || {};
                $scope.selectedNodeAttributes = value;
                var selectedNode = $scope.selectedNode || {};
                var brokerContainer = selectedNode['brokerContainer'] || {};
                var nodeType = selectedNode["type"];
                var brokerName = selectedNode["brokerName"];
                var containerId = selectedNode["container"] || brokerContainer["container"];
                var group = selectedNode["group"] || brokerContainer["group"];
                var jolokiaUrl = selectedNode["jolokiaUrl"] || brokerContainer["jolokiaUrl"];
                var profile = selectedNode["profile"] || brokerContainer["profile"];
                var version = selectedNode["version"] || brokerContainer["version"];
                var isBroker = nodeType && nodeType.startsWith("broker");
                var ignoreKeys = ignoreNodeAttributes.concat(ignoreNodeAttributesByType[nodeType] || []);
                var onlyShowKeys = onlyShowAttributesByType[nodeType];
                angular.forEach(value, function (v, k) {
                    if (onlyShowKeys ? onlyShowKeys.indexOf(k) >= 0 : ignoreKeys.indexOf(k) < 0) {
                        var formattedValue = Core.humanizeValueHtml(v);
                        properties.push({ key: Core.humanizeValue(k), value: formattedValue });
                    }
                });
                properties = properties.sortBy("key");
                var brokerProperty = null;
                if (brokerName) {
                    var brokerHtml = '<a target="broker" ng-click="connectToBroker()">' + '<img title="Apache ActiveMQ" src="img/icons/messagebroker.svg"> ' + brokerName + '</a>';
                    if (version && profile) {
                        var brokerLink = Fabric.brokerConfigLink(workspace, jolokia, localStorage, version, profile, brokerName);
                        if (brokerLink) {
                            brokerHtml += ' <a title="configuration settings" target="brokerConfig" href="' + brokerLink + '"><i class="icon-tasks"></i></a>';
                        }
                    }
                    var html = $compile(brokerHtml)($scope);
                    brokerProperty = { key: "Broker", value: html };
                    if (!isBroker) {
                        properties.splice(0, 0, brokerProperty);
                    }
                }
                if (containerId) {
                    properties.splice(0, 0, { key: "Container", value: $compile('<div fabric-container-link="' + selectedNode['container'] + '"></div>')($scope) });
                }
                var destinationName = value["DestinationName"] || selectedNode["destinationName"];
                if (destinationName && (nodeType !== "queue" && nodeType !== "topic")) {
                    var destinationTypeName = getDestinationTypeName(value);
                    var html = createDestinationLink(destinationName, destinationTypeName);
                    properties.splice(0, 0, { key: destinationTypeName, value: html });
                }
                var typeLabel = selectedNode["typeLabel"];
                var name = selectedNode["name"] || selectedNode["id"] || selectedNode['objectName'];
                if (typeLabel) {
                    var html = name;
                    if (nodeType === "queue" || nodeType === "topic") {
                        html = createDestinationLink(name, nodeType);
                    }
                    var typeProperty = { key: typeLabel, value: html };
                    if (isBroker && brokerProperty) {
                        typeProperty = brokerProperty;
                    }
                    properties.splice(0, 0, typeProperty);
                }
            }
            $scope.selectedNodeProperties = properties;
            Core.$apply($scope);
        }
        function createDestinationLink(destinationName, destinationType) {
            if (destinationType === void 0) { destinationType = "queue"; }
            return $compile('<a target="destination" title="' + destinationName + '" ng-click="connectToDestination()">' + destinationName + '</a>')($scope);
        }
        $scope.$watch("searchFilter", function (newValue, oldValue) {
            redrawGraph();
        });
        if (isFmc) {
            Core.register(jolokia, $scope, { type: 'exec', mbean: Fabric.mqManagerMBean, operation: "loadBrokerStatus()" }, onSuccess(onBrokerData));
        }
        else {
            $scope.$watch('workspace.tree', function () {
                redrawGraph();
            });
            $scope.$on('jmxTreeUpdated', function () {
                redrawGraph();
            });
        }
        function onBrokerData(response) {
            if (response) {
                var responseJson = angular.toJson(response.value);
                if ($scope.responseJson === responseJson) {
                    return;
                }
                $scope.responseJson = responseJson;
                $scope.brokers = response.value;
                doRedrawGraph();
            }
        }
        function redrawFabricBrokers() {
            var containersToDelete = $scope.activeContainers || {};
            $scope.activeContainers = {};
            angular.forEach($scope.brokers, function (brokerStatus) {
                brokerStatus.validContainer = brokerStatus.alive && brokerStatus.master && brokerStatus.provisionStatus === "success";
                renameTypeProperty(brokerStatus);
                var groupId = brokerStatus.group;
                var profileId = brokerStatus.profile;
                var brokerId = brokerStatus.brokerName;
                var containerId = brokerStatus.container;
                var versionId = brokerStatus.version || "1.0";
                var group = getOrAddNode("group", groupId, brokerStatus, function () {
                    return {
                        typeLabel: "Broker Group",
                        popup: {
                            title: "Broker Group: " + groupId,
                            content: "<p>" + groupId + "</p>"
                        }
                    };
                });
                var profile = getOrAddNode("profile", profileId, brokerStatus, function () {
                    return {
                        typeLabel: "Profile",
                        popup: {
                            title: "Profile: " + profileId,
                            content: "<p>" + profileId + "</p>"
                        }
                    };
                });
                var container = null;
                if (containerId) {
                    container = getOrAddNode("container", containerId, brokerStatus, function () {
                        return {
                            containerId: containerId,
                            typeLabel: "Container",
                            popup: {
                                title: "Container: " + containerId,
                                content: "<p>" + containerId + " version: " + versionId + "</p>"
                            }
                        };
                    });
                }
                var master = brokerStatus.master;
                var broker = getOrAddBroker(master, brokerId, groupId, containerId, container, brokerStatus);
                if (container && container.validContainer) {
                    var key = container.containerId;
                    $scope.activeContainers[key] = container;
                    delete containersToDelete[key];
                }
                if ($scope.viewSettings.group) {
                    if ($scope.viewSettings.profile) {
                        addLink(group, profile, "group");
                        addLink(profile, broker, "broker");
                    }
                    else {
                        addLink(group, broker, "group");
                    }
                }
                else {
                    if ($scope.viewSettings.profile) {
                        addLink(profile, broker, "broker");
                    }
                }
                if (container) {
                    if ((master || $scope.viewSettings.slave) && $scope.viewSettings.container) {
                        addLink(broker, container, "container");
                        container.destinationLinkNode = container;
                    }
                    else {
                        container.destinationLinkNode = broker;
                    }
                }
            });
            redrawActiveContainers();
        }
        function redrawLocalBroker() {
            var container = {
                jolokia: jolokia
            };
            var containerId = "local";
            $scope.activeContainers = {
                containerId: container
            };
            if ($scope.viewSettings.broker) {
                jolokia.search("org.apache.activemq:type=Broker,brokerName=*", onSuccess(function (response) {
                    angular.forEach(response, function (objectName) {
                        var details = Core.parseMBean(objectName);
                        if (details) {
                            var properties = details['attributes'];
                            ActiveMQ.log.info("Got broker: " + objectName + " on container: " + containerId + " properties: " + angular.toJson(properties, true));
                            if (properties) {
                                var master = true;
                                var brokerId = properties["brokerName"] || "unknown";
                                var groupId = "";
                                var broker = getOrAddBroker(master, brokerId, groupId, containerId, container, properties);
                            }
                        }
                    });
                    redrawActiveContainers();
                }));
            }
            else {
                redrawActiveContainers();
            }
        }
        function redrawActiveContainers() {
            angular.forEach($scope.activeContainers, function (container, id) {
                var containerJolokia = container.jolokia;
                if (containerJolokia) {
                    onContainerJolokia(containerJolokia, container, id);
                }
                else {
                    Fabric.containerJolokia(jolokia, id, function (containerJolokia) { return onContainerJolokia(containerJolokia, container, id); });
                }
            });
            $scope.graph = graphBuilder.buildGraph();
            Core.$apply($scope);
        }
        function doRedrawGraph() {
            graphBuilder = new ForceGraph.GraphBuilder();
            if (isFmc) {
                redrawFabricBrokers();
            }
            else {
                redrawLocalBroker();
            }
        }
        function brokerNameMarkup(brokerName) {
            return brokerName ? "<p></p>broker: " + brokerName + "</p>" : "";
        }
        function matchesDestinationName(destinationName, typeName) {
            if (destinationName) {
                var selection = workspace.selection;
                if (selection && selection.domain === ActiveMQ.jmxDomain) {
                    var type = selection.entries["destinationType"];
                    if (type) {
                        if ((type === "Queue" && typeName === "topic") || (type === "Topic" && typeName === "queue")) {
                            return false;
                        }
                    }
                    var destName = selection.entries["destinationName"];
                    if (destName) {
                        if (destName !== destinationName)
                            return false;
                    }
                }
                ActiveMQ.log.info("selection: " + selection);
                return !$scope.searchFilter || destinationName.indexOf($scope.searchFilter) >= 0;
            }
            return false;
        }
        function onContainerJolokia(containerJolokia, container, id) {
            if (containerJolokia) {
                container.jolokia = containerJolokia;
                function getOrAddDestination(properties) {
                    var typeName = properties.destType;
                    var brokerName = properties.brokerName;
                    var destinationName = properties.destinationName;
                    if (!matchesDestinationName(destinationName, typeName)) {
                        return null;
                    }
                    var hideFlag = "topic" === typeName ? $scope.viewSettings.topic : $scope.viewSettings.queue;
                    if (!hideFlag) {
                        return null;
                    }
                    var destination = getOrAddNode(typeName, destinationName, properties, function () {
                        var destinationTypeName = properties.destinationType || "Queue";
                        var objectName = "";
                        if (brokerName) {
                            if (!destinationName.startsWith("ActiveMQ.Advisory.TempQueue_ActiveMQ.Advisory.TempTopic")) {
                                objectName = "org.apache.activemq:type=Broker,brokerName=" + brokerName + ",destinationType=" + destinationTypeName + ",destinationName=" + destinationName;
                            }
                        }
                        var answer = {
                            typeLabel: destinationTypeName,
                            brokerContainer: container,
                            objectName: objectName,
                            jolokia: containerJolokia,
                            popup: {
                                title: destinationTypeName + ": " + destinationName,
                                content: brokerNameMarkup(properties.brokerName)
                            }
                        };
                        if (!brokerName) {
                            containerJolokia.search("org.apache.activemq:destinationType=" + destinationTypeName + ",destinationName=" + destinationName + ",*", onSuccess(function (response) {
                                ActiveMQ.log.info("Found destination mbean: " + response);
                                if (response && response.length) {
                                    answer.objectName = response[0];
                                }
                            }));
                        }
                        return answer;
                    });
                    if (destination && $scope.viewSettings.broker && brokerName) {
                        addLinkIds(brokerNodeId(brokerName), destination["id"], "destination");
                    }
                    return destination;
                }
                var brokerId = container.brokerName;
                if (brokerId && $scope.viewSettings.network && $scope.viewSettings.broker) {
                    containerJolokia.request({ type: "read", mbean: "org.apache.activemq:connector=networkConnectors,*" }, onSuccess(function (response) {
                        angular.forEach(response.value, function (properties, objectName) {
                            var details = Core.parseMBean(objectName);
                            var attributes = details['attributes'];
                            if (properties) {
                                configureDestinationProperties(properties);
                                var remoteBrokerId = properties.RemoteBrokerName;
                                if (remoteBrokerId) {
                                    addLinkIds(brokerNodeId(brokerId), brokerNodeId(remoteBrokerId), "network");
                                }
                            }
                        });
                        graphModelUpdated();
                    }));
                }
                if ($scope.viewSettings.consumer) {
                    containerJolokia.search("org.apache.activemq:endpoint=Consumer,*", onSuccess(function (response) {
                        angular.forEach(response, function (objectName) {
                            var details = Core.parseMBean(objectName);
                            if (details) {
                                var properties = details['attributes'];
                                if (properties) {
                                    configureDestinationProperties(properties);
                                    var consumerId = properties.consumerId;
                                    if (consumerId) {
                                        var destination = getOrAddDestination(properties);
                                        if (destination) {
                                            addLink(container.destinationLinkNode, destination, "destination");
                                            var consumer = getOrAddNode("consumer", consumerId, properties, function () {
                                                return {
                                                    typeLabel: "Consumer",
                                                    brokerContainer: container,
                                                    objectName: objectName,
                                                    jolokia: containerJolokia,
                                                    popup: {
                                                        title: "Consumer: " + consumerId,
                                                        content: "<p>client: " + (properties.clientId || "") + "</p> " + brokerNameMarkup(properties.brokerName)
                                                    }
                                                };
                                            });
                                            addLink(destination, consumer, "consumer");
                                        }
                                    }
                                }
                            }
                        });
                        graphModelUpdated();
                    }));
                }
                if ($scope.viewSettings.producer) {
                    containerJolokia.search("org.apache.activemq:endpoint=Producer,*", onSuccess(function (response) {
                        angular.forEach(response, function (objectName) {
                            var details = Core.parseMBean(objectName);
                            if (details) {
                                var properties = details['attributes'];
                                if (properties) {
                                    configureDestinationProperties(properties);
                                    var producerId = properties.producerId;
                                    if (producerId) {
                                        var destination = getOrAddDestination(properties);
                                        if (destination) {
                                            addLink(container.destinationLinkNode, destination, "destination");
                                            var producer = getOrAddNode("producer", producerId, properties, function () {
                                                return {
                                                    typeLabel: "Producer",
                                                    brokerContainer: container,
                                                    objectName: objectName,
                                                    jolokia: containerJolokia,
                                                    popup: {
                                                        title: "Producer: " + producerId,
                                                        content: "<p>client: " + (properties.clientId || "") + "</p> " + brokerNameMarkup(properties.brokerName)
                                                    }
                                                };
                                            });
                                            addLink(producer, destination, "producer");
                                        }
                                        graphModelUpdated();
                                    }
                                }
                            }
                        });
                        graphModelUpdated();
                    }));
                }
                if ($scope.viewSettings.producer) {
                    containerJolokia.request({ type: "read", mbean: "org.apache.activemq:endpoint=dynamicProducer,*" }, onSuccess(function (response) {
                        angular.forEach(response.value, function (mbeanValues, objectName) {
                            var details = Core.parseMBean(objectName);
                            var attributes = details['attributes'];
                            var properties = {};
                            angular.forEach(attributes, function (value, key) {
                                properties[key] = value;
                            });
                            angular.forEach(mbeanValues, function (value, key) {
                                properties[key] = value;
                            });
                            configureDestinationProperties(properties);
                            properties['destinationName'] = properties['DestinationName'];
                            var producerId = properties["producerId"] || properties["ProducerId"];
                            if (properties["DestinationTemporary"] || properties["DestinationTopc"]) {
                                properties["destType"] = "topic";
                            }
                            var destination = getOrAddDestination(properties);
                            if (producerId && destination) {
                                addLink(container.destinationLinkNode, destination, "destination");
                                var producer = getOrAddNode("producer", producerId, properties, function () {
                                    return {
                                        typeLabel: "Producer (Dynamic)",
                                        brokerContainer: container,
                                        objectName: objectName,
                                        jolokia: containerJolokia,
                                        popup: {
                                            title: "Producer (Dynamic): " + producerId,
                                            content: "<p>client: " + (properties['ClientId'] || "") + "</p> " + brokerNameMarkup(properties['brokerName'])
                                        }
                                    };
                                });
                                addLink(producer, destination, "producer");
                            }
                        });
                        graphModelUpdated();
                    }));
                }
            }
        }
        function graphModelUpdated() {
            $scope.graph = graphBuilder.buildGraph();
            Core.$apply($scope);
        }
        function getOrAddBroker(master, brokerId, groupId, containerId, container, brokerStatus) {
            var broker = null;
            var brokerFlag = master ? $scope.viewSettings.broker : $scope.viewSettings.slave;
            if (brokerFlag) {
                broker = getOrAddNode("broker", brokerId + (master ? "" : ":slave"), brokerStatus, function () {
                    return {
                        type: master ? "broker" : "brokerSlave",
                        typeLabel: master ? "Broker" : "Slave Broker",
                        popup: {
                            title: (master ? "Master" : "Slave") + " Broker: " + brokerId,
                            content: "<p>Container: " + containerId + "</p> <p>Group: " + groupId + "</p>"
                        }
                    };
                });
                if (master) {
                    if (!broker['objectName']) {
                        broker['objectName'] = "org.apache.activemq:type=Broker,brokerName=" + brokerId;
                        ActiveMQ.log.info("Guessed broker mbean: " + broker['objectName']);
                    }
                    if (!broker['brokerContainer'] && container) {
                        broker['brokerContainer'] = container;
                    }
                }
            }
            return broker;
        }
        function getOrAddNode(typeName, id, properties, createFn) {
            var node = null;
            if (id) {
                var nodeId = typeName + ":" + id;
                node = graphBuilder.getNode(nodeId);
                if (!node) {
                    var nodeValues = createFn();
                    node = angular.copy(properties);
                    angular.forEach(nodeValues, function (value, key) { return node[key] = value; });
                    node['id'] = nodeId;
                    if (!node['type']) {
                        node['type'] = typeName;
                    }
                    if (!node['name']) {
                        node['name'] = id;
                    }
                    if (node) {
                        var size = $scope.shapeSize[typeName];
                        if (size && !node['size']) {
                            node['size'] = size;
                        }
                        if (!node['summary']) {
                            node['summary'] = node['popup'] || "";
                        }
                        if (!$scope.viewSettings.popup) {
                            delete node['popup'];
                        }
                        if (!$scope.viewSettings.label) {
                            delete node['name'];
                        }
                        var enabled = $scope.viewSettings[typeName];
                        if (enabled || !angular.isDefined(enabled)) {
                            graphBuilder.addNode(node);
                        }
                        else {
                        }
                    }
                }
            }
            return node;
        }
        function addLink(object1, object2, linkType) {
            if (object1 && object2) {
                addLinkIds(object1.id, object2.id, linkType);
            }
        }
        function addLinkIds(id1, id2, linkType) {
            if (id1 && id2) {
                graphBuilder.addLink(id1, id2, linkType);
            }
        }
        function brokerNodeId(brokerId) {
            return brokerId ? "broker:" + brokerId : null;
        }
        function renameTypeProperty(properties) {
            properties.mbeanType = properties['type'];
            delete properties['type'];
        }
        function configureDestinationProperties(properties) {
            renameTypeProperty(properties);
            var destinationType = properties.destinationType || "Queue";
            var typeName = destinationType.toLowerCase();
            properties.isQueue = !typeName.startsWith("t");
            properties['destType'] = typeName;
        }
    }]);
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.BrowseQueueController = ActiveMQ._module.controller("ActiveMQ.BrowseQueueController", ["$scope", "workspace", "jolokia", "localStorage", '$location', "activeMQMessage", "$timeout", function ($scope, workspace, jolokia, localStorage, location, activeMQMessage, $timeout) {
        $scope.searchText = '';
        $scope.allMessages = [];
        $scope.messages = [];
        $scope.headers = {};
        $scope.mode = 'text';
        $scope.deleteDialog = false;
        $scope.moveDialog = false;
        $scope.gridOptions = {
            selectedItems: [],
            data: 'messages',
            displayFooter: false,
            showFilter: false,
            showColumnMenu: true,
            enableColumnResize: true,
            enableColumnReordering: true,
            enableHighlighting: true,
            filterOptions: {
                filterText: '',
                useExternalFilter: true
            },
            selectWithCheckboxOnly: true,
            showSelectionCheckbox: true,
            maintainColumnRatios: false,
            columnDefs: [
                {
                    field: 'JMSMessageID',
                    displayName: 'Message ID',
                    cellTemplate: '<div class="ngCellText"><a ng-click="openMessageDialog(row)">{{row.entity.JMSMessageID}}</a></div>',
                    width: '34%'
                },
                {
                    field: 'JMSType',
                    displayName: 'Type',
                    width: '10%'
                },
                {
                    field: 'JMSPriority',
                    displayName: 'Priority',
                    width: '7%'
                },
                {
                    field: 'JMSTimestamp',
                    displayName: 'Timestamp',
                    width: '19%'
                },
                {
                    field: 'JMSExpiration',
                    displayName: 'Expires',
                    width: '10%'
                },
                {
                    field: 'JMSReplyTo',
                    displayName: 'Reply To',
                    width: '10%'
                },
                {
                    field: 'JMSCorrelationID',
                    displayName: 'Correlation ID',
                    width: '10%'
                }
            ]
        };
        $scope.showMessageDetails = false;
        var ignoreColumns = ["PropertiesText", "BodyPreview", "Text"];
        var flattenColumns = ["BooleanProperties", "ByteProperties", "ShortProperties", "IntProperties", "LongProperties", "FloatProperties", "DoubleProperties", "StringProperties"];
        $scope.$watch('workspace.selection', function () {
            if (workspace.moveIfViewInvalid()) {
                return;
            }
            setTimeout(loadTable, 50);
        });
        $scope.$watch('gridOptions.filterOptions.filterText', function (filterText) {
            filterMessages(filterText);
        });
        $scope.openMessageDialog = function (message) {
            ActiveMQ.selectCurrentMessage(message, "JMSMessageID", $scope);
            if ($scope.row) {
                $scope.mode = CodeEditor.detectTextFormat($scope.row.Text);
                $scope.showMessageDetails = true;
            }
        };
        $scope.refresh = loadTable;
        ActiveMQ.decorate($scope);
        $scope.moveMessages = function () {
            var selection = workspace.selection;
            var mbean = selection.objectName;
            if (mbean && selection) {
                var selectedItems = $scope.gridOptions.selectedItems;
                $scope.message = "Moved " + Core.maybePlural(selectedItems.length, "message" + " to " + $scope.queueName);
                var operation = "moveMessageTo(java.lang.String, java.lang.String)";
                angular.forEach(selectedItems, function (item, idx) {
                    var id = item.JMSMessageID;
                    if (id) {
                        var callback = (idx + 1 < selectedItems.length) ? intermediateResult : moveSuccess;
                        jolokia.execute(mbean, operation, id, $scope.queueName, onSuccess(callback));
                    }
                });
            }
        };
        $scope.resendMessage = function () {
            var selection = workspace.selection;
            var mbean = selection.objectName;
            if (mbean && selection) {
                var selectedItems = $scope.gridOptions.selectedItems;
                activeMQMessage.message = selectedItems[0];
                location.path('activemq/sendMessage');
            }
        };
        $scope.deleteMessages = function () {
            var selection = workspace.selection;
            var mbean = selection.objectName;
            if (mbean && selection) {
                var selectedItems = $scope.gridOptions.selectedItems;
                $scope.message = "Deleted " + Core.maybePlural(selectedItems.length, "message");
                var operation = "removeMessage(java.lang.String)";
                angular.forEach(selectedItems, function (item, idx) {
                    var id = item.JMSMessageID;
                    if (id) {
                        var callback = (idx + 1 < selectedItems.length) ? intermediateResult : operationSuccess;
                        jolokia.execute(mbean, operation, id, onSuccess(callback));
                    }
                });
            }
        };
        $scope.retryMessages = function () {
            var selection = workspace.selection;
            var mbean = selection.objectName;
            if (mbean && selection) {
                var selectedItems = $scope.gridOptions.selectedItems;
                $scope.message = "Retry " + Core.maybePlural(selectedItems.length, "message");
                var operation = "retryMessage(java.lang.String)";
                angular.forEach(selectedItems, function (item, idx) {
                    var id = item.JMSMessageID;
                    if (id) {
                        var callback = (idx + 1 < selectedItems.length) ? intermediateResult : operationSuccess;
                        jolokia.execute(mbean, operation, id, onSuccess(callback));
                    }
                });
            }
        };
        $scope.queueNames = function (completionText) {
            var queuesFolder = ActiveMQ.getSelectionQueuesFolder(workspace);
            return (queuesFolder) ? queuesFolder.children.map(function (n) { return n.title; }) : [];
        };
        function populateTable(response) {
            var data = response.value;
            if (!angular.isArray(data)) {
                $scope.allMessages = [];
                angular.forEach(data, function (value, idx) {
                    $scope.allMessages.push(value);
                });
            }
            else {
                $scope.allMessages = data;
            }
            angular.forEach($scope.allMessages, function (message) {
                message.headerHtml = createHeaderHtml(message);
                message.bodyText = createBodyText(message);
            });
            Core.$apply($scope);
            filterMessages($scope.gridOptions.filterOptions.filterText);
        }
        function createBodyText(message) {
            if (message.Text) {
                var body = message.Text;
                var lenTxt = "" + body.length;
                message.textMode = "text (" + lenTxt + " chars)";
                return body;
            }
            else if (message.BodyPreview) {
                var code = Core.parseIntValue(localStorage["activemqBrowseBytesMessages"] || "1", "browse bytes messages");
                var body;
                message.textMode = "bytes (turned off)";
                if (code != 99) {
                    var bytesArr = [];
                    var textArr = [];
                    message.BodyPreview.forEach(function (b) {
                        if (code === 1 || code === 2) {
                            textArr.push(String.fromCharCode(b));
                        }
                        if (code === 1 || code === 4) {
                            var s = b.toString(16);
                            if (s.length === 1) {
                                s = "0" + s;
                            }
                            bytesArr.push(s);
                        }
                        else {
                            var s = b.toString(10);
                            bytesArr.push(s);
                        }
                    });
                    var bytesData = bytesArr.join(" ");
                    var textData = textArr.join("");
                    if (code === 1 || code === 2) {
                        var len = message.BodyPreview.length;
                        var lenTxt = "" + textArr.length;
                        body = "bytes:\n" + bytesData + "\n\ntext:\n" + textData;
                        message.textMode = "bytes (" + len + " bytes) and text (" + lenTxt + " chars)";
                    }
                    else {
                        var len = message.BodyPreview.length;
                        body = bytesData;
                        message.textMode = "bytes (" + len + " bytes)";
                    }
                }
                return body;
            }
            else {
                message.textMode = "unsupported";
                return "Unsupported message body type which cannot be displayed by hawtio";
            }
        }
        function createHeaderHtml(message) {
            var headers = createHeaders(message);
            var properties = createProperties(message);
            var headerKeys = Object.extended(headers).keys();
            function sort(a, b) {
                if (a > b)
                    return 1;
                if (a < b)
                    return -1;
                return 0;
            }
            var propertiesKeys = Object.extended(properties).keys().sort(sort);
            var jmsHeaders = headerKeys.filter(function (key) {
                return key.startsWith("JMS");
            }).sort(sort);
            var remaining = headerKeys.subtract(jmsHeaders, propertiesKeys).sort(sort);
            var buffer = [];
            function appendHeader(key) {
                var value = headers[key];
                if (value === null) {
                    value = '';
                }
                buffer.push('<tr><td class="propertyName"><span class="green">Header</span> - ' + key + '</td><td class="property-value">' + value + '</td></tr>');
            }
            function appendProperty(key) {
                var value = properties[key];
                if (value === null) {
                    value = '';
                }
                buffer.push('<tr><td class="propertyName">' + key + '</td><td class="property-value">' + value + '</td></tr>');
            }
            jmsHeaders.forEach(appendHeader);
            remaining.forEach(appendHeader);
            propertiesKeys.forEach(appendProperty);
            return buffer.join("\n");
        }
        function createHeaders(row) {
            ActiveMQ.log.debug("headers: ", row);
            var answer = {};
            angular.forEach(row, function (value, key) {
                if (!ignoreColumns.any(key) && !flattenColumns.any(key)) {
                    answer[Core.escapeHtml(key)] = Core.escapeHtml(value);
                }
            });
            return answer;
        }
        function createProperties(row) {
            ActiveMQ.log.debug("properties: ", row);
            var answer = {};
            angular.forEach(row, function (value, key) {
                if (!ignoreColumns.any(key) && flattenColumns.any(key)) {
                    angular.forEach(value, function (v2, k2) {
                        answer['<span class="green">' + key.replace('Properties', ' Property') + '</span> - ' + Core.escapeHtml(k2)] = Core.escapeHtml(v2);
                    });
                }
            });
            return answer;
        }
        function loadTable() {
            var objName;
            if (workspace.selection) {
                objName = workspace.selection.objectName;
            }
            else {
                var key = location.search()['nid'];
                var node = workspace.keyToNodeMap[key];
                objName = node.objectName;
            }
            if (objName) {
                $scope.dlq = false;
                jolokia.getAttribute(objName, "DLQ", onSuccess(onDlq, { silent: true }));
                jolokia.request({ type: 'exec', mbean: objName, operation: 'browse()' }, onSuccess(populateTable));
            }
        }
        function onDlq(response) {
            $scope.dlq = response;
            Core.$apply($scope);
        }
        function intermediateResult() {
        }
        function operationSuccess() {
            $scope.messageDialog = false;
            $scope.gridOptions.selectedItems.splice(0);
            Core.notification("success", $scope.message);
            setTimeout(loadTable, 50);
        }
        function moveSuccess() {
            operationSuccess();
            workspace.loadTree();
        }
        function filterMessages(filter) {
            var searchConditions = buildSearchConditions(filter);
            evalFilter(searchConditions);
        }
        function evalFilter(searchConditions) {
            if (!searchConditions || searchConditions.length === 0) {
                $scope.messages = $scope.allMessages;
            }
            else {
                ActiveMQ.log.debug("Filtering conditions:", searchConditions);
                $scope.messages = $scope.allMessages.filter(function (message) {
                    ActiveMQ.log.debug("Message:", message);
                    var matched = true;
                    $.each(searchConditions, function (index, condition) {
                        if (!condition.column) {
                            matched = matched && evalMessage(message, condition.regex);
                        }
                        else {
                            matched = matched && (message[condition.column] && condition.regex.test(message[condition.column])) || (message.StringProperties && message.StringProperties[condition.column] && condition.regex.test(message.StringProperties[condition.column]));
                        }
                    });
                    return matched;
                });
            }
        }
        function evalMessage(message, regex) {
            var jmsHeaders = ['JMSDestination', 'JMSDeliveryMode', 'JMSExpiration', 'JMSPriority', 'JMSMessageID', 'JMSTimestamp', 'JMSCorrelationID', 'JMSReplyTo', 'JMSType', 'JMSRedelivered'];
            for (var i = 0; i < jmsHeaders.length; i++) {
                var header = jmsHeaders[i];
                if (message[header] && regex.test(message[header])) {
                    return true;
                }
            }
            if (message.StringProperties) {
                for (var property in message.StringProperties) {
                    if (regex.test(message.StringProperties[property])) {
                        return true;
                    }
                }
            }
            if (message.bodyText && regex.test(message.bodyText)) {
                return true;
            }
            return false;
        }
        function getRegExp(str, modifiers) {
            try {
                return new RegExp(str, modifiers);
            }
            catch (err) {
                return new RegExp(str.replace(/(\^|\$|\(|\)|<|>|\[|\]|\{|\}|\\|\||\.|\*|\+|\?)/g, '\\$1'));
            }
        }
        function buildSearchConditions(filterText) {
            var searchConditions = [];
            var qStr;
            if (!(qStr = $.trim(filterText))) {
                return;
            }
            var columnFilters = qStr.split(";");
            for (var i = 0; i < columnFilters.length; i++) {
                var args = columnFilters[i].split(':');
                if (args.length > 1) {
                    var columnName = $.trim(args[0]);
                    var columnValue = $.trim(args[1]);
                    if (columnName && columnValue) {
                        searchConditions.push({
                            column: columnName,
                            columnDisplay: columnName.replace(/\s+/g, '').toLowerCase(),
                            regex: getRegExp(columnValue, 'i')
                        });
                    }
                }
                else {
                    var val = $.trim(args[0]);
                    if (val) {
                        searchConditions.push({
                            column: '',
                            regex: getRegExp(val, 'i')
                        });
                    }
                }
            }
            return searchConditions;
        }
    }]);
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.DestinationController", ["$scope", "workspace", "jolokia", function ($scope, workspace, jolokia) {
        $scope.workspace = workspace;
        $scope.message = "";
        $scope.queueType = 'true';
        $scope.deleteDialog = false;
        $scope.purgeDialog = false;
        updateQueueType();
        function updateQueueType() {
            $scope.destinationTypeName = $scope.queueType ? "Queue" : "Topic";
        }
        $scope.$watch('queueType', function () {
            updateQueueType();
        });
        $scope.$watch('workspace.selection', function () {
            workspace.moveIfViewInvalid();
        });
        function operationSuccess() {
            $scope.destinationName = "";
            $scope.workspace.operationCounter += 1;
            Core.$apply($scope);
            Core.notification("success", $scope.message);
            $scope.workspace.loadTree();
        }
        function deleteSuccess() {
            workspace.removeAndSelectParentNode();
            $scope.workspace.operationCounter += 1;
            Core.$apply($scope);
            Core.notification("success", $scope.message);
            $scope.workspace.loadTree();
        }
        function getBrokerMBean(jolokia) {
            var mbean = null;
            var selection = workspace.selection;
            if (selection && ActiveMQ.isBroker(workspace) && selection.objectName) {
                return selection.objectName;
            }
            var folderNames = selection.folderNames;
            var parent = selection ? selection.parent : null;
            if (selection && parent && jolokia && folderNames && folderNames.length > 1) {
                mbean = parent.objectName;
                if (!mbean && parent) {
                    mbean = parent.parent.objectName;
                }
                if (!mbean) {
                    mbean = "" + folderNames[0] + ":BrokerName=" + folderNames[1] + ",Type=Broker";
                }
            }
            return mbean;
        }
        $scope.createDestination = function (name, isQueue) {
            var mbean = getBrokerMBean(jolokia);
            if (mbean) {
                var operation;
                if (isQueue) {
                    operation = "addQueue(java.lang.String)";
                    $scope.message = "Created queue " + name;
                }
                else {
                    operation = "addTopic(java.lang.String)";
                    $scope.message = "Created topic " + name;
                }
                if (mbean) {
                    jolokia.execute(mbean, operation, name, onSuccess(operationSuccess));
                }
                else {
                    Core.notification("error", "Could not find the Broker MBean!");
                }
            }
        };
        $scope.deleteDestination = function () {
            var mbean = getBrokerMBean(jolokia);
            var selection = workspace.selection;
            var entries = selection.entries;
            if (mbean && selection && jolokia && entries) {
                var domain = selection.domain;
                var name = entries["Destination"] || entries["destinationName"] || selection.title;
                name = name.unescapeHTML();
                var isQueue = "Topic" !== (entries["Type"] || entries["destinationType"]);
                var operation;
                if (isQueue) {
                    operation = "removeQueue(java.lang.String)";
                    $scope.message = "Deleted queue " + name;
                }
                else {
                    operation = "removeTopic(java.lang.String)";
                    $scope.message = "Deleted topic " + name;
                }
                jolokia.execute(mbean, operation, name, onSuccess(deleteSuccess));
            }
        };
        $scope.purgeDestination = function () {
            var mbean = workspace.getSelectedMBeanName();
            var selection = workspace.selection;
            var entries = selection.entries;
            if (mbean && selection && jolokia && entries) {
                var name = entries["Destination"] || entries["destinationName"] || selection.title;
                name = name.unescapeHTML();
                var operation = "purge()";
                $scope.message = "Purged queue " + name;
                jolokia.execute(mbean, operation, onSuccess(operationSuccess));
            }
        };
        $scope.name = function () {
            var selection = workspace.selection;
            if (selection) {
                return selection.title;
            }
            return null;
        };
    }]);
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.DurableSubscriberController", ["$scope", "workspace", "jolokia", function ($scope, workspace, jolokia) {
        $scope.refresh = loadTable;
        $scope.durableSubscribers = [];
        $scope.tempData = [];
        $scope.createSubscriberDialog = new UI.Dialog();
        $scope.deleteSubscriberDialog = new UI.Dialog();
        $scope.showSubscriberDialog = new UI.Dialog();
        $scope.topicName = '';
        $scope.clientId = '';
        $scope.subscriberName = '';
        $scope.subSelector = '';
        $scope.gridOptions = {
            selectedItems: [],
            data: 'durableSubscribers',
            displayFooter: false,
            showFilter: false,
            showColumnMenu: true,
            enableCellSelection: false,
            enableColumnResize: true,
            enableColumnReordering: true,
            selectWithCheckboxOnly: false,
            showSelectionCheckbox: false,
            multiSelect: false,
            displaySelectionCheckbox: false,
            filterOptions: {
                filterText: ''
            },
            maintainColumnRatios: false,
            columnDefs: [
                {
                    field: 'destinationName',
                    displayName: 'Topic',
                    width: '30%'
                },
                {
                    field: 'clientId',
                    displayName: 'Client ID',
                    width: '30%'
                },
                {
                    field: 'consumerId',
                    displayName: 'Consumer ID',
                    cellTemplate: '<div class="ngCellText"><span ng-hide="row.entity.status != \'Offline\'">{{row.entity.consumerId}}</span><a ng-show="row.entity.status != \'Offline\'" ng-click="openSubscriberDialog(row)">{{row.entity.consumerId}}</a></div>',
                    width: '30%'
                },
                {
                    field: 'status',
                    displayName: 'Status',
                    width: '10%'
                }
            ]
        };
        $scope.doCreateSubscriber = function (clientId, subscriberName, topicName, subSelector) {
            $scope.createSubscriberDialog.close();
            $scope.clientId = clientId;
            $scope.subscriberName = subscriberName;
            $scope.topicName = topicName;
            $scope.subSelector = subSelector;
            if (Core.isBlank($scope.subSelector)) {
                $scope.subSelector = null;
            }
            var mbean = getBrokerMBean(jolokia);
            if (mbean) {
                jolokia.execute(mbean, "createDurableSubscriber(java.lang.String, java.lang.String, java.lang.String, java.lang.String)", $scope.clientId, $scope.subscriberName, $scope.topicName, $scope.subSelector, onSuccess(function () {
                    Core.notification('success', "Created durable subscriber " + clientId);
                    $scope.clientId = '';
                    $scope.subscriberName = '';
                    $scope.topicName = '';
                    $scope.subSelector = '';
                    loadTable();
                }));
            }
            else {
                Core.notification("error", "Could not find the Broker MBean!");
            }
        };
        $scope.deleteSubscribers = function () {
            var mbean = $scope.gridOptions.selectedItems[0]._id;
            jolokia.execute(mbean, "destroy()", onSuccess(function () {
                $scope.showSubscriberDialog.close();
                Core.notification('success', "Deleted durable subscriber");
                loadTable();
                $scope.gridOptions.selectedItems = [];
            }));
        };
        $scope.openSubscriberDialog = function (subscriber) {
            jolokia.request({ type: "read", mbean: subscriber.entity._id }, onSuccess(function (response) {
                $scope.showSubscriberDialog.subscriber = response.value;
                $scope.showSubscriberDialog.subscriber.Status = subscriber.entity.status;
                console.log("Subscriber is now " + $scope.showSubscriberDialog.subscriber);
                Core.$apply($scope);
                setTimeout(function () {
                    $scope.showSubscriberDialog.open();
                    Core.$apply($scope);
                }, 100);
            }));
        };
        $scope.topicNames = function (completionText) {
            var topicsFolder = ActiveMQ.getSelectionTopicsFolder(workspace);
            return (topicsFolder) ? topicsFolder.children.map(function (n) { return n.title; }) : [];
        };
        $scope.$watch('workspace.selection', function () {
            if (workspace.moveIfViewInvalid())
                return;
            setTimeout(loadTable, 50);
        });
        function loadTable() {
            var mbean = getBrokerMBean(jolokia);
            if (mbean) {
                $scope.durableSubscribers = [];
                jolokia.request({ type: "read", mbean: mbean, attribute: ["DurableTopicSubscribers"] }, onSuccess(function (response) { return populateTable(response, "DurableTopicSubscribers", "Active"); }));
                jolokia.request({ type: "read", mbean: mbean, attribute: ["InactiveDurableTopicSubscribers"] }, onSuccess(function (response) { return populateTable(response, "InactiveDurableTopicSubscribers", "Offline"); }));
            }
        }
        function populateTable(response, attr, status) {
            var data = response.value;
            ActiveMQ.log.debug("Got data: ", data);
            $scope.durableSubscribers.push.apply($scope.durableSubscribers, data[attr].map(function (o) {
                var objectName = o["objectName"];
                var entries = Core.objectNameProperties(objectName);
                if (!('objectName' in o)) {
                    if ('canonicalName' in o) {
                        objectName = o['canonicalName'];
                    }
                    entries = Object.extended(o['keyPropertyList']).clone();
                }
                entries["_id"] = objectName;
                entries["status"] = status;
                return entries;
            }));
            Core.$apply($scope);
        }
        function getBrokerMBean(jolokia) {
            var mbean = null;
            var selection = workspace.selection;
            if (selection && ActiveMQ.isBroker(workspace) && selection.objectName) {
                return selection.objectName;
            }
            var folderNames = selection.folderNames;
            var parent = selection ? selection.parent : null;
            if (selection && parent && jolokia && folderNames && folderNames.length > 1) {
                mbean = parent.objectName;
                if (!mbean && parent) {
                    mbean = parent.parent.objectName;
                }
                if (!mbean) {
                    mbean = "" + folderNames[0] + ":BrokerName=" + folderNames[1] + ",Type=Broker";
                }
            }
            return mbean;
        }
    }]);
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.JobSchedulerController", ["$scope", "workspace", "jolokia", function ($scope, workspace, jolokia) {
        $scope.refresh = loadTable;
        $scope.jobs = [];
        $scope.deleteJobsDialog = new UI.Dialog();
        $scope.gridOptions = {
            selectedItems: [],
            data: 'jobs',
            displayFooter: false,
            showFilter: false,
            showColumnMenu: true,
            enableColumnResize: true,
            enableColumnReordering: true,
            filterOptions: {
                filterText: ''
            },
            selectWithCheckboxOnly: true,
            showSelectionCheckbox: true,
            maintainColumnRatios: false,
            columnDefs: [
                {
                    field: 'jobId',
                    displayName: 'Job ID',
                    width: '25%'
                },
                {
                    field: 'cronEntry',
                    displayName: 'Cron Entry',
                    width: '10%'
                },
                {
                    field: 'delay',
                    displayName: 'Delay',
                    width: '5%'
                },
                {
                    field: 'repeat',
                    displayName: 'repeat',
                    width: '5%'
                },
                {
                    field: 'period',
                    displayName: 'period',
                    width: '5%'
                },
                {
                    field: 'start',
                    displayName: 'Start',
                    width: '25%'
                },
                {
                    field: 'next',
                    displayName: 'Next',
                    width: '25%'
                }
            ]
        };
        $scope.$watch('workspace.selection', function () {
            if (workspace.moveIfViewInvalid())
                return;
            setTimeout(loadTable, 50);
        });
        function loadTable() {
            var selection = workspace.selection;
            if (selection) {
                var mbean = selection.objectName;
                if (mbean) {
                    jolokia.request({ type: 'read', mbean: mbean, attribute: "AllJobs" }, onSuccess(populateTable));
                }
            }
            Core.$apply($scope);
        }
        function populateTable(response) {
            var data = response.value;
            if (!angular.isArray(data)) {
                $scope.jobs = [];
                angular.forEach(data, function (value, idx) {
                    $scope.jobs.push(value);
                });
            }
            else {
                $scope.jobs = data;
            }
            Core.$apply($scope);
        }
        $scope.deleteJobs = function () {
            var selection = workspace.selection;
            var mbean = selection.objectName;
            if (mbean && selection) {
                var selectedItems = $scope.gridOptions.selectedItems;
                $scope.message = "Deleted " + Core.maybePlural(selectedItems.length, "job");
                var operation = "removeJob(java.lang.String)";
                angular.forEach(selectedItems, function (item, idx) {
                    var id = item.jobId;
                    if (id) {
                        var callback = (idx + 1 < selectedItems.length) ? intermediateResult : operationSuccess;
                        jolokia.execute(mbean, operation, id, onSuccess(callback));
                    }
                });
            }
        };
        function intermediateResult() {
        }
        function operationSuccess() {
            $scope.gridOptions.selectedItems.splice(0);
            Core.notification("success", $scope.message);
            setTimeout(loadTable, 50);
        }
    }]);
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.PreferencesController", ["$scope", "localStorage", "userDetails", "$rootScope", function ($scope, localStorage, userDetails, $rootScope) {
        Core.initPreferenceScope($scope, localStorage, {
            'activemqUserName': {
                'value': userDetails.username,
            },
            'activemqPassword': {
                'value': userDetails.password
            },
            'activemqBrowseBytesMessages': {
                'value': 1,
                'converter': parseInt,
                'formatter': function (value) {
                    return "" + value;
                }
            },
            'activemqFilterAdvisoryTopics': {
                'value': false,
                'converter': Core.parseBooleanValue,
                'post': function (newValue) {
                    $rootScope.$broadcast('jmxTreeUpdated');
                }
            }
        });
    }]);
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.TreeHeaderController", ["$scope", function ($scope) {
        $scope.expandAll = function () {
            Tree.expandAll("#activemqtree");
        };
        $scope.contractAll = function () {
            Tree.contractAll("#activemqtree");
        };
    }]);
    ActiveMQ._module.controller("ActiveMQ.TreeController", ["$scope", "$location", "workspace", "localStorage", function ($scope, $location, workspace, localStorage) {
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            setTimeout(updateSelectionFromURL, 50);
        });
        $scope.$watch('workspace.tree', function () {
            reloadTree();
        });
        $scope.$on('jmxTreeUpdated', function () {
            reloadTree();
        });
        function reloadTree() {
            ActiveMQ.log.debug("workspace tree has changed, lets reload the activemq tree");
            var children = [];
            var tree = workspace.tree;
            if (tree) {
                var domainName = "org.apache.activemq";
                var folder = tree.get(domainName);
                if (folder) {
                    children = folder.children;
                }
                if (children.length) {
                    var firstChild = children[0];
                    if (!firstChild.typeName && firstChild.children.length < 4) {
                        var answer = [];
                        angular.forEach(children, function (child) {
                            answer = answer.concat(child.children);
                        });
                        children = answer;
                    }
                }
                children.forEach(function (broker) {
                    var grandChildren = broker.children;
                    if (grandChildren) {
                        Tree.sanitize(grandChildren);
                        var idx = grandChildren.findIndex(function (n) { return n.title === "Topic"; });
                        if (idx > 0) {
                            var old = grandChildren[idx];
                            var key = "ActiveMQ-allTopics-" + broker.title;
                            var allTopics = old.children.clone();
                            workspace.mapData[key] = allTopics;
                            var filter = Core.parseBooleanValue(localStorage["activemqFilterAdvisoryTopics"]);
                            if (filter) {
                                if (old && old.children) {
                                    var filteredTopics = old.children.filter(function (c) { return !c.title.startsWith("ActiveMQ.Advisory"); });
                                    old.children = filteredTopics;
                                }
                            }
                            else if (allTopics) {
                                old.children = allTopics;
                            }
                        }
                    }
                });
                var treeElement = $("#activemqtree");
                Jmx.enableTree($scope, $location, workspace, treeElement, children, true);
                setTimeout(updateSelectionFromURL, 50);
            }
        }
        function updateSelectionFromURL() {
            Jmx.updateTreeSelectionFromURLAndAutoSelect($location, $("#activemqtree"), function (first) {
                var queues = first.getChildren()[0];
                if (queues && queues.data.title === 'Queue') {
                    first = queues;
                    first.expand(true);
                    return first;
                }
                return null;
            }, true);
        }
    }]);
})(ActiveMQ || (ActiveMQ = {}));
var API;
(function (API) {
    API.log = Logger.get("API");
    API.wadlNamespace = "http://schemas.xmlsoap.org/wsdl/";
    function loadXml(url, onXml) {
        if (url) {
            API.log.info("Loading XML: " + url);
            var ajaxParams = {
                type: "GET",
                url: url,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', null);
                },
                dataType: "xml",
                contextType: "text/xml",
                success: onXml,
                error: function (jqXHR, textStatus, errorThrow) {
                    API.log.error("Failed to query XML for: " + url + " status:" + textStatus + " error: " + errorThrow);
                }
            };
            $.ajax(ajaxParams);
        }
    }
    API.loadXml = loadXml;
    var wadlXmlToJavaConfig = {};
    function parseJson(json) {
        var answer = null;
        try {
            answer = JSON.parse(json);
        }
        catch (e) {
            API.log.info("Failed to parse JSON " + e);
            API.log.info("JSON: " + json);
        }
        return answer;
    }
    API.parseJson = parseJson;
    function initScope($scope, $location, jolokia) {
        var search = $location.search();
        $scope.container = search["container"];
        $scope.objectName = search["objectName"];
        $scope.showHide = function (resource) {
            if (resource) {
                resource.hide = resource.hide ? false : true;
            }
        };
        $scope.showOperations = function (resource) {
            showHideOperations(resource, false);
        };
        $scope.expandOperations = function (resource) {
            showHideOperations(resource, true);
        };
        function showHideOperations(resource, flag) {
            if (resource) {
                resource.hide = false;
                angular.forEach(resource.resource, function (childResource) {
                    showHideOperations(childResource, flag);
                });
                angular.forEach(resource.method || resource.operations, function (method) {
                    method.expanded = flag;
                });
            }
        }
        $scope.autoFormat = function (codeMirror) {
            if (!codeMirror) {
                codeMirror = findChildScopeValue($scope, "codeMirror");
            }
            if (codeMirror) {
                setTimeout(function () {
                    CodeEditor.autoFormatEditor(codeMirror);
                }, 50);
            }
        };
        function findChildScopeValue(scope, name) {
            var answer = scope[name];
            var childScope = scope.$$childHead;
            while (childScope && !answer) {
                answer = findChildScopeValue(childScope, name);
                childScope = childScope.$$nextSibling;
            }
            return answer;
        }
        if ($scope.container && $scope.objectName) {
            Fabric.containerJolokia(jolokia, $scope.container, function (remoteJolokia) {
                $scope.remoteJolokia = remoteJolokia;
                if (remoteJolokia) {
                    API.loadJsonSchema(remoteJolokia, $scope.objectName, function (jsonSchema) {
                        $scope.jsonSchema = jsonSchema;
                        Core.$apply($scope);
                    });
                }
                else {
                    API.log.info("No Remote Jolokia!");
                }
            });
        }
        else {
            API.log.info("No container or objectName");
        }
        API.log.info("container: " + $scope.container + " objectName: " + $scope.objectName + " url: " + $scope.url);
    }
    API.initScope = initScope;
    function loadJsonSchema(jolokia, mbean, onJsonSchemaFn) {
        function onResults(response) {
            var schema = {};
            if (response) {
                var json = response;
                if (json) {
                    schema = parseJson(json);
                }
            }
            onJsonSchemaFn(schema);
        }
        if (mbean) {
            return jolokia.execute(mbean, "getJSONSchema", onSuccess(onResults));
        }
        else {
            var schema = {};
            onJsonSchemaFn(schema);
            return schema;
        }
    }
    API.loadJsonSchema = loadJsonSchema;
    function onWadlXmlLoaded(response) {
        var root = response.documentElement;
        var output = {};
        return API.convertWadlToJson(root, output);
    }
    API.onWadlXmlLoaded = onWadlXmlLoaded;
    function convertWadlToJson(element, obj) {
        if (obj === void 0) { obj = {}; }
        return API.convertXmlToJson(element, obj, wadlXmlToJavaConfig);
    }
    API.convertWadlToJson = convertWadlToJson;
    function convertWadlJsonToSwagger(object) {
        var apis = [];
        var basePath = null;
        var resourcePath = null;
        var resources = Core.pathGet(object, ["resources", 0]);
        if (resources) {
            basePath = resources.base;
            angular.forEach(resources.resource, function (resource) {
                var path = resource.path;
                var operations = [];
                angular.forEach(resource.method, function (method) {
                    var name = method.name;
                    var responseMessages = [];
                    var parameters = [];
                    operations.push({
                        "method": method.name,
                        "summary": method.summary,
                        "notes": method.notes,
                        "nickname": method.nickname,
                        "type": method.type,
                        "parameters": parameters,
                        "produces": [
                            "application/json"
                        ],
                        "responseMessages": responseMessages
                    });
                });
                apis.push({
                    path: path,
                    operations: operations
                });
            });
        }
        return {
            "apiVersion": "1.0",
            "swaggerVersion": "1.2",
            "basePath": basePath,
            "resourcePath": resourcePath,
            "produces": [
                "application/json"
            ],
            apis: apis
        };
    }
    API.convertWadlJsonToSwagger = convertWadlJsonToSwagger;
    function nodeName(owner, node) {
        return node ? node.localName : null;
    }
    function convertXmlToJson(element, obj, config) {
        var elementProperyFn = config.elementToPropertyName || nodeName;
        var attributeProperyFn = config.attributeToPropertyName || nodeName;
        angular.forEach(element.childNodes, function (child) {
            if (child.nodeType === 1) {
                var propertyName = elementProperyFn(element, child);
                if (propertyName) {
                    var array = obj[propertyName] || [];
                    if (!angular.isArray(array)) {
                        array = [array];
                    }
                    var value = {};
                    convertXmlToJson(child, value, config);
                    array.push(value);
                    obj[propertyName] = array;
                }
            }
        });
        angular.forEach(element.attributes, function (attr) {
            var propertyName = attributeProperyFn(element, attr);
            if (propertyName) {
                var value = attr.nodeValue;
                obj[propertyName] = value;
            }
        });
        return obj;
    }
    API.convertXmlToJson = convertXmlToJson;
    function concatArrays(arrays) {
        var answer = [];
        angular.forEach(arrays, function (array) {
            if (array) {
                if (angular.isArray(array)) {
                    answer = answer.concat(array);
                }
                else {
                    answer.push(array);
                }
            }
        });
        return answer;
    }
    API.concatArrays = concatArrays;
})(API || (API = {}));
var API;
(function (API) {
    API.pluginName = 'api';
    API._module = angular.module(API.pluginName, ['bootstrap', 'hawtioCore', 'hawtio-ui']);
    API._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/api/wsdl', { templateUrl: 'app/api/html/wsdl.html' }).when('/api/wadl', { templateUrl: 'app/api/html/wadl.html' });
    }]);
    API._module.run(["$location", "workspace", "viewRegistry", "layoutFull", "helpRegistry", function ($location, workspace, viewRegistry, layoutFull, helpRegistry) {
        viewRegistry['api'] = layoutFull;
    }]);
    hawtioPluginLoader.addModule(API.pluginName);
})(API || (API = {}));
var API;
(function (API) {
    API._module.controller("API.WadlViewController", ["$scope", "$location", "$http", "jolokia", function ($scope, $location, $http, jolokia) {
        API.initScope($scope, $location, jolokia);
        $scope.url = $location.search()["wadl"];
        API.loadXml($scope.url, onWsdl);
        $scope.$watch("apidocs", enrichApiDocsWithSchema);
        $scope.$watch("jsonSchema", enrichApiDocsWithSchema);
        $scope.tryInvoke = function (resource, method) {
            if (resource) {
                var path = resource.fullPath || resource.path;
                if (path) {
                    angular.forEach(resource.param, function (param) {
                        var name = param.name;
                        if (name) {
                            var value = param.value;
                            if (angular.isUndefined(value) || value === null) {
                                value = "";
                            }
                            value = value.toString();
                            API.log.debug("replacing " + name + " with '" + value + "'");
                            path = path.replace(new RegExp("{" + name + "}", "g"), value);
                        }
                    });
                    API.log.info("Lets invoke resource: " + path);
                    var url = Core.useProxyIfExternal(path);
                    var methodName = method.name || "GET";
                    method.invoke = {
                        url: url,
                        running: true
                    };
                    var requestData = {
                        method: methodName,
                        url: url,
                        headers: {}
                    };
                    if (methodName === "POST" || methodName === "PUT") {
                        angular.forEach(method.request, function (request) {
                            if (!requestData["data"]) {
                                requestData["data"] = request.value;
                            }
                            if (!requestData.headers["Content-Type"]) {
                                requestData.headers["Content-Type"] = request.contentType;
                            }
                        });
                    }
                    API.log.info("About to make request: " + angular.toJson(requestData));
                    $http(requestData).success(function (data, status, headers, config) {
                        API.log.info("Worked!" + data);
                        method.invoke = {
                            url: url,
                            realUrl: path,
                            success: true,
                            data: data,
                            dataMode: textFormat(headers),
                            status: status,
                            headers: headers(),
                            config: config
                        };
                        Core.$apply($scope);
                    }).error(function (data, status, headers, config) {
                        API.log.info("Failed: " + status);
                        method.invoke = {
                            url: url,
                            realUrl: path,
                            data: data,
                            dataMode: textFormat(headers),
                            status: status,
                            headers: headers(),
                            config: config
                        };
                        Core.$apply($scope);
                    });
                }
            }
        };
        function textFormat(headers) {
            return contentTypeTextFormat(headers("content-type"));
        }
        function contentTypeTextFormat(contentType) {
            if (contentType) {
                if (contentType.endsWith("xml")) {
                    return "xml";
                }
                if (contentType.endsWith("html")) {
                    return "html";
                }
                if (contentType.endsWith("json")) {
                    return "json";
                }
            }
            return null;
        }
        function enrichApiDocsWithSchema() {
            var apidocs = $scope.apidocs;
            var jsonSchema = $scope.jsonSchema;
            if (apidocs && jsonSchema) {
                enrichResources(jsonSchema, apidocs.resources);
            }
        }
        function enrichResources(jsonSchema, resources, parentUri) {
            if (parentUri === void 0) { parentUri = null; }
            angular.forEach(resources, function (resource) {
                var base = resource.base;
                if (base) {
                    if (parentUri) {
                        base = parentUri + base;
                    }
                }
                else {
                    base = parentUri;
                }
                var path = resource.path;
                if (base && path) {
                    if (!base.endsWith("/") && !path.startsWith("/")) {
                        base += "/";
                    }
                    base += path;
                    resource["fullPath"] = base;
                }
                var childResources = resource.resource;
                if (childResources) {
                    enrichResources(jsonSchema, childResources, base);
                }
                angular.forEach(API.concatArrays([resource.method, resource.operation]), function (method) {
                    var request = method.request;
                    if (request) {
                        var count = request.count(function (n) { return n["representation"]; });
                        if (!count) {
                            delete method.request;
                        }
                    }
                    angular.forEach(API.concatArrays([method.request, method.response]), function (object) {
                        var element = object["element"];
                        var representations = object["representation"];
                        if (representations) {
                            var mediaTypes = representations.map(function (r) { return r["mediaType"]; });
                            object["mediaTypes"] = mediaTypes;
                            if (mediaTypes && mediaTypes.length) {
                                object["contentType"] = mediaTypes[0];
                            }
                        }
                        angular.forEach(representations, function (representation) {
                            if (!element) {
                                element = representation["element"];
                            }
                            enrichRepresentation(jsonSchema, representation);
                        });
                        if (element) {
                            object["element"] = element;
                        }
                    });
                });
            });
        }
        function enrichRepresentation(jsonSchema, representation) {
            var defs = jsonSchema ? jsonSchema["definitions"] : null;
            if (defs && representation) {
                var contentType = representation["mediaType"];
                if (contentType) {
                    representation["dataMode"] = contentTypeTextFormat(contentType);
                }
                var element = representation["element"];
                if (element) {
                    var idx = element.indexOf(':');
                    if (idx >= 0) {
                        element = element.substring(idx + 1);
                    }
                    var elementPostfix = "." + element;
                    var foundDef = null;
                    angular.forEach(defs, function (value, key) {
                        if (!foundDef && (key === element || key.endsWith(elementPostfix))) {
                            foundDef = value;
                            representation["schema"] = foundDef;
                            representation["typeName"] = element;
                            representation["javaClass"] = key;
                        }
                    });
                }
            }
        }
        function onWsdl(response) {
            $scope.apidocs = API.onWadlXmlLoaded(response);
            Core.$apply($scope);
        }
    }]);
})(API || (API = {}));
var API;
(function (API) {
    API._module.controller("API.WsdlViewController", ["$scope", "$location", "jolokia", function ($scope, $location, jolokia) {
        var log = Logger.get("API");
        API.initScope($scope, $location, jolokia);
        var wsdlNamespace = "http://schemas.xmlsoap.org/wsdl/";
        $scope.url = $location.search()["wsdl"];
        API.loadXml($scope.url, onWsdl);
        $scope.$watch("services", enrichApiDocsWithSchema);
        $scope.$watch("jsonSchema", enrichApiDocsWithSchema);
        function enrichApiDocsWithSchema() {
            var services = $scope.services;
            var jsonSchema = $scope.jsonSchema;
            if (services && jsonSchema) {
                log.info("We have services and jsonSchema!");
                enrichServices(jsonSchema, services);
            }
        }
        function enrichServices(jsonSchema, services) {
            angular.forEach(services, function (service) {
                angular.forEach(service.operations, function (method) {
                    angular.forEach(API.concatArrays([method.inputs, method.outputs]), function (object) {
                        enrichRepresentation(jsonSchema, object);
                    });
                });
            });
        }
        function enrichRepresentation(jsonSchema, representation) {
            var defs = jsonSchema ? jsonSchema["definitions"] : null;
            if (defs && representation) {
                var name = representation["name"];
                if (name) {
                    var foundDef = defs[name];
                    if (foundDef) {
                        if (angular.isArray(foundDef) && foundDef.length > 0) {
                            foundDef = foundDef[0];
                        }
                        log.info("Found def " + angular.toJson(foundDef) + " for name " + name);
                        representation["schema"] = foundDef;
                    }
                }
            }
        }
        function onWsdl(response) {
            $scope.services = [];
            var root = response.documentElement;
            var targetNamespace = root ? root.getAttribute("targetNamespace") : null;
            var name = root ? root.getAttribute("name") : null;
            var portTypes = response.getElementsByTagNameNS(wsdlNamespace, "portType");
            var services = response.getElementsByTagNameNS(wsdlNamespace, "service");
            var bindings = response.getElementsByTagNameNS(wsdlNamespace, "binding");
            angular.forEach(portTypes, function (portType) {
                var service = {
                    name: name,
                    targetNamespace: targetNamespace,
                    portName: portType.getAttribute("name") || "Unknown",
                    operations: []
                };
                $scope.services.push(service);
                var operations = portType.getElementsByTagNameNS(wsdlNamespace, "operation");
                angular.forEach(operations, function (operation) {
                    var input = operation.getElementsByTagNameNS(wsdlNamespace, "input");
                    var output = operation.getElementsByTagNameNS(wsdlNamespace, "output");
                    function createMessageData(data) {
                        var answer = [];
                        angular.forEach(data, function (item) {
                            var name = item.getAttribute("name");
                            if (name) {
                                answer.push({
                                    name: name
                                });
                            }
                        });
                        return answer;
                    }
                    var opData = {
                        name: operation.getAttribute("name") || "Unknown",
                        inputs: createMessageData(input),
                        outputs: createMessageData(output)
                    };
                    service.operations.push(opData);
                });
            });
            Core.$apply($scope);
        }
    }]);
})(API || (API = {}));
var Apm;
(function (Apm) {
    Apm.log = Logger.get("Apm");
    Apm.jmxDomain = 'io.fabric8.apmagent';
    Apm.agentMBean = Apm.jmxDomain + ':type=apmAgent';
})(Apm || (Apm = {}));
var Apm;
(function (Apm) {
    Apm.pluginName = 'apm';
    Apm._module = angular.module(Apm.pluginName, ['bootstrap', 'ui.bootstrap', 'ui.bootstrap.dialog', 'ui.bootstrap.tabs', 'ui.bootstrap.typeahead', 'ngResource', 'hawtioCore', 'hawtio-ui']);
    Apm._module.config(["$routeProvider", function ($routeProvider) {
    }]);
    Apm._module.run(["workspace", "jolokia", "viewRegistry", "layoutFull", "helpRegistry", "preferencesRegistry", function (workspace, jolokia, viewRegistry, layoutFull, helpRegistry, preferencesRegistry) {
        viewRegistry['apm'] = 'app/apm/html/layoutApmTree.html';
        helpRegistry.addUserDoc('apm', 'app/apm/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties(Apm.jmxDomain);
        });
        var attributes = workspace.attributeColumnDefs;
        attributes[Apm.jmxDomain + "/MethodMetrics/folder"] = [
            { field: 'Name', displayName: 'Name' },
            { field: 'Count', displayName: 'Count' }
        ];
        attributes[Apm.jmxDomain + "/ThreadContextMetrics/folder"] = [
            { field: 'Name', displayName: 'Name' },
            { field: 'ThreadName', displayName: 'Thread' },
            { field: 'Count', displayName: 'Count' }
        ];
        function postProcessTree(tree) {
            var apmTree = tree.get(Apm.jmxDomain);
            if (apmTree) {
                angular.forEach(apmTree.children, function (folder) {
                    if (folder.title === "ThreadContextMetrics") {
                        angular.forEach(folder.children, function (child) {
                            if (!child.typeName) {
                                child.typeName = "ThreadContextMetrics";
                            }
                        });
                    }
                });
            }
        }
        workspace.addTreePostProcessor(postProcessTree);
    }]);
    hawtioPluginLoader.addModule(Apm.pluginName);
})(Apm || (Apm = {}));
var Apollo;
(function (Apollo) {
    Apollo.pluginName = 'apollo';
    Apollo._module = angular.module(Apollo.pluginName, ['bootstrap', 'ngResource', 'hawtioCore']);
    Apollo._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/apollo', { templateUrl: 'app/apollo/html/layout-apollo.html' });
    }]);
    Apollo._module.run(["$location", "workspace", "viewRegistry", "helpRegistry", function ($location, workspace, viewRegistry, helpRegistry) {
        viewRegistry['apollo'] = "app/apollo/html/layout-apollo.html";
        helpRegistry.addUserDoc('apollo', 'app/apollo/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties("org.apache.apollo");
        });
        workspace.topLevelTabs.push({
            id: "apollo",
            content: "Apollo",
            title: "Manage your Apollo Broker",
            isValid: function (workspace) { return workspace.treeContainsDomainAndProperties("org.apache.apollo"); },
            href: function () { return '#/apollo/virtual-hosts'; },
            isActive: function (workspace) { return workspace.isLinkActive("apollo"); }
        });
    }]);
    hawtioPluginLoader.addModule(Apollo.pluginName);
})(Apollo || (Apollo = {}));
var Apollo;
(function (Apollo) {
    Apollo._module.controller("Apollo.ApolloController", ["$scope", "$http", "$location", "localStorage", "workspace", function ($scope, $http, $location, localStorage, workspace) {
        var jolokia = workspace.jolokia;
        $scope.broker = {};
        $scope.online = true;
        $scope.route = function () {
            return $location.path();
        };
        $scope.apollo = {
            version: jolokia.getAttribute('org.apache.apollo:type=broker,name="default"', "Version", onSuccess(null)),
            url: jolokia.getAttribute('org.apache.apollo:type=broker,name="default"', "WebAdminUrl", onSuccess(null)),
        };
        var default_error_handler = function (data, status, headers, config) {
            if (status === 401) {
                alert("Action not authorized.");
            }
            else {
                alert("Error: " + status);
            }
        };
        $scope.ajax = function (type, path, success, error, data, binary_options) {
            if (!error) {
                error = default_error_handler;
            }
            var username = "admin";
            var password = "password";
            var ajax_options = {
                method: type,
                url: $scope.apollo.url + "/api/json" + path,
                headers: {
                    AuthPrompt: 'false',
                    Accept: "application/json",
                    ContentType: "application/json",
                    Authorization: Core.getBasicAuthHeader(username, password)
                },
                cache: false,
                data: null,
            };
            if (binary_options) {
                ajax_options.headers["Accept"] = binary_options.Accept || "application/octet-stream";
                ajax_options.headers["ContentType"] || "application/octet-stream";
                ajax_options.data = binary_options.data;
            }
            return $http(ajax_options).success(function (data, status, headers, config) {
                $scope.online = true;
                if (success) {
                    success(data, status, headers, config);
                }
            }).error(function (data, status, headers, config) {
                if (status === 0) {
                    $scope.online = false;
                }
                else {
                    $scope.online = true;
                    error(data, status, headers, config);
                }
            });
        };
        var reload = function () {
            if ($scope.apollo.url) {
                $scope.ajax("GET", "/broker", function (broker) {
                    $scope.broker = broker;
                    if ($scope.apollo.selected_virtual_host === undefined) {
                        $scope.apollo.selected_virtual_host = broker.virtual_hosts[0];
                    }
                }, function (error) {
                    alert("fail:" + error);
                });
            }
            else {
                $scope.broker = {};
            }
        };
        var schedule_refresh = function () {
        };
        schedule_refresh = function () {
            setTimeout(function () {
                reload();
                schedule_refresh();
            }, 1000);
        };
        schedule_refresh();
        $scope.$watch('apollo.url', reload);
        $scope.$watch('online', function () {
        });
    }]);
})(Apollo || (Apollo = {}));
var Apollo;
(function (Apollo) {
    Apollo._module.controller("Apollo.VirtualHostController", ["$scope", "$http", "$location", "localStorage", "workspace", function ($scope, $http, $location, localStorage, workspace) {
        $scope.virtual_host = {};
        $scope.init = function (virtual_host_name) {
            $scope.ajax("GET", "/broker/virtual-hosts/" + virtual_host_name, function (host) {
                $scope.virtual_host = host;
            });
        };
    }]);
})(Apollo || (Apollo = {}));
var Camel;
(function (Camel) {
    Camel.log = Logger.get("Camel");
    Camel.jmxDomain = 'org.apache.camel';
    Camel.defaultMaximumLabelWidth = 34;
    Camel.defaultCamelMaximumTraceOrDebugBodyLength = 5000;
    Camel.defaultCamelRouteMetricMaxSeconds = 10;
    function processRouteXml(workspace, jolokia, folder, onRoute) {
        var selectedRouteId = getSelectedRouteId(workspace, folder);
        var mbean = getSelectionCamelContextMBean(workspace);
        function onRouteXml(response) {
            var route = null;
            var data = response ? response.value : null;
            if (data) {
                var doc = $.parseXML(data);
                var routes = $(doc).find("route[id='" + selectedRouteId + "']");
                if (routes && routes.length) {
                    route = routes[0];
                }
            }
            onRoute(route);
        }
        if (mbean && selectedRouteId) {
            jolokia.request({ type: 'exec', mbean: mbean, operation: 'dumpRoutesAsXml()' }, onSuccess(onRouteXml, { error: onRouteXml }));
        }
        else {
            if (!selectedRouteId) {
                console.log("No selectedRouteId when trying to lazy load the route!");
            }
            onRoute(null);
        }
    }
    Camel.processRouteXml = processRouteXml;
    function getRouteNodeUri(node) {
        var uri = null;
        if (node) {
            uri = node.getAttribute("uri");
            if (!uri) {
                var ref = node.getAttribute("ref");
                if (ref) {
                    var method = node.getAttribute("method");
                    if (method) {
                        uri = ref + "." + method + "()";
                    }
                    else {
                        uri = "ref:" + ref;
                    }
                }
            }
        }
        return uri;
    }
    Camel.getRouteNodeUri = getRouteNodeUri;
    function getRouteFolderJSON(folder, answer) {
        if (answer === void 0) { answer = {}; }
        var nodeData = folder["camelNodeData"];
        if (!nodeData) {
            var routeXmlNode = folder["routeXmlNode"];
            if (routeXmlNode) {
                nodeData = Camel.getRouteNodeJSON(routeXmlNode);
            }
            if (!nodeData) {
                nodeData = answer;
            }
            folder["camelNodeData"] = nodeData;
        }
        return nodeData;
    }
    Camel.getRouteFolderJSON = getRouteFolderJSON;
    function getRouteNodeJSON(routeXmlNode, answer) {
        if (answer === void 0) { answer = {}; }
        if (routeXmlNode) {
            angular.forEach(routeXmlNode.attributes, function (attr) {
                answer[attr.name] = attr.value;
            });
            var localName = routeXmlNode.localName;
            if (localName !== "route" && localName !== "routes" && localName !== "camelContext") {
                $(routeXmlNode).children("*").each(function (idx, element) {
                    var nodeName = element.localName;
                    var langSettings = Camel.camelLanguageSettings(nodeName);
                    if (langSettings) {
                        answer["expression"] = {
                            language: nodeName,
                            expression: element.textContent
                        };
                    }
                    else {
                        if (!isCamelPattern(nodeName)) {
                            var nested = getRouteNodeJSON(element);
                            if (nested) {
                                answer[nodeName] = nested;
                            }
                        }
                    }
                });
            }
        }
        return answer;
    }
    Camel.getRouteNodeJSON = getRouteNodeJSON;
    function increaseIndent(currentIndent, indentAmount) {
        if (indentAmount === void 0) { indentAmount = "  "; }
        return currentIndent + indentAmount;
    }
    Camel.increaseIndent = increaseIndent;
    function setRouteNodeJSON(routeXmlNode, newData, indent) {
        if (routeXmlNode) {
            var childIndent = increaseIndent(indent);
            function doUpdate(value, key, append) {
                if (append === void 0) { append = false; }
                if (angular.isArray(value)) {
                    $(routeXmlNode).children(key).remove();
                    angular.forEach(value, function (item) {
                        doUpdate(item, key, true);
                    });
                }
                else if (angular.isObject(value)) {
                    var textContent = null;
                    if (key === "expression") {
                        var languageName = value["language"];
                        if (languageName) {
                            key = languageName;
                            textContent = value["expression"];
                            value = angular.copy(value);
                            delete value["expression"];
                            delete value["language"];
                        }
                    }
                    var nested = $(routeXmlNode).children(key);
                    var element = null;
                    if (append || !nested || !nested.length) {
                        var doc = routeXmlNode.ownerDocument || document;
                        routeXmlNode.appendChild(doc.createTextNode("\n" + childIndent));
                        element = doc.createElementNS(routeXmlNode.namespaceURI, key);
                        if (textContent) {
                            element.appendChild(doc.createTextNode(textContent));
                        }
                        routeXmlNode.appendChild(element);
                    }
                    else {
                        element = nested[0];
                    }
                    setRouteNodeJSON(element, value, childIndent);
                    if (textContent) {
                        nested.text(textContent);
                    }
                }
                else {
                    if (value) {
                        if (key.startsWith("_")) {
                        }
                        else {
                            var text = value.toString();
                            routeXmlNode.setAttribute(key, text);
                        }
                    }
                    else {
                        routeXmlNode.removeAttribute(key);
                    }
                }
            }
            angular.forEach(newData, function (value, key) { return doUpdate(value, key, false); });
        }
    }
    Camel.setRouteNodeJSON = setRouteNodeJSON;
    function getRouteNodeIcon(nodeSettingsOrXmlNode) {
        var nodeSettings = null;
        if (nodeSettingsOrXmlNode) {
            var nodeName = nodeSettingsOrXmlNode.localName;
            if (nodeName) {
                nodeSettings = getCamelSchema(nodeName);
            }
            else {
                nodeSettings = nodeSettingsOrXmlNode;
            }
        }
        if (nodeSettings) {
            var imageName = nodeSettings["icon"] || "generic24.png";
            return Core.url("/img/icons/camel/" + imageName);
        }
        else {
            return null;
        }
    }
    Camel.getRouteNodeIcon = getRouteNodeIcon;
    function getSelectedEndpointName(workspace) {
        var selection = workspace.selection;
        if (selection && selection['objectName'] && selection['typeName'] && selection['typeName'] === 'endpoints') {
            var mbean = Core.parseMBean(selection['objectName']);
            if (!mbean) {
                return null;
            }
            var attributes = mbean['attributes'];
            if (!attributes) {
                return null;
            }
            if (!('name' in attributes)) {
                return null;
            }
            var uri = attributes['name'];
            uri = uri.replace("\\?", "?");
            if (uri.startsWith("\"")) {
                uri = uri.last(uri.length - 1);
            }
            if (uri.endsWith("\"")) {
                uri = uri.first(uri.length - 1);
            }
            return uri;
        }
        else {
            return null;
        }
    }
    Camel.getSelectedEndpointName = getSelectedEndpointName;
    function escapeEndpointUriNameForJmx(uri) {
        if (angular.isString(uri)) {
            var answer = uri.replace("?", "\\?");
            answer = answer.replace(/\:(\/[^\/])/, "://$1");
            answer = answer.replace(/\:([^\/])/, "://$1");
            return answer;
        }
        else {
            return uri;
        }
    }
    Camel.escapeEndpointUriNameForJmx = escapeEndpointUriNameForJmx;
    function getContextAndTargetEndpoint(workspace) {
        return {
            uri: Camel.getSelectedEndpointName(workspace),
            mbean: Camel.getSelectionCamelContextMBean(workspace)
        };
    }
    Camel.getContextAndTargetEndpoint = getContextAndTargetEndpoint;
    function getSelectedRouteNode(workspace) {
        var selection = workspace.selection;
        return (selection && Camel.jmxDomain === selection.domain) ? selection["routeXmlNode"] : null;
    }
    Camel.getSelectedRouteNode = getSelectedRouteNode;
    function clearSelectedRouteNode(workspace) {
        var selection = workspace.selection;
        if (selection && Camel.jmxDomain === selection.domain) {
            delete selection["routeXmlNode"];
        }
    }
    Camel.clearSelectedRouteNode = clearSelectedRouteNode;
    function getCamelSchema(nodeIdOrDefinition) {
        return (angular.isObject(nodeIdOrDefinition)) ? nodeIdOrDefinition : Forms.lookupDefinition(nodeIdOrDefinition, _apacheCamelModel);
    }
    Camel.getCamelSchema = getCamelSchema;
    function isCamelPattern(nodeId) {
        return Forms.isJsonType(nodeId, _apacheCamelModel, "org.apache.camel.model.OptionalIdentifiedDefinition");
    }
    Camel.isCamelPattern = isCamelPattern;
    function isNextSiblingAddedAsChild(nodeIdOrDefinition) {
        var definition = getCamelSchema(nodeIdOrDefinition);
        if (definition) {
            return definition["nextSiblingAddedAsChild"] || false;
        }
        return null;
    }
    Camel.isNextSiblingAddedAsChild = isNextSiblingAddedAsChild;
    function acceptInput(nodeIdOrDefinition) {
        var definition = getCamelSchema(nodeIdOrDefinition);
        if (definition) {
            return definition["acceptInput"] || false;
        }
        return null;
    }
    Camel.acceptInput = acceptInput;
    function acceptOutput(nodeIdOrDefinition) {
        var definition = getCamelSchema(nodeIdOrDefinition);
        if (definition) {
            return definition["acceptOutput"] || false;
        }
        return null;
    }
    Camel.acceptOutput = acceptOutput;
    function camelLanguageSettings(nodeName) {
        return _apacheCamelModel.languages[nodeName];
    }
    Camel.camelLanguageSettings = camelLanguageSettings;
    function isCamelLanguage(nodeName) {
        return (camelLanguageSettings(nodeName) || nodeName === "expression") ? true : false;
    }
    Camel.isCamelLanguage = isCamelLanguage;
    function loadCamelTree(xml, key) {
        var doc = xml;
        if (angular.isString(xml)) {
            doc = $.parseXML(xml);
        }
        var id = "camelContext";
        var folder = new Folder(id);
        folder.addClass = "org-apache-camel-context";
        folder.domain = Camel.jmxDomain;
        folder.typeName = "context";
        folder.key = Core.toSafeDomID(key);
        var context = $(doc).find("camelContext");
        if (!context || !context.length) {
            context = $(doc).find("routes");
        }
        if (context && context.length) {
            folder["xmlDocument"] = doc;
            folder["routeXmlNode"] = context;
            $(context).children("route").each(function (idx, route) {
                var id = route.getAttribute("id");
                if (!id) {
                    id = "route" + idx;
                    route.setAttribute("id", id);
                }
                var routeFolder = new Folder(id);
                routeFolder.addClass = "org-apache-camel-route";
                routeFolder.typeName = "routes";
                routeFolder.domain = Camel.jmxDomain;
                routeFolder.key = folder.key + "_" + Core.toSafeDomID(id);
                routeFolder.parent = folder;
                var nodeSettings = getCamelSchema("route");
                if (nodeSettings) {
                    var imageUrl = getRouteNodeIcon(nodeSettings);
                    routeFolder.tooltip = nodeSettings["tooltip"] || nodeSettings["description"] || id;
                    routeFolder.icon = imageUrl;
                }
                folder.children.push(routeFolder);
                addRouteChildren(routeFolder, route);
            });
        }
        return folder;
    }
    Camel.loadCamelTree = loadCamelTree;
    function addRouteChildren(folder, route) {
        folder.children = [];
        folder["routeXmlNode"] = route;
        route.setAttribute("_cid", folder.key);
        $(route).children("*").each(function (idx, n) {
            addRouteChild(folder, n);
        });
    }
    Camel.addRouteChildren = addRouteChildren;
    function addRouteChild(folder, n) {
        var nodeName = n.localName;
        if (nodeName) {
            var nodeSettings = getCamelSchema(nodeName);
            if (nodeSettings) {
                var imageUrl = getRouteNodeIcon(nodeSettings);
                var child = new Folder(nodeName);
                child.domain = Camel.jmxDomain;
                child.typeName = "routeNode";
                updateRouteNodeLabelAndTooltip(child, n, nodeSettings);
                child.parent = folder;
                child.folderNames = folder.folderNames;
                var id = n.getAttribute("id") || nodeName;
                var key = folder.key + "_" + Core.toSafeDomID(id);
                var counter = 1;
                var notFound = true;
                while (notFound) {
                    var tmpKey = key + counter;
                    if (folder.children.some({ key: tmpKey })) {
                        counter += 1;
                    }
                    else {
                        notFound = false;
                        key = tmpKey;
                    }
                }
                child.key = key;
                child.icon = imageUrl;
                child["routeXmlNode"] = n;
                if (!folder.children) {
                    folder.children = [];
                }
                folder.children.push(child);
                addRouteChildren(child, n);
                return child;
            }
        }
        return null;
    }
    Camel.addRouteChild = addRouteChild;
    function getRootCamelFolder(workspace) {
        var tree = workspace ? workspace.tree : null;
        if (tree) {
            return tree.get(Camel.jmxDomain);
        }
        return null;
    }
    Camel.getRootCamelFolder = getRootCamelFolder;
    function getCamelContextFolder(workspace, camelContextId) {
        var answer = null;
        var root = getRootCamelFolder(workspace);
        if (root && camelContextId) {
            angular.forEach(root.children, function (contextFolder) {
                if (!answer && camelContextId === contextFolder.title) {
                    answer = contextFolder;
                }
            });
        }
        return answer;
    }
    Camel.getCamelContextFolder = getCamelContextFolder;
    function getCamelContextMBean(workspace, camelContextId) {
        var contextsFolder = getCamelContextFolder(workspace, camelContextId);
        if (contextsFolder) {
            var contextFolder = contextsFolder.navigate("context");
            if (contextFolder && contextFolder.children && contextFolder.children.length) {
                var contextItem = contextFolder.children[0];
                return contextItem.objectName;
            }
        }
        return null;
    }
    Camel.getCamelContextMBean = getCamelContextMBean;
    function linkToFullScreenView(workspace) {
        var answer = null;
        var selection = workspace.selection;
        if (selection) {
            var entries = selection.entries;
            if (entries) {
                var contextId = entries["context"];
                var name = entries["name"];
                var type = entries["type"];
                if ("endpoints" === type) {
                    return linkToBrowseEndpointFullScreen(contextId, name);
                }
                if ("routes" === type) {
                    return linkToRouteDiagramFullScreen(contextId, name);
                }
            }
        }
        return answer;
    }
    Camel.linkToFullScreenView = linkToFullScreenView;
    function linkToBrowseEndpointFullScreen(contextId, endpointPath) {
        var answer = null;
        if (contextId && endpointPath) {
            answer = "#/camel/endpoint/browse/" + contextId + "/" + endpointPath;
        }
        return answer;
    }
    Camel.linkToBrowseEndpointFullScreen = linkToBrowseEndpointFullScreen;
    function linkToRouteDiagramFullScreen(contextId, routeId) {
        var answer = null;
        if (contextId && routeId) {
            answer = "#/camel/route/diagram/" + contextId + "/" + routeId;
        }
        return answer;
    }
    Camel.linkToRouteDiagramFullScreen = linkToRouteDiagramFullScreen;
    function getFolderCamelNodeId(folder) {
        var answer = Core.pathGet(folder, ["routeXmlNode", "localName"]);
        return ("from" === answer || "to" === answer) ? "endpoint" : answer;
    }
    Camel.getFolderCamelNodeId = getFolderCamelNodeId;
    function createFolderXmlTree(treeNode, xmlNode, indent) {
        if (indent === void 0) { indent = Camel.increaseIndent(""); }
        var folder = treeNode.data || treeNode;
        var count = 0;
        var parentName = getFolderCamelNodeId(folder);
        if (folder) {
            if (!xmlNode) {
                xmlNode = document.createElement(parentName);
                var rootJson = Camel.getRouteFolderJSON(folder);
                if (rootJson) {
                    Camel.setRouteNodeJSON(xmlNode, rootJson, indent);
                }
            }
            var doc = xmlNode.ownerDocument || document;
            var namespaceURI = xmlNode.namespaceURI;
            var from = parentName !== "route";
            var childIndent = Camel.increaseIndent(indent);
            angular.forEach(treeNode.children || treeNode.getChildren(), function (childTreeNode) {
                var childFolder = childTreeNode.data || childTreeNode;
                var name = Camel.getFolderCamelNodeId(childFolder);
                var json = Camel.getRouteFolderJSON(childFolder);
                if (name && json) {
                    var language = false;
                    if (name === "endpoint") {
                        if (from) {
                            name = "to";
                        }
                        else {
                            name = "from";
                            from = true;
                        }
                    }
                    if (name === "expression") {
                        var languageName = json["language"];
                        if (languageName) {
                            name = languageName;
                            language = true;
                        }
                    }
                    xmlNode.appendChild(doc.createTextNode("\n" + childIndent));
                    var newNode = doc.createElementNS(namespaceURI, name);
                    Camel.setRouteNodeJSON(newNode, json, childIndent);
                    xmlNode.appendChild(newNode);
                    count += 1;
                    createFolderXmlTree(childTreeNode, newNode, childIndent);
                }
            });
            if (count) {
                xmlNode.appendChild(doc.createTextNode("\n" + indent));
            }
        }
        return xmlNode;
    }
    Camel.createFolderXmlTree = createFolderXmlTree;
    function updateRouteNodeLabelAndTooltip(folder, routeXmlNode, nodeSettings) {
        var localName = routeXmlNode.localName;
        var id = routeXmlNode.getAttribute("id");
        var label = nodeSettings["title"] || localName;
        var tooltip = nodeSettings["tooltip"] || nodeSettings["description"] || label;
        if (id) {
            label = id;
        }
        else {
            var uri = getRouteNodeUri(routeXmlNode);
            if (uri) {
                label = uri;
                var split = uri.split("?");
                if (split && split.length > 1) {
                    label = split[0];
                }
                tooltip += " " + uri;
            }
            else {
                var children = $(routeXmlNode).children("*");
                if (children && children.length) {
                    var child = children[0];
                    var childName = child.localName;
                    var expression = null;
                    if (Camel.isCamelLanguage(childName)) {
                        expression = child.textContent;
                        if (!expression) {
                            expression = child.getAttribute("expression");
                        }
                    }
                    if (expression) {
                        label += " " + expression;
                        tooltip += " " + childName + " expression";
                    }
                }
            }
        }
        folder.title = label;
        folder.tooltip = tooltip;
        return label;
    }
    Camel.updateRouteNodeLabelAndTooltip = updateRouteNodeLabelAndTooltip;
    function getSelectionCamelContextMBean(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "context");
                    if (result && result.children) {
                        var contextBean = result.children.first();
                        if (contextBean.title) {
                            var contextName = contextBean.title;
                            return "" + domain + ":context=" + contextId + ',type=context,name="' + contextName + '"';
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelContextMBean = getSelectionCamelContextMBean;
    function getSelectionCamelContextEndpoints(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    return tree.navigate(domain, contextId, "endpoints");
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelContextEndpoints = getSelectionCamelContextEndpoints;
    function getSelectionCamelTraceMBean(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "tracer");
                    if (result && result.children) {
                        var mbean = result.children.find(function (m) { return m.title.startsWith("BacklogTracer"); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                    var fabricResult = tree.navigate(domain, contextId, "fabric");
                    if (fabricResult && fabricResult.children) {
                        var mbean = fabricResult.children.first();
                        return mbean.objectName;
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelTraceMBean = getSelectionCamelTraceMBean;
    function getSelectionCamelDebugMBean(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "tracer");
                    if (result && result.children) {
                        var mbean = result.children.find(function (m) { return m.title.startsWith("BacklogDebugger"); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelDebugMBean = getSelectionCamelDebugMBean;
    function getSelectionCamelTypeConverter(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "services");
                    if (result && result.children) {
                        var mbean = result.children.find(function (m) { return m.title.startsWith("DefaultTypeConverter"); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelTypeConverter = getSelectionCamelTypeConverter;
    function getSelectionCamelRestRegistry(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "services");
                    if (result && result.children) {
                        var mbean = result.children.find(function (m) { return m.title.startsWith("DefaultRestRegistry"); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelRestRegistry = getSelectionCamelRestRegistry;
    function getSelectionCamelRouteMetrics(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "services");
                    if (result && result.children) {
                        var mbean = result.children.find(function (m) { return m.title.startsWith("MetricsRegistryService"); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelRouteMetrics = getSelectionCamelRouteMetrics;
    function getContextId(workspace) {
        var selection = workspace.selection;
        if (selection) {
            selection = selection.findAncestor(function (s) { return s.title === 'context' || s.parent != null && s.parent.title === 'org.apache.camel'; });
            if (selection) {
                var tree = workspace.tree;
                var folderNames = selection.folderNames;
                var entries = selection.entries;
                var contextId;
                if (tree) {
                    if (folderNames && folderNames.length > 1) {
                        contextId = folderNames[1];
                    }
                    else if (entries) {
                        contextId = entries["context"];
                    }
                }
            }
        }
        return contextId;
    }
    Camel.getContextId = getContextId;
    function isState(item, state) {
        var value = (item.State || "").toLowerCase();
        if (angular.isArray(state)) {
            return state.any(function (stateText) { return value.startsWith(stateText); });
        }
        else {
            return value.startsWith(state);
        }
    }
    Camel.isState = isState;
    function iconClass(state) {
        if (state) {
            switch (state.toLowerCase()) {
                case 'started':
                    return "green icon-play-circle";
                case 'suspended':
                    return "icon-pause";
            }
        }
        return "orange icon-off";
    }
    Camel.iconClass = iconClass;
    function getSelectedRouteId(workspace, folder) {
        if (folder === void 0) { folder = null; }
        var selection = folder || workspace.selection;
        var selectedRouteId = null;
        if (selection) {
            if (selection && selection.entries) {
                var typeName = selection.entries["type"];
                var name = selection.entries["name"];
                if ("routes" === typeName && name) {
                    selectedRouteId = Core.trimQuotes(name);
                }
            }
        }
        return selectedRouteId;
    }
    Camel.getSelectedRouteId = getSelectedRouteId;
    function getSelectionRouteMBean(workspace, routeId) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "routes");
                    if (result && result.children) {
                        var mbean = result.children.find(function (m) { return m.title === routeId; });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionRouteMBean = getSelectionRouteMBean;
    function getCamelVersion(workspace, jolokia) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, contextId, "context");
                    if (result && result.children) {
                        var contextBean = result.children.first();
                        if (contextBean.version) {
                            return contextBean.version;
                        }
                        if (contextBean.title) {
                            var contextName = contextBean.title;
                            var mbean = "" + domain + ":context=" + contextId + ',type=context,name="' + contextName + '"';
                            var version = jolokia.getAttribute(mbean, "CamelVersion", onSuccess(null));
                            contextBean.version = version;
                            return version;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getCamelVersion = getCamelVersion;
    function createMessageFromXml(exchange) {
        var exchangeElement = $(exchange);
        var uid = exchangeElement.children("uid").text();
        var timestamp = exchangeElement.children("timestamp").text();
        var messageData = {
            headers: {},
            headerTypes: {},
            id: null,
            uid: uid,
            timestamp: timestamp,
            headerHtml: ""
        };
        var message = exchangeElement.children("message")[0];
        if (!message) {
            message = exchange;
        }
        var messageElement = $(message);
        var headers = messageElement.find("header");
        var headerHtml = "";
        headers.each(function (idx, header) {
            var key = header.getAttribute("key");
            var typeName = header.getAttribute("type");
            var value = header.textContent;
            if (key) {
                if (value)
                    messageData.headers[key] = value;
                if (typeName)
                    messageData.headerTypes[key] = typeName;
                headerHtml += "<tr><td class='property-name'>" + key + "</td>" + "<td class='property-value'>" + (value || "") + "</td></tr>";
            }
        });
        messageData.headerHtml = headerHtml;
        var id = messageData.headers["breadcrumbId"];
        if (!id) {
            var postFixes = ["MessageID", "ID", "Path", "Name"];
            angular.forEach(postFixes, function (postfix) {
                if (!id) {
                    angular.forEach(messageData.headers, function (value, key) {
                        if (!id && key.endsWith(postfix)) {
                            id = value;
                        }
                    });
                }
            });
            angular.forEach(messageData.headers, function (value, key) {
                if (!id)
                    id = value;
            });
        }
        messageData.id = id;
        var body = messageElement.children("body")[0];
        if (body) {
            var bodyText = body.textContent;
            var bodyType = body.getAttribute("type");
            messageData["body"] = bodyText;
            messageData["bodyType"] = bodyType;
        }
        return messageData;
    }
    Camel.createMessageFromXml = createMessageFromXml;
    function createBrowseGridOptions() {
        return {
            selectedItems: [],
            data: 'messages',
            displayFooter: false,
            showFilter: false,
            showColumnMenu: true,
            enableColumnResize: true,
            enableColumnReordering: true,
            filterOptions: {
                filterText: ''
            },
            selectWithCheckboxOnly: true,
            showSelectionCheckbox: true,
            maintainColumnRatios: false,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'ID',
                    cellTemplate: '<div class="ngCellText"><a ng-click="openMessageDialog(row)">{{row.entity.id}}</a></div>'
                }
            ]
        };
    }
    Camel.createBrowseGridOptions = createBrowseGridOptions;
    function loadRouteXmlNodes($scope, doc, selectedRouteId, nodes, links, width) {
        var allRoutes = $(doc).find("route");
        var routeDelta = width / allRoutes.length;
        var rowX = 0;
        allRoutes.each(function (idx, route) {
            var routeId = route.getAttribute("id");
            if (!selectedRouteId || !routeId || selectedRouteId === routeId) {
                Camel.addRouteXmlChildren($scope, route, nodes, links, null, rowX, 0);
                rowX += routeDelta;
            }
        });
    }
    Camel.loadRouteXmlNodes = loadRouteXmlNodes;
    function addRouteXmlChildren($scope, parent, nodes, links, parentId, parentX, parentY, parentNode) {
        if (parentNode === void 0) { parentNode = null; }
        var delta = 150;
        var x = parentX;
        var y = parentY + delta;
        var rid = parent.getAttribute("id");
        var siblingNodes = [];
        var parenNodeName = parent.localName;
        $(parent).children().each(function (idx, route) {
            var id = nodes.length;
            var nodeId = route.localName;
            if (nodeId === "from" && !parentId) {
                parentId = id;
            }
            var nodeSettings = getCamelSchema(nodeId);
            var node = null;
            if (nodeSettings) {
                var label = nodeSettings["title"] || nodeId;
                var uri = getRouteNodeUri(route);
                if (uri) {
                    label += " " + uri.split("?")[0];
                }
                var tooltip = nodeSettings["tooltip"] || nodeSettings["description"] || label;
                if (uri) {
                    tooltip += " " + uri;
                }
                var elementID = route.getAttribute("id");
                var labelSummary = label;
                if (elementID) {
                    var customId = route.getAttribute("customId");
                    if ($scope.camelIgnoreIdForLabel || (!customId || customId === "false")) {
                        labelSummary = "id: " + elementID;
                    }
                    else {
                        label = elementID;
                    }
                }
                var labelLimit = $scope.camelMaximumLabelWidth || Camel.defaultMaximumLabelWidth;
                var length = label.length;
                if (length > labelLimit) {
                    labelSummary = label + "\n\n" + labelSummary;
                    label = label.substring(0, labelLimit) + "..";
                }
                var imageUrl = getRouteNodeIcon(nodeSettings);
                if ((nodeId === "from" || nodeId === "to") && uri) {
                    var uriIdx = uri.indexOf(":");
                    if (uriIdx > 0) {
                        var componentScheme = uri.substring(0, uriIdx);
                        if (componentScheme) {
                            var value = Camel.getEndpointIcon(componentScheme);
                            if (value) {
                                imageUrl = Core.url(value);
                            }
                        }
                    }
                }
                var cid = route.getAttribute("_cid") || route.getAttribute("id");
                node = { "name": name, "label": label, "labelSummary": labelSummary, "group": 1, "id": id, "elementId": elementID, "x": x, "y:": y, "imageUrl": imageUrl, "cid": cid, "tooltip": tooltip, "type": nodeId };
                if (rid) {
                    node["rid"] = rid;
                    if (!$scope.routeNodes)
                        $scope.routeNodes = {};
                    $scope.routeNodes[rid] = node;
                }
                if (!cid) {
                    cid = nodeId + (nodes.length + 1);
                }
                if (cid) {
                    node["cid"] = cid;
                    if (!$scope.nodes)
                        $scope.nodes = {};
                    $scope.nodes[cid] = node;
                }
                rid = null;
                nodes.push(node);
                if (parentId !== null && parentId !== id) {
                    if (siblingNodes.length === 0 || parenNodeName === "choice") {
                        links.push({ "source": parentId, "target": id, "value": 1 });
                    }
                    else {
                        siblingNodes.forEach(function (nodeId) {
                            links.push({ "source": nodeId, "target": id, "value": 1 });
                        });
                        siblingNodes.length = 0;
                    }
                }
            }
            else {
                var langSettings = Camel.camelLanguageSettings(nodeId);
                if (langSettings && parentNode) {
                    var name = langSettings["name"] || nodeId;
                    var text = route.textContent;
                    if (text) {
                        parentNode["tooltip"] = parentNode["label"] + " " + name + " " + text;
                        parentNode["label"] = text;
                    }
                    else {
                        parentNode["label"] = parentNode["label"] + " " + name;
                    }
                }
            }
            var siblings = addRouteXmlChildren($scope, route, nodes, links, id, x, y, node);
            if (parenNodeName === "choice") {
                siblingNodes = siblingNodes.concat(siblings);
                x += delta;
            }
            else if (nodeId === "choice") {
                siblingNodes = siblings;
                y += delta;
            }
            else {
                siblingNodes = [nodes.length - 1];
                y += delta;
            }
        });
        return siblingNodes;
    }
    Camel.addRouteXmlChildren = addRouteXmlChildren;
    function getCanvasHeight(canvasDiv) {
        var height = canvasDiv.height();
        if (height < 300) {
            console.log("browse thinks the height is only " + height + " so calculating offset from doc height");
            var offset = canvasDiv.offset();
            height = $(document).height() - 5;
            if (offset) {
                var top = offset['top'];
                if (top) {
                    height -= top;
                }
            }
        }
        return height;
    }
    Camel.getCanvasHeight = getCanvasHeight;
    function addFoldersToIndex(folder, map) {
        if (map === void 0) { map = {}; }
        if (folder) {
            var key = folder.key;
            if (key) {
                map[key] = folder;
            }
            angular.forEach(folder.children, function (child) { return addFoldersToIndex(child, map); });
        }
        return map;
    }
    Camel.addFoldersToIndex = addFoldersToIndex;
    function generateXmlFromFolder(treeNode) {
        var folder = (treeNode && treeNode.data) ? treeNode.data : treeNode;
        if (!folder)
            return null;
        var doc = folder["xmlDocument"];
        var context = folder["routeXmlNode"];
        if (context && context.length) {
            var element = context[0];
            var children = element.childNodes;
            var routeIndices = [];
            for (var i = 0; i < children.length; i++) {
                var node = children[i];
                var name = node.localName;
                if ("route" === name && parent) {
                    routeIndices.push(i);
                }
            }
            while (routeIndices.length) {
                var idx = routeIndices.pop();
                var nextIndex = idx + 1;
                while (true) {
                    var node = element.childNodes[nextIndex];
                    if (Core.isTextNode(node)) {
                        element.removeChild(node);
                    }
                    else {
                        break;
                    }
                }
                if (idx < element.childNodes.length) {
                    element.removeChild(element.childNodes[idx]);
                }
                for (var i = idx - 1; i >= 0; i--) {
                    var node = element.childNodes[i];
                    if (Core.isTextNode(node)) {
                        element.removeChild(node);
                    }
                    else {
                        break;
                    }
                }
            }
            Camel.createFolderXmlTree(treeNode, context[0]);
        }
        return doc;
    }
    Camel.generateXmlFromFolder = generateXmlFromFolder;
    function camelContextMBeansById(workspace) {
        var answer = {};
        var tree = workspace.tree;
        if (tree) {
            var camelTree = tree.navigate(Camel.jmxDomain);
            if (camelTree) {
                angular.forEach(camelTree.children, function (contextsFolder) {
                    var contextFolder = contextsFolder.navigate("context");
                    if (contextFolder && contextFolder.children && contextFolder.children.length) {
                        var contextItem = contextFolder.children[0];
                        var id = Core.pathGet(contextItem, ["entries", "name"]) || contextItem.key;
                        if (id) {
                            answer[id] = {
                                folder: contextItem,
                                mbean: contextItem.objectName
                            };
                        }
                    }
                });
            }
        }
        return answer;
    }
    Camel.camelContextMBeansById = camelContextMBeansById;
    function camelContextMBeansByComponentName(workspace) {
        return camelContextMBeansByRouteOrComponentId(workspace, "components");
    }
    Camel.camelContextMBeansByComponentName = camelContextMBeansByComponentName;
    function camelContextMBeansByRouteId(workspace) {
        return camelContextMBeansByRouteOrComponentId(workspace, "routes");
    }
    Camel.camelContextMBeansByRouteId = camelContextMBeansByRouteId;
    function camelContextMBeansByRouteOrComponentId(workspace, componentsOrRoutes) {
        var answer = {};
        var tree = workspace.tree;
        if (tree) {
            var camelTree = tree.navigate(Camel.jmxDomain);
            if (camelTree) {
                angular.forEach(camelTree.children, function (contextsFolder) {
                    var contextFolder = contextsFolder.navigate("context");
                    var componentsFolder = contextsFolder.navigate(componentsOrRoutes);
                    if (contextFolder && componentsFolder && contextFolder.children && contextFolder.children.length) {
                        var contextItem = contextFolder.children[0];
                        var mbean = contextItem.objectName;
                        if (mbean) {
                            var contextValues = {
                                folder: contextItem,
                                mbean: mbean
                            };
                            angular.forEach(componentsFolder.children, function (componentFolder) {
                                var id = componentFolder.title;
                                if (id) {
                                    answer[id] = contextValues;
                                }
                            });
                        }
                    }
                });
            }
        }
        return answer;
    }
    function camelProcessorMBeansById(workspace) {
        var answer = {};
        var tree = workspace.tree;
        if (tree) {
            var camelTree = tree.navigate(Camel.jmxDomain);
            if (camelTree) {
                angular.forEach(camelTree.children, function (contextsFolder) {
                    var processorsFolder = contextsFolder.navigate("processors");
                    if (processorsFolder && processorsFolder.children && processorsFolder.children.length) {
                        angular.forEach(processorsFolder.children, function (processorFolder) {
                            var id = processorFolder.title;
                            if (id) {
                                var processorValues = {
                                    folder: processorsFolder,
                                    key: processorFolder.key
                                };
                                answer[id] = processorValues;
                            }
                        });
                    }
                });
            }
        }
        return answer;
    }
    Camel.camelProcessorMBeansById = camelProcessorMBeansById;
    function ignoreIdForLabel(localStorage) {
        var value = localStorage["camelIgnoreIdForLabel"];
        return value && (value === "true" || value === true);
    }
    Camel.ignoreIdForLabel = ignoreIdForLabel;
    function maximumLabelWidth(localStorage) {
        var value = localStorage["camelMaximumLabelWidth"];
        if (angular.isString(value)) {
            value = parseInt(value);
        }
        if (!value) {
            value = Camel.defaultMaximumLabelWidth;
        }
        return value;
    }
    Camel.maximumLabelWidth = maximumLabelWidth;
    function maximumTraceOrDebugBodyLength(localStorage) {
        var value = localStorage["camelMaximumTraceOrDebugBodyLength"];
        if (angular.isString(value)) {
            value = parseInt(value);
        }
        if (!value) {
            value = Camel.defaultCamelMaximumTraceOrDebugBodyLength;
        }
        return value;
    }
    Camel.maximumTraceOrDebugBodyLength = maximumTraceOrDebugBodyLength;
    function routeMetricMaxSeconds(localStorage) {
        var value = localStorage["camelRouteMetricMaxSeconds"];
        if (angular.isString(value)) {
            value = parseInt(value);
        }
        if (!value) {
            value = Camel.defaultCamelRouteMetricMaxSeconds;
        }
        return value;
    }
    Camel.routeMetricMaxSeconds = routeMetricMaxSeconds;
    function highlightSelectedNode(nodes, toNode) {
        nodes.attr("class", "node");
        nodes.filter(function (item) {
            if (item) {
                var cid = item["cid"];
                var rid = item["rid"];
                var type = item["type"];
                var elementId = item["elementId"];
                if ("from" === type) {
                    return toNode === rid;
                }
                if (elementId) {
                    return toNode === elementId;
                }
                if (cid) {
                    return toNode === cid;
                }
                else {
                    return toNode === rid;
                }
            }
            return null;
        }).attr("class", "node selected");
    }
    Camel.highlightSelectedNode = highlightSelectedNode;
    function isCamelVersionEQGT(major, minor, workspace, jolokia) {
        var camelVersion = getCamelVersion(workspace, jolokia);
        if (camelVersion) {
            console.log("Camel version " + camelVersion);
            camelVersion += "camel-";
            var numbers = Core.parseVersionNumbers(camelVersion);
            if (Core.compareVersionNumberArrays(numbers, [major, minor]) >= 0) {
                return true;
            }
            else {
                return false;
            }
        }
        return false;
    }
    Camel.isCamelVersionEQGT = isCamelVersionEQGT;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var jmxModule = Jmx;
    Camel.pluginName = 'camel';
    var routeToolBar = "app/camel/html/attributeToolBarRoutes.html";
    var contextToolBar = "app/camel/html/attributeToolBarContext.html";
    Camel._module = angular.module(Camel.pluginName, ['bootstrap', 'ui.bootstrap', 'ui.bootstrap.dialog', 'ui.bootstrap.tabs', 'ui.bootstrap.typeahead', 'ngResource', 'hawtioCore', 'hawtio-ui']);
    Camel._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/camel/browseEndpoint', { templateUrl: 'app/camel/html/browseEndpoint.html' }).when('/camel/endpoint/browse/:contextId/*endpointPath', { templateUrl: 'app/camel/html/browseEndpoint.html' }).when('/camel/createEndpoint', { templateUrl: 'app/camel/html/createEndpoint.html' }).when('/camel/route/diagram/:contextId/:routeId', { templateUrl: 'app/camel/html/routes.html' }).when('/camel/routes', { templateUrl: 'app/camel/html/routes.html' }).when('/camel/fabricDiagram', { templateUrl: 'app/camel/html/fabricDiagram.html', reloadOnSearch: false }).when('/camel/typeConverter', { templateUrl: 'app/camel/html/typeConverter.html', reloadOnSearch: false }).when('/camel/restRegistry', { templateUrl: 'app/camel/html/restRegistry.html', reloadOnSearch: false }).when('/camel/routeMetrics', { templateUrl: 'app/camel/html/routeMetrics.html', reloadOnSearch: false }).when('/camel/sendMessage', { templateUrl: 'app/camel/html/sendMessage.html', reloadOnSearch: false }).when('/camel/source', { templateUrl: 'app/camel/html/source.html' }).when('/camel/traceRoute', { templateUrl: 'app/camel/html/traceRoute.html' }).when('/camel/debugRoute', { templateUrl: 'app/camel/html/debug.html' }).when('/camel/profileRoute', { templateUrl: 'app/camel/html/profileRoute.html' }).when('/camel/properties', { templateUrl: 'app/camel/html/properties.html' });
    }]);
    Camel._module.factory('tracerStatus', function () {
        return {
            jhandle: null,
            messages: []
        };
    });
    Camel._module.filter('camelIconClass', function () { return Camel.iconClass; });
    Camel._module.factory('activeMQMessage', function () {
        return { 'message': null };
    });
    Camel._module.run(["workspace", "jolokia", "viewRegistry", "layoutFull", "helpRegistry", "preferencesRegistry", function (workspace, jolokia, viewRegistry, layoutFull, helpRegistry, preferencesRegistry) {
        viewRegistry['camel/endpoint/'] = layoutFull;
        viewRegistry['camel/route/'] = layoutFull;
        viewRegistry['camel/fabricDiagram'] = layoutFull;
        viewRegistry['camel'] = 'app/camel/html/layoutCamelTree.html';
        helpRegistry.addUserDoc('camel', 'app/camel/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties(Camel.jmxDomain);
        });
        preferencesRegistry.addTab('Camel', 'app/camel/html/preferences.html', function () {
            return workspace.treeContainsDomainAndProperties(Camel.jmxDomain);
        });
        Jmx.addAttributeToolBar(Camel.pluginName, Camel.jmxDomain, function (selection) {
            var typeName = selection.typeName;
            if (typeName) {
                if (typeName.startsWith("context"))
                    return contextToolBar;
                if (typeName.startsWith("route"))
                    return routeToolBar;
            }
            var folderNames = selection.folderNames;
            if (folderNames && selection.domain === Camel.jmxDomain) {
                var last = folderNames.last();
                if ("routes" === last)
                    return routeToolBar;
                if ("context" === last)
                    return contextToolBar;
            }
            return null;
        });
        var stateField = 'State';
        var stateTemplate = '<div class="ngCellText pagination-centered" title="{{row.getProperty(col.field)}}"><i class="{{row.getProperty(\'' + stateField + '\') | camelIconClass}}"></i></div>';
        var stateColumn = { field: stateField, displayName: stateField, cellTemplate: stateTemplate, width: 56, minWidth: 56, maxWidth: 56, resizable: false, defaultSort: false };
        var attributes = workspace.attributeColumnDefs;
        attributes[Camel.jmxDomain + "/context/folder"] = [
            stateColumn,
            { field: 'CamelId', displayName: 'Context' },
            { field: 'Uptime', displayName: 'Uptime', visible: false },
            { field: 'CamelVersion', displayName: 'Version', visible: false },
            { field: 'ExchangesCompleted', displayName: 'Completed #' },
            { field: 'ExchangesFailed', displayName: 'Failed #' },
            { field: 'FailuresHandled', displayName: 'Failed Handled #' },
            { field: 'ExchangesTotal', displayName: 'Total #', visible: false },
            { field: 'InflightExchanges', displayName: 'Inflight #' },
            { field: 'MeanProcessingTime', displayName: 'Mean Time' },
            { field: 'MinProcessingTime', displayName: 'Min Time' },
            { field: 'MaxProcessingTime', displayName: 'Max Time' },
            { field: 'TotalProcessingTime', displayName: 'Total Time', visible: false },
            { field: 'LastProcessingTime', displayName: 'Last Time', visible: false },
            { field: 'LastExchangeCompletedTimestamp', displayName: 'Last completed', visible: false },
            { field: 'LastExchangeFailedTimestamp', displayName: 'Last failed', visible: false },
            { field: 'Redeliveries', displayName: 'Redelivery #', visible: false },
            { field: 'ExternalRedeliveries', displayName: 'External Redelivery #', visible: false }
        ];
        attributes[Camel.jmxDomain + "/routes/folder"] = [
            stateColumn,
            { field: 'CamelId', displayName: 'Context' },
            { field: 'RouteId', displayName: 'Route' },
            { field: 'ExchangesCompleted', displayName: 'Completed #' },
            { field: 'ExchangesFailed', displayName: 'Failed #' },
            { field: 'FailuresHandled', displayName: 'Failed Handled #' },
            { field: 'ExchangesTotal', displayName: 'Total #', visible: false },
            { field: 'InflightExchanges', displayName: 'Inflight #' },
            { field: 'MeanProcessingTime', displayName: 'Mean Time' },
            { field: 'MinProcessingTime', displayName: 'Min Time' },
            { field: 'MaxProcessingTime', displayName: 'Max Time' },
            { field: 'TotalProcessingTime', displayName: 'Total Time', visible: false },
            { field: 'DeltaProcessingTime', displayName: 'Delta Time', visible: false },
            { field: 'LastProcessingTime', displayName: 'Last Time', visible: false },
            { field: 'LastExchangeCompletedTimestamp', displayName: 'Last completed', visible: false },
            { field: 'LastExchangeFailedTimestamp', displayName: 'Last failed', visible: false },
            { field: 'Redeliveries', displayName: 'Redelivery #', visible: false },
            { field: 'ExternalRedeliveries', displayName: 'External Redelivery #', visible: false }
        ];
        attributes[Camel.jmxDomain + "/processors/folder"] = [
            stateColumn,
            { field: 'CamelId', displayName: 'Context' },
            { field: 'RouteId', displayName: 'Route' },
            { field: 'ProcessorId', displayName: 'Processor' },
            { field: 'ExchangesCompleted', displayName: 'Completed #' },
            { field: 'ExchangesFailed', displayName: 'Failed #' },
            { field: 'FailuresHandled', displayName: 'Failed Handled #' },
            { field: 'ExchangesTotal', displayName: 'Total #', visible: false },
            { field: 'InflightExchanges', displayName: 'Inflight #' },
            { field: 'MeanProcessingTime', displayName: 'Mean Time' },
            { field: 'MinProcessingTime', displayName: 'Min Time' },
            { field: 'MaxProcessingTime', displayName: 'Max Time' },
            { field: 'TotalProcessingTime', displayName: 'Total Time', visible: false },
            { field: 'LastProcessingTime', displayName: 'Last Time', visible: false },
            { field: 'LastExchangeCompletedTimestamp', displayName: 'Last completed', visible: false },
            { field: 'LastExchangeFailedTimestamp', displayName: 'Last failed', visible: false },
            { field: 'Redeliveries', displayName: 'Redelivery #', visible: false },
            { field: 'ExternalRedeliveries', displayName: 'External Redelivery #', visible: false }
        ];
        attributes[Camel.jmxDomain + "/components/folder"] = [
            stateColumn,
            { field: 'CamelId', displayName: 'Context' },
            { field: 'ComponentName', displayName: 'Name' }
        ];
        attributes[Camel.jmxDomain + "/consumers/folder"] = [
            stateColumn,
            { field: 'CamelId', displayName: 'Context' },
            { field: 'RouteId', displayName: 'Route' },
            { field: 'EndpointUri', displayName: 'Endpoint URI', width: "**" },
            { field: 'Suspended', displayName: 'Suspended', resizable: false },
            { field: 'InflightExchanges', displayName: 'Inflight #' }
        ];
        attributes[Camel.jmxDomain + "/services/folder"] = [
            stateColumn,
            { field: 'CamelId', displayName: 'Context' },
            { field: 'RouteId', displayName: 'Route' },
            { field: 'Suspended', displayName: 'Suspended', resizable: false },
            { field: 'SupportsSuspended', displayName: 'Can Suspend', resizable: false }
        ];
        attributes[Camel.jmxDomain + "/endpoints/folder"] = [
            stateColumn,
            { field: 'CamelId', displayName: 'Context' },
            { field: 'EndpointUri', displayName: 'Endpoint URI', width: "***" },
            { field: 'Singleton', displayName: 'Singleton', resizable: false }
        ];
        attributes[Camel.jmxDomain + "/threadpools/folder"] = [
            { field: 'Id', displayName: 'Id', width: "**" },
            { field: 'ActiveCount', displayName: 'Active #' },
            { field: 'PoolSize', displayName: 'Pool Size' },
            { field: 'CorePoolSize', displayName: 'Core Pool Size' },
            { field: 'TaskQueueSize', displayName: 'Task Queue Size' },
            { field: 'TaskCount', displayName: 'Task #' },
            { field: 'CompletedTaskCount', displayName: 'Completed Task #' }
        ];
        attributes[Camel.jmxDomain + "/errorhandlers/folder"] = [
            { field: 'CamelId', displayName: 'Context' },
            { field: 'DeadLetterChannel', displayName: 'Dead Letter' },
            { field: 'DeadLetterChannelEndpointUri', displayName: 'Endpoint URI', width: "**", resizable: true },
            { field: 'MaximumRedeliveries', displayName: 'Max Redeliveries' },
            { field: 'RedeliveryDelay', displayName: 'Redelivery Delay' },
            { field: 'MaximumRedeliveryDelay', displayName: 'Max Redeliveries Delay' }
        ];
        workspace.topLevelTabs.push({
            id: "camel",
            content: "Camel",
            title: "Manage your Apache Camel applications",
            isValid: function (workspace) { return workspace.treeContainsDomainAndProperties(Camel.jmxDomain); },
            href: function () { return "#/jmx/attributes?tab=camel"; },
            isActive: function (workspace) { return workspace.isTopTabActive("camel"); }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-picture"></i> Route Diagram',
            title: "View a diagram of the Camel routes",
            isValid: function (workspace) { return workspace.isRoute() && workspace.hasInvokeRightsForName(Camel.getSelectionCamelContextMBean(workspace), "dumpRoutesAsXml"); },
            href: function () { return "#/camel/routes"; },
            index: -2
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-bar-chart"></i> Route Metrics',
            title: "View the entire JVMs Camel route metrics",
            isValid: function (workspace) { return !workspace.isEndpointsFolder() && (workspace.isRoute() || workspace.isRoutesFolder() || workspace.isCamelContext()) && Camel.isCamelVersionEQGT(2, 14, workspace, jolokia) && workspace.hasInvokeRightsForName(Camel.getSelectionCamelRouteMetrics(workspace), "dumpStatisticsAsJson"); },
            href: function () { return "#/camel/routeMetrics"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class=" icon-file-alt"></i> Source',
            title: "View the source of the Camel routes",
            isValid: function (workspace) { return !workspace.isEndpointsFolder() && (workspace.isRoute() || workspace.isRoutesFolder() || workspace.isCamelContext()) && workspace.hasInvokeRightsForName(Camel.getSelectionCamelContextMBean(workspace), "dumpRoutesAsXml"); },
            href: function () { return "#/camel/source"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class=" icon-edit"></i> Properties',
            title: "View the pattern properties",
            isValid: function (workspace) { return Camel.getSelectedRouteNode(workspace); },
            href: function () { return "#/camel/properties"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-list"></i> Type Converters',
            title: "List all the type converters registered in the context",
            isValid: function (workspace) { return workspace.isTopTabActive("camel") && !workspace.isEndpointsFolder() && !workspace.isRoute() && Camel.isCamelVersionEQGT(2, 13, workspace, jolokia) && workspace.hasInvokeRightsForName(Camel.getSelectionCamelTypeConverter(workspace), "listTypeConverters"); },
            href: function () { return "#/camel/typeConverter"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-list"></i> Rest Services',
            title: "List all the REST services registered in the context",
            isValid: function (workspace) { return workspace.isTopTabActive("camel") && !workspace.isEndpointsFolder() && !workspace.isRoute() && Camel.isCamelVersionEQGT(2, 14, workspace, jolokia) && workspace.hasInvokeRightsForName(Camel.getSelectionCamelRestRegistry(workspace), "listRestServices"); },
            href: function () { return "#/camel/restRegistry"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-envelope"></i> Browse',
            title: "Browse the messages on the endpoint",
            isValid: function (workspace) { return workspace.isEndpoint() && workspace.hasInvokeRights(workspace.selection, "browseAllMessagesAsXml"); },
            href: function () { return "#/camel/browseEndpoint"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-stethoscope"></i> Debug',
            title: "Debug the Camel route",
            isValid: function (workspace) { return workspace.isRoute() && Camel.getSelectionCamelDebugMBean(workspace) && workspace.hasInvokeRightsForName(Camel.getSelectionCamelDebugMBean(workspace), "getBreakpoints"); },
            href: function () { return "#/camel/debugRoute"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-envelope"></i> Trace',
            title: "Trace the messages flowing through the Camel route",
            isValid: function (workspace) { return workspace.isRoute() && Camel.getSelectionCamelTraceMBean(workspace) && workspace.hasInvokeRightsForName(Camel.getSelectionCamelTraceMBean(workspace), "dumpAllTracedMessagesAsXml"); },
            href: function () { return "#/camel/traceRoute"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-bar-chart"></i> Profile',
            title: "Profile the messages flowing through the Camel route",
            isValid: function (workspace) { return workspace.isRoute() && Camel.getSelectionCamelTraceMBean(workspace) && workspace.hasInvokeRightsForName(Camel.getSelectionCamelTraceMBean(workspace), "dumpAllTracedMessagesAsXml"); },
            href: function () { return "#/camel/profileRoute"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-pencil"></i> Send',
            title: "Send a message to this endpoint",
            isValid: function (workspace) { return workspace.isEndpoint() && workspace.hasInvokeRights(workspace.selection, workspace.selection.domain === "org.apache.camel" ? "sendBodyAndHeaders" : "sendTextMessage"); },
            href: function () { return "#/camel/sendMessage"; }
        });
        workspace.subLevelTabs.push({
            content: '<i class="icon-plus"></i> Endpoint',
            title: "Create a new endpoint",
            isValid: function (workspace) { return workspace.isEndpointsFolder() && workspace.hasInvokeRights(workspace.selection, "createEndpoint"); },
            href: function () { return "#/camel/createEndpoint"; }
        });
    }]);
    hawtioPluginLoader.addModule(Camel.pluginName);
    hawtioPluginLoader.registerPreBootstrapTask(function (task) {
        jmxModule.registerLazyLoadHandler(Camel.jmxDomain, function (folder) {
            if (Camel.jmxDomain === folder.domain && "routes" === folder.typeName) {
                return function (workspace, folder, onComplete) {
                    if ("routes" === folder.typeName) {
                        Camel.processRouteXml(workspace, workspace.jolokia, folder, function (route) {
                            if (route) {
                                Camel.addRouteChildren(folder, route);
                            }
                            onComplete();
                        });
                    }
                    else {
                        onComplete();
                    }
                };
            }
            return null;
        });
        task();
    });
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.AttributesToolBarController", ["$scope", "workspace", "jolokia", function ($scope, workspace, jolokia) {
        $scope.deleteDialog = false;
        $scope.start = function () {
            $scope.invokeSelectedMBeans(function (item) {
                return Camel.isState(item, "suspend") ? "resume()" : "start()";
            });
        };
        $scope.pause = function () {
            $scope.invokeSelectedMBeans("suspend()");
        };
        $scope.stop = function () {
            $scope.invokeSelectedMBeans("stop()", function () {
                workspace.removeAndSelectParentNode();
            });
        };
        $scope.delete = function () {
            $scope.invokeSelectedMBeans("remove()", function () {
                $scope.workspace.operationCounter += 1;
                Core.$apply($scope);
            });
        };
        $scope.anySelectionHasState = function (state) {
            var selected = $scope.selectedItems || [];
            return selected.length && selected.any(function (s) { return Camel.isState(s, state); });
        };
        $scope.everySelectionHasState = function (state) {
            var selected = $scope.selectedItems || [];
            return selected.length && selected.every(function (s) { return Camel.isState(s, state); });
        };
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.BreadcrumbBarController", ["$scope", "$routeParams", "workspace", "jolokia", function ($scope, $routeParams, workspace, jolokia) {
        $scope.workspace = workspace;
        if ($routeParams != null) {
            $scope.contextId = $routeParams["contextId"];
            $scope.endpointPath = $routeParams["endpointPath"];
            $scope.endpointName = tidyJmxName($scope.endpointPath);
            $scope.routeId = $routeParams["routeId"];
        }
        $scope.treeViewLink = linkToTreeView();
        var defaultChildEntity = $scope.endpointPath ? "endpoints" : "routes";
        var childEntityToolTips = {
            "endpoints": "Camel Endpoint",
            "routes": "Camel Route"
        };
        $scope.breadcrumbs = [
            {
                name: $scope.contextId,
                items: findContexts(),
                tooltip: "Camel Context"
            },
            {
                name: defaultChildEntity,
                items: findChildEntityTypes($scope.contextId),
                tooltip: "Entity inside a Camel Context"
            },
            {
                name: $scope.endpointName || tidyJmxName($scope.routeId),
                items: findChildEntityLinks($scope.contextId, currentChildEntity()),
                tooltip: childEntityToolTips[defaultChildEntity]
            }
        ];
        function findContexts() {
            var answer = [];
            var rootFolder = Camel.getRootCamelFolder(workspace);
            if (rootFolder) {
                angular.forEach(rootFolder.children, function (contextFolder) {
                    var id = contextFolder.title;
                    if (id && id !== $scope.contextId) {
                        var name = id;
                        var link = createLinkToFirstChildEntity(id, currentChildEntity());
                        answer.push({
                            name: name,
                            tooltip: "Camel Context",
                            link: link
                        });
                    }
                });
            }
            return answer;
        }
        function findChildEntityTypes(contextId) {
            var answer = [];
            angular.forEach(["endpoints", "routes"], function (childEntityName) {
                if (childEntityName && childEntityName !== currentChildEntity()) {
                    var link = createLinkToFirstChildEntity(contextId, childEntityName);
                    answer.push({
                        name: childEntityName,
                        tooltip: "Entity inside a Camel Context",
                        link: link
                    });
                }
            });
            return answer;
        }
        function currentChildEntity() {
            var answer = Core.pathGet($scope, ["breadcrumbs", "childEntity"]);
            return answer || defaultChildEntity;
        }
        function createLinkToFirstChildEntity(id, childEntityValue) {
            var links = findChildEntityLinks(id, childEntityValue);
            var link = links.length > 0 ? links[0].link : Camel.linkToBrowseEndpointFullScreen(id, "noEndpoints");
            return link;
        }
        function findChildEntityLinks(contextId, childEntityValue) {
            if ("endpoints" === childEntityValue) {
                return findEndpoints(contextId);
            }
            else {
                return findRoutes(contextId);
            }
        }
        function findEndpoints(contextId) {
            var answer = [];
            var contextFolder = Camel.getCamelContextFolder(workspace, contextId);
            if (contextFolder) {
                var endpoints = (contextFolder["children"] || []).find(function (n) { return "endpoints" === n.title; });
                if (endpoints) {
                    angular.forEach(endpoints.children, function (endpointFolder) {
                        var entries = endpointFolder ? endpointFolder.entries : null;
                        if (entries) {
                            var endpointPath = entries["name"];
                            if (endpointPath) {
                                var name = tidyJmxName(endpointPath);
                                var link = Camel.linkToBrowseEndpointFullScreen(contextId, endpointPath);
                                answer.push({
                                    contextId: contextId,
                                    path: endpointPath,
                                    name: name,
                                    tooltip: "Endpoint",
                                    link: link
                                });
                            }
                        }
                    });
                }
            }
            return answer;
        }
        function findRoutes(contextId) {
            var answer = [];
            var contextFolder = Camel.getCamelContextFolder(workspace, contextId);
            if (contextFolder) {
                var folders = (contextFolder["children"] || []).find(function (n) { return "routes" === n.title; });
                if (folders) {
                    angular.forEach(folders.children, function (folder) {
                        var entries = folder ? folder.entries : null;
                        if (entries) {
                            var routeId = entries["name"];
                            if (routeId) {
                                var name = tidyJmxName(routeId);
                                var link = Camel.linkToRouteDiagramFullScreen(contextId, routeId);
                                answer.push({
                                    contextId: contextId,
                                    path: routeId,
                                    name: name,
                                    tooltip: "Camel Route",
                                    link: link
                                });
                            }
                        }
                    });
                }
            }
            return answer;
        }
        function linkToTreeView() {
            var answer = null;
            if ($scope.contextId) {
                var node = null;
                var tab = null;
                if ($scope.endpointPath) {
                    tab = "browseEndpoint";
                    node = workspace.findMBeanWithProperties(Camel.jmxDomain, {
                        context: $scope.contextId,
                        type: "endpoints",
                        name: $scope.endpointPath
                    });
                }
                else if ($scope.routeId) {
                    tab = "routes";
                    node = workspace.findMBeanWithProperties(Camel.jmxDomain, {
                        context: $scope.contextId,
                        type: "routes",
                        name: $scope.routeId
                    });
                }
                var key = node ? node["key"] : null;
                if (key && tab) {
                    answer = "#/camel/" + tab + "?tab=camel&nid=" + key;
                }
            }
            return answer;
        }
        function tidyJmxName(jmxName) {
            return jmxName ? Core.trimQuotes(jmxName) : jmxName;
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.BrowseEndpointController = Camel._module.controller("Camel.BrowseEndpointController", ["$scope", "$routeParams", "workspace", "jolokia", function ($scope, $routeParams, workspace, jolokia) {
        $scope.workspace = workspace;
        $scope.forwardDialog = new UI.Dialog();
        $scope.showMessageDetails = false;
        $scope.mode = 'text';
        $scope.gridOptions = Camel.createBrowseGridOptions();
        $scope.contextId = $routeParams["contextId"];
        $scope.endpointPath = $routeParams["endpointPath"];
        $scope.isJmxTab = !$routeParams["contextId"] || !$routeParams["endpointPath"];
        $scope.$watch('workspace.selection', function () {
            if ($scope.isJmxTab && workspace.moveIfViewInvalid())
                return;
            loadData();
        });
        $scope.openMessageDialog = function (message) {
            ActiveMQ.selectCurrentMessage(message, "id", $scope);
            if ($scope.row) {
                $scope.mode = CodeEditor.detectTextFormat($scope.row.body);
                $scope.showMessageDetails = true;
            }
        };
        ActiveMQ.decorate($scope);
        $scope.forwardMessagesAndCloseForwardDialog = function () {
            var mbean = Camel.getSelectionCamelContextMBean(workspace);
            var selectedItems = $scope.gridOptions.selectedItems;
            var uri = $scope.endpointUri;
            if (mbean && uri && selectedItems && selectedItems.length) {
                jolokia.execute(mbean, "createEndpoint(java.lang.String)", uri, onSuccess(intermediateResult));
                $scope.message = "Forwarded " + Core.maybePlural(selectedItems.length, "message" + " to " + uri);
                angular.forEach(selectedItems, function (item, idx) {
                    var callback = (idx + 1 < selectedItems.length) ? intermediateResult : operationSuccess;
                    var body = item.body;
                    var headers = item.headers;
                    jolokia.execute(mbean, "sendBodyAndHeaders(java.lang.String, java.lang.Object, java.util.Map)", uri, body, headers, onSuccess(callback));
                });
            }
            $scope.forwardDialog.close();
        };
        $scope.endpointUris = function () {
            var endpointFolder = Camel.getSelectionCamelContextEndpoints(workspace);
            return (endpointFolder) ? endpointFolder.children.map(function (n) { return n.title; }) : [];
        };
        $scope.refresh = loadData;
        function intermediateResult() {
        }
        function operationSuccess() {
            if ($scope.messageDialog) {
                $scope.messageDialog.close();
            }
            $scope.gridOptions.selectedItems.splice(0);
            Core.notification("success", $scope.message);
            setTimeout(loadData, 50);
        }
        function loadData() {
            var mbean = null;
            if ($scope.contextId && $scope.endpointPath) {
                var node = workspace.findMBeanWithProperties(Camel.jmxDomain, {
                    context: $scope.contextId,
                    type: "endpoints",
                    name: $scope.endpointPath
                });
                if (node) {
                    mbean = node.objectName;
                }
            }
            if (!mbean) {
                mbean = workspace.getSelectedMBeanName();
            }
            if (mbean) {
                Camel.log.info("MBean: " + mbean);
                var options = onSuccess(populateTable);
                jolokia.execute(mbean, 'browseAllMessagesAsXml(java.lang.Boolean)', true, options);
            }
        }
        function populateTable(response) {
            var data = [];
            if (angular.isString(response)) {
                var doc = $.parseXML(response);
                var allMessages = $(doc).find("message");
                allMessages.each(function (idx, message) {
                    var messageData = Camel.createMessageFromXml(message);
                    data.push(messageData);
                });
            }
            $scope.messages = data;
            Core.$apply($scope);
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.camelHeaderSchema = {
        definitions: {
            headers: {
                properties: {
                    "CamelAuthentication": {
                        type: "java.lang.String"
                    },
                    "CamelAuthenticationFailurePolicyId": {
                        type: "java.lang.String"
                    },
                    "CamelAcceptContentType": {
                        type: "java.lang.String"
                    },
                    "CamelAggregatedSize": {
                        type: "java.lang.String"
                    },
                    "CamelAggregatedTimeout": {
                        type: "java.lang.String"
                    },
                    "CamelAggregatedCompletedBy": {
                        type: "java.lang.String"
                    },
                    "CamelAggregatedCorrelationKey": {
                        type: "java.lang.String"
                    },
                    "CamelAggregationStrategy": {
                        type: "java.lang.String"
                    },
                    "CamelAggregationCompleteAllGroups": {
                        type: "java.lang.String"
                    },
                    "CamelAggregationCompleteAllGroupsInclusive": {
                        type: "java.lang.String"
                    },
                    "CamelAsyncWait": {
                        type: "java.lang.String"
                    },
                    "CamelBatchIndex": {
                        type: "java.lang.String"
                    },
                    "CamelBatchSize": {
                        type: "java.lang.String"
                    },
                    "CamelBatchComplete": {
                        type: "java.lang.String"
                    },
                    "CamelBeanMethodName": {
                        type: "java.lang.String"
                    },
                    "CamelBeanMultiParameterArray": {
                        type: "java.lang.String"
                    },
                    "CamelBinding": {
                        type: "java.lang.String"
                    },
                    "breadcrumbId": {
                        type: "java.lang.String"
                    },
                    "CamelCharsetName": {
                        type: "java.lang.String"
                    },
                    "CamelCreatedTimestamp": {
                        type: "java.lang.String"
                    },
                    "Content-Encoding": {
                        type: "java.lang.String"
                    },
                    "Content-Length": {
                        type: "java.lang.String"
                    },
                    "Content-Type": {
                        type: "java.lang.String"
                    },
                    "CamelCorrelationId": {
                        type: "java.lang.String"
                    },
                    "CamelDataSetIndex": {
                        type: "java.lang.String"
                    },
                    "org.apache.camel.default.charset": {
                        type: "java.lang.String"
                    },
                    "CamelDestinationOverrideUrl": {
                        type: "java.lang.String"
                    },
                    "CamelDisableHttpStreamCache": {
                        type: "java.lang.String"
                    },
                    "CamelDuplicateMessage": {
                        type: "java.lang.String"
                    },
                    "CamelExceptionCaught": {
                        type: "java.lang.String"
                    },
                    "CamelExceptionHandled": {
                        type: "java.lang.String"
                    },
                    "CamelEvaluateExpressionResult": {
                        type: "java.lang.String"
                    },
                    "CamelErrorHandlerHandled": {
                        type: "java.lang.String"
                    },
                    "CamelExternalRedelivered": {
                        type: "java.lang.String"
                    },
                    "CamelFailureHandled": {
                        type: "java.lang.String"
                    },
                    "CamelFailureEndpoint": {
                        type: "java.lang.String"
                    },
                    "CamelFailureRouteId": {
                        type: "java.lang.String"
                    },
                    "CamelFilterNonXmlChars": {
                        type: "java.lang.String"
                    },
                    "CamelFileLocalWorkPath": {
                        type: "java.lang.String"
                    },
                    "CamelFileName": {
                        type: "java.lang.String"
                    },
                    "CamelFileNameOnly": {
                        type: "java.lang.String"
                    },
                    "CamelFileNameProduced": {
                        type: "java.lang.String"
                    },
                    "CamelFileNameConsumed": {
                        type: "java.lang.String"
                    },
                    "CamelFilePath": {
                        type: "java.lang.String"
                    },
                    "CamelFileParent": {
                        type: "java.lang.String"
                    },
                    "CamelFileLastModified": {
                        type: "java.lang.String"
                    },
                    "CamelFileLength": {
                        type: "java.lang.String"
                    },
                    "CamelFilterMatched": {
                        type: "java.lang.String"
                    },
                    "CamelFileLockFileAcquired": {
                        type: "java.lang.String"
                    },
                    "CamelFileLockFileName": {
                        type: "java.lang.String"
                    },
                    "CamelGroupedExchange": {
                        type: "java.lang.String"
                    },
                    "CamelHttpBaseUri": {
                        type: "java.lang.String"
                    },
                    "CamelHttpCharacterEncoding": {
                        type: "java.lang.String"
                    },
                    "CamelHttpMethod": {
                        type: "java.lang.String"
                    },
                    "CamelHttpPath": {
                        type: "java.lang.String"
                    },
                    "CamelHttpProtocolVersion": {
                        type: "java.lang.String"
                    },
                    "CamelHttpQuery": {
                        type: "java.lang.String"
                    },
                    "CamelHttpResponseCode": {
                        type: "java.lang.String"
                    },
                    "CamelHttpUri": {
                        type: "java.lang.String"
                    },
                    "CamelHttpUrl": {
                        type: "java.lang.String"
                    },
                    "CamelHttpChunked": {
                        type: "java.lang.String"
                    },
                    "CamelHttpServletRequest": {
                        type: "java.lang.String"
                    },
                    "CamelHttpServletResponse": {
                        type: "java.lang.String"
                    },
                    "CamelInterceptedEndpoint": {
                        type: "java.lang.String"
                    },
                    "CamelInterceptSendToEndpointWhenMatched": {
                        type: "java.lang.String"
                    },
                    "CamelLanguageScript": {
                        type: "java.lang.String"
                    },
                    "CamelLogDebugBodyMaxChars": {
                        type: "java.lang.String"
                    },
                    "CamelLogDebugStreams": {
                        type: "java.lang.String"
                    },
                    "CamelLoopIndex": {
                        type: "java.lang.String"
                    },
                    "CamelLoopSize": {
                        type: "java.lang.String"
                    },
                    "CamelMaximumCachePoolSize": {
                        type: "java.lang.String"
                    },
                    "CamelMaximumEndpointCacheSize": {
                        type: "java.lang.String"
                    },
                    "CamelMessageHistory": {
                        type: "java.lang.String"
                    },
                    "CamelMulticastIndex": {
                        type: "java.lang.String"
                    },
                    "CamelMulticastComplete": {
                        type: "java.lang.String"
                    },
                    "CamelNotifyEvent": {
                        type: "java.lang.String"
                    },
                    "CamelOnCompletion": {
                        type: "java.lang.String"
                    },
                    "CamelOverruleFileName": {
                        type: "java.lang.String"
                    },
                    "CamelParentUnitOfWork": {
                        type: "java.lang.String"
                    },
                    "CamelRecipientListEndpoint": {
                        type: "java.lang.String"
                    },
                    "CamelReceivedTimestamp": {
                        type: "java.lang.String"
                    },
                    "CamelRedelivered": {
                        type: "java.lang.String"
                    },
                    "CamelRedeliveryCounter": {
                        type: "java.lang.String"
                    },
                    "CamelRedeliveryMaxCounter": {
                        type: "java.lang.String"
                    },
                    "CamelRedeliveryExhausted": {
                        type: "java.lang.String"
                    },
                    "CamelRedeliveryDelay": {
                        type: "java.lang.String"
                    },
                    "CamelRollbackOnly": {
                        type: "java.lang.String"
                    },
                    "CamelRollbackOnlyLast": {
                        type: "java.lang.String"
                    },
                    "CamelRouteStop": {
                        type: "java.lang.String"
                    },
                    "CamelSoapAction": {
                        type: "java.lang.String"
                    },
                    "CamelSkipGzipEncoding": {
                        type: "java.lang.String"
                    },
                    "CamelSlipEndpoint": {
                        type: "java.lang.String"
                    },
                    "CamelSplitIndex": {
                        type: "java.lang.String"
                    },
                    "CamelSplitComplete": {
                        type: "java.lang.String"
                    },
                    "CamelSplitSize": {
                        type: "java.lang.String"
                    },
                    "CamelTimerCounter": {
                        type: "java.lang.String"
                    },
                    "CamelTimerFiredTime": {
                        type: "java.lang.String"
                    },
                    "CamelTimerName": {
                        type: "java.lang.String"
                    },
                    "CamelTimerPeriod": {
                        type: "java.lang.String"
                    },
                    "CamelTimerTime": {
                        type: "java.lang.String"
                    },
                    "CamelToEndpoint": {
                        type: "java.lang.String"
                    },
                    "CamelTraceEvent": {
                        type: "java.lang.String"
                    },
                    "CamelTraceEventNodeId": {
                        type: "java.lang.String"
                    },
                    "CamelTraceEventTimestamp": {
                        type: "java.lang.String"
                    },
                    "CamelTraceEventExchange": {
                        type: "java.lang.String"
                    },
                    "Transfer-Encoding": {
                        type: "java.lang.String"
                    },
                    "CamelUnitOfWorkExhausted": {
                        type: "java.lang.String"
                    },
                    "CamelUnitOfWorkProcessSync": {
                        type: "java.lang.String"
                    },
                    "CamelXsltFileName": {
                        type: "java.lang.String"
                    }
                }
            }
        }
    };
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.DebugRouteController", ["$scope", "$element", "workspace", "jolokia", function ($scope, $element, workspace, jolokia) {
        $scope.camelMaximumTraceOrDebugBodyLength = Camel.maximumTraceOrDebugBodyLength(localStorage);
        $scope.ignoreRouteXmlNode = true;
        $scope.startDebugging = function () {
            setDebugging(true);
        };
        $scope.stopDebugging = function () {
            setDebugging(false);
        };
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            setTimeout(reloadData, 50);
        });
        $scope.$on("camel.diagram.selectedNodeId", function (event, value) {
            $scope.selectedDiagramNodeId = value;
            updateBreakpointFlag();
        });
        $scope.$on("camel.diagram.layoutComplete", function (event, value) {
            updateBreakpointIcons();
            $($element).find("g.node").dblclick(function (n) {
                var id = this.getAttribute("data-cid");
                $scope.toggleBreakpoint(id);
            });
        });
        $scope.$watch('workspace.selection', function () {
            if (workspace.moveIfViewInvalid())
                return;
            reloadData();
        });
        $scope.toggleBreakpoint = function (id) {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean && id) {
                var method = isBreakpointSet(id) ? "removeBreakpoint" : "addBreakpoint";
                jolokia.execute(mbean, method, id, onSuccess(breakpointsChanged));
            }
        };
        $scope.addBreakpoint = function () {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean && $scope.selectedDiagramNodeId) {
                jolokia.execute(mbean, "addBreakpoint", $scope.selectedDiagramNodeId, onSuccess(breakpointsChanged));
            }
        };
        $scope.removeBreakpoint = function () {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean && $scope.selectedDiagramNodeId) {
                jolokia.execute(mbean, "removeBreakpoint", $scope.selectedDiagramNodeId, onSuccess(breakpointsChanged));
            }
        };
        $scope.resume = function () {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean) {
                jolokia.execute(mbean, "resumeAll", onSuccess(clearStoppedAndResume));
            }
        };
        $scope.suspend = function () {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean) {
                jolokia.execute(mbean, "suspendAll", onSuccess(clearStoppedAndResume));
            }
        };
        $scope.step = function () {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            var stepNode = getStoppedBreakpointId();
            if (mbean && stepNode) {
                jolokia.execute(mbean, "stepBreakpoint(java.lang.String)", stepNode, onSuccess(clearStoppedAndResume));
            }
        };
        $scope.messages = [];
        $scope.mode = 'text';
        $scope.messageDialog = new UI.Dialog();
        $scope.gridOptions = Camel.createBrowseGridOptions();
        $scope.gridOptions.selectWithCheckboxOnly = false;
        $scope.gridOptions.showSelectionCheckbox = false;
        $scope.gridOptions.multiSelect = false;
        $scope.gridOptions.afterSelectionChange = onSelectionChanged;
        $scope.gridOptions.columnDefs.push({
            field: 'toNode',
            displayName: 'To Node'
        });
        $scope.openMessageDialog = function (message) {
            var idx = Core.pathGet(message, ["rowIndex"]);
            $scope.selectRowIndex(idx);
            if ($scope.row) {
                var body = $scope.row.body;
                $scope.mode = angular.isString(body) ? CodeEditor.detectTextFormat(body) : "text";
                $scope.messageDialog.open();
            }
        };
        $scope.selectRowIndex = function (idx) {
            $scope.rowIndex = idx;
            var selected = $scope.gridOptions.selectedItems;
            selected.splice(0, selected.length);
            if (idx >= 0 && idx < $scope.messages.length) {
                $scope.row = $scope.messages[idx];
                if ($scope.row) {
                    selected.push($scope.row);
                }
            }
            else {
                $scope.row = null;
            }
            onSelectionChanged();
        };
        function onSelectionChanged() {
            var toNode = getStoppedBreakpointId();
            if (toNode) {
                var nodes = getDiagramNodes();
                Camel.highlightSelectedNode(nodes, toNode);
            }
        }
        function reloadData() {
            $scope.debugging = false;
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean) {
                $scope.debugging = jolokia.getAttribute(mbean, "Enabled", onSuccess(null));
                if ($scope.debugging) {
                    jolokia.execute(mbean, "getBreakpoints", onSuccess(onBreakpoints));
                    $scope.graphView = "app/camel/html/routes.html";
                    $scope.tableView = "app/camel/html/browseMessages.html";
                    Core.register(jolokia, $scope, {
                        type: 'exec',
                        mbean: mbean,
                        operation: 'getDebugCounter'
                    }, onSuccess(onBreakpointCounter));
                }
                else {
                    $scope.graphView = null;
                    $scope.tableView = null;
                }
            }
        }
        function onBreakpointCounter(response) {
            var counter = response.value;
            if (counter && counter !== $scope.breakpointCounter) {
                $scope.breakpointCounter = counter;
                loadCurrentStack();
            }
        }
        function loadCurrentStack() {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean) {
                console.log("getting suspended breakpoints!");
                jolokia.execute(mbean, "getSuspendedBreakpointNodeIds", onSuccess(onSuspendedBreakpointNodeIds));
            }
        }
        function onSuspendedBreakpointNodeIds(response) {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            $scope.suspendedBreakpoints = response;
            $scope.stopped = response && response.length;
            var stopNodeId = getStoppedBreakpointId();
            if (mbean && stopNodeId) {
                jolokia.execute(mbean, 'dumpTracedMessagesAsXml', stopNodeId, onSuccess(onMessages));
                $scope.selectedDiagramNodeId = stopNodeId;
            }
            updateBreakpointIcons();
            Core.$apply($scope);
        }
        function onMessages(response) {
            console.log("onMessage! ");
            $scope.messages = [];
            if (response) {
                var xml = response;
                if (angular.isString(xml)) {
                    var doc = $.parseXML(xml);
                    var allMessages = $(doc).find("fabricTracerEventMessage");
                    if (!allMessages || !allMessages.length) {
                        allMessages = $(doc).find("backlogTracerEventMessage");
                    }
                    allMessages.each(function (idx, message) {
                        var messageData = Camel.createMessageFromXml(message);
                        var toNode = $(message).find("toNode").text();
                        if (toNode) {
                            messageData["toNode"] = toNode;
                        }
                        $scope.messages.push(messageData);
                    });
                }
            }
            else {
                console.log("WARNING: dumpTracedMessagesAsXml() returned no results!");
            }
            updateMessageSelection();
            console.log("has messages " + $scope.messages.length + " selected row " + $scope.row + " index " + $scope.rowIndex);
            Core.$apply($scope);
            updateBreakpointIcons();
        }
        function updateMessageSelection() {
            $scope.selectRowIndex($scope.rowIndex);
            if (!$scope.row && $scope.messageDialog.show) {
                $scope.row = {
                    headers: {},
                    body: ""
                };
            }
        }
        function clearStoppedAndResume() {
            $scope.messages = [];
            $scope.suspendedBreakpoints = [];
            $scope.stopped = false;
            updateMessageSelection();
            Core.$apply($scope);
            updateBreakpointIcons();
        }
        function getStoppedBreakpointId() {
            var stepNode = null;
            var stepNodes = $scope.suspendedBreakpoints;
            if (stepNodes && stepNodes.length) {
                stepNode = stepNodes[0];
                if (stepNodes.length > 1 && isSuspendedAt($scope.selectedDiagramNodeId)) {
                    stepNode = $scope.selectedDiagramNodeId;
                }
            }
            return stepNode;
        }
        function isSuspendedAt(nodeId) {
            return containsNodeId($scope.suspendedBreakpoints, nodeId);
        }
        function onBreakpoints(response) {
            $scope.breakpoints = response;
            updateBreakpointFlag();
            var nodes = getDiagramNodes();
            if (nodes.length) {
                updateBreakpointIcons(nodes);
            }
            Core.$apply($scope);
        }
        function isBreakpointSet(nodeId) {
            return containsNodeId($scope.breakpoints, nodeId);
        }
        function updateBreakpointFlag() {
            $scope.hasBreakpoint = isBreakpointSet($scope.selectedDiagramNodeId);
        }
        function containsNodeId(breakpoints, nodeId) {
            return nodeId && breakpoints && breakpoints.some(nodeId);
        }
        function getDiagramNodes() {
            var svg = d3.select("svg");
            return svg.selectAll("g .node");
        }
        var breakpointImage = Core.url("/app/camel/doc/img/debug/breakpoint.gif");
        var suspendedBreakpointImage = Core.url("/app/camel/doc/img/debug/breakpoint-suspended.gif");
        function updateBreakpointIcons(nodes) {
            if (nodes === void 0) { nodes = getDiagramNodes(); }
            nodes.each(function (object) {
                var nodeId = object.cid;
                var thisNode = d3.select(this);
                var icons = thisNode.selectAll("image.breakpoint");
                var isSuspended = isSuspendedAt(nodeId);
                var isBreakpoint = isBreakpointSet(nodeId);
                if (isBreakpoint || isSuspended) {
                    var imageUrl = isSuspended ? suspendedBreakpointImage : breakpointImage;
                    if (!icons.length || !icons[0].length) {
                        thisNode.append("image").attr("xlink:href", function (d) {
                            return imageUrl;
                        }).attr("class", "breakpoint").attr("x", -12).attr("y", -20).attr("height", 24).attr("width", 24);
                    }
                    else {
                        icons.attr("xlink:href", function (d) {
                            return imageUrl;
                        });
                    }
                }
                else {
                    icons.remove();
                }
            });
        }
        function breakpointsChanged(response) {
            reloadData();
            Core.$apply($scope);
        }
        function setDebugging(flag) {
            var mbean = Camel.getSelectionCamelDebugMBean(workspace);
            if (mbean) {
                var method = flag ? "enableDebugger" : "disableDebugger";
                var max = $scope.camelMaximumTraceOrDebugBodyLength;
                jolokia.setAttribute(mbean, "BodyMaxChars", max);
                jolokia.execute(mbean, method, onSuccess(breakpointsChanged));
            }
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.EndpointController", ["$scope", "$location", "localStorage", "workspace", "jolokia", function ($scope, $location, localStorage, workspace, jolokia) {
        Camel.initEndpointChooserScope($scope, $location, localStorage, workspace, jolokia);
        $scope.workspace = workspace;
        $scope.message = "";
        $scope.createEndpoint = function (name) {
            var jolokia = workspace.jolokia;
            if (jolokia) {
                var mbean = Camel.getSelectionCamelContextMBean(workspace);
                if (mbean) {
                    $scope.message = "Creating endpoint " + name;
                    var operation = "createEndpoint(java.lang.String)";
                    jolokia.execute(mbean, operation, name, onSuccess(operationSuccess));
                }
                else {
                    Core.notification("error", "Could not find the CamelContext MBean!");
                }
            }
        };
        $scope.createEndpointFromData = function () {
            if ($scope.selectedComponentName && $scope.endpointPath) {
                var name = $scope.selectedComponentName + "://" + $scope.endpointPath;
                console.log("Have endpoint data " + JSON.stringify($scope.endpointParameters));
                var params = "";
                angular.forEach($scope.endpointParameters, function (value, key) {
                    var prefix = params ? "&" : "";
                    params += prefix + key + "=" + value;
                });
                if (params) {
                    name += "?" + params;
                }
                $scope.createEndpoint(name);
            }
        };
        $scope.deleteEndpoint = function () {
            var jolokia = workspace.jolokia;
            var selection = workspace.selection;
            var entries = selection.entries;
            if (selection && jolokia && entries) {
                var domain = selection.domain;
                var brokerName = entries["BrokerName"];
                var name = entries["Destination"];
                var isQueue = "Topic" !== entries["Type"];
                if (domain && brokerName) {
                    var mbean = "" + domain + ":BrokerName=" + brokerName + ",Type=Broker";
                    $scope.message = "Deleting " + (isQueue ? "queue" : "topic") + " " + name;
                    var operation = "removeEndpoint(java.lang.String)";
                    jolokia.execute(mbean, operation, name, onSuccess(deleteSuccess));
                }
            }
        };
        function operationSuccess() {
            $scope.endpointName = "";
            $scope.workspace.operationCounter += 1;
            Core.$apply($scope);
            Core.notification("success", $scope.message);
        }
        function deleteSuccess() {
            if (workspace.selection) {
                var parent = Core.pathGet(workspace, ["selection", "parent"]);
                if (parent) {
                    $scope.workspace.updateSelectionNode(parent);
                }
            }
            $scope.workspace.operationCounter += 1;
            Core.$apply($scope);
            Core.notification("success", $scope.message);
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.endpointCategories = {
        bigdata: {
            label: "Big Data",
            endpoints: ["hdfs", "hbase", "lucene", "solr"],
            endpointIcon: "/img/icons/camel/endpointRepository24.png"
        },
        database: {
            label: "Database",
            endpoints: ["couchdb", "elasticsearch", "hbase", "jdbc", "jpa", "hibernate", "mongodb", "mybatis", "sql"],
            endpointIcon: "/img/icons/camel/endpointRepository24.png"
        },
        cloud: {
            label: "Cloud",
            endpoints: [
                "aws-cw",
                "aws-ddb",
                "aws-sdb",
                "aws-ses",
                "aws-sns",
                "aws-sqs",
                "aws-s3",
                "gauth",
                "ghhtp",
                "glogin",
                "gtask",
                "jclouds"
            ]
        },
        core: {
            label: "Core",
            endpoints: ["bean", "direct", "seda"]
        },
        messaging: {
            label: "Messaging",
            endpoints: ["jms", "activemq", "amqp", "cometd", "cometds", "mqtt", "netty", "vertx", "websocket"],
            endpointIcon: "/img/icons/camel/endpointQueue24.png"
        },
        mobile: {
            label: "Mobile",
            endpoints: ["apns"]
        },
        sass: {
            label: "SaaS",
            endpoints: ["salesforce", "sap-netweaver"]
        },
        social: {
            label: "Social",
            endpoints: ["atom", "facebook", "irc", "ircs", "rss", "smpp", "twitter", "weather"]
        },
        storage: {
            label: "Storage",
            endpointIcon: "/img/icons/camel/endpointFolder24.png",
            endpoints: ["file", "ftp", "sftp", "scp", "jsch"]
        },
        template: {
            label: "Templating",
            endpoints: ["freemarker", "velocity", "xquery", "xslt", "scalate", "string-template"]
        }
    };
    Camel.endpointToCategory = {};
    Camel.endpointIcon = "/img/icons/camel/endpoint24.png";
    Camel.endpointConfigurations = {
        drools: {
            icon: "/img/icons/camel/endpointQueue24.png"
        },
        quartz: {
            icon: "/img/icons/camel/endpointTimer24.png"
        },
        facebook: {
            icon: "/img/icons/camel/endpoints/facebook24.jpg"
        },
        salesforce: {
            icon: "/img/icons/camel/endpoints/salesForce24.png"
        },
        sap: {
            icon: "/img/icons/camel/endpoints/SAPe24.png"
        },
        "sap-netweaver": {
            icon: "/img/icons/camel/endpoints/SAPNetweaver24.jpg"
        },
        timer: {
            icon: "/img/icons/camel/endpointTimer24.png"
        },
        twitter: {
            icon: "/img/icons/camel/endpoints/twitter24.png"
        },
        weather: {
            icon: "/img/icons/camel/endpoints/weather24.jpg"
        }
    };
    Camel.endpointForms = {
        file: {
            tabs: {
                'Options': ['*']
            }
        },
        activemq: {
            tabs: {
                'Connection': ['clientId', 'transacted', 'transactedInOut', 'transactionName', 'transactionTimeout'],
                'Producer': ['timeToLive', 'priority', 'allowNullBody', 'pubSubNoLocal', 'preserveMessageQos'],
                'Consumer': ['concurrentConsumers', 'acknowledgementModeName', 'selector', 'receiveTimeout'],
                'Reply': ['replyToDestination', 'replyToDeliveryPersistent', 'replyToCacheLevelName', 'replyToDestinationSelectorName'],
                'Options': ['*']
            }
        }
    };
    Camel.endpointForms["jms"] = Camel.endpointForms.activemq;
    angular.forEach(Camel.endpointCategories, function (category, catKey) {
        category.id = catKey;
        angular.forEach(category.endpoints, function (endpoint) {
            Camel.endpointToCategory[endpoint] = category;
        });
    });
    var camelModelTabExtensions = {
        route: {
            'Overview': ['id', 'description'],
            'Advanced': ['*']
        }
    };
    function getEndpointIcon(endpointName) {
        var value = Camel.getEndpointConfig(endpointName, null);
        var answer = Core.pathGet(value, ["icon"]);
        if (!answer) {
            var category = getEndpointCategory(endpointName);
            answer = Core.pathGet(category, ["endpointIcon"]);
        }
        return answer || Camel.endpointIcon;
    }
    Camel.getEndpointIcon = getEndpointIcon;
    function getEndpointConfig(endpointName, category) {
        var answer = Camel.endpointConfigurations[endpointName];
        if (!answer) {
            answer = {};
            Camel.endpointConfigurations[endpointName] = answer;
        }
        if (!answer.label) {
            answer.label = endpointName;
        }
        if (!answer.icon) {
            answer.icon = Core.pathGet(category, ["endpointIcon"]) || Camel.endpointIcon;
        }
        if (!answer.category) {
            answer.category = category;
        }
        return answer;
    }
    Camel.getEndpointConfig = getEndpointConfig;
    function getEndpointCategory(endpointName) {
        return Camel.endpointToCategory[endpointName] || Camel.endpointCategories.core;
    }
    Camel.getEndpointCategory = getEndpointCategory;
    function getConfiguredCamelModel() {
        var schema = _apacheCamelModel;
        var definitions = schema["definitions"];
        if (definitions) {
            angular.forEach(camelModelTabExtensions, function (tabs, name) {
                var model = definitions[name];
                if (model) {
                    if (!model["tabs"]) {
                        model["tabs"] = tabs;
                    }
                }
            });
        }
        return schema;
    }
    Camel.getConfiguredCamelModel = getConfiguredCamelModel;
    function initEndpointChooserScope($scope, $location, localStorage, workspace, jolokia) {
        $scope.selectedComponentName = null;
        $scope.endpointParameters = {};
        $scope.endpointPath = "";
        $scope.schema = {
            definitions: {}
        };
        $scope.jolokia = jolokia;
        var versionId = $scope.branch;
        var profileId = Fabric.pagePathToProfileId($scope.pageId);
        if (profileId && versionId) {
            Fabric.profileJolokia(jolokia, profileId, versionId, function (profileJolokia) {
                if (!profileJolokia) {
                    Camel.log.info("No container is running for profile " + profileId + " and version " + versionId + " so using current container for endpoint completion");
                    profileJolokia = jolokia;
                }
                $scope.jolokia = profileJolokia;
                $scope.profileWorkspace = null;
                $scope.loadEndpointNames();
            });
        }
        var silentOptions = { silent: true };
        $scope.$watch('workspace.selection', function () {
            $scope.loadEndpointNames();
        });
        $scope.$watch('selectedComponentName', function () {
            if ($scope.selectedComponentName !== $scope.loadedComponentName) {
                $scope.endpointParameters = {};
                $scope.loadEndpointSchema($scope.selectedComponentName);
                $scope.loadedComponentName = $scope.selectedComponentName;
            }
        });
        $scope.endpointCompletions = function (completionText) {
            var answer = null;
            var mbean = findCamelContextMBean();
            var componentName = $scope.selectedComponentName;
            var endpointParameters = {};
            if (mbean && componentName && completionText) {
                answer = $scope.jolokia.execute(mbean, 'completeEndpointPath', componentName, endpointParameters, completionText, onSuccess(null, silentOptions));
            }
            return answer || [];
        };
        $scope.loadEndpointNames = function () {
            $scope.componentNames = null;
            var mbean = findCamelContextMBean();
            if (mbean) {
                $scope.jolokia.execute(mbean, 'findComponentNames', onSuccess(onComponents, { silent: true }));
            }
            else {
                console.log("WARNING: No camel context mbean so cannot load component names");
            }
        };
        $scope.loadEndpointSchema = function (componentName) {
            var mbean = findCamelContextMBean();
            if (mbean && componentName && componentName !== $scope.loadedEndpointSchema) {
                $scope.selectedComponentName = componentName;
                $scope.jolokia.execute(mbean, 'componentParameterJsonSchema', componentName, onSuccess(onEndpointSchema, silentOptions));
            }
        };
        function onComponents(response) {
            $scope.componentNames = response;
            Camel.log.info("onComponents: " + response);
            $scope.hasComponentNames = $scope.componentNames ? true : false;
            Core.$apply($scope);
        }
        function onEndpointSchema(response) {
            if (response) {
                try {
                    var json = JSON.parse(response);
                    var endpointName = $scope.selectedComponentName;
                    configureEndpointSchema(endpointName, json);
                    $scope.endpointSchema = json;
                    $scope.schema.definitions[endpointName] = json;
                    $scope.loadedEndpointSchema = endpointName;
                    Core.$apply($scope);
                }
                catch (e) {
                    console.log("Failed to parse JSON " + e);
                    console.log("JSON: " + response);
                }
            }
        }
        function configureEndpointSchema(endpointName, json) {
            console.log("======== configuring schema for " + endpointName);
            var config = Camel.endpointForms[endpointName];
            if (config && json) {
                if (config.tabs) {
                    json.tabs = config.tabs;
                }
            }
        }
        function findCamelContextMBean() {
            var profileWorkspace = $scope.profileWorkspace;
            if (!profileWorkspace) {
                var removeJolokia = $scope.jolokia;
                if (removeJolokia) {
                    profileWorkspace = Core.createRemoteWorkspace(removeJolokia, $location, localStorage);
                    $scope.profileWorkspace = profileWorkspace;
                }
            }
            if (!profileWorkspace) {
                Camel.log.info("No profileWorkspace found so defaulting it to workspace for now");
                profileWorkspace = workspace;
            }
            var componentName = $scope.selectedComponentName;
            var selectedCamelContextId;
            var selectedRouteId;
            if (angular.isDefined($scope.camelSelectionDetails)) {
                selectedCamelContextId = $scope.camelSelectionDetails.selectedCamelContextId;
                selectedRouteId = $scope.camelSelectionDetails.selectedRouteId;
            }
            console.log("==== componentName " + componentName + " selectedCamelContextId: " + selectedCamelContextId + " selectedRouteId: " + selectedRouteId);
            var contextsById = Camel.camelContextMBeansById(profileWorkspace);
            if (selectedCamelContextId) {
                var mbean = Core.pathGet(contextsById, [selectedCamelContextId, "mbean"]);
                if (mbean) {
                    return mbean;
                }
            }
            if (selectedRouteId) {
                var map = Camel.camelContextMBeansByRouteId(profileWorkspace);
                var mbean = Core.pathGet(map, [selectedRouteId, "mbean"]);
                if (mbean) {
                    return mbean;
                }
            }
            if (componentName) {
                var map = Camel.camelContextMBeansByComponentName(profileWorkspace);
                var mbean = Core.pathGet(map, [componentName, "mbean"]);
                if (mbean) {
                    return mbean;
                }
            }
            var answer = null;
            angular.forEach(contextsById, function (details, id) {
                var mbean = details.mbean;
                if (!answer && mbean)
                    answer = mbean;
            });
            return answer;
        }
    }
    Camel.initEndpointChooserScope = initEndpointChooserScope;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.FabricDiagramController", ["$scope", "$compile", "$location", "localStorage", "jolokia", "workspace", function ($scope, $compile, $location, localStorage, jolokia, workspace) {
        Fabric.initScope($scope, $location, jolokia, workspace);
        var isFmc = Fabric.isFMCContainer(workspace);
        $scope.isFmc = isFmc;
        $scope.selectedNode = null;
        var defaultFlags = {
            panel: true,
            popup: false,
            label: true,
            container: false,
            endpoint: true,
            route: true,
            context: false,
            consumer: true,
            producer: true
        };
        $scope.viewSettings = {};
        $scope.shapeSize = {
            context: 12,
            route: 10,
            endpoint: 7
        };
        var graphBuilder = new ForceGraph.GraphBuilder();
        Core.bindModelToSearchParam($scope, $location, "searchFilter", "q", "");
        angular.forEach(defaultFlags, function (defaultValue, key) {
            var modelName = "viewSettings." + key;
            function currentValue() {
                var answer = $location.search()[paramName] || defaultValue;
                return answer === "false" ? false : answer;
            }
            var paramName = key;
            var value = currentValue();
            Core.pathSet($scope, modelName, value);
            $scope.$watch(modelName, function () {
                var current = Core.pathGet($scope, modelName);
                var old = currentValue();
                if (current !== old) {
                    var defaultValue = defaultFlags[key];
                    if (current !== defaultValue) {
                        if (!current) {
                            current = "false";
                        }
                        $location.search(paramName, current);
                    }
                    else {
                        $location.search(paramName, null);
                    }
                }
                redrawGraph();
            });
        });
        $scope.connectToContext = function () {
            var selectedNode = $scope.selectedNode;
            if (selectedNode) {
                var container = selectedNode["container"] || selectedNode;
                var postfix = null;
                connectToContainer(container, postfix);
            }
        };
        $scope.connectToEndpoint = function () {
            var selectedNode = $scope.selectedNode;
            if (selectedNode) {
                var container = selectedNode["container"] || selectedNode;
                var postfix = null;
                connectToContainer(container, postfix);
            }
        };
        function connectToContainer(container, postfix, viewPrefix) {
            if (viewPrefix === void 0) { viewPrefix = "#/jmx/attributes?tab=camel"; }
            var view = viewPrefix;
            if (postfix) {
                view += postfix;
            }
            $scope.doConnect(container, view);
        }
        $scope.$on('$destroy', function (event) {
            stopOldJolokia();
        });
        function stopOldJolokia() {
            var oldJolokia = $scope.selectedNodeJolokia;
            if (oldJolokia && oldJolokia !== jolokia) {
                oldJolokia.stop();
            }
        }
        $scope.$watch("selectedNode", function (newValue, oldValue) {
            if ($scope.unregisterFn) {
                $scope.unregisterFn();
                $scope.unregisterFn = null;
            }
            var node = $scope.selectedNode;
            if (node) {
                var mbean = node.objectName;
                var container = node.container || {};
                var nodeJolokia = node.jolokia || container.jolokia || jolokia;
                if (nodeJolokia !== $scope.selectedNodeJolokia) {
                    stopOldJolokia();
                    $scope.selectedNodeJolokia = nodeJolokia;
                    if (nodeJolokia !== jolokia) {
                        var rate = Core.parseIntValue(localStorage['updateRate'] || "2000", "update rate");
                        if (rate) {
                            nodeJolokia.start(rate);
                        }
                    }
                }
                var dummyResponse = { value: node.panelProperties || {} };
                if (mbean && nodeJolokia) {
                    $scope.unregisterFn = Core.register(nodeJolokia, $scope, {
                        type: 'read',
                        mbean: mbean
                    }, onSuccess(renderNodeAttributes, { error: function (response) {
                        renderNodeAttributes(dummyResponse);
                        Core.defaultJolokiaErrorHandler(response);
                    } }));
                }
                else {
                    renderNodeAttributes(dummyResponse);
                }
            }
        });
        var ignoreNodeAttributes = [
            "CamelId",
            "CamelManagementName"
        ];
        var ignoreNodeAttributesByType = {
            context: ["ApplicationContextClassName", "CamelId", "ClassResolver", "ManagementName", "PackageScanClassResolver", "Properties"],
            endpoint: ["Camel", "Endpoint"],
            route: ["Description"]
        };
        var onlyShowAttributesByType = {
            broker: []
        };
        function renderNodeAttributes(response) {
            var properties = [];
            if (response) {
                var value = response.value || {};
                $scope.selectedNodeAttributes = value;
                var selectedNode = $scope.selectedNode || {};
                var container = selectedNode['container'] || {};
                var nodeType = selectedNode["type"];
                var brokerName = selectedNode["brokerName"];
                var containerId = container["id"];
                var group = selectedNode["group"] || container["group"];
                var jolokiaUrl = selectedNode["jolokiaUrl"] || container["jolokiaUrl"];
                var profile = selectedNode["profile"] || container["profile"];
                var version = selectedNode["version"] || container["version"];
                var isBroker = nodeType && nodeType.startsWith("broker");
                var ignoreKeys = ignoreNodeAttributes.concat(ignoreNodeAttributesByType[nodeType] || []);
                var onlyShowKeys = onlyShowAttributesByType[nodeType];
                angular.forEach(value, function (v, k) {
                    if (onlyShowKeys ? onlyShowKeys.indexOf(k) >= 0 : ignoreKeys.indexOf(k) < 0) {
                        var formattedValue = Core.humanizeValueHtml(v);
                        properties.push({ key: Core.humanizeValue(k), value: formattedValue });
                    }
                });
                properties = properties.sortBy("key");
                if (containerId && isFmc) {
                    properties.splice(0, 0, { key: "Container", value: $compile('<div fabric-container-link="' + selectedNode['container']['id'] + '"></div>')($scope) });
                }
                var typeLabel = selectedNode["typeLabel"];
                var name = selectedNode["name"] || selectedNode["id"] || selectedNode['objectName'];
                if (typeLabel) {
                    var html = name;
                    if (nodeType === "queue" || nodeType === "topic") {
                        html = createDestinationLink(name, nodeType);
                    }
                    var typeProperty = { key: typeLabel, value: html };
                    properties.splice(0, 0, typeProperty);
                }
            }
            $scope.selectedNodeProperties = properties;
            Core.$apply($scope);
        }
        function createDestinationLink(destinationName, destinationType) {
            if (destinationType === void 0) { destinationType = "queue"; }
            return $compile('<a target="destination" title="' + destinationName + '" ng-click="connectToEndpoint()">' + destinationName + '</a>')($scope);
        }
        $scope.$watch("searchFilter", function (newValue, oldValue) {
            redrawGraph();
        });
        if (isFmc) {
            $scope.versionId = Fabric.getDefaultVersionId(jolokia);
            var fields = ["id", "alive", "parentId", "profileIds", "versionId", "provisionResult", "jolokiaUrl", "jmxDomains"];
            Fabric.getContainersFields(jolokia, fields, onFabricContainerData);
        }
        else {
            $scope.$watch('workspace.tree', function () {
                reloadLocalJmxTree();
            });
            $scope.$on('jmxTreeUpdated', function () {
                reloadLocalJmxTree();
            });
        }
        function reloadLocalJmxTree() {
            var localContainer = {
                jolokia: jolokia
            };
            $scope.activeContainers = {
                "local": localContainer
            };
            redrawGraph();
            $scope.containerCount = 1;
        }
        function onFabricContainerData(response) {
            if (response) {
                var responseJson = angular.toJson(response);
                if ($scope.responseJson === responseJson) {
                    return;
                }
                $scope.responseJson = responseJson;
                var containersToDelete = $scope.activeContainers || {};
                $scope.activeContainers = (response || {}).filter(function (c) { return c.jmxDomains.any(Camel.jmxDomain); });
                $scope.containerCount = $scope.activeContainers.length;
                redrawGraph();
            }
            else {
                $scope.containerCount = 0;
            }
        }
        function redrawGraph() {
            graphBuilder = new ForceGraph.GraphBuilder();
            angular.forEach($scope.activeContainers, function (container, id) {
                var containerJolokia = container.jolokia;
                if (!containerJolokia) {
                    var jolokiaUrl = container["jolokiaUrl"];
                    if (jolokiaUrl) {
                        var url = Core.useProxyIfExternal(jolokiaUrl);
                        containerJolokia = Fabric.createJolokia(url);
                    }
                }
                if (containerJolokia) {
                    onContainerJolokia(containerJolokia, container);
                }
                else {
                    Fabric.containerJolokia(jolokia, id, function (containerJolokia) { return onContainerJolokia(containerJolokia, container); });
                }
            });
            Core.$apply($scope);
        }
        function matchesContextId(contextId) {
            if (contextId) {
                return !$scope.searchFilter || contextId.indexOf($scope.searchFilter) >= 0;
            }
            return false;
        }
        function onContainerJolokia(containerJolokia, container) {
            if (containerJolokia) {
                container.jolokia = containerJolokia;
                var containerId = container.id || "local";
                var idPrefix = containerId + ":";
                var endpointUriToObject = {};
                var startedLoadMetaDataFromEndpointMBeans = false;
                function getOrCreateRoute(objectName, properties, addEndpointLink, routeId, contextId, camelContext) {
                    if (routeId === void 0) { routeId = null; }
                    if (contextId === void 0) { contextId = null; }
                    if (camelContext === void 0) { camelContext = null; }
                    if (!objectName) {
                        objectName = Camel.jmxDomain + ':context=' + contextId + ',type=routes,name="' + routeId + '"';
                    }
                    var details = Core.parseMBean(objectName);
                    var attributes = details['attributes'];
                    var contextId = attributes["context"];
                    if (!routeId) {
                        routeId = Core.trimQuotes(attributes["name"]);
                    }
                    attributes["routeId"] = routeId;
                    attributes["mbean"] = objectName;
                    attributes["container"] = container;
                    attributes["type"] = "route";
                    var route = null;
                    if (routeId && matchesContextId(contextId)) {
                        route = getOrAddNode("route", idPrefix + routeId, attributes, function () {
                            return {
                                name: routeId,
                                typeLabel: "Route",
                                container: container,
                                objectName: objectName,
                                jolokia: containerJolokia,
                                popup: {
                                    title: "Route: " + routeId,
                                    content: "<p>context: " + contextId + "</p>"
                                }
                            };
                        });
                        if (addEndpointLink) {
                            var uri = properties["EndpointUri"];
                            if (uri && route) {
                                var endpoint = null;
                                var escaledUrl = Camel.escapeEndpointUriNameForJmx(uri);
                                var urlsToTry = [uri, escaledUrl];
                                angular.forEach(urlsToTry, function (key) {
                                    if (!endpoint) {
                                        endpoint = endpointUriToObject[key];
                                    }
                                });
                                if (!endpoint) {
                                    angular.forEach(urlsToTry, function (key) {
                                        if (!endpoint) {
                                            var idx = key.lastIndexOf("?");
                                            if (idx > 0) {
                                                var prefix = key.substring(0, idx);
                                                endpoint = endpointUriToObject[prefix];
                                            }
                                        }
                                    });
                                }
                                addLink(route, endpoint, "consumer");
                            }
                        }
                        if ($scope.viewSettings.route && $scope.viewSettings.context) {
                            if (!camelContext) {
                                camelContext = getOrCreateCamelContext(contextId);
                            }
                            addLink(camelContext, route, "route");
                        }
                    }
                    return route;
                }
                function getOrCreateEndpoint(objectName, uri, contextId) {
                    if (uri === void 0) { uri = null; }
                    if (contextId === void 0) { contextId = null; }
                    if (!objectName) {
                        objectName = Camel.jmxDomain + ':context=' + contextId + ',type=endpoints,name="' + Camel.escapeEndpointUriNameForJmx(uri) + '"';
                    }
                    var details = Core.parseMBean(objectName);
                    var attributes = details['attributes'];
                    var contextId = attributes["context"];
                    if (!uri) {
                        uri = Core.trimQuotes(attributes["name"]);
                    }
                    attributes["uri"] = uri;
                    attributes["mbean"] = objectName;
                    attributes["container"] = container;
                    attributes["contextId"] = contextId;
                    var endpoint = null;
                    if (uri && matchesContextId(contextId)) {
                        endpoint = getOrAddNode("endpoint", idPrefix + uri, attributes, function () {
                            return {
                                name: uri,
                                typeLabel: "Endpoint",
                                container: container,
                                objectName: objectName,
                                jolokia: containerJolokia,
                                popup: {
                                    title: "Endpoint: " + uri,
                                    content: "<p>context: " + contextId + "</p>"
                                }
                            };
                        });
                        if (endpoint) {
                            endpointUriToObject[uri] = endpoint;
                        }
                    }
                    return endpoint;
                }
                function loadMetaDataFromEndpointMBeans() {
                    if ($scope.viewSettings.route) {
                        containerJolokia.request({ type: "read", mbean: "org.apache.camel:type=routes,*", attribute: ["EndpointUri"] }, onSuccess(function (response) {
                            angular.forEach(response.value, function (properties, objectName) {
                                getOrCreateRoute(objectName, properties, true);
                            });
                            graphModelUpdated();
                        }));
                    }
                    if ($scope.viewSettings.endpoint) {
                        containerJolokia.search("org.apache.camel:type=endpoints,*", onSuccess(function (response) {
                            angular.forEach(response, function (objectName) {
                                var endpoint = getOrCreateEndpoint(objectName);
                                var camelContext = getOrCreateCamelContext(null, objectName);
                                addLink(camelContext, endpoint, "endpoint");
                            });
                            graphModelUpdated();
                        }));
                    }
                }
                function getOrCreateCamelContext(contextId, contextMBean) {
                    if (contextMBean === void 0) { contextMBean = null; }
                    var answer = null;
                    if (matchesContextId(contextId)) {
                        if (!contextMBean) {
                            contextMBean = Camel.jmxDomain + ':context=' + contextId + ',type=context,name="' + contextId + '"';
                        }
                        if (!contextId && contextMBean) {
                            var details = Core.parseMBean(contextMBean);
                            var attributes = details['attributes'];
                            contextId = attributes["context"];
                        }
                        var contextAttributes = {
                            contextId: contextId
                        };
                        if ($scope.viewSettings.context) {
                            answer = getOrAddNode("context", idPrefix + contextId, contextAttributes, function () {
                                return {
                                    name: contextId,
                                    typeLabel: "CamelContext",
                                    container: container,
                                    objectName: contextMBean,
                                    jolokia: containerJolokia,
                                    popup: {
                                        title: "CamelContext: " + contextId,
                                        content: ""
                                    }
                                };
                            });
                        }
                        containerJolokia.execute(contextMBean, "createRouteStaticEndpointJson", onSuccess(function (response) {
                            if (angular.isString(response)) {
                                var text = response;
                                var data = null;
                                try {
                                    data = JSON.parse(text);
                                }
                                catch (e) {
                                    text = Core.trimTrailing(text.trim(), "}");
                                    try {
                                        data = JSON.parse(text);
                                    }
                                    catch (e2) {
                                        Camel.log.debug("Ignored invalid json: " + e + " from text: " + response);
                                    }
                                }
                            }
                            if (data) {
                                angular.forEach(data["routes"], function (routeData, routeId) {
                                    angular.forEach(routeData["inputs"], function (inputEndpoint) {
                                        var inputUri = inputEndpoint["uri"];
                                        if (inputUri) {
                                            var route = getOrCreateRoute(null, {}, false, routeId, contextId, answer);
                                            var input = getOrCreateEndpoint(null, inputUri, contextId);
                                            var nextStep = route;
                                            addLink(input, route, "endpoint");
                                            angular.forEach(routeData["outputs"], function (outputEndpoint) {
                                                var outputUri = outputEndpoint["uri"];
                                                if (outputUri) {
                                                    var output = getOrCreateEndpoint(null, outputUri, contextId);
                                                    addLink(nextStep, output, "endpoint");
                                                    nextStep = output;
                                                }
                                            });
                                        }
                                    });
                                });
                                Camel.log.info("Updating graph model!");
                                graphModelUpdated();
                            }
                        }, {
                            error: function (response) {
                                if (!startedLoadMetaDataFromEndpointMBeans) {
                                    startedLoadMetaDataFromEndpointMBeans = true;
                                    loadMetaDataFromEndpointMBeans();
                                }
                            }
                        }));
                    }
                    return answer;
                }
                containerJolokia.search("org.apache.camel:type=context,*", onSuccess(function (response) {
                    angular.forEach(response, function (objectName) {
                        var details = Core.parseMBean(objectName);
                        var attributes = details['attributes'];
                        var contextId = attributes["context"];
                        var uri = Core.trimQuotes(attributes["name"]);
                        getOrCreateCamelContext(contextId, objectName);
                    });
                }));
            }
        }
        function graphModelUpdated() {
            $scope.graph = graphBuilder.buildGraph();
            Core.$apply($scope);
        }
        function getOrAddNode(typeName, id, properties, createFn) {
            var node = null;
            if (id) {
                var nodeId = typeName + ":" + id;
                node = graphBuilder.getNode(nodeId);
                if (!node) {
                    var nodeValues = createFn();
                    node = angular.copy(properties);
                    angular.forEach(nodeValues, function (value, key) { return node[key] = value; });
                    node['id'] = nodeId;
                    if (!node['type']) {
                        node['type'] = typeName;
                    }
                    if (!node['name']) {
                        node['name'] = id;
                    }
                    if (node) {
                        var size = $scope.shapeSize[typeName];
                        if (size && !node['size']) {
                            node['size'] = size;
                        }
                        if (!node['summary']) {
                            node['summary'] = node['popup'] || "";
                        }
                        if (!$scope.viewSettings.popup) {
                            delete node['popup'];
                        }
                        if (!$scope.viewSettings.label) {
                            delete node['name'];
                        }
                        var enabled = $scope.viewSettings[typeName];
                        if (enabled || !angular.isDefined(enabled)) {
                            graphBuilder.addNode(node);
                        }
                        else {
                        }
                    }
                }
            }
            return node;
        }
        function addLink(object1, object2, linkType) {
            if (object1 && object2) {
                addLinkIds(object1.id, object2.id, linkType);
            }
        }
        function addLinkIds(id1, id2, linkType) {
            if (id1 && id2) {
                graphBuilder.addLink(id1, id2, linkType);
            }
        }
        function renameTypeProperty(properties) {
            properties.mbeanType = properties['type'];
            delete properties['type'];
        }
        function configureEndpointProperties(properties) {
            renameTypeProperty(properties);
            var destinationType = properties.destinationType || "Queue";
            var typeName = destinationType.toLowerCase();
            properties.isQueue = !typeName.startsWith("t");
            properties['destType'] = typeName;
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.jmsHeaderSchema = {
        definitions: {
            headers: {
                properties: {
                    JMSCorrelationID: {
                        type: "java.lang.String"
                    },
                    JMSDeliveryMode: {
                        "type": "string",
                        "enum": [
                            "PERSISTENT",
                            "NON_PERSISTENT"
                        ]
                    },
                    JMSDestination: {
                        type: "javax.jms.Destination"
                    },
                    JMSExpiration: {
                        type: "long"
                    },
                    JMSPriority: {
                        type: "int"
                    },
                    JMSReplyTo: {
                        type: "javax.jms.Destination"
                    },
                    JMSType: {
                        type: "java.lang.String"
                    },
                    JMSXGroupId: {
                        type: "java.lang.String"
                    },
                    AMQ_SCHEDULED_CRON: {
                        type: "java.lang.String"
                    },
                    AMQ_SCHEDULED_DELAY: {
                        type: "java.lang.String"
                    },
                    AMQ_SCHEDULED_PERIOD: {
                        type: "java.lang.String"
                    },
                    AMQ_SCHEDULED_REPEAT: {
                        type: "java.lang.String"
                    }
                }
            },
            "javax.jms.Destination": {
                type: "java.lang.String"
            }
        }
    };
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.PreferencesController", ["$scope", "localStorage", function ($scope, localStorage) {
        Core.initPreferenceScope($scope, localStorage, {
            'camelIgnoreIdForLabel': {
                'value': false,
                'converter': Core.parseBooleanValue
            },
            'camelMaximumLabelWidth': {
                'value': Camel.defaultMaximumLabelWidth,
                'converter': parseInt
            },
            'camelMaximumTraceOrDebugBodyLength': {
                'value': Camel.defaultCamelMaximumTraceOrDebugBodyLength,
                'converter': parseInt
            },
            'camelRouteMetricMaxSeconds': {
                'value': Camel.defaultCamelRouteMetricMaxSeconds,
                'converter': parseInt
            }
        });
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.ProfileRouteController", ["$scope", "$location", "workspace", "jolokia", function ($scope, $location, workspace, jolokia) {
        $scope.data = [];
        $scope.calcManually = true;
        $scope.icons = {};
        $scope.selectedRouteId = "";
        var columnDefs = [
            {
                field: 'id',
                displayName: 'Id',
                cellTemplate: '<div class="ngCellText" ng-bind-html-unsafe="rowIcon(row.entity.id)"></div>',
                cellFilter: null,
                width: "**",
                resizable: true
            },
            {
                field: 'count',
                displayName: 'Count',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'last',
                displayName: 'Last',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'delta',
                displayName: 'Delta',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'mean',
                displayName: 'Mean',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'min',
                displayName: 'Min',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'max',
                displayName: 'Max',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'total',
                displayName: 'Total',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'self',
                displayName: 'Self',
                cellFilter: null,
                width: "*",
                resizable: true
            }
        ];
        $scope.rowIcon = function (id) {
            var entry = $scope.icons[id];
            if (entry) {
                return entry.img + " " + id;
            }
            else {
                return id;
            }
        };
        $scope.gridOptions = {
            data: 'data',
            displayFooter: true,
            displaySelectionCheckbox: false,
            canSelectRows: false,
            enableSorting: false,
            columnDefs: columnDefs,
            filterOptions: {
                filterText: ''
            }
        };
        var populateProfileMessages = function (response) {
            var updatedData = [];
            var xml = response.value;
            if (angular.isString(xml)) {
                var doc = $.parseXML(xml);
                var routeMessages = $(doc).find("routeStat");
                routeMessages.each(function (idx, message) {
                    var messageData = {
                        id: {},
                        count: {},
                        last: {},
                        delta: {},
                        mean: {},
                        min: {},
                        max: {},
                        total: {},
                        self: {}
                    };
                    messageData.id = message.getAttribute("id");
                    var total = 0;
                    total += +message.getAttribute("exchangesCompleted");
                    total += +message.getAttribute("exchangesFailed");
                    messageData.count = total;
                    messageData.last = message.getAttribute("lastProcessingTime");
                    var delta = message.getAttribute("deltaProcessingTime");
                    if (delta) {
                        messageData.delta = delta;
                    }
                    else {
                        messageData.delta = 0;
                    }
                    messageData.mean = message.getAttribute("meanProcessingTime");
                    messageData.min = message.getAttribute("minProcessingTime");
                    messageData.max = message.getAttribute("maxProcessingTime");
                    messageData.total = message.getAttribute("totalProcessingTime");
                    var self = message.getAttribute("selfProcessingTime");
                    if (self) {
                        messageData.self = self;
                    }
                    else {
                        $scope.calcManually = true;
                        messageData.self = "0";
                    }
                    updatedData.push(messageData);
                });
                var processorMessages = $(doc).find("processorStat");
                processorMessages.each(function (idx, message) {
                    var messageData = {
                        id: {},
                        count: {},
                        last: {},
                        delta: {},
                        mean: {},
                        min: {},
                        max: {},
                        total: {},
                        self: {}
                    };
                    messageData.id = message.getAttribute("id");
                    var total = 0;
                    total += +message.getAttribute("exchangesCompleted");
                    total += +message.getAttribute("exchangesFailed");
                    messageData.count = total;
                    messageData.last = message.getAttribute("lastProcessingTime");
                    var delta = message.getAttribute("deltaProcessingTime");
                    if (delta) {
                        messageData.delta = delta;
                    }
                    else {
                        messageData.delta = 0;
                    }
                    messageData.mean = message.getAttribute("meanProcessingTime");
                    messageData.min = message.getAttribute("minProcessingTime");
                    messageData.max = message.getAttribute("maxProcessingTime");
                    var apt = message.getAttribute("accumulatedProcessingTime");
                    if (apt) {
                        messageData.total = apt;
                    }
                    else {
                        messageData.total = "0";
                    }
                    messageData.self = message.getAttribute("totalProcessingTime");
                    updatedData.push(messageData);
                });
            }
            if ($scope.calcManually) {
                updatedData.sort(function (e1, e2) {
                    var entry1 = $scope.icons[e1.id];
                    var entry2 = $scope.icons[e2.id];
                    if (entry1 && entry2) {
                        return entry1.index - entry2.index;
                    }
                    else {
                        return 0;
                    }
                });
                var accTotal = 0;
                updatedData.reverse().forEach(function (data, idx) {
                    if (idx < updatedData.length - 1) {
                        accTotal += +data.self;
                        data.total = accTotal;
                    }
                    else {
                        data.self = +(data.total - accTotal);
                        if (data.self < 0) {
                            data.self = 0;
                        }
                    }
                });
                updatedData.reverse();
            }
            $scope.data = updatedData;
            Core.$apply($scope);
        };
        $scope.onResponse = function (response) {
            loadData();
        };
        $scope.$watch('workspace.tree', function () {
            setTimeout(loadData, 50);
        });
        function initIdToIcon() {
            console.log("initializing id and icons");
            $scope.icons = {};
            var routeXml = Core.pathGet(workspace.selection, ["routeXmlNode"]);
            if (routeXml) {
                var entry = {
                    img: "",
                    index: 0
                };
                entry.index = -1;
                entry.img = "<img src='img/icons/camel/camel_route.png'>";
                $scope.icons[$scope.selectedRouteId] = entry;
                $(routeXml).find('*').each(function (idx, element) {
                    var id = element.getAttribute("id");
                    if (id) {
                        var entry = {
                            img: "",
                            index: 0
                        };
                        entry.index = idx;
                        var icon = Camel.getRouteNodeIcon(element);
                        if (icon) {
                            entry.img = "<img src='" + icon + "'>";
                        }
                        else {
                            entry.img = "";
                        }
                        $scope.icons[id] = entry;
                    }
                });
            }
        }
        function loadData() {
            console.log("Loading Camel route profile data...");
            $scope.selectedRouteId = Camel.getSelectedRouteId(workspace);
            var routeMBean = Camel.getSelectionRouteMBean(workspace, $scope.selectedRouteId);
            console.log("Selected route is " + $scope.selectedRouteId);
            if (Camel.isCamelVersionEQGT(2, 11, workspace, jolokia)) {
                console.log("Camel 2.11 or better detected");
                $scope.calcManually = false;
            }
            else {
                console.log("Camel 2.10 or older detected");
                $scope.calcManually = true;
            }
            initIdToIcon();
            console.log("Initialized icons, with " + $scope.icons.length + " icons");
            var query = { type: 'exec', mbean: routeMBean, operation: 'dumpRouteStatsAsXml(boolean,boolean)', arguments: [false, true] };
            scopeStoreJolokiaHandle($scope, jolokia, jolokia.register(populateProfileMessages, query));
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.PropertiesController", ["$scope", "workspace", function ($scope, workspace) {
        $scope.viewTemplate = null;
        $scope.schema = _apacheCamelModel;
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            setTimeout(updateData, 50);
        });
        $scope.$watch('workspace.selection', function () {
            if (workspace.moveIfViewInvalid())
                return;
            updateData();
        });
        function updateData() {
            var routeXmlNode = Camel.getSelectedRouteNode(workspace);
            $scope.nodeData = Camel.getRouteNodeJSON(routeXmlNode);
            if (routeXmlNode) {
                var nodeName = routeXmlNode.nodeName;
                $scope.model = Camel.getCamelSchema(nodeName);
                if ($scope.model) {
                    console.log("data is: " + JSON.stringify($scope.nodeData, null, "  "));
                    console.log("model schema is: " + JSON.stringify($scope.model, null, "  "));
                    $scope.viewTemplate = "app/camel/html/nodePropertiesView.html";
                }
            }
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.RestServiceController", ["$scope", "$location", "workspace", "jolokia", function ($scope, $location, workspace, jolokia) {
        $scope.data = [];
        $scope.selectedMBean = null;
        $scope.mbeanAttributes = {};
        var columnDefs = [
            {
                field: 'url',
                displayName: 'Absolute Url',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'baseUrl',
                displayName: 'Base Url',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'basePath',
                displayName: 'Base Path',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'uriTemplate',
                displayName: 'Uri Template',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'method',
                displayName: 'Method',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'consumes',
                displayName: 'Consumes',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'produces',
                displayName: 'Produces',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'inType',
                displayName: 'Input Type',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'outType',
                displayName: 'Output Type',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'state',
                displayName: 'State',
                cellFilter: null,
                width: "*",
                resizable: true
            }
        ];
        $scope.gridOptions = {
            data: 'data',
            displayFooter: true,
            displaySelectionCheckbox: false,
            canSelectRows: false,
            enableSorting: true,
            columnDefs: columnDefs,
            selectedItems: [],
            filterOptions: {
                filterText: ''
            }
        };
        function onRestRegistry(response) {
            var obj = response.value;
            if (obj) {
                var arr = [];
                for (var key in obj) {
                    var values = obj[key];
                    for (var v in values) {
                        var entry = values[v];
                        arr.push({
                            url: entry.url,
                            baseUrl: entry.baseUrl,
                            basePath: entry.basePath,
                            uriTemplate: entry.uriTemplate,
                            method: entry.method,
                            consumes: entry.consumes,
                            produces: entry.produces,
                            inType: entry.inType,
                            outType: entry.outType,
                            state: entry.state
                        });
                    }
                }
                arr = arr.sortBy("url");
                $scope.data = arr;
                $scope.selectedMBean = response.request.mbean;
            }
            else {
                $scope.selectedMBean = "true";
            }
            Core.$apply($scope);
        }
        $scope.renderIcon = function (state) {
            return Camel.iconClass(state);
        };
        function loadRestRegistry() {
            console.log("Loading RestRegistry data...");
            var mbean = Camel.getSelectionCamelRestRegistry(workspace);
            if (mbean) {
                jolokia.request({ type: 'exec', mbean: mbean, operation: 'listRestServices' }, onSuccess(onRestRegistry));
            }
        }
        loadRestRegistry();
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.RouteMetricsController", ["$scope", "$location", "workspace", "jolokia", "metricsWatcher", function ($scope, $location, workspace, jolokia, metricsWatcher) {
        var log = Logger.get("Camel");
        $scope.maxSeconds = Camel.routeMetricMaxSeconds(localStorage);
        $scope.filterText = null;
        $scope.initDone = false;
        $scope.metricDivs = [];
        $scope.filterByRoute = function (div) {
            log.debug("Filter by route " + div);
            var match = Core.matchFilterIgnoreCase(div.routeId, $scope.filterText);
            if (!match) {
                return "display: none;";
            }
            else {
                return "";
            }
        };
        function populateRouteStatistics(response) {
            var obj = response.value;
            if (obj) {
                var json = JSON.parse(obj);
                if (!$scope.initDone) {
                    var meters = json['timers'];
                    var counter = 0;
                    if (meters != null) {
                        for (var v in meters) {
                            var key = v;
                            var lastDot = key.lastIndexOf(".");
                            var className = key.substr(0, lastDot);
                            var metricsName = key.substr(lastDot + 1);
                            var firstColon = key.indexOf(":");
                            var routeId = key.substr(firstColon + 1);
                            lastDot = routeId.lastIndexOf(".");
                            if (lastDot > 0) {
                                routeId = routeId.substr(0, lastDot);
                            }
                            var entry = meters[v];
                            var div = "timer-" + counter;
                            $scope.metricDivs.push({
                                id: div,
                                routeId: routeId
                            });
                            counter++;
                            log.info("Added timer: " + div + " (" + className + "." + metricsName + ") for route: " + routeId + " with max seconds: " + $scope.maxSeconds);
                            metricsWatcher.addTimer(div, className, metricsName, $scope.maxSeconds, routeId, "Histogram", $scope.maxSeconds * 1000);
                        }
                        log.info("Pre-init graphs");
                        Core.$apply($scope);
                    }
                    log.info("Init graphs");
                    metricsWatcher.initGraphs();
                }
                $scope.initDone = true;
                log.debug("Updating graphs: " + json);
                metricsWatcher.updateGraphs(json);
            }
            $scope.initDone = true;
            Core.$apply($scope);
        }
        $scope.onResponse = function (response) {
            loadData();
        };
        $scope.$watch('workspace.tree', function () {
            setTimeout(loadData, 50);
        });
        function loadData() {
            log.info("Loading RouteMetrics data...");
            var routeId = Camel.getSelectedRouteId(workspace);
            if (routeId != null) {
                $scope.filterText = routeId;
            }
            var mbean = Camel.getSelectionCamelRouteMetrics(workspace);
            if (mbean) {
                var query = { type: 'exec', mbean: mbean, operation: 'dumpStatisticsAsJson' };
                scopeStoreJolokiaHandle($scope, jolokia, jolokia.register(populateRouteStatistics, query));
            }
            else {
                $scope.initDone = true;
                Core.$apply($scope);
            }
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.RouteController", ["$scope", "$routeParams", "$element", "$timeout", "workspace", "$location", "jolokia", "localStorage", function ($scope, $routeParams, $element, $timeout, workspace, $location, jolokia, localStorage) {
        var log = Logger.get("Camel");
        $scope.routes = [];
        $scope.routeNodes = {};
        if ($routeParams != null) {
            $scope.contextId = $routeParams["contextId"];
            $scope.routeId = Core.trimQuotes($routeParams["routeId"]);
            $scope.isJmxTab = !$routeParams["contextId"] || !$routeParams["routeId"];
        }
        $scope.camelIgnoreIdForLabel = Camel.ignoreIdForLabel(localStorage);
        $scope.camelMaximumLabelWidth = Camel.maximumLabelWidth(localStorage);
        var updateRoutes = Core.throttled(doUpdateRoutes, 1000);
        var delayUpdatingRoutes = 300;
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            $timeout(updateRoutes, delayUpdatingRoutes);
        });
        $scope.$watch('workspace.selection', function () {
            if ($scope.isJmxTab && workspace.moveIfViewInvalid())
                return;
            $timeout(updateRoutes, delayUpdatingRoutes);
        });
        $scope.$on('jmxTreeUpdated', function () {
            $timeout(updateRoutes, delayUpdatingRoutes);
        });
        $scope.$watch('nodeXmlNode', function () {
            if ($scope.isJmxTab && workspace.moveIfViewInvalid())
                return;
            $timeout(updateRoutes, delayUpdatingRoutes);
        });
        function doUpdateRoutes() {
            var routeXmlNode = null;
            if (!$scope.ignoreRouteXmlNode) {
                routeXmlNode = Camel.getSelectedRouteNode(workspace);
                if (!routeXmlNode) {
                    routeXmlNode = $scope.nodeXmlNode;
                }
                if (routeXmlNode && routeXmlNode.localName !== "route") {
                    var wrapper = document.createElement("route");
                    wrapper.appendChild(routeXmlNode.cloneNode(true));
                    routeXmlNode = wrapper;
                }
            }
            $scope.mbean = Camel.getSelectionCamelContextMBean(workspace);
            if (!$scope.mbean && $scope.contextId) {
                $scope.mbean = Camel.getCamelContextMBean(workspace, $scope.contextId);
            }
            if (routeXmlNode) {
                $scope.nodes = {};
                var nodes = [];
                var links = [];
                $scope.processorTree = Camel.camelProcessorMBeansById(workspace);
                Camel.addRouteXmlChildren($scope, routeXmlNode, nodes, links, null, 0, 0);
                showGraph(nodes, links);
            }
            else if ($scope.mbean) {
                jolokia.request({ type: 'exec', mbean: $scope.mbean, operation: 'dumpRoutesAsXml()' }, onSuccess(populateTable));
            }
            else {
                log.info("No camel context bean! Selection: " + workspace.selection);
            }
        }
        var populateTable = function (response) {
            var data = response.value;
            $scope.routes = data;
            $scope.nodes = {};
            $scope.routeNodes = {};
            var nodes = [];
            var links = [];
            var selectedRouteId = $scope.routeId;
            if (!selectedRouteId) {
                selectedRouteId = Camel.getSelectedRouteId(workspace);
            }
            if (data) {
                var doc = $.parseXML(data);
                $scope.processorTree = Camel.camelProcessorMBeansById(workspace);
                Camel.loadRouteXmlNodes($scope, doc, selectedRouteId, nodes, links, getWidth());
                showGraph(nodes, links);
            }
            else {
                console.log("No data from route XML!");
            }
            Core.$apply($scope);
        };
        var postfix = " selected";
        function isSelected(node) {
            if (node) {
                var className = node.getAttribute("class");
                return className && className.endsWith(postfix);
            }
            return false;
        }
        function setSelected(node, flag) {
            var answer = false;
            if (node) {
                var className = node.getAttribute("class");
                var selected = className && className.endsWith(postfix);
                if (selected) {
                    className = className.substring(0, className.length - postfix.length);
                }
                else {
                    if (!flag) {
                        return answer;
                    }
                    className = className + postfix;
                    answer = true;
                }
                node.setAttribute("class", className);
            }
            return answer;
        }
        function showGraph(nodes, links) {
            var canvasDiv = $($element);
            var width = getWidth();
            var height = getHeight();
            var svg = canvasDiv.children("svg")[0];
            $scope.graphData = Core.dagreLayoutGraph(nodes, links, width, height, svg);
            var gNodes = canvasDiv.find("g.node");
            gNodes.click(function () {
                var selected = isSelected(this);
                gNodes.each(function (idx, element) {
                    setSelected(element, false);
                });
                var cid = null;
                if (!selected) {
                    cid = this.getAttribute("data-cid");
                    setSelected(this, true);
                }
                $scope.$emit("camel.diagram.selectedNodeId", cid);
                Core.$apply($scope);
            });
            if ($scope.mbean) {
                Core.register(jolokia, $scope, {
                    type: 'exec',
                    mbean: $scope.mbean,
                    operation: 'dumpRoutesStatsAsXml',
                    arguments: [true, true]
                }, onSuccess(statsCallback, { silent: true, error: false }));
            }
            $scope.$emit("camel.diagram.layoutComplete");
            return width;
        }
        function getWidth() {
            var canvasDiv = $($element);
            return canvasDiv.width();
        }
        function getHeight() {
            var canvasDiv = $($element);
            return Camel.getCanvasHeight(canvasDiv);
        }
        function statsCallback(response) {
            var data = response.value;
            if (data) {
                var doc = $.parseXML(data);
                var allStats = $(doc).find("routeStat");
                allStats.each(function (idx, stat) {
                    addTooltipToNode(true, stat);
                });
                var allStats = $(doc).find("processorStat");
                allStats.each(function (idx, stat) {
                    addTooltipToNode(false, stat);
                });
                Core.dagreUpdateGraphData($scope.graphData);
            }
            function addTooltipToNode(isRoute, stat) {
                var id = stat.getAttribute("id");
                var completed = stat.getAttribute("exchangesCompleted");
                var tooltip = "";
                if (id && completed) {
                    var container = isRoute ? $scope.routeNodes : $scope.nodes;
                    var node = container[id];
                    if (!node) {
                        angular.forEach(container, function (value, key) {
                            if (!node && id === value.elementId) {
                                node = value;
                            }
                        });
                    }
                    if (node) {
                        var total = 0 + parseInt(completed);
                        var failed = stat.getAttribute("exchangesFailed");
                        if (failed) {
                            total += parseInt(failed);
                        }
                        var last = stat.getAttribute("lastProcessingTime");
                        var mean = stat.getAttribute("meanProcessingTime");
                        var min = stat.getAttribute("minProcessingTime");
                        var max = stat.getAttribute("maxProcessingTime");
                        tooltip = "last: " + last + " (ms)\nmean: " + mean + " (ms)\nmin: " + min + " (ms)\nmax: " + max + " (ms)";
                        node["counter"] = total;
                        var labelSummary = node["labelSummary"];
                        if (labelSummary) {
                            tooltip = labelSummary + "\n\n" + tooltip;
                        }
                        node["tooltip"] = tooltip;
                    }
                    else {
                    }
                }
            }
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var DELIVERY_PERSISTENT = "2";
    Camel._module.controller("Camel.SendMessageController", ["$route", "$scope", "$element", "$timeout", "workspace", "jolokia", "localStorage", "$location", "activeMQMessage", "userDetails", function ($route, $scope, $element, $timeout, workspace, jolokia, localStorage, $location, activeMQMessage, userDetails) {
        var log = Logger.get("Camel");
        log.info("Loaded page!");
        $scope.noCredentials = false;
        $scope.showChoose = false;
        $scope.profileFileNames = [];
        $scope.profileFileNameToProfileId = {};
        $scope.selectedFiles = {};
        $scope.container = {};
        $scope.message = "\n\n\n\n";
        $scope.headers = [];
        Core.bindModelToSearchParam($scope, $location, "tab", "subtab", "compose");
        Core.bindModelToSearchParam($scope, $location, "searchText", "q", "");
        Core.reloadWhenParametersChange($route, $scope, $location);
        $scope.checkCredentials = function () {
            $scope.noCredentials = (Core.isBlank(userDetails.username) || Core.isBlank(userDetails.password)) && (Core.isBlank(localStorage['activemqUserName']) || Core.isBlank(localStorage['activemqPassword']));
        };
        if ($location.path().has('activemq')) {
            $scope.localStorage = localStorage;
            $scope.$watch('localStorage.activemqUserName', $scope.checkCredentials);
            $scope.$watch('localStorage.activemqPassword', $scope.checkCredentials);
            if (activeMQMessage.message !== null) {
                $scope.message = activeMQMessage.message.bodyText;
                if (activeMQMessage.message.PropertiesText !== null) {
                    for (var p in activeMQMessage.message.StringProperties) {
                        $scope.headers.push({ name: p, value: activeMQMessage.message.StringProperties[p] });
                    }
                }
            }
            activeMQMessage.message = null;
        }
        $scope.openPrefs = function () {
            $location.search('pref', 'ActiveMQ');
            $scope.$emit("hawtioOpenPrefs");
        };
        var LANGUAGE_FORMAT_PREFERENCE = "defaultLanguageFormat";
        var sourceFormat = workspace.getLocalStorage(LANGUAGE_FORMAT_PREFERENCE) || "javascript";
        $scope.codeMirror = undefined;
        var options = {
            mode: {
                name: sourceFormat
            },
            onChange: function (codeMirror) {
                if (!$scope.codeMirror) {
                    $scope.codeMirror = codeMirror;
                }
            }
        };
        $scope.codeMirrorOptions = CodeEditor.createEditorSettings(options);
        $scope.addHeader = function () {
            $scope.headers.push({ name: "", value: "" });
            if ($element) {
                $timeout(function () {
                    var lastHeader = $element.find("input.headerName").last();
                    lastHeader.focus();
                }, 100);
            }
        };
        $scope.removeHeader = function (header) {
            $scope.headers = $scope.headers.remove(header);
        };
        $scope.defaultHeaderNames = function () {
            var answer = [];
            function addHeaderSchema(schema) {
                angular.forEach(schema.definitions.headers.properties, function (value, name) {
                    answer.push(name);
                });
            }
            if (isJmsEndpoint()) {
                addHeaderSchema(Camel.jmsHeaderSchema);
            }
            if (isCamelEndpoint()) {
                addHeaderSchema(Camel.camelHeaderSchema);
            }
            return answer;
        };
        $scope.$watch('workspace.selection', function () {
            workspace.moveIfViewInvalid();
            if (Fabric.fabricCreated(workspace)) {
                loadProfileConfigurationFiles();
            }
        });
        $scope.$watch('codeMirrorOptions.mode.name', function (newValue, oldValue) {
            workspace.setLocalStorage(LANGUAGE_FORMAT_PREFERENCE, newValue);
        });
        var sendWorked = function () {
            $scope.message = "";
            Core.notification("success", "Message sent!");
        };
        $scope.autoFormat = function () {
            setTimeout(function () {
                CodeEditor.autoFormatEditor($scope.codeMirror);
            }, 50);
        };
        $scope.sendMessage = function () {
            var body = $scope.message;
            doSendMessage(body, sendWorked);
        };
        function doSendMessage(body, onSendCompleteFn) {
            var selection = workspace.selection;
            if (selection) {
                var mbean = selection.objectName;
                if (mbean) {
                    var headers = null;
                    if ($scope.headers.length) {
                        headers = {};
                        angular.forEach($scope.headers, function (object) {
                            var key = object.name;
                            if (key) {
                                headers[key] = object.value;
                            }
                        });
                        log.info("About to send headers: " + JSON.stringify(headers));
                    }
                    var callback = onSuccess(onSendCompleteFn);
                    if (selection.domain === "org.apache.camel") {
                        var target = Camel.getContextAndTargetEndpoint(workspace);
                        var uri = target['uri'];
                        mbean = target['mbean'];
                        if (mbean && uri) {
                            var ok = true;
                            if (Camel.isCamelVersionEQGT(2, 14, workspace, jolokia)) {
                                var reply = jolokia.execute(mbean, "canSendToEndpoint(java.lang.String)", uri);
                                if (!reply) {
                                    Core.notification("warning", "Camel does not support sending to this endpoint.");
                                    ok = false;
                                }
                            }
                            if (ok) {
                                if (headers) {
                                    jolokia.execute(mbean, "sendBodyAndHeaders(java.lang.String, java.lang.Object, java.util.Map)", uri, body, headers, callback);
                                }
                                else {
                                    jolokia.execute(mbean, "sendStringBody(java.lang.String, java.lang.String)", uri, body, callback);
                                }
                            }
                        }
                        else {
                            if (!mbean) {
                                Core.notification("error", "Could not find CamelContext MBean!");
                            }
                            else {
                                Core.notification("error", "Failed to determine endpoint name!");
                            }
                            log.debug("Parsed context and endpoint: ", target);
                        }
                    }
                    else {
                        var user = localStorage["activemqUserName"] || userDetails.username;
                        var pwd = localStorage["activemqPassword"] || userDetails.password;
                        if (!headers) {
                            headers = {};
                        }
                        if (!headers["JMSDeliveryMode"]) {
                            headers["JMSDeliveryMode"] = DELIVERY_PERSISTENT;
                        }
                        jolokia.execute(mbean, "sendTextMessage(java.util.Map, java.lang.String, java.lang.String, java.lang.String)", headers, body, user, pwd, callback);
                    }
                }
            }
        }
        $scope.fileSelection = function () {
            var answer = [];
            angular.forEach($scope.selectedFiles, function (value, key) {
                if (value) {
                    answer.push(key);
                }
            });
            return answer;
        };
        $scope.sendSelectedFiles = function () {
            var filesToSend = $scope.fileSelection();
            var fileCount = filesToSend.length;
            var version = $scope.container.versionId || "1.0";
            function onSendFileCompleted(response) {
                if (filesToSend.length) {
                    var fileName = filesToSend.pop();
                    if (fileName) {
                        var profile = $scope.profileFileNameToProfileId[fileName];
                        if (profile) {
                            var body = Fabric.getConfigFile(jolokia, version, profile, fileName);
                            if (!body) {
                                log.warn("No body for message " + fileName);
                                body = "";
                            }
                            doSendMessage(body, onSendFileCompleted);
                        }
                    }
                }
                else {
                    var text = Core.maybePlural(fileCount, "Message") + " sent!";
                    Core.notification("success", text);
                }
            }
            onSendFileCompleted(null);
        };
        function isCamelEndpoint() {
            return true;
        }
        function isJmsEndpoint() {
            return true;
        }
        function loadProfileConfigurationFiles() {
            if (Fabric.fabricCreated(workspace)) {
                $scope.container = Fabric.getCurrentContainer(jolokia, ['versionId', 'profileIds']);
                jolokia.execute(Fabric.managerMBean, "currentContainerConfigurationFiles", onSuccess(onFabricConfigFiles));
            }
        }
        function onFabricConfigFiles(response) {
            $scope.profileFileNameToProfileId = response;
            $scope.profileFileNames = Object.keys(response).filter(function (key) {
                return key.toLowerCase().startsWith('data/');
            }).sort();
            $scope.showChoose = $scope.profileFileNames.length ? true : false;
            $scope.selectedFiles = {};
            Core.$apply($scope);
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.SourceController", ["$scope", "workspace", function ($scope, workspace) {
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            setTimeout(updateRoutes, 50);
        });
        $scope.$watch('workspace.selection', function () {
            if (workspace.moveIfViewInvalid())
                return;
            updateRoutes();
        });
        $scope.mode = 'xml';
        function getSource(routeXmlNode) {
            function removeCrappyHeaders(idx, e) {
                var answer = e.getAttribute("customId");
                if (e.nodeName === 'route') {
                    answer = "true";
                }
                if (!answer || answer !== "true") {
                    e.removeAttribute("id");
                }
                e.removeAttribute("customId");
                e.removeAttribute("_cid");
                e.removeAttribute("group");
            }
            var copy = $(routeXmlNode).clone();
            copy.each(removeCrappyHeaders);
            copy.find("*").each(removeCrappyHeaders);
            var newNode = (copy && copy.length) ? copy[0] : routeXmlNode;
            return Core.xmlNodeToString(newNode);
        }
        function updateRoutes() {
            var routeXmlNode = Camel.getSelectedRouteNode(workspace);
            if (routeXmlNode) {
                $scope.source = getSource(routeXmlNode);
                Core.$apply($scope);
            }
            else {
                $scope.mbean = Camel.getSelectionCamelContextMBean(workspace);
                if (!$scope.mbean) {
                    var parent = Core.pathGet(workspace, ["selection", "parent"]);
                    if (parent && parent.title === "context") {
                        $scope.mbean = parent.children[0].objectName;
                    }
                }
                if ($scope.mbean) {
                    var jolokia = workspace.jolokia;
                    jolokia.request({ type: 'exec', mbean: $scope.mbean, operation: 'dumpRoutesAsXml()' }, onSuccess(populateTable));
                }
            }
        }
        var populateTable = function (response) {
            var data = response.value;
            var selectedRouteId = Camel.getSelectedRouteId(workspace);
            if (data && selectedRouteId) {
                var doc = $.parseXML(data);
                var routes = $(doc).find('route[id="' + selectedRouteId + '"]');
                if (routes && routes.length) {
                    var selectedRoute = routes[0];
                    var routeXml = getSource(selectedRoute);
                    if (routeXml) {
                        data = routeXml;
                    }
                }
            }
            $scope.source = data;
            Core.$apply($scope);
        };
        var saveWorked = function () {
            Core.notification("success", "Route updated!");
            Camel.clearSelectedRouteNode(workspace);
            updateRoutes();
        };
        $scope.saveRouteXml = function () {
            var routeXml = $scope.source;
            if (routeXml) {
                var decoded = decodeURIComponent(routeXml);
                Camel.log.debug("addOrUpdateRoutesFromXml xml decoded: " + decoded);
                var jolokia = workspace.jolokia;
                var mbean = Camel.getSelectionCamelContextMBean(workspace);
                if (mbean) {
                    jolokia.execute(mbean, "addOrUpdateRoutesFromXml(java.lang.String)", decoded, onSuccess(saveWorked));
                }
                else {
                    Core.notification("error", "Could not find CamelContext MBean!");
                }
            }
        };
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.TraceRouteController", ["$scope", "workspace", "jolokia", "localStorage", "tracerStatus", function ($scope, workspace, jolokia, localStorage, tracerStatus) {
        var log = Logger.get("CamelTracer");
        $scope.camelMaximumTraceOrDebugBodyLength = Camel.maximumTraceOrDebugBodyLength(localStorage);
        $scope.tracing = false;
        $scope.messages = [];
        $scope.graphView = null;
        $scope.tableView = null;
        $scope.mode = 'text';
        $scope.messageDialog = new UI.Dialog();
        $scope.gridOptions = Camel.createBrowseGridOptions();
        $scope.gridOptions.selectWithCheckboxOnly = false;
        $scope.gridOptions.showSelectionCheckbox = false;
        $scope.gridOptions.multiSelect = false;
        $scope.gridOptions.afterSelectionChange = onSelectionChanged;
        $scope.gridOptions.columnDefs.push({
            field: 'toNode',
            displayName: 'To Node'
        });
        $scope.startTracing = function () {
            log.info("Start tracing");
            setTracing(true);
        };
        $scope.stopTracing = function () {
            log.info("Stop tracing");
            setTracing(false);
        };
        $scope.clear = function () {
            log.debug("Clear messages");
            tracerStatus.messages = [];
            $scope.messages = [];
            Core.$apply($scope);
        };
        $scope.$watch('workspace.selection', function () {
            if (workspace.moveIfViewInvalid()) {
                return;
            }
            $scope.messages = tracerStatus.messages;
            reloadTracingFlag();
        });
        $scope.openMessageDialog = function (message) {
            var idx = Core.pathGet(message, ["rowIndex"]);
            $scope.selectRowIndex(idx);
            if ($scope.row) {
                $scope.mode = CodeEditor.detectTextFormat($scope.row.body);
                $scope.messageDialog.open();
            }
        };
        $scope.selectRowIndex = function (idx) {
            $scope.rowIndex = idx;
            var selected = $scope.gridOptions.selectedItems;
            selected.splice(0, selected.length);
            if (idx >= 0 && idx < $scope.messages.length) {
                $scope.row = $scope.messages[idx];
                if ($scope.row) {
                    selected.push($scope.row);
                }
            }
            else {
                $scope.row = null;
            }
            onSelectionChanged();
        };
        function reloadTracingFlag() {
            $scope.tracing = false;
            if (tracerStatus.jhandle != null) {
                log.debug("Unregistering jolokia handle");
                jolokia.unregister(tracerStatus.jhandle);
                tracerStatus.jhandle = null;
            }
            var mbean = Camel.getSelectionCamelTraceMBean(workspace);
            if (mbean) {
                $scope.tracing = jolokia.getAttribute(mbean, "Enabled", onSuccess(null));
                if ($scope.tracing) {
                    var traceMBean = mbean;
                    if (traceMBean) {
                        if (tracerStatus.jhandle === null) {
                            log.debug("Registering jolokia handle");
                            tracerStatus.jhandle = jolokia.register(populateRouteMessages, {
                                type: 'exec',
                                mbean: traceMBean,
                                operation: 'dumpAllTracedMessagesAsXml()',
                                ignoreErrors: true,
                                arguments: []
                            });
                        }
                    }
                    $scope.graphView = "app/camel/html/routes.html";
                    $scope.tableView = "app/camel/html/browseMessages.html";
                }
                else {
                    tracerStatus.messages = [];
                    $scope.messages = [];
                    $scope.graphView = null;
                    $scope.tableView = null;
                }
            }
        }
        function populateRouteMessages(response) {
            log.debug("Populating response " + response);
            var selectedRouteId = Camel.getSelectedRouteId(workspace);
            var xml = response.value;
            if (angular.isString(xml)) {
                var doc = $.parseXML(xml);
                var allMessages = $(doc).find("fabricTracerEventMessage");
                if (!allMessages || !allMessages.length) {
                    allMessages = $(doc).find("backlogTracerEventMessage");
                }
                allMessages.each(function (idx, message) {
                    var routeId = $(message).find("routeId").text();
                    if (routeId === selectedRouteId) {
                        var messageData = Camel.createMessageFromXml(message);
                        var toNode = $(message).find("toNode").text();
                        if (toNode) {
                            messageData["toNode"] = toNode;
                        }
                        log.debug("Adding new message to trace table with id " + messageData["id"]);
                        $scope.messages.push(messageData);
                    }
                });
                tracerStatus.messages = $scope.messages;
                Core.$apply($scope);
            }
        }
        function onSelectionChanged() {
            angular.forEach($scope.gridOptions.selectedItems, function (selected) {
                if (selected) {
                    var toNode = selected["toNode"];
                    if (toNode) {
                        var nodes = d3.select("svg").selectAll("g .node");
                        Camel.highlightSelectedNode(nodes, toNode);
                    }
                }
            });
        }
        function tracingChanged(response) {
            reloadTracingFlag();
            Core.$apply($scope);
        }
        function setTracing(flag) {
            var mbean = Camel.getSelectionCamelTraceMBean(workspace);
            if (mbean) {
                if (mbean.toString().endsWith("BacklogTracer")) {
                    var max = $scope.camelMaximumTraceOrDebugBodyLength;
                    jolokia.setAttribute(mbean, "BodyMaxChars", max);
                }
                jolokia.setAttribute(mbean, "Enabled", flag, onSuccess(tracingChanged));
            }
        }
        log.info("Re-activating tracer with " + tracerStatus.messages.length + " existing messages");
        $scope.messages = tracerStatus.messages;
        $scope.tracing = tracerStatus.jhandle != null;
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.TreeHeaderController", ["$scope", "$location", function ($scope, $location) {
        $scope.contextFilterText = '';
        $scope.$watch('contextFilterText', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.$emit("camel-contextFilterText", newValue);
            }
        });
        $scope.expandAll = function () {
            Tree.expandAll("#cameltree");
        };
        $scope.contractAll = function () {
            Tree.contractAll("#cameltree");
        };
    }]);
    Camel._module.controller("Camel.TreeController", ["$scope", "$location", "$timeout", "workspace", "$rootScope", function ($scope, $location, $timeout, workspace, $rootScope) {
        $scope.contextFilterText = $location.search()["cq"];
        $scope.fullScreenViewLink = Camel.linkToFullScreenView(workspace);
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            setTimeout(updateSelectionFromURL, 50);
        });
        var reloadThrottled = Core.throttled(reloadFunction, 500);
        $scope.$watch('workspace.tree', function () {
            reloadThrottled();
        });
        var reloadOnContextFilterThrottled = Core.throttled(function () {
            reloadFunction(function () {
                $("#camelContextIdFilter").focus();
            });
        }, 500);
        $scope.$watch('contextFilterText', function () {
            if ($scope.contextFilterText != $scope.lastContextFilterText) {
                $timeout(reloadOnContextFilterThrottled, 250);
            }
        });
        $rootScope.$on('camel-contextFilterText', function (event, value) {
            $scope.contextFilterText = value;
        });
        $scope.$on('jmxTreeUpdated', function () {
            reloadThrottled();
        });
        function reloadFunction(afterSelectionFn) {
            if (afterSelectionFn === void 0) { afterSelectionFn = null; }
            $scope.fullScreenViewLink = Camel.linkToFullScreenView(workspace);
            var children = [];
            var domainName = Camel.jmxDomain;
            var tree = workspace.tree;
            if (tree) {
                var rootFolder = new Folder("Camel Contexts");
                rootFolder.addClass = "org-apache-camel-context-folder";
                rootFolder.children = children;
                rootFolder.typeName = "context";
                rootFolder.key = "camelContexts";
                rootFolder.domain = domainName;
                var contextFilterText = $scope.contextFilterText;
                $scope.lastContextFilterText = contextFilterText;
                Camel.log.debug("Reloading the tree for filter: " + contextFilterText);
                var folder = tree.get(domainName);
                if (folder) {
                    angular.forEach(folder.children, function (value, key) {
                        var entries = value.map;
                        if (entries) {
                            var contextsFolder = entries["context"];
                            var routesNode = entries["routes"];
                            var endpointsNode = entries["endpoints"];
                            if (contextsFolder) {
                                var contextNode = contextsFolder.children[0];
                                if (contextNode) {
                                    var title = contextNode.title;
                                    var match = Core.matchFilterIgnoreCase(title, contextFilterText);
                                    if (match) {
                                        var folder = new Folder(title);
                                        folder.addClass = "org-apache-camel-context";
                                        folder.domain = domainName;
                                        folder.objectName = contextNode.objectName;
                                        folder.entries = contextNode.entries;
                                        folder.typeName = contextNode.typeName;
                                        folder.key = contextNode.key;
                                        folder.version = contextNode.version;
                                        if (routesNode) {
                                            var routesFolder = new Folder("Routes");
                                            routesFolder.addClass = "org-apache-camel-routes-folder";
                                            routesFolder.parent = contextsFolder;
                                            routesFolder.children = routesNode.children;
                                            angular.forEach(routesFolder.children, function (n) { return n.addClass = "org-apache-camel-routes"; });
                                            folder.children.push(routesFolder);
                                            routesFolder.typeName = "routes";
                                            routesFolder.key = routesNode.key;
                                            routesFolder.domain = routesNode.domain;
                                        }
                                        if (endpointsNode) {
                                            var endpointsFolder = new Folder("Endpoints");
                                            endpointsFolder.addClass = "org-apache-camel-endpoints-folder";
                                            endpointsFolder.parent = contextsFolder;
                                            endpointsFolder.children = endpointsNode.children;
                                            angular.forEach(endpointsFolder.children, function (n) {
                                                n.addClass = "org-apache-camel-endpoints";
                                                if (!Camel.getContextId(n)) {
                                                    n.entries["context"] = contextNode.entries["context"];
                                                }
                                            });
                                            folder.children.push(endpointsFolder);
                                            endpointsFolder.entries = contextNode.entries;
                                            endpointsFolder.typeName = "endpoints";
                                            endpointsFolder.key = endpointsNode.key;
                                            endpointsFolder.domain = endpointsNode.domain;
                                        }
                                        var jmxNode = new Folder("MBeans");
                                        angular.forEach(entries, function (jmxChild, name) {
                                            if (name !== "context" && name !== "routes" && name !== "endpoints") {
                                                jmxNode.children.push(jmxChild);
                                            }
                                        });
                                        if (jmxNode.children.length > 0) {
                                            jmxNode.sortChildren(false);
                                            folder.children.push(jmxNode);
                                        }
                                        folder.parent = rootFolder;
                                        children.push(folder);
                                    }
                                }
                            }
                        }
                    });
                }
                var treeElement = $("#cameltree");
                Jmx.enableTree($scope, $location, workspace, treeElement, [rootFolder], true);
                setTimeout(function () {
                    updateSelectionFromURL();
                    if (angular.isFunction(afterSelectionFn)) {
                        afterSelectionFn();
                    }
                }, 50);
            }
        }
        function updateSelectionFromURL() {
            Jmx.updateTreeSelectionFromURLAndAutoSelect($location, $("#cameltree"), function (first) {
                var contexts = first.getChildren();
                if (contexts && contexts.length === 1) {
                    first = contexts[0];
                    first.expand(true);
                    var children = first.getChildren();
                    if (children && children.length) {
                        var routes = children[0];
                        if (routes.data.typeName === 'routes') {
                            first = routes;
                            return first;
                        }
                    }
                }
                return null;
            }, true);
            $scope.fullScreenViewLink = Camel.linkToFullScreenView(workspace);
        }
    }]);
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel._module.controller("Camel.TypeConverterController", ["$scope", "$location", "workspace", "jolokia", function ($scope, $location, workspace, jolokia) {
        $scope.data = [];
        $scope.selectedMBean = null;
        $scope.mbeanAttributes = {};
        var columnDefs = [
            {
                field: 'from',
                displayName: 'From',
                cellFilter: null,
                width: "*",
                resizable: true
            },
            {
                field: 'to',
                displayName: 'To',
                cellFilter: null,
                width: "*",
                resizable: true
            }
        ];
        $scope.gridOptions = {
            data: 'data',
            displayFooter: true,
            displaySelectionCheckbox: false,
            canSelectRows: false,
            enableSorting: true,
            columnDefs: columnDefs,
            selectedItems: [],
            filterOptions: {
                filterText: ''
            }
        };
        function onAttributes(response) {
            var obj = response.value;
            if (obj) {
                $scope.mbeanAttributes = obj;
                Core.$apply($scope);
            }
        }
        function onConverters(response) {
            var obj = response.value;
            if (obj) {
                var arr = [];
                for (var key in obj) {
                    var values = obj[key];
                    for (var v in values) {
                        arr.push({ from: key, to: v });
                    }
                }
                arr = arr.sortBy("from");
                $scope.data = arr;
                $scope.selectedMBean = response.request.mbean;
                Core.$apply($scope);
            }
        }
        $scope.renderIcon = function (state) {
            return Camel.iconClass(state);
        };
        $scope.disableStatistics = function () {
            if ($scope.selectedMBean) {
                jolokia.setAttribute($scope.selectedMBean, "StatisticsEnabled", false);
            }
        };
        $scope.enableStatistics = function () {
            if ($scope.selectedMBean) {
                jolokia.setAttribute($scope.selectedMBean, "StatisticsEnabled", true);
            }
        };
        $scope.resetStatistics = function () {
            if ($scope.selectedMBean) {
                jolokia.request({ type: 'exec', mbean: $scope.selectedMBean, operation: 'resetTypeConversionCounters' }, onSuccess(null, { silent: true }));
            }
        };
        function loadConverters() {
            console.log("Loading TypeConverter data...");
            var mbean = Camel.getSelectionCamelTypeConverter(workspace);
            if (mbean) {
                var query = { type: "read", mbean: mbean, attribute: ["AttemptCounter", "FailedCounter", "HitCounter", "MissCounter", "NumberOfTypeConverters", "StatisticsEnabled"] };
                jolokia.request(query, onSuccess(onAttributes));
                scopeStoreJolokiaHandle($scope, jolokia, jolokia.register(onAttributes, query));
                jolokia.request({ type: 'exec', mbean: mbean, operation: 'listTypeConverters' }, onSuccess(onConverters));
            }
        }
        loadConverters();
    }]);
})(Camel || (Camel = {}));
var Camin;
(function (Camin) {
    var pluginName = 'camin';
    Camin._module = angular.module(pluginName, ['bootstrap', 'ngResource', 'ngGrid', 'hawtioCore', 'elasticjs.service']);
    Camin._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/camin', { templateUrl: 'app/camin/html/camin.html' }).when('/camin/:exchangeId', { templateUrl: 'app/camin/html/camin.html' });
    }]);
    Camin._module.run(["workspace", "viewRegistry", "helpRegistry", function (workspace, viewRegistry, helpRegistry) {
        viewRegistry["camin"] = "app/camin/html/layoutCamin.html";
        helpRegistry.addUserDoc('camin', 'app/camin/doc/help.md', function () {
            return Fabric.hasFabric(workspace);
        });
        workspace.topLevelTabs.push({
            id: "camin",
            content: "Camel",
            title: "Insight into Camel",
            isValid: function (workspace) { return Fabric.hasFabric(workspace); },
            href: function () { return "#/camin"; },
            isActive: function (workspace) { return workspace.isLinkActive("camin"); }
        });
    }]);
    hawtioPluginLoader.addModule(pluginName);
})(Camin || (Camin = {}));
var Camin;
(function (Camin) {
    Camin._module.controller("Camin.Controller", ["$scope", "jolokia", "localStorage", "$routeParams", "ejsResource", function ($scope, jolokia, localStorage, $routeParams, ejsResource) {
        $scope.query = "";
        $scope.breadcrumbs = [];
        $scope.onQueryChange = function () {
            $scope.breadcrumbs = [$scope.query];
            searchRequest();
        };
        var log = Logger.get("Camin");
        var esUrl = new Jolokia(Core.getJolokiaUrl()).execute("io.fabric8.insight:type=Elasticsearch", "getRestUrl", "insight");
        var esClient = ejsResource(esUrl);
        var searchRequest = function () {
            var queryStr = "exchange.id:\"" + $scope.breadcrumbs.join("\" OR exchange.id:\"") + "\" OR " + "exchange.in.headers.ExtendedBreadcrumb:\"" + $scope.breadcrumbs.join("\" OR exchange.in.headers.ExtendedBreadcrumb:\"") + "\" OR " + "exchange.out.headers.ExtendedBreadcrumb:\"" + $scope.breadcrumbs.join("\" OR exchange.out.headers.ExtendedBreadcrumb:\"") + "\"";
            var request = ejs.Request().types('camel');
            var searchPromise = request.from(0).size(1000).query(ejs.QueryStringQuery(queryStr)).doSearch();
            searchPromise.then(function (data) {
                if (!(angular.isUndefined(data.error))) {
                    log.error(data.error);
                    return;
                }
                log.debug("Results", data);
                var oldsize = $scope.breadcrumbs.length;
                for (var i = 0; i < data.hits.hits.length; i++) {
                    var concat = function (breadcrumbs) {
                        if (breadcrumbs) {
                            if (typeof breadcrumbs === 'string') {
                                breadcrumbs = [breadcrumbs];
                            }
                            for (var j = 0; j < breadcrumbs.length; j++) {
                                var id = breadcrumbs[j];
                                if ($scope.breadcrumbs.indexOf(id) < 0) {
                                    $scope.breadcrumbs.push(id);
                                }
                            }
                        }
                    };
                    if (angular.isDefined(data.hits.hits[i]._source.exchange.in)) {
                        concat(data.hits.hits[i]._source.exchange.in.headers.ExtendedBreadcrumb);
                    }
                    if (angular.isDefined(data.hits.hits[i]._source.exchange.out)) {
                        concat(data.hits.hits[i]._source.exchange.out.headers.ExtendedBreadcrumb);
                    }
                }
                log.debug("Found " + data.hits.total + " ids");
                if (oldsize != $scope.breadcrumbs.length) {
                    searchRequest();
                }
                else {
                    var ids = [];
                    for (var i = 0; i < data.hits.hits.length; i++) {
                        var id = data.hits.hits[i]._id;
                        if (ids.indexOf(id) < 0) {
                            ids.push(id);
                        }
                    }
                    var idSearchRequest = ejs.Request().types('camel');
                    var idSearchPromise = idSearchRequest.from(0).size(1000).query(ejs.MatchAllQuery()).filter(ejs.IdsFilter(ids)).sort('@timestamp').doSearch();
                    idSearchPromise.then(function (data) {
                        if (!(angular.isUndefined(data.error))) {
                            log.error(data.error);
                            return;
                        }
                        log.debug("Found " + data.hits.total + " exchanges");
                        var events = [];
                        for (var i = 0; i < data.hits.hits.length; i++) {
                            var e = data.hits.hits[i]._source;
                            events.push(e);
                        }
                        draw(events);
                    });
                }
            });
        };
        var isoDate = function (date) {
            var timestamp, struct, minutesOffset = 0;
            var numericKeys = [1, 4, 5, 6, 7, 10, 11];
            if ((struct = /^(\d{4}|[+\-]\d{6})(?:-(\d{2})(?:-(\d{2}))?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(?:\.(\d{3}))?)?(?:(Z)|([+\-])(\d{2})(?::(\d{2}))?)?)?$/.exec(date))) {
                for (var i = 0, k; (k = numericKeys[i]); ++i) {
                    struct[k] = +struct[k] || 0;
                }
                struct[2] = (+struct[2] || 1) - 1;
                struct[3] = +struct[3] || 1;
                if (struct[8] !== 'Z' && struct[9] !== undefined) {
                    minutesOffset = struct[10] * 60 + struct[11];
                    if (struct[9] === '+') {
                        minutesOffset = 0 - minutesOffset;
                    }
                }
                timestamp = Date.UTC(struct[1], struct[2], struct[3], struct[4], struct[5] + minutesOffset, struct[6], struct[7]);
            }
            else {
                timestamp = Date.parse(date);
            }
            return timestamp;
        };
        var buildSequence = function (events) {
            var sequence = new Camin.Sequence();
            var exchangeToExec = {};
            events = events.sort(function (a, b) {
                return isoDate(a['@timestamp']) - isoDate(b['@timestamp']);
            });
            for (var i = 0; i < events.length; i++) {
                if (events[i].event === 'Created') {
                    var evtCreated = events[i];
                    var evtCompleted = _.find(events, function (value, index) {
                        return value.event === 'Completed' && evtCreated.exchange.id === value.exchange.id;
                    });
                    if (evtCompleted === null) {
                        log.debug('Could not find matching Completed exchange for ' + evtCreated.exchange.id);
                        continue;
                    }
                    var endpoint = sequence.endpoint(evtCompleted.exchange.fromEndpoint, evtCompleted.exchange.routeId, evtCompleted.exchange.contextId, evtCompleted.host);
                    var exec = sequence.exec(evtCreated.exchange.id, endpoint, isoDate(evtCreated['@timestamp']), isoDate(evtCompleted['@timestamp']));
                    exchangeToExec[evtCreated.exchange.id] = exec;
                }
            }
            var calls = {};
            for (var i = 0; i < events.length; i++) {
                if (events[i].event === 'Sending' && events[i].exchange.in && events[i].exchange.in.headers) {
                    var callId = events[i].exchange.in.headers.AuditCallId;
                    if (callId && calls[callId] === undefined) {
                        var evtSending = events[i];
                        var evtSent = _.find(events, function (value, index) {
                            return value.event === 'Sent' && evtSending.exchange.id === value.exchange.id && value.exchange.in.headers.AuditCallId === callId;
                        });
                        var evtCreated = _.find(events, function (value, index) {
                            return value.event === 'Created' && evtSending.exchange.id !== value.exchange.id && value.exchange.in.headers.AuditCallId === callId;
                        });
                        var execA = exchangeToExec[evtSending.exchange.id];
                        var execB = evtCreated ? exchangeToExec[evtCreated.exchange.id] : null;
                        if (evtSent !== null && evtCreated !== null && execA !== null && execB != null) {
                            var call = sequence.call(callId, execA, execB, isoDate(evtSending['@timestamp']), isoDate(evtSent['@timestamp']));
                            calls[callId] = call;
                        }
                        else {
                            log.debug("Could not find Execution for exchange " + evtSending.exchange.id);
                        }
                    }
                }
            }
            return sequence;
        };
        var buildDiagram = function (sequence) {
            var diagram = new Camin.Diagram();
            var actors = {};
            var signals = [];
            var base = sequence.start();
            for (var i = 0; i < sequence.endpoints.length; i++) {
                var actor = diagram.actor("ep" + i);
                var ep = sequence.endpoints[i];
                var key = ep.url + "|" + ep.routeId + "|" + ep.contextId + "|" + ep.host;
                actors[key] = actor;
            }
            for (var i = 0; i < sequence.calls.length; i++) {
                var call = sequence.calls[i];
                if (call.execB) {
                    var epA = call.execA.endpoint;
                    var keyA = epA.url + "|" + epA.routeId + "|" + epA.contextId + "|" + epA.host;
                    var epB = call.execB.endpoint;
                    var keyB = epB.url + "|" + epB.routeId + "|" + epB.contextId + "|" + epB.host;
                    var actorA = actors[keyA];
                    var actorB = actors[keyB];
                    var start1 = call.start - base;
                    var stop1 = call.execB.start - base;
                    var start2 = call.execB.stop - base;
                    var stop2 = call.stop - base;
                    signals.push({ actorA: actorA, actorB: actorB, message: start1 + "ms - " + stop1 + "ms", timestamp: start1 });
                    signals.push({ actorA: actorB, actorB: actorA, message: start2 + "ms - " + stop2 + "ms", timestamp: start2 });
                }
            }
            signals = signals.sort(function (a, b) {
                return a['@timestamp'] - b['@timestamp'];
            });
            for (var i = 0; i < signals.length; i++) {
                diagram.signal(signals[i].actorA, signals[i].actorB, signals[i].message);
            }
            return diagram;
        };
        var buildGantt = function (sequence) {
            var gantt = new Camin.Gantt();
            for (var i = 0; i < sequence.endpoints.length; i++) {
                var endpoint = sequence.endpoints[i];
                var resource = gantt.resource(endpoint);
                for (var j = 0; j < sequence.execs.length; j++) {
                    var exec = sequence.execs[j];
                    if (exec.endpoint === endpoint) {
                        gantt.task(resource, exec.start, exec.stop, exec);
                    }
                }
            }
            for (var i = 0; i < sequence.calls.length; i++) {
                var call = sequence.calls[i];
                if (call.execB) {
                    var taskA = gantt.taskByData(call.execA);
                    var taskB = gantt.taskByData(call.execB);
                    gantt.link(call.start, taskA, call.stop, taskB, call);
                }
            }
            gantt.layout();
            return gantt;
        };
        var eventTypeValue = { "Created": 0, "Sending": 1, "Sent": 2, "Completed": 3 };
        var draw = function (events) {
            $scope.definition = "";
            events = events.sort(function (a, b) {
                return isoDate(a['@timestamp']) - isoDate(b['@timestamp']);
            });
            log.debug("Events", events);
            var sequence = buildSequence(events);
            log.debug("Sequence", sequence);
            var gantt = buildGantt(sequence);
            log.debug("Gantt", gantt);
            $('#gantt').html('');
            drawGantt('#gantt', gantt);
            var diagram = buildDiagram(sequence);
            log.debug("Diagram", diagram);
            $('#diagram').html('');
            drawDiagram('#diagram', diagram);
        };
        var drawDiagram = function (container, diagram) {
            var arrow_size = 10;
            var margin = 10;
            var actor_width = 100;
            var actor_margin = 30;
            var actor_height = 40;
            var signal_height = 30;
            var actor_font = 20;
            var signal_font = 14;
            var width = diagram.actors.length * (actor_width + actor_margin * 2);
            var height = (diagram.signals.length + 1) * signal_height + actor_height * 2 + margin * 2;
            var svg = d3.select(container).append('svg').attr('width', width + 2 * margin).attr('height', height + 2 * margin);
            var g = svg.append('g').attr('text-anchor', 'middle');
            for (var i = 0; i < diagram.actors.length; i++) {
                var actor = diagram.actors[i];
                var gu = g.append('g').attr('transform', 'translate(' + (i * (actor_width + actor_margin * 2) + actor_margin) + ',' + actor_height + ')');
                gu.append('rect').attr('width', actor_width).attr('height', actor_height).attr('stroke', '#000').attr('stroke-width', '2').attr('fill', '#FFFFFF');
                gu.append('text').attr('x', actor_width / 2).attr('y', actor_height / 2).attr('stroke-width', '0').attr('dominant-baseline', 'middle').attr('font-size', actor_font).text(actor.name);
                g.append('line').attr('x1', i * (actor_width + actor_margin * 2) + actor_width / 2 + actor_margin).attr('y1', actor_height * 2).attr('x2', i * (actor_width + actor_margin * 2) + actor_width / 2 + actor_margin).attr('y2', height - actor_height).attr('stroke', '#000').attr('stroke-width', '2');
                var gu = g.append('g').attr('transform', 'translate(' + (i * (actor_width + actor_margin * 2) + actor_margin) + ',' + (height - actor_height) + ')');
                gu.append('rect').attr('width', actor_width).attr('height', actor_height).attr('stroke', '#000').attr('stroke-width', '2').attr('fill', 'white');
                gu.append('text').attr('x', actor_width / 2).attr('y', actor_height / 2).attr('stroke-width', '0').attr('dominant-baseline', 'middle').attr('font-size', actor_font).text(actor.name);
            }
            for (var i = 0; i < diagram.signals.length; i++) {
                var x;
                var y;
                var length;
                var direction;
                var text;
                x = diagram.signals[i].actorA.index * (actor_width + actor_margin * 2) + actor_width / 2 + actor_margin;
                y = (i + 1) * signal_height + actor_height * 2;
                length = Math.abs(diagram.signals[i].actorA.index - diagram.signals[i].actorB.index) * (actor_width + actor_margin * 2);
                direction = diagram.signals[i].actorB.index > diagram.signals[i].actorA.index ? +1 : -1;
                text = diagram.signals[i].message;
                var gu = g.append('g').attr('transform', 'translate(' + x + ',' + y + ')').attr('stroke-width', '2');
                gu.append('rect').attr('x', Math.min(3, length * direction + 3)).attr('y', '-16').attr('width', Math.abs((length - 6) * direction)).attr('height', '19').attr('stroke', 'white').attr('stroke-width', '0').attr('fill', 'white');
                gu.append('line').attr('x1', 0).attr('y1', 0).attr('x2', length * direction).attr('y2', 0).attr('stroke', '#000').attr('stroke-width', '2');
                gu.append('line').attr('x1', length * direction - arrow_size * direction).attr('y1', -arrow_size).attr('x2', length * direction).attr('y2', 0).attr('stroke', '#000').attr('stroke-width', '2');
                gu.append('line').attr('x1', length * direction).attr('y1', 0).attr('x2', length * direction - arrow_size * direction).attr('y2', arrow_size).attr('stroke', '#000').attr('stroke-width', '2');
                gu.append('text').attr('x', length * direction / 2).attr('y', -8).attr('stroke-width', '0').attr('dominant-baseline', 'middle').attr('font-size', signal_font).text(text);
            }
        };
        var drawGantt = function (container, gantt) {
            var lineHeight = 35;
            var lineMargin = 3;
            var arrowWidth = 4;
            var width = 800;
            var height = lineHeight * gantt.resources.length;
            var margin = {
                top: 20,
                right: 40,
                bottom: 20,
                left: 250
            };
            var begin = gantt.start;
            var end = gantt.stop;
            var x = d3.scale.linear().domain([begin - (end - begin) * 0.1, end + (end - begin) * 0.1]).range([0, width]);
            var yt = function (t) {
                return t.resource.index * lineHeight + lineMargin + t.index * (lineHeight - 2 * lineMargin) / (t.max + 1);
            };
            var ht = function (t) {
                return 2 * (lineHeight - 2 * lineMargin) / (t.max + 1);
            };
            var svg = d3.select(container).append('svg').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom);
            var text = svg.append('g').attr('width', width).attr('height', height).attr('transform', 'translate(0,' + margin.top + ')').selectAll('text').data(gantt.resources).enter();
            text.append('text').attr('x', 0).attr('y', function (r) {
                return r.index * lineHeight + lineHeight / 2;
            }).attr('dy', '-0.2em').attr('text-anchor', 'start').text(function (r) {
                var endpoint = r.data;
                var text = endpoint.url;
                if (text.indexOf("Endpoint[") == 0) {
                    text = text.substring(9, text.length - 1);
                }
                return text;
            });
            text.append('text').attr('x', 0).attr('y', function (r) {
                return r.index * lineHeight + lineHeight / 2;
            }).attr('dy', '0.8em').attr('text-anchor', 'start').text(function (r) {
                var endpoint = r.data;
                return endpoint.host + "/" + endpoint.contextId + "/" + endpoint.routeId;
            });
            var g = svg.append('g').attr('width', width).attr('height', height).attr('transform', 'translate(' + margin.left + ',' + margin.top + ')');
            g.append('g').attr('width', width).attr('height', height).selectAll('rect').data(gantt.tasks).enter().append('rect').attr('rx', lineMargin * 2).attr('ry', lineMargin * 2).attr('x', function (t) {
                return x(t.start);
            }).attr('y', yt).attr('height', ht).attr('width', function (t) {
                return x(t.stop) - x(t.start);
            }).attr('stroke', '#000000').attr('stroke-width', '2').attr('fill', function (t) {
                return d3.hsl(Math.random() * 360, 0.8, 0.8).toString();
            });
            var lines = g.append('g').attr('width', width).attr('height', height).attr('stroke', '#404040').attr('stroke-width', '2').selectAll('line').data(gantt.links).enter();
            lines.append('line').attr('x1', function (l) {
                return x(l.start);
            }).attr('y1', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            }).attr('x2', function (l) {
                return x(l.start);
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.start);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.taskB.start);
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.taskB.start);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.taskB.start) - arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2 - arrowWidth;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.taskB.start);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.taskB.start) - arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2 + arrowWidth;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.taskB.stop);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.stop);
            }).attr('y2', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.stop);
            }).attr('y1', function (l) {
                return yt(l.taskB) + ht(l.taskB) / 2;
            }).attr('x2', function (l) {
                return x(l.stop);
            }).attr('y2', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.stop);
            }).attr('y1', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            }).attr('x2', function (l) {
                return x(l.stop) - arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskA) + ht(l.taskA) + arrowWidth;
            });
            lines.append('line').attr('x1', function (l) {
                return x(l.stop);
            }).attr('y1', function (l) {
                return yt(l.taskA) + ht(l.taskA);
            }).attr('x2', function (l) {
                return x(l.stop) + arrowWidth;
            }).attr('y2', function (l) {
                return yt(l.taskA) + ht(l.taskA) + arrowWidth;
            });
        };
        if ($routeParams["exchangeId"]) {
            $scope.query = $routeParams["exchangeId"];
            $scope.onQueryChange();
        }
    }]);
})(Camin || (Camin = {}));
var Camin;
(function (Camin) {
    var Diagram = (function () {
        function Diagram() {
            this.actors = [];
            this.signals = [];
        }
        Diagram.prototype.actor = function (name) {
            for (var i = 0; i < this.actors.length; i++) {
                if (this.actors[i].name === name) {
                    return this.actors[i];
                }
            }
            var actor = new Actor(name, this.actors.length);
            this.actors.push(actor);
            return actor;
        };
        Diagram.prototype.signal = function (actorA, actorB, message) {
            var signal = new Signal(actorA, actorB, message);
            this.signals.push(signal);
            return signal;
        };
        return Diagram;
    })();
    Camin.Diagram = Diagram;
    var Actor = (function () {
        function Actor(name, index) {
            this.name = name;
            this.index = index;
        }
        return Actor;
    })();
    Camin.Actor = Actor;
    var Signal = (function () {
        function Signal(actorA, actorB, message) {
            this.actorA = actorA;
            this.actorB = actorB;
            this.message = message;
        }
        Signal.prototype.isSelf = function () {
            return this.actorA.index === this.actorB.index;
        };
        return Signal;
    })();
    Camin.Signal = Signal;
})(Camin || (Camin = {}));
var Camin;
(function (Camin) {
    var Gantt = (function () {
        function Gantt() {
            this.resources = [];
            this.tasks = [];
            this.links = [];
        }
        Gantt.prototype.resource = function (data) {
            var resource = new Resource(data, this.resources.length);
            this.resources.push(resource);
            return resource;
        };
        Gantt.prototype.task = function (resource, start, stop, data) {
            var task = resource.task(start, stop, data);
            this.tasks.push(task);
            return task;
        };
        Gantt.prototype.link = function (start, taskA, stop, taskB, data) {
            var link = new Link(start, taskA, stop, taskB, data);
            this.links.push(link);
            return link;
        };
        Gantt.prototype.layout = function () {
            for (var i = 0; i < this.resources.length; i++) {
                this.resources[i].layout();
                this.start = this.start ? Math.min(this.start, this.resources[i].start) : this.resources[i].start;
                this.stop = this.stop ? Math.max(this.stop, this.resources[i].stop) : this.resources[i].stop;
            }
            for (var i = 0; i < this.links.length; i++) {
                this.start = this.start ? Math.min(this.start, this.links[i].start) : this.links[i].start;
                this.stop = this.stop ? Math.max(this.stop, this.links[i].stop) : this.links[i].stop;
            }
        };
        Gantt.prototype.taskByData = function (data) {
            for (var i = 0; i < this.tasks.length; i++) {
                if (this.tasks[i].data === data) {
                    return this.tasks[i];
                }
            }
            return undefined;
        };
        return Gantt;
    })();
    Camin.Gantt = Gantt;
    var Resource = (function () {
        function Resource(data, index) {
            this.tasks = [];
            this.index = index;
            this.data = data;
        }
        Resource.prototype.task = function (start, stop, data) {
            var task = new Task(start, stop, data, this);
            this.tasks.push(task);
            return task;
        };
        Resource.prototype.layout = function () {
            this.tasks.sort(function (ta, tb) {
                return ta.start - tb.start;
            });
            var bands = [];
            for (var i = 0; i < this.tasks.length; i++) {
                this.start = this.start ? Math.min(this.start, this.tasks[i].start) : this.tasks[i].start;
                this.stop = this.stop ? Math.max(this.stop, this.tasks[i].stop) : this.tasks[i].stop;
                for (var j = 0; j < bands.length; j++) {
                    if (bands[j] < this.tasks[i].start) {
                        bands[j] = this.tasks[i].stop;
                        this.tasks[i].index = j;
                        break;
                    }
                }
                if (!this.tasks[i].index) {
                    var index = bands.length;
                    this.tasks[i].index = index;
                    bands[index] = this.tasks[i].stop;
                }
            }
            for (var i = 0; i < this.tasks.length; i++) {
                this.tasks[i].max = bands.length;
            }
        };
        return Resource;
    })();
    Camin.Resource = Resource;
    var Task = (function () {
        function Task(start, stop, data, resource) {
            this.start = start;
            this.stop = stop;
            this.data = data;
            this.resource = resource;
        }
        return Task;
    })();
    Camin.Task = Task;
    var Link = (function () {
        function Link(start, taskA, stop, taskB, data) {
            this.start = start;
            this.stop = stop;
            this.taskA = taskA;
            this.taskB = taskB;
            this.data = data;
        }
        return Link;
    })();
    Camin.Link = Link;
})(Camin || (Camin = {}));
var Camin;
(function (Camin) {
    var Sequence = (function () {
        function Sequence() {
            this.endpoints = [];
            this.execs = [];
            this.calls = [];
        }
        Sequence.prototype.endpoint = function (url, routeId, contextId, host) {
            for (var i = 0; i < this.endpoints.length; i++) {
                if (this.endpoints[i].url === url && this.endpoints[i].routeId === routeId && this.endpoints[i].contextId === contextId && this.endpoints[i].host === host) {
                    return this.endpoints[i];
                }
            }
            var endpoint = new Endpoint(url, routeId, contextId, host);
            this.endpoints.push(endpoint);
            return endpoint;
        };
        Sequence.prototype.exec = function (exchangeId, endpoint, start, stop) {
            var exec = new Execution(exchangeId, endpoint, start, stop);
            this.execs.push(exec);
            return exec;
        };
        Sequence.prototype.call = function (callId, execA, execB, start, stop) {
            var call = new Call(callId, execA, execB, start, stop);
            this.calls.push(call);
            return call;
        };
        Sequence.prototype.start = function () {
            var start;
            for (var i = 0; i < this.execs.length; i++) {
                start = start ? Math.min(start, this.execs[i].start) : this.execs[i].start;
            }
            for (var i = 0; i < this.calls.length; i++) {
                start = start ? Math.min(start, this.calls[i].start) : this.calls[i].start;
            }
            return start;
        };
        Sequence.prototype.stop = function () {
            var stop;
            for (var i = 0; i < this.execs.length; i++) {
                stop = stop ? Math.max(stop, this.execs[i].stop) : this.execs[i].stop;
            }
            for (var i = 0; i < this.calls.length; i++) {
                stop = stop ? Math.max(stop, this.calls[i].stop) : this.calls[i].stop;
            }
            return stop;
        };
        return Sequence;
    })();
    Camin.Sequence = Sequence;
    var Endpoint = (function () {
        function Endpoint(url, routeId, contextId, host) {
            this.url = url;
            this.routeId = routeId;
            this.contextId = contextId;
            this.host = host;
        }
        return Endpoint;
    })();
    Camin.Endpoint = Endpoint;
    var Execution = (function () {
        function Execution(exchangeId, endpoint, start, stop) {
            this.exchangeId = exchangeId;
            this.endpoint = endpoint;
            this.start = start;
            this.stop = stop;
        }
        return Execution;
    })();
    Camin.Execution = Execution;
    var Call = (function () {
        function Call(callId, execA, execB, start, stop) {
            this.callId = callId;
            this.execA = execA;
            this.execB = execB;
            this.start = start;
            this.stop = stop;
        }
        return Call;
    })();
    Camin.Call = Call;
})(Camin || (Camin = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.AboutController", ["$scope", "$location", "jolokia", "branding", "localStorage", function ($scope, $location, jolokia, branding, localStorage) {
        var log = Logger.get("About");
        $.ajax({
            url: "app/core/doc/about.md",
            dataType: 'html',
            cache: false,
            success: function (data, textStatus, jqXHR) {
                $scope.html = "Unable to download about.md";
                if (angular.isDefined(data)) {
                    $scope.html = marked(data);
                    $scope.branding = branding;
                    $scope.customBranding = branding.enabled;
                    try {
                        $scope.hawtioVersion = jolokia.request({
                            type: "read",
                            mbean: "hawtio:type=About",
                            attribute: "HawtioVersion"
                        }).value;
                    }
                    catch (Error) {
                        $scope.hawtioVersion = "N/A";
                    }
                    $scope.jolokiaVersion = jolokia.version().agent;
                    $scope.serverProduct = jolokia.version().info.product;
                    $scope.serverVendor = jolokia.version().info.vendor;
                    $scope.serverVersion = jolokia.version().info.version;
                }
                Core.$apply($scope);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $scope.html = "Unable to download about.md";
                Core.$apply($scope);
            }
        });
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    function parsePreferencesJson(value, key) {
        var answer = null;
        if (angular.isDefined(value)) {
            answer = Core.parseJsonText(value, "localStorage for " + key);
        }
        return answer;
    }
    Core.parsePreferencesJson = parsePreferencesJson;
    function configuredPluginsForPerspectiveId(perspectiveId, workspace, jolokia, localStorage) {
        var topLevelTabs = Perspective.topLevelTabsForPerspectiveId(workspace, perspectiveId);
        if (topLevelTabs && topLevelTabs.length > 0) {
            topLevelTabs = topLevelTabs.filter(function (tab) {
                var href = undefined;
                if (angular.isFunction(tab.href)) {
                    href = tab.href();
                }
                else if (angular.isString(tab.href)) {
                    href = tab.href;
                }
                return href && isValidFunction(workspace, tab.isValid, perspectiveId);
            });
            var id = "plugins-" + perspectiveId;
            var initPlugins = parsePreferencesJson(localStorage[id], id);
            if (initPlugins) {
                initPlugins = initPlugins.filter(function (p) {
                    return topLevelTabs.some(function (tab) { return tab.id === p.id; });
                });
                topLevelTabs.forEach(function (tab) {
                    var knownPlugin = initPlugins.some(function (p) { return p.id === tab.id; });
                    if (!knownPlugin) {
                        Core.log.info("Discovered new plugin in JVM since loading configuration: " + tab.id);
                        initPlugins.push({ id: tab.id, index: -1, displayName: tab.content, enabled: true, isDefault: false });
                    }
                });
            }
            else {
                initPlugins = topLevelTabs;
            }
        }
        var answer = safeTabsToPlugins(initPlugins);
        return answer;
    }
    Core.configuredPluginsForPerspectiveId = configuredPluginsForPerspectiveId;
    function safeTabsToPlugins(tabs) {
        var answer = [];
        if (tabs) {
            tabs.forEach(function (tab, idx) {
                var name;
                if (angular.isUndefined(tab.displayName)) {
                    name = tab.content;
                }
                else {
                    name = tab.displayName;
                }
                var enabled;
                if (angular.isUndefined(tab.enabled)) {
                    enabled = true;
                }
                else {
                    enabled = tab.enabled;
                }
                var isDefault;
                if (angular.isUndefined(tab.isDefault)) {
                    isDefault = false;
                }
                else {
                    isDefault = tab.isDefault;
                }
                answer.push({ id: tab.id, index: idx, displayName: name, enabled: enabled, isDefault: isDefault });
            });
        }
        return answer;
    }
    Core.safeTabsToPlugins = safeTabsToPlugins;
    function filterTopLevelTabs(perspective, workspace, configuredPlugins) {
        var topLevelTabs = Perspective.topLevelTabsForPerspectiveId(workspace, perspective);
        if (perspective === "website")
            return topLevelTabs;
        var result = [];
        configuredPlugins.forEach(function (p) {
            if (p.enabled) {
                var pid = p.id;
                var tab = null;
                if (pid) {
                    tab = topLevelTabs.find(function (t) { return t.id === pid; });
                }
                if (tab) {
                    result.push(tab);
                }
            }
        });
        return result;
    }
    Core.filterTopLevelTabs = filterTopLevelTabs;
    function initPreferenceScope($scope, localStorage, defaults) {
        angular.forEach(defaults, function (_default, key) {
            $scope[key] = _default['value'];
            var converter = _default['converter'];
            var formatter = _default['formatter'];
            if (!formatter) {
                formatter = function (value) {
                    return value;
                };
            }
            if (!converter) {
                converter = function (value) {
                    return value;
                };
            }
            if (key in localStorage) {
                var value = converter(localStorage[key]);
                Core.log.debug("from local storage, setting ", key, " to ", value);
                $scope[key] = value;
            }
            else {
                var value = _default['value'];
                Core.log.debug("from default, setting ", key, " to ", value);
                localStorage[key] = value;
            }
            var watchFunc = _default['override'];
            if (!watchFunc) {
                watchFunc = function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        if (angular.isFunction(_default['pre'])) {
                            _default.pre(newValue);
                        }
                        var value = formatter(newValue);
                        Core.log.debug("to local storage, setting ", key, " to ", value);
                        localStorage[key] = value;
                        if (angular.isFunction(_default['post'])) {
                            _default.post(newValue);
                        }
                    }
                };
            }
            if (_default['compareAsObject']) {
                $scope.$watch(key, watchFunc, true);
            }
            else {
                $scope.$watch(key, watchFunc);
            }
        });
    }
    Core.initPreferenceScope = initPreferenceScope;
    function isValidFunction(workspace, validFn, perspectiveId) {
        return !validFn || validFn(workspace, perspectiveId);
    }
    Core.isValidFunction = isValidFunction;
    function getDefaultPlugin(perspectiveId, workspace, jolokia, localStorage) {
        var plugins = Core.configuredPluginsForPerspectiveId(perspectiveId, workspace, jolokia, localStorage);
        var defaultPlugin = null;
        plugins.forEach(function (p) {
            if (p.isDefault) {
                defaultPlugin = p;
            }
        });
        return defaultPlugin;
    }
    Core.getDefaultPlugin = getDefaultPlugin;
})(Core || (Core = {}));
var Insight;
(function (Insight) {
    Insight.managerMBean = "io.fabric8:type=Fabric";
    Insight.allContainers = { id: '-- all --' };
    function hasInsight(workspace) {
        return workspace.treeContainsDomainAndProperties('io.fabric8.insight', { type: 'Elasticsearch' });
    }
    Insight.hasInsight = hasInsight;
    function hasKibana(workspace) {
        return workspace.treeContainsDomainAndProperties('hawtio', { type: 'plugin', name: 'hawtio-kibana' });
    }
    Insight.hasKibana = hasKibana;
    function hasEsHead(workspace) {
        return workspace.treeContainsDomainAndProperties('hawtio', { type: 'plugin', name: 'hawtio-eshead' });
    }
    Insight.hasEsHead = hasEsHead;
    function getInsightMetricsCollectorMBean(workspace) {
        var node = workspace.findMBeanWithProperties('io.fabric8.insight', { type: 'MetricsCollector' });
        if (!node) {
            node = workspace.findMBeanWithProperties('org.fusesource.insight', { type: 'MetricsCollector' });
        }
        return node ? node.objectName : null;
    }
    Insight.getInsightMetricsCollectorMBean = getInsightMetricsCollectorMBean;
    function getChildren(node, type, field, hasHost) {
        var children = [];
        for (var p in node["properties"]) {
            var obj = node["properties"][p];
            if (obj["type"] === 'long' || obj["type"] === 'double') {
                children.push({ title: p, field: field + p, type: type, hasHost: hasHost });
            }
            else if (obj["properties"]) {
                children.push({ title: p, isFolder: true, children: getChildren(obj, type, field + p + ".", hasHost) });
            }
        }
        return children;
    }
    Insight.getChildren = getChildren;
    function createCharts($scope, chartsDef, element, jolokia) {
        var chartsDiv = $(element);
        var width = chartsDiv.width() - 80;
        var context = cubism.context().serverDelay(interval_to_seconds('1m') * 1000).clientDelay($scope.updateRate).step(interval_to_seconds($scope.timespan) * 1000).size(width);
        var d3Selection = d3.select(chartsDiv[0]);
        d3Selection.html("");
        d3Selection.selectAll(".axis").data(["top", "bottom"]).enter().append("div").attr("class", function (d) {
            return d + " axis";
        }).each(function (d) {
            d3.select(this).call(context.axis().ticks(12).orient(d));
        });
        d3Selection.append("div").attr("class", "rule").call(context.rule());
        context.on("focus", function (i) {
            d3Selection.selectAll(".value").style("right", i === null ? null : context.size() - i + "px");
        });
        chartsDef.forEach(function (chartDef) {
            d3Selection.call(function (div) {
                div.append("div").data([chart(context, chartDef, jolokia)]).attr("class", "horizon").call(context.horizon());
            });
        });
    }
    Insight.createCharts = createCharts;
    function chart(context, chartDef, jolokia) {
        return context.metric(function (start, stop, step, callback) {
            var values = [], value = 0, start = +start, stop = +stop;
            var range = {
                range: {
                    timestamp: {
                        from: new Date(start).toISOString(),
                        to: new Date(stop).toISOString()
                    }
                }
            };
            var filter;
            if (chartDef.query) {
                filter = {
                    fquery: {
                        query: {
                            filtered: {
                                query: {
                                    query_string: {
                                        query: chartDef.query
                                    }
                                },
                                filter: range
                            }
                        }
                    }
                };
            }
            else {
                filter = range;
            }
            var request = {
                size: 0,
                facets: {
                    histo: {
                        date_histogram: {
                            value_field: chartDef.field,
                            key_field: "timestamp",
                            interval: step + "ms"
                        },
                        facet_filter: filter
                    }
                }
            };
            var jreq = { type: 'exec', mbean: 'org.elasticsearch:service=restjmx', operation: 'exec', arguments: ['POST', '/_all/' + chartDef.type + '/_search', JSON.stringify(request)] };
            jolokia.request(jreq, { success: function (response) {
                var map = {};
                var data = jQuery.parseJSON(response.value)["facets"]["histo"]["entries"];
                data.forEach(function (entry) {
                    map[entry.time] = entry.max;
                });
                var delta = 0;
                if (chartDef.meta !== undefined) {
                    if (chartDef.meta['type'] === 'trends-up' || chartDef.meta['type'] === 'peak') {
                        delta = +1;
                    }
                    else if (chartDef.meta['type'] === 'trends-down') {
                        delta = -1;
                    }
                }
                while (start < stop) {
                    var v = 0;
                    if (delta !== 0) {
                        if (map[start - step] !== undefined) {
                            var d = (map[start] - map[start - step]) * delta;
                            v = d > 0 ? d : 0;
                        }
                    }
                    else {
                        if (map[start] !== undefined) {
                            v = map[start];
                        }
                    }
                    values.push(v);
                    start += step;
                }
                callback(null, values);
            } });
        }, chartDef.name);
    }
    function interval_to_seconds(string) {
        var matches = string.match(/(\d+)([Mwdhms])/);
        switch (matches[2]) {
            case 'M':
                return matches[1] * 2592000;
                ;
            case 'w':
                return matches[1] * 604800;
                ;
            case 'd':
                return matches[1] * 86400;
                ;
            case 'h':
                return matches[1] * 3600;
                ;
            case 'm':
                return matches[1] * 60;
                ;
            case 's':
                return matches[1];
        }
    }
    function time_ago(string) {
        return new Date(new Date().getTime() - (interval_to_seconds(string) * 1000));
    }
})(Insight || (Insight = {}));
var Site;
(function (Site) {
    Site.sitePluginEnabled = false;
    function isSiteNavBarValid() {
        return Site.sitePluginEnabled;
    }
    Site.isSiteNavBarValid = isSiteNavBarValid;
})(Site || (Site = {}));
var Perspective;
(function (Perspective) {
    Perspective.containerPerspectiveEnabled = true;
    Perspective.metadata = {
        fabric: {
            icon: {
                title: "Fabric8",
                type: "img",
                src: "img/icons/fabric8_icon.svg"
            },
            label: "Fabric",
            isValid: function (workspace) { return Fabric.isFMCContainer(workspace); },
            lastPage: "#/fabric/containers",
            topLevelTabs: {
                includes: [
                    {
                        id: "kubernetes"
                    },
                    {
                        id: "fabric.containers"
                    },
                    {
                        id: "fabric.profiles"
                    },
                    {
                        href: "#/wiki/branch/"
                    },
                    {
                        href: "#/fabric"
                    },
                    {
                        id: "fabric.requirements"
                    },
                    {
                        href: "#/wiki/profile"
                    },
                    {
                        href: "#/docker"
                    },
                    {
                        href: "#/dashboard"
                    },
                    {
                        href: "#/health"
                    }
                ]
            }
        },
        container: {
            icon: {
                title: "Java",
                type: "img",
                src: "img/icons/java.svg"
            },
            label: "Container",
            lastPage: "#/logs",
            isValid: function (workspace) { return workspace && workspace.tree && workspace.tree.children && workspace.tree.children.length; },
            topLevelTabs: {
                excludes: [
                    {
                        href: "#/fabric"
                    },
                    {
                        href: "#/kubernetes"
                    },
                    {
                        id: "fabric.profiles"
                    },
                    {
                        id: "fabric.containers"
                    },
                    {
                        id: "fabric.requirements"
                    },
                    {
                        id: "fabric.kubernetes"
                    },
                    {
                        href: "#/insight"
                    },
                    {
                        href: "#/camin"
                    },
                    {
                        id: "insight-camel"
                    },
                    {
                        id: "insight-logs"
                    },
                    {
                        id: "dashboard",
                        onCondition: function (workspace) { return Fabric.isFMCContainer(workspace); }
                    },
                    {
                        id: "health",
                        onCondition: function (workspace) { return Fabric.isFMCContainer(workspace); }
                    },
                    {
                        id: "wiki",
                        onCondition: function (workspace) { return Fabric.isFMCContainer(workspace); }
                    }
                ]
            }
        },
        limited: {
            label: "Limited",
            lastPage: "#/logs",
            isValid: function (workspace) { return false; },
            topLevelTabs: {
                includes: [
                    {
                        href: "#/jmx"
                    },
                    {
                        href: "#/camel"
                    },
                    {
                        href: "#/activemq"
                    },
                    {
                        href: "#/jetty"
                    },
                    {
                        href: "#/logs"
                    }
                ]
            }
        },
        website: {
            label: "WebSite",
            isValid: function (workspace) { return Site.sitePluginEnabled && Site.isSiteNavBarValid(); },
            lastPage: "#/site/doc/index.md",
            topLevelTabs: {
                includes: [
                    {
                        content: "Get Started",
                        title: "How to get started using hawtio",
                        href: function () { return "#/site/doc/GetStarted.md"; },
                        isValid: function () { return Site.isSiteNavBarValid(); }
                    },
                    {
                        content: "FAQ",
                        title: "Frequently Asked Questions",
                        href: function () { return "#/site/FAQ.md"; },
                        isValid: function () { return Site.isSiteNavBarValid(); }
                    },
                    {
                        content: "User Guide",
                        title: "All the docs on using hawtio",
                        href: function () { return "#/site/book/doc/index.md"; },
                        isValid: function () { return Site.isSiteNavBarValid(); }
                    },
                    {
                        content: "Community",
                        title: "Come on in and join our community!",
                        href: function () { return "#/site/doc/Community.html"; },
                        isValid: function () { return Site.isSiteNavBarValid(); }
                    },
                    {
                        content: "Developers",
                        title: "Resources for developers if you want to hack on hawtio or provide your own plugins",
                        href: function () { return "#/site/doc/developers/index.md"; },
                        isValid: function () { return Site.isSiteNavBarValid(); }
                    },
                    {
                        content: "github",
                        title: "Hawtio's source code and issue tracker",
                        href: function () { return "https://github.com/hawtio/hawtio"; },
                        isValid: function () { return Site.isSiteNavBarValid(); }
                    }
                ]
            }
        }
    };
})(Perspective || (Perspective = {}));
var Perspective;
(function (Perspective) {
    Perspective.log = Logger.get("Perspective");
    Perspective.perspectiveSearchId = "p";
    Perspective.defaultPerspective = null;
    Perspective.defaultPageLocation = null;
    function currentPerspectiveId($location, workspace, jolokia, localStorage) {
        var perspective = $location.search()[Perspective.perspectiveSearchId];
        if (!perspective) {
            perspective = Perspective.choosePerspective($location, workspace, jolokia, localStorage);
        }
        return perspective;
    }
    Perspective.currentPerspectiveId = currentPerspectiveId;
    function getPerspectives($location, workspace, jolokia, localStorage) {
        var perspectives = [];
        angular.forEach(Perspective.metadata, function (perspective, key) {
            if (isValidFunction(workspace, perspective.isValid)) {
                if (!perspective.label) {
                    perspective.label = key;
                }
                if (!perspective.title) {
                    perspective.title = perspective.label;
                }
                perspective.id = key;
                perspectives.push(perspective);
            }
        });
        return perspectives;
    }
    Perspective.getPerspectives = getPerspectives;
    function getPerspectiveById(id) {
        var answer;
        angular.forEach(Perspective.metadata, function (perspective, key) {
            if (key === id) {
                answer = perspective;
            }
        });
        return answer;
    }
    Perspective.getPerspectiveById = getPerspectiveById;
    function topLevelTabsForPerspectiveId(workspace, perspective) {
        var sortedTopLevelTabs = workspace.topLevelTabs.sortBy(function (f) { return f.content; });
        var data = perspective ? Perspective.metadata[perspective] : null;
        var metaData = data;
        var answer = [];
        if (!data) {
            answer = sortedTopLevelTabs;
        }
        else {
            var topLevelTabs = data.topLevelTabs;
            var includes = filterTabs(topLevelTabs.includes, workspace);
            var excludes = filterTabs(topLevelTabs.excludes, workspace);
            if (metaData) {
                excludes = excludes.filter(function (t) {
                    var metaTab = metaData.topLevelTabs.excludes.find(function (et) {
                        var etid = et.id;
                        return etid && etid === t.id;
                    });
                    if (metaTab != null && angular.isFunction(metaTab.onCondition)) {
                        var answer = metaTab.onCondition(workspace);
                        if (answer) {
                            Perspective.log.debug("Plugin " + t.id + " excluded in perspective " + perspective);
                            return true;
                        }
                        else {
                            return false;
                        }
                    }
                    return true;
                });
            }
            if (!topLevelTabs.includes) {
                answer = sortedTopLevelTabs;
            }
            else {
                answer = includes;
            }
            answer = answer.subtract(excludes);
        }
        return answer;
    }
    Perspective.topLevelTabsForPerspectiveId = topLevelTabsForPerspectiveId;
    function filterTabs(tabs, workspace) {
        var matched = [];
        function pushMatchedTab(tabSpec, tab) {
            if (tab) {
                var content = tabSpec.content;
                if (content) {
                    tab = angular.copy(tab);
                    tab.content = content;
                }
                matched.push(tab);
            }
        }
        angular.forEach(tabs, function (tabSpec) {
            var href = tabSpec.href;
            var id = tabSpec.id;
            var rhref = tabSpec.rhref;
            if (href) {
                var hrefValue = href;
                if (angular.isFunction(href)) {
                    hrefValue = href();
                }
                var tab = workspace.topLevelTabs.find(function (t) {
                    var thref = t.href();
                    return thref && thref.startsWith(hrefValue);
                });
                if (!tab && !id && tabSpec.content) {
                    tab = tabSpec;
                }
                pushMatchedTab(tabSpec, tab);
            }
            else if (id) {
                var tab = workspace.topLevelTabs.find(function (t) {
                    var tid = t.id;
                    return tid && tid === id;
                });
                pushMatchedTab(tabSpec, tab);
            }
            else if (rhref) {
                var tab = workspace.topLevelTabs.find(function (t) {
                    var thref = t.href();
                    return thref && thref.match(rhref);
                });
                pushMatchedTab(tabSpec, tab);
            }
        });
        return matched;
    }
    function filterOnlyValidTopLevelTabs(workspace, topLevelTabs) {
        var answer = topLevelTabs.filter(function (tab) {
            var href = tab.href();
            return href && isValidFunction(workspace, tab.isValid);
        });
        return answer;
    }
    Perspective.filterOnlyValidTopLevelTabs = filterOnlyValidTopLevelTabs;
    function filterOnlyActiveTopLevelTabs(workspace, topLevelTabs) {
        var answer = topLevelTabs.filter(function (tab) {
            var href = tab.href();
            return href && isValidFunction(workspace, tab.isActive);
        });
        return answer;
    }
    Perspective.filterOnlyActiveTopLevelTabs = filterOnlyActiveTopLevelTabs;
    function getTopLevelTabsForPerspective($location, workspace, jolokia, localStorage) {
        var perspective = currentPerspectiveId($location, workspace, jolokia, localStorage);
        var plugins = Core.configuredPluginsForPerspectiveId(perspective, workspace, jolokia, localStorage);
        var tabs = Core.filterTopLevelTabs(perspective, workspace, plugins);
        tabs = Perspective.filterOnlyValidTopLevelTabs(workspace, tabs);
        return tabs;
    }
    Perspective.getTopLevelTabsForPerspective = getTopLevelTabsForPerspective;
    function choosePerspective($location, workspace, jolokia, localStorage) {
        var answer;
        var url = $location.url();
        var inFMC = Fabric.isFMCContainer(workspace);
        if (inFMC) {
            if (url.startsWith("/perspective/defaultPage") || url.startsWith("/login") || url.startsWith("/welcome") || url.startsWith("/index") || url.startsWith("/fabric") || url.startsWith("/profiles") || url.startsWith("/dashboard") || url.startsWith("/health") || (url.startsWith("/wiki") && url.has("/fabric/profiles")) || (url.startsWith("/wiki") && url.has("/editFeatures"))) {
                answer = "fabric";
            }
        }
        answer = answer || Perspective.defaultPerspective || "container";
        return answer;
    }
    Perspective.choosePerspective = choosePerspective;
    function defaultPage($location, workspace, jolokia, localStorage) {
        var isProxy = Core.isProxyUrl($location);
        var isChomeApp = Core.isChromeApp();
        if (!isProxy && !isChomeApp && shouldShowWelcomePage(localStorage)) {
            return "/welcome/";
        }
        var answer = Perspective.defaultPageLocation;
        if (!answer && $location && workspace) {
            var perspectiveId = currentPerspectiveId($location, workspace, jolokia, localStorage);
            var defaultPlugin = Core.getDefaultPlugin(perspectiveId, workspace, jolokia, localStorage);
            var tabs = Perspective.topLevelTabsForPerspectiveId(workspace, perspectiveId);
            tabs = Perspective.filterOnlyValidTopLevelTabs(workspace, tabs);
            var defaultTab;
            if (defaultPlugin) {
                tabs.forEach(function (tab) {
                    if (tab.id === defaultPlugin.id) {
                        defaultTab = tab;
                    }
                });
            }
            else {
                defaultTab = tabs[0];
            }
            if (defaultTab) {
                answer = Core.trimLeading(defaultTab.href(), "#");
            }
        }
        return answer || '/help/index';
    }
    Perspective.defaultPage = defaultPage;
    function shouldShowWelcomePage(localStorage) {
        var value = localStorage["showWelcomePage"];
        if (angular.isString(value)) {
            return "true" === value;
        }
        return true;
    }
    Perspective.shouldShowWelcomePage = shouldShowWelcomePage;
    function isValidFunction(workspace, validFn) {
        return !validFn || validFn(workspace);
    }
})(Perspective || (Perspective = {}));
var Core;
(function (Core) {
    Core.ConsoleController = Core._module.controller("Core.ConsoleController", ["$scope", "$element", "$templateCache", function ($scope, $element, $templateCache) {
        $scope.setHandler = function (clip) {
            clip.addEventListener('mouseDown', function (client, args) {
                var icon = $element.find('.icon-copy');
                var icon2 = $element.find('.icon-trash');
                if (this !== icon.get(0) && this !== icon2.get(0)) {
                    return;
                }
                if (this == icon.get(0)) {
                    copyToClipboard();
                }
                else {
                    clearLogs();
                    Core.notification('info', "Cleared logging console");
                }
                Core.$apply($scope);
            });
            function copyToClipboard() {
                var text = $templateCache.get("logClipboardTemplate").lines();
                text.removeAt(0);
                text.removeAt(text.length - 1);
                text.push('<ul>');
                $element.find('#log-panel-statements').children().each(function (index, child) {
                    text.push('  <li>' + child.innerHTML + '</li>');
                });
                text.push('</ul>');
                clip.setText(text.join('\n'));
            }
            function clearLogs() {
                $element.find('#log-panel-statements').children().remove();
            }
        };
    }]);
    Core.AppController = Core._module.controller("Core.AppController", ["$scope", "$location", "workspace", "jolokia", "jolokiaStatus", "$document", "pageTitle", "localStorage", "userDetails", "lastLocation", "jolokiaUrl", "branding", "ConnectOptions", "$timeout", "locationChangeStartTasks", "$route", function ($scope, $location, workspace, jolokia, jolokiaStatus, $document, pageTitle, localStorage, userDetails, lastLocation, jolokiaUrl, branding, ConnectOptions, $timeout, locationChangeStartTasks, $route) {
        $scope.collapse = '';
        $scope.match = null;
        $scope.pageTitle = [];
        $scope.userDetails = userDetails;
        $scope.confirmLogout = false;
        $scope.connectionFailed = false;
        $scope.connectFailure = {};
        $scope.showPrefs = false;
        $scope.logoClass = function () {
            if (branding.logoOnly) {
                return "without-text";
            }
            else {
                return "with-text";
            }
        };
        $scope.branding = branding;
        $scope.hasMBeans = function () { return workspace.hasMBeans(); };
        $scope.$watch('jolokiaStatus.xhr', function () {
            var failure = jolokiaStatus.xhr;
            $scope.connectionFailed = failure ? true : false;
            $scope.connectFailure.summaryMessage = null;
            if ($scope.connectionFailed) {
                $scope.connectFailure.status = failure.status;
                $scope.connectFailure.statusText = failure.statusText;
                var text = failure.responseText;
                if (text) {
                    try {
                        var html = $(text);
                        var markup = html.find("body");
                        if (markup && markup.length) {
                            html = markup;
                        }
                        html.each(function (idx, e) {
                            var name = e.localName;
                            if (name && name.startsWith("h")) {
                                $(e).addClass("ajaxError");
                            }
                        });
                        var container = $("<div></div>");
                        container.append(html);
                        $scope.connectFailure.summaryMessage = container.html();
                        console.log("Found HTML: " + $scope.connectFailure.summaryMessage);
                    }
                    catch (e) {
                        if (text.indexOf('<') < 0) {
                            $scope.connectFailure.summaryMessage = "<p>" + text + "</p>";
                        }
                    }
                }
            }
        });
        $scope.showPreferences = function () {
            $scope.showPrefs = true;
        };
        $scope.closePreferences = function () {
            $scope.showPrefs = false;
        };
        $scope.confirmConnectionFailed = function () {
            window.close();
        };
        $scope.setPageTitle = function () {
            $scope.pageTitle = pageTitle.getTitleArrayExcluding([branding.appName]);
            var tab = workspace.getActiveTab();
            if (tab && tab.content) {
                Core.setPageTitleWithTab($document, pageTitle, tab.content);
            }
            else {
                Core.setPageTitle($document, pageTitle);
            }
        };
        $scope.setRegexIndicator = function () {
            try {
                var regexs = angular.fromJson(localStorage['regexs']);
                if (regexs) {
                    regexs.reverse().each(function (regex) {
                        var r = new RegExp(regex.regex, 'g');
                        if (r.test($location.absUrl())) {
                            $scope.match = {
                                name: regex.name,
                                color: regex.color
                            };
                        }
                    });
                }
            }
            catch (e) {
            }
        };
        $scope.loggedIn = function () {
            return userDetails.username !== null && userDetails.username !== 'public';
        };
        $scope.showLogout = function () {
            return $scope.loggedIn() && angular.isDefined(userDetails.loginDetails);
        };
        $scope.logout = function () {
            $scope.confirmLogout = true;
        };
        $scope.getUsername = function () {
            if (userDetails.username && !userDetails.username.isBlank()) {
                return userDetails.username;
            }
            else {
                return 'user';
            }
        };
        $scope.doLogout = function () {
            $scope.confirmLogout = false;
            Core.logout(jolokiaUrl, userDetails, localStorage, $scope);
        };
        $scope.$watch(function () {
            return localStorage['regexs'];
        }, $scope.setRegexIndicator);
        $scope.reloaded = false;
        $scope.maybeRedirect = function () {
            if (userDetails.username === null) {
                var currentUrl = $location.url();
                if (!currentUrl.startsWith('/login')) {
                    lastLocation.url = currentUrl;
                    $location.url('/login');
                }
                else {
                    if (!$scope.reloaded) {
                        $route.reload();
                        $scope.reloaded = true;
                    }
                }
            }
            else {
                if ($location.url().startsWith('/login')) {
                    var url = defaultPage();
                    if (angular.isDefined(lastLocation.url)) {
                        url = lastLocation.url;
                    }
                    $location.url(url);
                }
            }
        };
        $scope.$watch('userDetails', function (newValue, oldValue) {
            $scope.maybeRedirect();
        }, true);
        $scope.$on('hawtioOpenPrefs', function () {
            $scope.showPrefs = true;
        });
        $scope.$on('hawtioClosePrefs', function () {
            $scope.showPrefs = false;
        });
        $scope.$on('$routeChangeStart', function (event, args) {
            if ((!args.params || !args.params.pref) && $scope.showPrefs) {
                $scope.showPrefs = false;
            }
            $scope.maybeRedirect();
        });
        $scope.$on('$routeChangeSuccess', function () {
            $scope.setPageTitle($document, Core.PageTitle);
            $scope.maybeRedirect();
        });
        $scope.fullScreen = function () {
            if ($location.path().startsWith("/login")) {
                return branding.fullscreenLogin;
            }
            var tab = $location.search()['tab'];
            if (tab) {
                return tab === "fullscreen";
            }
            return false;
        };
        $scope.login = function () {
            return $location.path().startsWith("/login");
        };
        function defaultPage() {
            return Perspective.defaultPage($location, workspace, jolokia, localStorage);
        }
    }]);
})(Core || (Core = {}));
$(function () {
    hawtioPluginLoader.loadPlugins(function () {
        var doc = angular.element(document);
        var docEl = angular.element(document.documentElement);
        Core.injector = angular.bootstrap(docEl, hawtioPluginLoader.getModules());
        Logger.get("Core").debug("Bootstrapped application, injector: ", Core.injector);
        docEl.attr('xmlns:ng', "http://angularjs.org");
        docEl.attr('ng-app', 'hawtioCore');
    });
});
var Core;
(function (Core) {
    Core._module.directive('noClick', function () {
        return function ($scope, $element, $attrs) {
            $element.click(function (event) {
                event.preventDefault();
            });
        };
    });
    Core._module.directive('logToggler', ["localStorage", function (localStorage) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attr) {
                $($element).click(function () {
                    var log = $("#log-panel");
                    var body = $('body');
                    if (log.height() !== 0) {
                        localStorage['showLog'] = 'false';
                        log.css({ 'bottom': '110%' });
                        body.css({
                            'overflow-y': 'auto'
                        });
                    }
                    else {
                        localStorage['showLog'] = 'true';
                        log.css({ 'bottom': '50%' });
                        body.css({
                            'overflow-y': 'hidden'
                        });
                    }
                    return false;
                });
            }
        };
    }]);
    Core._module.directive('autofill', ['$timeout', function ($timeout) {
        return {
            restrict: "A",
            require: 'ngModel',
            link: function (scope, elem, attrs, ctrl) {
                var ngModel = attrs["ngModel"];
                if (ngModel) {
                    var log = Logger.get("Core");
                    function checkForDifference() {
                        var modelValue = scope.$eval(ngModel);
                        var value = elem.val();
                        if (value && !modelValue) {
                            Core.pathSet(scope, ngModel, value);
                        }
                        else {
                            elem.trigger('input');
                            elem.trigger('change');
                            if (elem.length) {
                                var firstElem = $(elem[0]);
                                firstElem.trigger('input');
                                firstElem.trigger('change');
                            }
                        }
                    }
                    $timeout(checkForDifference, 200);
                    $timeout(checkForDifference, 800);
                    $timeout(checkForDifference, 1500);
                }
            }
        };
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.CorePreferences", ["$scope", "localStorage", function ($scope, localStorage) {
        Core.initPreferenceScope($scope, localStorage, {
            'updateRate': {
                'value': 5000,
                'post': function (newValue) {
                    $scope.$emit('UpdateRate', newValue);
                }
            },
            'showWelcomePage': {
                'value': true,
                'converter': Core.parseBooleanValue,
            },
            'regexs': {
                'value': "",
                'converter': function (value) {
                    if (angular.isArray(value)) {
                        return value;
                    }
                    else if (Core.isBlank(value)) {
                        return [];
                    }
                    return angular.fromJson(value);
                },
                'formatter': function (value) {
                    return angular.toJson(value);
                },
                'compareAsObject': true
            }
        });
        $scope.newHost = {};
        $scope.forms = {};
        $scope.addRegexDialog = new UI.Dialog();
        $scope.onOk = function (json, form) {
            $scope.addRegexDialog.close();
            json['color'] = UI.colors.sample();
            if (!angular.isArray($scope.regexs)) {
                $scope.regexs = [json];
            }
            else {
                $scope.regexs.push(json);
            }
            $scope.newHost = {};
            Core.$apply($scope);
        };
        $scope.hostSchema = {
            properties: {
                'name': {
                    description: 'Indicator name',
                    type: 'string',
                    required: true
                },
                'regex': {
                    description: 'Indicator regex',
                    type: 'string',
                    required: true
                }
            }
        };
        $scope.delete = function (index) {
            $scope.regexs.removeAt(index);
        };
        $scope.moveUp = function (index) {
            var tmp = $scope.regexs[index];
            $scope.regexs[index] = $scope.regexs[index - 1];
            $scope.regexs[index - 1] = tmp;
        };
        $scope.moveDown = function (index) {
            var tmp = $scope.regexs[index];
            $scope.regexs[index] = $scope.regexs[index + 1];
            $scope.regexs[index + 1] = tmp;
        };
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    var HelpRegistry = (function () {
        function HelpRegistry($rootScope) {
            this.$rootScope = $rootScope;
            this.discoverableDocTypes = {
                user: 'help.md'
            };
            this.topicNameMappings = {
                activemq: 'ActiveMQ',
                camel: 'Camel',
                jboss: 'JBoss',
                jclouds: 'jclouds',
                jmx: 'JMX',
                jvm: 'Connect',
                log: 'Logs',
                openejb: 'OpenEJB'
            };
            this.subTopicNameMappings = {
                user: 'For Users',
                developer: 'For Developers',
                faq: 'FAQ'
            };
            this.pluginNameMappings = {
                hawtioCore: 'core',
                'hawtio-branding': 'branding',
                forceGraph: 'forcegraph',
                'hawtio-ui': 'ui',
                'hawtio-forms': 'forms',
                elasticjs: 'elasticsearch'
            };
            this.ignoredPlugins = [
                'core',
                'branding',
                'datatable',
                'forcegraph',
                'forms',
                'perspective',
                'tree',
                'ui'
            ];
            this.topics = {};
        }
        HelpRegistry.prototype.addUserDoc = function (topic, path, isValid) {
            if (isValid === void 0) { isValid = null; }
            this.addSubTopic(topic, 'user', path, isValid);
        };
        HelpRegistry.prototype.addDevDoc = function (topic, path, isValid) {
            if (isValid === void 0) { isValid = null; }
            this.addSubTopic(topic, 'developer', path, isValid);
        };
        HelpRegistry.prototype.addSubTopic = function (topic, subtopic, path, isValid) {
            if (isValid === void 0) { isValid = null; }
            this.getOrCreateTopic(topic, isValid)[subtopic] = path;
        };
        HelpRegistry.prototype.getOrCreateTopic = function (topic, isValid) {
            if (isValid === void 0) { isValid = null; }
            if (!angular.isDefined(this.topics[topic])) {
                if (isValid === null) {
                    isValid = function () {
                        return true;
                    };
                }
                this.topics[topic] = {
                    isValid: isValid
                };
                this.$rootScope.$broadcast('hawtioNewHelpTopic');
            }
            return this.topics[topic];
        };
        HelpRegistry.prototype.mapTopicName = function (name) {
            if (angular.isDefined(this.topicNameMappings[name])) {
                return this.topicNameMappings[name];
            }
            return name.capitalize();
        };
        HelpRegistry.prototype.mapSubTopicName = function (name) {
            if (angular.isDefined(this.subTopicNameMappings[name])) {
                return this.subTopicNameMappings[name];
            }
            return name.capitalize();
        };
        HelpRegistry.prototype.getTopics = function () {
            var answer = {};
            angular.forEach(this.topics, function (value, key) {
                if (value.isValid()) {
                    Core.log.debug(key, " is available");
                    answer[key] = angular.fromJson(angular.toJson(value));
                }
                else {
                    Core.log.debug(key, " is not available");
                }
            });
            return answer;
        };
        HelpRegistry.prototype.disableAutodiscover = function (name) {
            this.ignoredPlugins.push(name);
        };
        HelpRegistry.prototype.discoverHelpFiles = function (plugins) {
            var self = this;
            console.log("Ignored plugins: ", self.ignoredPlugins);
            plugins.forEach(function (plugin) {
                var pluginName = self.pluginNameMappings[plugin];
                if (!angular.isDefined(pluginName)) {
                    pluginName = plugin;
                }
                if (!self.ignoredPlugins.any(function (p) {
                    return p === pluginName;
                })) {
                    angular.forEach(self.discoverableDocTypes, function (value, key) {
                        if (!angular.isDefined(self[pluginName]) || !angular.isDefined(self[pluginName][key])) {
                            var target = 'app/' + pluginName + '/doc/' + value;
                            console.log("checking: ", target);
                            $.ajax(target, {
                                type: 'HEAD',
                                statusCode: {
                                    200: function () {
                                        self.getOrCreateTopic(plugin)[key] = target;
                                    }
                                }
                            });
                        }
                    });
                }
            });
        };
        return HelpRegistry;
    })();
    Core.HelpRegistry = HelpRegistry;
})(Core || (Core = {}));
var Core;
(function (Core) {
    var PreferencesRegistry = (function () {
        function PreferencesRegistry() {
            this.tabs = {};
        }
        PreferencesRegistry.prototype.addTab = function (name, template, isValid) {
            if (isValid === void 0) { isValid = undefined; }
            if (!isValid) {
                isValid = function () {
                    return true;
                };
            }
            this.tabs[name] = {
                template: template,
                isValid: isValid
            };
        };
        PreferencesRegistry.prototype.getTab = function (name) {
            return this.tabs[name];
        };
        PreferencesRegistry.prototype.getTabs = function () {
            var answer = {};
            angular.forEach(this.tabs, function (value, key) {
                if (value.isValid()) {
                    answer[key] = value;
                }
            });
            return answer;
        };
        return PreferencesRegistry;
    })();
    Core.PreferencesRegistry = PreferencesRegistry;
    ;
})(Core || (Core = {}));
var Themes;
(function (Themes) {
    Themes.defaultLoginBg = 'app/themes/img/default/hawtio-nologo.jpg';
    Themes.definitions = {
        'Default': {
            label: 'Default',
            file: 'app/themes/css/default.css',
            loginBg: Themes.defaultLoginBg
        },
        'Dark': {
            label: 'Dark',
            file: 'app/themes/css/dark.css',
            loginBg: Themes.defaultLoginBg
        },
        '3270': {
            label: 'Dark',
            file: 'app/themes/css/3270.css',
            loginBg: Themes.defaultLoginBg
        }
    };
    Themes.brandings = {
        'hawtio': {
            label: 'hawtio',
            setFunc: function (branding) {
                branding.appName = 'hawtio';
                branding.appLogo = 'img/hawtio_logo.svg';
                branding.css = 'css/site-branding.css';
                branding.logoOnly = true;
                branding.fullscreenLogin = false;
                branding.favicon = 'favicon.ico';
                branding.welcomePageUrl = 'app/core/doc/welcome.md';
                branding.onWelcomePage = function (data) {
                    return marked(data);
                };
                return branding;
            }
        },
        'Example': {
            label: 'Example',
            setFunc: function (branding) {
                branding.appName = 'Example';
                branding.logoOnly = false;
                branding.welcomePageUrl = 'app/themes/doc/welcome_example.md';
                return branding;
            }
        }
    };
    Themes.currentTheme = 'Default';
    Themes.currentBranding = 'hawtio';
    function getAvailableThemes() {
        return Object.extended(Themes.definitions).keys();
    }
    Themes.getAvailableThemes = getAvailableThemes;
    function getAvailableBrandings() {
        return Object.extended(Themes.brandings).keys();
    }
    Themes.getAvailableBrandings = getAvailableBrandings;
    function getBranding(name) {
        var b = Themes.brandings[name];
        if (!b || !b['setFunc']) {
            b = Themes.brandings['hawtio'];
        }
        return b;
    }
    function setCSS(el, file) {
        var cssEL = $(el);
        cssEL.prop("disabled", true);
        cssEL.attr({ href: file });
        cssEL.prop("disabled", false);
    }
    function setFavicon(file) {
        $('#favicon').remove();
        $('head').append('<link id="favicon" rel="icon" type="image/ico" href="' + file + '">"');
    }
    function applyTheme(theme, branding) {
        if (!theme || !theme['file'] || !theme['label']) {
            Themes.log.info("invalid theme, setting theme to Default");
            setCSS("#theme", Themes.definitions['Default']['file']);
            branding.loginBg = Themes.definitions['Default']['loginBg'];
        }
        else {
            Themes.log.debug("Setting theme to ", theme['label']);
            setCSS("#theme", theme['file']);
            if (theme['loginBg']) {
                branding.loginBg = theme['loginBg'];
            }
        }
    }
    function setBranding(name, branding) {
        var b = getBranding(name);
        branding = b.setFunc(branding);
        Themes.log.debug("Set branding to: ", branding);
        if (branding.favicon) {
            setFavicon(branding.favicon);
        }
        if (branding.css) {
            setCSS("#branding", branding.css);
        }
        Themes.currentBranding = b['label'];
        localStorage['branding'] = Themes.currentBranding;
    }
    Themes.setBranding = setBranding;
    function setTheme(name, branding) {
        if (!(name in Themes.definitions)) {
            name = 'Default';
            Themes.log.info("unknown theme name, using default theme");
        }
        var theme = Core.pathGet(Themes.definitions, [name]);
        applyTheme(theme, branding);
        Themes.currentTheme = name;
        localStorage['theme'] = Themes.currentTheme;
    }
    Themes.setTheme = setTheme;
    Themes.pluginName = "themes";
    Themes.log = Logger.get("Themes");
    Themes._module = angular.module(Themes.pluginName, ["hawtioCore"]);
    Themes._module.run(["localStorage", "branding", "preferencesRegistry", function (localStorage, branding, preferencesRegistry) {
        var themeName = localStorage['theme'];
        Themes.setTheme(themeName, branding);
        var brandingName = localStorage['branding'];
        Themes.setBranding(brandingName, branding);
        preferencesRegistry.addTab("Theme", "app/themes/html/preferences.html");
        Themes.log.debug("Loaded");
    }]);
    hawtioPluginLoader.addModule(Themes.pluginName);
})(Themes || (Themes = {}));
var Core;
(function (Core) {
    Core._module.factory('workspace', ["$location", "jmxTreeLazyLoadRegistry", "$compile", "$templateCache", "localStorage", "jolokia", "jolokiaStatus", "$rootScope", "userDetails", function ($location, jmxTreeLazyLoadRegistry, $compile, $templateCache, localStorage, jolokia, jolokiaStatus, $rootScope, userDetails) {
        var answer = new Core.Workspace(jolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope, userDetails);
        answer.loadTree();
        return answer;
    }]);
    Core._module.service('ConnectOptions', ['$location', function ($location) {
        var connectionName = Core.ConnectionName;
        if (!Core.isBlank(connectionName)) {
            var answer = Core.getConnectOptions(connectionName);
            Core.log.debug("ConnectOptions: ", answer);
            return answer;
        }
        Core.log.debug("No connection options, connected to local JVM");
        return null;
    }]);
    Core._module.service('localStorage', function () {
        return Core.getLocalStorage();
    });
    Core._module.factory('pageTitle', function () {
        var answer = new Core.PageTitle();
        return answer;
    });
    Core._module.factory('viewRegistry', function () {
        return {};
    });
    Core._module.factory('lastLocation', function () {
        return {};
    });
    Core._module.factory('locationChangeStartTasks', function () {
        return new Core.ParameterizedTasksImpl();
    });
    Core._module.factory('postLoginTasks', function () {
        return Core.postLoginTasks;
    });
    Core._module.factory('preLogoutTasks', function () {
        return Core.preLogoutTasks;
    });
    Core._module.factory('helpRegistry', ["$rootScope", function ($rootScope) {
        return new Core.HelpRegistry($rootScope);
    }]);
    Core._module.factory('preferencesRegistry', function () {
        return new Core.PreferencesRegistry();
    });
    Core._module.factory('toastr', ["$window", function ($window) {
        var answer = $window.toastr;
        if (!answer) {
            answer = {};
            $window.toaster = answer;
        }
        return answer;
    }]);
    Core._module.factory('metricsWatcher', ["$window", function ($window) {
        var answer = $window.metricsWatcher;
        if (!answer) {
            answer = {};
            $window.metricsWatcher = metricsWatcher;
        }
        return answer;
    }]);
    Core._module.factory('xml2json', function () {
        var jquery = $;
        return jquery.xml2json;
    });
    Core._module.factory('jolokiaUrl', function () {
        return Core.jolokiaUrl;
    });
    Core._module.factory('jolokiaStatus', function () {
        return {
            xhr: null
        };
    });
    Core.DEFAULT_MAX_DEPTH = 7;
    Core.DEFAULT_MAX_COLLECTION_SIZE = 500;
    Core._module.factory('jolokiaParams', ["jolokiaUrl", "localStorage", function (jolokiaUrl, localStorage) {
        var answer = {
            canonicalNaming: false,
            ignoreErrors: true,
            mimeType: 'application/json',
            maxDepth: Core.DEFAULT_MAX_DEPTH,
            maxCollectionSize: Core.DEFAULT_MAX_COLLECTION_SIZE
        };
        if ('jolokiaParams' in localStorage) {
            answer = angular.fromJson(localStorage['jolokiaParams']);
        }
        else {
            localStorage['jolokiaParams'] = angular.toJson(answer);
        }
        answer['url'] = jolokiaUrl;
        return answer;
    }]);
    Core._module.factory('branding', function () {
        var branding = Themes.brandings['hawtio'].setFunc({});
        branding.logoClass = function () {
            if (branding.logoOnly) {
                return "without-text";
            }
            else {
                return "with-text";
            }
        };
        return branding;
    });
    Core._module.factory('ResponseHistory', function () {
        var answer = Core.getResponseHistory();
        return answer;
    });
    Core._module.factory('userDetails', ["ConnectOptions", "localStorage", "$window", "$rootScope", function (ConnectOptions, localStorage, $window, $rootScope) {
        var answer = {
            username: null,
            password: null
        };
        if ('userDetails' in $window) {
            answer = $window['userDetails'];
            Core.log.debug("User details loaded from parent window: ", StringHelpers.toString(answer));
            Core.executePostLoginTasks();
        }
        else if ('userDetails' in localStorage) {
            answer = angular.fromJson(localStorage['userDetails']);
            Core.log.debug("User details loaded from local storage: ", StringHelpers.toString(answer));
            Core.executePostLoginTasks();
        }
        else if (Core.isChromeApp()) {
            answer = {
                username: 'user',
                password: ''
            };
            Core.log.debug("Running as a Chrome app, using fake UserDetails: ");
            Core.executePostLoginTasks();
        }
        else {
            Core.log.debug("No username set, checking if we have a session");
            var userUrl = "user";
            $.ajax(userUrl, {
                type: "GET",
                success: function (response) {
                    Core.log.debug("Got user response: ", response);
                    if (response === null) {
                        answer.username = null;
                        answer.password = null;
                        Core.log.debug("user response was null, no session available");
                        Core.$apply($rootScope);
                        return;
                    }
                    answer.username = response;
                    if (response === 'user') {
                        Core.log.debug("Authentication disabled, using dummy credentials");
                        answer.loginDetails = {};
                    }
                    else {
                        Core.log.debug("User details loaded from existing session: ", StringHelpers.toString(answer));
                    }
                    Core.executePostLoginTasks();
                    Core.$apply($rootScope);
                },
                error: function (xhr, textStatus, error) {
                    answer.username = null;
                    answer.password = null;
                    Core.log.debug("Failed to get session username: ", error);
                    Core.$apply($rootScope);
                }
            });
            Core.log.debug("Created empty user details to be filled in: ", StringHelpers.toString(answer));
        }
        return answer;
    }]);
    Core._module.factory('jmxTreeLazyLoadRegistry', function () {
        return Core.lazyLoaders;
    });
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core.fileUploadMBean = "hawtio:type=UploadManager";
    var FileUpload = (function () {
        function FileUpload() {
            this.restrict = 'A';
            this.replace = true;
            this.templateUrl = Core.templatePath + "fileUpload.html";
            this.scope = {
                files: '=hawtioFileUpload',
                target: '@',
                showFiles: '@'
            };
            this.controller = ["$scope", "$element", "$attrs", "jolokia", function ($scope, $element, $attrs, jolokia) {
                $scope.target = '';
                $scope.response = '';
                $scope.percentComplete = 0;
                UI.observe($scope, $attrs, 'target', '');
                UI.observe($scope, $attrs, 'showFiles', true);
                $scope.update = function (response) {
                    var responseJson = angular.toJson(response.value);
                    if ($scope.responseJson !== responseJson) {
                        $scope.responseJson = responseJson;
                        $scope.files = response.value;
                        Core.$applyNowOrLater($scope);
                    }
                };
                $scope.delete = function (fileName) {
                    jolokia.request({
                        type: 'exec',
                        mbean: Core.fileUploadMBean,
                        operation: 'delete(java.lang.String, java.lang.String)',
                        arguments: [$scope.target, fileName]
                    }, {
                        success: function () {
                            Core.$apply($scope);
                        },
                        error: function (response) {
                            Core.notification('error', "Failed to delete " + fileName + " due to: " + response.error);
                            Core.$apply($scope);
                        }
                    });
                };
                $scope.$watch('target', function (newValue, oldValue) {
                    if (oldValue !== newValue) {
                        Core.unregister(jolokia, $scope);
                    }
                    Core.register(jolokia, $scope, {
                        type: 'exec',
                        mbean: Core.fileUploadMBean,
                        operation: 'list(java.lang.String)',
                        arguments: [$scope.target]
                    }, onSuccess($scope.update));
                });
            }];
            this.link = function ($scope, $element, $attrs) {
                var fileInput = $element.find('input[type=file]');
                var form = $element.find('form[name=file-upload]');
                var button = $element.find('input[type=button]');
                var onFileChange = function () {
                    button.prop('disabled', true);
                    var files = fileInput.get(0).files;
                    var fileName = files.length + " files";
                    if (files.length === 1) {
                        fileName = files[0].name;
                    }
                    form.ajaxSubmit({
                        beforeSubmit: function (arr, $form, options) {
                            Core.notification('info', "Uploading " + fileName);
                            $scope.percentComplete = 0;
                            Core.$apply($scope);
                        },
                        success: function (response, statusText, xhr, $form) {
                            Core.notification('success', "Uploaded " + fileName);
                            setTimeout(function () {
                                button.prop('disabled', false);
                                $scope.percentComplete = 0;
                                Core.$apply($scope);
                            }, 1000);
                            Core.$apply($scope);
                        },
                        error: function (response, statusText, xhr, $form) {
                            Core.notification('error', "Failed to upload " + fileName + " due to " + statusText);
                            setTimeout(function () {
                                button.prop('disabled', false);
                                $scope.percentComplete = 0;
                                Core.$apply($scope);
                            }, 1000);
                            Core.$apply($scope);
                        },
                        uploadProgress: function (event, position, total, percentComplete) {
                            $scope.percentComplete = percentComplete;
                            Core.$apply($scope);
                        }
                    });
                    return false;
                };
                button.click(function () {
                    if (!button.prop('disabled')) {
                        fileInput.click();
                    }
                    return false;
                });
                form.submit(function () {
                    return false;
                });
                if ($.browser.msie) {
                    fileInput.click(function (event) {
                        setTimeout(function () {
                            if (fileInput.val().length > 0) {
                                onFileChange();
                            }
                        }, 0);
                    });
                }
                else {
                    fileInput.change(onFileChange);
                }
            };
        }
        return FileUpload;
    })();
    Core.FileUpload = FileUpload;
    Core._module.directive('hawtioFileUpload', function () {
        return new Core.FileUpload();
    });
})(Core || (Core = {}));
var Core;
(function (Core) {
    function d3ForceGraph(scope, nodes, links, canvasElement) {
        if (scope.graphForce) {
            scope.graphForce.stop();
        }
        if (!canvasElement) {
            canvasElement = $("#canvas")[0];
        }
        var canvasDiv = $(canvasElement);
        canvasDiv.children("svg").remove();
        if (nodes.length) {
            var width = canvasDiv.parent().width();
            var height = canvasDiv.parent().height();
            if (height < 100) {
                var offset = canvasDiv.offset();
                height = $(document).height() - 5;
                if (offset) {
                    height -= offset['top'];
                }
            }
            var svg = d3.select(canvasDiv[0]).append("svg").attr("width", width).attr("height", height);
            var force = d3.layout.force().distance(100).charge(-120 * 10).linkDistance(50).size([width, height]);
            scope.graphForce = force;
            svg.append("svg:defs").selectAll("marker").data(["from"]).enter().append("svg:marker").attr("id", String).attr("viewBox", "0 -5 10 10").attr("refX", 25).attr("refY", -1.5).attr("markerWidth", 6).attr("markerHeight", 6).attr("orient", "auto").append("svg:path").attr("d", "M0,-5L10,0L0,5");
            force.nodes(nodes).links(links).start();
            var link = svg.selectAll(".link").data(links).enter().append("line").attr("class", "link");
            link.attr("class", "link from");
            link.attr("marker-end", "url(#from)");
            var node = svg.selectAll(".node").data(nodes).enter().append("g").attr("class", "node").call(force.drag);
            node.append("image").attr("xlink:href", function (d) {
                return d.imageUrl;
            }).attr("x", -15).attr("y", -15).attr("width", 30).attr("height", 30);
            node.append("text").attr("dx", 20).attr("dy", ".35em").text(function (d) {
                return d.label;
            });
            force.on("tick", function () {
                link.attr("x1", function (d) {
                    return d.source.x;
                }).attr("y1", function (d) {
                    return d.source.y;
                }).attr("x2", function (d) {
                    return d.target.x;
                }).attr("y2", function (d) {
                    return d.target.y;
                });
                node.attr("transform", function (d) {
                    return "translate(" + d.x + "," + d.y + ")";
                });
            });
        }
    }
    Core.d3ForceGraph = d3ForceGraph;
    function createGraphStates(nodes, links, transitions) {
        var stateKeys = {};
        nodes.forEach(function (node) {
            var idx = node.id;
            if (idx === undefined) {
                console.log("No node found for node " + JSON.stringify(node));
            }
            else {
                if (node.edges === undefined)
                    node.edges = [];
                if (!node.label)
                    node.label = "node " + idx;
                stateKeys[idx] = node;
            }
        });
        var states = d3.values(stateKeys);
        links.forEach(function (d) {
            var source = stateKeys[d.source];
            var target = stateKeys[d.target];
            if (source === undefined || target === undefined) {
                console.log("Bad link!  " + source + " target " + target + " for " + d);
            }
            else {
                var edge = { source: source, target: target };
                transitions.push(edge);
                source.edges.push(edge);
                target.edges.push(edge);
            }
        });
        return states;
    }
    Core.createGraphStates = createGraphStates;
    function dagreLayoutGraph(nodes, links, width, height, svgElement) {
        var nodePadding = 10;
        var transitions = [];
        var states = Core.createGraphStates(nodes, links, transitions);
        function spline(e) {
            var points = e.dagre.points.slice(0);
            var source = dagre.util.intersectRect(e.source.dagre, points.length > 0 ? points[0] : e.source.dagre);
            var target = dagre.util.intersectRect(e.target.dagre, points.length > 0 ? points[points.length - 1] : e.source.dagre);
            points.unshift(source);
            points.push(target);
            return d3.svg.line().x(function (d) {
                return d.x;
            }).y(function (d) {
                return d.y;
            }).interpolate("linear")(points);
        }
        function translateEdge(e, dx, dy) {
            e.dagre.points.forEach(function (p) {
                p.x = Math.max(0, Math.min(svgBBox.width, p.x + dx));
                p.y = Math.max(0, Math.min(svgBBox.height, p.y + dy));
            });
        }
        var svg = svgElement ? d3.select(svgElement) : d3.select("svg");
        if (svgElement) {
            $(svgElement).children("g").remove();
        }
        $(svg).children("g").remove();
        var svgGroup = svg.append("g").attr("transform", "translate(5, 5)");
        var nodes = svgGroup.selectAll("g .node").data(states).enter().append("g").attr("class", "node").attr("data-cid", function (d) {
            return d.cid;
        }).attr("id", function (d) {
            return "node-" + d.label;
        });
        nodes.append("title").text(function (d) {
            return d.tooltip || "";
        });
        var edges = svgGroup.selectAll("path .edge").data(transitions).enter().append("path").attr("class", "edge").attr("marker-end", "url(#arrowhead)");
        var rects = nodes.append("rect").attr("rx", "4").attr("ry", "4").attr("class", function (d) {
            return d.type;
        });
        var images = nodes.append("image").attr("xlink:href", function (d) {
            return d.imageUrl;
        }).attr("x", -12).attr("y", -20).attr("height", 24).attr("width", 24);
        var counters = nodes.append("text").attr("text-anchor", "end").attr("class", "counter").attr("x", 0).attr("dy", 0).text(_counterFunction);
        var labels = nodes.append("text").attr("text-anchor", "middle").attr("x", 0);
        labels.append("tspan").attr("x", 0).attr("dy", 28).text(function (d) {
            return d.label;
        });
        var labelPadding = 12;
        var minLabelwidth = 80;
        labels.each(function (d) {
            var bbox = this.getBBox();
            d.bbox = bbox;
            if (bbox.width < minLabelwidth) {
                bbox.width = minLabelwidth;
            }
            d.width = bbox.width + 2 * nodePadding;
            d.height = bbox.height + 2 * nodePadding + labelPadding;
        });
        rects.attr("x", function (d) {
            return -(d.bbox.width / 2 + nodePadding);
        }).attr("y", function (d) {
            return -(d.bbox.height / 2 + nodePadding + (labelPadding / 2));
        }).attr("width", function (d) {
            return d.width;
        }).attr("height", function (d) {
            return d.height;
        });
        images.attr("x", function (d) {
            return -(d.bbox.width) / 2;
        });
        labels.attr("x", function (d) {
            return -d.bbox.width / 2;
        }).attr("y", function (d) {
            return -d.bbox.height / 2;
        });
        counters.attr("x", function (d) {
            var w = d.bbox.width;
            return w / 2;
        });
        dagre.layout().nodeSep(50).edgeSep(10).rankSep(50).nodes(states).edges(transitions).debugLevel(1).run();
        nodes.attr("transform", function (d) {
            return 'translate(' + d.dagre.x + ',' + d.dagre.y + ')';
        });
        edges.attr('id', function (e) {
            return e.dagre.id;
        }).attr("d", function (e) {
            return spline(e);
        });
        var svgNode = svg.node();
        if (svgNode) {
            var svgBBox = svgNode.getBBox();
            if (svgBBox) {
                svg.attr("width", svgBBox.width + 10);
                svg.attr("height", svgBBox.height + 10);
            }
        }
        var nodeDrag = d3.behavior.drag().origin(function (d) {
            return d.pos ? { x: d.pos.x, y: d.pos.y } : { x: d.dagre.x, y: d.dagre.y };
        }).on('drag', function (d, i) {
            var prevX = d.dagre.x, prevY = d.dagre.y;
            d.dagre.x = Math.max(d.width / 2, Math.min(svgBBox.width - d.width / 2, d3.event.x));
            d.dagre.y = Math.max(d.height / 2, Math.min(svgBBox.height - d.height / 2, d3.event.y));
            d3.select(this).attr('transform', 'translate(' + d.dagre.x + ',' + d.dagre.y + ')');
            var dx = d.dagre.x - prevX, dy = d.dagre.y - prevY;
            d.edges.forEach(function (e) {
                translateEdge(e, dx, dy);
                d3.select('#' + e.dagre.id).attr('d', spline(e));
            });
        });
        var edgeDrag = d3.behavior.drag().on('drag', function (d, i) {
            translateEdge(d, d3.event.dx, d3.event.dy);
            d3.select(this).attr('d', spline(d));
        });
        nodes.call(nodeDrag);
        edges.call(edgeDrag);
        return states;
    }
    Core.dagreLayoutGraph = dagreLayoutGraph;
    function dagreUpdateGraphData(data) {
        var svg = d3.select("svg");
        svg.selectAll("text.counter").text(_counterFunction);
        svg.selectAll("g .node title").text(function (d) {
            return d.tooltip || "";
        });
    }
    Core.dagreUpdateGraphData = dagreUpdateGraphData;
    function _counterFunction(d) {
        return d.counter || "";
    }
})(Core || (Core = {}));
var Core;
(function (Core) {
    var GridStyle = (function () {
        function GridStyle($window) {
            var _this = this;
            this.$window = $window;
            this.restrict = 'C';
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        GridStyle.prototype.doLink = function (scope, element, attrs) {
            var lastHeight = 0;
            var resizeFunc = angular.bind(this, function (scope) {
                var top = element.position().top;
                var windowHeight = $(this.$window).height();
                var height = windowHeight - top - 15;
                var heightStr = height + 'px';
                element.css({
                    'min-height': heightStr,
                    'height': heightStr
                });
                if (lastHeight !== height) {
                    lastHeight = height;
                    element.trigger('resize');
                }
            });
            resizeFunc();
            scope.$watch(resizeFunc);
            $(this.$window).resize(function () {
                resizeFunc();
                Core.$apply(scope);
                return false;
            });
        };
        return GridStyle;
    })();
    Core.GridStyle = GridStyle;
    Core._module.directive('gridStyle', ["$window", function ($window) {
        return new Core.GridStyle($window);
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.HelpController", ["$scope", "$routeParams", "marked", "helpRegistry", "branding", function ($scope, $routeParams, marked, helpRegistry, branding) {
        $scope.branding = branding;
        $scope.topics = helpRegistry.getTopics();
        if ('topic' in $routeParams) {
            $scope.topic = $routeParams['topic'];
        }
        else {
            $scope.topic = 'index';
        }
        if ('subtopic' in $routeParams) {
            $scope.subTopic = $routeParams['subtopic'];
        }
        else {
            $scope.subTopic = Object.extended($scope.topics[$scope.topic]).keys().first();
        }
        Core.log.debug("topic: ", $scope.topic, " subtopic: ", $scope.subTopic);
        var isIndex = $scope.topic === "index";
        var filterSubTopic = $scope.subTopic;
        if (isIndex && filterSubTopic !== "developer") {
            filterSubTopic = "user";
        }
        $scope.breadcrumbs = [
            {
                topic: "index",
                subTopic: "user",
                label: "User Guide"
            },
            {
                topic: "index",
                subTopic: "faq",
                label: "FAQ"
            },
            {
                topic: "index",
                subTopic: "changes",
                label: "Changes"
            },
            {
                topic: "index",
                subTopic: "developer",
                label: "Developers"
            }
        ];
        $scope.sectionLink = function (section) {
            var topic = section.topic || "";
            var subTopic = section.subTopic || "";
            var link = Core.pathGet(helpRegistry.topics, [topic, subTopic]);
            if (link && link.indexOf("#") >= 0) {
                return link;
            }
            else {
                return "#/help/" + topic + "/" + subTopic;
            }
        };
        var activeBreadcrumb = $scope.breadcrumbs.find(function (b) { return b.topic === $scope.topic && b.subTopic === $scope.subTopic; });
        if (activeBreadcrumb)
            activeBreadcrumb.active = true;
        $scope.sections = [];
        angular.forEach($scope.topics, function (details, topic) {
            if (topic !== "index" && details[filterSubTopic]) {
                $scope.sections.push({
                    topic: topic,
                    subTopic: filterSubTopic,
                    label: helpRegistry.mapTopicName(topic),
                    active: topic === $scope.topic
                });
            }
        });
        $scope.sections = $scope.sections.sortBy("label");
        $scope.$on('hawtioNewHelpTopic', function () {
            $scope.topics = helpRegistry.getTopics();
        });
        $scope.$watch('topics', function (newValue, oldValue) {
            Core.log.debug("Topics: ", $scope.topics);
        });
        if (!angular.isDefined($scope.topics[$scope.topic])) {
            $scope.html = "Unable to download help data for " + $scope.topic;
        }
        else {
            $.ajax({
                url: $scope.topics[$scope.topic][$scope.subTopic],
                dataType: 'html',
                cache: false,
                success: function (data, textStatus, jqXHR) {
                    $scope.html = "Unable to download help data for " + $scope.topic;
                    if (angular.isDefined(data)) {
                        $scope.html = marked(data);
                    }
                    Core.$apply($scope);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    $scope.html = "Unable to download help data for " + $scope.topic;
                    Core.$apply($scope);
                }
            });
        }
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.JolokiaPreferences", ["$scope", "localStorage", "jolokiaParams", "$window", function ($scope, localStorage, jolokiaParams, $window) {
        Core.initPreferenceScope($scope, localStorage, {
            'maxDepth': {
                'value': Core.DEFAULT_MAX_DEPTH,
                'converter': parseInt,
                'formatter': parseInt,
                'post': function (newValue) {
                    jolokiaParams.maxDepth = newValue;
                    localStorage['jolokiaParams'] = angular.toJson(jolokiaParams);
                }
            },
            'maxCollectionSize': {
                'value': Core.DEFAULT_MAX_COLLECTION_SIZE,
                'converter': parseInt,
                'formatter': parseInt,
                'post': function (newValue) {
                    jolokiaParams.maxCollectionSize = newValue;
                    localStorage['jolokiaParams'] = angular.toJson(jolokiaParams);
                }
            }
        });
        $scope.reboot = function () {
            $window.location.reload();
        };
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.factory('jolokia', ["$location", "localStorage", "jolokiaStatus", "$rootScope", "userDetails", "jolokiaParams", "jolokiaUrl", function ($location, localStorage, jolokiaStatus, $rootScope, userDetails, jolokiaParams, jolokiaUrl) {
        Core.log.debug("Jolokia URL is " + jolokiaUrl);
        if (jolokiaUrl) {
            var connectionName = Core.getConnectionNameParameter($location.search());
            var connectionOptions = Core.getConnectOptions(connectionName);
            var username = null;
            var password = null;
            var found = false;
            try {
                if (window.opener && "passUserDetails" in window.opener) {
                    username = window.opener["passUserDetails"].username;
                    password = window.opener["passUserDetails"].password;
                    found = true;
                }
            }
            catch (securityException) {
            }
            if (!found) {
                if (connectionOptions && connectionOptions.userName && connectionOptions.password) {
                    username = connectionOptions.userName;
                    password = connectionOptions.password;
                }
                else if (angular.isDefined(userDetails) && angular.isDefined(userDetails.username) && angular.isDefined(userDetails.password)) {
                    username = userDetails.username;
                    password = userDetails.password;
                }
                else {
                    var search = hawtioPluginLoader.parseQueryString();
                    username = search["_user"];
                    password = search["_pwd"];
                    if (angular.isArray(username))
                        username = username[0];
                    if (angular.isArray(password))
                        password = password[0];
                }
            }
            if (username && password) {
                userDetails.username = username;
                userDetails.password = password;
                $.ajaxSetup({
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', Core.getBasicAuthHeader(userDetails.username, userDetails.password));
                    }
                });
                var loginUrl = jolokiaUrl.replace("jolokia", "auth/login/");
                $.ajax(loginUrl, {
                    type: "POST",
                    success: function (response) {
                        if (response['credentials'] || response['principals']) {
                            userDetails.loginDetails = {
                                'credentials': response['credentials'],
                                'principals': response['principals']
                            };
                        }
                        else {
                            var doc = Core.pathGet(response, ['children', 0, 'innerHTML']);
                            if (doc) {
                                Core.log.debug("Response is a document (ignoring this): ", doc);
                            }
                        }
                        Core.executePostLoginTasks();
                    },
                    error: function (xhr, textStatus, error) {
                        Core.executePostLoginTasks();
                    }
                });
            }
            jolokiaParams['ajaxError'] = function (xhr, textStatus, error) {
                if (xhr.status === 401 || xhr.status === 403) {
                    userDetails.username = null;
                    userDetails.password = null;
                    delete userDetails.loginDetails;
                    if (found) {
                        delete window.opener["passUserDetails"];
                    }
                }
                else {
                    jolokiaStatus.xhr = xhr;
                    if (!xhr.responseText && error) {
                        xhr.responseText = error.stack;
                    }
                }
                Core.$apply($rootScope);
            };
            var jolokia = new Jolokia(jolokiaParams);
            localStorage['url'] = jolokiaUrl;
            jolokia.stop();
            return jolokia;
        }
        else {
            var answer = {
                running: false,
                request: function (req, opts) { return null; },
                register: function (req, opts) { return null; },
                list: function (path, opts) { return null; },
                search: function (mBeanPatter, opts) { return null; },
                getAttribute: function (mbean, attribute, path, opts) { return null; },
                setAttribute: function (mbean, attribute, value, path, opts) {
                },
                version: function (opts) { return null; },
                execute: function (mbean, operation) {
                    var args = [];
                    for (var _i = 2; _i < arguments.length; _i++) {
                        args[_i - 2] = arguments[_i];
                    }
                    return null;
                },
                start: function (period) {
                    answer.running = true;
                },
                stop: function () {
                    answer.running = false;
                },
                isRunning: function () { return answer.running; },
                jobs: function () { return []; }
            };
            return answer;
        }
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.LoggingPreferences", ["$scope", function ($scope) {
        Core.initPreferenceScope($scope, localStorage, {
            'logBuffer': {
                'value': 100,
                'converter': parseInt,
                'formatter': parseInt,
                'post': function (newValue) {
                    window['LogBuffer'] = newValue;
                }
            },
            'logLevel': {
                'value': '{"value": 2, "name": "INFO"}',
                'post': function (value) {
                    var level = angular.fromJson(value);
                    Logger.setLevel(level);
                }
            }
        });
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core.NavBarController = Core._module.controller("Core.NavBarController", ["$scope", "$location", "workspace", "$route", "jolokia", "localStorage", "NavBarViewCustomLinks", "postLoginTasks", function ($scope, $location, workspace, $route, jolokia, localStorage, NavBarViewCustomLinks, postLoginTasks) {
        $scope.hash = workspace.hash();
        $scope.topLevelTabs = [];
        $scope.subLevelTabs = workspace.subLevelTabs;
        $scope.currentPerspective = null;
        $scope.localStorage = localStorage;
        $scope.recentConnections = [];
        $scope.goTo = function (destination) {
            $location.url(destination);
        };
        $scope.$watch('localStorage.recentConnections', function (newValue, oldValue) {
            $scope.recentConnections = Core.getRecentConnections(localStorage);
        });
        $scope.openConnection = function (connection) {
            var connectOptions = Core.getConnectOptions(connection);
            if (connectOptions) {
                Core.connectToServer(localStorage, connectOptions);
            }
        };
        $scope.goHome = function () {
            window.open(".");
        };
        $scope.clearConnections = Core.clearConnections;
        postLoginTasks.addTask('navbarReloadPerspectives', reloadPerspective);
        $scope.perspectiveDetails = {
            perspective: null
        };
        $scope.topLevelTabs = function () {
            reloadPerspective();
            return workspace.topLevelTabs;
        };
        $scope.$on('jmxTreeUpdated', function () {
            reloadPerspective();
        });
        $scope.$watch('workspace.topLevelTabs', function () {
            reloadPerspective();
        });
        $scope.validSelection = function (uri) { return workspace.validSelection(uri); };
        $scope.isValid = function (nav) { return nav && nav.isValid(workspace); };
        $scope.switchPerspective = function (perspective) {
            if (perspective.onSelect && angular.isFunction(perspective.onSelect)) {
                perspective.onSelect.apply();
                return;
            }
            var searchPerspectiveId = $location.search()[Perspective.perspectiveSearchId];
            if (perspective && ($scope.currentPerspective !== perspective || perspective.id !== searchPerspectiveId)) {
                Logger.debug("Changed the perspective to " + JSON.stringify(perspective) + " from search id " + searchPerspectiveId);
                if ($scope.currentPerspective) {
                    $scope.currentPerspective.lastPage = $location.url();
                }
                var pid = perspective.id;
                $location.search(Perspective.perspectiveSearchId, pid);
                Logger.debug("Setting perspective to " + pid);
                $scope.currentPerspective = perspective;
                reloadPerspective();
                $scope.topLevelTabs = Perspective.getTopLevelTabsForPerspective($location, workspace, jolokia, localStorage);
                var defaultPlugin = Core.getDefaultPlugin(pid, workspace, jolokia, localStorage);
                var defaultTab;
                var path;
                if (defaultPlugin) {
                    $scope.topLevelTabs.forEach(function (tab) {
                        if (tab.id === defaultPlugin.id) {
                            defaultTab = tab;
                        }
                    });
                    if (defaultTab) {
                        path = Core.trimLeading(defaultTab.href(), "#");
                    }
                }
                else {
                    if (perspective.lastPage) {
                        path = Core.trimLeading(perspective.lastPage, "#");
                    }
                }
                if (path) {
                    var idx = path.indexOf("?p=") || path.indexOf("&p=");
                    if (idx > 0) {
                        path = path.substring(0, idx);
                    }
                    var sep = (path.indexOf("?") >= 0) ? "&" : "?";
                    path += sep + "p=" + pid;
                    $location.url(path);
                }
            }
        };
        $scope.$watch('hash', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                Core.log.debug("hash changed from ", oldValue, " to ", newValue);
            }
        });
        $scope.$on('$routeChangeSuccess', function () {
            $scope.hash = workspace.hash();
            reloadPerspective();
        });
        $scope.link = function (nav, includePerspective) {
            if (includePerspective === void 0) { includePerspective = false; }
            var href;
            if (angular.isString(nav)) {
                href = nav;
            }
            else {
                href = nav.href();
            }
            var removeParams = ['tab', 'nid', 'chapter', 'pref', 'q'];
            if (!includePerspective) {
                if (href.indexOf("?p=") >= 0 || href.indexOf("&p=") >= 0) {
                    removeParams.push("p");
                }
            }
            return Core.createHref($location, href, removeParams);
        };
        $scope.fullScreenLink = function () {
            var href = "#" + $location.path() + "?tab=notree";
            return Core.createHref($location, href, ['tab']);
        };
        $scope.addToDashboardLink = function () {
            var href = "#" + $location.path() + workspace.hash();
            var answer = "#/dashboard/add?tab=dashboard&href=" + encodeURIComponent(href);
            if ($location.url().has("/jmx/charts")) {
                var size = {
                    size_x: 4,
                    size_y: 3
                };
                answer += "&size=" + encodeURIComponent(angular.toJson(size));
            }
            return answer;
        };
        $scope.isActive = function (nav) {
            if (angular.isString(nav))
                return workspace.isLinkActive(nav);
            var fn = nav.isActive;
            if (fn) {
                return fn(workspace);
            }
            return workspace.isLinkActive(nav.href());
        };
        $scope.isTopTabActive = function (nav) {
            if (angular.isString(nav))
                return workspace.isTopTabActive(nav);
            var fn = nav.isActive;
            if (fn) {
                return fn(workspace);
            }
            return workspace.isTopTabActive(nav.href());
        };
        $scope.activeLink = function () {
            var tabs = $scope.topLevelTabs();
            if (!tabs) {
                return "Loading...";
            }
            var tab = tabs.find(function (nav) {
                return $scope.isActive(nav);
            });
            return tab ? tab['content'] : "";
        };
        $scope.navBarViewCustomLinks = NavBarViewCustomLinks;
        $scope.isCustomLinkSet = function () {
            return $scope.navBarViewCustomLinks.list.length;
        };
        function reloadPerspective() {
            var perspectives = Perspective.getPerspectives($location, workspace, jolokia, localStorage);
            var currentId = Perspective.currentPerspectiveId($location, workspace, jolokia, localStorage);
            var newTopLevelTabs = Perspective.getTopLevelTabsForPerspective($location, workspace, jolokia, localStorage);
            var diff = newTopLevelTabs.subtract($scope.topLevelTabs);
            if (diff && diff.length > 0) {
                $scope.topLevelTabs = newTopLevelTabs;
                $scope.perspectiveId = currentId;
                $scope.perspectives = perspectives;
                $scope.perspectiveDetails.perspective = $scope.perspectives.find(function (p) {
                    return p['id'] === currentId;
                });
                Core.$apply($scope);
            }
        }
    }]);
    Core._module.service("NavBarViewCustomLinks", ['$location', '$rootScope', function ($location, $rootScope) {
        return {
            list: [],
            dropDownLabel: "Extra"
        };
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core.PluginPreferences = Core._module.controller("Core.PluginPreferences", ["$scope", "localStorage", "$location", "workspace", "jolokia", function ($scope, localStorage, $location, workspace, jolokia) {
        Core.initPreferenceScope($scope, localStorage, {
            'autoRefresh': {
                'value': true,
                'converter': Core.parseBooleanValue
            }
        });
        $scope.perspectiveId = null;
        $scope.perspectives = [];
        $scope.plugins = [];
        $scope.pluginDirty = false;
        $scope.pluginMoveUp = function (index) {
            $scope.pluginDirty = true;
            var tmp = $scope.plugins[index];
            $scope.plugins[index] = $scope.plugins[index - 1];
            $scope.plugins[index - 1] = tmp;
        };
        $scope.pluginMoveDown = function (index) {
            $scope.pluginDirty = true;
            var tmp = $scope.plugins[index];
            $scope.plugins[index] = $scope.plugins[index + 1];
            $scope.plugins[index + 1] = tmp;
        };
        $scope.pluginDisable = function (index) {
            $scope.pluginDirty = true;
            var atLeastOneEnabled = false;
            $scope.plugins.forEach(function (p, idx) {
                if (idx != index && p.enabled) {
                    atLeastOneEnabled = true;
                }
            });
            if (atLeastOneEnabled) {
                $scope.plugins[index].enabled = false;
                $scope.plugins[index].isDefault = false;
            }
        };
        $scope.pluginEnable = function (index) {
            $scope.pluginDirty = true;
            $scope.plugins[index].enabled = true;
        };
        $scope.pluginDefault = function (index) {
            $scope.pluginDirty = true;
            $scope.plugins.forEach(function (p) {
                p.isDefault = false;
            });
            $scope.plugins[index].isDefault = true;
            $scope.plugins[index].enabled = true;
        };
        $scope.pluginApply = function () {
            $scope.pluginDirty = false;
            var noDefault = true;
            $scope.plugins.forEach(function (p, idx) {
                if (p.isDefault) {
                    noDefault = false;
                }
                p.index = idx;
            });
            if (noDefault) {
                $scope.plugins.find(function (p) {
                    return p.enabled == true;
                }).isDefault = true;
            }
            var json = angular.toJson($scope.plugins);
            if (json) {
                Core.log.debug("Saving plugin settings for perspective " + $scope.perspectiveId + " -> " + json);
                var id = "plugins-" + $scope.perspectiveId;
                localStorage[id] = json;
            }
            setTimeout(function () {
                window.location.hash = "#";
            }, 10);
        };
        $scope.$watch('perspectiveId', function (newValue, oldValue) {
            if (newValue === oldValue) {
                return;
            }
            var perspective = Perspective.getPerspectiveById(newValue);
            if (perspective) {
                updateToPerspective(perspective);
                Core.$apply($scope);
            }
        });
        function updateToPerspective(perspective) {
            var plugins = Core.configuredPluginsForPerspectiveId(perspective.id, workspace, jolokia, localStorage);
            $scope.plugins = plugins;
            $scope.perspectiveId = perspective.id;
            Core.log.debug("Updated to perspective " + $scope.perspectiveId + " with " + plugins.length + " plugins");
        }
        $scope.perspectives = Perspective.getPerspectives($location, workspace, jolokia, localStorage);
        Core.log.debug("There are " + $scope.perspectives.length + " perspectives");
        var selectPerspective;
        var perspectiveId = Perspective.currentPerspectiveId($location, workspace, jolokia, localStorage);
        if (perspectiveId) {
            selectPerspective = $scope.perspectives.find(function (p) { return p.id === perspectiveId; });
        }
        if (!selectPerspective) {
            selectPerspective = $scope.perspectives[0];
        }
        updateToPerspective(selectPerspective);
        Core.$apply($scope);
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.PreferencesController", ["$scope", "$location", "workspace", "preferencesRegistry", "$element", function ($scope, $location, workspace, preferencesRegistry, $element) {
        Core.bindModelToSearchParam($scope, $location, "pref", "pref", "Core");
        $scope.panels = {};
        $scope.$watch(function () {
            return $element.is(':visible');
        }, function (newValue, oldValue) {
            if (newValue) {
                setTimeout(function () {
                    $scope.panels = preferencesRegistry.getTabs();
                    Core.log.debug("Panels: ", $scope.panels);
                    Core.$apply($scope);
                }, 50);
            }
        });
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.ResetPreferences", ["$scope", "userDetails", "jolokiaUrl", "localStorage", function ($scope, userDetails, jolokiaUrl, localStorage) {
        $scope.doReset = function () {
            Core.log.info("Resetting");
            var doReset = function () {
                localStorage.clear();
                setTimeout(function () {
                    window.location.reload();
                }, 10);
            };
            if (Core.isBlank(userDetails.username) && Core.isBlank(userDetails.password)) {
                doReset();
            }
            else {
                Core.logout(jolokiaUrl, userDetails, localStorage, $scope, doReset);
            }
        };
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core.ViewController = Core._module.controller("Core.ViewController", ["$scope", "$route", "$location", "layoutTree", "layoutFull", "viewRegistry", function ($scope, $route, $location, layoutTree, layoutFull, viewRegistry) {
        findViewPartial();
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            findViewPartial();
        });
        function searchRegistry(path) {
            var answer = undefined;
            Object.extended(viewRegistry).keys(function (key, value) {
                if (!answer) {
                    if (key.startsWith("/") && key.endsWith("/")) {
                        var text = key.substring(1, key.length - 1);
                        try {
                            var reg = new RegExp(text, "");
                            if (reg.exec(path)) {
                                answer = value;
                            }
                        }
                        catch (e) {
                            Core.log.debug("Invalid RegExp " + text + " for viewRegistry value: " + value);
                        }
                    }
                    else {
                        if (path.startsWith(key)) {
                            answer = value;
                        }
                    }
                }
            });
            return answer;
        }
        function findViewPartial() {
            var answer = null;
            var hash = $location.search();
            var tab = hash['tab'];
            if (angular.isString(tab)) {
                answer = searchRegistry(tab);
            }
            if (!answer) {
                var path = $location.path();
                if (path) {
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    answer = searchRegistry(path);
                }
            }
            if (!answer) {
                answer = layoutTree;
            }
            $scope.viewPartial = answer;
            Core.log.debug("Using view partial: " + answer);
            return answer;
        }
    }]);
})(Core || (Core = {}));
var Core;
(function (Core) {
    Core._module.controller("Core.WelcomeController", ["$scope", "$location", "branding", "localStorage", function ($scope, $location, branding, localStorage) {
        $scope.branding = branding;
        var log = Logger.get("Welcome");
        $scope.stopShowingWelcomePage = function () {
            log.debug("Stop showing welcome page");
            localStorage['showWelcomePage'] = false;
            $location.path("/");
        };
        $scope.$watch('branding.welcomePageUrl', function (newValue, oldValue) {
            $.ajax({
                url: branding.welcomePageUrl,
                dataType: 'html',
                cache: false,
                success: function (data, textStatus, jqXHR) {
                    $scope.html = "Unable to download welcome.md";
                    if (angular.isDefined(data)) {
                        $scope.html = branding.onWelcomePage(data);
                    }
                    Core.$apply($scope);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    $scope.html = "Unable to download welcome.md";
                    Core.$apply($scope);
                }
            });
        });
    }]);
})(Core || (Core = {}));
var Dashboard;
(function (Dashboard) {
    Dashboard.log = Logger.get('Dashboard');
    function cleanDashboardData(item) {
        var cleanItem = {};
        angular.forEach(item, function (value, key) {
            if (!angular.isString(key) || (!key.startsWith("$") && !key.startsWith("_"))) {
                cleanItem[key] = value;
            }
        });
        return cleanItem;
    }
    Dashboard.cleanDashboardData = cleanDashboardData;
    function decodeURIComponentProperties(hash) {
        if (!hash) {
            return hash;
        }
        var decodeHash = {};
        angular.forEach(hash, function (value, key) {
            decodeHash[key] = value ? decodeURIComponent(value) : value;
        });
        return decodeHash;
    }
    Dashboard.decodeURIComponentProperties = decodeURIComponentProperties;
    function onOperationComplete(result) {
        console.log("Completed adding the dashboard with response " + JSON.stringify(result));
    }
    Dashboard.onOperationComplete = onOperationComplete;
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    Dashboard.templatePath = 'app/dashboard/html/';
    Dashboard.pluginName = 'dashboard';
    Dashboard._module = angular.module(Dashboard.pluginName, ['bootstrap', 'ngResource', 'hawtioCore', 'hawtio-ui']);
    Dashboard._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/dashboard/add', { templateUrl: Dashboard.templatePath + 'addToDashboard.html' }).when('/dashboard/edit', { templateUrl: Dashboard.templatePath + 'editDashboards.html' }).when('/dashboard/idx/:dashboardIndex', { templateUrl: Dashboard.templatePath + 'dashboard.html' }).when('/dashboard/id/:dashboardId', { templateUrl: Dashboard.templatePath + 'dashboard.html' }).when('/dashboard/id/:dashboardId/share', { templateUrl: Dashboard.templatePath + 'share.html' }).when('/dashboard/import', { templateUrl: Dashboard.templatePath + 'import.html' });
    }]);
    Dashboard._module.value('ui.config', {
        jq: {
            gridster: {
                widget_margins: [10, 10],
                widget_base_dimensions: [140, 140]
            }
        }
    });
    Dashboard._module.factory('dashboardRepository', ["workspace", "jolokia", "localStorage", function (workspace, jolokia, localStorage) {
        return new Dashboard.DefaultDashboardRepository(workspace, jolokia, localStorage);
    }]);
    Dashboard._module.directive('hawtioDashboard', function () {
        return new Dashboard.GridsterDirective();
    });
    Dashboard._module.run(["$location", "workspace", "viewRegistry", "helpRegistry", function ($location, workspace, viewRegistry, helpRegistry) {
        viewRegistry['dashboard'] = 'app/dashboard/html/layoutDashboard.html';
        helpRegistry.addUserDoc('dashboard', 'app/dashboard/doc/help.md');
        workspace.topLevelTabs.push({
            id: "dashboard",
            content: "Dashboard",
            title: "View and edit your own custom dashboards",
            isValid: function (workspace) { return workspace.hasMBeans(); },
            href: function () { return "#/dashboard/idx/0?tab=dashboard"; },
            isActive: function (workspace) { return workspace.isTopTabActive("dashboard"); }
        });
    }]);
    hawtioPluginLoader.addModule(Dashboard.pluginName);
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    var defaultDashboards = [
        {
            "title": "Monitor",
            "group": "Personal",
            "widgets": [
                {
                    "id": "w1",
                    "title": "Operating System",
                    "row": 1,
                    "col": 1,
                    "size_x": 3,
                    "size_y": 4,
                    "path": "jmx/attributes",
                    "include": "app/jmx/html/attributes.html",
                    "search": {
                        "nid": "root-java.lang-OperatingSystem"
                    },
                    "hash": ""
                },
                {
                    "id": "w3",
                    "title": "Java Heap Memory",
                    "row": 1,
                    "col": 6,
                    "size_x": 2,
                    "size_y": 2,
                    "path": "jmx/widget/donut",
                    "include": "app/jmx/html/donutChart.html",
                    "search": {},
                    "hash": "",
                    "routeParams": "{\"type\":\"donut\",\"title\":\"Java Heap Memory\",\"mbean\":\"java.lang:type=Memory\",\"attribute\":\"HeapMemoryUsage\",\"total\":\"Max\",\"terms\":\"Used\",\"remaining\":\"Free\"}"
                },
                {
                    "id": "w4",
                    "title": "Java Non Heap Memory",
                    "row": 1,
                    "col": 8,
                    "size_x": 2,
                    "size_y": 2,
                    "path": "jmx/widget/donut",
                    "include": "app/jmx/html/donutChart.html",
                    "search": {},
                    "hash": "",
                    "routeParams": "{\"type\":\"donut\",\"title\":\"Java Non Heap Memory\",\"mbean\":\"java.lang:type=Memory\",\"attribute\":\"NonHeapMemoryUsage\",\"total\":\"Max\",\"terms\":\"Used\",\"remaining\":\"Free\"}"
                },
                {
                    "id": "w5",
                    "title": "",
                    "row": 3,
                    "col": 4,
                    "size_x": 6,
                    "size_y": 2,
                    "path": "jmx/charts",
                    "include": "app/jmx/html/charts.html",
                    "search": {
                        "size": "%7B%22size_x%22%3A2%2C%22size_y%22%3A2%7D",
                        "title": "Java%20Non%20Heap%20Memory",
                        "routeParams": "%7B%22type%22%3A%22donut%22%2C%22title%22%3A%22Java%20Non%20Heap%20Memory%22%2C%22mbean%22%3A%22java.lang%3Atype",
                        "nid": "root-java.lang-Threading"
                    },
                    "hash": ""
                },
                {
                    "id": "w6",
                    "title": "System CPU Load",
                    "row": 1,
                    "col": 4,
                    "size_x": 2,
                    "size_y": 2,
                    "path": "jmx/widget/area",
                    "include": "app/jmx/html/areaChart.html",
                    "search": {},
                    "hash": "",
                    "routeParams": "{\"type\":\"area\",\"title\":\"System CPU Load\",\"mbean\":\"java.lang:type=OperatingSystem\",\"attribute\":\"SystemCpuLoad\"}"
                }
            ],
            "id": "4e9d116173ca41767e"
        }
    ];
    var DefaultDashboardRepository = (function () {
        function DefaultDashboardRepository(workspace, jolokia, localStorage) {
            this.workspace = workspace;
            this.jolokia = jolokia;
            this.localStorage = localStorage;
            this.repository = null;
        }
        DefaultDashboardRepository.prototype.putDashboards = function (array, commitMessage, fn) {
            this.getRepository().putDashboards(array, commitMessage, fn);
        };
        DefaultDashboardRepository.prototype.deleteDashboards = function (array, fn) {
            this.getRepository().deleteDashboards(array, fn);
        };
        DefaultDashboardRepository.prototype.getDashboards = function (fn) {
            this.getRepository().getDashboards(function (values) {
                fn(values);
            });
        };
        DefaultDashboardRepository.prototype.getDashboard = function (id, onLoad) {
            this.getRepository().getDashboard(id, onLoad);
        };
        DefaultDashboardRepository.prototype.createDashboard = function (options) {
            return this.getRepository().createDashboard(options);
        };
        DefaultDashboardRepository.prototype.cloneDashboard = function (dashboard) {
            return this.getRepository().cloneDashboard(dashboard);
        };
        DefaultDashboardRepository.prototype.getType = function () {
            return this.getRepository().getType();
        };
        DefaultDashboardRepository.prototype.isValid = function () {
            return this.getRepository().isValid();
        };
        DefaultDashboardRepository.prototype.getRepository = function () {
            if (this.repository && this.repository.isValid()) {
                return this.repository;
            }
            if (Fabric.hasFabric(this.workspace)) {
                this.repository = new Dashboard.FabricDashboardRepository(this.workspace, this.jolokia, this.localStorage);
                return this.repository;
            }
            var git = Git.createGitRepository(this.workspace, this.jolokia, this.localStorage);
            if (git) {
                this.repository = new GitDashboardRepository(this.workspace, git);
                return this.repository;
            }
            this.repository = new LocalDashboardRepository(this.workspace);
            return this.repository;
        };
        return DefaultDashboardRepository;
    })();
    Dashboard.DefaultDashboardRepository = DefaultDashboardRepository;
    var LocalDashboardRepository = (function () {
        function LocalDashboardRepository(workspace) {
            this.workspace = workspace;
            this.localStorage = null;
            this.localStorage = workspace.localStorage;
            if ('userDashboards' in this.localStorage) {
            }
            else {
                this.storeDashboards(defaultDashboards);
            }
        }
        LocalDashboardRepository.prototype.loadDashboards = function () {
            var answer = angular.fromJson(localStorage['userDashboards']);
            if (answer.length === 0) {
                answer.push(this.createDashboard({}));
            }
            Dashboard.log.debug("returning dashboards: ", answer);
            return answer;
        };
        LocalDashboardRepository.prototype.storeDashboards = function (dashboards) {
            Dashboard.log.debug("storing dashboards: ", dashboards);
            localStorage['userDashboards'] = angular.toJson(dashboards);
            return this.loadDashboards();
        };
        LocalDashboardRepository.prototype.putDashboards = function (array, commitMessage, fn) {
            var dashboards = this.loadDashboards();
            array.forEach(function (dash) {
                var existing = dashboards.findIndex(function (d) {
                    return d.id === dash.id;
                });
                if (existing >= 0) {
                    dashboards[existing] = dash;
                }
                else {
                    dashboards.push(dash);
                }
            });
            fn(this.storeDashboards(dashboards));
        };
        LocalDashboardRepository.prototype.deleteDashboards = function (array, fn) {
            var dashboards = this.loadDashboards();
            angular.forEach(array, function (item) {
                dashboards.remove(function (i) {
                    return i.id === item.id;
                });
            });
            fn(this.storeDashboards(dashboards));
        };
        LocalDashboardRepository.prototype.getDashboards = function (fn) {
            fn(this.loadDashboards());
        };
        LocalDashboardRepository.prototype.getDashboard = function (id, fn) {
            var dashboards = this.loadDashboards();
            var dashboard = dashboards.find(function (dashboard) {
                return dashboard.id === id;
            });
            fn(dashboard);
        };
        LocalDashboardRepository.prototype.createDashboard = function (options) {
            var answer = {
                title: "New Dashboard",
                group: "Personal",
                widgets: []
            };
            answer = angular.extend(answer, options);
            answer['id'] = Core.getUUID();
            return answer;
        };
        LocalDashboardRepository.prototype.cloneDashboard = function (dashboard) {
            var newDashboard = Object.clone(dashboard);
            newDashboard['id'] = Core.getUUID();
            newDashboard['title'] = "Copy of " + dashboard.title;
            return newDashboard;
        };
        LocalDashboardRepository.prototype.getType = function () {
            return 'container';
        };
        LocalDashboardRepository.prototype.isValid = function () {
            return !Fabric.hasFabric(this.workspace) && !Git.hasGit(this.workspace);
        };
        return LocalDashboardRepository;
    })();
    Dashboard.LocalDashboardRepository = LocalDashboardRepository;
    var GitDashboardRepository = (function () {
        function GitDashboardRepository(workspace, git) {
            this.workspace = workspace;
            this.git = git;
            this.branch = null;
        }
        GitDashboardRepository.prototype.putDashboards = function (array, commitMessage, fn) {
            var _this = this;
            var toPut = array.length;
            var maybeCallback = function () {
                toPut = toPut - 1;
                if (toPut === 0) {
                    _this.getDashboards(fn);
                }
            };
            angular.forEach(array, function (dash) {
                var path = _this.getDashboardPath(dash);
                var contents = JSON.stringify(dash, null, "  ");
                _this.git.write(_this.branch, path, commitMessage, contents, function () {
                    maybeCallback();
                });
            });
        };
        GitDashboardRepository.prototype.deleteDashboards = function (array, fn) {
            var _this = this;
            var toDelete = array.length;
            var maybeCallback = function () {
                toDelete = toDelete - 1;
                if (toDelete === 0) {
                    _this.getDashboards(fn);
                }
            };
            angular.forEach(array, function (dash) {
                var path = _this.getDashboardPath(dash);
                var commitMessage = "Removing dashboard " + path;
                _this.git.remove(_this.branch, path, commitMessage, function () {
                    maybeCallback();
                });
            });
        };
        GitDashboardRepository.prototype.createDashboard = function (options) {
            var answer = {
                title: "New Dashboard",
                group: "Personal",
                widgets: []
            };
            answer = angular.extend(answer, options);
            answer['id'] = Core.getUUID();
            return answer;
        };
        GitDashboardRepository.prototype.cloneDashboard = function (dashboard) {
            var newDashboard = Object.clone(dashboard);
            newDashboard['id'] = Core.getUUID();
            newDashboard['title'] = "Copy of " + dashboard.title;
            return newDashboard;
        };
        GitDashboardRepository.prototype.getType = function () {
            return 'git';
        };
        GitDashboardRepository.prototype.isValid = function () {
            return Git.hasGit(this.workspace);
        };
        GitDashboardRepository.prototype.getDashboardPath = function (dash) {
            var id = dash.id || Core.getUUID();
            var path = this.getUserDashboardPath(id);
            return path;
        };
        GitDashboardRepository.prototype.getDashboards = function (fn) {
            var _this = this;
            var path = this.getUserDashboardDirectory();
            var dashboards = [];
            this.git.read(this.branch, path, function (details) {
                var files = details.children;
                var toRead = files.length;
                var maybeCallback = function () {
                    toRead = toRead - 1;
                    if (toRead === 0) {
                        dashboards = dashboards.sort(function (d1, d2) {
                            var title1 = d1.title;
                            var title2 = d2.title;
                            return title1.localeCompare(title2);
                        });
                        fn(dashboards);
                    }
                };
                if (files.length === 0) {
                    dashboards.push(_this.createDashboard({}));
                    fn(dashboards);
                    return;
                }
                angular.forEach(files, function (file, idx) {
                    var path = file.path;
                    if (!file.directory && path.endsWith(".json")) {
                        _this.git.read(_this.branch, path, function (details) {
                            var content = details.text;
                            if (content) {
                                try {
                                    var json = JSON.parse(content);
                                    json.uri = path;
                                    dashboards.push(json);
                                }
                                catch (e) {
                                    console.log("Failed to parse: " + content + " due to: " + e);
                                }
                            }
                            Dashboard.log.debug("git - read ", idx, " files, total: ", files.length);
                            maybeCallback();
                        });
                    }
                });
            });
        };
        GitDashboardRepository.prototype.getDashboard = function (id, fn) {
            var path = this.getUserDashboardPath(id);
            this.git.read(this.branch, path, function (details) {
                var dashboard = null;
                var content = details.text;
                if (content) {
                    try {
                        dashboard = JSON.parse(content);
                    }
                    catch (e) {
                        console.log("Failed to parse: " + content + " due to: " + e);
                    }
                }
                fn(dashboard);
            });
        };
        GitDashboardRepository.prototype.getUserDashboardDirectory = function () {
            return "/dashboards/team/all";
        };
        GitDashboardRepository.prototype.getUserDashboardPath = function (id) {
            return this.getUserDashboardDirectory() + "/" + id + ".json";
        };
        return GitDashboardRepository;
    })();
    Dashboard.GitDashboardRepository = GitDashboardRepository;
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    Dashboard._module.controller("Dashboard.EditDashboardsController", ["$scope", "$routeParams", "$route", "$location", "$rootScope", "dashboardRepository", "jolokia", "workspace", function ($scope, $routeParams, $route, $location, $rootScope, dashboardRepository, jolokia, workspace) {
        $scope.hash = workspace.hash();
        $scope.selectedItems = [];
        $scope.repository = dashboardRepository;
        $scope.duplicateDashboards = new UI.Dialog();
        $scope.selectedProfilesDialog = [];
        $scope._dashboards = [];
        $rootScope.$on('dashboardsUpdated', dashboardLoaded);
        $scope.hasUrl = function () {
            return ($scope.url) ? true : false;
        };
        $scope.hasSelection = function () {
            return $scope.selectedItems.length !== 0;
        };
        $scope.gridOptions = {
            selectedItems: $scope.selectedItems,
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                filterText: ''
            },
            data: '_dashboards',
            selectWithCheckboxOnly: true,
            showSelectionCheckbox: true,
            columnDefs: [
                {
                    field: 'title',
                    displayName: 'Dashboard',
                    cellTemplate: '<div class="ngCellText"><a ng-href="#/dashboard/id/{{row.getProperty(' + "'id'" + ')}}{{hash}}"><editable-property class="inline-block" on-save="onDashRenamed(row.entity)" property="title" ng-model="row.entity"></editable-property></a></div>'
                },
                {
                    field: 'group',
                    displayName: 'Group'
                }
            ]
        };
        $scope.onDashRenamed = function (dash) {
            dashboardRepository.putDashboards([dash], "Renamed dashboard", function (dashboards) {
                dashboardLoaded(null, dashboards);
            });
        };
        $scope.usingGit = function () {
            return dashboardRepository.getType() === 'git';
        };
        $scope.usingFabric = function () {
            return dashboardRepository.getType() === 'fabric';
        };
        $scope.usingLocal = function () {
            return dashboardRepository.getType() === 'container';
        };
        if ($scope.usingFabric()) {
            $scope.container = Fabric.getCurrentContainer(jolokia, ['versionId', 'profileIds']);
            $scope.gridOptions.columnDefs.add([{
                field: 'versionId',
                displayName: 'Version'
            }, {
                field: 'profileId',
                displayName: 'Profile'
            }, {
                field: 'fileName',
                displayName: 'File Name'
            }]);
        }
        $scope.$on("$routeChangeSuccess", function (event, current, previous) {
            setTimeout(updateData, 100);
        });
        $scope.goBack = function () {
            var href = Core.trimLeading($scope.url, "#");
            if (href) {
                $location.url(href);
            }
        };
        $scope.duplicateToProfiles = function () {
            if ($scope.hasSelection()) {
                $scope.duplicateDashboards.open();
            }
        };
        $scope.doDuplicateToProfiles = function () {
            $scope.duplicateDashboards.close();
            var newDashboards = [];
            $scope.selectedItems.forEach(function (dashboard) {
                $scope.selectedProfilesDialog.forEach(function (profile) {
                    var newDash = dashboardRepository.cloneDashboard(dashboard);
                    newDash['profileId'] = profile.id;
                    newDash['title'] = dashboard.title;
                    newDashboards.push(newDash);
                });
            });
            var commitMessage = "Duplicating " + $scope.selectedItems.length + " dashboards to " + $scope.selectedProfilesDialog.length + " profiles";
            dashboardRepository.putDashboards(newDashboards, commitMessage, function (dashboards) {
                dashboardLoaded(null, dashboards);
            });
        };
        $scope.addViewToDashboard = function () {
            var nextHref = null;
            angular.forEach($scope.selectedItems, function (selectedItem) {
                var text = $scope.url;
                var query = null;
                if (text) {
                    var idx = text.indexOf('?');
                    if (idx && idx > 0) {
                        query = text.substring(idx + 1);
                        text = text.substring(0, idx);
                    }
                    text = Core.trimLeading(text, "#");
                }
                var search = {};
                if (query) {
                    var expressions = query.split("&");
                    angular.forEach(expressions, function (expression) {
                        if (expression) {
                            var names = expression.split("=");
                            var key = names[0];
                            var value = names.length > 1 ? names[1] : null;
                            if (value) {
                                value = encodeURIComponent(value);
                            }
                            var old = search[key];
                            if (old) {
                                if (!angular.isArray(old)) {
                                    old = [old];
                                    search[key] = old;
                                }
                                old.push(value);
                            }
                            else {
                                search[key] = value;
                            }
                        }
                    });
                }
                if ($route && $route.routes) {
                    var value = $route.routes[text];
                    if (value) {
                        var templateUrl = value["templateUrl"];
                        if (templateUrl) {
                            if (!selectedItem.widgets) {
                                selectedItem.widgets = [];
                            }
                            var nextNumber = selectedItem.widgets.length + 1;
                            var widget = {
                                id: "w" + nextNumber,
                                title: "",
                                row: 1,
                                col: 1,
                                size_x: 1,
                                size_y: 1,
                                path: Core.trimLeading(text, "/"),
                                include: templateUrl,
                                search: search,
                                hash: ""
                            };
                            if ($scope.widgetTitle) {
                                widget.title = $scope.widgetTitle;
                            }
                            var gridWidth = 0;
                            selectedItem.widgets.forEach(function (w) {
                                var rightSide = w.col + w.size_x;
                                if (rightSide > gridWidth) {
                                    gridWidth = rightSide;
                                }
                            });
                            if ($scope.preferredSize) {
                                widget.size_x = parseInt($scope.preferredSize['size_x']);
                                widget.size_y = parseInt($scope.preferredSize['size_y']);
                            }
                            var found = false;
                            var left = function (w) {
                                return w.col;
                            };
                            var right = function (w) {
                                return w.col + w.size_x - 1;
                            };
                            var top = function (w) {
                                return w.row;
                            };
                            var bottom = function (w) {
                                return w.row + w.size_y - 1;
                            };
                            var collision = function (w1, w2) {
                                return !(left(w2) > right(w1) || right(w2) < left(w1) || top(w2) > bottom(w1) || bottom(w2) < top(w1));
                            };
                            if (selectedItem.widgets.isEmpty()) {
                                found = true;
                            }
                            while (!found) {
                                widget.col = 1;
                                for (; (widget.col + widget.size_x) <= gridWidth; widget.col++) {
                                    if (!selectedItem.widgets.any(function (w) {
                                        var c = collision(w, widget);
                                        return c;
                                    })) {
                                        found = true;
                                        break;
                                    }
                                }
                                if (!found) {
                                    widget.row = widget.row + 1;
                                }
                                if (widget.row > 50) {
                                    found = true;
                                }
                            }
                            if ($scope.routeParams) {
                                widget['routeParams'] = $scope.routeParams;
                            }
                            selectedItem.widgets.push(widget);
                            if (!nextHref && selectedItem.id) {
                                nextHref = "/dashboard/id/" + selectedItem.id;
                            }
                        }
                    }
                    else {
                    }
                }
            });
            var commitMessage = "Add widget";
            dashboardRepository.putDashboards($scope.selectedItems, commitMessage, function (dashboards) {
                if (nextHref) {
                    delete $location.search()["href"];
                    $location.path(nextHref);
                    Core.$apply($scope);
                }
            });
        };
        $scope.create = function () {
            var counter = dashboards().length + 1;
            var title = "Untitled" + counter;
            var newDash = dashboardRepository.createDashboard({ title: title });
            dashboardRepository.putDashboards([newDash], "Created new dashboard: " + title, function (dashboards) {
                $scope.selectedItems.splice(0);
                dashboardLoaded(null, dashboards);
            });
        };
        $scope.duplicate = function () {
            var newDashboards = [];
            var commitMessage = "Duplicated dashboard(s) ";
            angular.forEach($scope.selectedItems, function (item, idx) {
                var commitMessage = "Duplicated dashboard " + item.title;
                var newDash = dashboardRepository.cloneDashboard(item);
                newDashboards.push(newDash);
            });
            $scope.selectedItems.splice(0);
            commitMessage = commitMessage + newDashboards.map(function (d) {
                return d.title;
            }).join(',');
            dashboardRepository.putDashboards(newDashboards, commitMessage, function (dashboards) {
                dashboardLoaded(null, dashboards);
            });
        };
        $scope.delete = function () {
            if ($scope.hasSelection()) {
                dashboardRepository.deleteDashboards($scope.selectedItems, function (dashboards) {
                    $scope.selectedItems.splice(0);
                    dashboardLoaded(null, dashboards);
                });
            }
        };
        $scope.gist = function () {
            if ($scope.selectedItems.length > 0) {
                var id = $scope.selectedItems[0].id;
                $location.path("/dashboard/id/" + id + "/share");
            }
        };
        function updateData() {
            var url = $routeParams["href"];
            if (url) {
                $scope.url = decodeURIComponent(url);
            }
            var routeParams = $routeParams["routeParams"];
            if (routeParams) {
                $scope.routeParams = decodeURIComponent(routeParams);
            }
            var size = $routeParams["size"];
            if (size) {
                size = decodeURIComponent(size);
                $scope.preferredSize = angular.fromJson(size);
            }
            var title = $routeParams["title"];
            if (title) {
                title = decodeURIComponent(title);
                $scope.widgetTitle = title;
            }
            dashboardRepository.getDashboards(function (dashboards) {
                dashboardLoaded(null, dashboards);
            });
        }
        function dashboardLoaded(event, dashboards) {
            $scope._dashboards = dashboards;
            if (event === null) {
                $scope.$emit('dashboardsUpdated', dashboards);
            }
            Core.$apply($scope);
        }
        function dashboards() {
            return $scope._dashboards;
        }
        updateData();
    }]);
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    var FabricDashboardRepository = (function () {
        function FabricDashboardRepository(workspace, jolokia, localStorage) {
            this.workspace = workspace;
            this.jolokia = jolokia;
            this.localStorage = localStorage;
            this.details = this.getBranchAndProfiles();
        }
        FabricDashboardRepository.prototype.getBranchAndProfiles = function () {
            if (Fabric.fabricCreated(this.workspace)) {
                var container = Fabric.getCurrentContainer(this.jolokia, ['id', 'versionId', 'profiles']);
                var profiles = [];
                if (container.profiles) {
                    profiles = container.profiles.unique();
                    profiles = Fabric.filterProfiles(this.jolokia, container.versionId, profiles);
                }
                return {
                    branch: container.versionId,
                    profiles: profiles
                };
            }
            else {
                return {
                    branch: "1.0",
                    profiles: []
                };
            }
        };
        FabricDashboardRepository.prototype.putDashboards = function (array, commitMessage, fn) {
            var _this = this;
            var jolokia = this.jolokia;
            var details = this.details;
            var toPut = array.length;
            var maybeCallback = function () {
                toPut = toPut - 1;
                if (toPut === 0) {
                    _this.getDashboards(fn);
                }
            };
            array.forEach(function (dashboard) {
                var data = angular.toJson(dashboard, true);
                var profileId = dashboard.profileId;
                if (!profileId) {
                    profileId = details.profiles.first();
                }
                var fileName = dashboard.fileName;
                if (!fileName) {
                    fileName = Core.getUUID() + ".dashboard";
                }
                Fabric.saveConfigFile(jolokia, details.branch, profileId, fileName, data.encodeBase64(), function () {
                    maybeCallback();
                }, function (response) {
                    Dashboard.log.error("Failed to store dashboard: ", dashboard.title, " due to: ", response.error, " stack trace: ", response.stacktrace);
                    maybeCallback();
                });
            });
        };
        FabricDashboardRepository.prototype.deleteDashboards = function (array, fn) {
            var _this = this;
            var jolokia = this.jolokia;
            var details = this.details;
            var toDelete = array.length;
            var maybeCallback = function () {
                toDelete = toDelete - 1;
                if (toDelete === 0) {
                    _this.getDashboards(fn);
                }
            };
            array.forEach(function (dashboard) {
                var profileId = dashboard.profileId;
                var fileName = dashboard.fileName;
                if (profileId && fileName) {
                    Fabric.deleteConfigFile(jolokia, details.branch, profileId, fileName, function () {
                        maybeCallback();
                    }, function (response) {
                        Dashboard.log.error("Failed to delete dashboard: ", dashboard.title, " due to: ", response.error, " stack trace: ", response.stacktrace);
                        maybeCallback();
                    });
                }
            });
        };
        FabricDashboardRepository.prototype.createDashboard = function (options) {
            var answer = {
                title: "New Dashboard",
                group: "Fabric",
                versionId: this.details.branch,
                profileId: this.details.profiles.first(),
                widgets: []
            };
            answer = angular.extend(answer, options);
            var uuid = Core.getUUID();
            answer['id'] = uuid;
            answer['fileName'] = uuid + ".dashboard";
            return answer;
        };
        FabricDashboardRepository.prototype.cloneDashboard = function (dashboard) {
            var newDashboard = Object.clone(dashboard);
            var uuid = Core.getUUID();
            newDashboard['id'] = uuid;
            newDashboard['fileName'] = uuid + ".dashboard";
            newDashboard['title'] = "Copy of " + dashboard.title;
            return newDashboard;
        };
        FabricDashboardRepository.prototype.getType = function () {
            return 'fabric';
        };
        FabricDashboardRepository.prototype.isValid = function () {
            return Fabric.hasFabric(this.workspace);
        };
        FabricDashboardRepository.prototype.getDashboards = function (fn) {
            var _this = this;
            var jolokia = this.jolokia;
            var details = this.details;
            var dashboards = [];
            jolokia.request({
                type: 'exec',
                mbean: Fabric.managerMBean,
                operation: 'getConfigurationFiles',
                arguments: [details.branch, details.profiles, ".*dashboard"]
            }, {
                method: 'POST',
                success: function (response) {
                    angular.forEach(response.value, function (value, profile) {
                        angular.forEach(value, function (value, fileName) {
                            var dashboard = angular.fromJson(value.decodeBase64());
                            dashboard['versionId'] = details.branch;
                            dashboard['profileId'] = profile;
                            dashboard['fileName'] = fileName;
                            dashboards.push(dashboard);
                        });
                    });
                    if (dashboards.isEmpty()) {
                        dashboards.push(_this.createDashboard({}));
                    }
                    dashboards = dashboards.sort(function (d1, d2) {
                        var title1 = d1.title;
                        var title2 = d2.title;
                        return title1.localeCompare(title2);
                    });
                    fn(dashboards);
                },
                error: function (response) {
                    Dashboard.log.error("Failed to load dashboard data: error: ", response.error, " stack trace: ", response.stacktrace);
                    fn([]);
                }
            });
        };
        FabricDashboardRepository.prototype.getDashboard = function (id, fn) {
            this.getDashboards(function (dashboards) {
                var dashboard = dashboards.find(function (dashboard) {
                    return dashboard.id === id;
                });
                fn(dashboard);
            });
        };
        return FabricDashboardRepository;
    })();
    Dashboard.FabricDashboardRepository = FabricDashboardRepository;
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    var GridsterDirective = (function () {
        function GridsterDirective() {
            this.restrict = 'A';
            this.replace = true;
            this.controller = ["$scope", "$element", "$attrs", "$location", "$routeParams", "$injector", "$route", "$templateCache", "workspace", "dashboardRepository", "$compile", function ($scope, $element, $attrs, $location, $routeParams, $injector, $route, $templateCache, workspace, dashboardRepository, $compile) {
                $scope.route = $route;
                $scope.injector = $injector;
                var gridSize = 150;
                var gridMargin = 6;
                var gridHeight;
                $scope.gridX = gridSize;
                $scope.gridY = gridSize;
                $scope.widgetMap = {};
                $scope.$on('$destroy', function () {
                    angular.forEach($scope.widgetMap, function (value, key) {
                        if ('scope' in value) {
                            var scope = value['scope'];
                            scope.$destroy();
                        }
                    });
                });
                updateWidgets();
                $scope.removeWidget = function (widget) {
                    var gridster = getGridster();
                    var widgetElem = null;
                    var widgetData = $scope.widgetMap[widget.id];
                    if (widgetData) {
                        delete $scope.widgetMap[widget.id];
                        var scope = widgetData.scope;
                        widgetElem = widgetData.widget;
                        if (scope) {
                            scope.$destroy();
                        }
                    }
                    if (!widgetElem) {
                        widgetElem = $("div").find("[data-widgetId='" + widget.id + "']").parent();
                    }
                    if (gridster && widgetElem) {
                        gridster.remove_widget(widgetElem);
                    }
                    if ($scope.dashboard) {
                        var widgets = $scope.dashboard.widgets;
                        if (widgets) {
                            widgets.remove(widget);
                        }
                    }
                    updateDashboardRepository("Removed widget " + widget.title);
                };
                function changeWidgetSize(widget, sizefunc, savefunc) {
                    var gridster = getGridster();
                    var entry = $scope.widgetMap[widget.id];
                    var w = entry.widget;
                    var scope = entry.scope;
                    sizefunc(entry);
                    gridster.resize_widget(w, entry.size_x, entry.size_y);
                    gridster.set_dom_grid_height();
                    setTimeout(function () {
                        var template = $templateCache.get("widgetTemplate");
                        var div = $('<div></div>');
                        div.html(template);
                        w.html($compile(div.contents())(scope));
                        makeResizable();
                        Core.$apply($scope);
                        setTimeout(function () {
                            savefunc(widget);
                        }, 50);
                    }, 30);
                }
                $scope.onWidgetRenamed = function (widget) {
                    updateDashboardRepository("Renamed widget to " + widget.title);
                };
                function updateWidgets() {
                    $scope.id = $routeParams["dashboardId"];
                    $scope.idx = $routeParams["dashboardIndex"];
                    if ($scope.id) {
                        $scope.$emit('loadDashboards');
                        dashboardRepository.getDashboard($scope.id, onDashboardLoad);
                    }
                    else {
                        dashboardRepository.getDashboards(function (dashboards) {
                            $scope.$emit('dashboardsUpdated', dashboards);
                            var idx = $scope.idx ? parseInt($scope.idx) : 0;
                            var id = null;
                            if (dashboards.length > 0) {
                                var dashboard = dashboards.length > idx ? dashboards[idx] : dashboard[0];
                                id = dashboard.id;
                            }
                            if (id) {
                                $location.path("/dashboard/id/" + id);
                            }
                            else {
                                $location.path("/dashboard/edit?tab=dashboard");
                            }
                            Core.$apply($scope);
                        });
                    }
                }
                function onDashboardLoad(dashboard) {
                    $scope.dashboard = dashboard;
                    var widgets = ((dashboard) ? dashboard.widgets : null) || [];
                    var minHeight = 10;
                    var minWidth = 6;
                    angular.forEach(widgets, function (widget) {
                        if (angular.isDefined(widget.row) && minHeight < widget.row) {
                            minHeight = widget.row + 1;
                        }
                        if (angular.isDefined(widget.size_x && angular.isDefined(widget.col))) {
                            var rightEdge = widget.col + widget.size_x;
                            if (rightEdge > minWidth) {
                                minWidth = rightEdge + 1;
                            }
                        }
                    });
                    var gridster = $element.gridster({
                        widget_margins: [gridMargin, gridMargin],
                        widget_base_dimensions: [$scope.gridX, $scope.gridY],
                        extra_rows: minHeight,
                        extra_cols: minWidth,
                        max_size_x: minWidth,
                        max_size_y: minHeight,
                        draggable: {
                            stop: function (event, ui) {
                                if (serializeDashboard()) {
                                    updateDashboardRepository("Changing dashboard layout");
                                }
                            }
                        }
                    }).data('gridster');
                    var template = $templateCache.get("widgetTemplate");
                    angular.forEach(widgets, function (widget) {
                        var childScope = $scope.$new(false);
                        childScope.widget = widget;
                        var path = widget.path;
                        var search = null;
                        if (widget.search) {
                            search = Dashboard.decodeURIComponentProperties(widget.search);
                        }
                        var hash = widget.hash;
                        var location = new Dashboard.RectangleLocation($location, path, search, hash);
                        var routeParams = null;
                        if (widget.routeParams) {
                            routeParams = angular.fromJson(widget.routeParams);
                        }
                        var childWorkspace = workspace.createChildWorkspace(location);
                        childWorkspace.$location = location;
                        if (search) {
                            var key = location.search()['nid'];
                            if (key && workspace.tree) {
                                childWorkspace.selection = workspace.keyToNodeMap[key];
                                if (!childWorkspace.selection) {
                                    var decodedKey = decodeURIComponent(key);
                                    childWorkspace.selection = workspace.keyToNodeMap[decodedKey];
                                }
                            }
                        }
                        var $$scopeInjections = {
                            workspace: childWorkspace,
                            location: location,
                            $location: location,
                            $routeParams: routeParams
                        };
                        childScope.$$scopeInjections = $$scopeInjections;
                        childScope.inDashboard = true;
                        if (!widget.size_x || widget.size_x < 1) {
                            widget.size_x = 1;
                        }
                        if (!widget.size_y || widget.size_y < 1) {
                            widget.size_y = 1;
                        }
                        var div = $('<div></div>');
                        div.html(template);
                        var outerDiv = $('<li class="grid-block" style="display: list-item; position: absolute"></li>');
                        outerDiv.html($compile(div.contents())(childScope));
                        var w = gridster.add_widget(outerDiv, widget.size_x, widget.size_y, widget.col, widget.row);
                        $scope.widgetMap[widget.id] = {
                            widget: w,
                            scope: childScope
                        };
                    });
                    makeResizable();
                    getGridster().enable();
                    Core.$apply($scope);
                }
                function serializeDashboard() {
                    var gridster = getGridster();
                    if (gridster) {
                        var data = gridster.serialize();
                        var widgets = $scope.dashboard.widgets || [];
                        angular.forEach(widgets, function (widget, idx) {
                            var value = data[idx];
                            if (value && widget) {
                                angular.forEach(value, function (attr, key) { return widget[key] = attr; });
                            }
                        });
                        return true;
                    }
                    return false;
                }
                function makeResizable() {
                    var blocks = $('.grid-block');
                    blocks.resizable('destroy');
                    blocks.resizable({
                        grid: [gridSize + (gridMargin * 2), gridSize + (gridMargin * 2)],
                        animate: false,
                        minWidth: gridSize,
                        minHeight: gridSize,
                        autoHide: false,
                        start: function (event, ui) {
                            gridHeight = getGridster().$el.height();
                        },
                        resize: function (event, ui) {
                            var g = getGridster();
                            var delta = gridSize + gridMargin * 2;
                            if (event.offsetY > g.$el.height()) {
                                var extra = Math.floor((event.offsetY - gridHeight) / delta + 1);
                                var newHeight = gridHeight + extra * delta;
                                g.$el.css('height', newHeight);
                            }
                        },
                        stop: function (event, ui) {
                            var resized = $(this);
                            setTimeout(function () {
                                resizeBlock(resized);
                            }, 300);
                        }
                    });
                    $('.ui-resizable-handle').hover(function () {
                        getGridster().disable();
                    }, function () {
                        getGridster().enable();
                    });
                }
                function resizeBlock(elmObj) {
                    var area = elmObj.find('.widget-area');
                    var w = elmObj.width() - gridSize;
                    var h = elmObj.height() - gridSize;
                    for (var grid_w = 1; w > 0; w -= (gridSize + (gridMargin * 2))) {
                        grid_w++;
                    }
                    for (var grid_h = 1; h > 0; h -= (gridSize + (gridMargin * 2))) {
                        grid_h++;
                    }
                    var widget = {
                        id: area.attr('data-widgetId')
                    };
                    changeWidgetSize(widget, function (widget) {
                        widget.size_x = grid_w;
                        widget.size_y = grid_h;
                    }, function (widget) {
                        if (serializeDashboard()) {
                            updateDashboardRepository("Changed size of widget: " + widget.id);
                        }
                    });
                }
                function updateDashboardRepository(message) {
                    if ($scope.dashboard) {
                        var commitMessage = message;
                        if ($scope.dashboard && $scope.dashboard.title) {
                            commitMessage += " on dashboard " + $scope.dashboard.title;
                        }
                        dashboardRepository.putDashboards([$scope.dashboard], commitMessage, Dashboard.onOperationComplete);
                    }
                }
                function getGridster() {
                    return $element.gridster().data('gridster');
                }
            }];
        }
        return GridsterDirective;
    })();
    Dashboard.GridsterDirective = GridsterDirective;
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    Dashboard._module.controller("Dashboard.ImportController", ["$scope", "$location", "$routeParams", "workspace", "dashboardRepository", function ($scope, $location, $routeParams, workspace, dashboardRepository) {
        $scope.placeholder = "Paste the JSON here for the dashboard configuration to import...";
        $scope.source = $scope.placeholder;
        var options = {
            mode: {
                name: "javascript"
            }
        };
        $scope.codeMirrorOptions = CodeEditor.createEditorSettings(options);
        $scope.isValid = function () { return $scope.source && $scope.source !== $scope.placeholder; };
        $scope.importJSON = function () {
            var json = [];
            try {
                json = JSON.parse($scope.source);
            }
            catch (e) {
                Core.notification("error", "Could not parse the JSON\n" + e);
                json = [];
            }
            var array = [];
            if (angular.isArray(json)) {
                array = json;
            }
            else if (angular.isObject(json)) {
                array.push(json);
            }
            if (array.length) {
                angular.forEach(array, function (dash, index) {
                    angular.copy(dash, dashboardRepository.createDashboard(dash));
                });
                dashboardRepository.putDashboards(array, "Imported dashboard JSON", Dashboard.onOperationComplete);
                $location.path("/dashboard/edit");
            }
        };
    }]);
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    Dashboard._module.controller("Dashboard.NavBarController", ["$scope", "$routeParams", "$rootScope", "workspace", "dashboardRepository", function ($scope, $routeParams, $rootScope, workspace, dashboardRepository) {
        $scope.hash = workspace.hash();
        $scope._dashboards = [];
        $scope.activeDashboard = $routeParams['dashboardId'];
        $rootScope.$on('loadDashboards', loadDashboards);
        $rootScope.$on('dashboardsUpdated', dashboardLoaded);
        $scope.dashboards = function () {
            return $scope._dashboards;
        };
        $scope.isActive = function (dash) {
            return workspace.isLinkActive("#/dashboard/id/" + dash.id);
        };
        $scope.isEditing = function () {
            return workspace.isLinkActive("#/dashboard/edit");
        };
        $scope.onTabRenamed = function (dash) {
            dashboardRepository.putDashboards([dash], "Renamed dashboard", function (dashboards) {
                dashboardLoaded(null, dashboards);
            });
        };
        function dashboardLoaded(event, dashboards) {
            Dashboard.log.debug("navbar dashboardLoaded: ", dashboards);
            $scope._dashboards = dashboards;
            if (event === null) {
                $rootScope.$broadcast('dashboardsUpdated', dashboards);
                Core.$apply($scope);
            }
        }
        function loadDashboards(event) {
            dashboardRepository.getDashboards(function (dashboards) {
                dashboardLoaded(event, dashboards);
                Core.$apply($scope);
            });
        }
    }]);
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    var RectangleLocation = (function () {
        function RectangleLocation(delegate, path, search, hash) {
            this.delegate = delegate;
            this._path = path;
            this._search = search;
            this._hash = hash;
        }
        RectangleLocation.prototype.absUrl = function () {
            return this.protocol() + this.host() + ":" + this.port() + this.path() + this.search();
        };
        RectangleLocation.prototype.hash = function (newHash) {
            if (newHash === void 0) { newHash = null; }
            if (newHash) {
                return this.delegate.hash(newHash).search('tab', null);
            }
            return this._hash;
        };
        RectangleLocation.prototype.host = function () {
            return this.delegate.host();
        };
        RectangleLocation.prototype.path = function (newPath) {
            if (newPath === void 0) { newPath = null; }
            if (newPath) {
                return this.delegate.path(newPath).search('tab', null);
            }
            return this._path;
        };
        RectangleLocation.prototype.port = function () {
            return this.delegate.port();
        };
        RectangleLocation.prototype.protocol = function () {
            return this.delegate.port();
        };
        RectangleLocation.prototype.replace = function () {
            return this;
        };
        RectangleLocation.prototype.search = function (parametersMap) {
            if (parametersMap === void 0) { parametersMap = null; }
            if (parametersMap) {
                return this.delegate.search(parametersMap);
            }
            return this._search;
        };
        RectangleLocation.prototype.url = function (newValue) {
            if (newValue === void 0) { newValue = null; }
            if (newValue) {
                return this.delegate.url(newValue).search('tab', null);
            }
            return this.absUrl();
        };
        return RectangleLocation;
    })();
    Dashboard.RectangleLocation = RectangleLocation;
})(Dashboard || (Dashboard = {}));
var Dashboard;
(function (Dashboard) {
    Dashboard.ShareController = Dashboard._module.controller("Dashboard.ShareController", ["$scope", "$location", "$routeParams", "workspace", "dashboardRepository", function ($scope, $location, $routeParams, workspace, dashboardRepository) {
        var id = $routeParams["dashboardId"];
        dashboardRepository.getDashboard(id, onDashboardLoad);
        var options = {
            mode: {
                name: "javascript"
            }
        };
        $scope.codeMirrorOptions = CodeEditor.createEditorSettings(options);
        function onDashboardLoad(dashboard) {
            $scope.dashboard = Dashboard.cleanDashboardData(dashboard);
            $scope.json = {
                "description": "hawtio dashboards",
                "public": true,
                "files": {
                    "dashboards.json": {
                        "content": JSON.stringify($scope.dashboard, null, "  ")
                    }
                }
            };
            $scope.source = JSON.stringify($scope.dashboard, null, "  ");
            Core.$applyNowOrLater($scope);
        }
    }]);
})(Dashboard || (Dashboard = {}));
var DataTable;
(function (DataTable) {
    var TableWidget = (function () {
        function TableWidget(scope, $templateCache, $compile, dataTableColumns, config) {
            var _this = this;
            if (config === void 0) { config = {}; }
            this.scope = scope;
            this.$templateCache = $templateCache;
            this.$compile = $compile;
            this.dataTableColumns = dataTableColumns;
            this.config = config;
            this.ignoreColumnHash = {};
            this.flattenColumnHash = {};
            this.detailTemplate = null;
            this.openMessages = [];
            this.addedExpandNodes = false;
            this.tableElement = null;
            this.sortColumns = null;
            this.dataTableConfig = {
                bPaginate: false,
                sDom: 'Rlfrtip',
                bDestroy: true,
                bAutoWidth: true
            };
            this.dataTable = null;
            angular.forEach(config.ignoreColumns, function (name) {
                _this.ignoreColumnHash[name] = true;
            });
            angular.forEach(config.flattenColumns, function (name) {
                _this.flattenColumnHash[name] = true;
            });
            var templateId = config.rowDetailTemplateId;
            if (templateId) {
                this.detailTemplate = this.$templateCache.get(templateId);
            }
        }
        TableWidget.prototype.addData = function (newData) {
            var dataTable = this.dataTable;
            dataTable.fnAddData(newData);
        };
        TableWidget.prototype.populateTable = function (data) {
            var _this = this;
            var $scope = this.scope;
            if (!data) {
                $scope.messages = [];
            }
            else {
                $scope.messages = data;
                var formatMessageDetails = function (dataTable, parentRow) {
                    var oData = dataTable.fnGetData(parentRow);
                    var div = $('<div>');
                    div.addClass('innerDetails');
                    _this.populateDetailDiv(oData, div);
                    return div;
                };
                var array = data;
                if (angular.isArray(data)) {
                }
                else if (angular.isObject(data)) {
                    array = [];
                    angular.forEach(data, function (object) { return array.push(object); });
                }
                var tableElement = this.tableElement;
                if (!tableElement) {
                    tableElement = $('#grid');
                }
                var tableTr = Core.getOrCreateElements(tableElement, ["thead", "tr"]);
                var tableBody = Core.getOrCreateElements(tableElement, ["tbody"]);
                var ths = $(tableTr).find("th");
                var columns = [];
                angular.forEach(this.dataTableColumns, function (value) { return columns.push(value); });
                var addColumn = function (key, title) {
                    columns.push({
                        "sDefaultContent": "",
                        "mData": null,
                        mDataProp: key
                    });
                    if (tableTr) {
                        $("<th>" + title + "</th>").appendTo(tableTr);
                    }
                };
                var checkForNewColumn = function (value, key, prefix) {
                    var found = _this.ignoreColumnHash[key] || columns.any(function (k, v) { return "mDataProp" === k && v === key; });
                    if (!found) {
                        if (_this.flattenColumnHash[key]) {
                            if (angular.isObject(value)) {
                                var childPrefix = prefix + key + ".";
                                angular.forEach(value, function (value, key) { return checkForNewColumn(value, key, childPrefix); });
                            }
                        }
                        else {
                            addColumn(prefix + key, Core.humanizeValue(key));
                        }
                    }
                };
                if (!this.config.disableAddColumns && angular.isArray(array) && array.length > 0) {
                    var first = array[0];
                    if (angular.isObject(first)) {
                        angular.forEach(first, function (value, key) { return checkForNewColumn(value, key, ""); });
                    }
                }
                if (columns.length > 1) {
                    var col0 = columns[0];
                    if (!this.sortColumns && !col0["mDataProp"] && !col0["mData"]) {
                        var sortOrder = [[1, "asc"]];
                        this.sortColumns = sortOrder;
                    }
                }
                if (array.length && !angular.isArray(array[0])) {
                    this.dataTableConfig["aaData"] = array;
                }
                else {
                    this.dataTableConfig["aaData"] = array;
                }
                this.dataTableConfig["aoColumns"] = columns;
                if (this.sortColumns) {
                    this.dataTableConfig["aaSorting"] = this.sortColumns;
                }
                this.dataTableConfig["oLanguage"] = {
                    "sSearch": "Filter:"
                };
                if (this.dataTable) {
                    this.dataTable.fnClearTable(false);
                    this.dataTable.fnAddData(array);
                    this.dataTable.fnDraw();
                }
                else {
                    this.dataTable = tableElement.dataTable(this.dataTableConfig);
                }
                var widget = this;
                if (this.dataTable) {
                    var keys = new KeyTable({
                        "table": tableElement[0],
                        "datatable": this.dataTable
                    });
                    keys.fnSetPosition(0, 0);
                    if (angular.isArray(data) && data.length) {
                        var selected = data[0];
                        var selectHandler = widget.config.selectHandler;
                        if (selected && selectHandler) {
                            selectHandler(selected);
                        }
                    }
                }
                $(tableElement).focus();
                var widget = this;
                var expandCollapseNode = function () {
                    var dataTable = widget.dataTable;
                    var parentRow = this.parentNode;
                    var openMessages = widget.openMessages;
                    var i = $.inArray(parentRow, openMessages);
                    var element = $('i', this);
                    if (i === -1) {
                        element.removeClass('icon-plus');
                        element.addClass('icon-minus');
                        var dataDiv = formatMessageDetails(dataTable, parentRow);
                        var detailsRow = $(dataTable.fnOpen(parentRow, dataDiv, 'details'));
                        detailsRow.css("padding", "0");
                        setTimeout(function () {
                            detailsRow.find(".innerDetails").slideDown(400, function () {
                                $(parentRow).addClass('opened');
                                openMessages.push(parentRow);
                            });
                        }, 20);
                    }
                    else {
                        $(parentRow.nextSibling).find(".innerDetails").slideUp(400, function () {
                            $(parentRow).removeClass('opened');
                            element.removeClass('icon-minus');
                            element.addClass('icon-plus');
                            dataTable.fnClose(parentRow);
                            openMessages.splice(i, 1);
                        });
                    }
                    Core.$apply($scope);
                };
                if (!this.addedExpandNodes) {
                    this.addedExpandNodes = true;
                    $(tableElement).on("click", "td.control", expandCollapseNode);
                    keys.event.action(0, null, function (node) {
                        expandCollapseNode.call(node);
                    });
                }
                keys.event.focus(null, null, function (node) {
                    var dataTable = widget.dataTable;
                    var row = node;
                    if (node) {
                        var nodeName = node.nodeName;
                        if (nodeName) {
                            if (nodeName.toLowerCase() === "td") {
                                row = $(node).parents("tr")[0];
                            }
                            var selected = dataTable.fnGetData(row);
                            var selectHandler = widget.config.selectHandler;
                            if (selected && selectHandler) {
                                selectHandler(selected);
                            }
                        }
                    }
                });
                $(tableElement).find("td.control").on("click", function (event) {
                    var dataTable = widget.dataTable;
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('focus selected');
                    }
                    else {
                        if (!widget.config.multiSelect) {
                            dataTable.$('td.selected').removeClass('focus selected');
                        }
                        $(this).addClass('focus selected');
                        var row = $(this).parents("tr")[0];
                        var selected = dataTable.fnGetData(row);
                        var selectHandler = widget.config.selectHandler;
                        if (selected && selectHandler) {
                            selectHandler(selected);
                        }
                    }
                });
            }
            Core.$apply($scope);
        };
        TableWidget.prototype.populateDetailDiv = function (row, div) {
            delete row["0"];
            var scope = this.scope.$new();
            scope.row = row;
            scope.templateDiv = div;
            var template = this.detailTemplate;
            if (!template) {
                var templateId = this.config.rowDetailTemplateId;
                if (templateId) {
                    this.detailTemplate = this.$templateCache.get(templateId);
                    template = this.detailTemplate;
                }
            }
            if (template) {
                div.html(template);
                this.$compile(div.contents())(scope);
            }
        };
        return TableWidget;
    })();
    DataTable.TableWidget = TableWidget;
})(DataTable || (DataTable = {}));
var DataTable;
(function (DataTable) {
    DataTable.pluginName = 'datatable';
    DataTable.log = Logger.get("DataTable");
    DataTable._module = angular.module(DataTable.pluginName, ['bootstrap', 'ngResource']);
    DataTable._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/datatable/test', { templateUrl: 'app/datatable/html/test.html' });
    }]);
    DataTable._module.directive('hawtioDatatable', ["$templateCache", "$compile", "$timeout", "$filter", function ($templateCache, $compile, $timeout, $filter) {
        return function (scope, element, attrs) {
            var gridOptions = null;
            var data = null;
            var widget = null;
            var timeoutId = null;
            var initialised = false;
            var childScopes = [];
            var rowDetailTemplate = null;
            var rowDetailTemplateId = null;
            var selectedItems = null;
            function updateGrid() {
                Core.$applyNowOrLater(scope);
            }
            function convertToDataTableColumn(columnDef) {
                var data = {
                    mData: columnDef.field,
                    sDefaultContent: ""
                };
                var name = columnDef.displayName;
                if (name) {
                    data["sTitle"] = name;
                }
                var width = columnDef.width;
                if (angular.isNumber(width)) {
                    data["sWidth"] = "" + width + "px";
                }
                else if (angular.isString(width) && !width.startsWith("*")) {
                    data["sWidth"] = width;
                }
                var template = columnDef.cellTemplate;
                if (template) {
                    data["fnCreatedCell"] = function (nTd, sData, oData, iRow, iCol) {
                        var childScope = childScopes[iRow];
                        if (!childScope) {
                            childScope = scope.$new(false);
                            childScopes[iRow] = childScope;
                        }
                        var entity = oData;
                        childScope["row"] = {
                            entity: entity,
                            getProperty: function (name) {
                                return entity[name];
                            }
                        };
                        var elem = $(nTd);
                        elem.html(template);
                        var contents = elem.contents();
                        contents.removeClass("ngCellText");
                        $compile(contents)(childScope);
                    };
                }
                else {
                    var cellFilter = columnDef.cellFilter;
                    var render = columnDef.render;
                    if (cellFilter && !render) {
                        var filter = $filter(cellFilter);
                        if (filter) {
                            render = function (data, type, full) {
                                return filter(data);
                            };
                        }
                    }
                    if (render) {
                        data["mRender"] = render;
                    }
                }
                return data;
            }
            function destroyChildScopes() {
                angular.forEach(childScopes, function (childScope) {
                    childScope.$destroy();
                });
                childScopes = [];
            }
            function selectHandler(selection) {
                if (selection && selectedItems) {
                    selectedItems.splice(0, selectedItems.length);
                    selectedItems.push(selection);
                    Core.$apply(scope);
                }
            }
            function onTableDataChange(value) {
                gridOptions = value;
                if (gridOptions) {
                    selectedItems = gridOptions.selectedItems;
                    rowDetailTemplate = gridOptions.rowDetailTemplate;
                    rowDetailTemplateId = gridOptions.rowDetailTemplateId;
                    if (widget === null) {
                        var widgetOptions = {
                            selectHandler: selectHandler,
                            disableAddColumns: true,
                            rowDetailTemplateId: rowDetailTemplateId,
                            ignoreColumns: gridOptions.ignoreColumns,
                            flattenColumns: gridOptions.flattenColumns
                        };
                        var rootElement = $(element);
                        var tableElement = rootElement.children("table");
                        if (!tableElement.length) {
                            $("<table class='table table-bordered table-condensed'></table>").appendTo(rootElement);
                            tableElement = rootElement.children("table");
                        }
                        tableElement.removeClass('table-striped');
                        tableElement.addClass('dataTable');
                        var trElement = Core.getOrCreateElements(tableElement, ["thead", "tr"]);
                        destroyChildScopes();
                        var columns = [];
                        var columnCounter = 1;
                        var extraLeftColumn = rowDetailTemplate || rowDetailTemplateId;
                        if (extraLeftColumn) {
                            columns.push({
                                "mDataProp": null,
                                "sClass": "control center",
                                "sWidth": "30px",
                                "sDefaultContent": '<i class="icon-plus"></i>'
                            });
                            var th = trElement.children("th");
                            if (th.length < columnCounter++) {
                                $("<th></th>").appendTo(trElement);
                            }
                        }
                        var columnDefs = gridOptions.columnDefs;
                        if (angular.isString(columnDefs)) {
                            columnDefs = scope[columnDefs];
                        }
                        angular.forEach(columnDefs, function (columnDef) {
                            th = trElement.children("th");
                            if (th.length < columnCounter++) {
                                var name = columnDef.displayName || "";
                                $("<th>" + name + "</th>").appendTo(trElement);
                            }
                            columns.push(convertToDataTableColumn(columnDef));
                        });
                        widget = new DataTable.TableWidget(scope, $templateCache, $compile, columns, widgetOptions);
                        widget.tableElement = tableElement;
                        var sortInfo = gridOptions.sortInfo;
                        if (sortInfo && columnDefs) {
                            var sortColumns = [];
                            var field = sortInfo.field;
                            if (field) {
                                var idx = columnDefs.findIndex({ field: field });
                                if (idx >= 0) {
                                    if (extraLeftColumn) {
                                        idx += 1;
                                    }
                                    var asc = sortInfo.direction || "asc";
                                    asc = asc.toLowerCase();
                                    sortColumns.push([idx, asc]);
                                }
                            }
                            if (sortColumns.length) {
                                widget.sortColumns = sortColumns;
                            }
                        }
                        if (columns.every(function (col) { return col.sWidth; })) {
                            widget.dataTableConfig.bAutoWidth = false;
                        }
                        var filterText = null;
                        var filterOptions = gridOptions.filterOptions;
                        if (filterOptions) {
                            filterText = filterOptions.filterText;
                        }
                        if (filterText || (angular.isDefined(gridOptions.showFilter) && !gridOptions.showFilter)) {
                            widget.dataTableConfig.sDom = 'Rlrtip';
                        }
                        if (filterText) {
                            scope.$watch(filterText, function (value) {
                                var dataTable = widget.dataTable;
                                if (dataTable) {
                                    dataTable.fnFilter(value);
                                }
                            });
                        }
                        if (angular.isDefined(gridOptions.displayFooter) && !gridOptions.displayFooter && widget.dataTableConfig.sDom) {
                            widget.dataTableConfig.sDom = widget.dataTableConfig.sDom.replace('i', '');
                        }
                    }
                    if (!data) {
                        data = gridOptions.data;
                        if (data) {
                            var listener = function (value) {
                                if (initialised || (value && (!angular.isArray(value) || value.length))) {
                                    initialised = true;
                                    destroyChildScopes();
                                    widget.populateTable(value);
                                    updateLater();
                                }
                            };
                            scope.$watch(data, listener);
                            scope.$on("hawtio.datatable." + data, function (args) {
                                var value = Core.pathGet(scope, data);
                                listener(value);
                            });
                        }
                    }
                }
                updateGrid();
            }
            scope.$watch(attrs.hawtioDatatable, onTableDataChange);
            function updateLater() {
                timeoutId = $timeout(function () {
                    updateGrid();
                }, 300);
            }
            element.bind('$destroy', function () {
                destroyChildScopes();
                $timeout.cancel(timeoutId);
            });
            updateLater();
        };
    }]);
    hawtioPluginLoader.addModule(DataTable.pluginName);
})(DataTable || (DataTable = {}));
var FilterHelpers;
(function (FilterHelpers) {
    FilterHelpers.log = Logger.get("FilterHelpers");
    function search(object, filter, maxDepth, and) {
        if (maxDepth === void 0) { maxDepth = -1; }
        if (and === void 0) { and = true; }
        var f = filter.split(" ");
        var matches = f.filter(function (f) {
            return searchObject(object, f, maxDepth);
        });
        if (and) {
            return matches.length === f.length;
        }
        else {
            return matches.length > 0;
        }
    }
    FilterHelpers.search = search;
    function searchObject(object, filter, maxDepth, depth) {
        if (maxDepth === void 0) { maxDepth = -1; }
        if (depth === void 0) { depth = 0; }
        if ((maxDepth > 0 && depth >= maxDepth) || depth > 50) {
            return false;
        }
        var f = filter.toLowerCase();
        var answer = false;
        if (angular.isString(object)) {
            answer = object.toLowerCase().has(f);
        }
        else if (angular.isNumber(object)) {
            answer = ("" + object).toLowerCase().has(f);
        }
        else if (angular.isArray(object)) {
            answer = object.some(function (item) {
                return searchObject(item, f, maxDepth, depth + 1);
            });
        }
        else if (angular.isObject(object)) {
            answer = searchObject(Object.extended(object).values(), f, maxDepth, depth);
        }
        return answer;
    }
    FilterHelpers.searchObject = searchObject;
})(FilterHelpers || (FilterHelpers = {}));
var DataTable;
(function (DataTable) {
    var SimpleDataTable = (function () {
        function SimpleDataTable($compile) {
            var _this = this;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = {
                config: '=hawtioSimpleTable',
                target: '@',
                showFiles: '@'
            };
            this.link = function ($scope, $element, $attrs) {
                return _this.doLink($scope, $element, $attrs);
            };
        }
        SimpleDataTable.prototype.doLink = function ($scope, $element, $attrs) {
            var defaultPrimaryKeyFn = function (entity, idx) {
                return entity["id"] || entity["_id"] || entity["name"] || idx;
            };
            var config = $scope.config;
            var dataName = config.data || "data";
            var primaryKeyFn = config.primaryKeyFn || defaultPrimaryKeyFn;
            $scope.rows = [];
            var scope = $scope.$parent || $scope;
            var listener = function (otherValue) {
                var value = Core.pathGet(scope, dataName);
                if (value && !angular.isArray(value)) {
                    value = [value];
                    Core.pathSet(scope, dataName, value);
                }
                if (!('sortInfo' in config) && 'columnDefs' in config) {
                    var ds = config.columnDefs.first()['defaultSort'];
                    var sortField;
                    if (angular.isUndefined(ds) || ds === true) {
                        sortField = config.columnDefs.first()['field'];
                    }
                    else {
                        sortField = config.columnDefs.slice(1).first()['field'];
                    }
                    config['sortInfo'] = {
                        sortBy: sortField,
                        ascending: true
                    };
                }
                else {
                    config['sortInfo'] = {
                        sortBy: '',
                        ascending: true
                    };
                }
                var sortInfo = $scope.config.sortInfo;
                var idx = -1;
                $scope.rows = (value || []).sortBy(sortInfo.sortBy, !sortInfo.ascending).map(function (entity) {
                    idx++;
                    return {
                        entity: entity,
                        index: idx,
                        getProperty: function (name) {
                            return entity[name];
                        }
                    };
                });
                Core.pathSet(scope, ['hawtioSimpleTable', dataName, 'rows'], $scope.rows);
                var reSelectedItems = [];
                $scope.rows.forEach(function (row, idx) {
                    var rpk = primaryKeyFn(row.entity, row.index);
                    var selected = config.selectedItems.some(function (s) {
                        var spk = primaryKeyFn(s, s.index);
                        return angular.equals(rpk, spk);
                    });
                    if (selected) {
                        row.entity.index = row.index;
                        reSelectedItems.push(row.entity);
                        DataTable.log.debug("Data changed so keep selecting row at index " + row.index);
                    }
                });
                config.selectedItems = reSelectedItems;
            };
            scope.$watch(dataName, listener);
            scope.$on("hawtio.datatable." + dataName, listener);
            function getSelectionArray() {
                var selectionArray = config.selectedItems;
                if (!selectionArray) {
                    selectionArray = [];
                    config.selectedItems = selectionArray;
                }
                if (angular.isString(selectionArray)) {
                    var name = selectionArray;
                    selectionArray = Core.pathGet(scope, name);
                    if (!selectionArray) {
                        selectionArray = [];
                        scope[name] = selectionArray;
                    }
                }
                return selectionArray;
            }
            function isMultiSelect() {
                var multiSelect = $scope.config.multiSelect;
                if (angular.isUndefined(multiSelect)) {
                    multiSelect = true;
                }
                return multiSelect;
            }
            $scope.toggleAllSelections = function () {
                var allRowsSelected = $scope.config.allRowsSelected;
                var newFlag = allRowsSelected;
                var selectionArray = getSelectionArray();
                selectionArray.splice(0, selectionArray.length);
                angular.forEach($scope.rows, function (row) {
                    row.selected = newFlag;
                    if (allRowsSelected) {
                        selectionArray.push(row.entity);
                    }
                });
            };
            $scope.toggleRowSelection = function (row) {
                if (row) {
                    var selectionArray = getSelectionArray();
                    if (!isMultiSelect()) {
                        selectionArray.splice(0, selectionArray.length);
                        angular.forEach($scope.rows, function (r) {
                            if (r !== row) {
                                r.selected = false;
                            }
                        });
                    }
                    var entity = row.entity;
                    if (entity) {
                        var idx = selectionArray.indexOf(entity);
                        if (row.selected) {
                            if (idx < 0) {
                                selectionArray.push(entity);
                            }
                        }
                        else {
                            $scope.config.allRowsSelected = false;
                            if (idx >= 0) {
                                selectionArray.splice(idx, 1);
                            }
                        }
                    }
                }
            };
            $scope.sortBy = function (field) {
                if ($scope.config.sortInfo.sortBy === field) {
                    $scope.config.sortInfo.ascending = !$scope.config.sortInfo.ascending;
                }
                else {
                    $scope.config.sortInfo.sortBy = field;
                    $scope.config.sortInfo.ascending = true;
                }
                $scope.$emit("hawtio.datatable." + dataName);
            };
            $scope.getClass = function (field) {
                if ('sortInfo' in $scope.config) {
                    if ($scope.config.sortInfo.sortBy === field) {
                        if ($scope.config.sortInfo.ascending) {
                            return 'asc';
                        }
                        else {
                            return 'desc';
                        }
                    }
                }
                return '';
            };
            $scope.showRow = function (row) {
                var filter = Core.pathGet($scope, ['config', 'filterOptions', 'filterText']);
                if (Core.isBlank(filter)) {
                    return true;
                }
                var data = null;
                try {
                    data = row['entity']['title'];
                }
                catch (e) {
                }
                if (!data) {
                    data = row.entity;
                }
                var match = FilterHelpers.search(data, filter);
                return match;
            };
            $scope.isSelected = function (row) {
                return config.selectedItems.some(row.entity);
            };
            $scope.onRowSelected = function (row) {
                var idx = config.selectedItems.indexOf(row.entity);
                if (idx >= 0) {
                    DataTable.log.debug("De-selecting row at index " + row.index);
                    config.selectedItems.splice(idx, 1);
                }
                else {
                    if (!config.multiSelect) {
                        config.selectedItems.length = 0;
                    }
                    DataTable.log.debug("Selecting row at index " + row.index);
                    row.entity.index = row.index;
                    config.selectedItems.push(row.entity);
                }
            };
            var rootElement = $element;
            rootElement.empty();
            var showCheckBox = firstValueDefined(config, ["showSelectionCheckbox", "displaySelectionCheckbox"], true);
            var enableRowClickSelection = firstValueDefined(config, ["enableRowClickSelection"], false);
            var onMouseDown;
            if (enableRowClickSelection) {
                onMouseDown = "ng-mousedown='onRowSelected(row)' ";
            }
            else {
                onMouseDown = "";
            }
            var headHtml = "<thead><tr>";
            var bodyHtml = "<tbody><tr ng-repeat='row in rows track by $index' ng-show='showRow(row)' " + onMouseDown + "ng-class=\"{'selected': isSelected(row)}\" >";
            var idx = 0;
            if (showCheckBox) {
                var toggleAllHtml = isMultiSelect() ? "<input type='checkbox' ng-show='rows.length' ng-model='config.allRowsSelected' ng-change='toggleAllSelections()'>" : "";
                headHtml += "\n<th class='simple-table-checkbox'>" + toggleAllHtml + "</th>";
                bodyHtml += "\n<td class='simple-table-checkbox'><input type='checkbox' ng-model='row.selected' ng-change='toggleRowSelection(row)'></td>";
            }
            angular.forEach(config.columnDefs, function (colDef) {
                var field = colDef.field;
                var cellTemplate = colDef.cellTemplate || '<div class="ngCellText" title="{{row.entity.' + field + '}}">{{row.entity.' + field + '}}</div>';
                headHtml += "\n<th class='clickable no-fade table-header' ng-click=\"sortBy('" + field + "')\" ng-class=\"getClass('" + field + "')\">{{config.columnDefs[" + idx + "].displayName}}<span class='indicator'></span></th>";
                bodyHtml += "\n<td>" + cellTemplate + "</td>";
                idx += 1;
            });
            var html = headHtml + "\n</tr></thead>\n" + bodyHtml + "\n</tr></tbody>";
            var newContent = this.$compile(html)($scope);
            rootElement.html(newContent);
        };
        return SimpleDataTable;
    })();
    DataTable.SimpleDataTable = SimpleDataTable;
    function firstValueDefined(object, names, defaultValue) {
        var answer = defaultValue;
        var found = false;
        angular.forEach(names, function (name) {
            var value = object[name];
            if (!found && angular.isDefined(value)) {
                answer = value;
                found = true;
            }
        });
        return answer;
    }
    DataTable._module.directive('hawtioSimpleTable', ["$compile", function ($compile) { return new DataTable.SimpleDataTable($compile); }]);
})(DataTable || (DataTable = {}));
var Dozer;
(function (Dozer) {
    Dozer.jmxDomain = 'net.sourceforge.dozer';
    Dozer.introspectorMBean = "hawtio:type=Introspector";
    Dozer.excludedPackages = [
        'java.lang',
        'int',
        'double',
        'long'
    ];
    Dozer.elementNameMappings = {
        "Mapping": "mapping",
        "MappingClass": "class",
        "Field": "field"
    };
    Dozer.log = Logger.get("Dozer");
    function loadDozerModel(xml, pageId) {
        var doc = xml;
        if (angular.isString(xml)) {
            doc = $.parseXML(xml);
        }
        console.log("Has Dozer XML document: " + doc);
        var model = new Dozer.Mappings(doc);
        var mappingsElement = doc.documentElement;
        copyAttributes(model, mappingsElement);
        $(mappingsElement).children("mapping").each(function (idx, element) {
            var mapping = createMapping(element);
            model.mappings.push(mapping);
        });
        return model;
    }
    Dozer.loadDozerModel = loadDozerModel;
    function saveToXmlText(model) {
        var element = model.doc.documentElement.cloneNode(false);
        appendElement(model.mappings, element, null, 1);
        Dozer.addTextNode(element, "\n");
        var xmlText = Core.xmlNodeToString(element);
        return '<?xml version="1.0" encoding="UTF-8"?>\n' + xmlText;
    }
    Dozer.saveToXmlText = saveToXmlText;
    function findUnmappedFields(workspace, mapping, fn) {
        var className = mapping.class_a.value;
        findProperties(workspace, className, null, function (properties) {
            var answer = [];
            angular.forEach(properties, function (property) {
                console.log("got property " + JSON.stringify(property, null, "  "));
                var name = property.name;
                if (name) {
                    if (mapping.hasFromField(name)) {
                    }
                    else {
                        answer.push(new Dozer.UnmappedField(name, property));
                    }
                }
            });
            fn(answer);
        });
    }
    Dozer.findUnmappedFields = findUnmappedFields;
    function findProperties(workspace, className, filter, fn) {
        if (filter === void 0) { filter = null; }
        if (fn === void 0) { fn = null; }
        var mbean = getIntrospectorMBean(workspace);
        if (mbean) {
            if (filter) {
                return workspace.jolokia.execute(mbean, "findProperties", className, filter, onSuccess(fn));
            }
            else {
                return workspace.jolokia.execute(mbean, "getProperties", className, onSuccess(fn));
            }
        }
        else {
            if (fn) {
                return fn([]);
            }
            else {
                return [];
            }
        }
    }
    Dozer.findProperties = findProperties;
    function findClassNames(workspace, searchText, limit, fn) {
        if (limit === void 0) { limit = 20; }
        if (fn === void 0) { fn = null; }
        var mbean = getIntrospectorMBean(workspace);
        if (mbean) {
            return workspace.jolokia.execute(mbean, "findClassNames", searchText, limit, onSuccess(fn));
        }
        else {
            if (fn) {
                return fn([]);
            }
            else {
                return [];
            }
        }
    }
    Dozer.findClassNames = findClassNames;
    function getIntrospectorMBean(workspace) {
        return Dozer.introspectorMBean;
    }
    Dozer.getIntrospectorMBean = getIntrospectorMBean;
    function loadModelFromTree(rootTreeNode, oldModel) {
        oldModel.mappings = [];
        angular.forEach(rootTreeNode.childList, function (treeNode) {
            var mapping = Core.pathGet(treeNode, ["data", "entity"]);
            if (mapping) {
                oldModel.mappings.push(mapping);
            }
        });
        return oldModel;
    }
    Dozer.loadModelFromTree = loadModelFromTree;
    function createDozerTree(model) {
        var id = "mappings";
        var folder = new Folder(id);
        folder.addClass = "net-sourceforge-dozer-mappings";
        folder.domain = Dozer.jmxDomain;
        folder.typeName = "mappings";
        folder.entity = model;
        folder.key = Core.toSafeDomID(id);
        angular.forEach(model.mappings, function (mapping) {
            var mappingFolder = createMappingFolder(mapping, folder);
            folder.children.push(mappingFolder);
        });
        return folder;
    }
    Dozer.createDozerTree = createDozerTree;
    function createMappingFolder(mapping, parentFolder) {
        var mappingName = mapping.name();
        var mappingFolder = new Folder(mappingName);
        mappingFolder.addClass = "net-sourceforge-dozer-mapping";
        mappingFolder.typeName = "mapping";
        mappingFolder.domain = Dozer.jmxDomain;
        mappingFolder.key = (parentFolder ? parentFolder.key + "_" : "") + Core.toSafeDomID(mappingName);
        mappingFolder.parent = parentFolder;
        mappingFolder.entity = mapping;
        mappingFolder.icon = Core.url("/app/dozer/img/class.gif");
        angular.forEach(mapping.fields, function (field) {
            addMappingFieldFolder(field, mappingFolder);
        });
        return mappingFolder;
    }
    Dozer.createMappingFolder = createMappingFolder;
    function addMappingFieldFolder(field, mappingFolder) {
        var name = field.name();
        var fieldFolder = new Folder(name);
        fieldFolder.addClass = "net-sourceforge-dozer-field";
        fieldFolder.typeName = "field";
        fieldFolder.domain = Dozer.jmxDomain;
        fieldFolder.key = mappingFolder.key + "_" + Core.toSafeDomID(name);
        fieldFolder.parent = mappingFolder;
        fieldFolder.entity = field;
        fieldFolder.icon = Core.url("/app/dozer/img/attribute.gif");
        mappingFolder.children.push(fieldFolder);
        return fieldFolder;
    }
    Dozer.addMappingFieldFolder = addMappingFieldFolder;
    function createMapping(element) {
        var mapping = new Dozer.Mapping();
        var elementJQ = $(element);
        mapping.class_a = createMappingClass(elementJQ.children("class-a"));
        mapping.class_b = createMappingClass(elementJQ.children("class-b"));
        elementJQ.children("field").each(function (idx, fieldElement) {
            var field = createField(fieldElement);
            mapping.fields.push(field);
        });
        copyAttributes(mapping, element);
        return mapping;
    }
    function createField(element) {
        if (element) {
            var jqe = $(element);
            var a = jqe.children("a").text();
            var b = jqe.children("b").text();
            var field = new Dozer.Field(new Dozer.FieldDefinition(a), new Dozer.FieldDefinition(b));
            copyAttributes(field, element);
            return field;
        }
        return new Dozer.Field(new Dozer.FieldDefinition(""), new Dozer.FieldDefinition(""));
    }
    function createMappingClass(jqElement) {
        if (jqElement && jqElement[0]) {
            var element = jqElement[0];
            var text = element.textContent;
            if (text) {
                var mappingClass = new Dozer.MappingClass(text);
                copyAttributes(mappingClass, element);
                return mappingClass;
            }
        }
        return new Dozer.MappingClass("");
    }
    function copyAttributes(object, element) {
        var attributeMap = element.attributes;
        for (var i = 0; i < attributeMap.length; i++) {
            var attMap = attributeMap;
            var attr = attMap.item(i);
            if (attr) {
                var name = attr.localName;
                var value = attr.value;
                if (name && !name.startsWith("xmlns")) {
                    var safeName = Forms.safeIdentifier(name);
                    object[safeName] = value;
                }
            }
        }
    }
    function appendAttributes(object, element, ignorePropertyNames) {
        angular.forEach(object, function (value, key) {
            if (ignorePropertyNames.any(key)) {
            }
            else {
                if (value) {
                    var text = value.toString();
                    var name = key.replace(/_/g, '-');
                    element.setAttribute(name, text);
                }
            }
        });
    }
    Dozer.appendAttributes = appendAttributes;
    function appendElement(object, element, elementName, indentLevel) {
        if (elementName === void 0) { elementName = null; }
        if (indentLevel === void 0) { indentLevel = 0; }
        var answer = null;
        if (angular.isArray(object)) {
            angular.forEach(object, function (child) {
                answer = appendElement(child, element, elementName, indentLevel);
            });
        }
        else if (object) {
            if (!elementName) {
                var className = Core.pathGet(object, ["constructor", "name"]);
                if (!className) {
                    console.log("WARNING: no class name for value " + object);
                }
                else {
                    elementName = Dozer.elementNameMappings[className];
                    if (!elementName) {
                        console.log("WARNING: could not map class name " + className + " to an XML element name");
                    }
                }
            }
            if (elementName) {
                if (indentLevel) {
                    var text = indentText(indentLevel);
                    Dozer.addTextNode(element, text);
                }
                var doc = element.ownerDocument || document;
                var child = doc.createElement(elementName);
                var fn = object.saveToElement;
                if (fn) {
                    fn.apply(object, [child]);
                }
                else {
                    angular.forEach(object, function (value, key) {
                        console.log("has key " + key + " value " + value);
                    });
                }
                if ($(child).children().length) {
                    var text = indentText(indentLevel);
                    Dozer.addTextNode(child, text);
                }
                element.appendChild(child);
                answer = child;
            }
        }
        return answer;
    }
    Dozer.appendElement = appendElement;
    function nameOf(object) {
        var text = angular.isObject(object) ? object["value"] : null;
        if (!text && angular.isString(object)) {
            text = object;
        }
        return text || "?";
    }
    Dozer.nameOf = nameOf;
    function addTextNode(element, text) {
        if (text) {
            var doc = element.ownerDocument || document;
            var child = doc.createTextNode(text);
            element.appendChild(child);
        }
    }
    Dozer.addTextNode = addTextNode;
    function indentText(indentLevel) {
        var text = "\n";
        for (var i = 0; i < indentLevel; i++) {
            text += "  ";
        }
        return text;
    }
})(Dozer || (Dozer = {}));
var Dozer;
(function (Dozer) {
    var Mappings = (function () {
        function Mappings(doc, mappings) {
            if (mappings === void 0) { mappings = []; }
            this.doc = doc;
            this.mappings = mappings;
        }
        return Mappings;
    })();
    Dozer.Mappings = Mappings;
    var Mapping = (function () {
        function Mapping() {
            this.fields = [];
            this.map_id = Core.getUUID();
            this.class_a = new MappingClass('');
            this.class_b = new MappingClass('');
        }
        Mapping.prototype.name = function () {
            return Dozer.nameOf(this.class_a) + " -> " + Dozer.nameOf(this.class_b);
        };
        Mapping.prototype.hasFromField = function (name) {
            return this.fields.find(function (f) { return name === f.a.value; });
        };
        Mapping.prototype.hasToField = function (name) {
            return this.fields.find(function (f) { return name === f.b.value; });
        };
        Mapping.prototype.saveToElement = function (element) {
            Dozer.appendElement(this.class_a, element, "class-a", 2);
            Dozer.appendElement(this.class_b, element, "class-b", 2);
            Dozer.appendElement(this.fields, element, "field", 2);
            Dozer.appendAttributes(this, element, ["class_a", "class_b", "fields"]);
        };
        return Mapping;
    })();
    Dozer.Mapping = Mapping;
    var MappingClass = (function () {
        function MappingClass(value) {
            this.value = value;
        }
        MappingClass.prototype.saveToElement = function (element) {
            Dozer.addTextNode(element, this.value);
            Dozer.appendAttributes(this, element, ["value", "properties", "error"]);
        };
        return MappingClass;
    })();
    Dozer.MappingClass = MappingClass;
    var Field = (function () {
        function Field(a, b) {
            this.a = a;
            this.b = b;
        }
        Field.prototype.name = function () {
            return Dozer.nameOf(this.a) + " -> " + Dozer.nameOf(this.b);
        };
        Field.prototype.saveToElement = function (element) {
            Dozer.appendElement(this.a, element, "a", 3);
            Dozer.appendElement(this.b, element, "b", 3);
            Dozer.appendAttributes(this, element, ["a", "b"]);
        };
        return Field;
    })();
    Dozer.Field = Field;
    var FieldDefinition = (function () {
        function FieldDefinition(value) {
            this.value = value;
        }
        FieldDefinition.prototype.saveToElement = function (element) {
            Dozer.addTextNode(element, this.value);
            Dozer.appendAttributes(this, element, ["value", "properties", "error"]);
        };
        return FieldDefinition;
    })();
    Dozer.FieldDefinition = FieldDefinition;
    var UnmappedField = (function () {
        function UnmappedField(fromField, property, toField) {
            if (toField === void 0) { toField = null; }
            this.fromField = fromField;
            this.property = property;
            this.toField = toField;
        }
        return UnmappedField;
    })();
    Dozer.UnmappedField = UnmappedField;
})(Dozer || (Dozer = {}));
var Dozer;
(function (Dozer) {
    function schemaConfigure() {
        io_hawt_dozer_schema_Field["tabs"] = {
            'Fields': ['a.value', 'b.value'],
            'From Field': ['a\\..*'],
            'To Field': ['b\\..*'],
            'Field Configuration': ['*']
        };
        io_hawt_dozer_schema_Mapping["tabs"] = {
            'Classes': ['class-a.value', 'class-b.value'],
            'From Class': ['class-a\\..*'],
            'To Class': ['class-b\\..*'],
            'Class Configuration': ['*']
        };
        io_hawt_dozer_schema_Mapping.properties.fieldOrFieldExclude.hidden = true;
        Core.pathSet(io_hawt_dozer_schema_Field, ["properties", "a", "properties", "value", "label"], "From Field");
        Core.pathSet(io_hawt_dozer_schema_Field, ["properties", "b", "properties", "value", "label"], "To Field");
        Core.pathSet(io_hawt_dozer_schema_Mapping, ["properties", "class-a", "properties", "value", "label"], "From Class");
        Core.pathSet(io_hawt_dozer_schema_Mapping, ["properties", "class-b", "properties", "value", "label"], "To Class");
        Core.pathSet(io_hawt_dozer_schema_Field, ["properties", "a", "ignorePrefixInLabel"], true);
        Core.pathSet(io_hawt_dozer_schema_Field, ["properties", "b", "ignorePrefixInLabel"], true);
        Core.pathSet(io_hawt_dozer_schema_Mapping, ["properties", "class-a", "ignorePrefixInLabel"], true);
        Core.pathSet(io_hawt_dozer_schema_Mapping, ["properties", "class-b", "ignorePrefixInLabel"], true);
        Core.pathSet(io_hawt_dozer_schema_Mapping, ["properties", "class-a", "properties", "value", "formTemplate"], classNameWidget("class_a"));
        Core.pathSet(io_hawt_dozer_schema_Mapping, ["properties", "class-b", "properties", "value", "formTemplate"], classNameWidget("class_b"));
        Core.pathSet(io_hawt_dozer_schema_Field, ["properties", "a", "properties", "value", "formTemplate"], '<input type="text" ng-model="dozerEntity.a.value" ' + 'typeahead="title for title in fromFieldNames($viewValue) | filter:$viewValue" ' + 'typeahead-editable="true"  title="The Java class name"/>');
        Core.pathSet(io_hawt_dozer_schema_Field, ["properties", "b", "properties", "value", "formTemplate"], '<input type="text" ng-model="dozerEntity.b.value" ' + 'typeahead="title for title in toFieldNames($viewValue) | filter:$viewValue" ' + 'typeahead-editable="true"  title="The Java class name"/>');
        function classNameWidget(propertyName) {
            return '<input type="text" ng-model="dozerEntity.' + propertyName + '.value" ' + 'typeahead="title for title in classNames($viewValue) | filter:$viewValue" ' + 'typeahead-editable="true"  title="The Java class name"/>';
        }
    }
    Dozer.schemaConfigure = schemaConfigure;
})(Dozer || (Dozer = {}));
var ES;
(function (ES) {
    ES.config = {
        elasticsearch: "http://" + window.location.hostname + ":9200",
        indice: "twitter",
        doctype: "tweet",
        query: "*"
    };
})(ES || (ES = {}));
var ES;
(function (ES) {
    function isEmptyObject(value) {
        return $.isEmptyObject(value);
    }
    ES.isEmptyObject = isEmptyObject;
    function SearchCtrl($scope, $location, $log, ejsResource) {
        var esServer = $scope.esServer = ES.config["elasticsearch"];
        var query = $scope.queryTerm = ES.config["query"];
        var facetField = $scope.facetField = "tags";
        var facetType = $scope.facetType = "terms";
        var index = $scope.indice = ES.config["indice"];
        var type = $scope.docType = ES.config["doctype"];
        var ejs;
        var request;
        $scope.log = $log;
        $scope.search = function () {
            if (isEmptyObject(ejs)) {
                console.log("Init EJS server");
                ejs = initElasticsearchServer(esServer);
            }
            setupEsRequest();
            request = request.query(ejs.QueryStringQuery(query));
            var results = request.doSearch();
            console.log("Do Elastic Search");
            results.then(function (results) {
                $scope.queryTerm = "";
                if (typeof results.error != 'undefined') {
                    console.error("ES error : " + results.error);
                    return;
                }
                console.log(results.hits.total + " : results retrieved");
                $scope.results = results;
            });
        };
        $scope.facetTermsSearch = function () {
            if (isEmptyObject(ejs)) {
                console.log("Init EJS server");
                ejs = initElasticsearchServer(esServer);
            }
            setupEsRequest();
            if (!isEmptyObject($scope.facetField)) {
                facetField = $scope.facetField;
            }
            if (!isEmptyObject($scope.facetType)) {
                facetType = $scope.facetType;
            }
            request = request.query(ejs.QueryStringQuery(query)).facet(ejs.TermsFacet("termFacet").field(facetField).size(50));
            var results = request.doSearch();
            console.log("Do Elastic Search");
            results.then(function (results) {
                $scope.queryTerm = "";
                if (typeof results.error != 'undefined') {
                    console.error("ES error : " + results.error);
                    return;
                }
                console.log(results.hits.total + " : results retrieved");
                $scope.results = results;
            });
        };
        $scope.facetDateHistogramSearch = function () {
            if (isEmptyObject(ejs)) {
                console.log("Init EJS server");
                ejs = initElasticsearchServer(esServer);
            }
            setupEsRequest();
            if (!isEmptyObject($scope.facetField)) {
                facetField = $scope.facetField;
            }
            if (!isEmptyObject($scope.facetType)) {
                facetType = $scope.facetType;
            }
            request = request.query(ejs.QueryStringQuery(query)).facet(ejs.DateHistogramFacet("dateHistoFacet").field(facetField).interval("minute"));
            var results = request.doSearch();
            console.log("Do Elastic Search");
            results.then(function (results) {
                $scope.queryTerm = "";
                if (typeof results.error != 'undefined') {
                    console.error("ES error : " + results.error);
                    return;
                }
                console.log(results.hits.total + " : results retrieved");
                $scope.results = results;
            });
        };
        $scope.indexSampleDocs = function () {
            var host = "http://" + location.host;
            if (isEmptyObject(ejs)) {
                console.log("EJS object is not defined - create it - setupEsRequest");
                ejs = initElasticsearchServer(esServer);
            }
            var docs = [];
            $.getJSON(host + "/hawtio/app/elasticsearch/js/data.json", function (result) {
                $.each(result, function (i, field) {
                    console.log("Field : " + field);
                    docs[i] = ejs.Document(index, type, i).source(field);
                    docs[i].refresh(true).doIndex();
                });
            });
        };
        function setupEsRequest() {
            console.log("ES Server = " + $scope.esServer);
            console.log("Indice = " + $scope.indice);
            console.log("Type = " + $scope.docType);
            console.log("Query = " + $scope.queryTerm);
            if (!isEmptyObject($scope.indice)) {
                index = $scope.indice;
            }
            if (!isEmptyObject($scope.esServer)) {
                esServer = $scope.esServer;
            }
            if (!isEmptyObject($scope.docType)) {
                type = $scope.docType;
            }
            if (!isEmptyObject($scope.queryTerm)) {
                query = $scope.queryTerm;
            }
            var ejs = ejsResource($scope.esServer);
            request = ejs.Request().indices(index).types(type);
            console.log("Request to call ElasticSearch defined");
        }
        function initElasticsearchServer(esServer) {
            return ejsResource(esServer);
        }
        $scope.parse_error = function (data) {
            var _error = data.match("nested: (.*?);");
            return _error == null ? data : _error[1];
        };
    }
    ES.SearchCtrl = SearchCtrl;
})(ES || (ES = {}));
var ES;
(function (ES) {
    var pluginName = 'elasticsearch';
    var base_url = 'app/elasticsearch/html';
    ES._module = angular.module(pluginName, ['bootstrap', 'ngResource', 'elasticjs.service', 'dangle']);
    ES._module.config(['$routeProvider', function ($routeProvider) {
        $routeProvider.when('/elasticsearch', { templateUrl: base_url + '/es.html' });
    }]);
    ES._module.run(["$location", "workspace", "viewRegistry", "helpRegistry", function ($location, workspace, viewRegistry, helpRegistry) {
        viewRegistry[pluginName] = 'app/elasticsearch/html/es.html';
        helpRegistry.addUserDoc(pluginName, 'app/elasticsearch/doc/help.md', function () {
            return false;
        });
    }]);
})(ES || (ES = {}));
var PluginHelpers;
(function (PluginHelpers) {
    function createControllerFunction(_module, pluginName) {
        return function (name, inlineAnnotatedConstructor) {
            return _module.controller(pluginName + '.' + name, inlineAnnotatedConstructor);
        };
    }
    PluginHelpers.createControllerFunction = createControllerFunction;
    function createRoutingFunction(templateUrl) {
        return function (templateName, reloadOnSearch) {
            if (reloadOnSearch === void 0) { reloadOnSearch = true; }
            return {
                templateUrl: UrlHelpers.join(templateUrl, templateName),
                reloadOnSearch: reloadOnSearch
            };
        };
    }
    PluginHelpers.createRoutingFunction = createRoutingFunction;
})(PluginHelpers || (PluginHelpers = {}));
var Wiki;
(function (Wiki) {
    var GitWikiRepository = (function () {
        function GitWikiRepository(factoryMethod) {
            this.factoryMethod = factoryMethod;
            this.directoryPrefix = "";
        }
        GitWikiRepository.prototype.getRepositoryLabel = function (fn, error) {
            this.git().getRepositoryLabel(fn, error);
        };
        GitWikiRepository.prototype.exists = function (branch, path, fn) {
            var fullPath = this.getPath(path);
            return this.git().exists(branch, fullPath, fn);
        };
        GitWikiRepository.prototype.completePath = function (branch, completionText, directoriesOnly, fn) {
            return this.git().completePath(branch, completionText, directoriesOnly, fn);
        };
        GitWikiRepository.prototype.getPage = function (branch, path, objectId, fn) {
            var _this = this;
            var git = this.git();
            path = path || "/";
            if (git) {
                if (objectId) {
                    var blobPath = this.getLogPath(path);
                    git.getContent(objectId, blobPath, function (content) {
                        var details = {
                            text: content,
                            directory: false
                        };
                        fn(details);
                    });
                }
                else {
                    var fullPath = this.getPath(path);
                    git.read(branch, fullPath, function (details) {
                        var children = details.children;
                        angular.forEach(children, function (child) {
                            var path = child.path;
                            if (path) {
                                var directoryPrefix = "/" + _this.directoryPrefix;
                                if (path.startsWith(directoryPrefix)) {
                                    path = "/" + path.substring(directoryPrefix.length);
                                    child.path = path;
                                }
                            }
                        });
                        fn(details);
                    });
                }
            }
            return git;
        };
        GitWikiRepository.prototype.diff = function (objectId, baseObjectId, path, fn) {
            var fullPath = this.getLogPath(path);
            var git = this.git();
            if (git) {
                git.diff(objectId, baseObjectId, fullPath, function (content) {
                    var details = {
                        text: content,
                        format: "diff",
                        directory: false
                    };
                    fn(details);
                });
            }
            return git;
        };
        GitWikiRepository.prototype.commitInfo = function (commitId, fn) {
            this.git().commitInfo(commitId, fn);
        };
        GitWikiRepository.prototype.commitTree = function (commitId, fn) {
            this.git().commitTree(commitId, fn);
        };
        GitWikiRepository.prototype.putPage = function (branch, path, contents, commitMessage, fn) {
            var fullPath = this.getPath(path);
            this.git().write(branch, fullPath, commitMessage, contents, fn);
        };
        GitWikiRepository.prototype.putPageBase64 = function (branch, path, contents, commitMessage, fn) {
            var fullPath = this.getPath(path);
            this.git().writeBase64(branch, fullPath, commitMessage, contents, fn);
        };
        GitWikiRepository.prototype.createDirectory = function (branch, path, commitMessage, fn) {
            var fullPath = this.getPath(path);
            this.git().createDirectory(branch, fullPath, commitMessage, fn);
        };
        GitWikiRepository.prototype.revertTo = function (branch, objectId, blobPath, commitMessage, fn) {
            var fullPath = this.getLogPath(blobPath);
            this.git().revertTo(branch, objectId, fullPath, commitMessage, fn);
        };
        GitWikiRepository.prototype.rename = function (branch, oldPath, newPath, commitMessage, fn) {
            var fullOldPath = this.getPath(oldPath);
            var fullNewPath = this.getPath(newPath);
            if (!commitMessage) {
                commitMessage = "Renaming page " + oldPath + " to " + newPath;
            }
            this.git().rename(branch, fullOldPath, fullNewPath, commitMessage, fn);
        };
        GitWikiRepository.prototype.removePage = function (branch, path, commitMessage, fn) {
            var fullPath = this.getPath(path);
            if (!commitMessage) {
                commitMessage = "Removing page " + path;
            }
            this.git().remove(branch, fullPath, commitMessage, fn);
        };
        GitWikiRepository.prototype.getPath = function (path) {
            var directoryPrefix = this.directoryPrefix;
            return (directoryPrefix) ? directoryPrefix + path : path;
        };
        GitWikiRepository.prototype.getLogPath = function (path) {
            return Core.trimLeading(this.getPath(path), "/");
        };
        GitWikiRepository.prototype.history = function (branch, objectId, path, limit, fn) {
            var fullPath = this.getLogPath(path);
            var git = this.git();
            if (git) {
                git.history(branch, objectId, fullPath, limit, fn);
            }
            return git;
        };
        GitWikiRepository.prototype.getContent = function (objectId, blobPath, fn) {
            var fullPath = this.getLogPath(blobPath);
            var git = this.git();
            if (git) {
                git.getContent(objectId, fullPath, fn);
            }
            return git;
        };
        GitWikiRepository.prototype.branches = function (fn) {
            var git = this.git();
            if (git) {
                git.branches(fn);
            }
            return git;
        };
        GitWikiRepository.prototype.jsonChildContents = function (path, nameWildcard, search, fn) {
            var fullPath = this.getLogPath(path);
            var git = this.git();
            if (git) {
                git.readJsonChildContent(fullPath, nameWildcard, search, fn);
            }
            return git;
        };
        GitWikiRepository.prototype.git = function () {
            var repository = this.factoryMethod();
            if (!repository) {
                console.log("No repository yet! TODO we should use a local impl!");
            }
            return repository;
        };
        return GitWikiRepository;
    })();
    Wiki.GitWikiRepository = GitWikiRepository;
})(Wiki || (Wiki = {}));
var Wiki;
(function (Wiki) {
    Wiki.pluginName = 'wiki';
    Wiki.templatePath = 'app/wiki/html/';
    Wiki.tab = null;
    Wiki._module = angular.module(Wiki.pluginName, ['bootstrap', 'ui.bootstrap.dialog', 'ui.bootstrap.tabs', 'ngResource', 'hawtioCore', 'hawtio-ui', 'tree', 'camel']);
    Wiki.controller = PluginHelpers.createControllerFunction(Wiki._module, 'Wiki');
    Wiki.route = PluginHelpers.createRoutingFunction(Wiki.templatePath);
    Wiki._module.config(["$routeProvider", function ($routeProvider) {
        angular.forEach(["", "/branch/:branch"], function (path) {
            $routeProvider.when(UrlHelpers.join('/wiki', path, 'view'), Wiki.route('viewPage.html', false)).when(UrlHelpers.join('/wiki', path, 'create/*page'), Wiki.route('create.html', false)).when('/wiki' + path + '/view/*page', { templateUrl: 'app/wiki/html/viewPage.html', reloadOnSearch: false }).when('/wiki' + path + '/book/*page', { templateUrl: 'app/wiki/html/viewBook.html', reloadOnSearch: false }).when('/wiki' + path + '/edit/*page', { templateUrl: 'app/wiki/html/editPage.html' }).when('/wiki' + path + '/version/*page/:objectId', { templateUrl: 'app/wiki/html/viewPage.html' }).when('/wiki' + path + '/history/*page', { templateUrl: 'app/wiki/html/history.html' }).when('/wiki' + path + '/commit/*page/:objectId', { templateUrl: 'app/wiki/html/commit.html' }).when('/wiki' + path + '/diff/*page/:objectId/:baseObjectId', { templateUrl: 'app/wiki/html/viewPage.html', reloadOnSearch: false }).when('/wiki' + path + '/formTable/*page', { templateUrl: 'app/wiki/html/formTable.html' }).when('/wiki' + path + '/dozer/mappings/*page', { templateUrl: 'app/wiki/html/dozerMappings.html' }).when('/wiki' + path + '/configurations/*page', { templateUrl: 'app/wiki/html/configurations.html' }).when('/wiki' + path + '/configuration/:pid/*page', { templateUrl: 'app/wiki/html/configuration.html' }).when('/wiki' + path + '/newConfiguration/:factoryPid/*page', { templateUrl: 'app/wiki/html/configuration.html' }).when('/wiki' + path + '/camel/diagram/*page', { templateUrl: 'app/wiki/html/camelDiagram.html' }).when('/wiki' + path + '/camel/canvas/*page', { templateUrl: 'app/wiki/html/camelCanvas.html' }).when('/wiki' + path + '/camel/properties/*page', { templateUrl: 'app/wiki/html/camelProperties.html' });
        });
    }]);
    Wiki._module.factory('wikiRepository', ["workspace", "jolokia", "localStorage", function (workspace, jolokia, localStorage) {
        return new Wiki.GitWikiRepository(function () { return Git.createGitRepository(workspace, jolokia, localStorage); });
    }]);
    Wiki._module.factory('wikiBranchMenu', function () {
        var self = {
            items: [],
            addExtension: function (item) {
                self.items.push(item);
            },
            applyMenuExtensions: function (menu) {
                if (self.items.length === 0) {
                    return;
                }
                var extendedMenu = [{
                    heading: "Actions"
                }];
                self.items.forEach(function (item) {
                    if (item.valid()) {
                        extendedMenu.push(item);
                    }
                });
                if (extendedMenu.length > 1) {
                    menu.add(extendedMenu);
                }
            }
        };
        return self;
    });
    Wiki._module.factory('fileExtensionTypeRegistry', function () {
        return {
            "image": ["svg", "png", "ico", "bmp", "jpg", "gif"],
            "markdown": ["md", "markdown", "mdown", "mkdn", "mkd"],
            "htmlmixed": ["html", "xhtml", "htm"],
            "text/x-java": ["java"],
            "text/x-scala": ["scala"],
            "javascript": ["js", "json", "javascript", "jscript", "ecmascript", "form"],
            "xml": ["xml", "xsd", "wsdl", "atom"],
            "properties": ["properties"]
        };
    });
    Wiki._module.filter('fileIconClass', function () { return Wiki.iconClass; });
    Wiki._module.run(["$location", "workspace", "viewRegistry", "jolokia", "localStorage", "layoutFull", "helpRegistry", "preferencesRegistry", "wikiRepository", "postLoginTasks", "$rootScope", function ($location, workspace, viewRegistry, jolokia, localStorage, layoutFull, helpRegistry, preferencesRegistry, wikiRepository, postLoginTasks, $rootScope) {
        viewRegistry['wiki'] = Wiki.templatePath + 'layoutWiki.html';
        helpRegistry.addUserDoc('wiki', 'app/wiki/doc/help.md', function () {
            return Wiki.isWikiEnabled(workspace, jolokia, localStorage);
        });
        preferencesRegistry.addTab("Git", 'app/wiki/html/gitPreferences.html');
        Wiki.tab = {
            id: "wiki",
            content: "Wiki",
            title: "View and edit wiki pages",
            isValid: function (workspace) { return Wiki.isWikiEnabled(workspace, jolokia, localStorage); },
            href: function () { return "#/wiki/view"; },
            isActive: function (workspace) { return workspace.isLinkActive("/wiki") && !workspace.linkContains("fabric", "profiles") && !workspace.linkContains("editFeatures"); }
        };
        workspace.topLevelTabs.push(Wiki.tab);
        postLoginTasks.addTask('wikiGetRepositoryLabel', function () {
            wikiRepository.getRepositoryLabel(function (label) {
                Wiki.tab.content = label;
                Core.$apply($rootScope);
            }, function (response) {
            });
        });
        Wiki.documentTemplates.forEach(function (template) {
            if (!template['regex']) {
                template.regex = /(?:)/;
            }
        });
    }]);
    hawtioPluginLoader.addModule(Wiki.pluginName);
})(Wiki || (Wiki = {}));
var Fabric;
(function (Fabric) {
    Fabric.templatePath = 'app/fabric/html/';
    Fabric.activeMQTemplatePath = 'app/activemq/html/';
    Fabric._module = angular.module('fabric', ['bootstrap', 'ui.bootstrap', 'ui.bootstrap.dialog', 'ngResource', 'ngGrid', 'hawtio-forms', 'hawtioCore', 'wiki']);
    Fabric._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/fabric/containers/createContainer', { templateUrl: Fabric.templatePath + 'createContainer.html', reloadOnSearch: false }).when('/fabric/map', { templateUrl: Fabric.templatePath + 'map.html' }).when('/fabric/clusters/*page', { templateUrl: Fabric.templatePath + 'clusters.html' }).when('/fabric/containers', { templateUrl: Fabric.templatePath + 'containers.html', reloadOnSearch: false }).when('/fabric/container/:containerId', { templateUrl: Fabric.templatePath + 'container.html', reloadOnSearch: false }).when('/fabric/assignProfile', { templateUrl: Fabric.templatePath + 'assignProfile.html' }).when('/fabric/activeProfiles', { templateUrl: Fabric.templatePath + 'activeProfiles.html' }).when('/wiki/profile/:versionId/:profileId/editFeatures', { templateUrl: Fabric.templatePath + 'editFeatures.html' }).when('/fabric/profile/:versionId/:profileId/:fname', { templateUrl: Fabric.templatePath + 'pid.html' }).when('/fabric/migrate', { templateUrl: Fabric.templatePath + 'migrateVersions.html' }).when('/fabric/patching', { templateUrl: Fabric.templatePath + 'patching.html' }).when('/fabric/configurations/:versionId/:profileId', { templateUrl: 'app/osgi/html/configurations.html' }).when('/fabric/configuration/:versionId/:profileId/:pid', { templateUrl: 'app/osgi/html/pid.html' }).when('/fabric/configuration/:versionId/:profileId/:pid/:factoryPid', { templateUrl: 'app/osgi/html/pid.html' }).when('/fabric/mq/brokers', { templateUrl: Fabric.templatePath + 'brokers.html' }).when('/fabric/mq/brokerDiagram', { templateUrl: Fabric.activeMQTemplatePath + 'brokerDiagram.html', reloadOnSearch: false }).when('/fabric/mq/brokerNetwork', { templateUrl: Fabric.templatePath + 'brokerNetwork.html' }).when('/fabric/mq/createBroker', { templateUrl: Fabric.templatePath + 'createBroker.html' }).when('/fabric/camel/diagram', { templateUrl: 'app/camel/html/fabricDiagram.html', reloadOnSearch: false }).when('/fabric/api', { templateUrl: Fabric.templatePath + 'apis.html' }).when('/fabric/api/wsdl', { templateUrl: 'app/api/html/wsdl.html' }).when('/fabric/api/wadl', { templateUrl: 'app/api/html/wadl.html' }).when('/fabric/test', { templateUrl: Fabric.templatePath + 'test.html' }).when('/fabric/profileView', { templateUrl: Fabric.templatePath + 'profileView.html', reloadOnSearch: false }).when('/fabric/containerView', { templateUrl: Fabric.templatePath + 'containerView.html', reloadOnSearch: false });
    }]);
    Fabric._module.factory('serviceIconRegistry', function () {
        return Fabric.serviceIconRegistry;
    });
    Fabric._module.factory('containerIconRegistry', function () {
        return Fabric.containerIconRegistry;
    });
    Fabric._module.run(["$location", "workspace", "jolokia", "viewRegistry", "pageTitle", "helpRegistry", "$rootScope", "postLoginTasks", "preferencesRegistry", "wikiBranchMenu", "$dialog", "layoutFull", function ($location, workspace, jolokia, viewRegistry, pageTitle, helpRegistry, $rootScope, postLoginTasks, preferencesRegistry, wikiBranchMenu, $dialog, layoutFull) {
        var layoutFabric = Fabric.templatePath + 'layoutFabric.html';
        var layoutNoTabs = Fabric.templatePath + 'layoutNoTabs.html';
        viewRegistry['fabric/assignProfile'] = layoutFabric;
        viewRegistry['fabric/profileView'] = layoutNoTabs;
        viewRegistry['fabric/containerView'] = layoutNoTabs;
        viewRegistry['fabric/migrate'] = layoutNoTabs;
        viewRegistry['fabric/patching'] = layoutNoTabs;
        viewRegistry['fabric/map'] = layoutFabric;
        viewRegistry['fabric/clusters'] = layoutFabric;
        viewRegistry['fabric/container'] = layoutFabric;
        viewRegistry['fabric/activeProfiles'] = layoutFabric;
        viewRegistry['fabric/containers'] = layoutFabric;
        viewRegistry['fabric/configurations'] = layoutFabric;
        viewRegistry['fabric/configuration'] = layoutFabric;
        viewRegistry['fabric/mq'] = layoutFabric;
        viewRegistry['fabric/camel'] = layoutFabric;
        viewRegistry['fabric/api'] = layoutFabric;
        pageTitle.addTitleElement(function () {
            return Fabric.currentContainerId;
        });
        Fabric.addWikiBranchMenuExtensions(wikiBranchMenu, $dialog, workspace);
        postLoginTasks.addTask('fabricFetchContainerName', function () {
            if (Fabric.currentContainerId === '' && Fabric.fabricCreated(workspace)) {
                jolokia.request({
                    type: 'exec',
                    mbean: Fabric.managerMBean,
                    operation: 'currentContainer()',
                    arguments: []
                }, onSuccess(function (response) {
                    if (!response.value) {
                        return;
                    }
                    Fabric.currentContainer = response.value;
                    Fabric.currentContainerId = Fabric.currentContainer['id'];
                    if ('container' in Perspective.metadata) {
                        Core.pathSet(Perspective.metadata, ['container', 'label'], Fabric.currentContainerId);
                        Core.pathSet(Perspective.metadata, ['container', 'icon'], Fabric.getTypeIcon(Fabric.currentContainer));
                    }
                    Core.$apply($rootScope);
                }));
            }
        });
        preferencesRegistry.addTab("Fabric", "app/fabric/html/preferences.html", function () {
            return Fabric.isFMCContainer(workspace);
        });
        workspace.topLevelTabs.push({
            id: "fabric.runtime",
            content: "Services",
            title: "Manage your containers in this fabric",
            isValid: function (workspace) { return Fabric.isFMCContainer(workspace); },
            href: function () { return "#/fabric/containers"; },
            isActive: function (workspace) { return workspace.isLinkActive("fabric") && !workspace.isLinkActive("fabric/profileView") && !workspace.isLinkActive("fabric/containerView") && !workspace.isLinkActive("fabric/deploy") && !workspace.isLinkActive("fabric/requirements"); }
        });
        workspace.topLevelTabs.push({
            id: "fabric.profiles",
            content: "Profiles",
            title: "Select and deploy profiles into this fabric",
            isValid: function (workspace) { return Fabric.isFMCContainer(workspace); },
            href: function () { return "#/fabric/profileView"; },
            isActive: function (workspace) { return workspace.isLinkActive("fabric/profileView"); }
        });
        workspace.topLevelTabs.push({
            id: 'fabric.containers',
            content: 'Containers',
            title: 'View and manage containers in this fabric',
            isValid: function (workspace) { return Fabric.isFMCContainer(workspace); },
            href: function () { return '#/fabric/containerView'; },
            isActive: function (workspace) { return workspace.isLinkActive('fabric/containerView'); }
        });
        workspace.topLevelTabs.push({
            id: "fabric.configuration",
            content: "Wiki",
            title: "View the documentation and configuration of your profiles in Fabric",
            isValid: function (workspace, perspectiveId) {
                var answer = Fabric.isFMCContainer(workspace);
                if (answer) {
                    var currentId = Perspective.currentPerspectiveId($location, workspace, jolokia, localStorage);
                    answer = "fabric" === (perspectiveId === undefined ? currentId : perspectiveId);
                }
                return answer;
            },
            href: function () {
                return "#/wiki/branch/default-version/view/fabric/profiles";
            },
            isActive: function (workspace) { return workspace.isLinkActive("/wiki") && (workspace.linkContains("fabric", "profiles") || workspace.linkContains("editFeatures")); }
        });
        helpRegistry.addUserDoc('fabric', 'app/fabric/doc/help.md', function () {
            return Fabric.isFMCContainer(workspace);
        });
        helpRegistry.addDevDoc("fabric", 'app/fabric/doc/developer.md');
    }]);
    hawtioPluginLoader.addModule('fabric');
})(Fabric || (Fabric = {}));
var FabricDeploy;
(function (FabricDeploy) {
    FabricDeploy.log = Logger.get('FabricDeploy');
    FabricDeploy.pluginName = 'fabric-deploy';
    FabricDeploy.templatePath = 'app/fabric-deploy/html/';
    FabricDeploy._module = angular.module(FabricDeploy.pluginName, ['bootstrap', 'fabric']);
    FabricDeploy._module.config(['$routeProvider', function ($routeProvider) {
        $routeProvider.when('/fabric/deploy', { templateUrl: FabricDeploy.templatePath + 'deploy.html' });
    }]);
    FabricDeploy._module.run(['viewRegistry', 'layoutFull', 'workspace', function (viewRegistry, layoutFull, workspace) {
        FabricDeploy.log.debug("started");
    }]);
    hawtioPluginLoader.addModule(FabricDeploy.pluginName);
})(FabricDeploy || (FabricDeploy = {}));
var FabricDeploy;
(function (FabricDeploy) {
    FabricDeploy.DeployArtifact = FabricDeploy._module.directive("fabricDeployArtifact", [function () {
        FabricDeploy.log.debug("Creating deploy artifact directive...");
        return {
            restrict: 'A',
            replace: true,
            scope: {
                versionId: '@',
                profileId: '@'
            },
            templateUrl: FabricDeploy.templatePath + "deploy.html",
            controller: ["$scope", "$element", "FileUploader", "jolokiaUrl", "$templateCache", "jolokia", "userDetails", function ($scope, $element, FileUploader, jolokiaUrl, $templateCache, jolokia, userDetails) {
                $scope.artifactTemplate = '';
                jolokia.request({
                    type: 'read',
                    mbean: Fabric.managerMBean,
                    attribute: 'MavenRepoUploadURI'
                }, onSuccess(function (response) {
                    var uploadURI = response.value;
                    if (jolokiaUrl.has('/proxy')) {
                        uploadURI = 'proxy/' + uploadURI;
                    }
                    FabricDeploy.log.debug("Maven upload URI: ", uploadURI);
                    var uploader = $scope.artifactUploader = new FileUploader({
                        headers: {
                            'Authorization': Core.authHeaderValue(userDetails)
                        },
                        autoUpload: true,
                        withCredentials: true,
                        method: 'PUT',
                        url: uploadURI
                    });
                    $scope.doUpload = function () {
                        uploader.uploadAll();
                    };
                    uploader.onWhenAddingFileFailed = function (item, filter, options) {
                        FabricDeploy.log.debug('onWhenAddingFileFailed', item, filter, options);
                    };
                    uploader.onAfterAddingFile = function (fileItem) {
                        FabricDeploy.log.debug('onAfterAddingFile', fileItem);
                    };
                    uploader.onAfterAddingAll = function (addedFileItems) {
                        FabricDeploy.log.debug('onAfterAddingAll', addedFileItems);
                    };
                    uploader.onBeforeUploadItem = function (item) {
                        if ('file' in item) {
                            item.fileSizeMB = (item.file.size / 1024 / 1024).toFixed(2);
                        }
                        else {
                            item.fileSizeMB = 0;
                        }
                        item.url = UrlHelpers.join(uploadURI, item.file.name) + '?profile=' + $scope.profileId + '&version=' + $scope.versionId;
                        FabricDeploy.log.debug('onBeforeUploadItem', item);
                    };
                    uploader.onProgressItem = function (fileItem, progress) {
                        FabricDeploy.log.debug('onProgressItem', fileItem, progress);
                    };
                    uploader.onProgressAll = function (progress) {
                        FabricDeploy.log.debug('onProgressAll', progress);
                    };
                    uploader.onSuccessItem = function (fileItem, response, status, headers) {
                        FabricDeploy.log.debug('onSuccessItem', fileItem, response, status, headers);
                    };
                    uploader.onErrorItem = function (fileItem, response, status, headers) {
                        FabricDeploy.log.debug('onErrorItem', fileItem, response, status, headers);
                    };
                    uploader.onCancelItem = function (fileItem, response, status, headers) {
                        FabricDeploy.log.debug('onCancelItem', fileItem, response, status, headers);
                    };
                    uploader.onCompleteItem = function (fileItem, response, status, headers) {
                        FabricDeploy.log.debug('onCompleteItem', fileItem, response, status, headers);
                    };
                    uploader.onCompleteAll = function () {
                        FabricDeploy.log.debug('onCompleteAll');
                        uploader.clearQueue();
                    };
                    FabricDeploy.log.debug('uploader', uploader);
                    $scope.artifactTemplate = $templateCache.get('fileUpload.html');
                    Core.$apply($scope);
                }));
            }]
        };
    }]);
})(FabricDeploy || (FabricDeploy = {}));
var ObjectHelpers;
(function (ObjectHelpers) {
    function toMap(arr, index, decorator) {
        if (!arr || arr.length === 0) {
            return {};
        }
        var answer = {};
        arr.forEach(function (item) {
            if (angular.isObject(item)) {
                answer[item[index]] = item;
                if (angular.isFunction(decorator)) {
                    decorator(item);
                }
            }
        });
        return answer;
    }
    ObjectHelpers.toMap = toMap;
})(ObjectHelpers || (ObjectHelpers = {}));
var SelectionHelpers;
(function (SelectionHelpers) {
    var log = Logger.get("SelectionHelpers");
    function selectNone(group) {
        group.forEach(function (item) {
            item['selected'] = false;
        });
    }
    SelectionHelpers.selectNone = selectNone;
    function selectAll(group, filter) {
        group.forEach(function (item) {
            if (!filter) {
                item['selected'] = true;
            }
            else {
                if (filter(item)) {
                    item['selected'] = true;
                }
            }
        });
    }
    SelectionHelpers.selectAll = selectAll;
    function toggleSelection(item) {
        item['selected'] = !item['selected'];
    }
    SelectionHelpers.toggleSelection = toggleSelection;
    function selectOne(group, item) {
        selectNone(group);
        toggleSelection(item);
    }
    SelectionHelpers.selectOne = selectOne;
    function sync(selections, group, index) {
        group.forEach(function (item) {
            item['selected'] = selections.any(function (selection) {
                return selection[index] === item[index];
            });
        });
        return group.filter(function (item) {
            return item['selected'];
        });
    }
    SelectionHelpers.sync = sync;
    function select(group, item, $event) {
        var ctrlKey = $event.ctrlKey;
        if (!ctrlKey) {
            if (item['selected']) {
                toggleSelection(item);
            }
            else {
                selectOne(group, item);
            }
        }
        else {
            toggleSelection(item);
        }
    }
    SelectionHelpers.select = select;
    function isSelected(item, yes, no) {
        return maybe(item['selected'], yes, no);
    }
    SelectionHelpers.isSelected = isSelected;
    function clearGroup(group) {
        group.length = 0;
    }
    SelectionHelpers.clearGroup = clearGroup;
    function toggleSelectionFromGroup(group, item, search) {
        var searchMethod = search || item;
        if (group.any(searchMethod)) {
            group.remove(searchMethod);
        }
        else {
            group.add(item);
        }
    }
    SelectionHelpers.toggleSelectionFromGroup = toggleSelectionFromGroup;
    function stringOrBoolean(str, answer) {
        if (angular.isDefined(str)) {
            return str;
        }
        else {
            return answer;
        }
    }
    function nope(str) {
        return stringOrBoolean(str, false);
    }
    function yup(str) {
        return stringOrBoolean(str, true);
    }
    function maybe(answer, yes, no) {
        if (answer) {
            return yup(yes);
        }
        else {
            return nope(no);
        }
    }
    function isInGroup(group, item, yes, no, search) {
        if (!group) {
            return nope(no);
        }
        var searchMethod = search || item;
        return maybe(group.any(searchMethod), yes, no);
    }
    SelectionHelpers.isInGroup = isInGroup;
    function filterByGroup(group, item, yes, no, search) {
        if (group.length === 0) {
            return yup(yes);
        }
        var searchMethod = search || item;
        if (angular.isArray(item)) {
            return maybe(group.intersect(item).length === group.length, yes, no);
        }
        else {
            return maybe(group.any(searchMethod), yes, no);
        }
    }
    SelectionHelpers.filterByGroup = filterByGroup;
    function syncGroupSelection(group, collection, attribute) {
        var newGroup = [];
        if (attribute) {
            group.forEach(function (groupItem) {
                var first = collection.find(function (collectionItem) {
                    return groupItem[attribute] === collectionItem[attribute];
                });
                if (first) {
                    newGroup.push(first);
                }
            });
        }
        else {
            group.forEach(function (groupItem) {
                var first = collection.find(function (collectionItem) {
                    return Object.equal(groupItem, collectionItem);
                });
                if (first) {
                    newGroup.push(first);
                }
            });
        }
        clearGroup(group);
        group.add(newGroup);
    }
    SelectionHelpers.syncGroupSelection = syncGroupSelection;
    function decorate($scope) {
        $scope.selectNone = selectNone;
        $scope.selectAll = selectAll;
        $scope.toggleSelection = toggleSelection;
        $scope.selectOne = selectOne;
        $scope.select = select;
        $scope.clearGroup = clearGroup;
        $scope.toggleSelectionFromGroup = toggleSelectionFromGroup;
        $scope.isInGroup = isInGroup;
        $scope.viewOnly = false;
        $scope.filterByGroup = filterByGroup;
    }
    SelectionHelpers.decorate = decorate;
})(SelectionHelpers || (SelectionHelpers = {}));
var ProfileHelpers;
(function (ProfileHelpers) {
    function getTags(profile) {
        var answer = profile.tags;
        if (!answer || !answer.length) {
            answer = profile.id.split('-');
            answer = answer.first(answer.length - 1);
        }
        return answer;
    }
    ProfileHelpers.getTags = getTags;
})(ProfileHelpers || (ProfileHelpers = {}));
var Fabric;
(function (Fabric) {
    Fabric._module.service("ProfileCart", function () {
        return [];
    });
    Fabric._module.service("ProfileViewActions", ['$location', '$rootScope', function ($location, $rootScope) {
        return {
            'Deploy': {
                index: 0,
                icon: 'icon-ok',
                buttonClass: 'btn-success',
                objectName: Fabric.managerMBean,
                methodName: 'createContainers',
                title: 'Deploy the selected profiles to new containers',
                action: function () {
                    var me = $location.path();
                    $location.path('/fabric/containers/createContainer').search({
                        p: 'fabric',
                        vid: '',
                        pid: '',
                        hideProfileSelector: true,
                        returnTo: me,
                        nextPage: '/fabric/containerView?groupBy=profileIds'
                    });
                    Core.$apply($rootScope);
                }
            },
            'Assign': {
                index: 2,
                icon: 'icon-truck',
                buttonClass: 'btn-primary',
                objectName: Fabric.managerMBean,
                methodName: 'addProfilesToContainer',
                title: 'Deploy the selected profiles to existing containers',
                action: function () {
                    $location.path('/fabric/assignProfile');
                    Core.$apply($rootScope);
                }
            }
        };
    }]);
    Fabric.AppViewPaneHeaderController = Fabric._module.controller("Fabric.AppViewPaneHeaderController", ["$scope", "ProfileCart", "ProfileViewActions", function ($scope, ProfileCart, ProfileViewActions) {
        SelectionHelpers.decorate($scope);
        var lastIndex = null;
        var buttons = [];
        angular.forEach(ProfileViewActions, function (value, key) {
            value['name'] = key;
            buttons.add(value);
        });
        $scope.actionButtons = buttons;
        $scope.cartItems = ProfileCart;
        $scope.getName = function () {
            return $scope.cartItems.map(function (p) {
                return p.id;
            }).join(", ");
        };
        $scope.$watch('filter', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.$emit("Fabric.AppViewPaneController.filter", newValue);
            }
        });
    }]);
    Fabric.AppViewController = Fabric._module.controller("Fabric.AppViewController", ["$scope", 'jolokia', "$templateCache", "ProfileCart", "$location", "workspace", "marked", function ($scope, jolokia, $templateCache, ProfileCart, $location, workspace, marked) {
        $scope.selectedVersion = {};
        $scope.profiles = [];
        $scope.cartItems = ProfileCart;
        $scope.tags = [];
        $scope.selectedTags = [];
        $scope.textFilter = '';
        $scope.lowercaseTextFilter = '';
        SelectionHelpers.decorate($scope);
        $scope.$on('Fabric.AppViewPaneController.filter', function ($event, newValue) {
            $scope.textFilter = newValue;
        });
        $scope.filterProfiles = function (profile) {
            var answer = $scope.filterByGroup($scope.selectedTags, profile.tags);
            if (answer && !Core.isBlank($scope.textFilter)) {
                var filter = $scope.textFilter.toLowerCase();
                return FilterHelpers.searchObject(profile, filter);
            }
            return answer;
        };
        var profileFields = ['id', 'abstract', 'hidden', 'attributes', 'overlay', 'containerCount', 'associatedContainers', 'fileConfigurations', 'iconURL', 'summaryMarkdown', 'tags'];
        var unreg = null;
        Fabric.loadRestApi(jolokia, workspace, undefined, function (response) {
            $scope.restApiUrl = UrlHelpers.maybeProxy(Core.injector.get('jolokiaUrl'), response.value);
            Fabric.log.debug("Scope rest API: ", $scope.restApiUrl);
            $scope.$watch('selectedVersion.id', function (newValue, oldValue) {
                if (!Core.isBlank(newValue)) {
                    if (unreg) {
                        unreg();
                    }
                    unreg = Core.registerForChanges(jolokia, $scope, {
                        type: 'exec',
                        mbean: Fabric.managerMBean,
                        operation: 'getProfiles(java.lang.String,java.util.List)',
                        arguments: [newValue, profileFields]
                    }, render);
                }
            });
        });
        $scope.viewProfile = function (profile) {
            Fabric.gotoProfile(workspace, jolokia, workspace.localStorage, $location, profile.versionId, profile.id);
        };
        function render(response) {
            var value = response.value;
            $scope.profiles = [];
            $scope.tags = [];
            value.forEach(function (profile) {
                if (profile.abstract || profile.hidden || profile.overlay) {
                    return;
                }
                var summaryMarkdown = profile["summaryMarkdown"];
                var tags = ProfileHelpers.getTags(profile);
                $scope.tags.add(tags);
                $scope.profiles.push({
                    id: profile.id,
                    versionId: $scope.selectedVersion.id,
                    name: profile.id,
                    tags: tags,
                    iconURL: Fabric.toIconURL($scope, profile.iconURL),
                    summary: summaryMarkdown ? marked(summaryMarkdown) : "",
                    containerCount: profile.containerCount,
                    associatedContainers: profile.associatedContainers
                });
            });
            $scope.profiles = $scope.profiles.sortBy('name');
            SelectionHelpers.syncGroupSelection($scope.cartItems, $scope.profiles, 'id');
            $scope.tags = $scope.tags.unique().sort();
            Core.$apply($scope);
        }
    }]);
})(Fabric || (Fabric = {}));
var FabricRequirements;
(function (FabricRequirements) {
    FabricRequirements.requirementsContext = '/fabric/requirements';
    FabricRequirements.requirementsHash = '#' + FabricRequirements.requirementsContext;
    FabricRequirements.pluginName = "FabricRequirements";
    FabricRequirements.templatePath = 'app/fabric-requirements/html/';
    FabricRequirements.log = Logger.get(FabricRequirements.pluginName);
    FabricRequirements._module = angular.module(FabricRequirements.pluginName, ['hawtioCore', 'fabric']);
    FabricRequirements.controller = PluginHelpers.createControllerFunction(FabricRequirements._module, FabricRequirements.pluginName);
    FabricRequirements.route = PluginHelpers.createRoutingFunction(FabricRequirements.templatePath);
    var fabricRoute = PluginHelpers.createRoutingFunction('app/fabric/html/');
    FabricRequirements._module.config(['$routeProvider', function ($routeProvider) {
        $routeProvider.when(UrlHelpers.join(FabricRequirements.requirementsContext, 'profile'), FabricRequirements.route('profileRequirements.html')).when(UrlHelpers.join(FabricRequirements.requirementsContext, 'sshConfig'), FabricRequirements.route('sshConfig.html')).when(UrlHelpers.join(FabricRequirements.requirementsContext, 'dockerConfig'), FabricRequirements.route('dockerConfig.html')).when(UrlHelpers.join(FabricRequirements.requirementsContext, 'status'), fabricRoute('activeProfiles.html'));
    }]);
    FabricRequirements._module.run(['viewRegistry', 'layoutFull', 'workspace', 'ProfileViewActions', '$location', '$rootScope', function (viewRegistry, layoutFull, workspace, ProfileViewActions, $location, $rootScope) {
        viewRegistry['fabric/requirements'] = FabricRequirements.templatePath + 'layout.html';
        workspace.topLevelTabs.push({
            id: 'fabric.requirements',
            content: 'Scaling',
            isValid: function (workspace) { return Fabric.isFMCContainer(workspace); },
            isActive: function (workspace) { return workspace.isLinkActive('fabric/requirements'); },
            href: function () { return '#/fabric/requirements/profile'; }
        });
        ProfileViewActions['Add Requirements'] = {
            index: 3,
            icon: 'icon-cog',
            buttonClass: 'btn-primary',
            objectName: Fabric.managerMBean,
            methodName: 'requirementsJson',
            title: 'Create requirements for the selected profiles',
            action: function () {
                $location.path('/fabric/requirements/profile');
                Core.$apply($rootScope);
            }
        };
    }]);
    hawtioPluginLoader.addModule(FabricRequirements.pluginName);
})(FabricRequirements || (FabricRequirements = {}));
var FileUpload;
(function (FileUpload) {
    function useJolokiaTransport(uploader, jolokia, onLoad) {
        var uploaderInternal = uploader;
        var $rootScope = Core.injector.get("$rootScope");
        uploaderInternal._xhrTransport = function (item) {
            var reader = new FileReader();
            reader.onload = function () {
                if (reader.readyState === 2) {
                    var parameters = onLoad(reader.result);
                    jolokia.request(parameters, onSuccess(function (response) {
                        item.json = reader.result;
                        uploaderInternal._onSuccessItem(item, response, response.status, {});
                        uploaderInternal._onCompleteItem(item, response, response.status, {});
                        Core.$apply($rootScope);
                    }, {
                        error: function (response) {
                            uploaderInternal._onErrorItem(item, response, response.status, {});
                            uploaderInternal._onCompleteItem(item, response, response.status, {});
                            Core.$apply($rootScope);
                        }
                    }));
                }
            };
            reader.readAsText(item._file);
        };
    }
    FileUpload.useJolokiaTransport = useJolokiaTransport;
})(FileUpload || (FileUpload = {}));
var FabricRequirements;
(function (FabricRequirements) {
    FabricRequirements._module.service("CurrentRequirements", function () {
        return {
            $dirty: false
        };
    });
    FabricRequirements.RequirementsController = FabricRequirements.controller("RequirementsController", ["$scope", "jolokia", "workspace", "ProfileCart", "$templateCache", "FileUploader", "userDetails", "jolokiaUrl", "$location", "$timeout", "CurrentRequirements", "$element", function ($scope, jolokia, workspace, ProfileCart, $templateCache, FileUploader, userDetails, jolokiaUrl, $location, $timeout, CurrentRequirements, $element) {
        $scope.tabs = {
            '0': {
                name: 'Profile Requirements',
                href: function () { return FabricRequirements.requirementsHash + '/profile'; },
                isActive: function () { return UrlHelpers.contextActive($location.path(), 'profile'); }
            },
            '1': {
                name: 'SSH Configuration',
                href: function () { return FabricRequirements.requirementsHash + '/sshConfig'; },
                isActive: function () { return UrlHelpers.contextActive($location.path(), 'sshConfig'); }
            },
            '2': {
                name: 'Docker Configuration',
                href: function () { return FabricRequirements.requirementsHash + '/dockerConfig'; },
                isActive: function () { return UrlHelpers.contextActive($location.path(), 'dockerConfig'); }
            },
            '3': {
                name: 'Status',
                href: function () { return FabricRequirements.requirementsHash + '/status'; },
                isActive: function () { return UrlHelpers.contextActive($location.path(), 'status'); }
            }
        };
        $scope.requirements = CurrentRequirements;
        $scope.template = '';
        $scope.newTag = '';
        $scope.addTag = function (tag) {
            if (tag && !$scope.requirements.$tags.some(function (t) {
                return t === tag;
            })) {
                $scope.requirements.$tags.push(tag);
                $scope.newTag = '';
                $element.find('#inputNewTag').val('');
            }
        };
        $scope.cancelChanges = function () {
            if ($scope.requirements.$dirty) {
                FabricRequirements.log.debug("Cancelling changes");
                $timeout(function () {
                    Object.merge($scope.requirements, $scope.requirementsFromServer, true);
                }, 20);
            }
        };
        $scope.onDrop = function (data, model, property) {
            FabricRequirements.log.debug("On drop - data: ", data, " model: ", model, " property: ", property);
            if (!model[property]) {
                model[property] = [];
            }
            if (!model[property].any(data)) {
                model[property].push(data);
                $scope.requirements.$dirty = true;
            }
        };
        $scope.$on('hawtio-drop', function ($event, data) {
            $scope.onDrop(data.data, data.model, data.property);
        });
        $scope.saveChanges = function () {
            if ($scope.requirements.$dirty) {
                function onRequirementsSaved() {
                    Core.notification("success", "Saved the requirements");
                    Core.$apply($scope);
                }
                var json = angular.toJson($scope.requirements);
                FabricRequirements.log.debug("Saving requirementS: ", json);
                $scope.requirements.$dirty = false;
                jolokia.execute(Fabric.managerMBean, "requirementsJson", json, onSuccess(onRequirementsSaved));
            }
        };
        $scope.onChange = function () {
            $scope.requirements.$dirty = true;
        };
        Fabric.loadRestApi(jolokia, workspace, undefined, function (response) {
            var uploadUrl = jolokiaUrl;
            $scope.uploader = new FileUploader({
                autoUpload: true,
                removeAfterUpload: true,
                url: uploadUrl
            });
            FileUpload.useJolokiaTransport($scope.uploader, jolokia, function (json) {
                return {
                    'type': 'exec',
                    mbean: Fabric.managerMBean,
                    operation: 'requirementsJson',
                    arguments: [json]
                };
            });
            $scope.uploader.onBeforeUploadItem = function (item) {
                Core.notification('info', 'Uploading ' + item);
            };
            $scope.uploader.onSuccessItem = function (item) {
                $scope.requirements = angular.fromJson(item.json);
            };
            $scope.uploader.onCompleteAll = function () {
                Core.notification('success', 'Imported requirements');
            };
            function createTagList(requirements) {
                var tags = [];
                ['sshConfiguration', 'dockerConfiguration'].forEach(function (config) {
                    if (requirements[config] && requirements[config].hosts) {
                        requirements.sshConfiguration.hosts.forEach(function (host) {
                            tags.add(host.tags);
                        });
                    }
                });
                requirements.profileRequirements.forEach(function (p) {
                    ['sshScalingRequirements', 'dockerScalingRequirements'].forEach(function (req) {
                        if (p[req] && p[req].hostTags) {
                            tags.add(p[req].hostTags);
                        }
                    });
                });
                requirements.$tags = tags.unique().sort();
            }
            Core.registerForChanges(jolokia, $scope, {
                type: 'exec',
                mbean: Fabric.managerMBean,
                operation: "requirements()"
            }, function (response) {
                $scope.requirementsFromServer = response.value;
                if (!$scope.requirements.$dirty) {
                    Object.merge($scope.requirements, $scope.requirementsFromServer, true);
                }
                var profileRequirements = $scope.requirements.profileRequirements;
                ProfileCart.forEach(function (profile) {
                    var id = profile.id;
                    if (!profileRequirements.some(function (r) {
                        return r.profile === id;
                    })) {
                        profileRequirements.push({
                            profile: id,
                            minimumInstances: null,
                            maximumInstances: null,
                            dependentProfiles: []
                        });
                        if (!$scope.requirements.$dirty) {
                            $scope.requirements.$dirty = true;
                        }
                    }
                });
                ProfileCart.length = 0;
                if (Core.isBlank($scope.template)) {
                    $scope.template = $templateCache.get('pageTemplate.html');
                }
                createTagList($scope.requirements);
                Core.$apply($scope);
            });
        });
    }]);
})(FabricRequirements || (FabricRequirements = {}));
var Forms;
(function (Forms) {
    Forms.log = Logger.get("Forms");
    function defaultValues(entity, schema) {
        if (entity && schema) {
            angular.forEach(schema.properties, function (property, key) {
                var defaultValue = property.default;
                if (defaultValue && !entity[key]) {
                    console.log("===== defaulting value " + defaultValue + " into entity[" + key + "]");
                    entity[key] = defaultValue;
                }
            });
        }
    }
    Forms.defaultValues = defaultValues;
    function resolveTypeNameAlias(type, schema) {
        if (type && schema) {
            var alias = lookupDefinition(type, schema);
            if (alias) {
                var realType = alias["type"];
                if (realType) {
                    type = realType;
                }
            }
        }
        return type;
    }
    Forms.resolveTypeNameAlias = resolveTypeNameAlias;
    function isJsonType(name, schema, typeName) {
        var definition = lookupDefinition(name, schema);
        while (definition) {
            var extendsTypes = Core.pathGet(definition, ["extends", "type"]);
            if (extendsTypes) {
                if (typeName === extendsTypes) {
                    return true;
                }
                else {
                    definition = lookupDefinition(extendsTypes, schema);
                }
            }
            else {
                return false;
            }
        }
        return false;
    }
    Forms.isJsonType = isJsonType;
    function safeIdentifier(id) {
        if (id) {
            return id.replace(/-/g, "_");
        }
        return id;
    }
    Forms.safeIdentifier = safeIdentifier;
    function lookupDefinition(name, schema) {
        if (schema) {
            var defs = schema.definitions;
            if (defs) {
                var answer = defs[name];
                if (answer) {
                    var fullSchema = answer["fullSchema"];
                    if (fullSchema) {
                        return fullSchema;
                    }
                    var extendsTypes = Core.pathGet(answer, ["extends", "type"]);
                    if (extendsTypes) {
                        fullSchema = angular.copy(answer);
                        fullSchema.properties = fullSchema.properties || {};
                        if (!angular.isArray(extendsTypes)) {
                            extendsTypes = [extendsTypes];
                        }
                        angular.forEach(extendsTypes, function (extendType) {
                            if (angular.isString(extendType)) {
                                var extendDef = lookupDefinition(extendType, schema);
                                var properties = Core.pathGet(extendDef, ["properties"]);
                                if (properties) {
                                    angular.forEach(properties, function (property, key) {
                                        fullSchema.properties[key] = property;
                                    });
                                }
                            }
                        });
                        answer["fullSchema"] = fullSchema;
                        return fullSchema;
                    }
                }
                return answer;
            }
        }
        return null;
    }
    Forms.lookupDefinition = lookupDefinition;
    function findArrayItemsSchema(property, schema) {
        var items = null;
        if (property && schema) {
            items = property.items;
            if (items) {
                var typeName = items["type"];
                if (typeName) {
                    var definition = lookupDefinition(typeName, schema);
                    if (definition) {
                        return definition;
                    }
                }
            }
            var additionalProperties = property.additionalProperties;
            if (additionalProperties) {
                if (additionalProperties["$ref"] === "#") {
                    return schema;
                }
            }
        }
        return items;
    }
    Forms.findArrayItemsSchema = findArrayItemsSchema;
    function isObjectType(definition) {
        var typeName = Core.pathGet(definition, "type");
        return typeName && "object" === typeName;
    }
    Forms.isObjectType = isObjectType;
    function isArrayOrNestedObject(property, schema) {
        if (property) {
            var propType = resolveTypeNameAlias(property["type"], schema);
            if (propType) {
                if (propType === "object" || propType === "array") {
                    return true;
                }
            }
        }
        return false;
    }
    Forms.isArrayOrNestedObject = isArrayOrNestedObject;
    function configure(config, scopeConfig, attrs) {
        if (angular.isDefined(scopeConfig)) {
            config = angular.extend(config, scopeConfig);
        }
        return angular.extend(config, attrs);
    }
    Forms.configure = configure;
    function getControlGroup(config, arg, id) {
        var rc = angular.element('<div class="' + config.controlgroupclass + '"></div>');
        if (angular.isDefined(arg.description)) {
            rc.attr('title', arg.description);
        }
        if (config['properties'] && config['properties'][id]) {
            var elementConfig = config['properties'][id];
            if (elementConfig && 'control-attributes' in elementConfig) {
                angular.forEach(elementConfig['control-attributes'], function (value, key) {
                    rc.attr(key, value);
                });
            }
        }
        return rc;
    }
    Forms.getControlGroup = getControlGroup;
    function getLabel(config, arg, label) {
        return angular.element('<label class="' + config.labelclass + '">' + label + ': </label>');
    }
    Forms.getLabel = getLabel;
    function getControlDiv(config) {
        return angular.element('<div class="' + config.controlclass + '"></div>');
    }
    Forms.getControlDiv = getControlDiv;
    function getHelpSpan(config, arg, id) {
        var help = Core.pathGet(config.data, ['properties', id, 'help']);
        if (!Core.isBlank(help)) {
            return angular.element('<span class="help-block">' + help + '</span>');
        }
        else {
            return angular.element('<span class="help-block"></span>');
        }
    }
    Forms.getHelpSpan = getHelpSpan;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    function createWidget(propTypeName, property, schema, config, id, ignorePrefixInLabel, configScopeName, wrapInGroup, disableHumanizeLabel) {
        if (wrapInGroup === void 0) { wrapInGroup = true; }
        if (disableHumanizeLabel === void 0) { disableHumanizeLabel = false; }
        var input = null;
        var group = null;
        function copyElementAttributes(element, propertyName) {
            var propertyAttributes = property[propertyName];
            if (propertyAttributes) {
                angular.forEach(propertyAttributes, function (value, key) {
                    if (angular.isString(value)) {
                        element.attr(key, value);
                    }
                });
            }
        }
        function copyAttributes() {
            copyElementAttributes(input, "input-attributes");
            angular.forEach(property, function (value, key) {
                if (angular.isString(value) && key.indexOf("$") < 0 && key !== "type") {
                    var html = Core.escapeHtml(value);
                    input.attr(key, html);
                }
            });
        }
        var options = {
            valueConverter: null
        };
        var safeId = Forms.safeIdentifier(id);
        var inputMarkup = createStandardWidgetMarkup(propTypeName, property, schema, config, options, safeId);
        if (inputMarkup) {
            input = angular.element(inputMarkup);
            copyAttributes();
            id = safeId;
            var modelName = config.model || Core.pathGet(property, ["input-attributes", "ng-model"]);
            if (!modelName) {
                modelName = config.getEntity() + "." + id;
            }
            input.attr("ng-model", modelName);
            input.attr('name', id);
            try {
                if (config.isReadOnly()) {
                    input.attr('readonly', 'true');
                }
            }
            catch (e) {
            }
            var title = property.tooltip || property.label;
            if (title) {
                input.attr('title', title);
            }
            var disableHumanizeLabelValue = disableHumanizeLabel || property.disableHumanizeLabel;
            var defaultLabel = id;
            if (ignorePrefixInLabel || property.ignorePrefixInLabel) {
                var idx = id.lastIndexOf('.');
                if (idx > 0) {
                    defaultLabel = id.substring(idx + 1);
                }
            }
            if (input.attr("type") !== "hidden" && wrapInGroup) {
                group = this.getControlGroup(config, config, id);
                var labelText = property.title || property.label || (disableHumanizeLabelValue ? defaultLabel : Core.humanizeValue(defaultLabel));
                var labelElement = Forms.getLabel(config, config, labelText);
                if (title) {
                    labelElement.attr('title', title);
                }
                group.append(labelElement);
                copyElementAttributes(labelElement, "label-attributes");
                var controlDiv = Forms.getControlDiv(config);
                controlDiv.append(input);
                controlDiv.append(Forms.getHelpSpan(config, config, id));
                group.append(controlDiv);
                copyElementAttributes(controlDiv, "control-attributes");
                copyElementAttributes(group, "control-group-attributes");
                var scope = config.scope;
                if (scope && modelName) {
                    var onModelChange = function (newValue) {
                        scope.$emit("hawtio.form.modelChange", modelName, newValue);
                    };
                    var fn = onModelChange;
                    var converterFn = options.valueConverter;
                    if (converterFn) {
                        fn = function () {
                            converterFn(scope, modelName);
                            var newValue = Core.pathGet(scope, modelName);
                            onModelChange(newValue);
                        };
                    }
                    scope.$watch(modelName, fn);
                }
            }
        }
        else {
            input = angular.element('<div></div>');
            input.attr(Forms.normalize(propTypeName, property, schema), '');
            copyAttributes();
            input.attr('entity', config.getEntity());
            input.attr('mode', config.getMode());
            var fullSchemaName = config.schemaName;
            if (fullSchemaName) {
                input.attr('schema', fullSchemaName);
            }
            if (configScopeName) {
                input.attr('data', configScopeName);
            }
            if (ignorePrefixInLabel || property.ignorePrefixInLabel) {
                input.attr('ignore-prefix-in-label', true);
            }
            if (disableHumanizeLabel || property.disableHumanizeLabel) {
                input.attr('disable-humanize-label', true);
            }
            input.attr('name', id);
        }
        var label = property.label;
        if (label) {
            input.attr('title', label);
        }
        if (property.required) {
            if (input[0].localName === "input" && input.attr("type") === "checkbox") {
            }
            else {
                input.attr('required', 'true');
            }
        }
        return group ? group : input;
    }
    Forms.createWidget = createWidget;
    function createStandardWidgetMarkup(propTypeName, property, schema, config, options, id) {
        var type = Forms.resolveTypeNameAlias(propTypeName, schema);
        if (!type) {
            return '<input type="text"/>';
        }
        var custom = Core.pathGet(property, ["formTemplate"]);
        if (custom) {
            return null;
        }
        var inputElement = Core.pathGet(property, ["input-element"]);
        if (inputElement) {
            return "<" + inputElement + "></" + inputElement + ">";
        }
        var enumValues = Core.pathGet(property, ["enum"]);
        if (enumValues) {
            var required = true;
            var valuesScopeName = null;
            var attributes = "";
            if (enumValues) {
                var scope = config.scope;
                var data = config.data;
                if (data && scope) {
                    var fullSchema = scope[config.schemaName];
                    var model = angular.isString(data) ? scope[data] : data;
                    var paths = id.split(".");
                    var property = null;
                    angular.forEach(paths, function (path) {
                        property = Core.pathGet(model, ["properties", path]);
                        var typeName = Core.pathGet(property, ["type"]);
                        var alias = Forms.lookupDefinition(typeName, fullSchema);
                        if (alias) {
                            model = alias;
                        }
                    });
                    var values = Core.pathGet(property, ["enum"]);
                    valuesScopeName = "$values_" + id.replace(/\./g, "_");
                    scope[valuesScopeName] = values;
                }
            }
            if (valuesScopeName) {
                attributes += ' ng-options="value for value in ' + valuesScopeName + '"';
            }
            var defaultOption = required ? "" : '<option value=""></option>';
            return '<select' + attributes + '>' + defaultOption + '</select>';
        }
        if (angular.isArray(type)) {
            return null;
        }
        if (!angular.isString(type)) {
            return null;
        }
        var defaultValueConverter = null;
        var defaultValue = property.default;
        if (defaultValue) {
            defaultValueConverter = function (scope, modelName) {
                var value = Core.pathGet(scope, modelName);
                if (!value) {
                    Core.pathSet(scope, modelName, property.default);
                }
            };
            options.valueConverter = defaultValueConverter;
        }
        function getModelValueOrDefault(scope, modelName) {
            var value = Core.pathGet(scope, modelName);
            if (!value) {
                var defaultValue = property.default;
                if (defaultValue) {
                    value = defaultValue;
                    Core.pathSet(scope, modelName, value);
                }
            }
            return value;
        }
        switch (type.toLowerCase()) {
            case "int":
            case "integer":
            case "long":
            case "short":
            case "java.lang.integer":
            case "java.lang.long":
            case "float":
            case "double":
            case "java.lang.float":
            case "java.lang.double":
                options.valueConverter = function (scope, modelName) {
                    var value = getModelValueOrDefault(scope, modelName);
                    if (value && angular.isString(value)) {
                        var numberValue = Number(value);
                        Core.pathSet(scope, modelName, numberValue);
                    }
                };
                return '<input type="number"/>';
            case "array":
            case "java.lang.array":
            case "java.lang.iterable":
            case "java.util.list":
            case "java.util.collection":
            case "java.util.iterator":
            case "java.util.set":
            case "object[]":
                return null;
            case "boolean":
            case "bool":
            case "java.lang.boolean":
                options.valueConverter = function (scope, modelName) {
                    var value = getModelValueOrDefault(scope, modelName);
                    if (value && "true" === value) {
                        Core.pathSet(scope, modelName, true);
                    }
                };
                return '<input type="checkbox"/>';
            case "password":
                return '<input type="password"/>';
            case "hidden":
                return '<input type="hidden"/>';
            case "map":
                return null;
            default:
                return '<input type="text"/>';
        }
    }
    Forms.createStandardWidgetMarkup = createStandardWidgetMarkup;
    function mapType(type) {
        switch (type.toLowerCase()) {
            case "int":
            case "integer":
            case "long":
            case "short":
            case "java.lang.integer":
            case "java.lang.long":
            case "float":
            case "double":
            case "java.lang.float":
            case "java.lang.double":
                return "number";
            case "array":
            case "java.lang.array":
            case "java.lang.iterable":
            case "java.util.list":
            case "java.util.collection":
            case "java.util.iterator":
            case "java.util.set":
            case "object[]":
                return "text";
            case "boolean":
            case "bool":
            case "java.lang.boolean":
                return "checkbox";
            case "password":
                return "password";
            case "hidden":
                return "hidden";
            default:
                return "text";
        }
    }
    Forms.mapType = mapType;
    function normalize(type, property, schema) {
        type = Forms.resolveTypeNameAlias(type, schema);
        if (!type) {
            return "hawtio-form-text";
        }
        var custom = Core.pathGet(property, ["formTemplate"]);
        if (custom) {
            return "hawtio-form-custom";
        }
        var enumValues = Core.pathGet(property, ["enum"]);
        if (enumValues) {
            return "hawtio-form-select";
        }
        if (angular.isArray(type)) {
            return null;
        }
        if (!angular.isString(type)) {
            try {
                console.log("Unsupported JSON schema type value " + JSON.stringify(type));
            }
            catch (e) {
                console.log("Unsupported JSON schema type value " + type);
            }
            return null;
        }
        switch (type.toLowerCase()) {
            case "int":
            case "integer":
            case "long":
            case "short":
            case "java.lang.integer":
            case "java.lang.long":
            case "float":
            case "double":
            case "java.lang.float":
            case "java.lang.double":
                return "hawtio-form-number";
            case "array":
            case "java.lang.array":
            case "java.lang.iterable":
            case "java.util.list":
            case "java.util.collection":
            case "java.util.iterator":
            case "java.util.set":
            case "object[]":
                var items = property.items;
                if (items) {
                    var typeName = items.type;
                    if (typeName && typeName === "string") {
                        return "hawtio-form-string-array";
                    }
                }
                else {
                    return "hawtio-form-string-array";
                }
                Forms.log.debug("Returning hawtio-form-array for : ", property);
                return "hawtio-form-array";
            case "boolean":
            case "bool":
            case "java.lang.boolean":
                return "hawtio-form-checkbox";
            case "password":
                return "hawtio-form-password";
            case "hidden":
                return "hawtio-form-hidden";
            case "map":
                return "hawtio-form-map";
            default:
                return "hawtio-form-text";
        }
    }
    Forms.normalize = normalize;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var SimpleFormConfig = (function () {
        function SimpleFormConfig() {
            this.name = 'form';
            this.method = 'post';
            this.entity = 'entity';
            this.schemaName = 'schema';
            this.mode = 'edit';
            this.data = {};
            this.json = undefined;
            this.scope = null;
            this.scopeName = null;
            this.properties = [];
            this.action = '';
            this.formclass = 'hawtio-form form-horizontal no-bottom-margin';
            this.controlgroupclass = 'control-group';
            this.controlclass = 'controls';
            this.labelclass = 'control-label';
            this.showtypes = 'false';
            this.onsubmit = 'onSubmit';
        }
        SimpleFormConfig.prototype.getMode = function () {
            return this.mode || "edit";
        };
        SimpleFormConfig.prototype.getEntity = function () {
            return this.entity || "entity";
        };
        SimpleFormConfig.prototype.isReadOnly = function () {
            return this.getMode() === "view";
        };
        return SimpleFormConfig;
    })();
    Forms.SimpleFormConfig = SimpleFormConfig;
    var SimpleForm = (function () {
        function SimpleForm(workspace, $compile) {
            var _this = this;
            this.workspace = workspace;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = true;
            this.replace = true;
            this.transclude = true;
            this.attributeName = 'simpleForm';
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        SimpleForm.prototype.isReadOnly = function () {
            return false;
        };
        SimpleForm.prototype.doLink = function (scope, element, attrs) {
            var config = new SimpleFormConfig;
            var fullSchemaName = attrs["schema"];
            var fullSchema = fullSchemaName ? scope[fullSchemaName] : null;
            var compiledNode = null;
            var childScope = null;
            var tabs = null;
            var fieldset = null;
            var schema = null;
            var configScopeName = attrs[this.attributeName] || attrs["data"];
            var firstControl = null;
            var simple = this;
            scope.$watch(configScopeName, onWidgetDataChange);
            function onWidgetDataChange(scopeData) {
                if (scopeData) {
                    onScopeData(scopeData);
                }
            }
            function onScopeData(scopeData) {
                config = Forms.configure(config, scopeData, attrs);
                config.schemaName = fullSchemaName;
                config.scopeName = configScopeName;
                config.scope = scope;
                var entityName = config.getEntity();
                if (angular.isDefined(config.json)) {
                    config.data = $.parseJSON(config.json);
                }
                else {
                    config.data = scopeData;
                }
                var form = simple.createForm(config);
                fieldset = form.find('fieldset');
                schema = config.data;
                tabs = {
                    elements: {},
                    locations: {},
                    use: false
                };
                if (schema && angular.isDefined(schema.tabs)) {
                    tabs.use = true;
                    tabs['div'] = $('<div class="tabbable hawtio-form-tabs"></div>');
                    angular.forEach(schema.tabs, function (value, key) {
                        tabs.elements[key] = $('<div class="tab-pane" title="' + key + '"></div>');
                        tabs['div'].append(tabs.elements[key]);
                        value.forEach(function (val) {
                            tabs.locations[val] = key;
                        });
                    });
                    if (!tabs.locations['*']) {
                        tabs.locations['*'] = Object.extended(schema.tabs).keys()[0];
                    }
                }
                if (!tabs.use) {
                    fieldset.append('<div class="spacer"></div>');
                }
                if (schema) {
                    if (tabs.use) {
                        var tabKeyToIdPropObject = {};
                        angular.forEach(schema.properties, function (property, id) {
                            var tabkey = findTabOrderValue(id);
                            var array = tabKeyToIdPropObject[tabkey];
                            if (!array) {
                                array = [];
                                tabKeyToIdPropObject[tabkey] = array;
                            }
                            array.push({ id: id, property: property });
                        });
                        angular.forEach(schema.tabs, function (value, key) {
                            value.forEach(function (val) {
                                var array = tabKeyToIdPropObject[val];
                                if (array) {
                                    angular.forEach(array, function (obj) {
                                        var id = obj.id;
                                        var property = obj.property;
                                        if (id && property) {
                                            addProperty(id, property);
                                        }
                                    });
                                }
                            });
                        });
                    }
                    else {
                        angular.forEach(schema.properties, function (property, id) {
                            addProperty(id, property);
                        });
                    }
                }
                if (tabs.use) {
                    var tabDiv = tabs['div'];
                    var tabCount = Object.keys(tabs.elements).length;
                    if (tabCount < 2) {
                        angular.forEach(tabDiv.children().children(), function (control) {
                            fieldset.append(control);
                        });
                    }
                    else {
                        fieldset.append(tabDiv);
                    }
                }
                var findFunction = function (scope, func) {
                    if (angular.isDefined(scope[func]) && angular.isFunction(scope[func])) {
                        return scope;
                    }
                    if (angular.isDefined(scope.$parent) && scope.$parent !== null) {
                        return findFunction(scope.$parent, func);
                    }
                    else {
                        return null;
                    }
                };
                var onSubmitFunc = config.onsubmit.replace('(', '').replace(')', '');
                var onSubmit = maybeGet(findFunction(scope, onSubmitFunc), onSubmitFunc);
                if (onSubmit === null) {
                    onSubmit = function (json, form) {
                        Forms.log.info("No submit handler defined for form:", form.get(0).name);
                    };
                }
                if (angular.isDefined(onSubmit)) {
                    form.submit(function () {
                        Forms.log.debug("child scope: ", childScope);
                        Forms.log.debug("form name: ", config);
                        if (childScope[config.name].$invalid) {
                            return false;
                        }
                        var entity = scope[entityName];
                        onSubmit(entity, form);
                        return false;
                    });
                }
                fieldset.append('<input type="submit" style="position: absolute; left: -9999px; width: 1px; height: 1px;">');
                var autoFocus = form.find("*[autofocus]");
                if (!autoFocus || !autoFocus.length) {
                    if (firstControl) {
                        console.log("No autofocus element, so lets add one!");
                        var input = firstControl.find("input").first() || firstControl.find("select").first();
                        if (input) {
                            input.attr("autofocus", "true");
                        }
                    }
                }
                if (compiledNode) {
                    $(compiledNode).remove();
                }
                if (childScope) {
                    childScope.$destroy();
                }
                childScope = scope.$new(false);
                compiledNode = simple.$compile(form)(childScope);
                var formsScopeProperty = "forms";
                var forms = scope[formsScopeProperty];
                if (!forms) {
                    forms = {};
                    scope[formsScopeProperty] = forms;
                }
                var formName = config.name;
                if (formName) {
                    var formObject = childScope[formName];
                    if (formObject) {
                        forms[formName] = formObject;
                    }
                    var formScope = formName += "$scope";
                    forms[formScope] = childScope;
                }
                $(element).append(compiledNode);
            }
            function findTabKey(id) {
                var tabkey = tabs.locations[id];
                if (!tabkey) {
                    angular.forEach(tabs.locations, function (value, key) {
                        if (!tabkey && key !== "*" && id.match(key)) {
                            tabkey = value;
                        }
                    });
                }
                if (!tabkey) {
                    tabkey = tabs.locations['*'];
                }
                return tabkey;
            }
            function findTabOrderValue(id) {
                var answer = null;
                angular.forEach(schema.tabs, function (value, key) {
                    value.forEach(function (val) {
                        if (!answer && val !== "*" && id.match(val)) {
                            answer = val;
                        }
                    });
                });
                if (!answer) {
                    answer = '*';
                }
                return answer;
            }
            function addProperty(id, property, ignorePrefixInLabel) {
                if (ignorePrefixInLabel === void 0) { ignorePrefixInLabel = property.ignorePrefixInLabel; }
                var propTypeName = property.type;
                if ("java.lang.String" === propTypeName) {
                    propTypeName = "string";
                }
                var propSchema = Forms.lookupDefinition(propTypeName, schema);
                if (!propSchema) {
                    propSchema = Forms.lookupDefinition(propTypeName, fullSchema);
                }
                var disableHumanizeLabel = schema ? schema.disableHumanizeLabel : false;
                if (property.hidden) {
                    return;
                }
                var nestedProperties = null;
                if (!propSchema && "object" === propTypeName && property.properties) {
                    nestedProperties = property.properties;
                }
                else if (propSchema && Forms.isObjectType(propSchema)) {
                    nestedProperties = propSchema.properties;
                }
                if (nestedProperties) {
                    angular.forEach(nestedProperties, function (childProp, childId) {
                        var newId = id + "." + childId;
                        addProperty(newId, childProp, property.ignorePrefixInLabel);
                    });
                }
                else {
                    var wrapInGroup = true;
                    var input = Forms.createWidget(propTypeName, property, schema, config, id, ignorePrefixInLabel, configScopeName, wrapInGroup, disableHumanizeLabel);
                    if (tabs.use) {
                        var tabkey = findTabKey(id);
                        tabs.elements[tabkey].append(input);
                    }
                    else {
                        fieldset.append(input);
                    }
                    if (!firstControl) {
                        firstControl = input;
                    }
                }
            }
            function maybeGet(scope, func) {
                if (scope !== null) {
                    return scope[func];
                }
                return null;
            }
        };
        SimpleForm.prototype.createForm = function (config) {
            var form = $('<form class="' + config.formclass + '" novalidate><fieldset></fieldset></form>');
            form.attr('name', config.name);
            form.attr('action', config.action);
            form.attr('method', config.method);
            form.find('fieldset').append(this.getLegend(config));
            return form;
        };
        SimpleForm.prototype.getLegend = function (config) {
            var description = Core.pathGet(config, "data.description");
            if (description) {
                return '<legend>' + description + '</legend>';
            }
            return '';
        };
        return SimpleForm;
    })();
    Forms.SimpleForm = SimpleForm;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var InputTableConfig = (function () {
        function InputTableConfig() {
            this.name = 'form';
            this.method = 'post';
            this.entity = 'entity';
            this.tableConfig = 'tableConfig';
            this.mode = 'edit';
            this.data = {};
            this.json = undefined;
            this.properties = [];
            this.action = '';
            this.tableclass = 'table table-striped inputTable';
            this.controlgroupclass = 'control-group';
            this.controlclass = 'controls pull-right';
            this.labelclass = 'control-label';
            this.showtypes = 'true';
            this.removeicon = 'icon-remove';
            this.editicon = 'icon-edit';
            this.addicon = 'icon-plus';
            this.removetext = 'Remove';
            this.edittext = 'Edit';
            this.addtext = 'Add';
            this.onadd = 'onadd';
            this.onedit = 'onedit';
            this.onremove = 'onRemove';
            this.primaryKeyProperty = undefined;
        }
        InputTableConfig.prototype.getTableConfig = function () {
            return this.tableConfig || "tableConfig";
        };
        return InputTableConfig;
    })();
    Forms.InputTableConfig = InputTableConfig;
    var InputTable = (function () {
        function InputTable(workspace, $compile) {
            var _this = this;
            this.workspace = workspace;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = true;
            this.replace = true;
            this.transclude = true;
            this.attributeName = 'hawtioInputTable';
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        InputTable.prototype.doLink = function (scope, element, attrs) {
            var _this = this;
            var config = new InputTableConfig;
            var configName = attrs[this.attributeName];
            var tableConfig = Core.pathGet(scope, configName);
            config = Forms.configure(config, tableConfig, attrs);
            var entityName = attrs["entity"] || config.data || "entity";
            var propertyName = attrs["property"] || "arrayData";
            var entityPath = entityName + "." + propertyName;
            var primaryKeyProperty = config.primaryKeyProperty;
            var tableName = config["title"] || entityName;
            if (angular.isDefined(config.json)) {
                config.data = $.parseJSON(config.json);
            }
            else {
                config.data = scope[config.data];
            }
            var div = $("<div></div>");
            var tableConfig = Core.pathGet(scope, configName);
            if (!tableConfig) {
                console.log("No table configuration for table " + tableName);
            }
            else {
                tableConfig["selectedItems"] = [];
                scope.config = tableConfig;
            }
            var table = this.createTable(config, configName);
            var group = this.getControlGroup(config, {}, "");
            var controlDiv = this.getControlDiv(config);
            controlDiv.addClass('btn-group');
            group.append(controlDiv);
            function updateData(action) {
                var data = Core.pathGet(scope, entityPath);
                if (!data) {
                    data = [];
                }
                if (!angular.isArray(data) && data) {
                    data = [data];
                }
                data = action(data);
                Core.pathSet(scope, entityPath, data);
                scope.$emit("hawtio.datatable." + entityPath, data);
                Core.$apply(scope);
            }
            function removeSelected(data) {
                angular.forEach(scope.config.selectedItems, function (selected) {
                    var id = selected["_id"];
                    if (angular.isArray(data)) {
                        data = data.remove(function (value) { return Object.equal(value, selected); });
                        delete selected["_id"];
                        data = data.remove(function (value) { return Object.equal(value, selected); });
                    }
                    else {
                        delete selected["_id"];
                        if (id) {
                            delete data[id];
                        }
                        else {
                            var found = false;
                            angular.forEach(data, function (value, key) {
                                if (!found && (Object.equal(value, selected))) {
                                    console.log("Found row to delete! " + key);
                                    delete data[key];
                                    found = true;
                                }
                            });
                            if (!found) {
                                console.log("Could not find " + JSON.stringify(selected) + " in " + JSON.stringify(data));
                            }
                        }
                    }
                });
                return data;
            }
            var add = null;
            var edit = null;
            var remove = null;
            var addDialog = null;
            var editDialog = null;
            var readOnly = attrs["readonly"];
            if (!readOnly) {
                var property = null;
                var dataName = attrs["data"];
                var dataModel = dataName ? Core.pathGet(scope, dataName) : null;
                var schemaName = attrs["schema"] || dataName;
                var schema = schemaName ? Core.pathGet(scope, schemaName) : null;
                if (propertyName && dataModel) {
                    property = Core.pathGet(dataModel, ["properties", propertyName]);
                }
                add = this.getAddButton(config);
                scope.addDialogOptions = {
                    backdropFade: true,
                    dialogFade: true
                };
                scope.showAddDialog = false;
                scope.openAddDialog = function () {
                    scope.addEntity = {};
                    scope.addFormConfig = Forms.findArrayItemsSchema(property, schema);
                    var childDataModelName = "addFormConfig";
                    if (!addDialog) {
                        var title = "Add " + tableName;
                        addDialog = $('<div modal="showAddDialog" close="closeAddDialog()" options="addDialogOptions">\n' + '<div class="modal-header"><h4>' + title + '</h4></div>\n' + '<div class="modal-body"><div simple-form="addFormConfig" entity="addEntity" data="' + childDataModelName + '" schema="' + schemaName + '"></div></div>\n' + '<div class="modal-footer">' + '<button class="btn btn-primary add" type="button" ng-click="addAndCloseDialog()">Add</button>' + '<button class="btn btn-warning cancel" type="button" ng-click="closeAddDialog()">Cancel</button>' + '</div></div>');
                        div.append(addDialog);
                        _this.$compile(addDialog)(scope);
                    }
                    scope.showAddDialog = true;
                    Core.$apply(scope);
                };
                scope.closeAddDialog = function () {
                    scope.showAddDialog = false;
                    scope.addEntity = {};
                };
                scope.addAndCloseDialog = function () {
                    var newData = scope.addEntity;
                    Forms.log.info("About to add the new entity " + JSON.stringify(newData));
                    if (newData) {
                        updateData(function (data) {
                            if (primaryKeyProperty) {
                                data.remove(function (entity) { return entity[primaryKeyProperty] === newData[primaryKeyProperty]; });
                            }
                            data.push(newData);
                            return data;
                        });
                    }
                    scope.closeAddDialog();
                };
                edit = this.getEditButton(config);
                scope.editDialogOptions = {
                    backdropFade: true,
                    dialogFade: true
                };
                scope.showEditDialog = false;
                scope.openEditDialog = function () {
                    var selected = scope.config.selectedItems;
                    var editObject = {};
                    if (selected && selected.length) {
                        angular.copy(selected[0], editObject);
                    }
                    scope.editEntity = editObject;
                    scope.editFormConfig = Forms.findArrayItemsSchema(property, schema);
                    if (!editDialog) {
                        var title = "Edit " + tableName;
                        editDialog = $('<div modal="showEditDialog" close="closeEditDialog()" options="editDialogOptions">\n' + '<div class="modal-header"><h4>' + title + '</h4></div>\n' + '<div class="modal-body"><div simple-form="editFormConfig" entity="editEntity"></div></div>\n' + '<div class="modal-footer">' + '<button class="btn btn-primary save" type="button" ng-click="editAndCloseDialog()">Save</button>' + '<button class="btn btn-warning cancel" type="button" ng-click="closeEditDialog()">Cancel</button>' + '</div></div>');
                        div.append(editDialog);
                        _this.$compile(editDialog)(scope);
                    }
                    scope.showEditDialog = true;
                    Core.$apply(scope);
                };
                scope.closeEditDialog = function () {
                    scope.showEditDialog = false;
                    scope.editEntity = {};
                };
                scope.editAndCloseDialog = function () {
                    var newData = scope.editEntity;
                    console.log("About to edit the new entity " + JSON.stringify(newData));
                    if (newData) {
                        updateData(function (data) {
                            data = removeSelected(data);
                            data.push(newData);
                            return data;
                        });
                    }
                    scope.closeEditDialog();
                };
                remove = this.getRemoveButton(config);
            }
            var findFunction = function (scope, func) {
                if (angular.isDefined(scope[func]) && angular.isFunction(scope[func])) {
                    return scope;
                }
                if (angular.isDefined(scope.$parent) && scope.$parent !== null) {
                    return findFunction(scope.$parent, func);
                }
                else {
                    return null;
                }
            };
            function maybeGet(scope, func) {
                if (scope !== null) {
                    return scope[func];
                }
                return null;
            }
            var onRemoveFunc = config.onremove.replace('(', '').replace(')', '');
            var onEditFunc = config.onedit.replace('(', '').replace(')', '');
            var onAddFunc = config.onadd.replace('(', '').replace(')', '');
            var onRemove = maybeGet(findFunction(scope, onRemoveFunc), onRemoveFunc);
            var onEdit = maybeGet(findFunction(scope, onEditFunc), onEditFunc);
            var onAdd = maybeGet(findFunction(scope, onAddFunc), onAddFunc);
            if (onRemove === null) {
                onRemove = function () {
                    updateData(function (data) {
                        return removeSelected(data);
                    });
                };
            }
            if (onEdit === null) {
                onEdit = function () {
                    scope.openEditDialog();
                };
            }
            if (onAdd === null) {
                onAdd = function (form) {
                    scope.openAddDialog();
                };
            }
            if (add) {
                add.click(function (event) {
                    onAdd();
                    return false;
                });
                controlDiv.append(add);
            }
            if (edit) {
                edit.click(function (event) {
                    onEdit();
                    return false;
                });
                controlDiv.append(edit);
            }
            if (remove) {
                remove.click(function (event) {
                    onRemove();
                    return false;
                });
                controlDiv.append(remove);
            }
            $(div).append(group);
            $(div).append(table);
            $(element).append(div);
            this.$compile(div)(scope);
        };
        InputTable.prototype.getAddButton = function (config) {
            return $('<button type="button" class="btn add"><i class="' + config.addicon + '"></i> ' + config.addtext + '</button>');
        };
        InputTable.prototype.getEditButton = function (config) {
            return $('<button type="button" class="btn edit" ng-disabled="!config.selectedItems.length"><i class="' + config.editicon + '"></i> ' + config.edittext + '</button>');
        };
        InputTable.prototype.getRemoveButton = function (config) {
            return $('<button type="remove" class="btn remove" ng-disabled="!config.selectedItems.length"><i class="' + config.removeicon + '"></i> ' + config.removetext + '</button>');
        };
        InputTable.prototype.createTable = function (config, tableConfig) {
            var tableType = "hawtio-simple-table";
            var table = $('<table class="' + config.tableclass + '" ' + tableType + '="' + tableConfig + '"></table>');
            return table;
        };
        InputTable.prototype.getLegend = function (config) {
            var description = Core.pathGet(config, "data.description");
            if (description) {
                return '<legend>' + config.data.description + '</legend>';
            }
            return '';
        };
        InputTable.prototype.getControlGroup = function (config, arg, id) {
            var rc = $('<div class="' + config.controlgroupclass + '"></div>');
            if (angular.isDefined(arg.description)) {
                rc.attr('title', arg.description);
            }
            return rc;
        };
        InputTable.prototype.getControlDiv = function (config) {
            return $('<div class="' + config.controlclass + '"></div>');
        };
        InputTable.prototype.getHelpSpan = function (config, arg, id) {
            var rc = $('<span class="help-block"></span>');
            if (angular.isDefined(arg.type) && config.showtypes !== 'false') {
                rc.append('Type: ' + arg.type);
            }
            return rc;
        };
        return InputTable;
    })();
    Forms.InputTable = InputTable;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var InputBaseConfig = (function () {
        function InputBaseConfig() {
            this.name = 'input';
            this.type = '';
            this.description = '';
            this._default = '';
            this.scope = null;
            this.mode = 'edit';
            this.schemaName = "schema";
            this.controlgroupclass = 'control-group';
            this.controlclass = 'controls';
            this.labelclass = 'control-label';
            this.showtypes = 'false';
            this.formtemplate = null;
            this.entity = 'entity';
            this.model = undefined;
        }
        InputBaseConfig.prototype.getEntity = function () {
            return this.entity || "entity";
        };
        InputBaseConfig.prototype.getMode = function () {
            return this.mode || "edit";
        };
        InputBaseConfig.prototype.isReadOnly = function () {
            return this.getMode() === "view";
        };
        return InputBaseConfig;
    })();
    Forms.InputBaseConfig = InputBaseConfig;
    var InputBase = (function () {
        function InputBase(workspace, $compile) {
            var _this = this;
            this.workspace = workspace;
            this.$compile = $compile;
            this.restrict = 'A';
            this.scope = true;
            this.replace = false;
            this.transclude = false;
            this.attributeName = '';
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        InputBase.prototype.doLink = function (scope, element, attrs) {
            var config = new InputBaseConfig;
            config = Forms.configure(config, null, attrs);
            config.scope = scope;
            config.schemaName = attrs["schema"] || "schema";
            var id = Forms.safeIdentifier(config.name);
            var group = this.getControlGroup(config, config, id);
            var modelName = config.model;
            if (!angular.isDefined(modelName)) {
                modelName = config.getEntity() + "." + id;
            }
            var defaultLabel = id;
            if ("true" === attrs["ignorePrefixInLabel"]) {
                var idx = id.lastIndexOf('.');
                if (idx > 0) {
                    defaultLabel = id.substring(idx + 1);
                }
            }
            var disableHumanizeLabel = "true" === attrs["disableHumanizeLabel"];
            var labelText = attrs["title"] || (disableHumanizeLabel ? defaultLabel : Core.humanizeValue(defaultLabel));
            group.append(Forms.getLabel(config, config, labelText));
            var controlDiv = Forms.getControlDiv(config);
            controlDiv.append(this.getInput(config, config, id, modelName));
            controlDiv.append(Forms.getHelpSpan(config, config, id));
            group.append(controlDiv);
            $(element).append(this.$compile(group)(scope));
            if (scope && modelName) {
                scope.$watch(modelName, onModelChange);
            }
            function onModelChange(newValue) {
                scope.$emit("hawtio.form.modelChange", modelName, newValue);
            }
        };
        InputBase.prototype.getControlGroup = function (config1, config2, id) {
            return Forms.getControlGroup(config1, config2, id);
        };
        InputBase.prototype.getInput = function (config, arg, id, modelName) {
            var rc = $('<span class="form-data"></span>');
            if (modelName) {
                rc.attr('ng-model', modelName);
                rc.append('{{' + modelName + '}}');
            }
            return rc;
        };
        return InputBase;
    })();
    Forms.InputBase = InputBase;
    var TextInput = (function (_super) {
        __extends(TextInput, _super);
        function TextInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
            this.type = "text";
        }
        TextInput.prototype.getInput = function (config, arg, id, modelName) {
            if (config.isReadOnly()) {
                return _super.prototype.getInput.call(this, config, arg, id, modelName);
            }
            var rc = $('<input type="' + this.type + '">');
            rc.attr('name', id);
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            var required = config.$attr["required"];
            if (required && required !== "false") {
                rc.attr('required', 'true');
            }
            return rc;
        };
        return TextInput;
    })(InputBase);
    Forms.TextInput = TextInput;
    var HiddenText = (function (_super) {
        __extends(HiddenText, _super);
        function HiddenText(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
            this.type = "hidden";
        }
        HiddenText.prototype.getControlGroup = function (config1, config2, id) {
            var group = _super.prototype.getControlGroup.call(this, config1, config2, id);
            group.css({ 'display': 'none' });
            return group;
        };
        HiddenText.prototype.getInput = function (config, arg, id, modelName) {
            var rc = _super.prototype.getInput.call(this, config, arg, id, modelName);
            rc.attr('readonly', 'true');
            return rc;
        };
        return HiddenText;
    })(TextInput);
    Forms.HiddenText = HiddenText;
    var PasswordInput = (function (_super) {
        __extends(PasswordInput, _super);
        function PasswordInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
            this.type = "password";
        }
        return PasswordInput;
    })(TextInput);
    Forms.PasswordInput = PasswordInput;
    var CustomInput = (function (_super) {
        __extends(CustomInput, _super);
        function CustomInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        CustomInput.prototype.getInput = function (config, arg, id, modelName) {
            var template = arg.formtemplate;
            template = Core.unescapeHtml(template);
            var rc = $(template);
            if (!rc.attr("name")) {
                rc.attr('name', id);
            }
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            return rc;
        };
        return CustomInput;
    })(InputBase);
    Forms.CustomInput = CustomInput;
    var SelectInput = (function (_super) {
        __extends(SelectInput, _super);
        function SelectInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        SelectInput.prototype.getInput = function (config, arg, id, modelName) {
            if (config.isReadOnly()) {
                return _super.prototype.getInput.call(this, config, arg, id, modelName);
            }
            var required = true;
            var defaultOption = required ? "" : '<option value=""></option>';
            var rc = $('<select>' + defaultOption + '</select>');
            rc.attr('name', id);
            var scope = config.scope;
            var data = config.data;
            if (data && scope) {
                var fullSchema = scope[config.schemaName];
                var model = scope[data];
                var paths = id.split(".");
                var property = null;
                angular.forEach(paths, function (path) {
                    property = Core.pathGet(model, ["properties", path]);
                    var typeName = Core.pathGet(property, ["type"]);
                    var alias = Forms.lookupDefinition(typeName, fullSchema);
                    if (alias) {
                        model = alias;
                    }
                });
                var values = Core.pathGet(property, ["enum"]);
                scope["$selectValues"] = values;
                rc.attr("ng-options", "value for value in $selectValues");
            }
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            return rc;
        };
        return SelectInput;
    })(InputBase);
    Forms.SelectInput = SelectInput;
    var NumberInput = (function (_super) {
        __extends(NumberInput, _super);
        function NumberInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        NumberInput.prototype.getInput = function (config, arg, id, modelName) {
            if (config.isReadOnly()) {
                return _super.prototype.getInput.call(this, config, arg, id, modelName);
            }
            var rc = $('<input type="number">');
            rc.attr('name', id);
            if (angular.isDefined(arg.def)) {
                rc.attr('value', arg.def);
            }
            if (angular.isDefined(arg.minimum)) {
                rc.attr('min', arg.minimum);
            }
            if (angular.isDefined(arg.maximum)) {
                rc.attr('max', arg.maximum);
            }
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            var scope = config.scope;
            if (scope) {
                function onModelChange() {
                    var value = Core.pathGet(scope, modelName);
                    if (value && angular.isString(value)) {
                        var numberValue = Number(value);
                        Core.pathSet(scope, modelName, numberValue);
                    }
                }
                scope.$watch(modelName, onModelChange);
                onModelChange();
            }
            return rc;
        };
        return NumberInput;
    })(InputBase);
    Forms.NumberInput = NumberInput;
    var StringArrayInput = (function (_super) {
        __extends(StringArrayInput, _super);
        function StringArrayInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        StringArrayInput.prototype.getInput = function (config, arg, id, modelName) {
            var rowScopeName = "_" + id;
            var ngRepeat = rowScopeName + ' in ' + modelName;
            var readOnlyWidget = '{{' + rowScopeName + '}}';
            if (config.isReadOnly()) {
                return angular.element('<ul><li ng-repeat="' + rowScopeName + ' in ' + modelName + '">' + readOnlyWidget + '</li></ul>');
            }
            else {
                var scope = config.scope;
                var fallbackSchemaName = (arg.$attr || {})["schema"] || "schema";
                var schema = scope[config.schemaName] || scope[fallbackSchemaName] || {};
                var properties = schema.properties || {};
                var arrayProperty = properties[id] || {};
                var property = arrayProperty["items"] || {};
                var propTypeName = property.type;
                var ignorePrefixInLabel = true;
                var disableHumanizeLabel = property.disableHumanizeLabel;
                var configScopeName = null;
                var value = Core.pathGet(scope, modelName);
                if (!value) {
                    Core.pathSet(scope, modelName, []);
                }
                var methodPrefix = "_form_stringArray" + rowScopeName + "_";
                var itemKeys = methodPrefix + "keys";
                var addMethod = methodPrefix + "add";
                var removeMethod = methodPrefix + "remove";
                function updateKeys() {
                    var value = Core.pathGet(scope, modelName);
                    scope[itemKeys] = value ? Object.keys(value) : [];
                    scope.$emit("hawtio.form.modelChange", modelName, value);
                }
                updateKeys();
                scope[addMethod] = function () {
                    var value = Core.pathGet(scope, modelName) || [];
                    value.push("");
                    Core.pathSet(scope, modelName, value);
                    updateKeys();
                };
                scope[removeMethod] = function (idx) {
                    var value = Core.pathGet(scope, modelName) || [];
                    if (idx < value.length) {
                        value.splice(idx, 1);
                    }
                    Core.pathSet(scope, modelName, value);
                    updateKeys();
                };
                var itemId = modelName + "[" + rowScopeName + "]";
                var itemsConfig = {
                    model: itemId
                };
                var wrapInGroup = false;
                var widget = Forms.createWidget(propTypeName, property, schema, itemsConfig, itemId, ignorePrefixInLabel, configScopeName, wrapInGroup, disableHumanizeLabel);
                if (!widget) {
                    widget = angular.element(readOnlyWidget);
                }
                var markup = angular.element('<div class="controls" style="white-space: nowrap" ng-repeat="' + rowScopeName + ' in ' + itemKeys + '"></div>');
                markup.append(widget);
                markup.append(angular.element('<a ng-click="' + removeMethod + '(' + rowScopeName + ')" title="Remove this value"><i class="red icon-remove"></i></a>'));
                markup.after(angular.element('<a ng-click="' + addMethod + '()" title="Add a new value"><i class="icon-plus"></i></a>'));
                return markup;
            }
        };
        return StringArrayInput;
    })(InputBase);
    Forms.StringArrayInput = StringArrayInput;
    var ArrayInput = (function (_super) {
        __extends(ArrayInput, _super);
        function ArrayInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        ArrayInput.prototype.doLink = function (scope, element, attrs) {
            var config = new InputBaseConfig;
            config = Forms.configure(config, null, attrs);
            var id = config.name;
            var dataName = attrs["data"] || "";
            var entityName = attrs["entity"] || config.entity;
            var schemaName = attrs["schema"] || config.schemaName;
            function renderRow(cell, type, data) {
                if (data) {
                    var description = data["description"];
                    if (!description) {
                        angular.forEach(data, function (value, key) {
                            if (value && !description) {
                                description = value;
                            }
                        });
                    }
                    return description;
                }
                return null;
            }
            var tableConfigPaths = ["properties", id, "inputTable"];
            var tableConfig = null;
            Core.pathGet(scope, tableConfigPaths);
            if (!tableConfig) {
                var tableConfigScopeName = tableConfigPaths.join(".");
                var disableHumanizeLabel = "true" === attrs["disableHumanizeLabel"];
                var cellDescription = disableHumanizeLabel ? id : Core.humanizeValue(id);
                tableConfig = {
                    formConfig: config,
                    title: cellDescription,
                    data: config.entity + "." + id,
                    displayFooter: false,
                    showFilter: false,
                    columnDefs: [
                        {
                            field: '_id',
                            displayName: cellDescription,
                            render: renderRow
                        }
                    ]
                };
                Core.pathSet(scope, tableConfigPaths, tableConfig);
            }
            var table = $('<div hawtio-input-table="' + tableConfigScopeName + '" data="' + dataName + '" property="' + id + '" entity="' + entityName + '" schema="' + schemaName + '"></div>');
            if (config.isReadOnly()) {
                table.attr("readonly", "true");
            }
            $(element).append(this.$compile(table)(scope));
        };
        return ArrayInput;
    })(InputBase);
    Forms.ArrayInput = ArrayInput;
    var BooleanInput = (function (_super) {
        __extends(BooleanInput, _super);
        function BooleanInput(workspace, $compile) {
            _super.call(this, workspace, $compile);
            this.workspace = workspace;
            this.$compile = $compile;
        }
        BooleanInput.prototype.getInput = function (config, arg, id, modelName) {
            var rc = $('<input class="hawtio-checkbox" type="checkbox">');
            rc.attr('name', id);
            if (config.isReadOnly()) {
                rc.attr('disabled', 'true');
            }
            if (modelName) {
                rc.attr('ng-model', modelName);
            }
            if (config.isReadOnly()) {
                rc.attr('readonly', 'true');
            }
            var scope = config.scope;
            if (scope) {
                function onModelChange() {
                    var value = Core.pathGet(scope, modelName);
                    if (value && "true" === value) {
                        Core.pathSet(scope, modelName, true);
                    }
                }
                scope.$watch(modelName, onModelChange);
                onModelChange();
            }
            return rc;
        };
        return BooleanInput;
    })(InputBase);
    Forms.BooleanInput = BooleanInput;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var SubmitForm = (function () {
        function SubmitForm() {
            var _this = this;
            this.restrict = 'A';
            this.scope = true;
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        SubmitForm.prototype.doLink = function (scope, element, attrs) {
            var el = $(element);
            var target = 'form[name=' + attrs['hawtioSubmit'] + ']';
            el.click(function () {
                $(target).submit();
                return false;
            });
        };
        return SubmitForm;
    })();
    Forms.SubmitForm = SubmitForm;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var ResetForm = (function () {
        function ResetForm() {
            var _this = this;
            this.restrict = 'A';
            this.scope = true;
            this.link = function (scope, element, attrs) {
                return _this.doLink(scope, element, attrs);
            };
        }
        ResetForm.prototype.doLink = function (scope, element, attrs) {
            var el = $(element);
            var target = 'form[name=' + attrs['hawtioReset'] + ']';
            el.click(function () {
                var forms = $(target);
                for (var i = 0; i < forms.length; i++) {
                    forms[i].reset();
                }
                return false;
            });
        };
        return ResetForm;
    })();
    Forms.ResetForm = ResetForm;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    Forms.pluginName = 'hawtio-forms';
    Forms.templateUrl = 'app/forms/html/';
    Forms._module = angular.module(Forms.pluginName, ['bootstrap', 'ngResource', 'hawtioCore', 'datatable', 'ui.bootstrap', 'ui.bootstrap.dialog', 'hawtio-ui']);
    Forms._module.config(["$routeProvider", function ($routeProvider) {
        $routeProvider.when('/forms/test', { templateUrl: 'app/forms/html/test.html' }).when('/forms/testTable', { templateUrl: 'app/forms/html/testTable.html' });
    }]);
    Forms._module.directive('simpleForm', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.SimpleForm(workspace, $compile);
    }]);
    Forms._module.directive('hawtioForm', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.SimpleForm(workspace, $compile);
    }]);
    Forms._module.directive('hawtioInputTable', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.InputTable(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormText', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.TextInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormPassword', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.PasswordInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormHidden', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.HiddenText(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormNumber', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.NumberInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormSelect', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.SelectInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormArray', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.ArrayInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormStringArray', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.StringArrayInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormCheckbox', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.BooleanInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioFormCustom', ["workspace", "$compile", function (workspace, $compile) {
        return new Forms.CustomInput(workspace, $compile);
    }]);
    Forms._module.directive('hawtioSubmit', function () {
        return new Forms.SubmitForm();
    });
    Forms._module.directive('hawtioReset', function () {
        return new Forms.ResetForm();
    });
    Forms._module.run(["helpRegistry", function (helpRegistry) {
        helpRegistry.addDevDoc("forms", 'app/forms/doc/developer.md');
    }]);
    hawtioPluginLoader.addModule(Forms.pluginName);
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    function createFormElement() {
        return {
            type: undefined
        };
    }
    Forms.createFormElement = createFormElement;
    function createFormTabs() {
        return {};
    }
    Forms.createFormTabs = createFormTabs;
    function createFormConfiguration() {
        return {
            properties: {}
        };
    }
    Forms.createFormConfiguration = createFormConfiguration;
    function createFormGridConfiguration() {
        return {
            rowSchema: {},
            rows: []
        };
    }
    Forms.createFormGridConfiguration = createFormGridConfiguration;
})(Forms || (Forms = {}));
var Forms;
(function (Forms) {
    var formGrid = Forms._module.directive("hawtioFormGrid", ['$templateCache', '$interpolate', '$compile', function ($templateCache, $interpolate, $compile) {
        return {
            restrict: 'A',
            replace: true,
            scope: {
                configuration: '=hawtioFormGrid'
            },
            templateUrl: Forms.templateUrl + 'formGrid.html',
            link: function (scope, element, attrs) {
                function createColumns() {
                    return [];
                }
                function createColumnSequence() {
                    var columns = createColumns();
                    if (angular.isDefined(scope.configuration.rowSchema.columnOrder)) {
                        var order = scope.configuration.rowSchema.columnOrder;
                        order.forEach(function (column) {
                            var property = Core.pathGet(scope.configuration.rowSchema.properties, [column]);
                            Core.pathSet(property, ['key'], column);
                            columns.push(property);
                        });
                    }
                    angular.forEach(scope.configuration.rowSchema.properties, function (property, key) {
                        if (!columns.some(function (c) {
                            return c.key === key;
                        })) {
                            property.key = key;
                            columns.push(property);
                        }
                    });
                    return columns;
                }
                function newHeaderRow() {
                    var header = element.find('thead');
                    header.empty();
                    return header.append($templateCache.get('rowTemplate.html')).find('tr');
                }
                function buildTableHeader(columns) {
                    var headerRow = newHeaderRow();
                    columns.forEach(function (property) {
                        var headingName = property.label || property.key;
                        if (!scope.configuration.rowSchema.disableHumanizeLabel) {
                            headingName = headingName.titleize();
                        }
                        var headerTemplate = property.headerTemplate || $templateCache.get('headerCellTemplate.html');
                        var interpolateFunc = $interpolate(headerTemplate);
                        headerRow.append(interpolateFunc({ label: headingName }));
                    });
                    headerRow.append($templateCache.get("emptyHeaderCellTemplate.html"));
                }
                function clearBody() {
                    var body = element.find('tbody');
                    body.empty();
                    return body;
                }
                function newBodyRow() {
                    return angular.element($templateCache.get('rowTemplate.html'));
                }
                function buildTableBody(columns, parent) {
                    var rows = scope.configuration.rows;
                    rows.forEach(function (row, index) {
                        var tr = newBodyRow();
                        columns.forEach(function (property) {
                            var type = Forms.mapType(property.type);
                            if (type === "number" && "input-attributes" in property) {
                                var template = property.template || $templateCache.get('cellNumberTemplate.html');
                                var interpolateFunc = $interpolate(template);
                                tr.append(interpolateFunc({
                                    row: 'configuration.rows[' + index + ']',
                                    type: type,
                                    key: property.key,
                                    min: (property["input-attributes"].min ? property["input-attributes"].min : ""),
                                    max: (property["input-attributes"].max ? property["input-attributes"].max : "")
                                }));
                            }
                            else {
                                var template = property.template || $templateCache.get('cellTemplate.html');
                                var interpolateFunc = $interpolate(template);
                                tr.append(interpolateFunc({
                                    row: 'configuration.rows[' + index + ']',
                                    type: type,
                                    key: property.key
                                }));
                            }
                        });
                        var func = $interpolate($templateCache.get("deleteRowTemplate.html"));
                        tr.append(func({
                            index: index
                        }));
                        parent.append(tr);
                    });
                }
                scope.removeThing = function (index) {
                    scope.configuration.rows.removeAt(index);
                };
                scope.addThing = function () {
                    scope.configuration.rows.push(scope.configuration.onAdd());
                };
                scope.getHeading = function () {
                    if (Core.isBlank(scope.configuration.rowName)) {
                        return 'items'.titleize();
                    }
                    return scope.configuration.rowName.pluralize().titleize();
                };
                scope.$watch('configuration.noDataTemplate', function (newValue, oldValue) {
                    var noDataTemplate = scope.configuration.noDataTemplate || $templateCache.get('heroUnitTemplate.html');
                    element.find('.nodata').html($compile(noDataTemplate)(scope));
                });
                scope.$watch('configuration.rowSchema', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        var columns = createColumnSequence();
                        buildTableHeader(columns);
                    }
                }, true);
                scope.$watchCollection('configuration.rows', function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        var body = clearBody();
                        var columns = createColumnSequence();
                        var tmp = angular.element('<div></div>');
                        buildTableBody(columns, tmp);
                        body.append($compile(tmp.children())(scope));
                    }
                });
            }
        };
    }]);
})(Forms || (Forms = {}));
var FabricRequirements;
(function (FabricRequirements) {
    FabricRequirements.DockerConfigController = FabricRequirements.controller("DockerConfigController", ["$scope", "jolokia", "$templateCache", function ($scope, jolokia, $templateCache) {
        $scope.gridConfig = Forms.createFormGridConfiguration();
        $scope.tableTemplate = '';
        if (!$scope.requirements.dockerConfiguration) {
            $scope.requirements.dockerConfiguration = Fabric.createDockerConfiguration();
        }
        if (!$scope.requirements.dockerConfiguration.hosts) {
            $scope.requirements.dockerConfiguration.hosts = [];
        }
        $scope.$watch('requirements.dockerConfiguration.hosts', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.requirements.$dirty = true;
            }
        }, true);
        Fabric.getDtoSchema(undefined, "io.fabric8.api.DockerConfiguration", jolokia, function (dockerConfigurationSchema) {
            FabricRequirements.log.debug("Received dockerConfigurationSchema: ", dockerConfigurationSchema);
            Fabric.getDtoSchema(undefined, 'io.fabric8.api.DockerHostConfiguration', jolokia, function (dockerHostConfigurationSchema) {
                FabricRequirements.log.debug("Received dockerHostConfigurationSchema: ", dockerHostConfigurationSchema);
                ['password', 'passPhrase'].forEach(function (s) {
                    Core.pathSet(dockerHostConfigurationSchema, ['properties', s, 'type'], 'password');
                });
                ['maximumContainerCount', 'port'].forEach(function (s) {
                    Core.pathSet(dockerHostConfigurationSchema, ['properties', s, 'type'], 'integer');
                    Core.pathSet(dockerHostConfigurationSchema, ['properties', s, 'input-attributes', 'min'], '1');
                });
                $scope.gridConfig.rowSchema = dockerHostConfigurationSchema;
                $scope.gridConfig.rowName = "docker host";
                $scope.gridConfig.heading = true;
                $scope.gridConfig.noDataTemplate = $templateCache.get('noDataTemplate');
                $scope.gridConfig.rowSchema.columnOrder = ['hostName', 'port', 'username', 'password', 'privateKeyFile', 'passPhrase', 'path', 'preferredAddress', 'tags'];
                Core.pathSet($scope.gridConfig, ['rowSchema', 'properties', 'tags', 'template'], $templateCache.get('tagCell.html'));
                $scope.gridConfig.rows = $scope.requirements.dockerConfiguration.hosts;
                $scope.gridConfig.onAdd = function () {
                    var answer = Fabric.createDockerHostConfiguration();
                    answer.hostName = 'New Host';
                    return answer;
                };
                $scope.tableTemplate = $templateCache.get('tableTemplate');
                Core.$apply($scope);
            });
        });
    }]);
})(FabricRequirements || (FabricRequirements = {}));
var Health;
(function (Health) {
    Health.log = Logger.get("Health");
    Health.healthDomains = {
        "org.apache.activemq": "ActiveMQ",
        "org.apache.camel": "Camel",
        "io.fabric8": "Fabric8"
    };
    function hasHealthMBeans(workspace) {
        var beans = getHealthMBeans(workspace);
        if (beans) {
            if (angular.isArray(beans))
                return beans.length >= 1;
            return true;
        }
        return false;
    }
    Health.hasHealthMBeans = hasHealthMBeans;
    function getHealthMBeans(workspace) {
        if (workspace) {
            var healthMap = workspace.mbeanServicesToDomain["Health"] || {};
            var selection = workspace.selection;
            if (selection) {
                var domain = selection.domain;
                if (domain) {
                    var mbean = healthMap[domain];
                    if (mbean) {
                        return mbean;
                    }
                }
            }
            if (healthMap) {
                var answer = [];
                angular.forEach(healthMap, function (value) {
                    if (angular.isArray(value)) {
                        answer = answer.concat(value);
                    }
                    else {
                        answer.push(value);
                    }
                });
                return answer;
            }
            else
                return null;
        }
    }
    Health.getHealthMBeans = getHealthMBeans;
    function decorate($scope) {
        $scope.levelSorting = {
            'ERROR': 0,
            'WARNING': 1,
            'INFO': 2
        };
        $scope.colorMaps = {
            'ERROR': {
                'Health': '#ff0a47',
                'Remaining': '#e92614'
            },
            'WARNING': {
                'Health': '#33cc00',
                'Remaining': '#f7ee09'
            },
            'INFO': {
                'Health': '#33cc00',
                'Remaining': '#00cc33'
            }
        };
        $scope.showKey = function (key) {
            if (key === "colorMap" || key === "data") {
                return false;
            }
            return true;
        };
        $scope.sanitize = function (value) {
            var answer = {};
            Object.extended(value).keys().forEach(function (key) {
                if ($scope.showKey(key) && value[key]) {
                    answer[key] = value[key];
                }
            });
            return answer;
        };
        $scope.getTitle = function (value) {
            if (!value) {
                return '';
            }
            if (value['healthId'].endsWith('profileHealth')) {
                return 'Profile: <strong>' + value['profile'] + '</strong>';
            }
            return 'HealthID: <strong>' + value['healthId'] + '</strong>';
        };
        $scope.generateChartData = function (value) {
            var healthPercentCurrent = 0;
            var healthPercentRemaining = 1;
            if ('healthPercent' in value) {
                var healthPercent = value['healthPercent'];
                healthPercentCurrent = healthPercent.round(3);
                healthPercentRemaining = 1 - healthPercentCurrent;
                healthPercentRemaining = healthPercentRemaining.round(3);
            }
            value.data = {
                total: 1,
                terms: [{
                    term: 'Health',
                    count: healthPercentCurrent
                }, {
                    term: 'Remaining',
                    count: healthPercentRemaining
                }]
            };
            value.colorMap = $scope.colorMaps[value.level];
        };
    }
    Health.decorate = decorate;
})(Health || (Health = {}));
var FabricRequirements;
(function (FabricRequirements) {
    FabricRequirements.ProfileRequirementsController = FabricRequirements.controller("ProfileRequirementsController", ["$scope", "jolokia", "$templateCache", function ($scope, jolokia, $templateCache) {
        Health.decorate($scope);
        $scope.hideTitle = true;
        $scope.healthTemplate = '';
        Core.registerForChanges(jolokia, $scope, {
            type: 'exec',
            mbean: Fabric.healthMBean,
            operation: 'healthList',
            arguments: []
        }, function (response) {
            $scope.fabricHealth = ObjectHelpers.toMap(response.value, 'profile', $scope.generateChartData);
            if (Core.isBlank($scope.healthTemplate)) {
                $scope.healthTemplate = $templateCache.get('healthTemplate.html');
            }
            else {
                $scope.healthTemplate = $scope.healthTemplate + ' ';
            }
            FabricRequirements.log.debug("Got health mbean list: ", $scope.fabricHealth);
            Core.$apply($scope);
        });
        $scope.profileRequirementsString = angular.toJson(($scope.requirements || {}).profileRequirements || [], true);
        $scope.remove = function (profileRequirement) {
            var oldLength = $scope.requirements.profileRequirements.length;
            $scope.requirements.profileRequirements.remove(function (r) {
                return r.profile === profileRequirement.profile;
            });
            var newLength = $scope.requirements.profileRequirements.length;
            if (oldLength > newLength) {
                $scope.requirements.$dirty = true;
            }
        };
    }]);
})(FabricRequirements || (FabricRequirements = {}));
var FabricRequirements;
(function (FabricRequirements) {
    FabricRequirements.SshConfigController = FabricRequirements.controller("SshConfigController", ["$scope", "jolokia", "$templateCache", function ($scope, jolokia, $templateCache) {
        $scope.forms = {
            sshConfig: {}
        };
        $scope.tableTemplate = '';
        if (!$scope.requirements.sshConfiguration) {
            $scope.requirements.sshConfiguration = Fabric.createSshConfiguration();
        }
        if (!$scope.requirements.sshConfiguration.hosts) {
            $scope.requirements.sshConfiguration.hosts = [];
        }
        $scope.gridConfig = Forms.createFormGridConfiguration();
        $scope.$watch("requirements.sshConfiguration.hosts", function (newValue, oldValue) {
            if (newValue !== oldValue) {
                $scope.requirements.$dirty = true;
            }
        }, true);
        $scope.$watch("forms.sshConfig.$dirty", function (newValue) {
            if (newValue) {
                $scope.requirements.$dirty = true;
            }
        });
        $scope.noop = function () {
        };
        Fabric.getDtoSchema(undefined, "io.fabric8.api.SshConfiguration", jolokia, function (sshConfigurationSchema) {
            Fabric.getDtoSchema(undefined, "io.fabric8.api.SshHostConfiguration", jolokia, function (hostConfigurationSchema) {
                ['defaultPassword', 'defaultPassPhrase'].forEach(function (s) {
                    Core.pathSet(sshConfigurationSchema, ['properties', s, 'type'], 'password');
                });
                Core.pathSet(sshConfigurationSchema, ['properties', 'defaultPort', 'type'], 'integer');
                Core.pathSet(sshConfigurationSchema, ['properties', 'defaultPort', 'input-attributes', 'min'], '1');
                ['password', 'passPhrase'].forEach(function (s) {
                    Core.pathSet(hostConfigurationSchema, ['properties', s, 'type'], 'password');
                });
                ['maximumContainerCount', 'port'].forEach(function (s) {
                    Core.pathSet(hostConfigurationSchema, ['properties', s, 'type'], 'integer');
                    Core.pathSet(hostConfigurationSchema, ['properties', s, 'input-attributes', 'min'], '1');
                });
                sshConfigurationSchema['tabs'] = {
                    'Defaults': ['defaultUsername', 'defaultPassword', 'defaultPort', 'defaultPrivateKeyFile', 'defaultPassPhrase', 'defaultPath', '*']
                };
                delete sshConfigurationSchema.properties.hosts;
                $scope.gridConfig.rowSchema = hostConfigurationSchema;
                $scope.gridConfig.rowName = "host";
                $scope.gridConfig.heading = true;
                $scope.gridConfig.noDataTemplate = $templateCache.get('noDataTemplate');
                $scope.gridConfig.rowSchema.columnOrder = ['hostName', 'port', 'username', 'password', 'privateKeyFile', 'passPhrase', 'path', 'preferredAddress', 'tags'];
                Core.pathSet($scope.gridConfig, ['rowSchema', 'properties', 'tags', 'template'], $templateCache.get('tagCell.html'));
                $scope.gridConfig.rows = $scope.requirements.sshConfiguration.hosts;
                $scope.gridConfig.onAdd = function () {
                    var answer = Fabric.createSshHostConfiguration();
                    answer.hostName = 'New Host';
                    return answer;
                };
                FabricRequirements.log.debug("gridConfig: ", $scope.gridConfig);
                $scope.formConfig = sshConfigurationSchema;
                $scope.tableTemplate = $templateCache.get('tableTemplate');
                Core.$apply($scope);
            });
        });
    }]);
})(FabricRequirements || (FabricRequirements = {}));
var Fabric;
(function (Fabric) {
    Fabric._module.controller("Fabric.ActiveProfileController", ["$scope", "jolokia", function ($scope, jolokia) {
        $scope.addToDashboardLink = function () {
            var href = "#/fabric/activeProfiles";
            var title = "Active Profiles";
            var size = angular.toJson({
                size_y: 1,
                size_x: 5
            });
            return "#/dashboard/add?tab=dashboard" + "&href=" + encodeURIComponent(href) + "&size=" + encodeURIComponent(size) + "&title=" + encodeURIComponent(title);
        };
    }]);
})(Fabric || (Fabric = {}));
var Fabric;
(function (Fabric) {
    Fabric._module.controller("Fabric.FabricApisController", ["$scope", "localStorage", "$routeParams", "$location", "jolokia", "workspace", "$compile", "$templateCache", function ($scope, localStorage, $routeParams, $location, jolokia, workspace, $compile, $templateCache) {
        $scope.path = "apis";
        Fabric.initScope($scope, $location, jolokia, workspace);
        $scope.apis = null;
        $scope.selectedApis = [];
        $scope.initDone = false;
        $scope.versionId = Fabric.getDefaultVersionId(jolokia);
        $scope.apiOptions = {
            data: 'apis',
            showFilter: false,
            showColumnMenu: false,
            filterOptions: {
                filterText: "",
                useExternalFilter: false
            },
            selectedItems: $scope.selectedApis,
            rowHeight: 32,
            showSelectionCheckbox: false,
            selectWithCheckboxOnly: true,
            columnDefs: [
                {
                    field: 'serviceName',
                    displayName: 'Service',
                    cellTemplate: '<div class="ngCellText">{{row.entity.serviceName}}</div>',
                    width: "***"
                },
                {
                    field: 'wadlHref',
                    displayName: 'APIs',
                    cellTemplate: '<div class="ngCellText">' + '<a ng-show="row.entity.apidocsHref" ng-href="{{row.entity.apidocsHref}}"><i class="icon-puzzle-piece"></i> Swagger</a> ' + '<a ng-show="row.entity.wadlHref" ng-href="{{row.entity.wadlHref}}"><i class="icon-puzzle-piece"></i> WADL</a> ' + '<a ng-show="row.entity.wsdlHref" ng-href="{{row.entity.wsdlHref}}"><i class="icon-puzzle-piece"></i> WSDL</a>' + '</div>',
                    width: "*"
                },
                {
                    field: 'container',
                    displayName: 'Container',
                    cellTemplate: '<div class="ngCellText"><span fabric-container-link="{{row.entity.container}}"/></div>',
                    width: "*"
                },
                {
                    field: 'version',
                    displayName: 'Version',
                    cellTemplate: '<div class="ngCellText">{{row.entity.version}}</div>',
                    width: "*"
                },
                {
                    field: 'endpoint',
                    displayName: 'Location',
                    cellTemplate: '<div class="ngCellText"><a target="endpoint" href="{{row.entity.endpoint}}">{{row.entity.endpoint}}</a></div>',
                    width: "***"
                }
            ]
        };
        function matchesFilter(text) {
            var filter = $scope.searchFilter;
            return !filter || (text && text.has(filter));
        }
        if (Fabric.fabricCreated(workspace)) {
            var query = { type: 'exec', mbean: Fabric.managerMBean, operation: 'clusterJson', arguments: [$scope.path] };
            scopeStoreJolokiaHandle($scope, jolokia, jolokia.register(onClusterData, query));
        }
        function addObjectNameProperties(object) {
            var objectName = object["objectName"];
            if (objectName) {
                var properties = Core.objectNameProperties(objectName);
                if (properties) {
                    angular.forEach(properties, function (value, key) {
                        if (!object[key]) {
                            object[key] = value;
                        }
                    });
                }
            }
            return null;
        }
        function createFlatList(array, json, path) {
            if (path === void 0) { path = ""; }
            angular.forEach(json, function (value, key) {
                var childPath = path + "/" + key;
                function addParameters(href) {
                    angular.forEach(["container", "objectName"], function (name) {
                        var param = value[name];
                        if (param) {
                            href += "&" + name + "=" + encodeURIComponent(param);
                        }
                    });
                    return href;
                }
                var services = value["services"];
                if (services && angular.isArray(services) && value["id"]) {
                    value["path"] = childPath;
                    if (services.length) {
                        var url = services[0];
                        value["endpoint"] = url;
                        addObjectNameProperties(value);
                        url = Core.useProxyIfExternal(url);
                        value["serviceName"] = Core.trimQuotes(value["service"]);
                        var apidocs = value["apidocs"];
                        var wadl = value["wadl"];
                        var wsdl = value["wsdl"];
                        if (apidocs) {
                            value["apidocsHref"] = addParameters("/hawtio-swagger/index.html?baseUri=" + url + apidocs);
                        }
                        if (wadl) {
                            value["wadlHref"] = addParameters("#/fabric/api/wadl?wadl=" + encodeURIComponent(url + wadl));
                        }
                        if (wsdl) {
                            value["wsdlHref"] = addParameters("#/fabric/api/wsdl?wsdl=" + encodeURIComponent(url + wsdl));
                        }
                    }
                    array.push(value);
                }
                else {
                    createFlatList(array, value, childPath);
                }
            });
        }
        function onClusterData(response) {
            $scope.initDone = true;
            var responseJson = null;
            if (response) {
                responseJson = response.value;
            }
            if ($scope.responseJson === responseJson) {
                return;
            }
            $scope.apis = [];
            $scope.responseJson = responseJson;
            try {
                var json = JSON.parse(responseJson);
                createFlatList($scope.apis, json);
                Core.$apply($scope);
            }
            catch (e) {
                console.log("Failed to parse JSON " + e);
                console.log("JSON: " + responseJson);
            }
        }
   