/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import io.fabric8.common.util.XPathBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathFacade {
    private final XPathBuilder builder;
    private final String xpathText;
    private final XPathExpression expression;

    public XPathFacade(XPathBuilder builder, String xpathText, XPathExpression expression) {
        this.builder = builder;
        this.xpathText = xpathText;
        this.expression = expression;
    }

    public String toString() {
        return "XPathFacade(" + this.xpathText + ")";
    }

    public Node node(Object item) throws XPathExpressionException {
        Object answer = this.expression.evaluate(item, XPathConstants.NODE);
        if (answer instanceof Node) {
            return (Node)answer;
        }
        return null;
    }

    public List<Node> nodes(Object item) throws XPathExpressionException {
        ArrayList<Node> answer = new ArrayList<Node>();
        Object value = this.expression.evaluate(item, XPathConstants.NODESET);
        if (value instanceof NodeList) {
            NodeList nodeList = (NodeList)value;
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodeList.item(i);
                if (node == null) continue;
                answer.add(node);
            }
        } else if (value instanceof Node) {
            answer.add((Node)value);
        }
        return answer;
    }

    public List<Element> elements(Object item) throws XPathExpressionException {
        ArrayList<Element> answer = new ArrayList<Element>();
        Object value = this.expression.evaluate(item, XPathConstants.NODESET);
        if (value instanceof NodeList) {
            NodeList nodeList = (NodeList)value;
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                answer.add((Element)node);
            }
        } else if (value instanceof Element) {
            answer.add((Element)value);
        }
        return answer;
    }

    public Element element(Object item) throws XPathExpressionException {
        Node node = this.node(item);
        if (node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    public String elementTextContent(Object item) throws XPathExpressionException {
        Element element = this.element(item);
        if (element != null) {
            return element.getTextContent();
        }
        return null;
    }

    public XPathBuilder getBuilder() {
        return this.builder;
    }

    public String getXpathText() {
        return this.xpathText;
    }

    public XPathExpression getExpression() {
        return this.expression;
    }
}

