/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffFilter;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.commit.DuplicateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateBlobFilter
extends CommitDiffFilter {
    private final Map<RevCommit, DuplicateContainer> duplicates = new LinkedHashMap<RevCommit, DuplicateContainer>();

    public DuplicateBlobFilter() {
    }

    public DuplicateBlobFilter(boolean detectRenames) {
        super(detectRenames);
    }

    @Override
    public boolean include(RevCommit commit, Collection<DiffEntry> diffs) {
        DuplicateContainer dupes = new DuplicateContainer(commit);
        block4: for (DiffEntry diff : diffs) {
            if (!this.isFileDiff(diff)) continue;
            switch (diff.getChangeType()) {
                case DELETE: {
                    continue block4;
                }
                case COPY: 
                case MODIFY: 
                case RENAME: {
                    if (diff.getOldMode() == diff.getNewMode() || !diff.getNewId().equals(diff.getOldId())) break;
                    continue block4;
                }
            }
            dupes.include(diff.getNewId().toObjectId(), diff.getNewPath());
        }
        if (dupes.validate()) {
            this.duplicates.put(commit, dupes);
        }
        return true;
    }

    public Map<RevCommit, DuplicateContainer> getDuplicates() {
        return this.duplicates;
    }

    public boolean hasDuplicates() {
        return !this.duplicates.isEmpty();
    }

    @Override
    public CommitFilter reset() {
        this.duplicates.clear();
        return super.reset();
    }

    @Override
    public RevFilter clone() {
        return new DuplicateBlobFilter(this.detectRenames);
    }
}

