/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ShowNoteCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.RepositoryUtils;
import org.gitective.core.filter.commit.CommitFilter;

public class NoteFilter
extends CommitFilter {
    private ShowNoteCommand show;
    private String[] noteRefs;

    public CommitFilter setRepository(Repository repository) {
        super.setRepository(repository);
        if (repository != null) {
            this.show = Git.wrap(repository).notesShow();
            this.noteRefs = this.getNoteRefs(repository);
        } else {
            this.show = null;
            this.noteRefs = null;
        }
        return this;
    }

    protected String[] getNoteRefs(Repository repository) {
        Collection<String> refs = RepositoryUtils.getNoteRefs(repository);
        return refs.toArray(new String[refs.size()]);
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        this.show.setObjectId(commit);
        int refLength = this.noteRefs.length;
        for (int i = 0; i < refLength; ++i) {
            if (this.show.setNotesRef(this.noteRefs[i]).call() == null) continue;
            return true;
        }
        return this.include(false);
    }

    public RevFilter clone() {
        return new NoteFilter();
    }
}

