/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.commands;

import io.fabric8.patch.FabricPatchService;
import io.fabric8.patch.Service;
import io.fabric8.patch.commands.PatchActionSupport;
import io.fabric8.patch.management.Patch;
import io.fabric8.patch.management.PatchResult;
import io.fabric8.patch.management.ProfileUpdateStrategy;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(scope="patch", name="fabric-install", description="Install a patch in fabric environment")
public class FabricInstallAction
extends PatchActionSupport {
    @Argument(name="PATCH", description="Name of the patch to install", required=true, multiValued=false)
    String patchId;
    @Option(name="-s", aliases={"--simulation"}, description="Simulates installation of the patch")
    boolean simulation = false;
    @Option(name="--merge-overwrite", description="Merge strategy: replace entire profile file with a patched one")
    boolean mergeOverwrite = false;
    @Option(name="--merge-prefer-new", description="Merge strategy: take new properties, replace existing")
    boolean mergeSelectNew = false;
    @Option(name="--merge-keep-old", description="Merge strategy: take new properties, keep existing")
    boolean mergeKeepExisting = false;
    @Option(name="--upload", description="Upload artifacts from patch to Maven repository")
    boolean upload = false;
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Option(name="-p", aliases={"--password"}, description="Remote user password", required=false, multiValued=false)
    private String password;
    @Option(name="--version", description="Version in which the patch should be installed", required=true, multiValued=false)
    private String versionId;
    private final FabricPatchService fabricPatchService;

    FabricInstallAction(Service service, FabricPatchService fabricPatchService) {
        super(service);
        this.fabricPatchService = fabricPatchService;
    }

    @Override
    protected void doExecute(Service service) throws Exception {
        Patch patch = super.getPatch(this.patchId);
        ProfileUpdateStrategy strategy = ProfileUpdateStrategy.GIT;
        if (this.mergeOverwrite && (this.mergeSelectNew || this.mergeKeepExisting) || this.mergeSelectNew && (this.mergeOverwrite || this.mergeKeepExisting) || this.mergeKeepExisting && (this.mergeOverwrite || this.mergeSelectNew)) {
            throw new UnsupportedOperationException("Please select single merge strategy");
        }
        if (this.mergeKeepExisting) {
            strategy = ProfileUpdateStrategy.PROPERTIES_PREFER_EXISTING;
        } else if (this.mergeSelectNew) {
            strategy = ProfileUpdateStrategy.PROPERTIES_PREFER_NEW;
        }
        PatchResult result = this.fabricPatchService.install(patch, this.simulation, this.versionId, this.upload, this.username, this.password, strategy);
    }
}

