/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.api.AutoScaleProfileStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AutoScaleStatus {
    private List<AutoScaleProfileStatus> profileStatuses = new ArrayList<AutoScaleProfileStatus>();

    public List<AutoScaleProfileStatus> getProfileStatuses() {
        return this.profileStatuses;
    }

    public void setProfileStatuses(List<AutoScaleProfileStatus> profileStatuses) {
        this.profileStatuses = profileStatuses;
    }

    public AutoScaleProfileStatus profileStatus(String profile) {
        AutoScaleProfileStatus requirements = this.findProfileStatus(profile);
        if (requirements == null) {
            requirements = new AutoScaleProfileStatus(profile);
            this.profileStatuses.add(requirements);
        }
        return requirements;
    }

    public AutoScaleProfileStatus findProfileStatus(String profile) {
        for (AutoScaleProfileStatus profileStatus : this.profileStatuses) {
            if (!profile.equals(profileStatus.getProfile())) continue;
            return profileStatus;
        }
        return null;
    }

    public boolean removeAutoScaleProfileStatus(String profile) {
        AutoScaleProfileStatus requirements = this.findProfileStatus(profile);
        if (requirements != null) {
            this.profileStatuses.remove(requirements);
            return true;
        }
        return false;
    }

    public void addOrUpdateAutoScaleProfileStatus(AutoScaleProfileStatus requirement) {
        this.removeAutoScaleProfileStatus(requirement.getProfile());
        this.profileStatuses.add(requirement);
        this.sortProfilesStatuses();
    }

    protected void sortProfilesStatuses() {
        Collections.sort(this.profileStatuses);
    }
}

