/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.jcip.NotThreadSafe;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@NotThreadSafe
public class CreateContainerBasicOptions<T extends CreateContainerBasicOptions>
extends CreateEnsembleOptions
implements CreateContainerOptions {
    static final long serialVersionUID = -663983552172109587L;
    @JsonProperty
    final String name;
    @JsonProperty
    final String parent;
    @JsonProperty
    final String providerType;
    @JsonProperty
    final boolean ensembleServer;
    @JsonProperty
    final String preferredAddress;
    @JsonProperty
    final Integer number;
    @JsonProperty
    final URI proxyUri;
    @JsonProperty
    final String zookeeperUrl;
    @JsonProperty
    final String jvmOpts;
    @JsonProperty
    final boolean adminAccess;
    @JsonProperty
    final Map<String, Properties> systemProperties;
    final Map<String, CreateContainerMetadata<T>> metadataMap = new HashMap<String, CreateContainerMetadata<T>>();

    protected CreateContainerBasicOptions(String bindAddress, String resolver, String globalResolver, String manualIp, int minimumPort, int maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, int getZooKeeperServerPort, int zooKeeperServerConnectionPort, String zookeeperPassword, boolean ensembleStart, boolean agentEnabled, boolean waitForProvision, long provisionTimeout, boolean autoImportEnabled, String importPath, Map<String, String> users, String name, String parent, String providerType, boolean ensembleServer, String preferredAddress, Map<String, Properties> systemProperties, Integer number, URI proxyUri, String zookeeperUrl, String jvmOpts, boolean adminAccess, boolean clean) {
        super(bindAddress, resolver, globalResolver, manualIp, minimumPort, maximumPort, profiles, version, dataStoreProperties, getZooKeeperServerPort, zooKeeperServerConnectionPort, 2000, 10, 5, "zookeeper", zookeeperPassword, ensembleStart, agentEnabled, waitForProvision, provisionTimeout, 120000L, autoImportEnabled, importPath, users, clean);
        this.name = name;
        this.parent = parent;
        this.providerType = providerType;
        this.ensembleServer = ensembleServer;
        this.preferredAddress = preferredAddress;
        this.number = number;
        this.proxyUri = proxyUri;
        this.zookeeperUrl = zookeeperUrl;
        this.jvmOpts = jvmOpts;
        this.adminAccess = adminAccess;
        this.systemProperties = systemProperties;
    }

    @Override
    public String getProviderType() {
        return this.providerType;
    }

    @Override
    public CreateContainerOptions updateCredentials(String user, String credential) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public boolean isEnsembleServer() {
        return this.ensembleServer;
    }

    @Override
    public String getPreferredAddress() {
        return this.preferredAddress;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public String getResolver() {
        return this.resolver;
    }

    @Override
    public String getManualIp() {
        return this.manualIp;
    }

    @Override
    public int getMinimumPort() {
        return this.minimumPort;
    }

    @Override
    public int getMaximumPort() {
        return this.maximumPort;
    }

    @Override
    public Map<String, Properties> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Integer getNumber() {
        return this.number;
    }

    @Override
    public URI getProxyUri() {
        return this.proxyUri;
    }

    @Override
    public String getZookeeperUrl() {
        return this.zookeeperUrl;
    }

    @Override
    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    @Override
    public String getJvmOpts() {
        return this.jvmOpts;
    }

    @Override
    public boolean isAdminAccess() {
        return this.adminAccess;
    }

    public Map<String, CreateContainerMetadata<T>> getMetadataMap() {
        return this.metadataMap;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public static class Builder<B extends Builder<?>>
    extends CreateEnsembleOptions.Builder<B> {
        @JsonProperty
        String name;
        @JsonProperty
        String parent;
        @JsonProperty
        String providerType;
        @JsonProperty
        boolean ensembleServer;
        @JsonProperty
        String preferredAddress;
        @JsonProperty
        Map<String, Properties> systemProperties = new HashMap<String, Properties>();
        @JsonProperty
        Integer number = 0;
        @JsonProperty
        URI proxyUri;
        @JsonProperty
        String zookeeperUrl;
        @JsonProperty
        String jvmOpts;
        @JsonProperty
        boolean adminAccess = true;
        @JsonIgnore
        Map<String, CreateContainerMetadata> metadataMap = new HashMap<String, CreateContainerMetadata>();

        public B preferredAddress(String preferredAddress) {
            this.preferredAddress = preferredAddress;
            return (B)this;
        }

        public B ensembleServer(boolean ensembleServer) {
            this.ensembleServer = ensembleServer;
            return (B)this;
        }

        public B number(int number) {
            this.number = number;
            return (B)this;
        }

        public B name(String name) {
            this.name = name;
            return (B)this;
        }

        public B parent(String parent) {
            this.parent = parent;
            return (B)this;
        }

        public B providerType(String providerType) {
            this.providerType = providerType;
            return (B)this;
        }

        public B zookeeperUrl(String zookeeperUrl) {
            this.zookeeperUrl = zookeeperUrl;
            return (B)this;
        }

        public B proxyUri(URI proxyUri) {
            this.proxyUri = proxyUri;
            return (B)this;
        }

        public B proxyUri(String proxyUri) throws URISyntaxException {
            this.proxyUri = new URI(proxyUri);
            return (B)this;
        }

        public B jvmOpts(String jvmOpts) {
            this.jvmOpts = jvmOpts;
            return (B)this;
        }

        public B adminAccess(boolean adminAccess) {
            this.adminAccess = adminAccess;
            return (B)this;
        }

        public String getName() {
            return this.name;
        }

        public String getParent() {
            return this.parent;
        }

        public String getProviderType() {
            return this.providerType;
        }

        public boolean isEnsembleServer() {
            return this.ensembleServer;
        }

        public String getPreferredAddress() {
            return this.preferredAddress;
        }

        public Map<String, Properties> getSystemProperties() {
            return this.systemProperties;
        }

        public Integer getNumber() {
            return this.number;
        }

        public URI getProxyUri() {
            return this.proxyUri;
        }

        public String getZookeeperUrl() {
            return this.zookeeperUrl;
        }

        public String getJvmOpts() {
            return this.jvmOpts;
        }

        public boolean isAdminAccess() {
            return this.adminAccess;
        }

        public Map<String, CreateContainerMetadata> getMetadataMap() {
            return this.metadataMap;
        }

        @Override
        public CreateContainerBasicOptions build() {
            return new CreateContainerBasicOptions(this.bindAddress, this.resolver, this.globalResolver, this.manualIp, this.minimumPort, this.maximumPort, this.profiles, this.version, this.dataStoreProperties, this.zooKeeperServerPort, this.zooKeeperServerConnectionPort, this.zookeeperPassword, this.ensembleStart, this.agentEnabled, this.waitForProvision, this.bootstrapTimeout, this.autoImportEnabled, this.importPath, this.users, this.name, this.parent, this.providerType, this.ensembleServer, this.preferredAddress, this.systemProperties, this.number, this.proxyUri, this.zookeeperUrl, this.jvmOpts, this.adminAccess, this.clean);
        }
    }
}

