/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.gravia;

import io.fabric8.api.gravia.AbstractPropertiesProvider;
import io.fabric8.api.gravia.IllegalArgumentAssertion;
import io.fabric8.api.gravia.PropertiesProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CompositePropertiesProvider
extends AbstractPropertiesProvider {
    private final List<PropertiesProvider> delegates;

    public CompositePropertiesProvider(PropertiesProvider ... delegates) {
        IllegalArgumentAssertion.assertNotNull(delegates, "delegates");
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object result = null;
        for (PropertiesProvider delegate : this.delegates) {
            result = delegate.getProperty(key);
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }

    List<PropertiesProvider> getDelegates() {
        return Collections.unmodifiableList(this.delegates);
    }
}

