/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.dosgi;

import io.fabric8.dosgi.impl.Manager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.osgi.framework.BundleContext;

public class Activator
implements ConnectionStateListener {
    private BundleContext bundleContext;
    private Manager manager;
    private String uri;
    private String exportedAddress;
    private long timeout = TimeUnit.MINUTES.toMillis(5L);
    private CuratorFramework curator;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setExportedAddress(String exportedAddress) {
        this.exportedAddress = exportedAddress;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void destroy() {
        this.destroyManager();
        this.curator = null;
    }

    protected void destroyManager() {
        if (this.manager != null) {
            Manager mgr = this.manager;
            this.manager = null;
            try {
                mgr.destroy();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        switch (newState) {
            case CONNECTED: 
            case RECONNECTED: {
                this.curator = client;
                this.onConnected();
                break;
            }
            default: {
                this.onDisconnected();
            }
        }
    }

    public void onConnected() {
        this.destroyManager();
        try {
            this.manager = new Manager(this.bundleContext, this.curator, this.uri, this.exportedAddress, this.timeout);
            this.manager.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start DOSGi service: " + e.getMessage(), e);
        }
    }

    public void onDisconnected() {
        this.destroyManager();
    }
}

