/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.internal;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Validatable;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.ValidationSupport;
import io.fabric8.zookeeper.ZkPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.zookeeper.urlhandler", label="Fabric8 ZooKeeper URL Handler", immediate=true, metatype=false)
@Service(value={URLStreamHandlerService.class})
@Properties(value={@Property(name="url.handler.protocol", value={"zk"})})
public class ZkUrlHandler
extends AbstractURLStreamHandlerService
implements Validatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkUrlHandler.class);
    private static final String SYNTAX = "zk: zk-node-path";
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private final ValidationSupport active = new ValidationSupport();

    @Activate
    void activate() {
        this.active.setValid();
    }

    @Deactivate
    void deactivate() {
        this.active.setInvalid();
    }

    public boolean isValid() {
        return this.active.isValid();
    }

    public void assertValid() {
        this.active.assertValid();
    }

    public URLConnection openConnection(URL url) throws IOException {
        this.assertValid();
        return new Connection(url);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    private class Connection
    extends URLConnection {
        public Connection(URL url) throws MalformedURLException {
            String path;
            super(url);
            if (url.getPath() == null || url.getPath().trim().length() == 0) {
                throw new MalformedURLException("Path can not be null or empty. Syntax: zk: zk-node-path");
            }
            if (url.getHost() != null && url.getHost().length() > 0 || url.getPort() != -1) {
                throw new MalformedURLException("Unsupported host/port in zookeeper url");
            }
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                throw new MalformedURLException("Unsupported query in zookeeper url");
            }
            if (url.getRef() != null && !(path = url.getPath().trim()).endsWith(".properties") && !path.endsWith(".json")) {
                throw new MalformedURLException("Fragments are only supported for '.properties' and '.json' files.");
            }
        }

        @Override
        public void connect() throws IOException {
            ZkUrlHandler.this.assertValid();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            ZkUrlHandler.this.assertValid();
            try {
                return new ByteArrayInputStream(ZkPath.loadURL((CuratorFramework)ZkUrlHandler.this.curator.get(), this.url.toString()));
            }
            catch (Exception e) {
                LOGGER.error("Error opening zookeeper url", (Throwable)e);
                throw (IOException)new IOException("Error opening zookeeper url").initCause(e);
            }
        }
    }
}

