/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.zookeeper.data.Stat;

public class TreeData
extends ChildData {
    private final Set<String> children = new HashSet<String>();
    private volatile boolean invalidated;

    public TreeData(String path, Stat stat, byte[] data) {
        super(path, stat, data);
    }

    public TreeData(String path, Stat stat, byte[] data, Collection<String> children) {
        super(path, stat, data);
        this.children.addAll(children);
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public void invalidate() {
        this.invalidated = true;
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public String toString() {
        return "TreeData{path='" + this.getPath() + '\'' + ", stat=" + this.getStat() + ", data=" + Arrays.toString(this.getData()) + ", children=" + this.getChildren() + '}';
    }
}

