/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.CamelNodeState;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ManagedGroupFactory;
import io.fabric8.groups.internal.ManagedGroupFactoryBuilder;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;

public class ClusteredSingletonLifecycleStrategy
implements LifecycleStrategy,
GroupListener<CamelNodeState>,
Callable<CuratorFramework> {
    public static Log LOG = LogFactory.getLog(ClusteredSingletonLifecycleStrategy.class);
    Group<CamelNodeState> group;
    String groupName;
    volatile CamelContext camelContext;
    final AtomicBoolean started = new AtomicBoolean();
    CuratorFramework curator;
    ManagedGroupFactory factory;

    static void info(String msg, Object ... args) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format(msg, args));
        }
    }

    CamelNodeState createState() {
        CamelNodeState state = new CamelNodeState(this.groupName);
        state.started = this.started.get();
        return state;
    }

    public void start() throws Exception {
        this.factory = ManagedGroupFactoryBuilder.create((CuratorFramework)this.curator, (ClassLoader)this.getClass().getClassLoader(), (Callable)this);
        this.group = this.factory.createGroup("/fabric/camel-clusters/" + this.groupName, CamelNodeState.class);
        this.group.update((NodeState)this.createState());
        this.group.add((GroupListener)this);
        this.group.start();
        ClusteredSingletonLifecycleStrategy.info("Camel context %s is waiting to become the master", this.groupName);
    }

    @Override
    public CuratorFramework call() throws Exception {
        String connectString = System.getProperty("zookeeper.url", "localhost:2181");
        String password = System.getProperty("zookeeper.password");
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryOneTime(1000)).connectionTimeoutMs(10000);
        if (password != null && !password.isEmpty()) {
            builder.authorization("digest", ("fabric:" + password).getBytes());
        }
        CuratorFramework client = builder.build();
        LOG.debug((Object)("Starting curator " + this.curator));
        client.start();
        return client;
    }

    public void stop() {
        try {
            this.factory.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void groupEvent(Group<CamelNodeState> group, GroupListener.GroupEvent event) {
        if (group.isMaster()) {
            if (this.started.compareAndSet(false, true)) {
                ClusteredSingletonLifecycleStrategy.info("Camel context %s is now the master, starting the context.", this.groupName);
                try {
                    this.camelContext.start();
                    group.update((NodeState)this.createState());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.started.compareAndSet(true, false)) {
            ClusteredSingletonLifecycleStrategy.info("Camel context %s is now a slave, stopping the context.", this.groupName);
            try {
                this.camelContext.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onContextStart(CamelContext camelContext) throws VetoCamelContextStartException {
        this.camelContext = camelContext;
        if (!this.started.get()) {
            throw new VetoCamelContextStartException("Do not start him! and don't rethrow", camelContext);
        }
    }

    public void onContextStop(CamelContext camelContext) {
    }

    public void onComponentAdd(String s, Component component) {
    }

    public void onComponentRemove(String s, Component component) {
    }

    public void onEndpointAdd(Endpoint endpoint) {
    }

    public void onEndpointRemove(Endpoint endpoint) {
    }

    public void onServiceAdd(CamelContext camelContext, Service service, Route route) {
    }

    public void onServiceRemove(CamelContext camelContext, Service service, Route route) {
    }

    public void onRoutesAdd(Collection<Route> routes) {
    }

    public void onRoutesRemove(Collection<Route> routes) {
    }

    public void onRouteContextCreate(RouteContext routeContext) {
    }

    public void onErrorHandlerAdd(RouteContext routeContext, Processor processor, ErrorHandlerFactory errorHandlerFactory) {
    }

    public void onErrorHandlerAdd(RouteContext routeContext, Processor processor, ErrorHandlerBuilder errorHandlerBuilder) {
    }

    public void onErrorHandlerRemove(RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory errorHandlerBuilder) {
    }

    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPoolExecutor, String s, String s1, String s2, String s3) {
    }

    public void onThreadPoolRemove(CamelContext camelContext, ThreadPoolExecutor threadPoolExecutor) {
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }
}

