/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.CamelNodeState;
import io.fabric8.camel.FabricComponent;
import io.fabric8.common.util.PublicPortMapper;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;

public class FabricPublisherEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(FabricPublisherEndpoint.class);
    private final FabricComponent component;
    private final String singletonId;
    private final String child;
    private final String consumer;
    private Group<CamelNodeState> group;
    private String joined;
    private final AtomicReference<GroupListener.GroupEvent> prevConnectionState = new AtomicReference<GroupListener.GroupEvent>(GroupListener.GroupEvent.DISCONNECTED);

    public FabricPublisherEndpoint(String uri, FabricComponent component, String singletonId, String child) throws Exception {
        super(uri, (Component)component);
        Map params;
        String consumer;
        this.component = component;
        this.singletonId = singletonId;
        String path = child;
        int idx = path.indexOf(63);
        if (idx > -1) {
            path = path.substring(0, idx);
        }
        String string = consumer = (params = URISupport.parseParameters((URI)new URI(child))) != null ? (String)params.remove("consumer") : null;
        if (consumer != null) {
            Map properties = IntrospectionSupport.extractProperties((Map)params, (String)"consumer.");
            if (properties != null && properties.size() > 0) {
                consumer = consumer + "?" + URISupport.createQueryString((Map)properties);
                for (String k : properties.keySet()) {
                    params.remove(k);
                }
            }
            child = path;
            if (params.size() > 0) {
                child = child + "?" + URISupport.createQueryString((Map)params);
            }
        } else {
            consumer = child;
        }
        LOG.info((Object)("Child: " + child));
        LOG.info((Object)("Consumer (internal address): " + consumer));
        consumer = this.toPublicAddress(consumer);
        LOG.info((Object)("Consumer (public address): " + consumer));
        this.child = child;
        this.consumer = consumer;
        this.publishOnZK();
    }

    public Producer createProducer() throws Exception {
        return this.getCamelContext().getEndpoint(this.child).createProducer();
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.getCamelContext().getEndpoint(this.child).createConsumer(processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.group.start();
    }

    public void doStop() throws Exception {
        this.group.close();
        super.doStop();
    }

    protected String toPublicAddress(String address) {
        try {
            String answer;
            String containerId = System.getProperty("karaf.name");
            if (containerId == null || containerId.trim().equals("")) {
                return address;
            }
            URI uri = new URI(address);
            StringBuilder schemes = new StringBuilder();
            while (uri.getSchemeSpecificPart().contains("://")) {
                schemes.append(uri.getScheme()).append(":");
                uri = new URI(uri.getSchemeSpecificPart());
            }
            int port = this.publicPort(uri);
            String path = uri.getPath();
            if (uri.getQuery() != null) {
                path = path + "?" + uri.getQuery();
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.trim().equals("")) {
                path = "/" + path;
            }
            if (this.getComponent().getCurator() != null) {
                String hostname = "${zk:" + containerId + "/ip}";
                answer = schemes.toString() + uri.getScheme() + "://" + hostname + ":" + port + path;
                this.getComponent().getCurator().getZookeeperClient().blockUntilConnectedOrTimedOut();
                answer = ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.getComponent().getCurator(), (String)answer);
            } else {
                answer = schemes.toString() + uri.getScheme() + "://" + uri.getHost() + ":" + port + path;
            }
            return answer;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Could not connect to Zookeeper to get public container address");
            return address;
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not map URL to a public address: " + address));
            return address;
        }
    }

    protected int publicPort(URI uri) {
        return PublicPortMapper.getPublicPort((int)uri.getPort());
    }

    public FabricComponent getComponent() {
        return this.component;
    }

    public String getChild() {
        return this.child;
    }

    public synchronized void publishOnZK() {
        String path = this.getComponent().getFabricPath(this.singletonId);
        this.group = this.getComponent().createGroup(path);
        CamelNodeState state = new CamelNodeState(this.singletonId);
        state.consumer = this.consumer;
        this.group.update((NodeState)state);
        this.group.add((GroupListener)new GroupListener<CamelNodeState>(){

            public void groupEvent(Group<CamelNodeState> group, GroupListener.GroupEvent newState) {
                LOG.info((Object)("Triggered event: " + newState));
                block0 : switch (FabricPublisherEndpoint.this.prevConnectionState.getAndSet(newState)) {
                    case DISCONNECTED: {
                        switch (newState) {
                            case CONNECTED: {
                                CamelNodeState state = new CamelNodeState(FabricPublisherEndpoint.this.singletonId);
                                state.consumer = FabricPublisherEndpoint.this.consumer;
                                group.update((NodeState)state);
                                break block0;
                            }
                            case CHANGED: 
                            case DISCONNECTED: {
                                break block0;
                            }
                        }
                        LOG.error((Object)("Unhandled Curator connection state: " + newState), (Throwable)new IllegalArgumentException("Unhandled Curator connection state."));
                        break;
                    }
                    case CONNECTED: 
                    case CHANGED: {
                        break;
                    }
                    default: {
                        LOG.error((Object)("Unhandled Curator connection state: " + newState), (Throwable)new IllegalArgumentException("Unhandled Curator connection state."));
                    }
                }
            }
        });
        this.group.start();
    }
}

