/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel;

import io.fabric8.camel.CamelNodeState;
import io.fabric8.camel.MasterComponent;
import io.fabric8.camel.MasterEndpoint;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterConsumer
extends DefaultConsumer
implements GroupListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(MasterConsumer.class);
    private final MasterEndpoint endpoint;
    private final Processor processor;
    private Consumer delegate;
    private SuspendableService delegateService;
    private final Group<CamelNodeState> singleton;

    public MasterConsumer(MasterEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
        MasterComponent component = endpoint.getComponent();
        String path = component.getFabricPath(endpoint.getSingletonId());
        this.singleton = component.createGroup(path);
        this.singleton.add((GroupListener)this);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.singleton.start();
        LOG.debug("Attempting to become master for endpoint: " + (Object)((Object)this.endpoint) + " in " + this.endpoint.getCamelContext() + " with singletonID: " + this.endpoint.getSingletonId());
        this.singleton.update((NodeState)this.createNodeState());
    }

    private CamelNodeState createNodeState() {
        CamelNodeState state = new CamelNodeState(this.endpoint.getSingletonId());
        state.consumer = this.endpoint.getChildEndpoint().getEndpointUri();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            this.stopConsumer();
        }
        finally {
            this.singleton.close();
        }
    }

    protected void stopConsumer() throws Exception {
        ServiceHelper.stopService((Object)this.delegate);
        this.delegate = null;
        this.delegateService = null;
    }

    protected void doResume() throws Exception {
        if (this.delegateService != null) {
            this.delegateService.resume();
        }
        super.doResume();
    }

    protected void doSuspend() throws Exception {
        if (this.delegateService != null) {
            this.delegateService.suspend();
        }
        super.doSuspend();
    }

    public void groupEvent(Group group, GroupListener.GroupEvent event) {
        switch (event) {
            case CONNECTED: {
                break;
            }
            case CHANGED: {
                if (!this.singleton.isConnected()) break;
                if (this.singleton.isMaster()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Master/Standby endpoint is Master for:  " + (Object)((Object)this.endpoint) + " in " + this.endpoint.getCamelContext());
                    }
                    this.onLockOwned();
                    break;
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Master/Standby endpoint is Standby for: " + (Object)((Object)this.endpoint) + " in " + this.endpoint.getCamelContext());
                break;
            }
            case DISCONNECTED: {
                try {
                    this.stopConsumer();
                    break;
                }
                catch (Exception e) {
                    LOG.error("Failed to stop master consumer for: " + (Object)((Object)this.endpoint) + ". Reason: " + e, (Throwable)e);
                }
            }
        }
    }

    protected void onLockOwned() {
        if (this.delegate == null) {
            try {
                this.delegate = this.endpoint.getChildEndpoint().createConsumer(this.processor);
                this.delegateService = null;
                if (this.delegate instanceof SuspendableService) {
                    this.delegateService = (SuspendableService)this.delegate;
                }
                CamelNodeState nodeState = this.createNodeState();
                nodeState.started = true;
                this.singleton.update((NodeState)nodeState);
                ServiceHelper.startService((Service)this.delegate);
            }
            catch (Exception e) {
                LOG.error("Failed to start master consumer for: " + (Object)((Object)this.endpoint) + ". Reason: " + e, (Throwable)e);
            }
        }
    }
}

