/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ops4j.pax.web.extender.war.internal.tracker.ReplaceableServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceableService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceableService.class);
    private final BundleContext m_context;
    private final Class<T> m_serviceClass;
    private final ReplaceableServiceListener<T> m_serviceListener;
    private final ServiceTracker<T, T> m_serviceTracker;
    private final List<ServiceReference<T>> m_boundReferences;
    private T m_service;

    public ReplaceableService(BundleContext context, Class<T> serviceClass, ReplaceableServiceListener<T> serviceListener) {
        this.m_context = context;
        this.m_serviceClass = serviceClass;
        this.m_serviceListener = serviceListener;
        this.m_serviceTracker = new ServiceTracker(context, serviceClass, (ServiceTrackerCustomizer)new Customizer());
        this.m_boundReferences = new ArrayList<ServiceReference<T>>();
    }

    public void start() {
        this.m_serviceTracker.open();
    }

    public void stop() {
        this.m_serviceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(T service) {
        if (this.m_serviceListener != null) {
            T oldService;
            ReplaceableService replaceableService = this;
            synchronized (replaceableService) {
                oldService = this.m_service;
                this.m_service = service;
            }
            this.m_serviceListener.serviceChanged(oldService, service);
        }
    }

    private class Customizer
    implements ServiceTrackerCustomizer<T, T> {
        private Customizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T addingService(ServiceReference<T> reference) {
            ServiceReference bind;
            Object service = ReplaceableService.this.m_context.getService(reference);
            List list = ReplaceableService.this.m_boundReferences;
            synchronized (list) {
                ReplaceableService.this.m_boundReferences.add(reference);
                Collections.sort(ReplaceableService.this.m_boundReferences);
                bind = (ServiceReference)ReplaceableService.this.m_boundReferences.get(0);
            }
            if (bind == reference) {
                ReplaceableService.this.bind(service);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.m_serviceTracker.getService(bind));
            }
            return service;
        }

        public void modifiedService(ServiceReference<T> reference, T service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<T> reference, T service) {
            ServiceReference bind;
            List list = ReplaceableService.this.m_boundReferences;
            synchronized (list) {
                ReplaceableService.this.m_boundReferences.remove(reference);
                bind = ReplaceableService.this.m_boundReferences.isEmpty() ? null : (ServiceReference)ReplaceableService.this.m_boundReferences.get(0);
            }
            if (bind == null) {
                ReplaceableService.this.bind(null);
            } else {
                ReplaceableService.this.bind(ReplaceableService.this.m_serviceTracker.getService(bind));
            }
            ReplaceableService.this.m_context.ungetService(reference);
        }
    }
}

