/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.conflicts;

import io.fabric8.patch.management.conflicts.Resolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class UsersPropertiesResolver
implements Resolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String resolve(File patchChange, File base, File customChange) {
        String string;
        Properties ourUsers = new Properties();
        FileInputStream fis = null;
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<String> groupsFromPatch = new LinkedHashSet<String>();
        try {
            fis = new FileInputStream(customChange);
            ourUsers.load(fis);
            Set<String> users = ourUsers.stringPropertyNames();
            List<String> patchVersion = FileUtils.readLines(patchChange);
            for (String line : patchVersion) {
                if (line != null && line.trim().startsWith("#")) {
                    sb.append(line).append("\n");
                    if (line.trim().substring(1).indexOf(61) <= 0) continue;
                    String possibleUserDefinition = line.trim().substring(1);
                    String user = possibleUserDefinition.substring(0, possibleUserDefinition.indexOf(61)).trim();
                    String groups = possibleUserDefinition.substring(possibleUserDefinition.indexOf(61) + 1).trim();
                    if (!"admin".equals(user)) continue;
                    String[] defaultPasswordAndDefaultGroups = groups.split("\\s*,\\s*");
                    String[] defaultGroups = new String[defaultPasswordAndDefaultGroups.length - 1];
                    System.arraycopy(defaultPasswordAndDefaultGroups, 1, defaultGroups, 0, defaultGroups.length);
                    groupsFromPatch.addAll(Arrays.asList(defaultGroups));
                    continue;
                }
                if (line == null || !"".equals(line.trim())) continue;
                sb.append(line).append("\n");
            }
            for (String user : users) {
                String groups = ourUsers.getProperty(user);
                if (groups != null && !"".equals(groups)) {
                    LinkedHashSet<String> ourGroups = new LinkedHashSet<String>(Arrays.asList(groups.split("\\s*,\\s*")));
                    if ("admin".equals(user)) {
                        ourGroups.addAll(groupsFromPatch);
                    }
                    String newGroups = "";
                    for (String newGroup : ourGroups) {
                        newGroups = newGroups + ", " + newGroup;
                    }
                    sb.append(user).append(" =").append("".equals(newGroups) ? "" : newGroups.substring(1)).append("\n");
                    continue;
                }
                sb.append(user).append(" =").append("\n");
            }
            string = sb.toString();
        }
        catch (IOException e) {
            try {
                System.out.printf("Problem resolving conflict between \"%s\" and \"%s\": %n" + e.getMessage(), new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            return null;
        }
        IOUtils.closeQuietly(fis);
        return string;
    }

    public String toString() {
        return "etc/users.properties resolver";
    }
}

