/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.impl;

import io.fabric8.patch.management.BackupService;
import io.fabric8.patch.management.PatchManagement;
import io.fabric8.patch.management.impl.FileBackupService;
import io.fabric8.patch.management.impl.GitPatchManagementService;
import io.fabric8.patch.management.impl.GitPatchManagementServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class Activator
implements BundleActivator {
    public static final int PATCH_MANAGEMENT_START_LEVEL = 2;
    private FrameworkStartLevel sl;
    private int activatedAt = 0;
    private GitPatchManagementService patchManagementService;
    private final Object serviceAccess = new Object();
    private Version startupVersion;
    private Version deployVersion;
    private StartLevelNotificationFrameworkListener startLevelNotificationFrameworkListener;
    private BundleContext systemContext;
    private ServiceRegistration<PatchManagement> patchManagementRegistration;
    private ServiceRegistration<BackupService> backupServiceRegistration;

    public void start(BundleContext context) throws Exception {
        this.systemContext = context.getBundle(0L).getBundleContext();
        this.patchManagementService = new GitPatchManagementServiceImpl(context);
        int targetStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
        this.sl = (FrameworkStartLevel)context.getBundle(0L).adapt(FrameworkStartLevel.class);
        this.activatedAt = this.sl.getStartLevel();
        if (!this.patchManagementService.isEnabled()) {
            System.out.println("[PATCH] Not a Fuse/AMQ installation, ignore now");
            System.out.flush();
            return;
        }
        switch (this.activatedAt) {
            case 2: {
                this.startupVersion = context.getBundle().getVersion();
                this.patchManagementService.cleanupDeployDir();
                break;
            }
            default: {
                this.deployVersion = context.getBundle().getVersion();
            }
        }
        this.patchManagementService.start();
        this.patchManagementRegistration = this.systemContext.registerService(PatchManagement.class, PatchManagement.class.cast(this.patchManagementService), null);
        this.backupServiceRegistration = this.systemContext.registerService(BackupService.class, (Object)new FileBackupService(this.systemContext), null);
        if (this.startupVersion != null) {
            this.patchManagementService.checkPendingPatches();
        }
        if (this.sl.getStartLevel() == targetStartLevel) {
            this.patchManagementService.ensurePatchManagementInitialized();
        } else {
            this.startLevelNotificationFrameworkListener = new StartLevelNotificationFrameworkListener(targetStartLevel);
            this.systemContext.addFrameworkListener((FrameworkListener)this.startLevelNotificationFrameworkListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = this.serviceAccess;
        synchronized (object) {
            this.patchManagementService.stop();
            this.patchManagementService = null;
        }
        if (this.patchManagementRegistration != null) {
            this.patchManagementRegistration.unregister();
            this.patchManagementRegistration = null;
        }
        if (this.backupServiceRegistration != null) {
            this.backupServiceRegistration.unregister();
            this.backupServiceRegistration = null;
        }
    }

    private class StartLevelNotificationFrameworkListener
    implements FrameworkListener {
        private final int targetStartLevel;
        private boolean done = false;

        public StartLevelNotificationFrameworkListener(int targetStartLevel) {
            this.targetStartLevel = targetStartLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void frameworkEvent(FrameworkEvent event) {
            if (event.getType() == 8 && !this.done && Activator.this.sl.getStartLevel() == this.targetStartLevel) {
                this.done = true;
                Object object = Activator.this.serviceAccess;
                synchronized (object) {
                    if (Activator.this.patchManagementService != null) {
                        Activator.this.patchManagementService.ensurePatchManagementInitialized();
                        Activator.this.systemContext.removeFrameworkListener((FrameworkListener)this);
                    }
                }
            }
        }
    }
}

