/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.impl;

import io.fabric8.patch.management.EnvService;
import io.fabric8.patch.management.EnvType;
import java.io.File;
import java.io.IOException;
import org.osgi.framework.BundleContext;

public class DefaultEnvService
implements EnvService {
    private final BundleContext systemContext;
    private final File karafHome;
    private final File karafBase;

    public DefaultEnvService(BundleContext systemContext, File karafHome, File karafBase) {
        this.systemContext = systemContext;
        this.karafHome = karafHome;
        this.karafBase = karafBase;
    }

    @Override
    public EnvType determineEnvironmentType() throws IOException {
        if (Boolean.getBoolean("patching.disabled")) {
            return EnvType.UNKNOWN;
        }
        File localGitRepository = new File(this.systemContext.getProperty("karaf.data"), "git/local/fabric");
        boolean isChild = this.isChild(this.systemContext);
        if (localGitRepository.isDirectory() && new File(localGitRepository, ".git").isDirectory()) {
            boolean hasMasterBranch = new File(localGitRepository, ".git/refs/heads/master").isFile();
            boolean hasRootTag = new File(localGitRepository, ".git/refs/tags/root").isFile();
            if (hasMasterBranch && hasRootTag) {
                if (isChild) {
                    return EnvType.FABRIC_CHILD;
                }
                if (new File(this.karafHome, "bin/fuse").isFile() || new File(this.karafHome, "bin/fuse.bat").isFile()) {
                    return EnvType.FABRIC_FUSE;
                }
                if (new File(this.karafHome, "bin/amq").isFile() || new File(this.karafHome, "bin/amq.bat").isFile()) {
                    return EnvType.FABRIC_AMQ;
                }
                if (new File(this.karafHome, "bin/fabric8").isFile() || new File(this.karafHome, "bin/fabric8.bat").isFile()) {
                    return EnvType.FABRIC_FABRIC8;
                }
            }
        }
        return EnvType.STANDALONE;
    }

    private boolean isChild(BundleContext systemContext) {
        String karafName = systemContext.getProperty("karaf.name");
        String karafInstances = systemContext.getProperty("karaf.instances");
        String karafHome = systemContext.getProperty("karaf.home");
        String karafBase = systemContext.getProperty("karaf.base");
        return !karafBase.equals(karafHome) && (karafInstances + "/" + karafName).equals(karafBase);
    }
}

