/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.management.io;

import io.fabric8.patch.management.ProfileUpdateStrategy;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ProfileFileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    private static final Set<String> PREFIXES_TO_REMOVE = new HashSet<String>(Arrays.asList("bundle.", "feature.", "repository.", "override."));

    public static void copyDirectory(File srcDir, File destDir, ProfileUpdateStrategy strategy) throws IOException {
        File[] srcFiles;
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath()) && (srcFiles = srcDir.listFiles()) != null && srcFiles.length > 0) {
            exclusionList = new ArrayList<String>(srcFiles.length);
            for (File srcFile : srcFiles) {
                File copiedFile = new File(destDir, srcFile.getName());
                exclusionList.add(copiedFile.getCanonicalPath());
            }
        }
        ProfileFileUtils.doCopyDirectory(srcDir, destDir, exclusionList, strategy);
    }

    private static void doCopyDirectory(File srcDir, File destDir, List<String> exclusionList, ProfileUpdateStrategy strategy) throws IOException {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            if (!srcFile.isFile() || !".skipimport".equals(srcFile.getName())) continue;
            return;
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                ProfileFileUtils.doCopyDirectory(srcFile, dstFile, exclusionList, strategy);
                continue;
            }
            ProfileFileUtils.doCopyFile(srcFile, dstFile, strategy);
        }
        destDir.setLastModified(srcDir.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doCopyFile(File srcFile, File destFile, ProfileUpdateStrategy strategy) throws IOException {
        FileInputStream is1;
        BufferedOutputStream os;
        FileInputStream fis;
        block11: {
            if (destFile.exists() && destFile.isDirectory()) {
                throw new IOException("Destination '" + destFile + "' exists but is a directory");
            }
            String ext = FilenameUtils.getExtension(srcFile.getName());
            fis = null;
            FileOutputStream fos = null;
            os = null;
            try {
                if (strategy == ProfileUpdateStrategy.GIT || !ext.equals("properties")) {
                    fis = new FileInputStream(srcFile);
                    fos = new FileOutputStream(destFile);
                    os = new BufferedOutputStream(fos);
                    IOUtils.copyLarge(fis, os);
                    break block11;
                }
                is1 = null;
                FileInputStream is2 = null;
                try {
                    Properties existing = new Properties();
                    Properties newProperties = new Properties();
                    is1 = new FileInputStream(destFile);
                    is2 = new FileInputStream(srcFile);
                    existing.load(is1);
                    newProperties.load(is2);
                    Set<String> existingProperties = existing.stringPropertyNames();
                    for (String key : existingProperties) {
                        for (String prefix : PREFIXES_TO_REMOVE) {
                            if (!key.startsWith(prefix)) continue;
                            existing.remove(key);
                        }
                    }
                    for (String key : newProperties.stringPropertyNames()) {
                        if (!existing.containsKey(key)) {
                            existing.setProperty(key, newProperties.getProperty(key));
                            continue;
                        }
                        if (strategy == ProfileUpdateStrategy.PROPERTIES_PREFER_EXISTING) continue;
                        existing.setProperty(key, newProperties.getProperty(key));
                    }
                    fos = new FileOutputStream(destFile);
                    existing.store(fos, null);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    IOUtils.closeQuietly(is1);
                    IOUtils.closeQuietly(is2);
                    throw throwable;
                }
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(is1);
                IOUtils.closeQuietly(is2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                FileInputStream is12 = new FileInputStream(srcFile);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(os);
        is1 = new FileInputStream(srcFile);
        IOUtils.closeQuietly(fis);
        if (srcFile.length() == destFile.length()) {
            destFile.setLastModified(srcFile.lastModified());
            return;
        }
        throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
    }
}

