/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.core.mxbean;

import io.fabric8.api.mxbean.ProfileManagement;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.core.mxbean.ProfileManagementImpl;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Component(policy=ConfigurationPolicy.IGNORE, immediate=true)
@Service(value={MXBeansProvider.class})
public final class MXBeansProvider
extends AbstractComponent {
    @Reference(referenceInterface=MBeanServer.class)
    private final ValidatingReference<MBeanServer> mbeanServer = new ValidatingReference();

    @Activate
    void activate() {
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.deactivateInternal();
    }

    private void activateInternal() {
        MBeanServer server = (MBeanServer)this.mbeanServer.get();
        try {
            ProfileManagementImpl profileMXBean = new ProfileManagementImpl();
            server.registerMBean(new StandardMBean(profileMXBean, ProfileManagement.class, true), new ObjectName(ProfileManagement.OBJECT_NAME));
        }
        catch (JMException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void deactivateInternal() {
        MBeanServer server = (MBeanServer)this.mbeanServer.get();
        try {
            server.unregisterMBean(new ObjectName(ProfileManagement.OBJECT_NAME));
        }
        catch (JMException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void bindMbeanServer(MBeanServer service) {
        this.mbeanServer.bind((Object)service);
    }

    void unbindMbeanServer(MBeanServer service) {
        this.mbeanServer.unbind((Object)service);
    }
}

