/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.core.mxbean;

import io.fabric8.api.Profile;
import io.fabric8.api.ProfileManager;
import io.fabric8.api.ProfileManagerLocator;
import io.fabric8.api.Version;
import io.fabric8.api.mxbean.ProfileManagement;
import io.fabric8.api.mxbean.ProfileState;
import io.fabric8.api.mxbean.VersionState;
import java.util.List;
import java.util.Map;

public final class ProfileManagementImpl
implements ProfileManagement {
    public VersionState createVersion(VersionState versionState) {
        Version version = this.getProfileManager().createVersion(versionState.toVersion());
        return new VersionState(version);
    }

    public VersionState createVersionFrom(String sourceId, String targetId, Map<String, String> attributes) {
        Version version = this.getProfileManager().createVersionFrom(sourceId, targetId, attributes);
        return new VersionState(version);
    }

    public List<String> getVersions() {
        return this.getProfileManager().getVersions();
    }

    public VersionState getVersion(String versionId) {
        Version version = this.getProfileManager().getVersion(versionId);
        return version != null ? new VersionState(version) : null;
    }

    public void deleteVersion(String versionId) {
        this.getProfileManager().deleteVersion(versionId);
    }

    public ProfileState createProfile(ProfileState profileState) {
        Profile profile = this.getProfileManager().createProfile(profileState.toProfile());
        return new ProfileState(profile);
    }

    public ProfileState getProfile(String versionId, String profileId) {
        Profile profile = this.getProfileManager().getProfile(versionId, profileId);
        return profile != null ? new ProfileState(profile) : null;
    }

    public ProfileState updateProfile(ProfileState profileState) {
        Profile profile = this.getProfileManager().updateProfile(profileState.toProfile());
        return new ProfileState(profile);
    }

    public void deleteProfile(String versionId, String profileId, boolean force) {
        this.getProfileManager().deleteProfile(versionId, profileId, force);
    }

    private ProfileManager getProfileManager() {
        return ProfileManagerLocator.getProfileManager();
    }
}

