/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.FabricException;
import io.fabric8.api.Profile;
import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.utils.DataStoreUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

final class ProfileImpl
implements Profile {
    private final String versionId;
    private final String profileId;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<String> parents = new ArrayList<String>();
    private final Map<String, byte[]> fileConfigurations = new HashMap<String, byte[]>();
    private final Map<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
    private final boolean isOverlay;
    private final String lastModified;

    ProfileImpl(String versionId, String profileId, List<String> parents, Map<String, byte[]> fileConfigs, String lastModified, boolean isOverlay) {
        this.profileId = profileId;
        this.versionId = versionId;
        this.lastModified = lastModified;
        this.isOverlay = isOverlay;
        this.parents.addAll(parents);
        for (Map.Entry<String, byte[]> entry : fileConfigs.entrySet()) {
            String fileKey = entry.getKey();
            byte[] bytes = entry.getValue();
            this.fileConfigurations.put(fileKey, bytes);
            if (!fileKey.endsWith(".properties")) continue;
            String pid = fileKey.substring(0, fileKey.indexOf(".properties"));
            this.configurations.put(pid, Collections.unmodifiableMap(DataStoreUtils.toMap(bytes)));
        }
        Map<String, String> agentConfig = this.configurations.get("io.fabric8.agent");
        if (agentConfig != null) {
            int prefixLength = "attribute.".length();
            for (Map.Entry<String, String> entry : agentConfig.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("attribute.")) continue;
                this.attributes.put(key.substring(prefixLength), entry.getValue());
            }
        }
    }

    public String getId() {
        return this.profileId;
    }

    public String getVersion() {
        return this.versionId;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public int compareTo(Profile profile) {
        return this.profileId.compareTo(profile.getId());
    }

    public List<String> getLibraries() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.LIBRARIES);
    }

    public List<String> getEndorsedLibraries() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.ENDORSED);
    }

    public List<String> getExtensionLibraries() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.EXTENSION);
    }

    public List<String> getBundles() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.BUNDLES);
    }

    public List<String> getFabs() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.FABS);
    }

    public List<String> getFeatures() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.FEATURES);
    }

    public List<String> getRepositories() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.REPOSITORIES);
    }

    public List<String> getOverrides() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.OVERRIDES);
    }

    public List<String> getOptionals() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.OPTIONALS);
    }

    public List<String> getParentIds() {
        return Collections.unmodifiableList(this.parents);
    }

    public boolean isAbstract() {
        return Boolean.parseBoolean(this.getAttributes().get("abstract"));
    }

    public boolean isLocked() {
        return Boolean.parseBoolean(this.getAttributes().get("locked"));
    }

    public boolean isHidden() {
        return Boolean.parseBoolean(this.getAttributes().get("hidden"));
    }

    public boolean isOverlay() {
        return this.isOverlay;
    }

    public Map<String, byte[]> getFileConfigurations() {
        return Collections.unmodifiableMap(this.fileConfigurations);
    }

    public Set<String> getConfigurationFileNames() {
        return Collections.unmodifiableSet(this.fileConfigurations.keySet());
    }

    public byte[] getFileConfiguration(String fileName) {
        return this.fileConfigurations.get(fileName);
    }

    public Map<String, Map<String, String>> getConfigurations() {
        return Collections.unmodifiableMap(this.configurations);
    }

    public Map<String, String> getConfiguration(String pid) {
        Map<String, String> config = this.configurations.get(pid);
        config = config != null ? config : Collections.emptyMap();
        return Collections.unmodifiableMap(config);
    }

    public String getProfileHash() {
        StringBuilder answer = new StringBuilder();
        if (this.lastModified != null) {
            answer.append(this.lastModified);
        }
        for (String bundle : this.getBundles()) {
            String name;
            byte[] data;
            if (!bundle.startsWith("blueprint:profile:") && !bundle.startsWith("spring:profile:") || (data = this.fileConfigurations.get(name = bundle.startsWith("blueprint:profile:") ? bundle.substring(18) : bundle.substring(15))) == null) continue;
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            try {
                long crc = ChecksumUtils.checksum((InputStream)is);
                answer.append(crc);
            }
            catch (IOException iOException) {}
        }
        return answer.toString();
    }

    static List<String> getContainerConfigList(Profile p, ConfigListType type) {
        try {
            Map containerProps = p.getConfiguration("io.fabric8.agent");
            ArrayList<String> rc = new ArrayList<String>();
            String prefix = (Object)((Object)type) + ".";
            for (Map.Entry e : containerProps.entrySet()) {
                if (!((String)e.getKey()).startsWith(prefix)) continue;
                rc.add((String)e.getValue());
            }
            return rc;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getIconURL() {
        String result = null;
        Set<String> fileNames = this.getConfigurationFileNames();
        for (String fileName : fileNames) {
            if (!fileName.startsWith("icon.")) continue;
            String id = this.getId();
            String version = this.getVersion();
            result = version + "/fabric/profiles/" + id + ".profile/" + fileName;
            break;
        }
        return result;
    }

    public String getIconRelativePath() {
        String result = null;
        Set<String> fileNames = this.getConfigurationFileNames();
        for (String fileName : fileNames) {
            if (!fileName.startsWith("icon.")) continue;
            return fileName;
        }
        return result;
    }

    public String getSummaryMarkdown() {
        byte[] data = this.getFileConfiguration("Summary.md");
        if (data != null) {
            return new String(data);
        }
        data = this.getFileConfiguration("ReadMe.md");
        if (data != null) {
            String readMe = new String(data).trim();
            StringTokenizer iter = new StringTokenizer(readMe, "\n");
            boolean first = true;
            while (iter.hasMoreTokens()) {
                String text = iter.nextToken();
                if (text == null) continue;
                if (ProfileImpl.skipSummaryLine(text = text.trim()) && first) {
                    first = false;
                    continue;
                }
                while (ProfileImpl.skipSummaryLine(text)) {
                    text = text.substring(1);
                }
                if ((text = text.trim()).length() <= 0) continue;
                return text;
            }
        }
        return null;
    }

    private static boolean skipSummaryLine(String line) {
        return line.startsWith("=") || line.startsWith("#");
    }

    public List<String> getTags() {
        List<String> answer = ProfileImpl.getContainerConfigList(this, ConfigListType.TAGS);
        if (answer == null || answer.size() == 0) {
            answer = new ArrayList<String>();
            String id = this.getId();
            String[] paths = id.split("-");
            if (paths != null) {
                HashSet<String> tags = new HashSet<String>();
                int last = paths.length - 1;
                for (int i = 0; i < last; ++i) {
                    tags.add(paths[i]);
                }
                answer.addAll(tags);
            }
        }
        return answer;
    }

    public int hashCode() {
        int result = this.profileId.hashCode();
        result = 31 * result + this.versionId.hashCode();
        result = 31 * result + this.parents.hashCode();
        result = 31 * result + this.configurations.hashCode();
        result = 31 * result + this.fileConfigurations.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProfileImpl)) {
            return false;
        }
        ProfileImpl other = (ProfileImpl)obj;
        if (!this.profileId.equals(other.profileId) || !this.versionId.equals(other.versionId)) {
            return false;
        }
        if (!this.parents.equals(other.parents)) {
            return false;
        }
        if (!this.configurations.equals(other.configurations)) {
            return false;
        }
        return this.fileConfigurations.equals(other.fileConfigurations);
    }

    public String toString() {
        return "Profile[ver=" + this.versionId + ",id=" + this.profileId + ",atts=" + this.getAttributes() + "]";
    }

    static enum ConfigListType {
        BUNDLES("bundle"),
        ENDORSED("endorsed"),
        EXTENSION("extension"),
        FABS("fab"),
        FEATURES("feature"),
        LIBRARIES("lib"),
        OPTIONALS("optional"),
        OVERRIDES("override"),
        REPOSITORIES("repository"),
        TAGS("tags");

        private String value;

        private ConfigListType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

