/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.env", label="Fabric8 Environment Placeholder Resolver", metatype=false)
@Service(value={PlaceholderResolver.class, EnvPlaceholderResolver.class})
@Properties(value={@Property(name="scheme", value={"env"})})
public final class EnvPlaceholderResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static final String RESOLVER_SCHEME = "env";
    public static final String ELVIS_OPERATOR = "?:";

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        if (value != null && value.length() > RESOLVER_SCHEME.length()) {
            String answer;
            String name = value.substring(RESOLVER_SCHEME.length() + 1);
            int idx = name.indexOf(ELVIS_OPERATOR);
            String defaultValue = null;
            if (idx > 0) {
                defaultValue = name.substring(idx + ELVIS_OPERATOR.length());
                name = name.substring(0, idx);
            }
            if ((answer = System.getenv(name)) == null) {
                answer = defaultValue;
            }
            return answer;
        }
        return value;
    }

    public static String resolveExpression(String expression, Map<String, String> environmentVariables, boolean preserveUnresolved) {
        String answer;
        int idx = expression.indexOf(ELVIS_OPERATOR);
        String defaultValue = null;
        String name = expression;
        if (idx > 0) {
            defaultValue = expression.substring(idx + ELVIS_OPERATOR.length());
            name = expression.substring(0, idx);
        }
        String string = answer = environmentVariables != null ? environmentVariables.get(name) : null;
        if (answer == null && (answer = System.getenv(name)) == null) {
            return preserveUnresolved ? expression : defaultValue;
        }
        return answer;
    }

    public static String removeTokens(String expression) {
        if (expression.startsWith("${") && expression.endsWith("}")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if (expression.startsWith("env:")) {
            expression = expression.substring(4);
        }
        return expression;
    }
}

