/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricException;
import io.fabric8.service.JmxTemplateSupport;
import java.io.IOException;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTemplate
extends JmxTemplateSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxTemplate.class);
    private JMXConnector connector;

    public JmxTemplate() {
    }

    public JmxTemplate(JMXConnector connector) {
        this.connector = connector;
    }

    @Override
    public <T> T execute(JmxTemplateSupport.JmxConnectorCallback<T> callback) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            T t;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            JMXConnector connector = this.getConnector();
            if (connector == null) {
                throw new IllegalStateException("JMX connector can not be created");
            }
            try {
                t = callback.doWithJmxConnector(connector);
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    LOGGER.debug("Exception when attempting to close connection " + e2 + " after getting exception: " + e, (Throwable)e2);
                }
                throw FabricException.launderThrowable((Throwable)e);
            }
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public synchronized void close() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                throw new FabricException("Failed to close connection: " + this.connector + " on " + this + ". " + e, (Throwable)e);
            }
            finally {
                this.connector = null;
            }
        }
    }

    protected synchronized JMXConnector getConnector() {
        if (this.connector == null) {
            this.connector = this.createConnector();
        }
        return this.connector;
    }

    protected JMXConnector createConnector() {
        throw new UnsupportedOperationException("No JMX connector has been configured!");
    }
}

