/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.PatchException;
import io.fabric8.api.PatchService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.utils.Base64Encoder;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchServiceImpl
implements PatchService {
    private static final String PATCH_ID = "id";
    private static final String PATCH_DESCRIPTION = "description";
    private static final String PATCH_BUNDLES = "bundle";
    private static final String PATCH_REQUIREMENTS = "requirement";
    private static final String PATCH_COUNT = "count";
    private static final String PATCH_RANGE = "range";
    private static final String MIGRATOR_BUNDLE = "migrator-bundle";
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchServiceImpl.class);
    private final ProfileService profileService;
    private final FabricService fabricService;

    public PatchServiceImpl(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPatch(Version version, URL patch, String login, String password) {
        try {
            URI uploadUri = this.fabricService.getMavenRepoUploadURI();
            ArrayList<PatchDescriptor> descriptors = new ArrayList<PatchDescriptor>();
            if (!PatchServiceImpl.isZipValid(patch.getFile())) {
                throw new PatchException("Invalid zip file: " + patch.getFile());
            }
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(patch.openStream()));
            try {
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    block28: {
                        if (!entry.isDirectory()) {
                            String entryName = entry.getName();
                            if (entryName.startsWith("repository/")) {
                                String fileName = entryName.substring("repository/".length());
                                while (fileName.startsWith("/")) {
                                    fileName = fileName.substring(1);
                                }
                                URL uploadUrl = uploadUri.resolve(fileName).toURL();
                                URLConnection con = uploadUrl.openConnection();
                                if (con instanceof HttpURLConnection) {
                                    ((HttpURLConnection)con).setRequestMethod("PUT");
                                }
                                if (login != null && password != null) {
                                    con.setRequestProperty("Authorization", "Basic " + Base64Encoder.encode(login + ":" + password));
                                }
                                con.setDoInput(true);
                                con.setDoOutput(true);
                                con.connect();
                                OutputStream os = con.getOutputStream();
                                try {
                                    try {
                                        int code;
                                        PatchServiceImpl.copy(zis, os);
                                        if (con instanceof HttpURLConnection && ((code = ((HttpURLConnection)con).getResponseCode()) < 200 || code >= 300)) {
                                            throw new IOException("Error uploading patched jars: " + ((HttpURLConnection)con).getResponseMessage());
                                        }
                                        break block28;
                                    }
                                    finally {
                                        zis.closeEntry();
                                    }
                                }
                                finally {
                                    PatchServiceImpl.close(os);
                                }
                            }
                            if (entryName.endsWith(".patch") && !entryName.contains("/")) {
                                try {
                                    Properties patchMetadata = new Properties();
                                    patchMetadata.load(zis);
                                    descriptors.add(new PatchDescriptor(patchMetadata));
                                }
                                finally {
                                    zis.closeEntry();
                                }
                            }
                        }
                    }
                    entry = zis.getNextEntry();
                }
            }
            finally {
                PatchServiceImpl.close(zis);
            }
            PatchServiceImpl.checkRequirements(version, descriptors);
            List profiles = version.getProfiles();
            for (PatchDescriptor descriptor : descriptors) {
                String profileId = "patch-" + descriptor.getId();
                Profile profile = PatchServiceImpl.getPatchProfile(version, descriptor);
                for (Profile p : profiles) {
                    if (!profileId.equals(p.getId())) continue;
                    profile = p;
                    break;
                }
                if (profile == null) {
                    String versionId = version.getId();
                    ProfileBuilder builder = ProfileBuilder.Factory.create((String)versionId, (String)profileId);
                    builder.setOverrides(descriptor.getBundles());
                    if (descriptor.migratorBundle != null) {
                        builder.setBundles(Collections.singletonList(descriptor.migratorBundle));
                    }
                    profile = this.profileService.createProfile(builder.getProfile());
                    Profile defaultProfile = version.getRequiredProfile("default");
                    LinkedList<String> parentIds = new LinkedList<String>();
                    parentIds.addAll(defaultProfile.getParentIds());
                    if (parentIds.contains(profile.getId())) continue;
                    parentIds.add(profile.getId());
                    builder = ProfileBuilder.Factory.createFrom((Profile)defaultProfile);
                    builder.setParents(parentIds);
                    this.profileService.updateProfile(builder.getProfile());
                    continue;
                }
                LOGGER.info("The patch {} has already been applied to version {}, ignoring.", (Object)descriptor.getId(), (Object)version.getId());
            }
        }
        catch (PatchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to apply patch", e);
        }
    }

    protected static void checkRequirements(Version version, PatchDescriptor descriptor) {
        for (String requirement : descriptor.getRequirements()) {
            if (PatchServiceImpl.getPatchProfile(version, requirement) != null) continue;
            throw new PatchException(String.format("Unable to install patch '%s' - required patch '%s' is missing in version %s", descriptor.getId(), requirement, version.getId()));
        }
    }

    protected static void checkRequirements(Version version, Collection<PatchDescriptor> patches) {
        for (PatchDescriptor patch : patches) {
            PatchServiceImpl.checkRequirements(version, patch);
        }
    }

    protected static Profile getPatchProfile(Version version, PatchDescriptor patch) {
        return PatchServiceImpl.getPatchProfile(version, patch.getId());
    }

    protected static Profile getPatchProfile(Version version, String patchId) {
        return version.getProfile("patch-" + patchId);
    }

    public static boolean isZipValid(String fileName) {
        boolean result = true;
        try {
            ZipFile zipFile = new ZipFile(fileName);
            zipFile.size();
        }
        catch (Exception e) {
            result = false;
            LOGGER.error("Patch zip [{}] is not valid. ", (Object)fileName, (Object)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] b = new byte[4096];
            int l = is.read(b);
            while (l >= 0) {
                os.write(b, 0, l);
                l = is.read(b);
            }
        }
        finally {
            PatchServiceImpl.close(os);
        }
    }

    static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class PatchDescriptor {
        final String id;
        final String description;
        final List<String> bundles;
        final List<String> requirements;
        final String migratorBundle;

        PatchDescriptor(Properties properties) {
            int i;
            this.id = properties.getProperty(PatchServiceImpl.PATCH_ID);
            this.description = properties.getProperty(PatchServiceImpl.PATCH_DESCRIPTION);
            this.migratorBundle = properties.getProperty(PatchServiceImpl.MIGRATOR_BUNDLE);
            this.bundles = new ArrayList<String>();
            int count = Integer.parseInt(properties.getProperty("bundle.count", "0"));
            for (i = 0; i < count; ++i) {
                String url = properties.getProperty("bundle." + Integer.toString(i));
                String range = properties.getProperty("bundle." + Integer.toString(i) + "." + PatchServiceImpl.PATCH_RANGE);
                if (range != null) {
                    url = String.format("%s;range=%s", url, range);
                }
                this.bundles.add(url);
            }
            this.requirements = new LinkedList<String>();
            count = Integer.parseInt(properties.getProperty("requirement.count", "0"));
            for (i = 0; i < count; ++i) {
                String requirement = properties.getProperty("requirement." + Integer.toString(i));
                this.requirements.add(requirement);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getBundles() {
            return this.bundles;
        }

        public List<String> getRequirements() {
            return this.requirements;
        }
    }
}

