/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.jmx.ScrComponentStatus;
import io.fabric8.api.jmx.ScrHelperMBean;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.common.util.JMXUtils;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.scrservice", label="Fabric8 SCR Service")
public class ScrService
extends AbstractComponent
implements ScrHelperMBean {
    public static Logger LOG = LoggerFactory.getLogger(ScrService.class);
    public static ObjectName OBJECT_NAME;
    @Reference(referenceInterface=org.apache.felix.scr.ScrService.class)
    private org.apache.felix.scr.ScrService scrService;
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private MBeanServer mbeanServer;

    @Activate
    void activate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.registerMBean((Object)new StandardMBean(this, ScrHelperMBean.class, true), (MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
        this.deactivateComponent();
    }

    public List<ScrComponentStatus> listComponents() {
        LinkedList<ScrComponentStatus> scrComponents = new LinkedList<ScrComponentStatus>();
        if (this.scrService != null) {
            for (org.apache.felix.scr.Component c : this.scrService.getComponents()) {
                scrComponents.add(new ScrComponentStatus(c.getName(), c.getState(), this.getStateName(c.getState())));
            }
        }
        return scrComponents;
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    private String getStateName(int state) {
        switch (state) {
            case 2: {
                return "Enabled";
            }
            case 4: {
                return "Unsatisfied";
            }
            case 8: {
                return "Activating";
            }
            case 16: {
                return "Active";
            }
            case 32: {
                return "Registered";
            }
            case 64: {
                return "Factory";
            }
            case 128: {
                return "Deactivating";
            }
            case 256: {
                return "Destroying";
            }
            case 1024: {
                return "Disabling";
            }
            case 2048: {
                return "Disposing";
            }
        }
        return "Unknown";
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:service=Scr");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    protected void bindScrService(org.apache.felix.scr.ScrService scrService) {
        this.scrService = scrService;
    }

    protected void unbindScrService(org.apache.felix.scr.ScrService scrService) {
        if (this.scrService == scrService) {
            this.scrService = null;
        }
    }
}

