/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.child;

import io.fabric8.api.AutoScaleRequest;
import io.fabric8.api.ChildScalingRequirements;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.NameValidator;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.scr.support.Strings;
import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Filters;
import io.fabric8.service.child.ChildContainerProvider;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildAutoScaler
implements ContainerAutoScaler {
    private static final transient Logger LOG = LoggerFactory.getLogger(ChildAutoScaler.class);
    private final ChildContainerProvider containerProvider;

    public ChildAutoScaler(ChildContainerProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    public int getWeight() {
        return 0;
    }

    public void createContainers(AutoScaleRequest request) throws Exception {
        int count = request.getDelta();
        String profile = request.getProfile();
        String version = request.getVersion();
        FabricService fabricService = request.getFabricService();
        CreateChildContainerOptions.Builder builder = null;
        if (fabricService != null) {
            builder = this.createAutoScaleOptions(request, fabricService);
        }
        if (builder != null) {
            HashSet<String> ignoreContainerNames = new HashSet<String>();
            for (int i = 0; i < count; ++i) {
                CreateChildContainerOptions.Builder configuredBuilder = (CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)builder.number(1)).version(version)).profiles(profile);
                Container[] containers = fabricService.getContainers();
                NameValidator nameValidator = Containers.createNameValidator((Container[])containers);
                String name = Containers.createContainerName((Container[])containers, (String)profile, (String)this.containerProvider.getScheme(), (NameValidator)nameValidator);
                ignoreContainerNames.add(name);
                CreateChildContainerOptions options = ((CreateChildContainerOptions.Builder)configuredBuilder.name(name)).build();
                LOG.info("Creating container name " + name + " version " + version + " profile " + profile + " " + count + " container(s)");
                fabricService.createContainers((CreateContainerOptions)options);
            }
        } else {
            LOG.warn("Could not create version " + version + " profile " + profile + " due to missing autoscale configuration");
        }
    }

    protected CreateChildContainerOptions.Builder createAutoScaleOptions(AutoScaleRequest request, FabricService fabricService) {
        CreateChildContainerOptions.Builder builder = CreateChildContainerOptions.builder();
        Container[] containers = fabricService.getContainers();
        if (containers != null) {
            List containerIds = Containers.rootContainerIds((Container[])containers);
            if (containerIds.isEmpty()) {
                throw new IllegalStateException("No root containers are available!");
            }
            String rootContainer = null;
            rootContainer = containerIds.size() == 1 ? (String)containerIds.get(0) : this.chooseRootContainer(request, containerIds);
            if (Strings.isNullOrBlank((String)rootContainer)) {
                throw new IllegalStateException("Could not choose a root container from the possible IDs: " + containerIds + " with requirements: " + this.getChildScalingRequirements(request));
            }
            builder = (CreateChildContainerOptions.Builder)builder.parent(rootContainer);
        }
        String zookeeperUrl = fabricService.getZookeeperUrl();
        String zookeeperPassword = fabricService.getZookeeperPassword();
        return (CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)builder.jmxUser("admin").jmxPassword(zookeeperPassword).zookeeperUrl(zookeeperUrl)).zookeeperPassword(zookeeperPassword);
    }

    protected String chooseRootContainer(AutoScaleRequest request, List<String> containerIds) {
        List rootContainerPatterns;
        ChildScalingRequirements scalingRequirements = this.getChildScalingRequirements(request);
        if (scalingRequirements != null && (rootContainerPatterns = scalingRequirements.getRootContainerPatterns()) != null && !rootContainerPatterns.isEmpty()) {
            Filter filter = Filters.createStringFilters((Iterable)rootContainerPatterns);
            List matchingRootContainers = Filters.filter(containerIds, (Filter)filter);
            return (String)Filters.matchRandomElement((List)matchingRootContainers);
        }
        return (String)Filters.matchRandomElement(containerIds);
    }

    protected ChildScalingRequirements getChildScalingRequirements(AutoScaleRequest request) {
        ChildScalingRequirements scalingRequirements = null;
        ProfileRequirements profileRequirements = request.getProfileRequirements();
        if (profileRequirements != null) {
            scalingRequirements = profileRequirements.getChildScalingRequirements();
        }
        return scalingRequirements;
    }

    public void destroyContainers(String profile, int count, List<Container> containers) {
    }
}

