/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mq.fabric.discovery;

import io.fabric8.mq.fabric.discovery.FabricDiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.curator.framework.CuratorFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiFabricDiscoveryAgent
extends FabricDiscoveryAgent
implements ServiceTrackerCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiFabricDiscoveryAgent.class);
    ServiceTracker tracker;
    BundleContext context = this.findBundleContextToUse();

    public OsgiFabricDiscoveryAgent() {
        this.tracker = new ServiceTracker(this.context, CuratorFramework.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    private BundleContext findBundleContextToUse() {
        Class[] classCtx;
        Bundle activemqBundle = FrameworkUtil.getBundle(DiscoveryAgent.class);
        for (Class aClassCtx : classCtx = new SecurityManagerEx().getClassContext()) {
            BundleContext context;
            Bundle bundle = FrameworkUtil.getBundle((Class)aClassCtx);
            if (bundle == activemqBundle) continue;
            BundleContext bundleContext = context = bundle != null ? bundle.getBundleContext() : null;
            if (context == null) continue;
            return context;
        }
        return null;
    }

    public Object addingService(ServiceReference serviceReference) {
        this.curator = (CuratorFramework)this.context.getService(serviceReference);
        return this.curator;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
    }

    public void removedService(ServiceReference serviceReference, Object o) {
    }

    @Override
    public synchronized void stop() throws Exception {
        super.stop();
        if (this.tracker != null) {
            LOG.info("closing tracker");
            this.tracker.close();
        }
    }

    static class SecurityManagerEx
    extends SecurityManager {
        SecurityManagerEx() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

