/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.download.ProfileDownloaderListener;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.common.util.Files;
import io.fabric8.maven.util.Parser;
import io.fabric8.service.VersionPropertyPointerResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileDownloader {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProfileDownloader.class);
    private final FabricService fabricService;
    private final File target;
    private final boolean force;
    private final ScheduledExecutorService executorService;
    private final Set<File> processedFiles = new HashSet<File>();
    private boolean stopOnFailure;
    private boolean downloadFilesFromProfile = true;
    private ProfileDownloaderListener listener;
    private final Map<String, Exception> errors = new HashMap<String, Exception>();

    public ProfileDownloader(FabricService fabricService, File target, boolean force, ScheduledExecutorService executorService) {
        this.fabricService = fabricService;
        this.target = target;
        this.force = force;
        this.executorService = executorService;
    }

    public ProfileDownloaderListener getListener() {
        return this.listener;
    }

    public void setListener(ProfileDownloaderListener listener) {
        this.listener = listener;
    }

    public boolean isStopOnFailure() {
        return this.stopOnFailure;
    }

    public void setStopOnFailure(boolean stopOnFailure) {
        this.stopOnFailure = stopOnFailure;
    }

    public boolean isDownloadFilesFromProfile() {
        return this.downloadFilesFromProfile;
    }

    public void setDownloadFilesFromProfile(boolean downloadFilesFromProfile) {
        this.downloadFilesFromProfile = downloadFilesFromProfile;
    }

    public void downloadVersion(Version version) throws Exception {
        List profiles = version.getProfiles();
        Profile[] prfarray = profiles.toArray(new Profile[profiles.size()]);
        if (this.listener != null) {
            this.listener.beforeDownloadProfiles(prfarray);
        }
        for (Profile profile : profiles) {
            try {
                this.downloadProfile(profile);
            }
            catch (Exception e) {
                if (this.listener != null) {
                    this.listener.onError(profile, e);
                }
                if (!this.stopOnFailure) {
                    String id = profile.getId();
                    this.errors.put(id, e);
                    LOG.error("Failed to download profile " + id + " due " + e.getMessage(), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        if (this.listener != null) {
            this.listener.afterDownloadProfiles(prfarray);
        }
    }

    public void downloadProfile(Profile profile) throws Exception {
        if (this.listener != null) {
            this.listener.beforeDownloadProfile(profile);
        }
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        if (!profile.isOverlay()) {
            profile = profileService.getOverlayProfile(profile);
        }
        DownloadManager downloadManager = DownloadManagers.createDownloadManager(this.fabricService, this.executorService);
        LinkedHashSet<String> bundles = new LinkedHashSet<String>();
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        this.addMavenBundles(this.fabricService, profile, bundles, profile.getBundles());
        this.addMavenBundles(this.fabricService, profile, bundles, profile.getFabs());
        AgentUtils.addFeatures(features, this.fabricService, downloadManager, profile);
        Map<String, File> files = AgentUtils.downloadBundles(downloadManager, features, bundles, Collections.emptySet(), !this.isDownloadFilesFromProfile());
        Set<Map.Entry<String, File>> entries = files.entrySet();
        for (Map.Entry<String, File> entry : entries) {
            File destFile;
            String name = entry.getKey();
            File file = entry.getValue();
            if (!this.processedFiles.add(file)) continue;
            String fileName = file.getName();
            String mvnCoords = ProfileDownloader.getMavenCoords(name);
            if (mvnCoords != null) {
                Parser parser = new Parser(mvnCoords);
                destFile = new File(this.target, parser.getArtifactPath());
            } else {
                destFile = new File(this.target, fileName);
            }
            if (!this.force && destFile.exists()) continue;
            LOG.info("Copying file: " + file + " to: " + destFile.getCanonicalPath());
            Files.copy(file, destFile);
            if (this.listener == null) continue;
            this.listener.onCopyDone(profile, destFile);
        }
        if (this.listener != null) {
            this.listener.afterDownloadProfile(profile);
        }
    }

    public static String getMavenCoords(String bundle) {
        if (bundle.startsWith("mvn:")) {
            return bundle.substring(4);
        }
        int idx = bundle.indexOf(":mvn:", 1);
        if (idx > 0) {
            return bundle.substring(idx + 5);
        }
        return null;
    }

    public int getProcessedFileCount() {
        return this.processedFiles.size();
    }

    public List<String> getFailedProfileIDs() {
        return new ArrayList<String>(this.errors.keySet());
    }

    protected void addMavenBundles(FabricService fabricService, Profile profile, Set<String> bundles, List<String> bundleList) {
        for (String bundle : bundleList) {
            if (bundle == null) continue;
            if (bundle.contains("$")) {
                ProfileService profileService = (ProfileService)fabricService.adapt(ProfileService.class);
                Profile overlay = profileService.getOverlayProfile(profile);
                bundle = VersionPropertyPointerResolver.replaceVersions((FabricService)fabricService, (Map)overlay.getConfigurations(), (String)bundle);
            }
            bundles.add(bundle);
        }
    }
}

