/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MapUtils {
    private MapUtils() {
    }

    public static <S, T> Map<S, Set<T>> invert(Map<T, S> map) {
        HashMap inverted = new HashMap(map.size());
        for (Map.Entry<T, S> entry : map.entrySet()) {
            MapUtils.addToMapSet(inverted, entry.getValue(), entry.getKey());
        }
        return inverted;
    }

    public static <S, T, U> Map<S, Set<U>> apply(Map<S, Set<T>> mapset, Function<T, U> function) {
        HashMap<S, Set<U>> result = new HashMap<S, Set<U>>(mapset.size());
        for (Map.Entry<S, Set<T>> entry : mapset.entrySet()) {
            result.put(entry.getKey(), MapUtils.apply(entry.getValue(), function));
        }
        return result;
    }

    public static <U, T> Set<U> apply(Set<T> set, Function<T, U> function) {
        HashSet<U> result = new HashSet<U>(set.size());
        for (T t : set) {
            U u = function.apply(t);
            if (u == null) continue;
            result.add(u);
        }
        return result;
    }

    public static <S, T, U> Map<T, U> build(Collection<S> col, Function<S, T> key, Function<S, U> value) {
        HashMap<T, U> result = new HashMap<T, U>(col.size());
        for (S s : col) {
            T t = key.apply(s);
            U u = value.apply(s);
            if (t == null || u == null) continue;
            result.put(t, u);
        }
        return result;
    }

    public static <S, T, U> Function<S, U> compose(final Function<S, T> f1, final Function<T, U> f2) {
        return new Function<S, U>(){

            @Override
            public U apply(S s) {
                return f2.apply(f1.apply(s));
            }
        };
    }

    public static <T, U> Function<T, U> map(final Map<T, U> map) {
        return new Function<T, U>(){

            @Override
            public U apply(T t) {
                return map.get(t);
            }
        };
    }

    public static <S, T> boolean contains(Map<S, Set<T>> mapset, S key, T val) {
        Set<T> set = mapset.get(key);
        return set != null && set.contains(val);
    }

    public static <S, T> Set<T> flatten(Map<S, Set<T>> mapset) {
        HashSet<T> set = new HashSet<T>();
        for (Set<T> s : mapset.values()) {
            set.addAll(s);
        }
        return set;
    }

    public static <S, T> Map<S, Set<T>> diff(Map<S, Set<T>> from, Map<S, Set<T>> to) {
        Map<S, Set<T>> diff = MapUtils.copyMapSet(from);
        MapUtils.remove(diff, to);
        return diff;
    }

    public static <S, T> void add(Map<S, Set<T>> from, Map<S, Set<T>> toAdd) {
        for (Map.Entry<S, Set<T>> entry : toAdd.entrySet()) {
            Set<T> s = from.get(entry.getKey());
            if (s == null) {
                s = new HashSet<T>();
                from.put(entry.getKey(), s);
            }
            s.addAll((Collection)entry.getValue());
        }
    }

    public static <S, T> void retain(Map<S, Set<T>> from, Map<S, Set<T>> toRetain) {
        Iterator<Map.Entry<S, Set<T>>> iterator = from.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<S, Set<T>> entry = iterator.next();
            Set<T> s = toRetain.get(entry.getKey());
            if (s != null) {
                entry.getValue().retainAll(s);
                continue;
            }
            iterator.remove();
        }
    }

    public static <S, T> void remove(Map<S, Set<T>> from, Map<S, Set<T>> toRemove) {
        for (Map.Entry<S, Set<T>> entry : toRemove.entrySet()) {
            Set<T> s = from.get(entry.getKey());
            if (s == null) continue;
            s.removeAll((Collection)entry.getValue());
            if (!s.isEmpty()) continue;
            from.remove(entry.getKey());
        }
    }

    public static <S> S copy(S obj) {
        if (obj instanceof List) {
            ArrayList r = new ArrayList();
            for (Object o : (List)obj) {
                r.add(MapUtils.copy(o));
            }
            return (S)r;
        }
        if (obj instanceof Set) {
            HashSet r = new HashSet();
            for (Object o : (Set)obj) {
                r.add(MapUtils.copy(o));
            }
            return (S)r;
        }
        if (obj instanceof Map) {
            HashMap r = new HashMap();
            for (Map.Entry e : ((Map)obj).entrySet()) {
                r.put(MapUtils.copy(e.getKey()), MapUtils.copy(e.getValue()));
            }
            return (S)r;
        }
        return obj;
    }

    public static <S> void copy(S s1, S s2) {
        if (s1 instanceof Collection) {
            for (Object o : (Collection)s1) {
                ((Collection)s2).add(MapUtils.copy(o));
            }
        } else if (s1 instanceof Map) {
            for (Map.Entry e : ((Map)s1).entrySet()) {
                ((Map)s2).put(MapUtils.copy(e.getKey()), MapUtils.copy(e.getValue()));
            }
        } else {
            throw new IllegalArgumentException("Source is not a Collection or a Map");
        }
    }

    public static <S, T> Map<S, Set<T>> copyMapSet(Map<S, Set<T>> from) {
        HashMap to = new HashMap();
        MapUtils.copyMapSet(from, to);
        return to;
    }

    public static <S, T> void copyMapSet(Map<S, Set<T>> from, Map<S, Set<T>> to) {
        for (Map.Entry<S, Set<T>> entry : from.entrySet()) {
            to.put(entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    public static <S, T> void addToMapSet(Map<S, Set<T>> map, S key, T value) {
        Set<T> values = map.get(key);
        if (values == null) {
            values = new HashSet<T>();
            map.put(key, values);
        }
        values.add(value);
    }

    public static <S, T> void removeFromMapSet(Map<S, Set<T>> map, S key, T value) {
        Set<T> values = map.get(key);
        if (values != null) {
            values.remove(value);
            if (values.isEmpty()) {
                map.remove(key);
            }
        }
    }

    public static interface Function<T, U> {
        public U apply(T var1);
    }
}

