/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.model;

import io.fabric8.agent.model.Feature;
import io.fabric8.agent.model.Features;
import io.fabric8.agent.model.JaxbUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;

public class Repository {
    private final URI uri;
    private Features features;

    public Repository(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getName() throws IOException {
        this.load();
        return this.features.getName();
    }

    public URI[] getRepositories() throws IOException {
        this.load();
        URI[] result = new URI[this.features.getRepository().size()];
        for (int i = 0; i < this.features.getRepository().size(); ++i) {
            String uri = this.features.getRepository().get(i);
            uri = uri.trim();
            result[i] = URI.create(uri);
        }
        return result;
    }

    public Feature[] getFeatures() throws IOException {
        this.load();
        return this.features.getFeature().toArray(new Feature[this.features.getFeature().size()]);
    }

    public void load() throws IOException {
        this.load(false);
    }

    public void load(boolean validate) throws IOException {
        if (this.features == null) {
            try (InterruptibleInputStream inputStream = new InterruptibleInputStream(this.uri.toURL().openStream());){
                this.load(inputStream, validate);
            }
        }
    }

    public void load(InputStream inputStream, boolean validate) throws IOException {
        try {
            this.features = JaxbUtil.unmarshal(this.uri.toASCIIString(), inputStream, validate);
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage() + " : " + this.uri).initCause(e);
        }
    }

    static class InterruptibleInputStream
    extends FilterInputStream {
        InterruptibleInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            return super.read(b, off, len);
        }
    }
}

