/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.region;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;

public abstract class AbstractRegionDigraphVisitor<C>
implements RegionDigraphVisitor {
    private final Collection<C> allCandidates;
    private final Deque<Set<C>> allowedDeque = new ArrayDeque<Set<C>>();
    private final Deque<Collection<C>> filteredDeque = new ArrayDeque<Collection<C>>();
    private Set<C> allowed = new HashSet<C>();

    public AbstractRegionDigraphVisitor(Collection<C> candidates) {
        this.allCandidates = candidates;
    }

    public Collection<C> getAllowed() {
        return this.allowed;
    }

    @Override
    public boolean visit(Region region) {
        Collection<C> candidates = this.filteredDeque.isEmpty() ? this.allCandidates : this.filteredDeque.peek();
        for (C candidate : candidates) {
            if (!this.contains(region, candidate)) continue;
            this.allowed.add(candidate);
        }
        return !this.allowed.containsAll(candidates);
    }

    @Override
    public boolean preEdgeTraverse(RegionFilter regionFilter) {
        Collection<C> filtered = this.filteredDeque.isEmpty() ? this.allCandidates : this.filteredDeque.peek();
        ArrayList<C> candidates = new ArrayList<C>(filtered);
        candidates.removeAll(this.allowed);
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            Object candidate = i.next();
            if (this.isAllowed(candidate, regionFilter)) continue;
            i.remove();
        }
        if (candidates.isEmpty()) {
            return false;
        }
        this.filteredDeque.push(candidates);
        this.allowedDeque.push(this.allowed);
        this.allowed = new HashSet<C>();
        return true;
    }

    @Override
    public void postEdgeTraverse(RegionFilter regionFilter) {
        this.filteredDeque.poll();
        Set<C> candidates = this.allowed;
        this.allowed = this.allowedDeque.pop();
        this.allowed.addAll(candidates);
    }

    protected abstract boolean contains(Region var1, C var2);

    protected abstract boolean isAllowed(C var1, RegionFilter var2);
}

