/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.region;

import io.fabric8.agent.download.DownloadCallback;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.Downloader;
import io.fabric8.agent.download.StreamProvider;
import io.fabric8.agent.internal.MapUtils;
import io.fabric8.agent.internal.Overrides;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.Conditional;
import io.fabric8.agent.model.Dependency;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.model.ScopeFilter;
import io.fabric8.agent.resolver.FeatureResource;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.ResourceImpl;
import io.fabric8.agent.resolver.ResourceUtils;
import io.fabric8.agent.service.MetadataBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Subsystem
extends ResourceImpl {
    private static final String ALL_FILTER = "(|(!(all=*))(all=*))";
    private static final String SUBSYSTEM_FILTER = String.format("(%s=%s)", "type", "karaf.subsystem");
    private static final String FEATURE_FILTER = String.format("(%s=%s)", "type", "karaf.feature");
    private static final String SUBSYSTEM_OR_FEATURE_FILTER = String.format("(|%s%s)", SUBSYSTEM_FILTER, FEATURE_FILTER);
    private static final Map<String, Set<String>> SHARE_ALL_POLICY = Collections.singletonMap("org.eclipse.equinox.allow.all", Collections.singleton("(|(!(all=*))(all=*))"));
    private static final Map<String, Set<String>> SHARE_NONE_POLICY = Collections.singletonMap("osgi.identity", Collections.singleton(SUBSYSTEM_FILTER));
    private final String name;
    private final boolean acceptDependencies;
    private final Subsystem parent;
    private final Feature feature;
    private final List<Subsystem> children = new ArrayList<Subsystem>();
    private final Map<String, Set<String>> importPolicy;
    private final Map<String, Set<String>> exportPolicy;
    private final List<Resource> installable = new ArrayList<Resource>();
    private final Map<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
    private final List<Requirement> dependentFeatures = new ArrayList<Requirement>();
    private final List<String> bundles = new ArrayList<String>();

    public Subsystem(String name) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = null;
        this.acceptDependencies = true;
        this.feature = null;
        this.importPolicy = SHARE_NONE_POLICY;
        this.exportPolicy = SHARE_NONE_POLICY;
    }

    public Subsystem(String name, Feature feature, Subsystem parent) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = parent;
        this.acceptDependencies = feature.getScoping() != null && feature.getScoping().acceptDependencies();
        this.feature = feature;
        if (feature.getScoping() != null) {
            this.importPolicy = this.createPolicy(feature.getScoping().getImports());
            this.importPolicy.put("osgi.identity", Collections.singleton(SUBSYSTEM_OR_FEATURE_FILTER));
            this.exportPolicy = this.createPolicy(feature.getScoping().getExports());
            this.exportPolicy.put("osgi.identity", Collections.singleton(SUBSYSTEM_OR_FEATURE_FILTER));
        } else {
            this.importPolicy = SHARE_ALL_POLICY;
            this.exportPolicy = SHARE_ALL_POLICY;
        }
        ResourceUtils.addIdentityRequirement((ResourceImpl)this, feature.getName(), "karaf.feature", new VersionRange(VersionTable.getVersion(feature.getVersion()), true));
    }

    public Subsystem(String name, Subsystem parent, boolean acceptDependencies) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = parent;
        this.acceptDependencies = acceptDependencies;
        this.feature = null;
        this.importPolicy = SHARE_ALL_POLICY;
        this.exportPolicy = SHARE_NONE_POLICY;
    }

    public List<Resource> getInstallable() {
        return this.installable;
    }

    public String getName() {
        return this.name;
    }

    public Subsystem getParent() {
        return this.parent;
    }

    public Collection<Subsystem> getChildren() {
        return this.children;
    }

    public Subsystem getChild(String name) {
        for (Subsystem child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public boolean isAcceptDependencies() {
        return this.acceptDependencies;
    }

    public Map<String, Set<String>> getImportPolicy() {
        return this.importPolicy;
    }

    public Map<String, Set<String>> getExportPolicy() {
        return this.exportPolicy;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Subsystem createSubsystem(String name, boolean acceptDependencies) {
        if (this.feature != null) {
            throw new UnsupportedOperationException("Can not create application subsystems inside a feature subsystem");
        }
        String childName = this.getName() + "/" + name;
        Subsystem as = new Subsystem(childName, this, acceptDependencies);
        this.children.add(as);
        ResourceUtils.addIdentityRequirement((ResourceImpl)this, childName, "karaf.subsystem", (VersionRange)null);
        this.installable.add(as);
        return as;
    }

    public void addSystemResource(Resource resource) {
        this.installable.add(resource);
    }

    public void requireFeature(String name, String range, boolean mandatory) {
        if (mandatory) {
            ResourceUtils.addIdentityRequirement((ResourceImpl)this, name, "karaf.feature", range);
        } else {
            ResourceImpl res = new ResourceImpl();
            ResourceUtils.addIdentityRequirement(res, name, "karaf.feature", range);
            this.dependentFeatures.addAll(res.getRequirements(null));
        }
    }

    public void require(String requirement) throws BundleException {
        String req;
        String type;
        int idx = requirement.indexOf(":");
        if (idx >= 0) {
            type = requirement.substring(0, idx);
            req = requirement.substring(idx + 1);
        } else {
            type = "feature";
            req = requirement;
        }
        switch (type) {
            case "feature": {
                this.addRequirement(ResourceUtils.toFeatureRequirement(req));
                break;
            }
            case "requirement": {
                this.addRequirement(req);
                break;
            }
            case "bundle": {
                this.bundles.add(req);
            }
        }
    }

    protected void addRequirement(String requirement) throws BundleException {
        for (Requirement req : ResourceBuilder.parseRequirement(this, requirement)) {
            Object range = req.getAttributes().get("version");
            if (range instanceof String) {
                req.getAttributes().put("version", new VersionRange((String)range));
            }
            this.addRequirement(req);
        }
    }

    public Map<String, BundleInfo> getBundleInfos() {
        HashMap<String, BundleInfo> infos = new HashMap<String, BundleInfo>();
        for (DependencyInfo di : this.dependencies.values()) {
            infos.put(di.getLocation(), di);
        }
        return infos;
    }

    public void build(Collection<Feature> features) throws Exception {
        for (Subsystem child : this.children) {
            child.build(features);
        }
        if (this.feature != null) {
            for (Dependency dep : this.feature.getDependencies()) {
                Subsystem ss = this;
                while (!ss.isAcceptDependencies()) {
                    ss = ss.getParent();
                }
                ss.requireFeature(dep.getName(), dep.getVersion(), !dep.isDependency());
            }
        }
        ArrayList<Requirement> processed = new ArrayList<Requirement>();
        block3: while (true) {
            List<Requirement> requirements = this.getRequirements("osgi.identity");
            requirements.addAll(this.dependentFeatures);
            requirements.removeAll(processed);
            if (requirements.isEmpty()) break;
            Iterator<Requirement> i$ = requirements.iterator();
            while (true) {
                if (!i$.hasNext()) continue block3;
                Requirement requirement = i$.next();
                String name = (String)requirement.getAttributes().get("osgi.identity");
                String type = (String)requirement.getAttributes().get("type");
                VersionRange range = (VersionRange)requirement.getAttributes().get("version");
                if ("karaf.feature".equals(type)) {
                    for (Feature feature : features) {
                        String ssName;
                        Subsystem fs;
                        if (!feature.getName().equals(name) || range != null && !range.contains(VersionTable.getVersion(feature.getVersion())) || feature == this.feature || (fs = this.getChild(ssName = this.name + "#" + (feature.hasVersion() ? feature.getName() + "-" + feature.getVersion() : feature.getName()))) != null) continue;
                        fs = new Subsystem(ssName, feature, this);
                        fs.build(features);
                        this.installable.add(fs);
                        this.children.add(fs);
                    }
                }
                processed.add(requirement);
            }
            break;
        }
    }

    public Set<String> collectPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        this.doCollectPrerequisites(prereqs);
        return prereqs;
    }

    private void doCollectPrerequisites(Set<String> prereqs) {
        for (Subsystem child : this.children) {
            child.doCollectPrerequisites(prereqs);
        }
        if (this.feature != null) {
            for (Dependency dep : this.feature.getDependencies()) {
                if (!dep.isPrerequisite()) continue;
                prereqs.add(dep.toString());
            }
        }
    }

    public void downloadBundles(DownloadManager manager, MetadataBuilder builder, Set<String> overrides, String featureResolutionRange) throws Exception {
        String loc;
        for (Subsystem child : this.children) {
            child.downloadBundles(manager, builder, overrides, featureResolutionRange);
        }
        ConcurrentHashMap<String, ResourceImpl> bundles = new ConcurrentHashMap<String, ResourceImpl>();
        Downloader downloader = manager.createDownloader();
        HashMap<BundleInfo, Conditional> infos = new HashMap<BundleInfo, Conditional>();
        if (this.feature != null) {
            for (Conditional cond : this.feature.getConditional()) {
                for (BundleInfo bi : cond.getBundles()) {
                    infos.put(bi, cond);
                }
            }
            for (BundleInfo bi : this.feature.getBundles()) {
                infos.put(bi, null);
            }
        }
        ResourceBuilderCallback callback = new ResourceBuilderCallback(bundles, builder);
        for (Map.Entry entry : infos.entrySet()) {
            BundleInfo bi;
            bi = (BundleInfo)entry.getKey();
            String loc2 = bi.getLocation();
            downloader.download(loc2, callback);
        }
        for (Clause bundle : Parser.parseClauses(this.bundles.toArray(new String[this.bundles.size()]))) {
            loc = bundle.getName();
            downloader.download(loc, callback);
        }
        for (String override : overrides) {
            String loc3 = Overrides.extractUrl(override);
            downloader.download(loc3, callback);
        }
        downloader.await();
        Overrides.override(bundles, overrides);
        if (this.feature != null) {
            HashMap<Conditional, FeatureResource> resConds = new HashMap<Conditional, FeatureResource>();
            for (Conditional cond : this.feature.getConditional()) {
                FeatureResource resCond = FeatureResource.build(this.feature, cond, featureResolutionRange, bundles);
                ResourceUtils.addIdentityRequirement(this, resCond, false);
                ResourceUtils.addIdentityRequirement(resCond, this, true);
                this.installable.add(resCond);
                resConds.put(cond, resCond);
            }
            FeatureResource resFeature = FeatureResource.build(this.feature, featureResolutionRange, bundles);
            ResourceUtils.addIdentityRequirement(resFeature, this);
            this.installable.add(resFeature);
            for (Map.Entry entry : infos.entrySet()) {
                BundleInfo bi = (BundleInfo)entry.getKey();
                String loc4 = bi.getLocation();
                Conditional cond = (Conditional)entry.getValue();
                ResourceImpl res = (ResourceImpl)bundles.get(loc4);
                if (bi.isDependency()) {
                    this.addDependency(res, false, bi.isStart(), bi.getStartLevel());
                } else {
                    this.doAddDependency(res, cond == null, bi.isStart(), bi.getStartLevel());
                }
                if (cond == null) continue;
                ResourceUtils.addIdentityRequirement(res, (Resource)resConds.get(cond), true);
            }
        }
        for (Clause bundle : Parser.parseClauses(this.bundles.toArray(new String[this.bundles.size()]))) {
            loc = bundle.getName();
            boolean dependency = Boolean.parseBoolean(bundle.getAttribute("dependency"));
            boolean start = bundle.getAttribute("start") == null || Boolean.parseBoolean(bundle.getAttribute("start"));
            int startLevel = 0;
            try {
                startLevel = Integer.parseInt(bundle.getAttribute("start-level"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dependency) {
                this.addDependency((ResourceImpl)bundles.get(loc), false, start, startLevel);
                continue;
            }
            this.doAddDependency((ResourceImpl)bundles.get(loc), true, start, startLevel);
            ResourceUtils.addIdentityRequirement(this, (Resource)bundles.get(loc));
        }
        for (DependencyInfo info : this.dependencies.values()) {
            this.installable.add(info.resource);
            ResourceUtils.addIdentityRequirement(info.resource, this, info.mandatory);
        }
    }

    void addDependency(ResourceImpl resource, boolean mandatory, boolean start, int startLevel) {
        if (this.isAcceptDependencies()) {
            this.doAddDependency(resource, mandatory, start, startLevel);
        } else {
            this.parent.addDependency(resource, mandatory, start, startLevel);
        }
    }

    private void doAddDependency(ResourceImpl resource, boolean mandatory, boolean start, int startLevel) {
        String id = ResourceUtils.getSymbolicName(resource) + "|" + ResourceUtils.getVersion(resource);
        DependencyInfo info = this.dependencies.get(id);
        if (info == null) {
            info = new DependencyInfo();
            this.dependencies.put(id, info);
        }
        info.resource = resource;
        info.mandatory |= mandatory;
        info.start |= start;
        info.startLevel = info.startLevel > 0 && startLevel > 0 ? Math.min(info.startLevel, startLevel) : Math.max(info.startLevel, startLevel);
    }

    Map<String, Set<String>> createPolicy(List<? extends ScopeFilter> filters) {
        HashMap<String, Set<String>> policy = new HashMap<String, Set<String>>();
        for (ScopeFilter scopeFilter : filters) {
            MapUtils.addToMapSet(policy, scopeFilter.getNamespace(), scopeFilter.getFilter());
        }
        return policy;
    }

    ResourceImpl createResource(String uri, Map<String, String> headers) throws Exception {
        try {
            return ResourceBuilder.build(uri, headers);
        }
        catch (BundleException e) {
            throw new Exception("Unable to create resource for bundle " + uri, e);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    class DependencyInfo
    extends BundleInfo {
        ResourceImpl resource;
        boolean mandatory;
        boolean start;
        int startLevel;

        DependencyInfo() {
        }

        @Override
        public boolean isStart() {
            return this.start;
        }

        @Override
        public int getStartLevel() {
            return this.startLevel;
        }

        @Override
        public String getLocation() {
            return ResourceUtils.getUri(this.resource);
        }

        @Override
        public boolean isDependency() {
            return !this.mandatory;
        }
    }

    class ResourceBuilderCallback
    implements DownloadCallback {
        final Map<String, ResourceImpl> bundles;
        final MetadataBuilder builder;

        ResourceBuilderCallback(Map<String, ResourceImpl> bundles, MetadataBuilder builder) {
            this.bundles = bundles;
            this.builder = builder;
        }

        @Override
        public void downloaded(StreamProvider provider) throws Exception {
            String loc = provider.getUrl();
            Map<String, String> headers = this.builder.getMetadata(provider.getUrl(), provider.getFile());
            ResourceImpl res = Subsystem.this.createResource(loc, headers);
            this.bundles.put(loc, res);
        }
    }
}

