/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.internal.Macro;
import io.fabric8.agent.model.BundleInfo;
import io.fabric8.agent.model.Capability;
import io.fabric8.agent.model.Conditional;
import io.fabric8.agent.model.Dependency;
import io.fabric8.agent.model.Feature;
import io.fabric8.agent.resolver.RequirementImpl;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.ResourceImpl;
import io.fabric8.agent.resolver.ResourceUtils;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.BundleException;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public final class FeatureResource
extends ResourceImpl {
    public static final String REQUIREMENT_CONDITIONAL_DIRECTIVE = "condition";
    public static final String CONDITIONAL_TRUE = "true";
    private final Feature feature;

    private FeatureResource(Feature feature) {
        super(feature.getName(), "karaf.feature", VersionTable.getVersion(feature.getVersion()));
        this.feature = feature;
    }

    public static FeatureResource build(Feature feature, Conditional conditional, String featureRange, Map<String, ? extends Resource> locToRes) throws BundleException {
        Feature fcond = conditional.asFeature(feature.getName(), feature.getVersion());
        FeatureResource resource = FeatureResource.build(fcond, featureRange, locToRes);
        for (String cond : conditional.getCondition()) {
            if (cond.startsWith("req:")) {
                cond = cond.substring("req:".length());
                List<Requirement> reqs = ResourceBuilder.parseRequirement(resource, cond);
                resource.addRequirements(reqs);
                continue;
            }
            Dependency dep = new Dependency();
            String[] p = cond.split("/");
            dep.setName(p[0]);
            if (p.length > 1) {
                dep.setVersion(p[1]);
            }
            FeatureResource.addDependency(resource, dep, featureRange, true);
        }
        Dependency dep = new Dependency();
        dep.setName(feature.getName());
        dep.setVersion(feature.getVersion());
        FeatureResource.addDependency(resource, dep, featureRange, true);
        return resource;
    }

    public static FeatureResource build(Feature feature, String featureRange, Map<String, ? extends Resource> locToRes) throws BundleException {
        FeatureResource resource = new FeatureResource(feature);
        for (BundleInfo info : feature.getBundles()) {
            if (info.isDependency()) continue;
            Resource res = locToRes.get(info.getLocation());
            if (res == null) {
                throw new IllegalStateException("Resource not found for url " + info.getLocation());
            }
            ResourceUtils.addIdentityRequirement(resource, res);
        }
        for (Dependency dep : feature.getDependencies()) {
            if (dep.isDependency()) continue;
            FeatureResource.addDependency(resource, dep, featureRange);
        }
        for (Capability cap : feature.getCapabilities()) {
            resource.addCapabilities(ResourceBuilder.parseCapability(resource, cap.getValue()));
        }
        for (io.fabric8.agent.model.Requirement req : feature.getRequirements()) {
            resource.addRequirements(ResourceBuilder.parseRequirement(resource, req.getValue()));
        }
        return resource;
    }

    protected static void addDependency(FeatureResource resource, Dependency dep, String featureRange) {
        FeatureResource.addDependency(resource, dep, featureRange, false);
    }

    protected static void addDependency(FeatureResource resource, Dependency dep, String featureRange, boolean condition) {
        String name = dep.getName();
        String version = dep.getVersion();
        if (version.equals("0.0.0")) {
            version = null;
        } else if (!version.startsWith("[") && !version.startsWith("(")) {
            version = Macro.transform(featureRange, version);
        }
        RequirementImpl requirement = ResourceUtils.addIdentityRequirement((ResourceImpl)resource, name, "karaf.feature", version);
        if (condition) {
            requirement.getDirectives().put(REQUIREMENT_CONDITIONAL_DIRECTIVE, CONDITIONAL_TRUE);
        }
    }

    public Feature getFeature() {
        return this.feature;
    }
}

