/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;

public class MetadataBuilder {
    private final Map<String, Map<VersionRange, Map<String, String>>> metadata;

    public MetadataBuilder(Map<String, Map<VersionRange, Map<String, String>>> metadata) {
        this.metadata = metadata;
    }

    public Map<String, String> getMetadata(String url, File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(is);
            while ((entry = zis.getNextEntry()) != null) {
                if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                Attributes attributes = new Manifest(zis).getMainAttributes();
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                    headers.put(attr.getKey().toString(), attr.getValue().toString());
                }
                Map<String, String> map = this.overrideHeaders(headers);
                return map;
            }
        }
        throw new IllegalArgumentException("Resource " + url + " does not contain a manifest");
    }

    public Map<String, String> overrideHeaders(Map<String, String> headers) {
        String bsn = headers.get("Bundle-SymbolicName");
        String vstr = headers.get("Bundle-Version");
        if (bsn != null && vstr != null) {
            Map<VersionRange, Map<String, String>> ranges;
            if (bsn.indexOf(59) > 0) {
                bsn = bsn.substring(0, bsn.indexOf(59));
            }
            Version ver = VersionTable.getVersion(vstr);
            Map<VersionRange, Map<String, String>> map = ranges = this.metadata != null ? this.metadata.get(bsn) : null;
            if (ranges != null) {
                for (Map.Entry<VersionRange, Map<String, String>> entry2 : ranges.entrySet()) {
                    if (!entry2.getKey().contains(ver)) continue;
                    for (Map.Entry<String, String> entry3 : entry2.getValue().entrySet()) {
                        String val;
                        val = entry3.getValue().startsWith("=") ? entry3.getValue().substring(1) : ((val = headers.get(entry3.getKey())) != null ? val + "," + entry3.getValue() : entry3.getValue());
                        headers.put(entry3.getKey(), val);
                    }
                }
            }
        }
        return headers;
    }
}

