/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.service;

import io.fabric8.agent.service.State;
import io.fabric8.common.util.json.JsonReader;
import io.fabric8.common.util.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class StateStorage {
    public void load(State state) throws IOException {
        state.repositories.clear();
        state.requirements.clear();
        state.installedFeatures.clear();
        state.managedBundles.clear();
        try (InputStream is = this.getInputStream();){
            if (is != null) {
                Map json = (Map)JsonReader.read((InputStream)is);
                state.bootDone.set((Boolean)json.get("bootDone"));
                state.repositories.addAll(StateStorage.toStringSet((Collection)json.get("repositories")));
                state.requirements.putAll(StateStorage.toStringStringSetMap((Map)json.get("features")));
                state.installedFeatures.putAll(StateStorage.toStringStringSetMap((Map)json.get("installed")));
                state.stateFeatures.putAll(StateStorage.toStringStringStringMapMap((Map)json.get("state")));
                state.managedBundles.putAll(StateStorage.toStringLongSetMap((Map)json.get("managed")));
                state.bundleChecksums.putAll(StateStorage.toLongLongMap((Map)json.get("checksums")));
            }
        }
    }

    public void save(State state) throws IOException {
        try (OutputStream os = this.getOutputStream();){
            if (os != null) {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("bootDone", state.bootDone.get());
                json.put("repositories", state.repositories);
                json.put("features", state.requirements);
                json.put("installed", state.installedFeatures);
                json.put("state", state.stateFeatures);
                json.put("managed", state.managedBundles);
                json.put("checksums", StateStorage.toStringLongMap(state.bundleChecksums));
                JsonWriter.write((OutputStream)os, json);
            }
        }
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    static Map<String, Map<String, String>> toStringStringStringMapMap(Map<?, ?> map) {
        HashMap<String, Map<String, String>> nm = new HashMap<String, Map<String, String>>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            nm.put(entry.getKey().toString(), StateStorage.toStringStringMap((Map)entry.getValue()));
        }
        return nm;
    }

    static Map<String, String> toStringStringMap(Map<?, ?> map) {
        HashMap<String, String> nm = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            nm.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return nm;
    }

    static Map<String, Set<String>> toStringStringSetMap(Map<?, ?> map) {
        HashMap<String, Set<String>> nm = new HashMap<String, Set<String>>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            nm.put(entry.getKey().toString(), StateStorage.toStringSet((Collection)entry.getValue()));
        }
        return nm;
    }

    static Map<String, Set<Long>> toStringLongSetMap(Map<?, ?> map) {
        HashMap<String, Set<Long>> nm = new HashMap<String, Set<Long>>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            nm.put(entry.getKey().toString(), StateStorage.toLongSet((Collection)entry.getValue()));
        }
        return nm;
    }

    static Set<String> toStringSet(Collection<?> col) {
        TreeSet<String> ns = new TreeSet<String>();
        for (Object o : col) {
            ns.add(o.toString());
        }
        return ns;
    }

    static Set<Long> toLongSet(Collection<?> set) {
        TreeSet<Long> ns = new TreeSet<Long>();
        for (Object o : set) {
            ns.add(StateStorage.toLong(o));
        }
        return ns;
    }

    static Map<Long, Long> toLongLongMap(Map<?, ?> map) {
        HashMap<Long, Long> nm = new HashMap<Long, Long>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            nm.put(StateStorage.toLong(entry.getKey()), StateStorage.toLong(entry.getValue()));
        }
        return nm;
    }

    static Map<String, Long> toStringLongMap(Map<?, ?> map) {
        HashMap<String, Long> nm = new HashMap<String, Long>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            nm.put(entry.getKey().toString(), StateStorage.toLong(entry.getValue()));
        }
        return nm;
    }

    static long toLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(o.toString());
    }
}

