/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.CertificateCallback;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.PropertiesLoader;
import org.apache.activemq.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CertificateLoginModule
extends PropertiesLoader
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateLoginModule.class);
    private CallbackHandler callbackHandler;
    private Subject subject;
    private X509Certificate[] certificates;
    private String username;
    private Set<String> groups;
    private Set<Principal> principals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.init(options);
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " Unable to obtain client certificates.");
        }
        this.certificates = ((CertificateCallback)callbacks[0]).getCertificates();
        this.username = this.getUserNameForCertificates(this.certificates);
        if (this.username == null) {
            throw new FailedLoginException("No user for client certificate: " + this.getDistinguishedName(this.certificates));
        }
        this.groups = this.getUserGroups(this.username);
        if (this.debug) {
            LOG.debug("Certificate for user: " + this.username);
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.username));
        for (String group : this.groups) {
            this.principals.add(new GroupPrincipal(group));
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            LOG.debug("commit");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.groups.clear();
        this.certificates = null;
    }

    protected abstract String getUserNameForCertificates(X509Certificate[] var1) throws LoginException;

    protected abstract Set<String> getUserGroups(String var1) throws LoginException;

    protected String getDistinguishedName(X509Certificate[] certs) {
        if (certs != null && certs.length > 0 && certs[0] != null) {
            return certs[0].getSubjectDN().getName();
        }
        return null;
    }
}

