/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.jaas.CertificateLoginModule;

public class TextFileCertificateLoginModule
extends CertificateLoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.user";
    private static final String GROUP_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.group";
    private Properties groups;
    private Map<String, String> usersByDn;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.usersByDn = this.load(USER_FILE_PROP_NAME, "", options).invertedPropertiesMap();
        this.groups = this.load(GROUP_FILE_PROP_NAME, "", options).getProps();
    }

    @Override
    protected String getUserNameForCertificates(X509Certificate[] certs) throws LoginException {
        if (certs == null) {
            throw new LoginException("Client certificates not found. Cannot authenticate.");
        }
        return this.usersByDn.get(this.getDistinguishedName(certs));
    }

    @Override
    protected Set<String> getUserGroups(String username) throws LoginException {
        HashSet<String> userGroups = new HashSet<String>();
        Enumeration<Object> enumeration = this.groups.keys();
        block0: while (enumeration.hasMoreElements()) {
            String groupName = (String)enumeration.nextElement();
            String[] userList = (this.groups.getProperty(groupName) + "").split(",");
            for (int i = 0; i < userList.length; ++i) {
                if (!username.equals(userList[i])) continue;
                userGroups.add(groupName);
                continue block0;
            }
        }
        return userGroups;
    }
}

