/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.broker.region.CompositeDestinationInterceptor;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.virtual.CompositeQueue;
import org.apache.activemq.broker.region.virtual.CompositeTopic;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.schema.core.DtoCompositeQueue;
import org.apache.activemq.schema.core.DtoCompositeTopic;
import org.apache.activemq.schema.core.DtoVirtualDestinationInterceptor;
import org.apache.activemq.schema.core.DtoVirtualTopic;

public class VirtualDestinationInterceptorProcessor
extends DefaultConfigurationProcessor {
    public VirtualDestinationInterceptorProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public void addNew(Object o) {
        final DtoVirtualDestinationInterceptor dto = (DtoVirtualDestinationInterceptor)o;
        this.plugin.addDestinationWork.add(new Runnable(){

            @Override
            public void run() {
                boolean updatedExistingInterceptor = false;
                RegionBroker regionBroker = (RegionBroker)VirtualDestinationInterceptorProcessor.this.plugin.getBrokerService().getRegionBroker();
                for (DestinationInterceptor destinationInterceptor : VirtualDestinationInterceptorProcessor.this.plugin.getBrokerService().getDestinationInterceptors()) {
                    if (!(destinationInterceptor instanceof VirtualDestinationInterceptor)) continue;
                    VirtualDestinationInterceptor virtualDestinationInterceptor = (VirtualDestinationInterceptor)destinationInterceptor;
                    virtualDestinationInterceptor.setVirtualDestinations(VirtualDestinationInterceptorProcessor.this.fromDto(dto));
                    VirtualDestinationInterceptorProcessor.this.plugin.info("applied updates to: " + virtualDestinationInterceptor);
                    updatedExistingInterceptor = true;
                }
                if (!updatedExistingInterceptor) {
                    VirtualDestinationInterceptor virtualDestinationInterceptor = new VirtualDestinationInterceptor();
                    virtualDestinationInterceptor.setVirtualDestinations(VirtualDestinationInterceptorProcessor.this.fromDto(dto));
                    ArrayList<DestinationInterceptor> interceptorsList = new ArrayList<DestinationInterceptor>();
                    interceptorsList.addAll(Arrays.asList(VirtualDestinationInterceptorProcessor.this.plugin.getBrokerService().getDestinationInterceptors()));
                    interceptorsList.add(virtualDestinationInterceptor);
                    DestinationInterceptor[] destinationInterceptors = interceptorsList.toArray(new DestinationInterceptor[0]);
                    VirtualDestinationInterceptorProcessor.this.plugin.getBrokerService().setDestinationInterceptors(destinationInterceptors);
                    ((CompositeDestinationInterceptor)regionBroker.getDestinationInterceptor()).setInterceptors(destinationInterceptors);
                    VirtualDestinationInterceptorProcessor.this.plugin.info("applied new: " + interceptorsList);
                }
                regionBroker.reapplyInterceptor();
            }
        });
    }

    @Override
    public void remove(Object o) {
        this.plugin.addDestinationWork.add(new Runnable(){

            @Override
            public void run() {
                ArrayList<DestinationInterceptor> interceptorsList = new ArrayList<DestinationInterceptor>();
                for (DestinationInterceptor candidate : VirtualDestinationInterceptorProcessor.this.plugin.getBrokerService().getDestinationInterceptors()) {
                    if (candidate instanceof VirtualDestinationInterceptor) continue;
                    interceptorsList.add(candidate);
                }
                DestinationInterceptor[] destinationInterceptors = interceptorsList.toArray(new DestinationInterceptor[0]);
                VirtualDestinationInterceptorProcessor.this.plugin.getBrokerService().setDestinationInterceptors(destinationInterceptors);
                ((CompositeDestinationInterceptor)((RegionBroker)VirtualDestinationInterceptorProcessor.this.plugin.getBrokerService().getRegionBroker()).getDestinationInterceptor()).setInterceptors(destinationInterceptors);
                VirtualDestinationInterceptorProcessor.this.plugin.info("removed VirtualDestinationInterceptor from: " + interceptorsList);
            }
        });
    }

    private VirtualDestination[] fromDto(DtoVirtualDestinationInterceptor virtualDestinationInterceptor) {
        ArrayList<VirtualDestination> answer = new ArrayList<VirtualDestination>();
        for (Object vd : this.filter(virtualDestinationInterceptor, DtoVirtualDestinationInterceptor.VirtualDestinations.class)) {
            for (Object vt : this.filter(vd, DtoVirtualTopic.class)) {
                answer.add(this.fromDto(vt, new VirtualTopic()));
            }
            for (Object vt : this.filter(vd, DtoCompositeTopic.class)) {
                answer.add(this.fromDto(vt, new CompositeTopic()));
            }
            for (Object vt : this.filter(vd, DtoCompositeQueue.class)) {
                answer.add(this.fromDto(vt, new CompositeQueue()));
            }
        }
        VirtualDestination[] array = new VirtualDestination[answer.size()];
        answer.toArray(array);
        return array;
    }
}

