/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import javax.jms.BytesMessage;
import javax.jms.Message;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.InboundTransformer;
import org.apache.activemq.transport.amqp.message.JMSVendor;

public class AMQPRawInboundTransformer
extends InboundTransformer {
    public AMQPRawInboundTransformer(JMSVendor vendor) {
        super(vendor);
    }

    @Override
    public String getTransformerName() {
        return "raw";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return null;
    }

    @Override
    public Message transform(EncodedMessage amqpMessage) throws Exception {
        BytesMessage rc = this.vendor.createBytesMessage();
        rc.writeBytes(amqpMessage.getArray(), amqpMessage.getArrayOffset(), amqpMessage.getLength());
        rc.setJMSDeliveryMode(this.defaultDeliveryMode);
        rc.setJMSPriority(this.defaultPriority);
        long now = System.currentTimeMillis();
        rc.setJMSTimestamp(now);
        if (this.defaultTtl > 0L) {
            rc.setJMSExpiration(now + this.defaultTtl);
        }
        rc.setLongProperty(this.prefixVendor + "MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        rc.setBooleanProperty(this.prefixVendor + "NATIVE", true);
        return rc;
    }
}

