/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JsonSchemaHelper {
    private static final Pattern PATTERN = Pattern.compile("\"(.+?)\"|\\[(.+)\\]");
    private static final String QUOT = "&quot;";

    private JsonSchemaHelper() {
    }

    public static String getType(Class<?> type) {
        if (type.isEnum()) {
            return "enum";
        }
        if (type.isArray()) {
            return "array";
        }
        if (type.isAssignableFrom(URI.class) || type.isAssignableFrom(URL.class)) {
            return "sting";
        }
        String primitive = JsonSchemaHelper.getPrimitiveType(type);
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(Class<?> type) {
        String name = type.getCanonicalName();
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return "boolean";
        }
        if ("boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return "integer";
        }
        if ("int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return "integer";
        }
        if ("long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return "integer";
        }
        if ("short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return "integer";
        }
        if ("byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return "number";
        }
        if ("float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return "number";
        }
        if ("double".equals(name)) {
            return "number";
        }
        return null;
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        String[] lines;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        boolean found = false;
        for (String line : lines = json.split("\n")) {
            if (!found) {
                String s = line.trim();
                found = s.startsWith("\"" + group + "\":");
                continue;
            }
            if (line.equals("  },") || line.equals("  }")) break;
            line = line.replaceAll("\"\\\\\"\"", "\"&quot;\"");
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            Matcher matcher = PATTERN.matcher(line);
            String key = parseProperties ? "name" : null;
            while (matcher.find()) {
                if (key == null) {
                    key = matcher.group(1);
                    continue;
                }
                String value = matcher.group(1);
                if (value == null) {
                    value = matcher.group(2);
                    value = value.replaceAll("\"", "");
                    value = value.replaceAll(", ", ",");
                }
                if (value != null) {
                    value = value.trim();
                    value = value.replaceAll(QUOT, "\"");
                    value = JsonSchemaHelper.decodeJson(value);
                }
                row.put(key, value);
                key = null;
            }
            if (row.isEmpty()) continue;
            answer.add(row);
        }
        return answer;
    }

    private static String decodeJson(String value) {
        if ("\\\\".equals(value)) {
            value = "\\";
        }
        return value;
    }
}

