/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.CloseShellException;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellCommandFactory
implements CommandFactory {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String EXEC_INIT_SCRIPT = "karaf.exec.init.script";
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellCommandFactory.class);
    private static final Class[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private CommandProcessor commandProcessor;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public Command createCommand(String command) {
        return new ShellCommand(command);
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String scriptFileName, CommandSession session) {
        if (scriptFileName != null) {
            Reader r = null;
            try {
                int n;
                File scriptFile = new File(scriptFileName);
                r = new InputStreamReader(new FileInputStream(scriptFile));
                CharArrayWriter w = new CharArrayWriter();
                char[] buf = new char[8192];
                while ((n = r.read(buf)) > 0) {
                    w.write(buf, 0, n);
                }
                session.execute((CharSequence)new String(w.toCharArray()));
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script", (Throwable)e);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public class ShellCommand
    implements Command,
    SessionAware {
        private String command;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;

        public ShellCommand(String command) {
            this.command = command;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(Environment env) throws IOException {
            int exitStatus = 0;
            final CommandSession commandSession = ShellCommandFactory.this.commandProcessor.createSession(this.in, new PrintStream(this.out), new PrintStream(this.err));
            try {
                commandSession.put("SCOPE", (Object)"shell:osgi:*");
                commandSession.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
                for (Map.Entry e : env.getEnv().entrySet()) {
                    commandSession.put((String)e.getKey(), e.getValue());
                }
                try {
                    Object result;
                    Subject subject;
                    this.waitForIfCommands(commandSession);
                    Subject subject2 = subject = this.session != null ? (Subject)this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                    if (subject != null) {
                        try {
                            result = JaasHelper.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    String scriptFileName = System.getProperty(ShellCommandFactory.EXEC_INIT_SCRIPT);
                                    if (scriptFileName == null) {
                                        scriptFileName = System.getProperty(ShellCommandFactory.SHELL_INIT_SCRIPT);
                                    }
                                    ShellCommandFactory.this.executeScript(scriptFileName, commandSession);
                                    return commandSession.execute((CharSequence)ShellCommand.this.command);
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            throw e.getException();
                        }
                    } else {
                        String scriptFileName = System.getProperty(ShellCommandFactory.EXEC_INIT_SCRIPT);
                        if (scriptFileName == null) {
                            scriptFileName = System.getProperty(ShellCommandFactory.SHELL_INIT_SCRIPT);
                        }
                        ShellCommandFactory.this.executeScript(scriptFileName, commandSession);
                        result = commandSession.execute((CharSequence)this.command);
                    }
                    if (result != null) {
                        commandSession.getConsole().println(commandSession.format(result, 0));
                    }
                }
                catch (Throwable t) {
                    exitStatus = 1;
                    try {
                        boolean isCommandNotFound = "org.apache.felix.gogo.runtime.CommandNotFoundException".equals(t.getClass().getName());
                        if (isCommandNotFound) {
                            LOGGER.debug("Unknown command entered", t);
                        } else if (!(t instanceof CloseShellException)) {
                            LOGGER.info("Exception caught while executing command", t);
                        }
                        commandSession.put("karaf.lastException", (Object)t);
                        if (t instanceof CommandException) {
                            commandSession.getConsole().println(((CommandException)t).getNiceHelp());
                        } else if (isCommandNotFound) {
                            String str = Ansi.ansi().fg(Ansi.Color.RED).a("Command not found: ").a(Ansi.Attribute.INTENSITY_BOLD).a(t.getClass().getMethod("getCommand", new Class[0]).invoke((Object)t, new Object[0])).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString();
                            commandSession.getConsole().println(str);
                        }
                        if (this.getBoolean(commandSession, "karaf.printStackTraces")) {
                            commandSession.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                            t.printStackTrace(commandSession.getConsole());
                            commandSession.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                        } else if (!(t instanceof CloseShellException || t instanceof CommandException || isCommandNotFound)) {
                            commandSession.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                            commandSession.getConsole().println("Error executing command: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getName()));
                            commandSession.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                        }
                        commandSession.getConsole().flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                try {
                    exitStatus = 1;
                    throw (IOException)new IOException("Unable to start shell").initCause(e);
                }
                catch (Throwable throwable) {
                    ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
                    commandSession.close();
                    this.callback.onExit(exitStatus);
                    throw throwable;
                }
            }
            ShellCommandFactory.close(new Closeable[]{this.in, this.out, this.err});
            commandSession.close();
            this.callback.onExit(exitStatus);
        }

        private void waitForIfCommands(CommandSession commandSession) throws TimeoutException, InterruptedException {
            Set names = (Set)commandSession.get(".commands");
            if (names.contains("shell:if")) {
                return;
            }
            for (int i = 0; i < 300; ++i) {
                Thread.sleep(100L);
                if (!names.contains("shell:if")) continue;
                return;
            }
            throw new TimeoutException("Command 'shell:if' not available");
        }

        public void destroy() {
        }

        protected boolean getBoolean(CommandSession session, String name) {
            Object s = session.get(name);
            if (s == null) {
                s = System.getProperty(name);
            }
            if (s == null) {
                return false;
            }
            if (s instanceof Boolean) {
                return (Boolean)s;
            }
            return Boolean.parseBoolean(s.toString());
        }
    }
}

