/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

abstract class BaseMethod {
    protected static final Class COMPONENT_CONTEXT_CLASS = ComponentContext.class;
    protected static final Class BUNDLE_CONTEXT_CLASS = BundleContext.class;
    protected static final Class SERVICE_REFERENCE_CLASS = ServiceReference.class;
    protected static final Class MAP_CLASS = Map.class;
    protected static final Class INTEGER_CLASS = Integer.class;
    private final boolean isDS11;
    private final boolean isDS12Felix;
    private final String m_methodName;
    private final Class m_componentClass;
    private volatile Method m_method;
    private final boolean m_methodRequired;
    private volatile State m_state;

    protected BaseMethod(String methodName, Class componentClass, boolean ds11, boolean ds12Felix) {
        this(methodName, methodName != null, componentClass, ds11, ds12Felix);
    }

    protected BaseMethod(String methodName, boolean methodRequired, Class componentClass, boolean ds11, boolean ds12Felix) {
        this.m_methodName = methodName;
        this.m_methodRequired = methodRequired;
        this.m_componentClass = componentClass;
        this.isDS11 = ds11;
        this.isDS12Felix = ds12Felix;
        this.m_state = this.m_methodName == null ? NotApplicable.INSTANCE : NotResolved.INSTANCE;
    }

    protected final boolean isDS11() {
        return this.isDS11;
    }

    protected final boolean isDS12Felix() {
        return this.isDS12Felix;
    }

    protected final String getMethodName() {
        return this.m_methodName;
    }

    protected final Method getMethod() {
        return this.m_method;
    }

    protected final Class getComponentClass() {
        return this.m_componentClass;
    }

    void setMethod(Method method, SimpleLogger logger) {
        this.m_method = method;
        if (method != null) {
            this.m_state = Resolved.INSTANCE;
            logger.log(4, "Found {0} method: {1}", new Object[]{this.getMethodNamePrefix(), method}, null);
        } else if (this.m_methodRequired) {
            this.m_state = NotFound.INSTANCE;
            logger.log(1, "{0} method [{1}] not found; Component will fail", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
        } else {
            logger.log(4, "{0} method [{1}] not found, ignoring", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
            this.m_state = NotApplicable.INSTANCE;
        }
    }

    State getState() {
        return this.m_state;
    }

    private Method findMethod(SimpleLogger logger) throws InvocationTargetException {
        boolean acceptPrivate = this.isDS11();
        boolean acceptPackage = this.isDS11();
        Class targetClass = this.getComponentClass();
        ClassLoader targetClasslLoader = targetClass.getClassLoader();
        String targetPackage = BaseMethod.getPackageName(targetClass);
        Class theClass = targetClass;
        while (true) {
            if (logger.isLogEnabled(4)) {
                logger.log(4, "Locating method " + this.getMethodName() + " in class " + theClass.getName(), null);
            }
            try {
                Method method = this.doFindMethod(theClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                logger.log(1, "findMethod: Suitable but non-accessible method {0} found in class {1}, subclass of {2}", new Object[]{this.getMethodName(), theClass.getName(), targetClass.getName()}, null);
                break;
            }
            theClass = theClass.getSuperclass();
            if (theClass == null) break;
            acceptPackage &= targetClasslLoader == theClass.getClassLoader() && targetPackage.equals(BaseMethod.getPackageName(theClass));
            acceptPrivate = false;
        }
        return null;
    }

    protected abstract Method doFindMethod(Class var1, boolean var2, boolean var3, SimpleLogger var4) throws SuitableMethodNotAccessibleException, InvocationTargetException;

    private MethodResult invokeMethod(Object componentInstance, Object rawParameter, SimpleLogger logger) throws InvocationTargetException {
        logger.log(4, "invoking {0}: {1}", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
        try {
            if (componentInstance != null) {
                Object[] params = this.getParameters(this.m_method, rawParameter);
                Object result = this.m_method.invoke(componentInstance, params);
                logger.log(4, "invoked {0}: {1}: parameters {2}", new Object[]{this.getMethodNamePrefix(), this.getMethodName(), Arrays.asList(params)}, null);
                return new MethodResult(this.m_method.getReturnType() != Void.TYPE, (Map)result);
            }
            logger.log(2, "Method {0} cannot be called on null object", new Object[]{this.getMethodName()}, null);
        }
        catch (IllegalStateException ise) {
            logger.log(4, ise.getMessage(), null);
            return null;
        }
        catch (IllegalAccessException ex) {
            logger.log(4, "Method {0} cannot be called", new Object[]{this.getMethodName()}, ex);
        }
        catch (InvocationTargetException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
        return MethodResult.VOID;
    }

    protected boolean returnValue() {
        return this.isDS12Felix();
    }

    protected abstract Object[] getParameters(Method var1, Object var2);

    protected String getMethodNamePrefix() {
        return "";
    }

    public Method getMethod(Class clazz, String name, Class[] parameterTypes, boolean acceptPrivate, boolean acceptPackage, SimpleLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            if (BaseMethod.accept(method, acceptPrivate, acceptPackage, this.returnValue())) {
                return method;
            }
            throw new SuitableMethodNotAccessibleException();
        }
        catch (NoSuchMethodException nsme) {
            if (logger.isLogEnabled(4)) {
                String argList = parameterTypes != null ? Arrays.asList(parameterTypes).toString() : "";
                logger.log(4, "Declared Method {0}.{1}({2}) not found", new Object[]{clazz.getName(), name, argList}, null);
            }
        }
        catch (NoClassDefFoundError cdfe) {
            if (logger.isLogEnabled(2)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Failure loooking up method ").append(name).append('(');
                for (int i = 0; parameterTypes != null && i < parameterTypes.length; ++i) {
                    buf.append(parameterTypes[i].getName());
                    if (i <= 0) continue;
                    buf.append(", ");
                }
                buf.append(") in class class ").append(clazz.getName()).append(". Assuming no such method.");
                logger.log(2, buf.toString(), cdfe);
            }
        }
        catch (SuitableMethodNotAccessibleException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable, "Unexpected problem trying to get method " + name);
        }
        return null;
    }

    static boolean accept(Method method, boolean acceptPrivate, boolean acceptPackage, boolean allowReturnValue) {
        if (!(Void.TYPE == method.getReturnType() || MAP_CLASS == method.getReturnType() && allowReturnValue)) {
            return false;
        }
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
            BaseMethod.setAccessible(method);
            return true;
        }
        if (Modifier.isPrivate(mod)) {
            if (acceptPrivate) {
                BaseMethod.setAccessible(method);
                return true;
            }
            return false;
        }
        if (acceptPackage) {
            BaseMethod.setAccessible(method);
            return true;
        }
        return false;
    }

    private static void setAccessible(final Method method) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
    }

    public static String getPackageName(Class clazz) {
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        return dot > 0 ? name.substring(0, dot) : "";
    }

    public MethodResult invoke(Object componentInstance, Object rawParameter, MethodResult methodCallFailureResult, SimpleLogger logger) {
        try {
            return this.m_state.invoke(this, componentInstance, rawParameter, logger);
        }
        catch (InvocationTargetException ite) {
            logger.log(1, "The {0} method has thrown an exception", new Object[]{this.getMethodName()}, ite.getCause());
            return methodCallFailureResult;
        }
    }

    public boolean methodExists(SimpleLogger logger) {
        return this.m_state.methodExists(this, logger);
    }

    private static class Resolved
    implements State {
        private static final State INSTANCE = new Resolved();

        private Resolved() {
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter, SimpleLogger logger) throws InvocationTargetException {
            return baseMethod.invokeMethod(componentInstance, rawParameter, logger);
        }

        public boolean methodExists(BaseMethod baseMethod, SimpleLogger logger) {
            return true;
        }
    }

    private static class NotFound
    implements State {
        private static final State INSTANCE = new NotFound();

        private NotFound() {
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter, SimpleLogger logger) {
            logger.log(1, "{0} method [{1}] not found", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            return null;
        }

        public boolean methodExists(BaseMethod baseMethod, SimpleLogger logger) {
            return false;
        }
    }

    private static class NotResolved
    implements State {
        private static final State INSTANCE = new NotResolved();

        private NotResolved() {
        }

        private synchronized void resolve(BaseMethod baseMethod, SimpleLogger logger) {
            logger.log(4, "getting {0}: {1}", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            Method method = null;
            try {
                method = baseMethod.findMethod(logger);
            }
            catch (InvocationTargetException ex) {
                logger.log(2, "{0} cannot be found", new Object[]{baseMethod.getMethodName()}, ex.getTargetException());
            }
            baseMethod.setMethod(method, logger);
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter, SimpleLogger logger) throws InvocationTargetException {
            this.resolve(baseMethod, logger);
            return baseMethod.getState().invoke(baseMethod, componentInstance, rawParameter, logger);
        }

        public boolean methodExists(BaseMethod baseMethod, SimpleLogger logger) {
            this.resolve(baseMethod, logger);
            return baseMethod.getState().methodExists(baseMethod, logger);
        }
    }

    private static class NotApplicable
    implements State {
        private static final State INSTANCE = new NotApplicable();

        private NotApplicable() {
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter, SimpleLogger logger) {
            return MethodResult.VOID;
        }

        public boolean methodExists(BaseMethod baseMethod, SimpleLogger logger) {
            return true;
        }
    }

    private static interface State {
        public MethodResult invoke(BaseMethod var1, Object var2, Object var3, SimpleLogger var4) throws InvocationTargetException;

        public boolean methodExists(BaseMethod var1, SimpleLogger var2);
    }
}

