/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.TargetedPID;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.manager.SingleComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationComponentFactoryImpl<S>
extends ComponentFactoryImpl<S> {
    private final Map<String, SingleComponentManager<S>> m_configuredServices = new HashMap<String, SingleComponentManager<S>>();

    public ConfigurationComponentFactoryImpl(BundleComponentActivator activator, ComponentMetadata metadata) {
        super(activator, metadata);
    }

    @Override
    public Dictionary<String, Object> getServiceProperties() {
        Dictionary<String, Object> props = super.getServiceProperties();
        props.put("service.pid", this.getComponentMetadata().getConfigurationPid());
        props.put("service.description", "Configurable (nonstandard) Factory Component " + this.getComponentMetadata().getName());
        return props;
    }

    @Override
    boolean getServiceInternal() {
        ArrayList cms = new ArrayList();
        this.getComponentManagers(this.m_configuredServices, cms);
        Iterator i = cms.iterator();
        while (i.hasNext()) {
            ((AbstractComponentManager)i.next()).enable(false);
        }
        this.m_activated = true;
        return true;
    }

    @Override
    protected void deleteComponent(int reason) {
        ArrayList cms = new ArrayList();
        this.getComponentManagers(this.m_configuredServices, cms);
        for (AbstractComponentManager abstractComponentManager : cms) {
            abstractComponentManager.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationDeleted(String pid) {
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            super.configurationDeleted(pid);
        } else {
            SingleComponentManager<S> cm;
            Map<String, SingleComponentManager<S>> map = this.m_configuredServices;
            synchronized (map) {
                cm = this.m_configuredServices.remove(pid);
            }
            if (cm != null) {
                this.log(4, "Disposing component after configuration deletion", null);
                cm.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean configurationUpdated(String pid, Dictionary<String, Object> configuration, long changeCount, TargetedPID targetedPid) {
        SingleComponentManager<S> cm;
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            return super.configurationUpdated(pid, configuration, changeCount, targetedPid);
        }
        Map<String, SingleComponentManager<S>> map = this.m_configuredServices;
        synchronized (map) {
            cm = this.m_configuredServices.get(pid);
        }
        if (cm == null) {
            cm = this.createConfigurationComponentManager();
            cm.reconfigure(configuration, changeCount, this.m_targetedPID);
            if (this.getState() == 64) {
                cm.enable(false);
            }
            map = this.m_configuredServices;
            synchronized (map) {
                this.m_configuredServices.put(pid, cm);
            }
            return true;
        }
        cm.reconfigure(configuration, changeCount, this.m_targetedPID);
        return false;
    }

    @Override
    public Component[] getComponents() {
        List cms = this.getComponentList();
        this.getComponentManagers(this.m_configuredServices, cms);
        return cms.toArray(new Component[cms.size()]);
    }

    @Override
    public void disposeComponents(int reason) {
        super.disposeComponents(reason);
        ArrayList cms = new ArrayList();
        this.getComponentManagers(this.m_configuredServices, cms);
        for (AbstractComponentManager abstractComponentManager : cms) {
            abstractComponentManager.dispose(reason);
        }
        this.m_configuredServices.clear();
        this.dispose(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getChangeCount(String pid) {
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            return this.m_changeCount;
        }
        Map<String, SingleComponentManager<S>> map = this.m_configuredServices;
        synchronized (map) {
            SingleComponentManager<S> icm = this.m_configuredServices.get(pid);
            return icm == null ? -1L : icm.getChangeCount();
        }
    }

    private SingleComponentManager<S> createConfigurationComponentManager() {
        return new ComponentFactoryConfiguredInstance(this.getActivator(), this, this.getComponentMetadata(), this.getComponentMethods());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComponentFactoryConfiguredInstance<S>
    extends SingleComponentManager<S> {
        public ComponentFactoryConfiguredInstance(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
            super(activator, componentHolder, metadata, componentMethods, true);
        }

        @Override
        public boolean isImmediate() {
            return true;
        }
    }
}

